% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-log-likelihood.R
\name{utils_log_likelihood}
\alias{utils_log_likelihood}
\title{Log-Likelihood Functions for Probability Models}
\usage{
utils_log_likelihood(
  data,
  distribution,
  params,
  ns_years = NULL,
  ns_structure = NULL
)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{distribution}{A three-character code indicating the distribution family.
Must be \code{"GUM"}, \code{"NOR"}, \code{"LNO"}, \code{"GEV"}, \code{"GLO"}, \code{"GNO"}, \code{"PE3"}, \code{"LP3"},
or \code{"WEI"}.}

\item{params}{Numeric vector of distribution parameters, in the order (location,
scale, shape). The length must be between 2 and 5, depending on the specified
\code{distribution} and \code{structure}.}

\item{ns_years}{For NS-FFA only: Numeric vector of observation years corresponding
to \code{data}. Must be the same length as \code{data} and strictly increasing.}

\item{ns_structure}{For NS-FFA only: Named list indicating which distribution
parameters are modeled as nonstationary. Must contain two logical scalars:
\itemize{
\item \code{location}: If \code{TRUE}, the location parameter has a linear temporal trend.
\item \code{scale}: If \code{TRUE}, the scale parameter has a linear temporal trend.
}}
}
\value{
Numeric scalar. The log-likelihood value.
}
\description{
Compute the log-likelihood for stationary and nonstationary probability models.

\strong{For NS-FFA}: To compute the log-likelihood for a nonstationary probability model,
include the observation years (\code{ns_years}) and the nonstationary model structure
(\code{ns_structure}).
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
params <- c(100, 1, 10)
ns_years <- seq(from = 1901, to = 2000)
ns_structure <- list(location = TRUE, scale = FALSE)

# Compute the log-likelihood
utils_log_likelihood(data, "NOR", params, ns_years, ns_structure)

}
\seealso{
\code{\link[=utils_generalized_likelihood]{utils_generalized_likelihood()}}
}
