% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperop.R
\name{hyperop}
\alias{hyperop}
\title{Hyperopic eye data}
\usage{
hyperop(x, cols, eye = NULL)
}
\arguments{
\item{x}{data frame}

\item{cols}{columns which should be made "wide". Tidyselection supported}

\item{eye}{eye column (default looking for "eye" or "eyes", all cases)}
}
\value{
A tibble, see also \link[tibble:tibble]{tibble::tibble}
}
\description{
Pivot eye-related variables to two columns
}
\details{
Basically the opposite of \code{\link[=myop]{myop()}} - a slightly intelligent
wrapper around \code{\link[tidyr:pivot_longer]{tidyr::pivot_longer()}} and \code{\link[tidyr:pivot_wider]{tidyr::pivot_wider()}}
Will find the eye column, unify the codes for the eyes (all to "r" and "l")
and pivot the columns wide, that have been specified in "cols".

\strong{Good names and tidy data always help!}

For more information about shaping data and good names, see \code{vignette("eye")},
or \code{?blink} or \code{?myop}
}
\examples{
# Example to clean a bit messy data frame

iopva <- data.frame(
  id = c("a", "e", "j", "h"),
  va_r = c(37L, 36L, 33L, 38L),
  iop_r = c(38L, 40L, 33L, 34L),
  va_l = c(30L, 39L, 37L, 40L),
  iop_l = c(31L, 34L, 33L, 31L)
)
myop_iop <- myop(iopva)
hyperop(myop_iop, cols = matches("va|iop"))


}
\seealso{
\href{https://tidyselect.r-lib.org/reference/language.html}{About tidyselection}
}
