% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore.R
\name{explore_cor}
\alias{explore_cor}
\title{Explore the correlation between two variables}
\usage{
explore_cor(
  data,
  x,
  y,
  target,
  bins = 8,
  min_val = NA,
  max_val = NA,
  auto_scale = TRUE,
  title = NA,
  color = c("#ADD8E6", "#7BB8DA"),
  ...
)
}
\arguments{
\item{data}{A dataset}

\item{x}{Variable on x axis}

\item{y}{Variable on y axis}

\item{target}{Target variable (categorical)}

\item{bins}{Number of bins}

\item{min_val}{All values < min_val are converted to min_val}

\item{max_val}{All values > max_val are converted to max_val}

\item{auto_scale}{Use 0.2 and 0.98 quantile for min_val and max_val (if min_val and max_val are not defined)}

\item{title}{Title of the plot}

\item{color}{Color of the plot}

\item{...}{Further arguments}
}
\value{
Plot
}
\description{
Explore the correlation between two variables
}
\examples{
explore_cor(iris, x = Sepal.Length, y = Sepal.Width)
}
