% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterize.R
\name{rasterize_polygons}
\alias{rasterize_polygons}
\alias{rasterize_polygons,sf,RasterLayer-method}
\alias{rasterize_polygons,sf,SpatRaster-method}
\title{Create a raster approximation of a polygon coverage}
\usage{
\S4method{rasterize_polygons}{sf,RasterLayer}(x, y, min_coverage = 0)

\S4method{rasterize_polygons}{sf,SpatRaster}(x, y, min_coverage = 0)
}
\arguments{
\item{x}{a \code{sf} or \code{sfc} object with polygonal geometries}

\item{y}{a (possibly empty) \code{RasterLayer} whose resolution and
extent will be used for the generated \code{RasterLayer}.}

\item{min_coverage}{minimum fraction of a cell that must be covered by
polygons to be included in the output}
}
\value{
a \code{RasterLayer} or \code{SpatRaster}, consistent with the type of \code{y}
}
\description{
Returns a raster whose values indicate the index of the polygon covering
each cell. Where multiple polygons cover the same cell, the index of the
polygon covering the greatest area will be used, with the lowest index
returned in the case of ties. Cells that are not covered by any polygon,
or whose total covered fraction is less than \code{min_coverage}, will be
set to \code{NA}.
}
