% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/try_rescue_dose.R
\name{try_rescue_dose}
\alias{try_rescue_dose}
\title{Demand that a rescue dose is tried before stopping is permitted.}
\usage{
try_rescue_dose(parent_selector_factory, n, dose)
}
\arguments{
\item{parent_selector_factory}{Object of type \code{\link{selector_factory}}.}

\item{n}{Continue at least until there are n at a dose.}

\item{dose}{index of rescue dose-level to try in extremis.}
}
\value{
an object of type \code{\link{selector_factory}} that can fit a
dose-finding model to outcomes.
}
\description{
This method continues a dose-finding trial until a safety dose has been given
to n patients. Once that condition is met, it delegates dose selelcting and
stopping responsibility to its parent dose selector, whatever that might be.
This class is greedy in that it meets its own needs before asking any other
selectors higher in the chain what they want. Thus, different behaviours may
be achieved by nesting dose selectors in different orders. See examples.
}
\examples{
skeleton <- c(0.05, 0.1, 0.25, 0.4, 0.6)
target <- 0.25

# This model will demand the lowest dose is tried in at least two patients
# before the trial is stopped for excess toxicity
model1 <- get_dfcrm(skeleton = skeleton, target = target) \%>\%
  stop_when_too_toxic(dose = 1, tox_threshold = 0.35, confidence = 0.8) \%>\%
  try_rescue_dose(dose = 1, n = 2)

# In contrast, this model will stop for excess toxicity without trying dose 1
model2 <- get_dfcrm(skeleton = skeleton, target = target) \%>\%
  stop_when_too_toxic(dose = 1, tox_threshold = 0.35, confidence = 0.8)

# For non-toxic outcomes, both designs will continue at sensible doses:
fit1 <- model1 \%>\% fit('2NNN')
fit1 \%>\% recommended_dose()
fit1 \%>\% continue()

fit2 <- model2 \%>\% fit('2NNN')
fit2 \%>\% recommended_dose()
fit2 \%>\% continue()

# For toxic outcomes, the design 1 will use dose 1 before stopping is allowed
fit1 <- model1 \%>\% fit('2TTT')
fit1 \%>\% recommended_dose()
fit1 \%>\% continue()

# For toxic outcomes, however, design 2 will stop despite dose 1 being
# untested:
fit2 <- model2 \%>\% fit('2TTT')
fit2 \%>\% recommended_dose()
fit2 \%>\% continue()

# After dose 1 is given the requisite number of times, dose recommendation
# and stopping revert to being determined by the underlying dose selector:
fit1 <- model1 \%>\% fit('2TTT 1T')
fit1 \%>\% recommended_dose()
fit1 \%>\% continue()

fit1 <- model1 \%>\% fit('2TTT 1TT')
fit1 \%>\% recommended_dose()
fit1 \%>\% continue()
}
