% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-rd.R, R/filter.R
\name{filter.duckplyr_df}
\alias{filter.duckplyr_df}
\title{Keep rows that match a condition}
\usage{
\method{filter}{duckplyr_df}(.data, ..., .by = NULL, .preserve = FALSE)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Expressions that
return a logical value, and are defined in terms of the variables in
\code{.data}. If multiple expressions are included, they are combined with the
\code{&} operator. Only rows for which all conditions evaluate to \code{TRUE} are
kept.}

\item{.by}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[dplyr:group_by]{group_by()}}. For
details and examples, see \link[dplyr:dplyr_by]{?dplyr_by}.}

\item{.preserve}{Relevant when the \code{.data} input is grouped.
If \code{.preserve = FALSE} (the default), the grouping structure
is recalculated based on the resulting data, otherwise the grouping is kept as is.}
}
\description{
This is a method for the \code{\link[dplyr:filter]{dplyr::filter()}} generic.
See "Fallbacks" section for differences in implementation.
The \code{filter()} function is used to subset a data frame,
retaining all rows that satisfy your conditions.
To be retained, the row must produce a value of \code{TRUE} for all conditions.
Note that when a condition evaluates to \code{NA} the row will be dropped,
unlike base subsetting with \code{[}.
}
\section{Fallbacks}{

There is no DuckDB translation in \code{filter.duckplyr_df()}
\itemize{
\item with no filter conditions,
\item nor for a grouped operation (if \code{.by} is set).
}

These features fall back to \code{\link[dplyr:filter]{dplyr::filter()}}, see \code{vignette("fallback")} for details.
}

\examples{
df <- duckdb_tibble(x = 1:3, y = 3:1)
filter(df, x >= 2)
}
\seealso{
\code{\link[dplyr:filter]{dplyr::filter()}}
}
