% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/munsell2rgb.R
\name{rgb2munsell}
\alias{rgb2munsell}
\title{sRGB to Munsell Color Conversion}
\usage{
rgb2munsell(color, colorSpace = c("CIE2000", "LAB", "sRGB"), nClosest = 1)
}
\arguments{
\item{color}{a \code{data.frame} or \code{matrix} object containing sRGB coordinates in the range of (0,1)}

\item{colorSpace}{distance metric (colorspace) to use for finding the closest chip: CIE2000 is the most accurate but requires farver >= 2.0.3, Euclidean distance in CIELAB is a close second, while Euclidean distance in sRGB is not at all accurate and should only be used for demonstration purposes.}

\item{nClosest}{number of closest Munsell colors to return (valid range is 1-20)}
}
\value{
an (NA-padded) \code{data.frame} containing \code{hue}, \code{value}, \code{chroma}, and distance (dE00 when \code{colorSpace = 'CIE2000'}, Euclidean distance otherwise) to nearest matching color.
}
\description{
Convert sRGB color coordinates to the closest \code{n} Munsell chips in the \code{munsell} lookup table. This function will be replaced by \code{col2Munsell()} in \strong{aqp 2.1}.
}
\note{
This function is fully vectorized and will pad output with NA-records when NA are present in \code{color}.
}
\examples{

# keep examples from using more than 2 cores
data.table::setDTthreads(Sys.getenv("OMP_THREAD_LIMIT", unset = 2))

# Munsell notation to sRGB triplets [0-1] 
color <- munsell2rgb(
  the_hue = c('10YR', '2.5YR', '5YR'), 
  the_value = c(3, 5, 2.5), 
  the_chroma = c(5, 6, 2), 
  return_triplets = TRUE
)

# result is a data.frame
color

# back-transform sRGB -> closest Munsell color
# sigma is the dE00 color contrast metric
rgb2munsell(color)

}
\references{
\itemize{
\item http://ncss-tech.github.io/AQP/
\item http://www.brucelindbloom.com/index.html?ColorCalcHelp.html
\item http://www.munsellcolourscienceforpainters.com/MunsellAndKubelkaMunkToolbox/MunsellAndKubelkaMunkToolbox.html
\item http://www.cis.rit.edu/mcsl/online/munsell.php
}
}
\author{
D.E. Beaudette
}
