% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilProfileCollection-metadata.R
\docType{methods}
\name{hzdesgnname}
\alias{hzdesgnname}
\alias{hzdesgnname,SoilProfileCollection-method}
\alias{hzdesgnname<-}
\alias{hzdesgnname<-,SoilProfileCollection-method}
\title{Get or Set Horizon Designation Column Name}
\usage{
\S4method{hzdesgnname}{SoilProfileCollection}(object, required = FALSE)

\S4method{hzdesgnname}{SoilProfileCollection}(object, required = FALSE) <- value
}
\arguments{
\item{object}{a SoilProfileCollection}

\item{required}{logical, is this attribute required? If it is, set to \code{TRUE} to trigger error on invalid \code{value}.}

\item{value}{character, name of column containing horizon designations}
}
\description{
\code{hzdesgnname()}: Get column name containing horizon designations

\verb{hzdesgnname<-}: Set horizon designation column name
}
\details{
Store the column name containing horizon designations or other identifiers in the metadata slot of the SoilProfileCollection.
}
\examples{

data(sp1)

# promote to SPC
depths(sp1) <- id ~ top + bottom

# set horizon designation column
hzdesgnname(sp1) <- "name"

# get horizon designation column
hzdesgnname(sp1)
}
\seealso{
\code{\link[=hzDesgn]{hzDesgn()}}
}
