% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.R
\name{build_random_forest}
\alias{build_random_forest}
\title{Fit an SFHNV random forest}
\usage{
build_random_forest(
  data,
  honest_ratio = 1,
  min_size = 50,
  max_depth = 50,
  num_trees = 100,
  feature_choose = "sqrt",
  parallel = TRUE,
  approximate = FALSE,
  max_candidates = 256,
  leaf_round_digits = 1L
)
}
\arguments{
\item{data}{A data frame or output from \code{\link[=NW_prepare]{NW_prepare()}}.}

\item{honest_ratio}{Ratio of the estimation subsample to the splitting subsample.}

\item{min_size}{Minimum number of observations in each child node.}

\item{max_depth}{Maximum depth of each tree.}

\item{num_trees}{Number of trees to build.}

\item{feature_choose}{Strategy for selecting features at each split. One of
\code{"sqrt"}, \code{"log2"}, \code{"third"}, or \code{"all"}.}

\item{parallel}{Logical; if \code{TRUE} and \code{future.apply} is available, build trees in parallel.}

\item{approximate}{Logical; if \code{TRUE}, limit candidate split points for speed.}

\item{max_candidates}{Maximum candidate split points per feature when \code{approximate = TRUE}.}

\item{leaf_round_digits}{Rounding control for demand samples in leaf CDF estimation.}
}
\value{
A list of SFHNV trees.
}
\description{
Fit an SFHNV random forest
}
\examples{
data <- data.frame(x1 = rnorm(200), x2 = rnorm(200), D = rnorm(200), Q = rnorm(200))
forest <- build_random_forest(data, num_trees = 5, min_size = 20)
}
