% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class_definitions.R
\docType{class}
\name{OM-class}
\alias{OM-class}
\title{Class \code{'OM'}}
\description{
An object containing all the parameters needed to control the MSE which can
be build from component Stock, Fleet, Obs, and Imp objects.
}
\details{
Almost all of these inputs are a vector of length 2 which describes the upper and lower
bounds of a uniform distribution from which to sample the parameter.
}
\section{Slots}{

\describe{
\item{\code{Name}}{Name of the operating model}

\item{\code{Agency}}{Name of the agency responsible for the management of the fishery. Character string}

\item{\code{Region}}{Name of the general geographic region of the fishery. Character string}

\item{\code{Sponsor}}{Name of the organization who sponsored the OM. Character string}

\item{\code{Latitude}}{Latitude (decimal degrees). Negative values represent the South of the Equator. Numeric. Single value}

\item{\code{Longitude}}{Longitude (decimal degrees). Negative values represent the West of the Prime Meridian. Numeric. Single value}

\item{\code{nsim}}{The number of simulations}

\item{\code{proyears}}{The number of projected years}

\item{\code{interval}}{The assessment interval - how often would you like to update the management system?}

\item{\code{pstar}}{The percentile of the sample of the management recommendation for each method}

\item{\code{maxF}}{Maximum instantaneous fishing mortality rate that may be simulated for any given age class}

\item{\code{reps}}{Number of samples of the management recommendation for each method. Note that when this is set to 1, the mean value of
the data inputs is used.}

\item{\code{cpars}}{A list of custom parameters. Time series are a matrix nsim rows by nyears columns. Single parameters are a vector nsim long. See \code{\link[=validcpars]{validcpars()}}}

\item{\code{seed}}{A random seed to ensure users can reproduce results exactly}

\item{\code{Source}}{A reference to a website or article from which parameters were taken to define the operating model}
}}

\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new('OM', Stock, Fleet, Obs, Imp)}.
}

\author{
T. Carruthers and A. Hordyk
}
\keyword{classes}
