/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.ContentHeader;
import com.rabbitmq.client.impl.ContentHeaderPropertyReader;
import com.rabbitmq.client.impl.ContentHeaderPropertyWriter;
import com.rabbitmq.client.impl.Frame;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class AMQContentHeader
implements ContentHeader {
    public long readFrom(DataInputStream in) throws IOException {
        short weight = in.readShort();
        long bodySize = in.readLong();
        this.readPropertiesFrom(new ContentHeaderPropertyReader(in));
        return bodySize;
    }

    public void writeTo(DataOutputStream out, long bodySize) throws IOException {
        out.writeShort(0);
        out.writeLong(bodySize);
        this.writePropertiesTo(new ContentHeaderPropertyWriter(out));
    }

    public abstract void readPropertiesFrom(ContentHeaderPropertyReader var1) throws IOException;

    public abstract void writePropertiesTo(ContentHeaderPropertyWriter var1) throws IOException;

    public void appendPropertyDebugStringTo(StringBuffer acc) {
        acc.append("(?)");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("#contentHeader<").append(this.getClassName()).append(">");
        this.appendPropertyDebugStringTo(sb);
        return sb.toString();
    }

    public Frame toFrame(int channelNumber, long bodySize) throws IOException {
        Frame frame = new Frame(2, channelNumber);
        DataOutputStream bodyOut = frame.getOutputStream();
        bodyOut.writeShort(this.getClassId());
        this.writeTo(bodyOut, bodySize);
        return frame;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

