/////////////////////////////////////////////////////
// DESCRIPT, a STR-ing used as a descriptor:
//  <type>['|'<param>=<value>]
/////////////////////////////////////////////////////
#if !defined(DESCRIPT_HPP)
#define DESCRIPT_HPP
#if !defined(RC_INVOKED)	// real C++ stuff
#include "STR.HPP"
class DESCRIPT : public STR {
public:
	DESCRIPT(const char szS[] = 0);
	virtual ~DESCRIPT();

	const char* type(STR& Buf) const;
	const char* value(const char szParam[], STR& Buf)
								const;
	int value(const char szParam[], int nDefVal = 0)
								const;

	void setType(const char szType[]);
	void addParam(const char szParam[],
					const char szValue[]);
	void addParam(const char szParam[], int nValue);

private:
	short isSep(int c, int k) const;
	const char* retVal(STR& Buf) const;
	enum { SLASH = '|', EQUAL = '=' , LIT = '\\'};
};

class MULTIPARAM {
public:
	MULTIPARAM(const DESCRIPT* Desc,
				const char szMP[]);
	~MULTIPARAM() {};
	int no() const { return _n; }
	const char* value(int index, STR& Buf);
	int value(int index, int nDefVal = 0);

private:
	const DESCRIPT* const _desc;
	const STR _mp;
	int _n;
	STR _full;
	const char *_makeParam(int index);
	};
#endif
#endif
