Listing2

//////////////////////////////////////////////////////
// ASSOCMEM, an abstract data bank
//////////////////////////////////////////////////////
#if !defined(ASSOCMEM_HPP)
#define ASSOCMEM_HPP
#if !defined(RC_INVOKED)    // no Windows RC compiler
#include "STR.HPP"
class ASSOCMEM {
public:
    ASSOCMEM() {}
    virtual ~ASSOCMEM() {}
// get/set for strings:
    virtual const char* get(const char szSym[],
                            STR& Val) const = 0;
        // returns Val, unchanged if szSym not found
    virtual void set(const char szSym[],
                    const char szValue[])= 0;
// get/set for integers:
    virtual int get(const char szSym[],
                    int nDefault = 0) const = 0;
    virtual void set(const char szSym[], int nVal)= 0;

private:
    ASSOCMEM(const ASSOCMEM&);
    ASSOCMEM& operator=(const ASSOCMEM&);
};
#endif
#endif

//////////////////////////////////////////////////////
// SHOWDATA, an ASSOCMEM with a face
//////////////////////////////////////////////////////
#if !defined(SHOWDATA_HPP)
#define SHOWDATA_HPP
#if !defined(RC_INVOKED)    // no Windows RC compiler
#include "ASSOCMEM.HPP"
#include <windows.h>
class MODALDLG;
class SHOWDATA : public ASSOCMEM {
public:
    enum RET { OK, CANCEL,
                MEMORYOUT, INTERNALERR,
                DESCNOTFOUND, SYNTAXERR };
    SHOWDATA(const char szStoreFile[],
            const char szStoreSect[] = 0
            );
    virtual ~SHOWDATA();
// store / retrieve, ASSOCMEM overloads:
    virtual const char* get(const char szSym[],
                            STR& Val) const;
    virtual void set(const char szSym[],
                    const char szValue[]);
    virtual int get(const char szSym[],
                    int nDefault = 0) const;
    virtual void set(const char szSym[], int nVal);
// MS-Windows presentation layer:
    RET modalDlg(HWND hWndParent, HINSTANCE hInst,
            const char szDescrFile[],
            const char szDescrSect[],
            const char szResourceType[] = 0);

private:
    const STR _name, _sect;
    MODALDLG *_dlg;

    SHOWDATA();
    SHOWDATA(const SHOWDATA&);
    SHOWDATA& operator=(const SHOWDATA&);
};
#endif
#endif
