#ifndef _AS_ARGS_H
#define _AS_ARGS_H

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#define ARG_ERROR      -1
#define ARG_NOINIT     -2
#define ARG_NOTENOUGH  -3
#define ARG_NODELIM    -4
#define ARG_INVTYPE    -5
#define ARG_INVDATE    -6
#define ARG_NOTFOUND   -7
#define ARG_USAGE      -8
#define ARG_NOARGS     -9

#define ARG_OK          0

#define ARG_SWITCH      1
#define ARG_STRING      2
#define ARG_CHAR        3
#define ARG_INT         4
#define ARG_LONG        5
#define ARG_FLOAT       6
#define ARG_DOUBLE      7
#define ARG_DATE        8

typedef struct _FILE_ {
    char disk[81];
    char dir[81];
    char name[21];
    char ext[11];
} FILE_t, *FILE_p;

extern char *ArgCheck( void );
extern char *ArgErr( void );
extern int   ArgGet( char *key, int type, ... );
extern int   ArgInit( int argc, char *argv[], int mandatory );
extern int   ArgInitPrgm( int argc, char *argv[], int mandatory, FILE_p file );
extern void  SplitFile( char *name, FILE_p file );

#endif                                      /* ifndef _AS_ARGS_H             */

