LISTING 8 - Shows how to register a signal handler

/* ignore.c:   Ignores interactive attention key */
#include <stdio.h>
#include <signal.h>

main()
{
    char buf[BUFSIZ];
    int i;

    /* Ignore keyboard interruptions */
    signal(SIGINT,SIG_IGN);

    while (gets(buf))
        puts(buf);

    /* Restore default attention key handling
       so the user can abort form the keyboard */
    signal(SIGINT,SIG_DFL);
    for (i = 1; ; ++i)
        printf("%d%c",i,(i%15 ? ' ' : '\n'));
}

/* Sample Execution 
c:>ignore
hello
hello
^C
there
there
^C
^Z
1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
16 17 18 19 20 21 22 23 24 25 26 27 28 29 30
31 32 33 34 35 36 37 38 39 40 41 42 43 44 45
46 47 48 49 50 51 52 53 54 55 56 57 58 59 60
61 62 63 64 65 66 67 ^C
*/
