; BCDOPS.ASM - Add, subtract, and negate BCD numbers
; Prototypes: void BCDAdd(BCD num1, BCD num2, BCD* sum)
;             void BCDSub(BCD num1, BCD num2, BCD* diff)
;             void BCDNeg(BCD num1, BCD* opp)
; To assemble:  TASM /zi /ml bcdops
; Copyright 1994 - Mark R. Parker
        masm
        .MODEL  small, C
        .CODE
        PUBLIC  BCDAdd, BCDSub, BCDNeg
BCDAdd  PROC    NEAR
        ARG     Add1: WORD, Add2: WORD, Sum: WORD
        USES    di, si
        mov     si, WORD PTR[Add1]
        finit
        fbld    TBYTE PTR [si]      ; Load 1st BCD num
        mov     si, WORD PTR[Add2]  
        fbld    TBYTE PTR [si]      ; Load 2nd BCD num
        fadd                        ; Add them, pop st
        mov     di, WORD PTR[Sum]   ; Put addr. of Sum
        mov     si, [di]            ;   into SI
        fbstp   TBYTE PTR [si]      ; Store Sum where
        ret                         ;   SI points
BCDAdd  ENDP

BCDSub PROC     NEAR
        ARG     Sub1: WORD, Sub2: WORD, Diff: WORD
        USES    di, si
        mov     si, WORD PTR[Sub1]
        finit                                         
        fbld    TBYTE PTR [si]      ; Load Sub1
        mov     si, WORD PTR[Sub2]
        fbld    TBYTE PTR [si]      ; Load Sub2
        fsub                        ; Sub1-Sub2 at TOS
        mov     di, WORD PTR[Diff]  ; Put addr. of Diff
        mov     si, [di]            ;   into SI
        fbstp   TBYTE PTR [si]      ; Store Diff where
        ret                         ;   SI points
BCDSub  ENDP

BCDNeg  PROC    NEAR
        ARG     Num: WORD, Opp: WORD
        USES    di, si
        finit
        mov     si, WORD PTR[Num]                     
        fbld    TBYTE PTR [si]      ; Load Num
        fchs                        ; Change its sign
        mov     di, WORD PTR[Opp]   ; Put addr. of Opp
        mov     si, [di]            ;   into SI
        fbstp   TBYTE PTR [si]      ; Store Opp where
        ret                         ;   SI points
BCDNeg  ENDP
        END



