#include <defcodes.h>
#define	MAX_STACK	32
static	int	StackIndex;
static	ULONG	Stack[MAX_STACK+1];

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

/* INDENT OFF */
static	void	Push F((ULONG));
static	void	ShowStack F((void));
static	int	StackEmpty F((void));
static	void	StackInit F((void));
static	ULONG	Pop F((void));

# undef F
/* INDENT ON */

/* ==================================================================== */
/* StackInit - initializes simulated stack-handler function		*/
/* ==================================================================== */
static	void
StackInit(void)
{
    StackIndex = 0;
}
/* ==================================================================== */
/* Push - pushes a value onto stack					*/
/* ==================================================================== */
static	void
Push(ULONG  Value)
{
    assert(StackIndex <= MAX_STACK);
    Stack[StackIndex] = Value;
    ++StackIndex;
}
/* ==================================================================== */
/* Pop - pops a value from the stack and returns it to caller		*/
/* ==================================================================== */
static	ULONG
Pop(void)
{
    assert(StackIndex > 0);
    --StackIndex;
    return(Stack[StackIndex]);
}
# if SHOW_STACK
/* ==================================================================== */
/* ShowStack - prints stack depth (StackIndex) and contents of Stack	*/
/* ==================================================================== */
static	void
ShowStack(void)
{
    int     ShowIndex;

    AX(("Stack Depth = %d\n", StackIndex));
    for (ShowIndex = 0; ShowIndex < StackIndex; ++ShowIndex)
    {
	AX(("%5d  %5lu\n", ShowIndex, Stack[ShowIndex]));
    }
}
# endif
/* ==================================================================== */
/* StackEmpty - retruns TRUE if Stack is empty (StackIndex == 0)	*/
/* ==================================================================== */
static	int
StackEmpty(void)
{
    return (StackIndex == 0);
}
