/* ============ */
/* isort.c	*/
/* ============ */
#include <defcodes.h>
#include <assert.h>
/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define	F( P )	P
# else
#	define	F( P )	()
# endif
/* INDENT OFF */
static	void	Heapify F((size_t, size_t));
static	void	InsertionSort F((ULONG));
extern	void	isort F((void *, size_t, size_t,
			int (*)(const void *, const void *)));
# if SHOW_PARTITION
static	void	ShowPartition(int, ULONG, ULONG, ULONG);
# endif

static	void	Swap F((char *, char *));

static	int (*Cmpr) F((const void *, const void *));
# undef F

extern	long	SwapCtr;

static	size_t	DataWidth;
static	char	  *MyBase;
/* INDENT ON */

#define DATA(i) (*(int *)(MyBase + ADDR(i-1)))
#define ADDR(i) (ULONG)((ULONG)(i)*((ULONG)DataWidth))
#define CMPR(i, j) (*Cmpr)(MyBase + ADDR(i-1), MyBase + ADDR(j-1))
#define SWAP(i, j)   Swap (MyBase + ADDR(i-1), MyBase + ADDR(j-1))
/* ==================================================================== */
/* isort - sort a set of elements by Straight Insertion Sort		*/
/* ==================================================================== */
# if defined(__STDC__) || defined(__PROTO__)
void
isort(void *Base, size_t Num, size_t Width,
    int(*Compare) (const void *, const void *))
# else
void
isort(Base, Num, Width, Compare)
void   *Base;
size_t	Num;
size_t	Width;
int	(*Compare)();
# endif
{
    Cmpr = Compare;
    DataWidth = Width;
    MyBase = Base;

    InsertionSort((ULONG) Num);
}
/* ==================================================================== */
/* InsertionSort - executes the Straight Insertion Sort algorithm	*/
/* ==================================================================== */
# if defined(__STDC__) || defined(__PROTO__)
static void
InsertionSort(ULONG Num)
# else
static void
InsertionSort(Num)
ULONG	Num;
# endif
{
    ULONG   NextIdx, StartIdx;

    for (StartIdx = 2; StartIdx <= Num; ++StartIdx)
    {
	for (NextIdx = StartIdx; NextIdx > 1; --NextIdx)
	{
	    if (0 >= CMPR(NextIdx - 1, NextIdx))
	    {
		break;
	    }

	    SWAP(NextIdx - 1, NextIdx);
	}
    }
}
/* ==================================================================== */
/* Swap - exchanges two data elements each of DataWidth bytes		*/
/* ==================================================================== */
# if defined(__STDC__) || defined(__PROTO__)
PRIVATE	void
Swap(char  * Elem1, char  * Elem2)
# else
PRIVATE void
Swap(Elem1, Elem2)
char  *Elem1;
char  *Elem2;
# endif
# if !defined(MAX_SWAP)
#	define	MAX_SWAP	256
# endif
{
    extern long SwapCtr;
    extern size_t DataWidth;

    ++SwapCtr;

    /* ----------------------------- */
    /* Swap in Most Efficient Manner */
    /* ----------------------------- */
    switch (DataWidth)
    {
    case 1:
	{
	    char    OneXfer;
	    OneXfer = *Elem1;
	    *Elem1 = *Elem2;
	    *Elem2 = OneXfer;
	    break;
	}
    case 2:
	{
	    short   TwoXfer;
	    TwoXfer = *(short *) Elem1;
	    *(short *) Elem1 = *(short *) Elem2;
	    *(short *) Elem2 = TwoXfer;
	    break;
	}
    case 4:
	{
	    long    FourXfer;
	    FourXfer = *(long *) Elem1;
	    *(long *) Elem1 = *(long *) Elem2;
	    *(long *) Elem2 = FourXfer;
	    break;
	}
    default:
	{
	    char    TempBuf[MAX_SWAP];
	    size_t  CopySize, XferSize;

	    /* ---------------------------------- */
	    /* Copy as much as possible each pass */
	    /* ---------------------------------- */
	    for (XferSize = DataWidth; 0 < XferSize; XferSize -= CopySize)
	    {
		CopySize = (XferSize < sizeof(TempBuf)) ? XferSize :
		    sizeof(TempBuf);

		memcpy(TempBuf, Elem1, CopySize);
		memcpy(Elem1, Elem2, CopySize);
		memcpy(Elem2, TempBuf, CopySize);
		Elem1 += CopySize, Elem2 += CopySize;
	    }
	    break;
	}
    }
}
# if defined(TEST)
#include "tsrtdefs.h"
# if defined(SORT_NAME)
# else
#	define	SORT_NAME	isort
# endif
void
main(int argc, char **argv)
{
    SORT_TEST_STRU  SortParms;

    SortParms.argc	= argc;
    SortParms.argv	= argv;
    SortParms.SortFun	= SORT_NAME;
    SortParms.OKCodes	= (char *) NULL;
    SortParms.ExecName	= DQ(SORT_NAME);
    SortParms.ExecLabel = "Insertion Sort";

    tstsort(&SortParms);
}
# endif
