/////////////////////////////////////////////////////
//	STR.CPP	Null-Ended String Class Implementation
/////////////////////////////////////////////////////
#include "STR.HPP"
#include <ctype.h>

//////////////////////////////////////////////////////
// Constructors:
//////////////////////////////////////////////////////
STR::STR()
{
if(0 == (s = new char[1])){
	l = 0;
	s = 0;
	}
else{
	l = 1;
	s[0] = '\0';
	}
}

STR::STR(const STR &y)
{
if(0 == (s = new char[y.l])){
	l = 0;
	s = 0;
	}
else{
	l = y.l;
	strcpy(s, y.s);
	}
}

STR::STR(const char str[])
{
int len;
if(str == 0){
	if(0 == (s = new char[1])){
		l = 0;
		s = 0;
		}
	else{
		l = 1;
		s[0]='\0';
		}
	return;
	}
if(0 == (s = new char[len = strlen(str)+1])){
	l = 0;
	s = 0;
	}
else{
	l = len;
	strcpy(s,str);
	}
}

STR::STR(int n)
{
if(0 == (s = new char[n+1])){
	l = 0;
	s = 0;
	}
else{
	l = n+1;
	s[0] = '\0';
	}
}

//////////////////////////////////////////////////////
// Destructor:
STR::~STR()
{
if(l != 0 && s != 0){
	delete  s;
	s = 0;
	l = 0;
	}
}

STR& STR::operator=(const STR &y)
{
if(this == &y)
	return *this;
if(s != 0)
	delete s;
if(0 == (s = new char[y.l])){
	l = 0;
	s = 0;
	}
else{
	l = y.l;
	strcpy(s, y.s);
	}
return *this;
}

STR& STR::operator+=(const STR &y)
{
if(strlen(s)+strlen(y.s) < l){
	strcat(s, y.s);
	return *this;
	}
STR tmpx(*this);
STR tmpy(y);
if(s != 0)
	delete s;
if(0 == (s = new char[l = tmpx.l + strlen(tmpy.s)])){
	l = 0;
	s = 0;
	return *this;
	}
strcpy(s,tmpx.s);
strcat(s,tmpy.s);
return *this;
}

STR& STR::operator=(const char str[])
{
if(s == str)
	return *this;
if(s != 0)
	delete s;
if(str == 0){
	if(0 == (s = new char[1])){
		l = 0;
		s = 0;
		}
	else{
		l = 1;
		s[0]='\0';
		}
	return *this;
	}
if(0 == (s = new char[l = 1 + strlen(str)]))
	l = 0;
else
	strcpy(s, str);
return *this;
}

STR& STR::operator+=(const char str[])
{
if(strlen(s)+strlen(str) < l){
	strcat(s, str);
	return *this;
	}
STR tmp(*this);
if(s != 0)
	delete s;
if(0 == (s = new char[l = tmp.l + strlen(str)])){
	l = 0;
	s = 0;
	return *this;
	}
strcpy(s,tmp.s);
strcat(s,str);
return *this;
}

STR& STR::operator=(char c)
{
if(s != 0)
	delete s;
if(0 == (s = new char[l=2])){
	l = 0;
	s = 0;
	}
else{
	s[0] = c;
	s[1] = '\0';
	}
return *this;
}

STR& STR::operator+=(char c)
{
int i;
if(1 + (i=strlen(s)) < l){
	s[i] = c;
	s[i+1] = '\0';
	return *this;
	}
STR tmp(*this);
if(s != 0)
	delete s;
if(0 == (s = new char[l = tmp.l + 1])){
	l = 0;
	s = 0;
	return *this;
	}
strcpy(s,tmp.s);
s[l-2] = c;
s[l-1] = '\0';
return *this;
}

int STR::streq(const char szS[]) const
{
for(int i=0; s[i] && szS[i]; i++)
	if(::toupper(s[i]) != ::toupper(szS[i]))
		return 0;
return(s[i] || szS[i] ? 0 : 1);
}

int STR::hasin(const char subs[], int nFromIndex,
				int bIgnoreCase) const
{
int subslen = strlen(subs);
int searchlen = len() - subslen ;
if(searchlen < 0)
	return (-1);
for(int i = nFromIndex; i <= searchlen; i++){
	int bOk = 1;
	for(int j = 0 ; j < subslen ; j++){
		int c1 = s[i+j];
		int c2 = subs[j];
		if(bIgnoreCase){
			c1 = ::toupper(c1);
			c2 = ::toupper(c2);
			}
		if(c1 != c2){
			bOk=0;
			break;
			}
		}
	if(bOk)
		return i;
	}
return -1;
}

int STR::hasin(char c, int nFromIndex,
				int bIgnoreCase) const
{
for(int i = nFromIndex; s[i]; i++){
	if(s[i] == c)
		return i;
	if(bIgnoreCase && ::toupper(s[i]) == ::toupper(c))
		return i;
	}
if(c=='\0')
	return i;
return -1;
}

void STR::noFrontSpace()
{
int k,i;
for(i = 0; isspace(s[i]); i++)
	;
if(i == 0)
	return;
for(k = 0; s[i]; )
	s[k++] = s[i++];
s[k] = '\0';
}

void STR::noTrailSpace()
{
for(int i = strlen(s)-1; i >= 0 && isspace(s[i]); i--)
	s[i]='\0';
}
