static int var_a = 1;      /* Internal linkage, definition */
static int var_a;          /* Remains internal linkage */
extern int var_a;          /* Remains internal linkage */
int var_a;                 /* Error - var_a has internal linkage */
static int var_a = 1;      /* Error - more than one definition */

static int var_b;          /* Internal linkage, tentative definition */
extern int var_b = 1;      /* Remains internal linkage, definition
                              overrides tentative definition */

int var_c = 1;             /* External linkage, definition */
extern int var_c;          /* Remains external linkage */
int var_c;                 /* Remains external linkage */
static int var_c;          /* Error - var_c has external linkage */
static int var_c = 1;      /* Error - more than one definition */

extern int var_d = 1;      /* External linkage, definition */

static int var_e;          /* Internal linkage, tentative definition */
int var_e = 1;             /* Error - var_d has internal linkage */

static int var_f;          /* Internal linkage, tentative definition */
int var_g;                 /* External linkage, tentative definition */
extern int var_h;          /* External linkage */
extern int var_f;          /* Remains internal linkage */
static int var_f;          /* Remains internal linkage, another tentative
                              definition */

int main (void)
{
    static int var_c       /* No linkage, hides the previous var_c */
    extern int var_i;      /* External linkage */
    extern int var_j;      /* External linkage */
    extern int var_k;      /* External linkage */

    auto int var_f, var_g; /* Auto declarations hide the previous ones */
                           /* No linkage */

    {
        extern int var_f;  /* Error - hidden var_f has internal linkage */
                           /* Illustrates subtle point #2 */
       extern int var_g;  /* Remains external linkage */

        /* var_g here refers to the external linkage variable once more */
    }

    /* var_g here refers to the auto variable */
    return 0;
}

int var_i;                 /* Remains external linkage, tentative
                              definition */
                           /* Illustrates subtle point #1 */
extern int var_j;          /* Remains external linkage */
static int var_k;          /* Error - var_k has external linkage */

/* End of File */ 

