static int fn_a (void);     /* Internal linkage (first decl'n) */
int fn_a (void);            /* Remains internal linkage */
extern int fn_a (void);     /* Remains internal linkage; extern has no effect */

int fn_b (void);            /* External linkage (first decl'n) */
static int fn_b (void);     /* Error - fn_b has external linkage */

extern int fn_c (void);     /* External linkage (first decl'n) */

static int fn_d (void);     /* Internal linkage (first decl'n) */

int main (void)
{
    int fn_a (void);        /* Remains internal linkage */
    int fn_b (void);        /* Remains external linkage */
    static int fn_a (void); /* Error - block scope must not be static */

    int fn_e (void);        /* External linkage (first decl'n) */
    int fn_f (void);        /* External linkage (first decl'n) */

    int fn_c, fn_d;         /* Variable declarations hide the functions */
                            /* declarations in outer scope */

    {
        int fn_c ();        /* Remains external linkage */
        int fn_d ();        /* Error - hidden fn_d has internal linkage */
                            /* Illustrates subtle point `#2' */

        /* fn_c here refers to the external linkage function once more */
    }

    /* fn_c here refers to the variable */
    return 0;
}

int fn_e (void);            /* Remains external linkage */
                            /* Illustrates subtle point `#1' */
static int fn_f (void);     /* Error - fn_f has external linkage */

/* End of File */ 

