//====================== AUTOQ.CPP ======================================
//  AutoQueue Class Implementation File
//  R. Scott Guthrie - Original Code Creation
//=======================================================================
#include "AUTOQ.HPP"

// ----- Constructor (Auto Linking) -----
// Constructor used to create an AutoQueue entry in the specified list.
AutoQueue::AutoQueue(AutoQueue** QHead)
{ QHead_ = QHead;             // Save QHead value.
  Next_ = *QHead;             // Next points to top.
  if(Next_)                   // If there is a Next,
    Next_->Previous_ = this;  //   make its Previous point to this instance.
  Previous_ = 0;              // Previous is 0.
  *QHead = this;              // QHead points to this instance.
}

// ----- Destructor -----
AutoQueue::~AutoQueue()
{ if(QHead_)                         // If this instance is linked...
  { if(!Previous_)                   // If this is the first node
      *QHead_ = Next_;               //   make QHead -> Next
    else                             // Otherwise,
      Previous_->Next_ = Next_;      //   make previous Next -> Next.
    if(Next_)                        // If there is a Next,
      Next_->Previous_ = Previous_;  //   make its Previous -> this Previous.
  }
}
// end file AUTOQ.CPP
