/* ============ */
/* gausrand.c	*/
/* ============ */
#include <math.h>
# undef	RAND
#define	RAND	(double)rand
/* ====================================================================	*/
/* GenGausRand - generates a Gaussian-distributed double in (-6, +6)	*/
/* ====================================================================	*/
double	GenGausRand()
{
    double  RetVal;

    RetVal = RAND() + RAND() + RAND() + RAND() + RAND() + RAND() +
	     RAND() + RAND() + RAND() + RAND() + RAND() + RAND();

    RetVal = RetVal/((double)RAND_MAX + 1.0) - 6.0;

    return (RetVal);
}
# if defined(CHECK_OUT)
#include <stdio.h>
void
main()
{
#define	ITEM_MAX  1000000L
    long    i;
    double  Mean, StdDev, Sum, SumSq;

    Sum = SumSq = 0;
    for (i = 1; i <= ITEM_MAX; ++i)
    {
	double	NextRand = GenGausRand();

	Sum   += NextRand;
	SumSq += NextRand*NextRand;
    }
    Mean = Sum/(double)ITEM_MAX;

    StdDev = SumSq/(double)ITEM_MAX - Mean*Mean;
    StdDev = (StdDev < 0) ? 0 : sqrt(StdDev);

    printf("Sum of %ld random digits = %f, Mean = %f, Std Dev = %f\n",
	ITEM_MAX, Sum, Mean, StdDev);
}
# endif
