

    /***********************************************
    *
    *       file d:\cips\overlay.c
    *
    *       Functions: This file contains
    *          non_zero_overlay
    *          zero_overlay
    *          greater_overlay
    *          less_overlay
    *          average_overlay
    *
    *       Purpose:
    *          These functions implement the functions
    *          that overlay one image on top of another
    *          image.
    *
    *       External Calls:
    *          wtiff.c - create_file_if_needed
    *                    write_array_into_tiff_image
    *          tiff.c - read_tiff_header
    *          rtiff.c - read_tiff_image
    *          numcvrt.c - get_integer
    *
    *       Modifications:
    *          6 March 1993 - created
    *
    ***********************************************/


#include "cips.h"



   /**************************************************
   *
   *   non_zero_overlay(...
   *
   *   This function overlays in1 on top of in2
   *   and writes the result to the output image.
   *   It writes any non-zero pixel from in1 on top
   *   of in2.
   *
   ***************************************************/

non_zero_overlay(in1_name, in2_name, out_name,
          the_image, out_image,
          il1, ie1, ll1, le1,
          il2, ie2, ll2, le2,
          il3, ie3, ll3, le3)
   char   in1_name[], in2_name[], out_name[];
   int    il1, ie1, ll1, le1,
          il2, ie2, ll2, le2,
          il3, ie3, ll3, le3;
   short  the_image[ROWS][COLS],
          out_image[ROWS][COLS];
{
   int    i, j, length, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_image(in1_name, the_image,
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image,
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         if(the_image[i][j] != 0)
            out_image[i][j] = the_image[i][j];
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

} /* ends non_zero_overlay */





   /**************************************************
   *
   *   zero_overlay(...
   *
   *   This function overlays in1 on top of in2
   *   and writes the result to the output image.
   *   It writes any zero pixel from in1 on top
   *   of in2.
   *
   ***************************************************/

zero_overlay(in1_name, in2_name, out_name,
         the_image, out_image,
         il1, ie1, ll1, le1,
         il2, ie2, ll2, le2,
         il3, ie3, ll3, le3)
   char  in1_name[], in2_name[], out_name[];
   int   il1, ie1, ll1, le1,
         il2, ie2, ll2, le2,
         il3, ie3, ll3, le3;
   short the_image[ROWS][COLS],
         out_image[ROWS][COLS];
{
   int    i, j, length, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_image(in1_name, the_image,
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image,
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         if(the_image[i][j] == 0)
            out_image[i][j] = the_image[i][j];
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

} /* ends zero_overlay */





   /**************************************************
   *
   *   greater_overlay(...
   *
   *   This function overlays in1 on top of in2
   *   and writes the result to the output image.
   *   It writes in1 on top of in2 if the value of
   *   in1 is greater than in2.
   *
   ***************************************************/

greater_overlay(in1_name, in2_name, out_name,
         the_image, out_image,
         il1, ie1, ll1, le1,
         il2, ie2, ll2, le2,
         il3, ie3, ll3, le3)
   char  in1_name[], in2_name[], out_name[];
   int   il1, ie1, ll1, le1,
         il2, ie2, ll2, le2,
         il3, ie3, ll3, le3;
   short the_image[ROWS][COLS],
         out_image[ROWS][COLS];
{
   int    i, j, length, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_image(in1_name, the_image,
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image,
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         if(the_image[i][j] > out_image[i][j])
            out_image[i][j] = the_image[i][j];
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

} /* ends greater_overlay */





   /**************************************************
   *
   *   less_overlay(...
   *
   *   This function overlays in1 on top of in2
   *   and writes the result to the output image.
   *   It writes in1 on top of in2 if the value of
   *   in1 is less than in2.
   *
   ***************************************************/

less_overlay(in1_name, in2_name, out_name,
         the_image, out_image,
         il1, ie1, ll1, le1,
         il2, ie2, ll2, le2,
         il3, ie3, ll3, le3)
   char  in1_name[], in2_name[], out_name[];
   int   il1, ie1, ll1, le1,
         il2, ie2, ll2, le2,
         il3, ie3, ll3, le3;
   short the_image[ROWS][COLS],
         out_image[ROWS][COLS];
{
   int    i, j, length, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_image(in1_name, the_image,
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image,
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         if(the_image[i][j] < out_image[i][j])
            out_image[i][j] = the_image[i][j];
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

} /* ends less_overlay */





   /**************************************************
   *
   *   average_overlay(...
   *
   *   This function mixes in1 and in2
   *   and writes the result to the output image.
   *   It writes the average of in1 and in2 to the
   *   output image.
   *
   ***************************************************/

average_overlay(in1_name, in2_name, out_name,
         the_image, out_image,
         il1, ie1, ll1, le1,
         il2, ie2, ll2, le2,
         il3, ie3, ll3, le3)
   char  in1_name[], in2_name[], out_name[];
   int   il1, ie1, ll1, le1,
         il2, ie2, ll2, le2,
         il3, ie3, ll3, le3;
   short the_image[ROWS][COLS],
         out_image[ROWS][COLS];
{
   int    i, j, length, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_image(in1_name, the_image,
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image,
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         out_image[i][j] =
            (the_image[i][j] + out_image[i][j])/2;
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

} /* ends average_overlay */
