
    /********************************************
    *
    *    file d:\cips\geometry.c
    *
    *    Functions: This file contains
    *       main
    *
    *    Purpose:
    *       This file contains the main calling
    *       routine for geometric subroutines.
    *
    *    External Calls:
    *       gin.c - get_image_name
    *       tiff.c - read_tiff_header
    *       geosubs.c - geometry
    *                   arotate
    *
    *    Modifications:
    *       26 October 1993 - created
    *
    ********************************************/

#include "cips.h"


short the_image[ROWS][COLS];
short out_image[ROWS][COLS];

main(argc, argv)
   int argc;
   char *argv[];
{

   char   name[80], name2[80], type[80];
   float  theta, x_stretch, y_stretch,
          x_cross, y_cross;
   int    bilinear, count, i, ie, il, j, le,
          length, ll, width;
   int    x_control, y_control;
   short  m, n, x_displace, y_displace;
   struct tiff_header_struct image_header;

   my_clear_text_screen();


      /*************************************
      *
      *   This program will use a different
      *   command line for each type of
      *   call.
      *
      *   Print a usage statement that
      *   gives an example of each type
      *   of call.
      *
      *************************************/

   if(argc < 7){
    printf("\n\nNot enough parameters:");
    printf("\n");
    printf("\n   Two Operations: ");
    printf("\n      geometry  rotate");
    printf("\n\n   Examples:");
    printf("\n");
    printf("\n   geometry in out geometry angle");
    printf(" x-displace y-displace");
    printf("\n            x-stretch y-stretch");
    printf(" x-cross y-cross bilinear (1 or 0)");
    printf("\n");
    printf("\n   geometry in out rotate angle m n");
    printf(" bilinear (1 or 0)");
    printf("\n");
    exit(0);
   }

      /*************************************
      *
      *   Interpret the command line
      *   depending on the type of call.
      *
      *************************************/

   if(strncmp(argv[3], "geometry", 3) == 0){
      strcpy(name,  argv[1]);
      strcpy(name2, argv[2]);
      strcpy(type,  argv[3]);
      theta      = atof(argv[4]);
      x_displace = atoi(argv[5]);
      y_displace = atoi(argv[6]);
      x_stretch  = atof(argv[7]);
      y_stretch  = atof(argv[8]);
      x_cross    = atof(argv[9]);
      y_cross    = atof(argv[10]);
      bilinear   = atoi(argv[11]);
   }

   if(strncmp(argv[3], "rotate", 3) == 0){
      strcpy(name,  argv[1]);
      strcpy(name2, argv[2]);
      strcpy(type,  argv[3]);
      theta    = atof(argv[4]);
      m        = atoi(argv[5]);
      n        = atoi(argv[6]);
      bilinear = atoi(argv[7]);
   }

   il = 1;
   ie = 1;
   ll = ROWS+1;
   le = COLS+1;

   read_tiff_header(name, &image_header);

   length = (ROWS-10 + image_header.image_length)/ROWS;
   width  = (COLS-10 +image_header.image_width)/COLS;
   count  = 1;
   printf("\nlength=%d  width=%d", length, width);

      /*************************************
      *
      *   Call the routines
      *
      *************************************/

   if(strncmp(type, "geometry", 3) == 0){
      for(i=0; i<length; i++){
         for(j=0; j<width; j++){
           printf("\nrunning %d of %d",
                   count, length*width);
           count++;
           printf("\ntype is %s", type);
           geometry(name, name2, the_image, out_image,
                   il+i*ROWS, ie+j*COLS,
                   ll+i*ROWS, le+j*COLS,
                   theta, x_stretch, y_stretch,
                   x_displace, y_displace,
                   x_cross, y_cross,
                   bilinear);
         }  /* ends loop over j */
      }  /* ends loop over i */
   }  /* ends if */



   if(strncmp(type, "rotate", 3) == 0){
      for(i=0; i<length; i++){
         for(j=0; j<width; j++){
           printf("\nrunning %d of %d",
                   count, length*width);
           count++;
           printf("\ntype is %s", type);
           arotate(name, name2, the_image, out_image,
                  il+i*ROWS, ie+j*COLS,
                  ll+i*ROWS, le+j*COLS,
                  theta, m, n, bilinear);
         }  /* ends loop over j */
      }  /* ends loop over i */
   }  /* ends if */

}  /* ends main  */
