/*----------------------------------------*
 * hashhmap.cxx --
 *    Implementation of the VPmap class.
 */
#include <stdlib.h>
#include "hashmap.h"

/*----------------------------------------*
 * convenient macros
 */
#define ELEMENTS(array) \
        (sizeof(array) / sizeof(array[0]))

#define EACHELEM(x, array, size) \
        x = &(array)[size]; \
        x-- > (array);

 
VPmap::VPmap(
         size_t             buckets,
         KeyHashProc        key_hash,
         KeyCompareEqProc   key_cmp,
         KeyValCreateProc   K_V_C,
         KeyValDestroyProc  K_V_D)
{
    hash               = key_hash;
    isEqual            = key_cmp;
    CreateKeyAndValue  = K_V_C;
    DestroyKeyAndValue = K_V_D;
    hashsize           = buckets;

    VPAssoc **ptr;
    keys = new VPAssoc *[hashsize];
    for (EACHELEM(ptr, keys, hashsize))
        *ptr = NULL;
}



VPmap::~VPmap()
{
    VPAssoc **list;

    for (EACHELEM(list, keys, hashsize))
        while (*list) {
            VPAssoc *item  = *list;
            *list = item->next;

            DestroyKeyAndValue(item->key, item->value);
            delete item;
        }

    delete[] keys;
}



void VPmap::apply(VPiterProc proc, void *data)
{
    VPAssoc **list, *item;

    for (EACHELEM(list, keys, hashsize))
        for (item = *list; item != NULL; item = item->next)
            (*proc)(item->key, item->value, data);
}



void *VPmap::index(const void *theKey)
{
    VPAssoc *item, **list = &keys[hash(theKey) % hashsize];

    for (item = *list; item != NULL; item = item->next)
        if (isEqual(theKey, item->key))
            return item->value;

    VPAssoc *n = new VPAssoc;
    CreateKeyAndValue(this, theKey, n->key, n->value);
    n->next = *list;
    *list = n;

    return n->value;
}


