/* ********************************* */
/* Transaction Master demo */

#include <stdio.h>
#include "netfn.h"

struct messout {
       char call[82] ;
       int flag ; } messout ;

struct messin {
       char reply[82] ; } messin ;


main()
{  
   int dgstat;
   char *get_neterrmess() ;
   
   messout.flag = 0 ;
   open_net_client("master") ;           		// Open the client
   strcpy(messout.call,"Sending datagram to rpc server") ;
   printf("Sending message to rpc server\n") ;
   dgstat = NetTransact("rpcserver", messin, messout) ;  // Transact with rpcserver 
   if (dgstat)
    printf("%s\n", get_neterrmess(dgstat)) ;
   else
    { printf("Received reply : %s\n", &messin.reply) ;
      messout.flag = -1 ;
      NetTransact("rpcserver", messin, messout) ;     // Terminate server
    }
   close_net_client() ;
}

/* ***************************************************** */
/* RPC server demo */

#include <stdio.h>
#include <string.h>
#include "netfn.h"


/* Message structures must be static */
struct messin {
       char call[82] ;
       int flag ; } ;

struct messout {
       char reply[82] ;} messout ;

int flag = 0 ;
char *name = "rpcserver" ;

/* Remote Procedure */
struct messout *server(struct messin *messptr)
{ if (messptr->flag != -1)
    { printf("Message in : %s\n", messptr->call) ;
      strcpy(messout.reply, "Sending reply from rpc server") ;
      printf("Returning reply\n") ;
    }
  else
   { printf("Terminate message issued\n") ;
     flag = messptr->flag ;
   }
  return(&messout) ;
}

main()
{    
/* Install destructor */
   atexit(remove_all_rpcservers) ;

   if (install_rpcserver(name, (void *)server, sizeof(messout)) == NULL)
     { printf("Cannot add network name %s\n", name) ;
       exit(1) ;
     }  

   printf("Starting\n") ;

   while(flag != -1)
     net_comms() ;               // Loop round servicing datagrams until terminated

   printf("Finish\n") ;
}




