

        /******************************************************
        *      
        *       file d:\lsu\huffman.h
        *
        *       Functions: This file contains no functions. It
        *           contains declarations of the data 
        *           structures used by the hoffman coding 
        *           program.
        *
        *       Purpose: To declare data structures.
        *
        *       Modifications:
        *
        *******************************************************/

#include "d:\c600\include\stdio.h"
#include "d:\c600\include\graph.h"
#include "d:\c600\include\io.h"
#include "d:\c600\include\fcntl.h"
#include "d:\c600\include\dos.h"
#include "d:\c600\include\math.h"
#include "d:\c600\include\sys\types.h"
#include "d:\c600\include\sys\stat.h"
#include "d:\lsu\iptype.h"




#define LENGTH      256  /* length of item array */
#define LLENGTH      25  /* length of includes array */
#define ONE         '1'
#define ZERO        '0'
#define OTHER       '2'
#define CODE_LENGTH  16  /* max # of bits for a character */
#define IB_LENGTH   150
#define OB_LENGTH  1000
#define END_FILE    254

   /* The following constants are for setting, clearing, and
      testing bits in a char buffer */

#define SET_BIT_SEVEN   1
#define SET_BIT_SIX     2
#define SET_BIT_FIVE    4
#define SET_BIT_FOUR    8
#define SET_BIT_THREE  16
#define SET_BIT_TWO    32
#define SET_BIT_ONE    64
#define SET_BIT_ZERO  128

#define CLEAR_BIT_ZERO   127
#define CLEAR_BIT_ONE    191
#define CLEAR_BIT_TWO    223
#define CLEAR_BIT_THREE  239
#define CLEAR_BIT_FOUR   247
#define CLEAR_BIT_FIVE   251
#define CLEAR_BIT_SIX    253
#define CLEAR_BIT_SEVEN  254



     /************************************************
     *
     *   This is the item_struct which defines the
     *   item_array used throughout the Huffman 
     *   program.
     *
     *      indicator - shows whether or not to process
     *         an element of the item array.  The values
     *         can be D=disable or E=enalble.
     *
     *      character - the original character in the big
     *         file.  This can be any character from
     *         decimal 0 to 255.
     *
     *      count - counts the number of times a character
     *         appears in the original big file.
     *
     *      coded[CODE_LENGTH] - this holds the code for a
     *         character.  It is of the form 101101222222.
     *         The '2' is the OTHER character which means
     *         it is not used. e.g. if code=10122222, then
     *         the code is 101 and the 22222 are dummy
     *         characters.
     *
     *      includes - this is a number that links the item
     *         to any other item with which it has been 
     *         combined.
     *
     *************************************************/

struct item_struct{
   char   indicator;
   char   character;
   long   count;
   char   coded[CODE_LENGTH];
   short  includes[LLENGTH];
};


     /************************************************
     *
     *   This is the header_struct.  We'll save this
     *   at the beginning of the compressed file.  It
     *   is smaller than the item_struct and will save
     *   some space in the compressed file.
     *
     *************************************************/

struct short_item{
   char   character;
   char   coded[CODE_LENGTH];
};


struct header_struct{
   struct short_item items[LENGTH];
   long   in_file_length;
};
