;/*
comment &
*/
#define IVEC_DPMI   0x31

/* DPMI Functions */

#define DPMI_GETRMVEC 0x0200	    /* Get Real Mode Vector	    */
#define DPMI_SETRMVEC 0x0201	    /* Set Real Mode Vector	    */
#define DPMI_SIMRMINT 0x0300	    /* Simulate Real Mode Interrupt */
#define DPMI_RMCALL   0x0301	    /* Call real mode procedure     */
#define DPMI_RMINT    0x0302	    /* Call real mode interrupt svc */
#define DPMI_ALLOCRMC 0x0303	    /* Allocate Real Mode Callback  */
#define DPMI_FREERMC  0x0304	    /* Free Real Mode Callback	    */

typedef struct __RMCS		/* Real Mode Call Structure */
    {
    unsigned long _edi ;	/*  0/00 */
    unsigned long _esi ;	/*  4/00 */
    unsigned long _ebp ;	/*  8/00 */
    unsigned long _reserved ;	/* 12/00 */
    unsigned long _ebx ;	/* 16/00 */
    unsigned long _edx ;	/* 20/00 */
    unsigned long _ecx ;	/* 24/00 */
    unsigned long _eax ;	/* 28/00 */
    unsigned short _flags ;	/* 32/00 */
    unsigned short _es ;	/* 34/00 */
    unsigned short _ds ;	/* 36/00 */
    unsigned short _fs ;	/* 38/00 */
    unsigned short _gs ;	/* 40/00 */
    unsigned short _ip ;	/* 42/00 */
    unsigned short _cs ;	/* 44/00 */
    unsigned short _sp ;	/* 46/00 */
    unsigned short _ss ;	/* 48/00 */
    } _RMCS ;

; /*&
IVEC_DPMI   equ     31h

DPMI_GETRMVEC equ 0200h        ; Get Real Mode Vector
DPMI_SETRMVEC equ 0201h        ; Set Real Mode Vector
DPMI_SIMRMINT equ 0300h        ; Simulate Real Mode Interrupt
DPMI_RMCALL   equ 0301h        ; Call real mode procedure
DPMI_RMINT    equ 0302h        ; Call real mode interrupt svc
DPMI_ALLOCRMC equ 0303h        ; Allocate Real Mode Callback
DPMI_FREERMC  equ 0304h        ; Free Real Mode Callback


RMCS STRUC
rmcs_edi	dd ?	;  0/00
rmcs_esi	dd ?	;  4/04
rmcs_ebp	dd ?	;  8/08
rmcs_reserved	dd ?	; 12/0C
rmcs_ebx	dd ?	; 16/10
rmcs_edx	dd ?	; 20/14
rmcs_ecx	dd ?	; 24/18
rmcs_eax	dd ?	; 28/1C
rmcs_flags	dw ?	; 32/20
rmcs_es 	dw ?	; 34/22
rmcs_ds 	dw ?	; 36/24
rmcs_fs 	dw ?	; 38/26
rmcs_gs 	dw ?	; 40/28
rmcs_ip 	dw ?	; 42/2A
rmcs_cs 	dw ?	; 44/2C
rmcs_sp 	dw ?	; 46/2E
rmcs_ss 	dw ?	; 48/30
			; 50/32 (total)
RMCS ENDS

rmcs_di equ word ptr rmcs_edi
rmcs_si equ word ptr rmcs_esi
rmcs_bp equ word ptr rmcs_ebp
rmcs_bx equ word ptr rmcs_ebx
rmcs_dx equ word ptr rmcs_edx
rmcs_cx equ word ptr rmcs_ecx
rmcs_ax equ word ptr rmcs_eax
rmcs_fl equ word ptr rmcs_flags

rmcs_bl equ byte ptr rmcs_bx
rmcs_bh equ byte ptr rmcs_bl+1
rmcs_dl equ byte ptr rmcs_dx
rmcs_dh equ byte ptr rmcs_dl+1
rmcs_cl equ byte ptr rmcs_cx
rmcs_ch equ byte ptr rmcs_cl+1
rmcs_al equ byte ptr rmcs_ax
rmcs_ah equ byte ptr rmcs_al+1

; */
