
DDKINCLUDE=..\include

DEBUG=1

PROJ=vxd2

LDEBUG=/m /co
LNODEBUG=/m
DBGOBJS=
NODBGOBJS=
ADEBUG=-DDEBUG -Zi
CDEBUG=-Od -Zi
CFLAGS=-nologo -G2 -A$(MODEL) -Aw -W4 -WX -Gs -Oas -Zpe $(CDEBUG)

CC=cl
LINK=link /F
RC=rc
MAPSYM=mapsym
AS=masm
ASFLAT=masm5
LINKFLAT=link386

!IF $(DEBUG)
AFLAGS=-p -w2 -Mx $(ADEBUG)
LFLAGS=/nologo /NOI /NOD /NOP $(LDEBUG)
!ELSE
AFLAGS=-p -w2 -Mx
LFLAGS=/nologo /NOI /NOD /NOP $(LNODEBUG)
!ENDIF

.asm.obj:
	$(ASFLAT) $(AFLAGS) -I$(DDKINCLUDE) $* ;

.asm.lst:
	$(ASFLAT) -l $(AFLAGS) -I$(DDKINCLUDE) $* ;

all: $(PROJ).386

$(PROJ).obj: $(PROJ).asm $(DDKINCLUDE)\v86mmgr.inc \
		$(DDKINCLUDE)\debug.inc $(DDKINCLUDE)\vmm.inc

$(PROJ).lst: $(PROJ).asm $(DDKINCLUDE)\v86mmgr.inc \
		$(DDKINCLUDE)\debug.inc $(DDKINCLUDE)\vmm.inc

$(PROJ).lnk: makefile.
	if exist $@ del $@
	echo $*.obj >>$@
	echo $*.386 >>$@
	echo $*.map	>>$@
	echo.>>$@
	echo $*.def ;	>>$@

$(PROJ).386: $(PROJ).def $(PROJ).obj $(PROJ).lnk
	$(LINKFLAT) $(LFLAGS) @$*.lnk
	addhdr $*.386
	mapsym32 $*

dostest.obj: dostest.asm
	$(AS) $(AFLAGS) $* ;

dostest.lst: dostest.asm
	$(AS) -l $(AFLAGS) $* ;

dostest.exe: dostest.obj
	$(LINK) $(LFLAGS) $* ;

dostest.sym: dostest.exe
	mapsym $*
