# !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
# This file is machine-generated by lib/unicore/mktables from the Unicode
# database, Version 15.0.0.  Any changes made here will be lost!

sub TODO_FAILING_BREAKS { 0 }

use strict;
use warnings;

use feature 'signatures';

no warnings 'experimental::uniprop_wildcards';

# Test qr/\X/ and the \p{} regular expression constructs.  This file is
# constructed by mktables from the tables it generates, so if mktables is
# buggy, this won't necessarily catch those bugs.  Tests are generated for all
# feasible properties; a few aren't currently feasible; see
# is_code_point_usable() in mktables for details.

# Standard test packages are not used because this manipulates SIG_WARN.  It
# exits 0 if every non-skipped test succeeded; -1 if any failed.

my $Tests = 0;
my $Fails = 0;

# loc_tools.pl requires this function to be defined
sub ok($pass, @msg) {
    print "not " unless $pass;
    print "ok ";
    print ++$Tests;
    print " - ", join "", @msg if @msg;
    print "\n";
}

sub Expect($expected, $ord, $regex, $warning_type='') {
    my $line   = (caller)[2];

    # Convert the code point to hex form
    my $string = sprintf "\"\\x{%04X}\"", $ord;

    my @tests = "";

    # The first time through, use all warnings.  If the input should generate
    # a warning, add another time through with them turned off
    push @tests, "no warnings '$warning_type';" if $warning_type;

    foreach my $no_warnings (@tests) {

        # Store any warning messages instead of outputting them
        local $SIG{__WARN__} = $SIG{__WARN__};
        my $warning_message;
        $SIG{__WARN__} = sub { $warning_message = $_[0] };

        $Tests++;

        # A string eval is needed because of the 'no warnings'.
        # Assumes no parentheses in the regular expression
        my $result = eval "$no_warnings
                            my \$RegObj = qr($regex);
                            $string =~ \$RegObj ? 1 : 0";
        if (not defined $result) {
            print "not ok $Tests - couldn't compile /$regex/; line $line: $@\n";
            $Fails++;
        }
        elsif ($result ^ $expected) {
            print "not ok $Tests - expected $expected but got $result for $string =~ qr/$regex/; line $line\n";
            $Fails++;
        }
        elsif ($warning_message) {
            if (! $warning_type || ($warning_type && $no_warnings)) {
                print "not ok $Tests - for qr/$regex/ did not expect warning message '$warning_message'; line $line\n";
                $Fails++;
            }
            else {
                print "ok $Tests - expected and got a warning message for qr/$regex/; line $line\n";
            }
        }
        elsif ($warning_type && ! $no_warnings) {
            print "not ok $Tests - for qr/$regex/ expected a $warning_type warning message, but got none; line $line\n";
            $Fails++;
        }
        else {
            print "ok $Tests - got $result for $string =~ qr/$regex/; line $line\n";
        }
    }
    return;
}

sub Error($regex) {
    $Tests++;
    if (eval { 'x' =~ qr/$regex/; 1 }) {
        $Fails++;
        my $line = (caller)[2];
        print "not ok $Tests - re compiled ok, but expected error for qr/$regex/; line $line: $@\n";
    }
    else {
        my $line = (caller)[2];
        print "ok $Tests - got and expected error for qr/$regex/; line $line\n";
    }
    return;
}

# Break test files (e.g. GCBTest.txt) character that break allowed here
my $breakable_utf8 = my $breakable = chr(utf8::unicode_to_native(0xF7));
utf8::upgrade($breakable_utf8);

# Break test files (e.g. GCBTest.txt) character that indicates can't break
# here
my $nobreak_utf8 = my $nobreak = chr(utf8::unicode_to_native(0xD7));
utf8::upgrade($nobreak_utf8);

my $are_ctype_locales_available;
my $utf8_locale;
chdir 't' if -d 't';
eval { require "./loc_tools.pl" };
if (defined &locales_enabled) {
    $are_ctype_locales_available = locales_enabled('LC_CTYPE');
    if ($are_ctype_locales_available) {
        $utf8_locale = &find_utf8_ctype_locale;
    }
}

# Eval'd so can run on versions earlier than the property is available in
my $WB_Extend_or_Format_re = eval 'qr/[\p{WB=Extend}\p{WB=Format}\p{WB=ZWJ}]/';
if (! defined $WB_Extend_or_Format_re) {
    $WB_Extend_or_Format_re = eval 'qr/[\p{WB=Extend}\p{WB=Format}]/';
}

sub _test_break($template, $break_type) {
    # Test various break property matches.  The 2nd parameter gives the
    # property name.  The input is a line from auxiliary/*Test.txt for the
    # given property.  Each such line is a sequence of Unicode (not native)
    # code points given by their hex numbers, separated by the two characters
    # defined just before this subroutine that indicate that either there can
    # or cannot be a break between the adjacent code points.  All these are
    # tested.
    #
    # For the gcb property extra tests are made.  if there isn't a break, that
    # means the sequence forms an extended grapheme cluster, which means that
    # \X should match the whole thing.  If there is a break, \X should stop
    # there.  This is all converted by this routine into a match: $string =~
    # /(\X)/, Each \X should match the next cluster; and that is what is
    # checked.

    my $line   = (caller 1)[2];   # Line number
    my $comment = "";

    if ($template =~ / ( .*? ) \s* \# (.*) /x) {
        $template = $1;
        $comment = $2;

        # Replace leading spaces with a single one.
        $comment =~ s/ ^ \s* / # /x;
    }

    # The line contains characters above the ASCII range, but in Latin1.  It
    # may or may not be in utf8, and if it is, it may or may not know it.  So,
    # convert these characters to 8 bits.  If knows is in utf8, simply
    # downgrade.
    if (utf8::is_utf8($template)) {
        utf8::downgrade($template);
    } else {

        # Otherwise, if it is in utf8, but doesn't know it, the next lines
        # convert the two problematic characters to their 8-bit equivalents.
        # If it isn't in utf8, they don't harm anything.
        use bytes;
        $template =~ s/$nobreak_utf8/$nobreak/g;
        $template =~ s/$breakable_utf8/$breakable/g;
    }

    # Perl customizes wb.  So change the official tests accordingly
    if ($break_type eq 'wb' && $WB_Extend_or_Format_re) {

        # Split into elements that alternate between code point and
        # break/no-break
        my @line = split / +/, $template;

        # Look at each code point and its following one
        for (my $i = 1; $i <  @line - 1 - 1; $i+=2) {

            # The customization only involves changing some breaks to
            # non-breaks.
            next if $line[$i+1] =~ /$nobreak/;

            my $lhs = chr utf8::unicode_to_native(hex $line[$i]);
            my $rhs = chr utf8::unicode_to_native(hex $line[$i+2]);

            # And it only affects adjacent space characters.
            next if $lhs !~ /\s/u;

            # But, we want to make sure to test spaces followed by a Extend
            # or Format.
            next if $rhs !~ /\s|$WB_Extend_or_Format_re/;

            # To test the customization, add some white-space before this to
            # create a span.  The $lhs white space may or may not be bound to
            # that span, and also with the $rhs.  If the $rhs is a binding
            # character, the $lhs is bound to it and not to the span, unless
            # $lhs is vertical space.  In all other cases, the $lhs is bound
            # to the span.  If the $rhs is white space, it is bound to the
            # $lhs
            my $bound;
            my $span;
            if ($rhs =~ /$WB_Extend_or_Format_re/) {
                if ($lhs =~ /\v/) {
                    $bound = $breakable;
                    $span = $nobreak;
                }
                else {
                    $bound = $nobreak;
                    $span = $breakable;
                }
            }
            else {
                $span = $nobreak;
                $bound = $nobreak;
            }

            splice @line, $i, 0, ( '0020', $nobreak, '0020', $span);
            $i += 4;
            $line[$i+1] = $bound;
        }
        $template = join " ", @line;
    }

    # The input is just the break/no-break symbols and sequences of Unicode
    # code points as hex digits separated by spaces for legibility. e.g.:
    # ÷ 0020 × 0308 ÷ 0020 ÷
    # Convert to native \x format
    $template =~ s/ \s* ( [[:xdigit:]]+ ) \s* /sprintf("\\x{%02X}", utf8::unicode_to_native(hex $1))/gex;
    $template =~ s/ \s* //gx;   # Probably the line above removed all spaces;
                                # but be sure

    # Make a copy of the input with the symbols replaced by \b{} and \B{} as
    # appropriate
    my $break_pattern = $template =~ s/ $breakable /\\b{$break_type}/grx;
    $break_pattern =~ s/ $nobreak /\\B{$break_type}/gx;

    my $display_string = $template =~ s/[$breakable$nobreak]//gr;
    my $string = eval "\"$display_string\"";

    # The remaining massaging of the input is for the \X tests.  Get rid of
    # the leading and trailing breakables
    $template =~ s/^ \s* $breakable \s* //x;
    $template =~ s/ \s* $breakable \s* $ //x;

    # Delete no-breaks
    $template =~ s/ \s* $nobreak \s* //xg;

    # Split the input into segments that are breakable between them.
    my @should_display = split /\s*$breakable\s*/, $template;
    my @should_match = map { eval "\"$_\"" } @should_display;

    # If a string can be represented in both non-ut8 and utf8, test both cases
    my $display_upgrade = "";
    UPGRADE:
    for my $to_upgrade (0 .. 1) {

        if ($to_upgrade) {

            # If already in utf8, would just be a repeat
            next UPGRADE if utf8::is_utf8($string);

            utf8::upgrade($string);
            $display_upgrade = " (utf8-upgraded)";
        }

        my @modifiers = qw(a aa d u i);
        if ($are_ctype_locales_available) {
            push @modifiers, "l$utf8_locale" if defined $utf8_locale;

            # The /l modifier has C after it to indicate the locale to try
            push @modifiers, "lC";
        }

        # Test for each of the regex modifiers.
        for my $modifier (@modifiers) {
            my $display_locale = "";

            # For /l, set the locale to what it says to.
            if ($modifier =~ / ^ l (.*) /x) {
                my $locale = $1;
                $display_locale = "(locale = $locale)";
                POSIX::setlocale(POSIX::LC_CTYPE(), $locale);
                $modifier = 'l';
            }

            no warnings qw(locale regexp surrogate);
            my $pattern = "(?$modifier:$break_pattern)";

            # Actually do the test
            my $matched_text;
            my $matched = $string =~ qr/$pattern/;
            if ($matched) {
                $matched_text = "matched";
            }
            else {
                $matched_text = "failed to match";
                print "not ";

                if (TODO_FAILING_BREAKS) {
                    $comment = " # $comment" unless $comment =~ / ^ \s* \# /x;
                    $comment =~ s/#/# TODO/;
                }
            }
            print "ok ", ++$Tests, " - \"$display_string\" $matched_text /$pattern/$display_upgrade; line $line $display_locale$comment\n";

            # Only print the comment on the first use of this line
            $comment = "";

            # Repeat with the first \B{} in the pattern.  This makes sure the
            # code in regexec.c:find_byclass() for \B gets executed
            if ($pattern =~ / ( .*? : ) .* ( \\B\{ .* ) /x) {
                my $B_pattern = "$1$2";
                $matched = $string =~ qr/$B_pattern/;
                print "not " unless $matched;
                $matched_text = ($matched) ? "matched" : "failed to match";
                print "ok ", ++$Tests, " - \"$display_string\" $matched_text /$B_pattern/$display_upgrade; line $line $display_locale";
                print " # TODO" if TODO_FAILING_BREAKS && ! $matched;
                print "\n";
            }
        }

        next if $break_type ne 'gcb';

        # Finally, do the \X match.
        my @matches = $string =~ /(\X)/g;

        # Look through each matched cluster to verify that it matches what we
        # expect.
        my $min = (@matches < @should_match) ? @matches : @should_match;
        for my $i (0 .. $min - 1) {
            $Tests++;
            if ($matches[$i] eq $should_match[$i]) {
                print "ok $Tests - ";
                if ($i == 0) {
                    print "In \"$display_string\" =~ /(\\X)/g, \\X #1";
                } else {
                    print "And \\X #", $i + 1,
                }
                print " correctly matched $should_display[$i]; line $line\n";
            } else {
                $matches[$i] = join("", map { sprintf "\\x{%04X}", ord $_ }
                                                    split "", $matches[$i]);
                print "not ok $Tests -";
                print " # TODO" if TODO_FAILING_BREAKS;
                print " In \"$display_string\" =~ /(\\X)/g, \\X #",
                    $i + 1,
                    " should have matched $should_display[$i]",
                    " but instead matched $matches[$i]",
                    ".  Abandoning rest of line $line\n";
                next UPGRADE;
            }
        }

        # And the number of matches should equal the number of expected matches.
        $Tests++;
        if (@matches == @should_match) {
            print "ok $Tests - Nothing was left over; line $line\n";
        } else {
            print "not ok $Tests - There were ", scalar @should_match, " \\X matches expected, but got ", scalar @matches, " instead; line $line";
            print " # TODO" if TODO_FAILING_BREAKS;
            print "\n";
        }
    }

    return;
}

sub Test_GCB($t) {
    _test_break($t, 'gcb');
}

sub Test_LB($t) {
    _test_break($t, 'lb');
}

sub Test_SB($t) {
    _test_break($t, 'sb');
}

sub Test_WB($t) {
    _test_break($t, 'wb');
}

sub Finished() {
    print "1..$Tests\n";
    exit($Fails ? -1 : 0);
}

if (!$::TESTCHUNK or $::TESTCHUNK == 1) {
    Error('\p{Script=InGreek}');    # Bug #69018
    Test_GCB("1100 $nobreak 1161");  # Bug #70940
    Expect(0, 0x2028, '\p{Print}', ""); # Bug # 71722
    Expect(0, 0x2029, '\p{Print}', ""); # Bug # 71722
    Expect(1, 0xFF10, '\p{XDigit}', ""); # Bug # 71726
    Error('\p{InKana}');    # 'Kana' is not a block so InKana shouldn't compile
    Expect(1, 0xB6, '\p{In=V1_1}', ""); # Didn't use to work
    Expect(1, 0x3A2,'\p{In=NA}', "");   # Didn't use to work
    
    # Make sure this gets tested; it was not part of the official test suite at
    # the time this was added.  Note that this is as it would appear in the
    # official suite, and gets modified to check for the perl tailoring by
    # Test_WB()
    Test_WB("$breakable 0020 $breakable 0020 $breakable 0308 $breakable");
    Test_LB("$nobreak 200B $nobreak 0020 $nobreak 0020 $breakable 2060 $breakable");
    Expect(1, ord(" "), '\p{gc=:(?aa)s:}', "");     # /aa is valid
    Expect(1, ord(" "), '\p{gc=:(?-s)s:}', "");     # /-s is valid
    ;
    Error('\p{_perllb}');
    Error('\P{_perllb}');
    Error('\p{_perlscx}');
    Error('\P{_perlscx}');
    Error('\p{age}');
    Error('\P{age}');
    Error('\p{Age=_V1_1/a/}');
    Error('\P{Age=_V1_1/a/}');
    Expect(1, 65533, '\p{Age=:\AV1_1\z:}', "");;
    Expect(0, 65536, '\p{Age=:\AV1_1\z:}', "");;
    Expect(1, 65533, '\p{Age=v11}', "");
    Expect(0, 65533, '\p{^Age=v11}', "");
    Expect(0, 65533, '\P{Age=v11}', "");
    Expect(1, 65533, '\P{^Age=v11}', "");
    Expect(0, 65536, '\p{Age=v11}', "");
    Expect(1, 65536, '\p{^Age=v11}', "");
    Expect(1, 65536, '\P{Age=v11}', "");
    Expect(0, 65536, '\P{^Age=v11}', "");
    Expect(1, 65533, '\p{Age=:\Av11\z:}', "");;
    Expect(0, 65536, '\p{Age=:\Av11\z:}', "");;
    Expect(1, 65533, '\p{Age=	v1_1}', "");
    Expect(0, 65533, '\p{^Age=	v1_1}', "");
    Expect(0, 65533, '\P{Age=	v1_1}', "");
    Expect(1, 65533, '\P{^Age=	v1_1}', "");
    Expect(0, 65536, '\p{Age=	v1_1}', "");
    Expect(1, 65536, '\p{^Age=	v1_1}', "");
    Expect(1, 65536, '\P{Age=	v1_1}', "");
    Expect(0, 65536, '\P{^Age=	v1_1}', "");
    Error('\p{Is_Age=:=	 000000001.1}');
    Error('\P{Is_Age=:=	 000000001.1}');
    Expect(1, 65533, '\p{Is_Age=+0_1.1}', "");
    Expect(0, 65533, '\p{^Is_Age=+0_1.1}', "");
    Expect(0, 65533, '\P{Is_Age=+0_1.1}', "");
    Expect(1, 65533, '\P{^Is_Age=+0_1.1}', "");
    Expect(0, 65536, '\p{Is_Age=+0_1.1}', "");
    Expect(1, 65536, '\p{^Is_Age=+0_1.1}', "");
    Expect(1, 65536, '\P{Is_Age=+0_1.1}', "");
    Expect(0, 65536, '\P{^Is_Age=+0_1.1}', "");
    Error('\p{Age=		v10_0:=}');
    Error('\P{Age=		v10_0:=}');
    Expect(1, 191456, '\p{Age=:\AV10_0\z:}', "");;
    Expect(0, 191457, '\p{Age=:\AV10_0\z:}', "");;
    Expect(1, 191456, '\p{Age=v100}', "");
    Expect(0, 191456, '\p{^Age=v100}', "");
    Expect(0, 191456, '\P{Age=v100}', "");
    Expect(1, 191456, '\P{^Age=v100}', "");
    Expect(0, 191457, '\p{Age=v100}', "");
    Expect(1, 191457, '\p{^Age=v100}', "");
    Expect(1, 191457, '\P{Age=v100}', "");
    Expect(0, 191457, '\P{^Age=v100}', "");
    Expect(1, 191456, '\p{Age=:\Av100\z:}', "");;
    Expect(0, 191457, '\p{Age=:\Av100\z:}', "");;
    Expect(1, 191456, '\p{Age=	-V10_0}', "");
    Expect(0, 191456, '\p{^Age=	-V10_0}', "");
    Expect(0, 191456, '\P{Age=	-V10_0}', "");
    Expect(1, 191456, '\P{^Age=	-V10_0}', "");
    Expect(0, 191457, '\p{Age=	-V10_0}', "");
    Expect(1, 191457, '\p{^Age=	-V10_0}', "");
    Expect(1, 191457, '\P{Age=	-V10_0}', "");
    Expect(0, 191457, '\P{^Age=	-V10_0}', "");
    Error('\p{Is_Age:   __0_0_0_0_0_0_0010.0/a/}');
    Error('\P{Is_Age:   __0_0_0_0_0_0_0010.0/a/}');
    Expect(1, 191456, '\p{Is_Age=0000010.0}', "");
    Expect(0, 191456, '\p{^Is_Age=0000010.0}', "");
    Expect(0, 191456, '\P{Is_Age=0000010.0}', "");
    Expect(1, 191456, '\P{^Is_Age=0000010.0}', "");
    Expect(0, 191457, '\p{Is_Age=0000010.0}', "");
    Expect(1, 191457, '\p{^Is_Age=0000010.0}', "");
    Expect(1, 191457, '\P{Is_Age=0000010.0}', "");
    Expect(0, 191457, '\P{^Is_Age=0000010.0}', "");
    Error('\p{Age=/a/V11_0}');
    Error('\P{Age=/a/V11_0}');
    Expect(1, 129645, '\p{Age=:\AV11_0\z:}', "");;
    Expect(0, 129646, '\p{Age=:\AV11_0\z:}', "");;
    Expect(1, 129645, '\p{Age=v110}', "");
    Expect(0, 129645, '\p{^Age=v110}', "");
    Expect(0, 129645, '\P{Age=v110}', "");
    Expect(1, 129645, '\P{^Age=v110}', "");
    Expect(0, 129646, '\p{Age=v110}', "");
    Expect(1, 129646, '\p{^Age=v110}', "");
    Expect(1, 129646, '\P{Age=v110}', "");
    Expect(0, 129646, '\P{^Age=v110}', "");
    Expect(1, 129645, '\p{Age=:\Av110\z:}', "");;
    Expect(0, 129646, '\p{Age=:\Av110\z:}', "");;
    Expect(1, 129645, '\p{Age= _V11_0}', "");
    Expect(0, 129645, '\p{^Age= _V11_0}', "");
    Expect(0, 129645, '\P{Age= _V11_0}', "");
    Expect(1, 129645, '\P{^Age= _V11_0}', "");
    Expect(0, 129646, '\p{Age= _V11_0}', "");
    Expect(1, 129646, '\p{^Age= _V11_0}', "");
    Expect(1, 129646, '\P{Age= _V11_0}', "");
    Expect(0, 129646, '\P{^Age= _V11_0}', "");
    Error('\p{Is_Age=_ +0000011.0:=}');
    Error('\P{Is_Age=_ +0000011.0:=}');
    Expect(1, 129645, '\p{Is_Age=1_1.0}', "");
    Expect(0, 129645, '\p{^Is_Age=1_1.0}', "");
    Expect(0, 129645, '\P{Is_Age=1_1.0}', "");
    Expect(1, 129645, '\P{^Is_Age=1_1.0}', "");
    Expect(0, 129646, '\p{Is_Age=1_1.0}', "");
    Expect(1, 129646, '\p{^Is_Age=1_1.0}', "");
    Expect(1, 129646, '\P{Is_Age=1_1.0}', "");
    Expect(0, 129646, '\P{^Is_Age=1_1.0}', "");
    Error('\p{Age= V12_0:=}');
    Error('\P{Age= V12_0:=}');
    Expect(1, 129685, '\p{Age=:\AV12_0\z:}', "");;
    Expect(0, 129686, '\p{Age=:\AV12_0\z:}', "");;
    Expect(1, 129685, '\p{Age=v120}', "");
    Expect(0, 129685, '\p{^Age=v120}', "");
    Expect(0, 129685, '\P{Age=v120}', "");
    Expect(1, 129685, '\P{^Age=v120}', "");
    Expect(0, 129686, '\p{Age=v120}', "");
    Expect(1, 129686, '\p{^Age=v120}', "");
    Expect(1, 129686, '\P{Age=v120}', "");
    Expect(0, 129686, '\P{^Age=v120}', "");
    Expect(1, 129685, '\p{Age=:\Av120\z:}', "");;
    Expect(0, 129686, '\p{Age=:\Av120\z:}', "");;
    Expect(1, 129685, '\p{Age= _V12_0}', "");
    Expect(0, 129685, '\p{^Age= _V12_0}', "");
    Expect(0, 129685, '\P{Age= _V12_0}', "");
    Expect(1, 129685, '\P{^Age= _V12_0}', "");
    Expect(0, 129686, '\p{Age= _V12_0}', "");
    Expect(1, 129686, '\p{^Age= _V12_0}', "");
    Expect(1, 129686, '\P{Age= _V12_0}', "");
    Expect(0, 129686, '\P{^Age= _V12_0}', "");
    Error('\p{Is_Age=/a/		0000000012.0}');
    Error('\P{Is_Age=/a/		0000000012.0}');
    Expect(1, 129685, '\p{Is_Age=00_00_01_2.0}', "");
    Expect(0, 129685, '\p{^Is_Age=00_00_01_2.0}', "");
    Expect(0, 129685, '\P{Is_Age=00_00_01_2.0}', "");
    Expect(1, 129685, '\P{^Is_Age=00_00_01_2.0}', "");
    Expect(0, 129686, '\p{Is_Age=00_00_01_2.0}', "");
    Expect(1, 129686, '\p{^Is_Age=00_00_01_2.0}', "");
    Expect(1, 129686, '\P{Is_Age=00_00_01_2.0}', "");
    Expect(0, 129686, '\P{^Is_Age=00_00_01_2.0}', "");
    Error('\p{Age=_V12_1/a/}');
    Error('\P{Age=_V12_1/a/}');
    Expect(1, 13055, '\p{Age=:\AV12_1\z:}', "");;
    Expect(0, 13056, '\p{Age=:\AV12_1\z:}', "");;
    Expect(1, 13055, '\p{Age=v121}', "");
    Expect(0, 13055, '\p{^Age=v121}', "");
    Expect(0, 13055, '\P{Age=v121}', "");
    Expect(1, 13055, '\P{^Age=v121}', "");
    Expect(0, 13056, '\p{Age=v121}', "");
    Expect(1, 13056, '\p{^Age=v121}', "");
    Expect(1, 13056, '\P{Age=v121}', "");
    Expect(0, 13056, '\P{^Age=v121}', "");
    Expect(1, 13055, '\p{Age=:\Av121\z:}', "");;
    Expect(0, 13056, '\p{Age=:\Av121\z:}', "");;
    Expect(1, 13055, '\p{Age= 	V12_1}', "");
    Expect(0, 13055, '\p{^Age= 	V12_1}', "");
    Expect(0, 13055, '\P{Age= 	V12_1}', "");
    Expect(1, 13055, '\P{^Age= 	V12_1}', "");
    Expect(0, 13056, '\p{Age= 	V12_1}', "");
    Expect(1, 13056, '\p{^Age= 	V12_1}', "");
    Expect(1, 13056, '\P{Age= 	V12_1}', "");
    Expect(0, 13056, '\P{^Age= 	V12_1}', "");
    Error('\p{Is_Age=:=-+012.1}');
    Error('\P{Is_Age=:=-+012.1}');
    Expect(1, 13055, '\p{Is_Age=000000012.1}', "");
    Expect(0, 13055, '\p{^Is_Age=000000012.1}', "");
    Expect(0, 13055, '\P{Is_Age=000000012.1}', "");
    Expect(1, 13055, '\P{^Is_Age=000000012.1}', "");
    Expect(0, 13056, '\p{Is_Age=000000012.1}', "");
    Expect(1, 13056, '\p{^Is_Age=000000012.1}', "");
    Expect(1, 13056, '\P{Is_Age=000000012.1}', "");
    Expect(0, 13056, '\P{^Is_Age=000000012.1}', "");
    Error('\p{Age=--V13_0/a/}');
    Error('\P{Age=--V13_0/a/}');
    Expect(1, 201546, '\p{Age=:\AV13_0\z:}', "");;
    Expect(0, 201547, '\p{Age=:\AV13_0\z:}', "");;
    Expect(1, 201546, '\p{Age=v130}', "");
    Expect(0, 201546, '\p{^Age=v130}', "");
    Expect(0, 201546, '\P{Age=v130}', "");
    Expect(1, 201546, '\P{^Age=v130}', "");
    Expect(0, 201547, '\p{Age=v130}', "");
    Expect(1, 201547, '\p{^Age=v130}', "");
    Expect(1, 201547, '\P{Age=v130}', "");
    Expect(0, 201547, '\P{^Age=v130}', "");
    Expect(1, 201546, '\p{Age=:\Av130\z:}', "");;
    Expect(0, 201547, '\p{Age=:\Av130\z:}', "");;
    Expect(1, 201546, '\p{Age= V13_0}', "");
    Expect(0, 201546, '\p{^Age= V13_0}', "");
    Expect(0, 201546, '\P{Age= V13_0}', "");
    Expect(1, 201546, '\P{^Age= V13_0}', "");
    Expect(0, 201547, '\p{Age= V13_0}', "");
    Expect(1, 201547, '\p{^Age= V13_0}', "");
    Expect(1, 201547, '\P{Age= V13_0}', "");
    Expect(0, 201547, '\P{^Age= V13_0}', "");
    Error('\p{Is_Age=	01_3.0/a/}');
    Error('\P{Is_Age=	01_3.0/a/}');
    Expect(1, 201546, '\p{Is_Age=+00000013.0}', "");
    Expect(0, 201546, '\p{^Is_Age=+00000013.0}', "");
    Expect(0, 201546, '\P{Is_Age=+00000013.0}', "");
    Expect(1, 201546, '\P{^Is_Age=+00000013.0}', "");
    Expect(0, 201547, '\p{Is_Age=+00000013.0}', "");
    Expect(1, 201547, '\p{^Is_Age=+00000013.0}', "");
    Expect(1, 201547, '\P{Is_Age=+00000013.0}', "");
    Expect(0, 201547, '\P{^Is_Age=+00000013.0}', "");
    Error('\p{Age=	V14_0/a/}');
    Error('\P{Age=	V14_0/a/}');
    Expect(1, 177976, '\p{Age=:\AV14_0\z:}', "");;
    Expect(0, 177977, '\p{Age=:\AV14_0\z:}', "");;
    Expect(1, 177976, '\p{Age=v140}', "");
    Expect(0, 177976, '\p{^Age=v140}', "");
    Expect(0, 177976, '\P{Age=v140}', "");
    Expect(1, 177976, '\P{^Age=v140}', "");
    Expect(0, 177977, '\p{Age=v140}', "");
    Expect(1, 177977, '\p{^Age=v140}', "");
    Expect(1, 177977, '\P{Age=v140}', "");
    Expect(0, 177977, '\P{^Age=v140}', "");
    Expect(1, 177976, '\p{Age=:\Av140\z:}', "");;
    Expect(0, 177977, '\p{Age=:\Av140\z:}', "");;
    Expect(1, 177976, '\p{Age=  V14_0}', "");
    Expect(0, 177976, '\p{^Age=  V14_0}', "");
    Expect(0, 177976, '\P{Age=  V14_0}', "");
    Expect(1, 177976, '\P{^Age=  V14_0}', "");
    Expect(0, 177977, '\p{Age=  V14_0}', "");
    Expect(1, 177977, '\p{^Age=  V14_0}', "");
    Expect(1, 177977, '\P{Age=  V14_0}', "");
    Expect(0, 177977, '\P{^Age=  V14_0}', "");
    Error('\p{Is_Age=:=	-+00000014.0}');
    Error('\P{Is_Age=:=	-+00000014.0}');
    Expect(1, 177976, '\p{Is_Age=0_0_0_0_0014.0}', "");
    Expect(0, 177976, '\p{^Is_Age=0_0_0_0_0014.0}', "");
    Expect(0, 177976, '\P{Is_Age=0_0_0_0_0014.0}', "");
    Expect(1, 177976, '\P{^Is_Age=0_0_0_0_0014.0}', "");
    Expect(0, 177977, '\p{Is_Age=0_0_0_0_0014.0}', "");
    Expect(1, 177977, '\p{^Is_Age=0_0_0_0_0014.0}', "");
    Expect(1, 177977, '\P{Is_Age=0_0_0_0_0014.0}', "");
    Expect(0, 177977, '\P{^Is_Age=0_0_0_0_0014.0}', "");
    Error('\p{Age= :=V15_0}');
    Error('\P{Age= :=V15_0}');
    Expect(1, 205743, '\p{Age=:\AV15_0\z:}', "");;
    Expect(0, 205744, '\p{Age=:\AV15_0\z:}', "");;
    Expect(1, 205743, '\p{Age=v150}', "");
    Expect(0, 205743, '\p{^Age=v150}', "");
    Expect(0, 205743, '\P{Age=v150}', "");
    Expect(1, 205743, '\P{^Age=v150}', "");
    Expect(0, 205744, '\p{Age=v150}', "");
    Expect(1, 205744, '\p{^Age=v150}', "");
    Expect(1, 205744, '\P{Age=v150}', "");
    Expect(0, 205744, '\P{^Age=v150}', "");
    Expect(1, 205743, '\p{Age=:\Av150\z:}', "");;
    Expect(0, 205744, '\p{Age=:\Av150\z:}', "");;
    Expect(1, 205743, '\p{Age=V15_0}', "");
    Expect(0, 205743, '\p{^Age=V15_0}', "");
    Expect(0, 205743, '\P{Age=V15_0}', "");
    Expect(1, 205743, '\P{^Age=V15_0}', "");
    Expect(0, 205744, '\p{Age=V15_0}', "");
    Expect(1, 205744, '\p{^Age=V15_0}', "");
    Expect(1, 205744, '\P{Age=V15_0}', "");
    Expect(0, 205744, '\P{^Age=V15_0}', "");
    Error('\p{Is_Age=/a/ -+00000015.0}');
    Error('\P{Is_Age=/a/ -+00000015.0}');
    Expect(1, 205743, '\p{Is_Age=1_5.0}', "");
    Expect(0, 205743, '\p{^Is_Age=1_5.0}', "");
    Expect(0, 205743, '\P{Is_Age=1_5.0}', "");
    Expect(1, 205743, '\P{^Is_Age=1_5.0}', "");
    Expect(0, 205744, '\p{Is_Age=1_5.0}', "");
    Expect(1, 205744, '\p{^Is_Age=1_5.0}', "");
    Expect(1, 205744, '\P{Is_Age=1_5.0}', "");
    Expect(0, 205744, '\P{^Is_Age=1_5.0}', "");
    Error('\p{Age=-	v2_0:=}');
    Error('\P{Age=-	v2_0:=}');
    Expect(1, 983040, '\p{Age=:\AV2_0\z:}', "");;
    Expect(0, 983037, '\p{Age=:\AV2_0\z:}', "");;
    Expect(1, 983040, '\p{Age=v20}', "");
    Expect(0, 983040, '\p{^Age=v20}', "");
    Expect(0, 983040, '\P{Age=v20}', "");
    Expect(1, 983040, '\P{^Age=v20}', "");
    Expect(0, 983037, '\p{Age=v20}', "");
    Expect(1, 983037, '\p{^Age=v20}', "");
    Expect(1, 983037, '\P{Age=v20}', "");
    Expect(0, 983037, '\P{^Age=v20}', "");
    Expect(1, 983040, '\p{Age=:\Av20\z:}', "");;
    Expect(0, 983037, '\p{Age=:\Av20\z:}', "");;
    Expect(1, 983040, '\p{Age=_	V2_0}', "");
    Expect(0, 983040, '\p{^Age=_	V2_0}', "");
    Expect(0, 983040, '\P{Age=_	V2_0}', "");
    Expect(1, 983040, '\P{^Age=_	V2_0}', "");
    Expect(0, 983037, '\p{Age=_	V2_0}', "");
    Expect(1, 983037, '\p{^Age=_	V2_0}', "");
    Expect(1, 983037, '\P{Age=_	V2_0}', "");
    Expect(0, 983037, '\P{^Age=_	V2_0}', "");
    Error('\p{Is_Age:/a/- +000002.0}');
    Error('\P{Is_Age:/a/- +000002.0}');
    Expect(1, 983040, '\p{Is_Age=+2.0}', "");
    Expect(0, 983040, '\p{^Is_Age=+2.0}', "");
    Expect(0, 983040, '\P{Is_Age=+2.0}', "");
    Expect(1, 983040, '\P{^Is_Age=+2.0}', "");
    Expect(0, 983037, '\p{Is_Age=+2.0}', "");
    Expect(1, 983037, '\p{^Is_Age=+2.0}', "");
    Expect(1, 983037, '\P{Is_Age=+2.0}', "");
    Expect(0, 983037, '\P{^Is_Age=+2.0}', "");
    Error('\p{Age=__V2_1/a/}');
    Error('\P{Age=__V2_1/a/}');
    Expect(1, 65532, '\p{Age=:\AV2_1\z:}', "");;
    Expect(0, 65533, '\p{Age=:\AV2_1\z:}', "");;
    Expect(1, 65532, '\p{Age=v21}', "");
    Expect(0, 65532, '\p{^Age=v21}', "");
    Expect(0, 65532, '\P{Age=v21}', "");
    Expect(1, 65532, '\P{^Age=v21}', "");
    Expect(0, 65533, '\p{Age=v21}', "");
    Expect(1, 65533, '\p{^Age=v21}', "");
    Expect(1, 65533, '\P{Age=v21}', "");
    Expect(0, 65533, '\P{^Age=v21}', "");
    Expect(1, 65532, '\p{Age=:\Av21\z:}', "");;
    Expect(0, 65533, '\p{Age=:\Av21\z:}', "");;
    Expect(1, 65532, '\p{Age=__V2_1}', "");
    Expect(0, 65532, '\p{^Age=__V2_1}', "");
    Expect(0, 65532, '\P{Age=__V2_1}', "");
    Expect(1, 65532, '\P{^Age=__V2_1}', "");
    Expect(0, 65533, '\p{Age=__V2_1}', "");
    Expect(1, 65533, '\p{^Age=__V2_1}', "");
    Expect(1, 65533, '\P{Age=__V2_1}', "");
    Expect(0, 65533, '\P{^Age=__V2_1}', "");
    Error('\p{Is_Age=:=00000002.1}');
    Error('\P{Is_Age=:=00000002.1}');
    Expect(1, 65532, '\p{Is_Age=0_2.1}', "");
    Expect(0, 65532, '\p{^Is_Age=0_2.1}', "");
    Expect(0, 65532, '\P{Is_Age=0_2.1}', "");
    Expect(1, 65532, '\P{^Is_Age=0_2.1}', "");
    Expect(0, 65533, '\p{Is_Age=0_2.1}', "");
    Expect(1, 65533, '\p{^Is_Age=0_2.1}', "");
    Expect(1, 65533, '\P{Is_Age=0_2.1}', "");
    Expect(0, 65533, '\P{^Is_Age=0_2.1}', "");
    Error('\p{Age=/a/  V3_0}');
    Error('\P{Age=/a/  V3_0}');
    Expect(1, 65531, '\p{Age=:\AV3_0\z:}', "");;
    Expect(0, 65532, '\p{Age=:\AV3_0\z:}', "");;
    Expect(1, 65531, '\p{Age=v30}', "");
    Expect(0, 65531, '\p{^Age=v30}', "");
    Expect(0, 65531, '\P{Age=v30}', "");
    Expect(1, 65531, '\P{^Age=v30}', "");
    Expect(0, 65532, '\p{Age=v30}', "");
    Expect(1, 65532, '\p{^Age=v30}', "");
    Expect(1, 65532, '\P{Age=v30}', "");
    Expect(0, 65532, '\P{^Age=v30}', "");
    Expect(1, 65531, '\p{Age=:\Av30\z:}', "");;
    Expect(0, 65532, '\p{Age=:\Av30\z:}', "");;
    Expect(1, 65531, '\p{Age=-_V3_0}', "");
    Expect(0, 65531, '\p{^Age=-_V3_0}', "");
    Expect(0, 65531, '\P{Age=-_V3_0}', "");
    Expect(1, 65531, '\P{^Age=-_V3_0}', "");
    Expect(0, 65532, '\p{Age=-_V3_0}', "");
    Expect(1, 65532, '\p{^Age=-_V3_0}', "");
    Expect(1, 65532, '\P{Age=-_V3_0}', "");
    Expect(0, 65532, '\P{^Age=-_V3_0}', "");
    Error('\p{Is_Age:		:=0000000003.0}');
    Error('\P{Is_Age:		:=0000000003.0}');
    Expect(1, 65531, '\p{Is_Age=0_3.0}', "");
    Expect(0, 65531, '\p{^Is_Age=0_3.0}', "");
    Expect(0, 65531, '\P{Is_Age=0_3.0}', "");
    Expect(1, 65531, '\P{^Is_Age=0_3.0}', "");
    Expect(0, 65532, '\p{Is_Age=0_3.0}', "");
    Expect(1, 65532, '\p{^Is_Age=0_3.0}', "");
    Expect(1, 65532, '\P{Is_Age=0_3.0}', "");
    Expect(0, 65532, '\P{^Is_Age=0_3.0}', "");
    Error('\p{Age=-:=V3_1}');
    Error('\P{Age=-:=V3_1}');
    Expect(1, 917631, '\p{Age=:\AV3_1\z:}', "");;
    Expect(0, 917632, '\p{Age=:\AV3_1\z:}', "");;
    Expect(1, 917631, '\p{Age=v31}', "");
    Expect(0, 917631, '\p{^Age=v31}', "");
    Expect(0, 917631, '\P{Age=v31}', "");
    Expect(1, 917631, '\P{^Age=v31}', "");
    Expect(0, 917632, '\p{Age=v31}', "");
    Expect(1, 917632, '\p{^Age=v31}', "");
    Expect(1, 917632, '\P{Age=v31}', "");
    Expect(0, 917632, '\P{^Age=v31}', "");
    Expect(1, 917631, '\p{Age=:\Av31\z:}', "");;
    Expect(0, 917632, '\p{Age=:\Av31\z:}', "");;
    Expect(1, 917631, '\p{Age=		v3_1}', "");
    Expect(0, 917631, '\p{^Age=		v3_1}', "");
    Expect(0, 917631, '\P{Age=		v3_1}', "");
    Expect(1, 917631, '\P{^Age=		v3_1}', "");
    Expect(0, 917632, '\p{Age=		v3_1}', "");
    Expect(1, 917632, '\p{^Age=		v3_1}', "");
    Expect(1, 917632, '\P{Age=		v3_1}', "");
    Expect(0, 917632, '\P{^Age=		v3_1}', "");
    Error('\p{Is_Age=		0_0_0_0_0_03.1/a/}');
    Error('\P{Is_Age=		0_0_0_0_0_03.1/a/}');
    Expect(1, 917631, '\p{Is_Age=0003.1}', "");
    Expect(0, 917631, '\p{^Is_Age=0003.1}', "");
    Expect(0, 917631, '\P{Is_Age=0003.1}', "");
    Expect(1, 917631, '\P{^Is_Age=0003.1}', "");
    Expect(0, 917632, '\p{Is_Age=0003.1}', "");
    Expect(1, 917632, '\p{^Is_Age=0003.1}', "");
    Expect(1, 917632, '\P{Is_Age=0003.1}', "");
    Expect(0, 917632, '\P{^Is_Age=0003.1}', "");
    Error('\p{Age=:=	V3_2}');
    Error('\P{Age=:=	V3_2}');
    Expect(1, 65376, '\p{Age=:\AV3_2\z:}', "");;
    Expect(0, 65377, '\p{Age=:\AV3_2\z:}', "");;
    Expect(1, 65376, '\p{Age:	v32}', "");
    Expect(0, 65376, '\p{^Age:	v32}', "");
    Expect(0, 65376, '\P{Age:	v32}', "");
    Expect(1, 65376, '\P{^Age:	v32}', "");
    Expect(0, 65377, '\p{Age:	v32}', "");
    Expect(1, 65377, '\p{^Age:	v32}', "");
    Expect(1, 65377, '\P{Age:	v32}', "");
    Expect(0, 65377, '\P{^Age:	v32}', "");
    Expect(1, 65376, '\p{Age=:\Av32\z:}', "");;
    Expect(0, 65377, '\p{Age=:\Av32\z:}', "");;
    Expect(1, 65376, '\p{Age= -v3_2}', "");
    Expect(0, 65376, '\p{^Age= -v3_2}', "");
    Expect(0, 65376, '\P{Age= -v3_2}', "");
    Expect(1, 65376, '\P{^Age= -v3_2}', "");
    Expect(0, 65377, '\p{Age= -v3_2}', "");
    Expect(1, 65377, '\p{^Age= -v3_2}', "");
    Expect(1, 65377, '\P{Age= -v3_2}', "");
    Expect(0, 65377, '\P{^Age= -v3_2}', "");
    Error('\p{Is_Age=_0_3.2:=}');
    Error('\P{Is_Age=_0_3.2:=}');
    Expect(1, 65376, '\p{Is_Age=+00003.2}', "");
    Expect(0, 65376, '\p{^Is_Age=+00003.2}', "");
    Expect(0, 65376, '\P{Is_Age=+00003.2}', "");
    Expect(1, 65376, '\P{^Is_Age=+00003.2}', "");
    Expect(0, 65377, '\p{Is_Age=+00003.2}', "");
    Expect(1, 65377, '\p{^Is_Age=+00003.2}', "");
    Expect(1, 65377, '\P{Is_Age=+00003.2}', "");
    Expect(0, 65377, '\P{^Is_Age=+00003.2}', "");
    Error('\p{Age=:=_V4_0}');
    Error('\P{Age=:=_V4_0}');
    Expect(1, 917999, '\p{Age=:\AV4_0\z:}', "");;
    Expect(0, 918000, '\p{Age=:\AV4_0\z:}', "");;
    Expect(1, 917999, '\p{Age:	v40}', "");
    Expect(0, 917999, '\p{^Age:	v40}', "");
    Expect(0, 917999, '\P{Age:	v40}', "");
    Expect(1, 917999, '\P{^Age:	v40}', "");
    Expect(0, 918000, '\p{Age:	v40}', "");
    Expect(1, 918000, '\p{^Age:	v40}', "");
    Expect(1, 918000, '\P{Age:	v40}', "");
    Expect(0, 918000, '\P{^Age:	v40}', "");
    Expect(1, 917999, '\p{Age=:\Av40\z:}', "");;
    Expect(0, 918000, '\p{Age=:\Av40\z:}', "");;
    Expect(1, 917999, '\p{Age=		v4_0}', "");
    Expect(0, 917999, '\p{^Age=		v4_0}', "");
    Expect(0, 917999, '\P{Age=		v4_0}', "");
    Expect(1, 917999, '\P{^Age=		v4_0}', "");
    Expect(0, 918000, '\p{Age=		v4_0}', "");
    Expect(1, 918000, '\p{^Age=		v4_0}', "");
    Expect(1, 918000, '\P{Age=		v4_0}', "");
    Expect(0, 918000, '\P{^Age=		v4_0}', "");
    Error('\p{Is_Age=:=00_4.0}');
    Error('\P{Is_Age=:=00_4.0}');
    Expect(1, 917999, '\p{Is_Age=00_00_4.0}', "");
    Expect(0, 917999, '\p{^Is_Age=00_00_4.0}', "");
    Expect(0, 917999, '\P{Is_Age=00_00_4.0}', "");
    Expect(1, 917999, '\P{^Is_Age=00_00_4.0}', "");
    Expect(0, 918000, '\p{Is_Age=00_00_4.0}', "");
    Expect(1, 918000, '\p{^Is_Age=00_00_4.0}', "");
    Expect(1, 918000, '\P{Is_Age=00_00_4.0}', "");
    Expect(0, 918000, '\P{^Is_Age=00_00_4.0}', "");
    Error('\p{Age:/a/_V4_1}');
    Error('\P{Age:/a/_V4_1}');
    Expect(1, 120485, '\p{Age=:\AV4_1\z:}', "");;
    Expect(0, 120486, '\p{Age=:\AV4_1\z:}', "");;
    Expect(1, 120485, '\p{Age=v41}', "");
    Expect(0, 120485, '\p{^Age=v41}', "");
    Expect(0, 120485, '\P{Age=v41}', "");
    Expect(1, 120485, '\P{^Age=v41}', "");
    Expect(0, 120486, '\p{Age=v41}', "");
    Expect(1, 120486, '\p{^Age=v41}', "");
    Expect(1, 120486, '\P{Age=v41}', "");
    Expect(0, 120486, '\P{^Age=v41}', "");
    Expect(1, 120485, '\p{Age=:\Av41\z:}', "");;
    Expect(0, 120486, '\p{Age=:\Av41\z:}', "");;
    Expect(1, 120485, '\p{Age=	-V4_1}', "");
    Expect(0, 120485, '\p{^Age=	-V4_1}', "");
    Expect(0, 120485, '\P{Age=	-V4_1}', "");
    Expect(1, 120485, '\P{^Age=	-V4_1}', "");
    Expect(0, 120486, '\p{Age=	-V4_1}', "");
    Expect(1, 120486, '\p{^Age=	-V4_1}', "");
    Expect(1, 120486, '\P{Age=	-V4_1}', "");
    Expect(0, 120486, '\P{^Age=	-V4_1}', "");
    Error('\p{Is_Age=/a/-_+0_4.1}');
    Error('\P{Is_Age=/a/-_+0_4.1}');
    Expect(1, 120485, '\p{Is_Age=+00_00_00_004.1}', "");
    Expect(0, 120485, '\p{^Is_Age=+00_00_00_004.1}', "");
    Expect(0, 120485, '\P{Is_Age=+00_00_00_004.1}', "");
    Expect(1, 120485, '\P{^Is_Age=+00_00_00_004.1}', "");
    Expect(0, 120486, '\p{Is_Age=+00_00_00_004.1}', "");
    Expect(1, 120486, '\p{^Is_Age=+00_00_00_004.1}', "");
    Expect(1, 120486, '\P{Is_Age=+00_00_00_004.1}', "");
    Expect(0, 120486, '\P{^Is_Age=+00_00_00_004.1}', "");
    Error('\p{Age=V5_0:=}');
    Error('\P{Age=V5_0:=}');
    Expect(1, 120779, '\p{Age=:\AV5_0\z:}', "");;
    Expect(0, 120780, '\p{Age=:\AV5_0\z:}', "");;
    Expect(1, 120779, '\p{Age=v50}', "");
    Expect(0, 120779, '\p{^Age=v50}', "");
    Expect(0, 120779, '\P{Age=v50}', "");
    Expect(1, 120779, '\P{^Age=v50}', "");
    Expect(0, 120780, '\p{Age=v50}', "");
    Expect(1, 120780, '\p{^Age=v50}', "");
    Expect(1, 120780, '\P{Age=v50}', "");
    Expect(0, 120780, '\P{^Age=v50}', "");
    Expect(1, 120779, '\p{Age=:\Av50\z:}', "");;
    Expect(0, 120780, '\p{Age=:\Av50\z:}', "");;
    Expect(1, 120779, '\p{Age=	V5_0}', "");
    Expect(0, 120779, '\p{^Age=	V5_0}', "");
    Expect(0, 120779, '\P{Age=	V5_0}', "");
    Expect(1, 120779, '\P{^Age=	V5_0}', "");
    Expect(0, 120780, '\p{Age=	V5_0}', "");
    Expect(1, 120780, '\p{^Age=	V5_0}', "");
    Expect(1, 120780, '\P{Age=	V5_0}', "");
    Expect(0, 120780, '\P{^Age=	V5_0}', "");
    Error('\p{Is_Age=/a/		5.0}');
    Error('\P{Is_Age=/a/		5.0}');
    Expect(1, 120779, '\p{Is_Age=0_0_0_05.0}', "");
    Expect(0, 120779, '\p{^Is_Age=0_0_0_05.0}', "");
    Expect(0, 120779, '\P{Is_Age=0_0_0_05.0}', "");
    Expect(1, 120779, '\P{^Is_Age=0_0_0_05.0}', "");
    Expect(0, 120780, '\p{Is_Age=0_0_0_05.0}', "");
    Expect(1, 120780, '\p{^Is_Age=0_0_0_05.0}', "");
    Expect(1, 120780, '\P{Is_Age=0_0_0_05.0}', "");
    Expect(0, 120780, '\P{^Is_Age=0_0_0_05.0}', "");
    Error('\p{Age=	:=V5_1}');
    Error('\P{Age=	:=V5_1}');
    Expect(1, 127123, '\p{Age=:\AV5_1\z:}', "");;
    Expect(0, 127124, '\p{Age=:\AV5_1\z:}', "");;
    Expect(1, 127123, '\p{Age: v51}', "");
    Expect(0, 127123, '\p{^Age: v51}', "");
    Expect(0, 127123, '\P{Age: v51}', "");
    Expect(1, 127123, '\P{^Age: v51}', "");
    Expect(0, 127124, '\p{Age: v51}', "");
    Expect(1, 127124, '\p{^Age: v51}', "");
    Expect(1, 127124, '\P{Age: v51}', "");
    Expect(0, 127124, '\P{^Age: v51}', "");
    Expect(1, 127123, '\p{Age=:\Av51\z:}', "");;
    Expect(0, 127124, '\p{Age=:\Av51\z:}', "");;
    Expect(1, 127123, '\p{Age= _V5_1}', "");
    Expect(0, 127123, '\p{^Age= _V5_1}', "");
    Expect(0, 127123, '\P{Age= _V5_1}', "");
    Expect(1, 127123, '\P{^Age= _V5_1}', "");
    Expect(0, 127124, '\p{Age= _V5_1}', "");
    Expect(1, 127124, '\p{^Age= _V5_1}', "");
    Expect(1, 127124, '\P{Age= _V5_1}', "");
    Expect(0, 127124, '\P{^Age= _V5_1}', "");
    Error('\p{Is_Age=_+000005.1:=}');
    Error('\P{Is_Age=_+000005.1:=}');
    Expect(1, 127123, '\p{Is_Age=+0000000005.1}', "");
    Expect(0, 127123, '\p{^Is_Age=+0000000005.1}', "");
    Expect(0, 127123, '\P{Is_Age=+0000000005.1}', "");
    Expect(1, 127123, '\P{^Is_Age=+0000000005.1}', "");
    Expect(0, 127124, '\p{Is_Age=+0000000005.1}', "");
    Expect(1, 127124, '\p{^Is_Age=+0000000005.1}', "");
    Expect(1, 127124, '\P{Is_Age=+0000000005.1}', "");
    Expect(0, 127124, '\P{^Is_Age=+0000000005.1}', "");
    Error('\p{Age:		/a/V5_2}');
    Error('\P{Age:		/a/V5_2}');
    Expect(1, 177972, '\p{Age=:\AV5_2\z:}', "");;
    Expect(0, 177973, '\p{Age=:\AV5_2\z:}', "");;
    Expect(1, 177972, '\p{Age=v52}', "");
    Expect(0, 177972, '\p{^Age=v52}', "");
    Expect(0, 177972, '\P{Age=v52}', "");
    Expect(1, 177972, '\P{^Age=v52}', "");
    Expect(0, 177973, '\p{Age=v52}', "");
    Expect(1, 177973, '\p{^Age=v52}', "");
    Expect(1, 177973, '\P{Age=v52}', "");
    Expect(0, 177973, '\P{^Age=v52}', "");
    Expect(1, 177972, '\p{Age=:\Av52\z:}', "");;
    Expect(0, 177973, '\p{Age=:\Av52\z:}', "");;
    Expect(1, 177972, '\p{Age=_ v5_2}', "");
    Expect(0, 177972, '\p{^Age=_ v5_2}', "");
    Expect(0, 177972, '\P{Age=_ v5_2}', "");
    Expect(1, 177972, '\P{^Age=_ v5_2}', "");
    Expect(0, 177973, '\p{Age=_ v5_2}', "");
    Expect(1, 177973, '\p{^Age=_ v5_2}', "");
    Expect(1, 177973, '\P{Age=_ v5_2}', "");
    Expect(0, 177973, '\P{^Age=_ v5_2}', "");
    Error('\p{Is_Age=- +00_5.2:=}');
    Error('\P{Is_Age=- +00_5.2:=}');
    Expect(1, 177972, '\p{Is_Age:	0_5.2}', "");
    Expect(0, 177972, '\p{^Is_Age:	0_5.2}', "");
    Expect(0, 177972, '\P{Is_Age:	0_5.2}', "");
    Expect(1, 177972, '\P{^Is_Age:	0_5.2}', "");
    Expect(0, 177973, '\p{Is_Age:	0_5.2}', "");
    Expect(1, 177973, '\p{^Is_Age:	0_5.2}', "");
    Expect(1, 177973, '\P{Is_Age:	0_5.2}', "");
    Expect(0, 177973, '\P{^Is_Age:	0_5.2}', "");
    Error('\p{Age=/a/V6_0}');
    Error('\P{Age=/a/V6_0}');
    Expect(1, 178205, '\p{Age=:\AV6_0\z:}', "");;
    Expect(0, 178206, '\p{Age=:\AV6_0\z:}', "");;
    Expect(1, 178205, '\p{Age=v60}', "");
    Expect(0, 178205, '\p{^Age=v60}', "");
    Expect(0, 178205, '\P{Age=v60}', "");
    Expect(1, 178205, '\P{^Age=v60}', "");
    Expect(0, 178206, '\p{Age=v60}', "");
    Expect(1, 178206, '\p{^Age=v60}', "");
    Expect(1, 178206, '\P{Age=v60}', "");
    Expect(0, 178206, '\P{^Age=v60}', "");
    Expect(1, 178205, '\p{Age=:\Av60\z:}', "");;
    Expect(0, 178206, '\p{Age=:\Av60\z:}', "");;
    Expect(1, 178205, '\p{Age=_V6_0}', "");
    Expect(0, 178205, '\p{^Age=_V6_0}', "");
    Expect(0, 178205, '\P{Age=_V6_0}', "");
    Expect(1, 178205, '\P{^Age=_V6_0}', "");
    Expect(0, 178206, '\p{Age=_V6_0}', "");
    Expect(1, 178206, '\p{^Age=_V6_0}', "");
    Expect(1, 178206, '\P{Age=_V6_0}', "");
    Expect(0, 178206, '\P{^Age=_V6_0}', "");
    Error('\p{Is_Age= 00000000_6.0:=}');
    Error('\P{Is_Age= 00000000_6.0:=}');
    Expect(1, 178205, '\p{Is_Age=+0_6.0}', "");
    Expect(0, 178205, '\p{^Is_Age=+0_6.0}', "");
    Expect(0, 178205, '\P{Is_Age=+0_6.0}', "");
    Expect(1, 178205, '\P{^Is_Age=+0_6.0}', "");
    Expect(0, 178206, '\p{Is_Age=+0_6.0}', "");
    Expect(1, 178206, '\p{^Is_Age=+0_6.0}', "");
    Expect(1, 178206, '\P{Is_Age=+0_6.0}', "");
    Expect(0, 178206, '\P{^Is_Age=+0_6.0}', "");
    Error('\p{Age=:=_v6_1}');
    Error('\P{Age=:=_v6_1}');
    Expect(1, 128564, '\p{Age=:\AV6_1\z:}', "");;
    Expect(0, 128565, '\p{Age=:\AV6_1\z:}', "");;
    Expect(1, 128564, '\p{Age=v61}', "");
    Expect(0, 128564, '\p{^Age=v61}', "");
    Expect(0, 128564, '\P{Age=v61}', "");
    Expect(1, 128564, '\P{^Age=v61}', "");
    Expect(0, 128565, '\p{Age=v61}', "");
    Expect(1, 128565, '\p{^Age=v61}', "");
    Expect(1, 128565, '\P{Age=v61}', "");
    Expect(0, 128565, '\P{^Age=v61}', "");
    Expect(1, 128564, '\p{Age=:\Av61\z:}', "");;
    Expect(0, 128565, '\p{Age=:\Av61\z:}', "");;
    Expect(1, 128564, '\p{Age=-V6_1}', "");
    Expect(0, 128564, '\p{^Age=-V6_1}', "");
    Expect(0, 128564, '\P{Age=-V6_1}', "");
    Expect(1, 128564, '\P{^Age=-V6_1}', "");
    Expect(0, 128565, '\p{Age=-V6_1}', "");
    Expect(1, 128565, '\p{^Age=-V6_1}', "");
    Expect(1, 128565, '\P{Age=-V6_1}', "");
    Expect(0, 128565, '\P{^Age=-V6_1}', "");
    Error('\p{Is_Age=_	0_6.1/a/}');
    Error('\P{Is_Age=_	0_6.1/a/}');
    Expect(1, 128564, '\p{Is_Age=00_00_00_00_6.1}', "");
    Expect(0, 128564, '\p{^Is_Age=00_00_00_00_6.1}', "");
    Expect(0, 128564, '\P{Is_Age=00_00_00_00_6.1}', "");
    Expect(1, 128564, '\P{^Is_Age=00_00_00_00_6.1}', "");
    Expect(0, 128565, '\p{Is_Age=00_00_00_00_6.1}', "");
    Expect(1, 128565, '\p{^Is_Age=00_00_00_00_6.1}', "");
    Expect(1, 128565, '\P{Is_Age=00_00_00_00_6.1}', "");
    Expect(0, 128565, '\P{^Is_Age=00_00_00_00_6.1}', "");
    Error('\p{Age=-	v6_2/a/}');
    Error('\P{Age=-	v6_2/a/}');
    Expect(1, 8378, '\p{Age=:\AV6_2\z:}', "");;
    Expect(0, 8379, '\p{Age=:\AV6_2\z:}', "");;
    Expect(1, 8378, '\p{Age=v62}', "");
    Expect(0, 8378, '\p{^Age=v62}', "");
    Expect(0, 8378, '\P{Age=v62}', "");
    Expect(1, 8378, '\P{^Age=v62}', "");
    Expect(0, 8379, '\p{Age=v62}', "");
    Expect(1, 8379, '\p{^Age=v62}', "");
    Expect(1, 8379, '\P{Age=v62}', "");
    Expect(0, 8379, '\P{^Age=v62}', "");
    Expect(1, 8378, '\p{Age=:\Av62\z:}', "");;
    Expect(0, 8379, '\p{Age=:\Av62\z:}', "");;
    Expect(1, 8378, '\p{Age=  V6_2}', "");
    Expect(0, 8378, '\p{^Age=  V6_2}', "");
    Expect(0, 8378, '\P{Age=  V6_2}', "");
    Expect(1, 8378, '\P{^Age=  V6_2}', "");
    Expect(0, 8379, '\p{Age=  V6_2}', "");
    Expect(1, 8379, '\p{^Age=  V6_2}', "");
    Expect(1, 8379, '\P{Age=  V6_2}', "");
    Expect(0, 8379, '\P{^Age=  V6_2}', "");
    Error('\p{Is_Age=_/a/006.2}');
    Error('\P{Is_Age=_/a/006.2}');
    Expect(1, 8378, '\p{Is_Age=00000000_6.2}', "");
    Expect(0, 8378, '\p{^Is_Age=00000000_6.2}', "");
    Expect(0, 8378, '\P{Is_Age=00000000_6.2}', "");
    Expect(1, 8378, '\P{^Is_Age=00000000_6.2}', "");
    Expect(0, 8379, '\p{Is_Age=00000000_6.2}', "");
    Expect(1, 8379, '\p{^Is_Age=00000000_6.2}', "");
    Expect(1, 8379, '\P{Is_Age=00000000_6.2}', "");
    Expect(0, 8379, '\P{^Is_Age=00000000_6.2}', "");
    Error('\p{Age=/a/- V6_3}');
    Error('\P{Age=/a/- V6_3}');
    Expect(1, 8297, '\p{Age=:\AV6_3\z:}', "");;
    Expect(0, 8298, '\p{Age=:\AV6_3\z:}', "");;
    Expect(1, 8297, '\p{Age=v63}', "");
    Expect(0, 8297, '\p{^Age=v63}', "");
    Expect(0, 8297, '\P{Age=v63}', "");
    Expect(1, 8297, '\P{^Age=v63}', "");
    Expect(0, 8298, '\p{Age=v63}', "");
    Expect(1, 8298, '\p{^Age=v63}', "");
    Expect(1, 8298, '\P{Age=v63}', "");
    Expect(0, 8298, '\P{^Age=v63}', "");
    Expect(1, 8297, '\p{Age=:\Av63\z:}', "");;
    Expect(0, 8298, '\p{Age=:\Av63\z:}', "");;
    Expect(1, 8297, '\p{Age=_	v6_3}', "");
    Expect(0, 8297, '\p{^Age=_	v6_3}', "");
    Expect(0, 8297, '\P{Age=_	v6_3}', "");
    Expect(1, 8297, '\P{^Age=_	v6_3}', "");
    Expect(0, 8298, '\p{Age=_	v6_3}', "");
    Expect(1, 8298, '\p{^Age=_	v6_3}', "");
    Expect(1, 8298, '\P{Age=_	v6_3}', "");
    Expect(0, 8298, '\P{^Age=_	v6_3}', "");
    Error('\p{Is_Age=:= _0000006.3}');
    Error('\P{Is_Age=:= _0000006.3}');
    Expect(1, 8297, '\p{Is_Age=+0000_0000_06.3}', "");
    Expect(0, 8297, '\p{^Is_Age=+0000_0000_06.3}', "");
    Expect(0, 8297, '\P{Is_Age=+0000_0000_06.3}', "");
    Expect(1, 8297, '\P{^Is_Age=+0000_0000_06.3}', "");
    Expect(0, 8298, '\p{Is_Age=+0000_0000_06.3}', "");
    Expect(1, 8298, '\p{^Is_Age=+0000_0000_06.3}', "");
    Expect(1, 8298, '\P{Is_Age=+0000_0000_06.3}', "");
    Expect(0, 8298, '\P{^Is_Age=+0000_0000_06.3}', "");
    Error('\p{Age= /a/v7_0}');
    Error('\P{Age= /a/v7_0}');
    Expect(1, 129197, '\p{Age=:\AV7_0\z:}', "");;
    Expect(0, 129198, '\p{Age=:\AV7_0\z:}', "");;
    Expect(1, 129197, '\p{Age=v70}', "");
    Expect(0, 129197, '\p{^Age=v70}', "");
    Expect(0, 129197, '\P{Age=v70}', "");
    Expect(1, 129197, '\P{^Age=v70}', "");
    Expect(0, 129198, '\p{Age=v70}', "");
    Expect(1, 129198, '\p{^Age=v70}', "");
    Expect(1, 129198, '\P{Age=v70}', "");
    Expect(0, 129198, '\P{^Age=v70}', "");
    Expect(1, 129197, '\p{Age=:\Av70\z:}', "");;
    Expect(0, 129198, '\p{Age=:\Av70\z:}', "");;
    Expect(1, 129197, '\p{Age=	 V7_0}', "");
    Expect(0, 129197, '\p{^Age=	 V7_0}', "");
    Expect(0, 129197, '\P{Age=	 V7_0}', "");
    Expect(1, 129197, '\P{^Age=	 V7_0}', "");
    Expect(0, 129198, '\p{Age=	 V7_0}', "");
    Expect(1, 129198, '\p{^Age=	 V7_0}', "");
    Expect(1, 129198, '\P{Age=	 V7_0}', "");
    Expect(0, 129198, '\P{^Age=	 V7_0}', "");
    Error('\p{Is_Age= :=0007.0}');
    Error('\P{Is_Age= :=0007.0}');
    Expect(1, 129197, '\p{Is_Age=00000007.0}', "");
    Expect(0, 129197, '\p{^Is_Age=00000007.0}', "");
    Expect(0, 129197, '\P{Is_Age=00000007.0}', "");
    Expect(1, 129197, '\P{^Is_Age=00000007.0}', "");
    Expect(0, 129198, '\p{Is_Age=00000007.0}', "");
    Expect(1, 129198, '\p{^Is_Age=00000007.0}', "");
    Expect(1, 129198, '\P{Is_Age=00000007.0}', "");
    Expect(0, 129198, '\P{^Is_Age=00000007.0}', "");
    Error('\p{Age=	/a/V8_0}');
    Error('\P{Age=	/a/V8_0}');
    Expect(1, 183969, '\p{Age=:\AV8_0\z:}', "");;
    Expect(0, 183970, '\p{Age=:\AV8_0\z:}', "");;
    Expect(1, 183969, '\p{Age=v80}', "");
    Expect(0, 183969, '\p{^Age=v80}', "");
    Expect(0, 183969, '\P{Age=v80}', "");
    Expect(1, 183969, '\P{^Age=v80}', "");
    Expect(0, 183970, '\p{Age=v80}', "");
    Expect(1, 183970, '\p{^Age=v80}', "");
    Expect(1, 183970, '\P{Age=v80}', "");
    Expect(0, 183970, '\P{^Age=v80}', "");
    Expect(1, 183969, '\p{Age=:\Av80\z:}', "");;
    Expect(0, 183970, '\p{Age=:\Av80\z:}', "");;
    Expect(1, 183969, '\p{Age=_v8_0}', "");
    Expect(0, 183969, '\p{^Age=_v8_0}', "");
    Expect(0, 183969, '\P{Age=_v8_0}', "");
    Expect(1, 183969, '\P{^Age=_v8_0}', "");
    Expect(0, 183970, '\p{Age=_v8_0}', "");
    Expect(1, 183970, '\p{^Age=_v8_0}', "");
    Expect(1, 183970, '\P{Age=_v8_0}', "");
    Expect(0, 183970, '\P{^Age=_v8_0}', "");
    Error('\p{Is_Age=:=	_+008.0}');
    Error('\P{Is_Age=:=	_+008.0}');
    Expect(1, 183969, '\p{Is_Age=0_0_0_0_008.0}', "");
    Expect(0, 183969, '\p{^Is_Age=0_0_0_0_008.0}', "");
    Expect(0, 183969, '\P{Is_Age=0_0_0_0_008.0}', "");
    Expect(1, 183969, '\P{^Is_Age=0_0_0_0_008.0}', "");
    Expect(0, 183970, '\p{Is_Age=0_0_0_0_008.0}', "");
    Expect(1, 183970, '\p{^Is_Age=0_0_0_0_008.0}', "");
    Expect(1, 183970, '\P{Is_Age=0_0_0_0_008.0}', "");
    Expect(0, 183970, '\P{^Is_Age=0_0_0_0_008.0}', "");
    Error('\p{Age=-	V9_0:=}');
    Error('\P{Age=-	V9_0:=}');
    Expect(1, 129425, '\p{Age=:\AV9_0\z:}', "");;
    Expect(0, 129426, '\p{Age=:\AV9_0\z:}', "");;
    Expect(1, 129425, '\p{Age=v90}', "");
    Expect(0, 129425, '\p{^Age=v90}', "");
    Expect(0, 129425, '\P{Age=v90}', "");
    Expect(1, 129425, '\P{^Age=v90}', "");
    Expect(0, 129426, '\p{Age=v90}', "");
    Expect(1, 129426, '\p{^Age=v90}', "");
    Expect(1, 129426, '\P{Age=v90}', "");
    Expect(0, 129426, '\P{^Age=v90}', "");
    Expect(1, 129425, '\p{Age=:\Av90\z:}', "");;
    Expect(0, 129426, '\p{Age=:\Av90\z:}', "");;
    Expect(1, 129425, '\p{Age=-V9_0}', "");
    Expect(0, 129425, '\p{^Age=-V9_0}', "");
    Expect(0, 129425, '\P{Age=-V9_0}', "");
    Expect(1, 129425, '\P{^Age=-V9_0}', "");
    Expect(0, 129426, '\p{Age=-V9_0}', "");
    Expect(1, 129426, '\p{^Age=-V9_0}', "");
    Expect(1, 129426, '\P{Age=-V9_0}', "");
    Expect(0, 129426, '\P{^Age=-V9_0}', "");
    Error('\p{Is_Age=/a/00000009.0}');
    Error('\P{Is_Age=/a/00000009.0}');
    Expect(1, 129425, '\p{Is_Age=0_0_0_0_0009.0}', "");
    Expect(0, 129425, '\p{^Is_Age=0_0_0_0_0009.0}', "");
    Expect(0, 129425, '\P{Is_Age=0_0_0_0_0009.0}', "");
    Expect(1, 129425, '\P{^Is_Age=0_0_0_0_0009.0}', "");
    Expect(0, 129426, '\p{Is_Age=0_0_0_0_0009.0}', "");
    Expect(1, 129426, '\p{^Is_Age=0_0_0_0_0009.0}', "");
    Expect(1, 129426, '\P{Is_Age=0_0_0_0_0009.0}', "");
    Expect(0, 129426, '\P{^Is_Age=0_0_0_0_0009.0}', "");
    Error('\p{Age=	:=unassigned}');
    Error('\P{Age=	:=unassigned}');
    Expect(1, 983037, '\p{Age=:\AUnassigned\z:}', "");;
    Expect(0, 983040, '\p{Age=:\AUnassigned\z:}', "");;
    Expect(1, 983037, '\p{Age=unassigned}', "");
    Expect(0, 983037, '\p{^Age=unassigned}', "");
    Expect(0, 983037, '\P{Age=unassigned}', "");
    Expect(1, 983037, '\P{^Age=unassigned}', "");
    Expect(0, 983040, '\p{Age=unassigned}', "");
    Expect(1, 983040, '\p{^Age=unassigned}', "");
    Expect(1, 983040, '\P{Age=unassigned}', "");
    Expect(0, 983040, '\P{^Age=unassigned}', "");
    Expect(1, 983037, '\p{Age=:\Aunassigned\z:}', "");;
    Expect(0, 983040, '\p{Age=:\Aunassigned\z:}', "");;
    Expect(1, 983037, '\p{Age=	UNASSIGNED}', "");
    Expect(0, 983037, '\p{^Age=	UNASSIGNED}', "");
    Expect(0, 983037, '\P{Age=	UNASSIGNED}', "");
    Expect(1, 983037, '\P{^Age=	UNASSIGNED}', "");
    Expect(0, 983040, '\p{Age=	UNASSIGNED}', "");
    Expect(1, 983040, '\p{^Age=	UNASSIGNED}', "");
    Expect(1, 983040, '\P{Age=	UNASSIGNED}', "");
    Expect(0, 983040, '\P{^Age=	UNASSIGNED}', "");
    Error('\p{Is_Age=/a/_ NA}');
    Error('\P{Is_Age=/a/_ NA}');
    Expect(1, 983037, '\p{Is_Age=na}', "");
    Expect(0, 983037, '\p{^Is_Age=na}', "");
    Expect(0, 983037, '\P{Is_Age=na}', "");
    Expect(1, 983037, '\P{^Is_Age=na}', "");
    Expect(0, 983040, '\p{Is_Age=na}', "");
    Expect(1, 983040, '\p{^Is_Age=na}', "");
    Expect(1, 983040, '\P{Is_Age=na}', "");
    Expect(0, 983040, '\P{^Is_Age=na}', "");
    Expect(1, 983037, '\p{Is_Age=_NA}', "");
    Expect(0, 983037, '\p{^Is_Age=_NA}', "");
    Expect(0, 983037, '\P{Is_Age=_NA}', "");
    Expect(1, 983037, '\P{^Is_Age=_NA}', "");
    Expect(0, 983040, '\p{Is_Age=_NA}', "");
    Expect(1, 983040, '\p{^Is_Age=_NA}', "");
    Expect(1, 983040, '\P{Is_Age=_NA}', "");
    Expect(0, 983040, '\P{^Is_Age=_NA}', "");
    Error('\p{ASCII_Hex_Digit=-/a/no}');
    Error('\P{ASCII_Hex_Digit=-/a/no}');
    Expect(1, 103, '\p{ASCII_Hex_Digit=:\ANo\z:}', "");;
    Expect(0, 102, '\p{ASCII_Hex_Digit=:\ANo\z:}', "");;
    Expect(1, 103, '\p{ASCII_Hex_Digit=no}', "");
    Expect(0, 103, '\p{^ASCII_Hex_Digit=no}', "");
    Expect(0, 103, '\P{ASCII_Hex_Digit=no}', "");
    Expect(1, 103, '\P{^ASCII_Hex_Digit=no}', "");
    Expect(0, 102, '\p{ASCII_Hex_Digit=no}', "");
    Expect(1, 102, '\p{^ASCII_Hex_Digit=no}', "");
    Expect(1, 102, '\P{ASCII_Hex_Digit=no}', "");
    Expect(0, 102, '\P{^ASCII_Hex_Digit=no}', "");
    Expect(1, 103, '\p{ASCII_Hex_Digit=:\Ano\z:}', "");;
    Expect(0, 102, '\p{ASCII_Hex_Digit=:\Ano\z:}', "");;
    Expect(1, 103, '\p{ASCII_Hex_Digit=-	No}', "");
    Expect(0, 103, '\p{^ASCII_Hex_Digit=-	No}', "");
    Expect(0, 103, '\P{ASCII_Hex_Digit=-	No}', "");
    Expect(1, 103, '\P{^ASCII_Hex_Digit=-	No}', "");
    Expect(0, 102, '\p{ASCII_Hex_Digit=-	No}', "");
    Expect(1, 102, '\p{^ASCII_Hex_Digit=-	No}', "");
    Expect(1, 102, '\P{ASCII_Hex_Digit=-	No}', "");
    Expect(0, 102, '\P{^ASCII_Hex_Digit=-	No}', "");
    Error('\p{AHex:	__N:=}');
    Error('\P{AHex:	__N:=}');
    Expect(1, 103, '\p{AHex=:\AN\z:}', "");;
    Expect(0, 102, '\p{AHex=:\AN\z:}', "");;
    Expect(1, 103, '\p{AHex:	n}', "");
    Expect(0, 103, '\p{^AHex:	n}', "");
    Expect(0, 103, '\P{AHex:	n}', "");
    Expect(1, 103, '\P{^AHex:	n}', "");
    Expect(0, 102, '\p{AHex:	n}', "");
    Expect(1, 102, '\p{^AHex:	n}', "");
    Expect(1, 102, '\P{AHex:	n}', "");
    Expect(0, 102, '\P{^AHex:	n}', "");
    Expect(1, 103, '\p{AHex=:\An\z:}', "");;
    Expect(0, 102, '\p{AHex=:\An\z:}', "");;
    Expect(1, 103, '\p{AHex=	n}', "");
    Expect(0, 103, '\p{^AHex=	n}', "");
    Expect(0, 103, '\P{AHex=	n}', "");
    Expect(1, 103, '\P{^AHex=	n}', "");
    Expect(0, 102, '\p{AHex=	n}', "");
    Expect(1, 102, '\p{^AHex=	n}', "");
    Expect(1, 102, '\P{AHex=	n}', "");
    Expect(0, 102, '\P{^AHex=	n}', "");
    Error('\p{Is_ASCII_Hex_Digit=	F/a/}');
    Error('\P{Is_ASCII_Hex_Digit=	F/a/}');
    Expect(1, 103, '\p{Is_ASCII_Hex_Digit:   f}', "");
    Expect(0, 103, '\p{^Is_ASCII_Hex_Digit:   f}', "");
    Expect(0, 103, '\P{Is_ASCII_Hex_Digit:   f}', "");
    Expect(1, 103, '\P{^Is_ASCII_Hex_Digit:   f}', "");
    Expect(0, 102, '\p{Is_ASCII_Hex_Digit:   f}', "");
    Expect(1, 102, '\p{^Is_ASCII_Hex_Digit:   f}', "");
    Expect(1, 102, '\P{Is_ASCII_Hex_Digit:   f}', "");
    Expect(0, 102, '\P{^Is_ASCII_Hex_Digit:   f}', "");
    Expect(1, 103, '\p{Is_ASCII_Hex_Digit=_ F}', "");
    Expect(0, 103, '\p{^Is_ASCII_Hex_Digit=_ F}', "");
    Expect(0, 103, '\P{Is_ASCII_Hex_Digit=_ F}', "");
    Expect(1, 103, '\P{^Is_ASCII_Hex_Digit=_ F}', "");
    Expect(0, 102, '\p{Is_ASCII_Hex_Digit=_ F}', "");
    Expect(1, 102, '\p{^Is_ASCII_Hex_Digit=_ F}', "");
    Expect(1, 102, '\P{Is_ASCII_Hex_Digit=_ F}', "");
    Expect(0, 102, '\P{^Is_ASCII_Hex_Digit=_ F}', "");
    Error('\p{Is_AHex=_	False:=}');
    Error('\P{Is_AHex=_	False:=}');
    Expect(1, 103, '\p{Is_AHex=false}', "");
    Expect(0, 103, '\p{^Is_AHex=false}', "");
    Expect(0, 103, '\P{Is_AHex=false}', "");
    Expect(1, 103, '\P{^Is_AHex=false}', "");
    Expect(0, 102, '\p{Is_AHex=false}', "");
    Expect(1, 102, '\p{^Is_AHex=false}', "");
    Expect(1, 102, '\P{Is_AHex=false}', "");
    Expect(0, 102, '\P{^Is_AHex=false}', "");
    Expect(1, 103, '\p{Is_AHex= -false}', "");
    Expect(0, 103, '\p{^Is_AHex= -false}', "");
    Expect(0, 103, '\P{Is_AHex= -false}', "");
    Expect(1, 103, '\P{^Is_AHex= -false}', "");
    Expect(0, 102, '\p{Is_AHex= -false}', "");
    Expect(1, 102, '\p{^Is_AHex= -false}', "");
    Expect(1, 102, '\P{Is_AHex= -false}', "");
    Expect(0, 102, '\P{^Is_AHex= -false}', "");
    Error('\p{ASCII_Hex_Digit=:=__Yes}');
    Error('\P{ASCII_Hex_Digit=:=__Yes}');
    Expect(1, 102, '\p{ASCII_Hex_Digit=:\AYes\z:}', "");;
    Expect(0, 103, '\p{ASCII_Hex_Digit=:\AYes\z:}', "");;
    Expect(1, 102, '\p{ASCII_Hex_Digit=yes}', "");
    Expect(0, 102, '\p{^ASCII_Hex_Digit=yes}', "");
    Expect(0, 102, '\P{ASCII_Hex_Digit=yes}', "");
    Expect(1, 102, '\P{^ASCII_Hex_Digit=yes}', "");
    Expect(0, 103, '\p{ASCII_Hex_Digit=yes}', "");
    Expect(1, 103, '\p{^ASCII_Hex_Digit=yes}', "");
    Expect(1, 103, '\P{ASCII_Hex_Digit=yes}', "");
    Expect(0, 103, '\P{^ASCII_Hex_Digit=yes}', "");
    Expect(1, 102, '\p{ASCII_Hex_Digit=:\Ayes\z:}', "");;
    Expect(0, 103, '\p{ASCII_Hex_Digit=:\Ayes\z:}', "");;
    Expect(1, 102, '\p{ASCII_Hex_Digit=	 YES}', "");
    Expect(0, 102, '\p{^ASCII_Hex_Digit=	 YES}', "");
    Expect(0, 102, '\P{ASCII_Hex_Digit=	 YES}', "");
    Expect(1, 102, '\P{^ASCII_Hex_Digit=	 YES}', "");
    Expect(0, 103, '\p{ASCII_Hex_Digit=	 YES}', "");
    Expect(1, 103, '\p{^ASCII_Hex_Digit=	 YES}', "");
    Expect(1, 103, '\P{ASCII_Hex_Digit=	 YES}', "");
    Expect(0, 103, '\P{^ASCII_Hex_Digit=	 YES}', "");
    Error('\p{AHex=-/a/y}');
    Error('\P{AHex=-/a/y}');
    Expect(1, 102, '\p{AHex=:\AY\z:}', "");;
    Expect(0, 103, '\p{AHex=:\AY\z:}', "");;
    Expect(1, 102, '\p{AHex:	y}', "");
    Expect(0, 102, '\p{^AHex:	y}', "");
    Expect(0, 102, '\P{AHex:	y}', "");
    Expect(1, 102, '\P{^AHex:	y}', "");
    Expect(0, 103, '\p{AHex:	y}', "");
    Expect(1, 103, '\p{^AHex:	y}', "");
    Expect(1, 103, '\P{AHex:	y}', "");
    Expect(0, 103, '\P{^AHex:	y}', "");
    Expect(1, 102, '\p{AHex=:\Ay\z:}', "");;
    Expect(0, 103, '\p{AHex=:\Ay\z:}', "");;
    Expect(1, 102, '\p{AHex=_ Y}', "");
    Expect(0, 102, '\p{^AHex=_ Y}', "");
    Expect(0, 102, '\P{AHex=_ Y}', "");
    Expect(1, 102, '\P{^AHex=_ Y}', "");
    Expect(0, 103, '\p{AHex=_ Y}', "");
    Expect(1, 103, '\p{^AHex=_ Y}', "");
    Expect(1, 103, '\P{AHex=_ Y}', "");
    Expect(0, 103, '\P{^AHex=_ Y}', "");
    Error('\p{Is_ASCII_Hex_Digit=--T:=}');
    Error('\P{Is_ASCII_Hex_Digit=--T:=}');
    Expect(1, 102, '\p{Is_ASCII_Hex_Digit=t}', "");
    Expect(0, 102, '\p{^Is_ASCII_Hex_Digit=t}', "");
    Expect(0, 102, '\P{Is_ASCII_Hex_Digit=t}', "");
    Expect(1, 102, '\P{^Is_ASCII_Hex_Digit=t}', "");
    Expect(0, 103, '\p{Is_ASCII_Hex_Digit=t}', "");
    Expect(1, 103, '\p{^Is_ASCII_Hex_Digit=t}', "");
    Expect(1, 103, '\P{Is_ASCII_Hex_Digit=t}', "");
    Expect(0, 103, '\P{^Is_ASCII_Hex_Digit=t}', "");
    Expect(1, 102, '\p{Is_ASCII_Hex_Digit=		T}', "");
    Expect(0, 102, '\p{^Is_ASCII_Hex_Digit=		T}', "");
    Expect(0, 102, '\P{Is_ASCII_Hex_Digit=		T}', "");
    Expect(1, 102, '\P{^Is_ASCII_Hex_Digit=		T}', "");
    Expect(0, 103, '\p{Is_ASCII_Hex_Digit=		T}', "");
    Expect(1, 103, '\p{^Is_ASCII_Hex_Digit=		T}', "");
    Expect(1, 103, '\P{Is_ASCII_Hex_Digit=		T}', "");
    Expect(0, 103, '\P{^Is_ASCII_Hex_Digit=		T}', "");
    Error('\p{Is_AHex=:=-true}');
    Error('\P{Is_AHex=:=-true}');
    Expect(1, 102, '\p{Is_AHex=true}', "");
    Expect(0, 102, '\p{^Is_AHex=true}', "");
    Expect(0, 102, '\P{Is_AHex=true}', "");
    Expect(1, 102, '\P{^Is_AHex=true}', "");
    Expect(0, 103, '\p{Is_AHex=true}', "");
    Expect(1, 103, '\p{^Is_AHex=true}', "");
    Expect(1, 103, '\P{Is_AHex=true}', "");
    Expect(0, 103, '\P{^Is_AHex=true}', "");
    Expect(1, 102, '\p{Is_AHex=- True}', "");
    Expect(0, 102, '\p{^Is_AHex=- True}', "");
    Expect(0, 102, '\P{Is_AHex=- True}', "");
    Expect(1, 102, '\P{^Is_AHex=- True}', "");
    Expect(0, 103, '\p{Is_AHex=- True}', "");
    Expect(1, 103, '\p{^Is_AHex=- True}', "");
    Expect(1, 103, '\P{Is_AHex=- True}', "");
    Expect(0, 103, '\P{^Is_AHex=- True}', "");
    Error('\p{Alphabetic=:=__no}');
    Error('\P{Alphabetic=:=__no}');
    Expect(1, 205744, '\p{Alphabetic=:\ANo\z:}', "");;
    Expect(0, 205743, '\p{Alphabetic=:\ANo\z:}', "");;
    Expect(1, 205744, '\p{Alphabetic=no}', "");
    Expect(0, 205744, '\p{^Alphabetic=no}', "");
    Expect(0, 205744, '\P{Alphabetic=no}', "");
    Expect(1, 205744, '\P{^Alphabetic=no}', "");
    Expect(0, 205743, '\p{Alphabetic=no}', "");
    Expect(1, 205743, '\p{^Alphabetic=no}', "");
    Expect(1, 205743, '\P{Alphabetic=no}', "");
    Expect(0, 205743, '\P{^Alphabetic=no}', "");
    Expect(1, 205744, '\p{Alphabetic=:\Ano\z:}', "");;
    Expect(0, 205743, '\p{Alphabetic=:\Ano\z:}', "");;
    Expect(1, 205744, '\p{Alphabetic=  No}', "");
    Expect(0, 205744, '\p{^Alphabetic=  No}', "");
    Expect(0, 205744, '\P{Alphabetic=  No}', "");
    Expect(1, 205744, '\P{^Alphabetic=  No}', "");
    Expect(0, 205743, '\p{Alphabetic=  No}', "");
    Expect(1, 205743, '\p{^Alphabetic=  No}', "");
    Expect(1, 205743, '\P{Alphabetic=  No}', "");
    Expect(0, 205743, '\P{^Alphabetic=  No}', "");
    Error('\p{Alpha:	_/a/N}');
    Error('\P{Alpha:	_/a/N}');
    Expect(1, 205744, '\p{Alpha=:\AN\z:}', "");;
    Expect(0, 205743, '\p{Alpha=:\AN\z:}', "");;
    Expect(1, 205744, '\p{Alpha=n}', "");
    Expect(0, 205744, '\p{^Alpha=n}', "");
    Expect(0, 205744, '\P{Alpha=n}', "");
    Expect(1, 205744, '\P{^Alpha=n}', "");
    Expect(0, 205743, '\p{Alpha=n}', "");
    Expect(1, 205743, '\p{^Alpha=n}', "");
    Expect(1, 205743, '\P{Alpha=n}', "");
    Expect(0, 205743, '\P{^Alpha=n}', "");
    Expect(1, 205744, '\p{Alpha=:\An\z:}', "");;
    Expect(0, 205743, '\p{Alpha=:\An\z:}', "");;
    Expect(1, 205744, '\p{Alpha=	_N}', "");
    Expect(0, 205744, '\p{^Alpha=	_N}', "");
    Expect(0, 205744, '\P{Alpha=	_N}', "");
    Expect(1, 205744, '\P{^Alpha=	_N}', "");
    Expect(0, 205743, '\p{Alpha=	_N}', "");
    Expect(1, 205743, '\p{^Alpha=	_N}', "");
    Expect(1, 205743, '\P{Alpha=	_N}', "");
    Expect(0, 205743, '\P{^Alpha=	_N}', "");
    Error('\p{Is_Alphabetic=:=--F}');
    Error('\P{Is_Alphabetic=:=--F}');
    Expect(1, 205744, '\p{Is_Alphabetic=f}', "");
    Expect(0, 205744, '\p{^Is_Alphabetic=f}', "");
    Expect(0, 205744, '\P{Is_Alphabetic=f}', "");
    Expect(1, 205744, '\P{^Is_Alphabetic=f}', "");
    Expect(0, 205743, '\p{Is_Alphabetic=f}', "");
    Expect(1, 205743, '\p{^Is_Alphabetic=f}', "");
    Expect(1, 205743, '\P{Is_Alphabetic=f}', "");
    Expect(0, 205743, '\P{^Is_Alphabetic=f}', "");
    Expect(1, 205744, '\p{Is_Alphabetic:    -F}', "");
    Expect(0, 205744, '\p{^Is_Alphabetic:    -F}', "");
    Expect(0, 205744, '\P{Is_Alphabetic:    -F}', "");
    Expect(1, 205744, '\P{^Is_Alphabetic:    -F}', "");
    Expect(0, 205743, '\p{Is_Alphabetic:    -F}', "");
    Expect(1, 205743, '\p{^Is_Alphabetic:    -F}', "");
    Expect(1, 205743, '\P{Is_Alphabetic:    -F}', "");
    Expect(0, 205743, '\P{^Is_Alphabetic:    -F}', "");
    Error('\p{Is_Alpha=:=-	FALSE}');
    Error('\P{Is_Alpha=:=-	FALSE}');
    Expect(1, 205744, '\p{Is_Alpha=false}', "");
    Expect(0, 205744, '\p{^Is_Alpha=false}', "");
    Expect(0, 205744, '\P{Is_Alpha=false}', "");
    Expect(1, 205744, '\P{^Is_Alpha=false}', "");
    Expect(0, 205743, '\p{Is_Alpha=false}', "");
    Expect(1, 205743, '\p{^Is_Alpha=false}', "");
    Expect(1, 205743, '\P{Is_Alpha=false}', "");
    Expect(0, 205743, '\P{^Is_Alpha=false}', "");
    Expect(1, 205744, '\p{Is_Alpha: 		false}', "");
    Expect(0, 205744, '\p{^Is_Alpha: 		false}', "");
    Expect(0, 205744, '\P{Is_Alpha: 		false}', "");
    Expect(1, 205744, '\P{^Is_Alpha: 		false}', "");
    Expect(0, 205743, '\p{Is_Alpha: 		false}', "");
    Expect(1, 205743, '\p{^Is_Alpha: 		false}', "");
    Expect(1, 205743, '\P{Is_Alpha: 		false}', "");
    Expect(0, 205743, '\P{^Is_Alpha: 		false}', "");
    Error('\p{Alphabetic=-YES/a/}');
    Error('\P{Alphabetic=-YES/a/}');
    Expect(1, 205743, '\p{Alphabetic=:\AYes\z:}', "");;
    Expect(0, 205744, '\p{Alphabetic=:\AYes\z:}', "");;
    Expect(1, 205743, '\p{Alphabetic=yes}', "");
    Expect(0, 205743, '\p{^Alphabetic=yes}', "");
    Expect(0, 205743, '\P{Alphabetic=yes}', "");
    Expect(1, 205743, '\P{^Alphabetic=yes}', "");
    Expect(0, 205744, '\p{Alphabetic=yes}', "");
    Expect(1, 205744, '\p{^Alphabetic=yes}', "");
    Expect(1, 205744, '\P{Alphabetic=yes}', "");
    Expect(0, 205744, '\P{^Alphabetic=yes}', "");
    Expect(1, 205743, '\p{Alphabetic=:\Ayes\z:}', "");;
    Expect(0, 205744, '\p{Alphabetic=:\Ayes\z:}', "");;
    Expect(1, 205743, '\p{Alphabetic=_-YES}', "");
    Expect(0, 205743, '\p{^Alphabetic=_-YES}', "");
    Expect(0, 205743, '\P{Alphabetic=_-YES}', "");
    Expect(1, 205743, '\P{^Alphabetic=_-YES}', "");
    Expect(0, 205744, '\p{Alphabetic=_-YES}', "");
    Expect(1, 205744, '\p{^Alphabetic=_-YES}', "");
    Expect(1, 205744, '\P{Alphabetic=_-YES}', "");
    Expect(0, 205744, '\P{^Alphabetic=_-YES}', "");
    Error('\p{Alpha=_:=Y}');
    Error('\P{Alpha=_:=Y}');
    Expect(1, 205743, '\p{Alpha=:\AY\z:}', "");;
    Expect(0, 205744, '\p{Alpha=:\AY\z:}', "");;
    Expect(1, 205743, '\p{Alpha=y}', "");
    Expect(0, 205743, '\p{^Alpha=y}', "");
    Expect(0, 205743, '\P{Alpha=y}', "");
    Expect(1, 205743, '\P{^Alpha=y}', "");
    Expect(0, 205744, '\p{Alpha=y}', "");
    Expect(1, 205744, '\p{^Alpha=y}', "");
    Expect(1, 205744, '\P{Alpha=y}', "");
    Expect(0, 205744, '\P{^Alpha=y}', "");
    Expect(1, 205743, '\p{Alpha=:\Ay\z:}', "");;
    Expect(0, 205744, '\p{Alpha=:\Ay\z:}', "");;
    Expect(1, 205743, '\p{Alpha= Y}', "");
    Expect(0, 205743, '\p{^Alpha= Y}', "");
    Expect(0, 205743, '\P{Alpha= Y}', "");
    Expect(1, 205743, '\P{^Alpha= Y}', "");
    Expect(0, 205744, '\p{Alpha= Y}', "");
    Expect(1, 205744, '\p{^Alpha= Y}', "");
    Expect(1, 205744, '\P{Alpha= Y}', "");
    Expect(0, 205744, '\P{^Alpha= Y}', "");
    Error('\p{Is_Alphabetic:	:=T}');
    Error('\P{Is_Alphabetic:	:=T}');
    Expect(1, 205743, '\p{Is_Alphabetic=t}', "");
    Expect(0, 205743, '\p{^Is_Alphabetic=t}', "");
    Expect(0, 205743, '\P{Is_Alphabetic=t}', "");
    Expect(1, 205743, '\P{^Is_Alphabetic=t}', "");
    Expect(0, 205744, '\p{Is_Alphabetic=t}', "");
    Expect(1, 205744, '\p{^Is_Alphabetic=t}', "");
    Expect(1, 205744, '\P{Is_Alphabetic=t}', "");
    Expect(0, 205744, '\P{^Is_Alphabetic=t}', "");
    Expect(1, 205743, '\p{Is_Alphabetic=_T}', "");
    Expect(0, 205743, '\p{^Is_Alphabetic=_T}', "");
    Expect(0, 205743, '\P{Is_Alphabetic=_T}', "");
    Expect(1, 205743, '\P{^Is_Alphabetic=_T}', "");
    Expect(0, 205744, '\p{Is_Alphabetic=_T}', "");
    Expect(1, 205744, '\p{^Is_Alphabetic=_T}', "");
    Expect(1, 205744, '\P{Is_Alphabetic=_T}', "");
    Expect(0, 205744, '\P{^Is_Alphabetic=_T}', "");
    Error('\p{Is_Alpha=-/a/true}');
    Error('\P{Is_Alpha=-/a/true}');
    Expect(1, 205743, '\p{Is_Alpha: true}', "");
    Expect(0, 205743, '\p{^Is_Alpha: true}', "");
    Expect(0, 205743, '\P{Is_Alpha: true}', "");
    Expect(1, 205743, '\P{^Is_Alpha: true}', "");
    Expect(0, 205744, '\p{Is_Alpha: true}', "");
    Expect(1, 205744, '\p{^Is_Alpha: true}', "");
    Expect(1, 205744, '\P{Is_Alpha: true}', "");
    Expect(0, 205744, '\P{^Is_Alpha: true}', "");
    Expect(1, 205743, '\p{Is_Alpha=	true}', "");
    Expect(0, 205743, '\p{^Is_Alpha=	true}', "");
    Expect(0, 205743, '\P{Is_Alpha=	true}', "");
    Expect(1, 205743, '\P{^Is_Alpha=	true}', "");
    Expect(0, 205744, '\p{Is_Alpha=	true}', "");
    Expect(1, 205744, '\p{^Is_Alpha=	true}', "");
    Expect(1, 205744, '\P{Is_Alpha=	true}', "");
    Expect(0, 205744, '\P{^Is_Alpha=	true}', "");
    Error('\p{bidiclass}');
    Error('\P{bidiclass}');
    Error('\p{bc}');
    Error('\P{bc}');
    Error('\p{Bidi_Class=	-Arabic_letter:=}');
    Error('\P{Bidi_Class=	-Arabic_letter:=}');
    Expect(1, 126719, '\p{Bidi_Class=:\AArabic_Letter\z:}', "");;
    Expect(0, 126720, '\p{Bidi_Class=:\AArabic_Letter\z:}', "");;
    Expect(1, 126719, '\p{Bidi_Class=arabicletter}', "");
    Expect(0, 126719, '\p{^Bidi_Class=arabicletter}', "");
    Expect(0, 126719, '\P{Bidi_Class=arabicletter}', "");
    Expect(1, 126719, '\P{^Bidi_Class=arabicletter}', "");
    Expect(0, 126720, '\p{Bidi_Class=arabicletter}', "");
    Expect(1, 126720, '\p{^Bidi_Class=arabicletter}', "");
    Expect(1, 126720, '\P{Bidi_Class=arabicletter}', "");
    Expect(0, 126720, '\P{^Bidi_Class=arabicletter}', "");
    Expect(1, 126719, '\p{Bidi_Class=:\Aarabicletter\z:}', "");;
    Expect(0, 126720, '\p{Bidi_Class=:\Aarabicletter\z:}', "");;
    Expect(1, 126719, '\p{Bidi_Class=	-ARABIC_letter}', "");
    Expect(0, 126719, '\p{^Bidi_Class=	-ARABIC_letter}', "");
    Expect(0, 126719, '\P{Bidi_Class=	-ARABIC_letter}', "");
    Expect(1, 126719, '\P{^Bidi_Class=	-ARABIC_letter}', "");
    Expect(0, 126720, '\p{Bidi_Class=	-ARABIC_letter}', "");
    Expect(1, 126720, '\p{^Bidi_Class=	-ARABIC_letter}', "");
    Expect(1, 126720, '\P{Bidi_Class=	-ARABIC_letter}', "");
    Expect(0, 126720, '\P{^Bidi_Class=	-ARABIC_letter}', "");
    Error('\p{Bc=-/a/AL}');
    Error('\P{Bc=-/a/AL}');
    Expect(1, 126719, '\p{Bc=:\AAL\z:}', "");;
    Expect(0, 126720, '\p{Bc=:\AAL\z:}', "");;
    Expect(1, 126719, '\p{Bc=al}', "");
    Expect(0, 126719, '\p{^Bc=al}', "");
    Expect(0, 126719, '\P{Bc=al}', "");
    Expect(1, 126719, '\P{^Bc=al}', "");
    Expect(0, 126720, '\p{Bc=al}', "");
    Expect(1, 126720, '\p{^Bc=al}', "");
    Expect(1, 126720, '\P{Bc=al}', "");
    Expect(0, 126720, '\P{^Bc=al}', "");
    Expect(1, 126719, '\p{Bc=:\Aal\z:}', "");;
    Expect(0, 126720, '\p{Bc=:\Aal\z:}', "");;
    Expect(1, 126719, '\p{Bc=	-AL}', "");
    Expect(0, 126719, '\p{^Bc=	-AL}', "");
    Expect(0, 126719, '\P{Bc=	-AL}', "");
    Expect(1, 126719, '\P{^Bc=	-AL}', "");
    Expect(0, 126720, '\p{Bc=	-AL}', "");
    Expect(1, 126720, '\p{^Bc=	-AL}', "");
    Expect(1, 126720, '\P{Bc=	-AL}', "");
    Expect(0, 126720, '\P{^Bc=	-AL}', "");
    Error('\p{Is_Bidi_Class:   -	Arabic_letter/a/}');
    Error('\P{Is_Bidi_Class:   -	Arabic_letter/a/}');
    Expect(1, 126719, '\p{Is_Bidi_Class=arabicletter}', "");
    Expect(0, 126719, '\p{^Is_Bidi_Class=arabicletter}', "");
    Expect(0, 126719, '\P{Is_Bidi_Class=arabicletter}', "");
    Expect(1, 126719, '\P{^Is_Bidi_Class=arabicletter}', "");
    Expect(0, 126720, '\p{Is_Bidi_Class=arabicletter}', "");
    Expect(1, 126720, '\p{^Is_Bidi_Class=arabicletter}', "");
    Expect(1, 126720, '\P{Is_Bidi_Class=arabicletter}', "");
    Expect(0, 126720, '\P{^Is_Bidi_Class=arabicletter}', "");
    Expect(1, 126719, '\p{Is_Bidi_Class=__Arabic_Letter}', "");
    Expect(0, 126719, '\p{^Is_Bidi_Class=__Arabic_Letter}', "");
    Expect(0, 126719, '\P{Is_Bidi_Class=__Arabic_Letter}', "");
    Expect(1, 126719, '\P{^Is_Bidi_Class=__Arabic_Letter}', "");
    Expect(0, 126720, '\p{Is_Bidi_Class=__Arabic_Letter}', "");
    Expect(1, 126720, '\p{^Is_Bidi_Class=__Arabic_Letter}', "");
    Expect(1, 126720, '\P{Is_Bidi_Class=__Arabic_Letter}', "");
    Expect(0, 126720, '\P{^Is_Bidi_Class=__Arabic_Letter}', "");
    Error('\p{Is_Bc=__AL:=}');
    Error('\P{Is_Bc=__AL:=}');
    Expect(1, 126719, '\p{Is_Bc=al}', "");
    Expect(0, 126719, '\p{^Is_Bc=al}', "");
    Expect(0, 126719, '\P{Is_Bc=al}', "");
    Expect(1, 126719, '\P{^Is_Bc=al}', "");
    Expect(0, 126720, '\p{Is_Bc=al}', "");
    Expect(1, 126720, '\p{^Is_Bc=al}', "");
    Expect(1, 126720, '\P{Is_Bc=al}', "");
    Expect(0, 126720, '\P{^Is_Bc=al}', "");
    Expect(1, 126719, '\p{Is_Bc=_-AL}', "");
    Expect(0, 126719, '\p{^Is_Bc=_-AL}', "");
    Expect(0, 126719, '\P{Is_Bc=_-AL}', "");
    Expect(1, 126719, '\P{^Is_Bc=_-AL}', "");
    Expect(0, 126720, '\p{Is_Bc=_-AL}', "");
    Expect(1, 126720, '\p{^Is_Bc=_-AL}', "");
    Expect(1, 126720, '\P{Is_Bc=_-AL}', "");
    Expect(0, 126720, '\P{^Is_Bc=_-AL}', "");
    Error('\p{Bidi_Class=/a/-_ARABIC_Number}');
    Error('\P{Bidi_Class=/a/-_ARABIC_Number}');
    Expect(1, 69246, '\p{Bidi_Class=:\AArabic_Number\z:}', "");;
    Expect(0, 69247, '\p{Bidi_Class=:\AArabic_Number\z:}', "");;
    Expect(1, 69246, '\p{Bidi_Class=arabicnumber}', "");
    Expect(0, 69246, '\p{^Bidi_Class=arabicnumber}', "");
    Expect(0, 69246, '\P{Bidi_Class=arabicnumber}', "");
    Expect(1, 69246, '\P{^Bidi_Class=arabicnumber}', "");
    Expect(0, 69247, '\p{Bidi_Class=arabicnumber}', "");
    Expect(1, 69247, '\p{^Bidi_Class=arabicnumber}', "");
    Expect(1, 69247, '\P{Bidi_Class=arabicnumber}', "");
    Expect(0, 69247, '\P{^Bidi_Class=arabicnumber}', "");
    Expect(1, 69246, '\p{Bidi_Class=:\Aarabicnumber\z:}', "");;
    Expect(0, 69247, '\p{Bidi_Class=:\Aarabicnumber\z:}', "");;
    Expect(1, 69246, '\p{Bidi_Class=-	Arabic_Number}', "");
    Expect(0, 69246, '\p{^Bidi_Class=-	Arabic_Number}', "");
    Expect(0, 69246, '\P{Bidi_Class=-	Arabic_Number}', "");
    Expect(1, 69246, '\P{^Bidi_Class=-	Arabic_Number}', "");
    Expect(0, 69247, '\p{Bidi_Class=-	Arabic_Number}', "");
    Expect(1, 69247, '\p{^Bidi_Class=-	Arabic_Number}', "");
    Expect(1, 69247, '\P{Bidi_Class=-	Arabic_Number}', "");
    Expect(0, 69247, '\P{^Bidi_Class=-	Arabic_Number}', "");
    Error('\p{Bc: 	an:=}');
    Error('\P{Bc: 	an:=}');
    Expect(1, 69246, '\p{Bc=:\AAN\z:}', "");;
    Expect(0, 69247, '\p{Bc=:\AAN\z:}', "");;
    Expect(1, 69246, '\p{Bc=an}', "");
    Expect(0, 69246, '\p{^Bc=an}', "");
    Expect(0, 69246, '\P{Bc=an}', "");
    Expect(1, 69246, '\P{^Bc=an}', "");
    Expect(0, 69247, '\p{Bc=an}', "");
    Expect(1, 69247, '\p{^Bc=an}', "");
    Expect(1, 69247, '\P{Bc=an}', "");
    Expect(0, 69247, '\P{^Bc=an}', "");
    Expect(1, 69246, '\p{Bc=:\Aan\z:}', "");;
    Expect(0, 69247, '\p{Bc=:\Aan\z:}', "");;
    Expect(1, 69246, '\p{Bc=__AN}', "");
    Expect(0, 69246, '\p{^Bc=__AN}', "");
    Expect(0, 69246, '\P{Bc=__AN}', "");
    Expect(1, 69246, '\P{^Bc=__AN}', "");
    Expect(0, 69247, '\p{Bc=__AN}', "");
    Expect(1, 69247, '\p{^Bc=__AN}', "");
    Expect(1, 69247, '\P{Bc=__AN}', "");
    Expect(0, 69247, '\P{^Bc=__AN}', "");
    Error('\p{Is_Bidi_Class= -ARABIC_Number:=}');
    Error('\P{Is_Bidi_Class= -ARABIC_Number:=}');
    Expect(1, 69246, '\p{Is_Bidi_Class=arabicnumber}', "");
    Expect(0, 69246, '\p{^Is_Bidi_Class=arabicnumber}', "");
    Expect(0, 69246, '\P{Is_Bidi_Class=arabicnumber}', "");
    Expect(1, 69246, '\P{^Is_Bidi_Class=arabicnumber}', "");
    Expect(0, 69247, '\p{Is_Bidi_Class=arabicnumber}', "");
    Expect(1, 69247, '\p{^Is_Bidi_Class=arabicnumber}', "");
    Expect(1, 69247, '\P{Is_Bidi_Class=arabicnumber}', "");
    Expect(0, 69247, '\P{^Is_Bidi_Class=arabicnumber}', "");
    Expect(1, 69246, '\p{Is_Bidi_Class=	 Arabic_Number}', "");
    Expect(0, 69246, '\p{^Is_Bidi_Class=	 Arabic_Number}', "");
    Expect(0, 69246, '\P{Is_Bidi_Class=	 Arabic_Number}', "");
    Expect(1, 69246, '\P{^Is_Bidi_Class=	 Arabic_Number}', "");
    Expect(0, 69247, '\p{Is_Bidi_Class=	 Arabic_Number}', "");
    Expect(1, 69247, '\p{^Is_Bidi_Class=	 Arabic_Number}', "");
    Expect(1, 69247, '\P{Is_Bidi_Class=	 Arabic_Number}', "");
    Expect(0, 69247, '\P{^Is_Bidi_Class=	 Arabic_Number}', "");
    Error('\p{Is_Bc=_AN/a/}');
    Error('\P{Is_Bc=_AN/a/}');
    Expect(1, 69246, '\p{Is_Bc=an}', "");
    Expect(0, 69246, '\p{^Is_Bc=an}', "");
    Expect(0, 69246, '\P{Is_Bc=an}', "");
    Expect(1, 69246, '\P{^Is_Bc=an}', "");
    Expect(0, 69247, '\p{Is_Bc=an}', "");
    Expect(1, 69247, '\p{^Is_Bc=an}', "");
    Expect(1, 69247, '\P{Is_Bc=an}', "");
    Expect(0, 69247, '\P{^Is_Bc=an}', "");
    Expect(1, 69246, '\p{Is_Bc:   	 an}', "");
    Expect(0, 69246, '\p{^Is_Bc:   	 an}', "");
    Expect(0, 69246, '\P{Is_Bc:   	 an}', "");
    Expect(1, 69246, '\P{^Is_Bc:   	 an}', "");
    Expect(0, 69247, '\p{Is_Bc:   	 an}', "");
    Expect(1, 69247, '\p{^Is_Bc:   	 an}', "");
    Expect(1, 69247, '\P{Is_Bc:   	 an}', "");
    Expect(0, 69247, '\P{^Is_Bc:   	 an}', "");
    Error('\p{Bidi_Class=-:=Paragraph_Separator}');
    Error('\P{Bidi_Class=-:=Paragraph_Separator}');
    Expect(1, 8233, '\p{Bidi_Class=:\AParagraph_Separator\z:}', "");;
    Expect(0, 8234, '\p{Bidi_Class=:\AParagraph_Separator\z:}', "");;
    Expect(1, 8233, '\p{Bidi_Class=paragraphseparator}', "");
    Expect(0, 8233, '\p{^Bidi_Class=paragraphseparator}', "");
    Expect(0, 8233, '\P{Bidi_Class=paragraphseparator}', "");
    Expect(1, 8233, '\P{^Bidi_Class=paragraphseparator}', "");
    Expect(0, 8234, '\p{Bidi_Class=paragraphseparator}', "");
    Expect(1, 8234, '\p{^Bidi_Class=paragraphseparator}', "");
    Expect(1, 8234, '\P{Bidi_Class=paragraphseparator}', "");
    Expect(0, 8234, '\P{^Bidi_Class=paragraphseparator}', "");
    Expect(1, 8233, '\p{Bidi_Class=:\Aparagraphseparator\z:}', "");;
    Expect(0, 8234, '\p{Bidi_Class=:\Aparagraphseparator\z:}', "");;
    Expect(1, 8233, '\p{Bidi_Class=_Paragraph_Separator}', "");
    Expect(0, 8233, '\p{^Bidi_Class=_Paragraph_Separator}', "");
    Expect(0, 8233, '\P{Bidi_Class=_Paragraph_Separator}', "");
    Expect(1, 8233, '\P{^Bidi_Class=_Paragraph_Separator}', "");
    Expect(0, 8234, '\p{Bidi_Class=_Paragraph_Separator}', "");
    Expect(1, 8234, '\p{^Bidi_Class=_Paragraph_Separator}', "");
    Expect(1, 8234, '\P{Bidi_Class=_Paragraph_Separator}', "");
    Expect(0, 8234, '\P{^Bidi_Class=_Paragraph_Separator}', "");
    Error('\p{Bc=/a/--b}');
    Error('\P{Bc=/a/--b}');
    Expect(1, 8233, '\p{Bc=:\AB\z:}', "");;
    Expect(0, 8234, '\p{Bc=:\AB\z:}', "");;
    Expect(1, 8233, '\p{Bc=b}', "");
    Expect(0, 8233, '\p{^Bc=b}', "");
    Expect(0, 8233, '\P{Bc=b}', "");
    Expect(1, 8233, '\P{^Bc=b}', "");
    Expect(0, 8234, '\p{Bc=b}', "");
    Expect(1, 8234, '\p{^Bc=b}', "");
    Expect(1, 8234, '\P{Bc=b}', "");
    Expect(0, 8234, '\P{^Bc=b}', "");
    Expect(1, 8233, '\p{Bc=:\Ab\z:}', "");;
    Expect(0, 8234, '\p{Bc=:\Ab\z:}', "");;
    Expect(1, 8233, '\p{Bc=-b}', "");
    Expect(0, 8233, '\p{^Bc=-b}', "");
    Expect(0, 8233, '\P{Bc=-b}', "");
    Expect(1, 8233, '\P{^Bc=-b}', "");
    Expect(0, 8234, '\p{Bc=-b}', "");
    Expect(1, 8234, '\p{^Bc=-b}', "");
    Expect(1, 8234, '\P{Bc=-b}', "");
    Expect(0, 8234, '\P{^Bc=-b}', "");
    Error('\p{Is_Bidi_Class=	:=Paragraph_Separator}');
    Error('\P{Is_Bidi_Class=	:=Paragraph_Separator}');
    Expect(1, 8233, '\p{Is_Bidi_Class=paragraphseparator}', "");
    Expect(0, 8233, '\p{^Is_Bidi_Class=paragraphseparator}', "");
    Expect(0, 8233, '\P{Is_Bidi_Class=paragraphseparator}', "");
    Expect(1, 8233, '\P{^Is_Bidi_Class=paragraphseparator}', "");
    Expect(0, 8234, '\p{Is_Bidi_Class=paragraphseparator}', "");
    Expect(1, 8234, '\p{^Is_Bidi_Class=paragraphseparator}', "");
    Expect(1, 8234, '\P{Is_Bidi_Class=paragraphseparator}', "");
    Expect(0, 8234, '\P{^Is_Bidi_Class=paragraphseparator}', "");
    Expect(1, 8233, '\p{Is_Bidi_Class=	 Paragraph_separator}', "");
    Expect(0, 8233, '\p{^Is_Bidi_Class=	 Paragraph_separator}', "");
    Expect(0, 8233, '\P{Is_Bidi_Class=	 Paragraph_separator}', "");
    Expect(1, 8233, '\P{^Is_Bidi_Class=	 Paragraph_separator}', "");
    Expect(0, 8234, '\p{Is_Bidi_Class=	 Paragraph_separator}', "");
    Expect(1, 8234, '\p{^Is_Bidi_Class=	 Paragraph_separator}', "");
    Expect(1, 8234, '\P{Is_Bidi_Class=	 Paragraph_separator}', "");
    Expect(0, 8234, '\P{^Is_Bidi_Class=	 Paragraph_separator}', "");
    Error('\p{Is_Bc=_/a/B}');
    Error('\P{Is_Bc=_/a/B}');
    Expect(1, 8233, '\p{Is_Bc=b}', "");
    Expect(0, 8233, '\p{^Is_Bc=b}', "");
    Expect(0, 8233, '\P{Is_Bc=b}', "");
    Expect(1, 8233, '\P{^Is_Bc=b}', "");
    Expect(0, 8234, '\p{Is_Bc=b}', "");
    Expect(1, 8234, '\p{^Is_Bc=b}', "");
    Expect(1, 8234, '\P{Is_Bc=b}', "");
    Expect(0, 8234, '\P{^Is_Bc=b}', "");
    Expect(1, 8233, '\p{Is_Bc=		B}', "");
    Expect(0, 8233, '\p{^Is_Bc=		B}', "");
    Expect(0, 8233, '\P{Is_Bc=		B}', "");
    Expect(1, 8233, '\P{^Is_Bc=		B}', "");
    Expect(0, 8234, '\p{Is_Bc=		B}', "");
    Expect(1, 8234, '\p{^Is_Bc=		B}', "");
    Expect(1, 8234, '\P{Is_Bc=		B}', "");
    Expect(0, 8234, '\P{^Is_Bc=		B}', "");
    Error('\p{Bidi_Class=/a/	boundary_Neutral}');
    Error('\P{Bidi_Class=/a/	boundary_Neutral}');
    Expect(1, 921599, '\p{Bidi_Class=:\ABoundary_Neutral\z:}', "");;
    Expect(0, 1114109, '\p{Bidi_Class=:\ABoundary_Neutral\z:}', "");;
    Expect(1, 921599, '\p{Bidi_Class:   boundaryneutral}', "");
    Expect(0, 921599, '\p{^Bidi_Class:   boundaryneutral}', "");
    Expect(0, 921599, '\P{Bidi_Class:   boundaryneutral}', "");
    Expect(1, 921599, '\P{^Bidi_Class:   boundaryneutral}', "");
    Expect(0, 1114109, '\p{Bidi_Class:   boundaryneutral}', "");
    Expect(1, 1114109, '\p{^Bidi_Class:   boundaryneutral}', "");
    Expect(1, 1114109, '\P{Bidi_Class:   boundaryneutral}', "");
    Expect(0, 1114109, '\P{^Bidi_Class:   boundaryneutral}', "");
    Expect(1, 921599, '\p{Bidi_Class=:\Aboundaryneutral\z:}', "");;
    Expect(0, 1114109, '\p{Bidi_Class=:\Aboundaryneutral\z:}', "");;
    Expect(1, 921599, '\p{Bidi_Class=	Boundary_Neutral}', "");
    Expect(0, 921599, '\p{^Bidi_Class=	Boundary_Neutral}', "");
    Expect(0, 921599, '\P{Bidi_Class=	Boundary_Neutral}', "");
    Expect(1, 921599, '\P{^Bidi_Class=	Boundary_Neutral}', "");
    Expect(0, 1114109, '\p{Bidi_Class=	Boundary_Neutral}', "");
    Expect(1, 1114109, '\p{^Bidi_Class=	Boundary_Neutral}', "");
    Expect(1, 1114109, '\P{Bidi_Class=	Boundary_Neutral}', "");
    Expect(0, 1114109, '\P{^Bidi_Class=	Boundary_Neutral}', "");
    Error('\p{Bc=-BN:=}');
    Error('\P{Bc=-BN:=}');
    Expect(1, 921599, '\p{Bc=:\ABN\z:}', "");;
    Expect(0, 1114109, '\p{Bc=:\ABN\z:}', "");;
    Expect(1, 921599, '\p{Bc=bn}', "");
    Expect(0, 921599, '\p{^Bc=bn}', "");
    Expect(0, 921599, '\P{Bc=bn}', "");
    Expect(1, 921599, '\P{^Bc=bn}', "");
    Expect(0, 1114109, '\p{Bc=bn}', "");
    Expect(1, 1114109, '\p{^Bc=bn}', "");
    Expect(1, 1114109, '\P{Bc=bn}', "");
    Expect(0, 1114109, '\P{^Bc=bn}', "");
    Expect(1, 921599, '\p{Bc=:\Abn\z:}', "");;
    Expect(0, 1114109, '\p{Bc=:\Abn\z:}', "");;
    Expect(1, 921599, '\p{Bc= bn}', "");
    Expect(0, 921599, '\p{^Bc= bn}', "");
    Expect(0, 921599, '\P{Bc= bn}', "");
    Expect(1, 921599, '\P{^Bc= bn}', "");
    Expect(0, 1114109, '\p{Bc= bn}', "");
    Expect(1, 1114109, '\p{^Bc= bn}', "");
    Expect(1, 1114109, '\P{Bc= bn}', "");
    Expect(0, 1114109, '\P{^Bc= bn}', "");
    Error('\p{Is_Bidi_Class=-/a/Boundary_neutral}');
    Error('\P{Is_Bidi_Class=-/a/Boundary_neutral}');
    Expect(1, 921599, '\p{Is_Bidi_Class=boundaryneutral}', "");
    Expect(0, 921599, '\p{^Is_Bidi_Class=boundaryneutral}', "");
    Expect(0, 921599, '\P{Is_Bidi_Class=boundaryneutral}', "");
    Expect(1, 921599, '\P{^Is_Bidi_Class=boundaryneutral}', "");
    Expect(0, 1114109, '\p{Is_Bidi_Class=boundaryneutral}', "");
    Expect(1, 1114109, '\p{^Is_Bidi_Class=boundaryneutral}', "");
    Expect(1, 1114109, '\P{Is_Bidi_Class=boundaryneutral}', "");
    Expect(0, 1114109, '\P{^Is_Bidi_Class=boundaryneutral}', "");
    Expect(1, 921599, '\p{Is_Bidi_Class=__boundary_Neutral}', "");
    Expect(0, 921599, '\p{^Is_Bidi_Class=__boundary_Neutral}', "");
    Expect(0, 921599, '\P{Is_Bidi_Class=__boundary_Neutral}', "");
    Expect(1, 921599, '\P{^Is_Bidi_Class=__boundary_Neutral}', "");
    Expect(0, 1114109, '\p{Is_Bidi_Class=__boundary_Neutral}', "");
    Expect(1, 1114109, '\p{^Is_Bidi_Class=__boundary_Neutral}', "");
    Expect(1, 1114109, '\P{Is_Bidi_Class=__boundary_Neutral}', "");
    Expect(0, 1114109, '\P{^Is_Bidi_Class=__boundary_Neutral}', "");
    Error('\p{Is_Bc=/a/bn}');
    Error('\P{Is_Bc=/a/bn}');
    Expect(1, 921599, '\p{Is_Bc=bn}', "");
    Expect(0, 921599, '\p{^Is_Bc=bn}', "");
    Expect(0, 921599, '\P{Is_Bc=bn}', "");
    Expect(1, 921599, '\P{^Is_Bc=bn}', "");
    Expect(0, 1114109, '\p{Is_Bc=bn}', "");
    Expect(1, 1114109, '\p{^Is_Bc=bn}', "");
    Expect(1, 1114109, '\P{Is_Bc=bn}', "");
    Expect(0, 1114109, '\P{^Is_Bc=bn}', "");
    Expect(1, 921599, '\p{Is_Bc=_ BN}', "");
    Expect(0, 921599, '\p{^Is_Bc=_ BN}', "");
    Expect(0, 921599, '\P{Is_Bc=_ BN}', "");
    Expect(1, 921599, '\P{^Is_Bc=_ BN}', "");
    Expect(0, 1114109, '\p{Is_Bc=_ BN}', "");
    Expect(1, 1114109, '\p{^Is_Bc=_ BN}', "");
    Expect(1, 1114109, '\P{Is_Bc=_ BN}', "");
    Expect(0, 1114109, '\P{^Is_Bc=_ BN}', "");
    Error('\p{Bidi_Class=_COMMON_Separator/a/}');
    Error('\P{Bidi_Class=_COMMON_Separator/a/}');
    Expect(1, 65306, '\p{Bidi_Class=:\ACommon_Separator\z:}', "");;
    Expect(0, 65307, '\p{Bidi_Class=:\ACommon_Separator\z:}', "");;
    Expect(1, 65306, '\p{Bidi_Class=commonseparator}', "");
    Expect(0, 65306, '\p{^Bidi_Class=commonseparator}', "");
    Expect(0, 65306, '\P{Bidi_Class=commonseparator}', "");
    Expect(1, 65306, '\P{^Bidi_Class=commonseparator}', "");
    Expect(0, 65307, '\p{Bidi_Class=commonseparator}', "");
    Expect(1, 65307, '\p{^Bidi_Class=commonseparator}', "");
    Expect(1, 65307, '\P{Bidi_Class=commonseparator}', "");
    Expect(0, 65307, '\P{^Bidi_Class=commonseparator}', "");
    Expect(1, 65306, '\p{Bidi_Class=:\Acommonseparator\z:}', "");;
    Expect(0, 65307, '\p{Bidi_Class=:\Acommonseparator\z:}', "");;
    Expect(1, 65306, '\p{Bidi_Class=-	common_Separator}', "");
    Expect(0, 65306, '\p{^Bidi_Class=-	common_Separator}', "");
    Expect(0, 65306, '\P{Bidi_Class=-	common_Separator}', "");
    Expect(1, 65306, '\P{^Bidi_Class=-	common_Separator}', "");
    Expect(0, 65307, '\p{Bidi_Class=-	common_Separator}', "");
    Expect(1, 65307, '\p{^Bidi_Class=-	common_Separator}', "");
    Expect(1, 65307, '\P{Bidi_Class=-	common_Separator}', "");
    Expect(0, 65307, '\P{^Bidi_Class=-	common_Separator}', "");
    Error('\p{Bc=_-cs:=}');
    Error('\P{Bc=_-cs:=}');
    Expect(1, 65306, '\p{Bc=:\ACS\z:}', "");;
    Expect(0, 65307, '\p{Bc=:\ACS\z:}', "");;
    Expect(1, 65306, '\p{Bc=cs}', "");
    Expect(0, 65306, '\p{^Bc=cs}', "");
    Expect(0, 65306, '\P{Bc=cs}', "");
    Expect(1, 65306, '\P{^Bc=cs}', "");
    Expect(0, 65307, '\p{Bc=cs}', "");
    Expect(1, 65307, '\p{^Bc=cs}', "");
    Expect(1, 65307, '\P{Bc=cs}', "");
    Expect(0, 65307, '\P{^Bc=cs}', "");
    Expect(1, 65306, '\p{Bc=:\Acs\z:}', "");;
    Expect(0, 65307, '\p{Bc=:\Acs\z:}', "");;
    Expect(1, 65306, '\p{Bc=		cs}', "");
    Expect(0, 65306, '\p{^Bc=		cs}', "");
    Expect(0, 65306, '\P{Bc=		cs}', "");
    Expect(1, 65306, '\P{^Bc=		cs}', "");
    Expect(0, 65307, '\p{Bc=		cs}', "");
    Expect(1, 65307, '\p{^Bc=		cs}', "");
    Expect(1, 65307, '\P{Bc=		cs}', "");
    Expect(0, 65307, '\P{^Bc=		cs}', "");
    Error('\p{Is_Bidi_Class:-/a/Common_Separator}');
    Error('\P{Is_Bidi_Class:-/a/Common_Separator}');
    Expect(1, 65306, '\p{Is_Bidi_Class=commonseparator}', "");
    Expect(0, 65306, '\p{^Is_Bidi_Class=commonseparator}', "");
    Expect(0, 65306, '\P{Is_Bidi_Class=commonseparator}', "");
    Expect(1, 65306, '\P{^Is_Bidi_Class=commonseparator}', "");
    Expect(0, 65307, '\p{Is_Bidi_Class=commonseparator}', "");
    Expect(1, 65307, '\p{^Is_Bidi_Class=commonseparator}', "");
    Expect(1, 65307, '\P{Is_Bidi_Class=commonseparator}', "");
    Expect(0, 65307, '\P{^Is_Bidi_Class=commonseparator}', "");
    Expect(1, 65306, '\p{Is_Bidi_Class=	-COMMON_Separator}', "");
    Expect(0, 65306, '\p{^Is_Bidi_Class=	-COMMON_Separator}', "");
    Expect(0, 65306, '\P{Is_Bidi_Class=	-COMMON_Separator}', "");
    Expect(1, 65306, '\P{^Is_Bidi_Class=	-COMMON_Separator}', "");
    Expect(0, 65307, '\p{Is_Bidi_Class=	-COMMON_Separator}', "");
    Expect(1, 65307, '\p{^Is_Bidi_Class=	-COMMON_Separator}', "");
    Expect(1, 65307, '\P{Is_Bidi_Class=	-COMMON_Separator}', "");
    Expect(0, 65307, '\P{^Is_Bidi_Class=	-COMMON_Separator}', "");
    Error('\p{Is_Bc:		:=cs}');
    Error('\P{Is_Bc:		:=cs}');
    Expect(1, 65306, '\p{Is_Bc=cs}', "");
    Expect(0, 65306, '\p{^Is_Bc=cs}', "");
    Expect(0, 65306, '\P{Is_Bc=cs}', "");
    Expect(1, 65306, '\P{^Is_Bc=cs}', "");
    Expect(0, 65307, '\p{Is_Bc=cs}', "");
    Expect(1, 65307, '\p{^Is_Bc=cs}', "");
    Expect(1, 65307, '\P{Is_Bc=cs}', "");
    Expect(0, 65307, '\P{^Is_Bc=cs}', "");
    Expect(1, 65306, '\p{Is_Bc=-_CS}', "");
    Expect(0, 65306, '\p{^Is_Bc=-_CS}', "");
    Expect(0, 65306, '\P{Is_Bc=-_CS}', "");
    Expect(1, 65306, '\P{^Is_Bc=-_CS}', "");
    Expect(0, 65307, '\p{Is_Bc=-_CS}', "");
    Expect(1, 65307, '\p{^Is_Bc=-_CS}', "");
    Expect(1, 65307, '\P{Is_Bc=-_CS}', "");
    Expect(0, 65307, '\P{^Is_Bc=-_CS}', "");
    Error('\p{Bidi_Class::=		European_number}');
    Error('\P{Bidi_Class::=		European_number}');
    Expect(1, 130041, '\p{Bidi_Class=:\AEuropean_Number\z:}', "");;
    Expect(0, 130042, '\p{Bidi_Class=:\AEuropean_Number\z:}', "");;
    Expect(1, 130041, '\p{Bidi_Class=europeannumber}', "");
    Expect(0, 130041, '\p{^Bidi_Class=europeannumber}', "");
    Expect(0, 130041, '\P{Bidi_Class=europeannumber}', "");
    Expect(1, 130041, '\P{^Bidi_Class=europeannumber}', "");
    Expect(0, 130042, '\p{Bidi_Class=europeannumber}', "");
    Expect(1, 130042, '\p{^Bidi_Class=europeannumber}', "");
    Expect(1, 130042, '\P{Bidi_Class=europeannumber}', "");
    Expect(0, 130042, '\P{^Bidi_Class=europeannumber}', "");
    Expect(1, 130041, '\p{Bidi_Class=:\Aeuropeannumber\z:}', "");;
    Expect(0, 130042, '\p{Bidi_Class=:\Aeuropeannumber\z:}', "");;
    Expect(1, 130041, '\p{Bidi_Class=- EUROPEAN_NUMBER}', "");
    Expect(0, 130041, '\p{^Bidi_Class=- EUROPEAN_NUMBER}', "");
    Expect(0, 130041, '\P{Bidi_Class=- EUROPEAN_NUMBER}', "");
    Expect(1, 130041, '\P{^Bidi_Class=- EUROPEAN_NUMBER}', "");
    Expect(0, 130042, '\p{Bidi_Class=- EUROPEAN_NUMBER}', "");
    Expect(1, 130042, '\p{^Bidi_Class=- EUROPEAN_NUMBER}', "");
    Expect(1, 130042, '\P{Bidi_Class=- EUROPEAN_NUMBER}', "");
    Expect(0, 130042, '\P{^Bidi_Class=- EUROPEAN_NUMBER}', "");
    Error('\p{Bc=	:=EN}');
    Error('\P{Bc=	:=EN}');
    Expect(1, 130041, '\p{Bc=:\AEN\z:}', "");;
    Expect(0, 130042, '\p{Bc=:\AEN\z:}', "");;
    Expect(1, 130041, '\p{Bc=en}', "");
    Expect(0, 130041, '\p{^Bc=en}', "");
    Expect(0, 130041, '\P{Bc=en}', "");
    Expect(1, 130041, '\P{^Bc=en}', "");
    Expect(0, 130042, '\p{Bc=en}', "");
    Expect(1, 130042, '\p{^Bc=en}', "");
    Expect(1, 130042, '\P{Bc=en}', "");
    Expect(0, 130042, '\P{^Bc=en}', "");
    Expect(1, 130041, '\p{Bc=:\Aen\z:}', "");;
    Expect(0, 130042, '\p{Bc=:\Aen\z:}', "");;
    Expect(1, 130041, '\p{Bc=-EN}', "");
    Expect(0, 130041, '\p{^Bc=-EN}', "");
    Expect(0, 130041, '\P{Bc=-EN}', "");
    Expect(1, 130041, '\P{^Bc=-EN}', "");
    Expect(0, 130042, '\p{Bc=-EN}', "");
    Expect(1, 130042, '\p{^Bc=-EN}', "");
    Expect(1, 130042, '\P{Bc=-EN}', "");
    Expect(0, 130042, '\P{^Bc=-EN}', "");
    Error('\p{Is_Bidi_Class=:= 	european_number}');
    Error('\P{Is_Bidi_Class=:= 	european_number}');
    Expect(1, 130041, '\p{Is_Bidi_Class=europeannumber}', "");
    Expect(0, 130041, '\p{^Is_Bidi_Class=europeannumber}', "");
    Expect(0, 130041, '\P{Is_Bidi_Class=europeannumber}', "");
    Expect(1, 130041, '\P{^Is_Bidi_Class=europeannumber}', "");
    Expect(0, 130042, '\p{Is_Bidi_Class=europeannumber}', "");
    Expect(1, 130042, '\p{^Is_Bidi_Class=europeannumber}', "");
    Expect(1, 130042, '\P{Is_Bidi_Class=europeannumber}', "");
    Expect(0, 130042, '\P{^Is_Bidi_Class=europeannumber}', "");
    Expect(1, 130041, '\p{Is_Bidi_Class=_ european_Number}', "");
    Expect(0, 130041, '\p{^Is_Bidi_Class=_ european_Number}', "");
    Expect(0, 130041, '\P{Is_Bidi_Class=_ european_Number}', "");
    Expect(1, 130041, '\P{^Is_Bidi_Class=_ european_Number}', "");
    Expect(0, 130042, '\p{Is_Bidi_Class=_ european_Number}', "");
    Expect(1, 130042, '\p{^Is_Bidi_Class=_ european_Number}', "");
    Expect(1, 130042, '\P{Is_Bidi_Class=_ european_Number}', "");
    Expect(0, 130042, '\P{^Is_Bidi_Class=_ european_Number}', "");
    Error('\p{Is_Bc=-:=EN}');
    Error('\P{Is_Bc=-:=EN}');
    Expect(1, 130041, '\p{Is_Bc=en}', "");
    Expect(0, 130041, '\p{^Is_Bc=en}', "");
    Expect(0, 130041, '\P{Is_Bc=en}', "");
    Expect(1, 130041, '\P{^Is_Bc=en}', "");
    Expect(0, 130042, '\p{Is_Bc=en}', "");
    Expect(1, 130042, '\p{^Is_Bc=en}', "");
    Expect(1, 130042, '\P{Is_Bc=en}', "");
    Expect(0, 130042, '\P{^Is_Bc=en}', "");
    Expect(1, 130041, '\p{Is_Bc:-EN}', "");
    Expect(0, 130041, '\p{^Is_Bc:-EN}', "");
    Expect(0, 130041, '\P{Is_Bc:-EN}', "");
    Expect(1, 130041, '\P{^Is_Bc:-EN}', "");
    Expect(0, 130042, '\p{Is_Bc:-EN}', "");
    Expect(1, 130042, '\p{^Is_Bc:-EN}', "");
    Expect(1, 130042, '\P{Is_Bc:-EN}', "");
    Expect(0, 130042, '\P{^Is_Bc:-EN}', "");
    Error('\p{Bidi_Class=/a/--European_Separator}');
    Error('\P{Bidi_Class=/a/--European_Separator}');
    Expect(1, 65293, '\p{Bidi_Class=:\AEuropean_Separator\z:}', "");;
    Expect(0, 65294, '\p{Bidi_Class=:\AEuropean_Separator\z:}', "");;
    Expect(1, 65293, '\p{Bidi_Class=europeanseparator}', "");
    Expect(0, 65293, '\p{^Bidi_Class=europeanseparator}', "");
    Expect(0, 65293, '\P{Bidi_Class=europeanseparator}', "");
    Expect(1, 65293, '\P{^Bidi_Class=europeanseparator}', "");
    Expect(0, 65294, '\p{Bidi_Class=europeanseparator}', "");
    Expect(1, 65294, '\p{^Bidi_Class=europeanseparator}', "");
    Expect(1, 65294, '\P{Bidi_Class=europeanseparator}', "");
    Expect(0, 65294, '\P{^Bidi_Class=europeanseparator}', "");
    Expect(1, 65293, '\p{Bidi_Class=:\Aeuropeanseparator\z:}', "");;
    Expect(0, 65294, '\p{Bidi_Class=:\Aeuropeanseparator\z:}', "");;
    Expect(1, 65293, '\p{Bidi_Class=_European_Separator}', "");
    Expect(0, 65293, '\p{^Bidi_Class=_European_Separator}', "");
    Expect(0, 65293, '\P{Bidi_Class=_European_Separator}', "");
    Expect(1, 65293, '\P{^Bidi_Class=_European_Separator}', "");
    Expect(0, 65294, '\p{Bidi_Class=_European_Separator}', "");
    Expect(1, 65294, '\p{^Bidi_Class=_European_Separator}', "");
    Expect(1, 65294, '\P{Bidi_Class=_European_Separator}', "");
    Expect(0, 65294, '\P{^Bidi_Class=_European_Separator}', "");
    Error('\p{Bc= ES/a/}');
    Error('\P{Bc= ES/a/}');
    Expect(1, 65293, '\p{Bc=:\AES\z:}', "");;
    Expect(0, 65294, '\p{Bc=:\AES\z:}', "");;
    Expect(1, 65293, '\p{Bc=es}', "");
    Expect(0, 65293, '\p{^Bc=es}', "");
    Expect(0, 65293, '\P{Bc=es}', "");
    Expect(1, 65293, '\P{^Bc=es}', "");
    Expect(0, 65294, '\p{Bc=es}', "");
    Expect(1, 65294, '\p{^Bc=es}', "");
    Expect(1, 65294, '\P{Bc=es}', "");
    Expect(0, 65294, '\P{^Bc=es}', "");
    Expect(1, 65293, '\p{Bc=:\Aes\z:}', "");;
    Expect(0, 65294, '\p{Bc=:\Aes\z:}', "");;
    Expect(1, 65293, '\p{Bc=_ES}', "");
    Expect(0, 65293, '\p{^Bc=_ES}', "");
    Expect(0, 65293, '\P{Bc=_ES}', "");
    Expect(1, 65293, '\P{^Bc=_ES}', "");
    Expect(0, 65294, '\p{Bc=_ES}', "");
    Expect(1, 65294, '\p{^Bc=_ES}', "");
    Expect(1, 65294, '\P{Bc=_ES}', "");
    Expect(0, 65294, '\P{^Bc=_ES}', "");
    Error('\p{Is_Bidi_Class=- European_Separator/a/}');
    Error('\P{Is_Bidi_Class=- European_Separator/a/}');
    Expect(1, 65293, '\p{Is_Bidi_Class=europeanseparator}', "");
    Expect(0, 65293, '\p{^Is_Bidi_Class=europeanseparator}', "");
    Expect(0, 65293, '\P{Is_Bidi_Class=europeanseparator}', "");
    Expect(1, 65293, '\P{^Is_Bidi_Class=europeanseparator}', "");
    Expect(0, 65294, '\p{Is_Bidi_Class=europeanseparator}', "");
    Expect(1, 65294, '\p{^Is_Bidi_Class=europeanseparator}', "");
    Expect(1, 65294, '\P{Is_Bidi_Class=europeanseparator}', "");
    Expect(0, 65294, '\P{^Is_Bidi_Class=europeanseparator}', "");
    Expect(1, 65293, '\p{Is_Bidi_Class:   	-EUROPEAN_Separator}', "");
    Expect(0, 65293, '\p{^Is_Bidi_Class:   	-EUROPEAN_Separator}', "");
    Expect(0, 65293, '\P{Is_Bidi_Class:   	-EUROPEAN_Separator}', "");
    Expect(1, 65293, '\P{^Is_Bidi_Class:   	-EUROPEAN_Separator}', "");
    Expect(0, 65294, '\p{Is_Bidi_Class:   	-EUROPEAN_Separator}', "");
    Expect(1, 65294, '\p{^Is_Bidi_Class:   	-EUROPEAN_Separator}', "");
    Expect(1, 65294, '\P{Is_Bidi_Class:   	-EUROPEAN_Separator}', "");
    Expect(0, 65294, '\P{^Is_Bidi_Class:   	-EUROPEAN_Separator}', "");
    Error('\p{Is_Bc=-/a/ES}');
    Error('\P{Is_Bc=-/a/ES}');
    Expect(1, 65293, '\p{Is_Bc=es}', "");
    Expect(0, 65293, '\p{^Is_Bc=es}', "");
    Expect(0, 65293, '\P{Is_Bc=es}', "");
    Expect(1, 65293, '\P{^Is_Bc=es}', "");
    Expect(0, 65294, '\p{Is_Bc=es}', "");
    Expect(1, 65294, '\p{^Is_Bc=es}', "");
    Expect(1, 65294, '\P{Is_Bc=es}', "");
    Expect(0, 65294, '\P{^Is_Bc=es}', "");
    Expect(1, 65293, '\p{Is_Bc=- ES}', "");
    Expect(0, 65293, '\p{^Is_Bc=- ES}', "");
    Expect(0, 65293, '\P{Is_Bc=- ES}', "");
    Expect(1, 65293, '\P{^Is_Bc=- ES}', "");
    Expect(0, 65294, '\p{Is_Bc=- ES}', "");
    Expect(1, 65294, '\p{^Is_Bc=- ES}', "");
    Expect(1, 65294, '\P{Is_Bc=- ES}', "");
    Expect(0, 65294, '\P{^Is_Bc=- ES}', "");
    Error('\p{Bidi_Class=_European_TERMINATOR:=}');
    Error('\P{Bidi_Class=_European_TERMINATOR:=}');
    Expect(1, 123647, '\p{Bidi_Class=:\AEuropean_Terminator\z:}', "");;
    Expect(0, 123648, '\p{Bidi_Class=:\AEuropean_Terminator\z:}', "");;
    Expect(1, 123647, '\p{Bidi_Class=europeanterminator}', "");
    Expect(0, 123647, '\p{^Bidi_Class=europeanterminator}', "");
    Expect(0, 123647, '\P{Bidi_Class=europeanterminator}', "");
    Expect(1, 123647, '\P{^Bidi_Class=europeanterminator}', "");
    Expect(0, 123648, '\p{Bidi_Class=europeanterminator}', "");
    Expect(1, 123648, '\p{^Bidi_Class=europeanterminator}', "");
    Expect(1, 123648, '\P{Bidi_Class=europeanterminator}', "");
    Expect(0, 123648, '\P{^Bidi_Class=europeanterminator}', "");
    Expect(1, 123647, '\p{Bidi_Class=:\Aeuropeanterminator\z:}', "");;
    Expect(0, 123648, '\p{Bidi_Class=:\Aeuropeanterminator\z:}', "");;
    Expect(1, 123647, '\p{Bidi_Class:	_	European_Terminator}', "");
    Expect(0, 123647, '\p{^Bidi_Class:	_	European_Terminator}', "");
    Expect(0, 123647, '\P{Bidi_Class:	_	European_Terminator}', "");
    Expect(1, 123647, '\P{^Bidi_Class:	_	European_Terminator}', "");
    Expect(0, 123648, '\p{Bidi_Class:	_	European_Terminator}', "");
    Expect(1, 123648, '\p{^Bidi_Class:	_	European_Terminator}', "");
    Expect(1, 123648, '\P{Bidi_Class:	_	European_Terminator}', "");
    Expect(0, 123648, '\P{^Bidi_Class:	_	European_Terminator}', "");
    Error('\p{Bc=:=__ET}');
    Error('\P{Bc=:=__ET}');
    Expect(1, 123647, '\p{Bc=:\AET\z:}', "");;
    Expect(0, 123648, '\p{Bc=:\AET\z:}', "");;
    Expect(1, 123647, '\p{Bc=et}', "");
    Expect(0, 123647, '\p{^Bc=et}', "");
    Expect(0, 123647, '\P{Bc=et}', "");
    Expect(1, 123647, '\P{^Bc=et}', "");
    Expect(0, 123648, '\p{Bc=et}', "");
    Expect(1, 123648, '\p{^Bc=et}', "");
    Expect(1, 123648, '\P{Bc=et}', "");
    Expect(0, 123648, '\P{^Bc=et}', "");
    Expect(1, 123647, '\p{Bc=:\Aet\z:}', "");;
    Expect(0, 123648, '\p{Bc=:\Aet\z:}', "");;
    Expect(1, 123647, '\p{Bc=-ET}', "");
    Expect(0, 123647, '\p{^Bc=-ET}', "");
    Expect(0, 123647, '\P{Bc=-ET}', "");
    Expect(1, 123647, '\P{^Bc=-ET}', "");
    Expect(0, 123648, '\p{Bc=-ET}', "");
    Expect(1, 123648, '\p{^Bc=-ET}', "");
    Expect(1, 123648, '\P{Bc=-ET}', "");
    Expect(0, 123648, '\P{^Bc=-ET}', "");
    Error('\p{Is_Bidi_Class=_:=European_terminator}');
    Error('\P{Is_Bidi_Class=_:=European_terminator}');
    Expect(1, 123647, '\p{Is_Bidi_Class=europeanterminator}', "");
    Expect(0, 123647, '\p{^Is_Bidi_Class=europeanterminator}', "");
    Expect(0, 123647, '\P{Is_Bidi_Class=europeanterminator}', "");
    Expect(1, 123647, '\P{^Is_Bidi_Class=europeanterminator}', "");
    Expect(0, 123648, '\p{Is_Bidi_Class=europeanterminator}', "");
    Expect(1, 123648, '\p{^Is_Bidi_Class=europeanterminator}', "");
    Expect(1, 123648, '\P{Is_Bidi_Class=europeanterminator}', "");
    Expect(0, 123648, '\P{^Is_Bidi_Class=europeanterminator}', "");
    Expect(1, 123647, '\p{Is_Bidi_Class= European_terminator}', "");
    Expect(0, 123647, '\p{^Is_Bidi_Class= European_terminator}', "");
    Expect(0, 123647, '\P{Is_Bidi_Class= European_terminator}', "");
    Expect(1, 123647, '\P{^Is_Bidi_Class= European_terminator}', "");
    Expect(0, 123648, '\p{Is_Bidi_Class= European_terminator}', "");
    Expect(1, 123648, '\p{^Is_Bidi_Class= European_terminator}', "");
    Expect(1, 123648, '\P{Is_Bidi_Class= European_terminator}', "");
    Expect(0, 123648, '\P{^Is_Bidi_Class= European_terminator}', "");
    Error('\p{Is_Bc=:=ET}');
    Error('\P{Is_Bc=:=ET}');
    Expect(1, 123647, '\p{Is_Bc=et}', "");
    Expect(0, 123647, '\p{^Is_Bc=et}', "");
    Expect(0, 123647, '\P{Is_Bc=et}', "");
    Expect(1, 123647, '\P{^Is_Bc=et}', "");
    Expect(0, 123648, '\p{Is_Bc=et}', "");
    Expect(1, 123648, '\p{^Is_Bc=et}', "");
    Expect(1, 123648, '\P{Is_Bc=et}', "");
    Expect(0, 123648, '\P{^Is_Bc=et}', "");
    Expect(1, 123647, '\p{Is_Bc: _	et}', "");
    Expect(0, 123647, '\p{^Is_Bc: _	et}', "");
    Expect(0, 123647, '\P{Is_Bc: _	et}', "");
    Expect(1, 123647, '\P{^Is_Bc: _	et}', "");
    Expect(0, 123648, '\p{Is_Bc: _	et}', "");
    Expect(1, 123648, '\p{^Is_Bc: _	et}', "");
    Expect(1, 123648, '\P{Is_Bc: _	et}', "");
    Expect(0, 123648, '\P{^Is_Bc: _	et}', "");
    Error('\p{Bidi_Class: _:=First_Strong_Isolate}');
    Error('\P{Bidi_Class: _:=First_Strong_Isolate}');
    Expect(1, 8296, '\p{Bidi_Class=:\AFirst_Strong_Isolate\z:}', "");;
    Expect(0, 8297, '\p{Bidi_Class=:\AFirst_Strong_Isolate\z:}', "");;
    Expect(1, 8296, '\p{Bidi_Class=firststrongisolate}', "");
    Expect(0, 8296, '\p{^Bidi_Class=firststrongisolate}', "");
    Expect(0, 8296, '\P{Bidi_Class=firststrongisolate}', "");
    Expect(1, 8296, '\P{^Bidi_Class=firststrongisolate}', "");
    Expect(0, 8297, '\p{Bidi_Class=firststrongisolate}', "");
    Expect(1, 8297, '\p{^Bidi_Class=firststrongisolate}', "");
    Expect(1, 8297, '\P{Bidi_Class=firststrongisolate}', "");
    Expect(0, 8297, '\P{^Bidi_Class=firststrongisolate}', "");
    Expect(1, 8296, '\p{Bidi_Class=:\Afirststrongisolate\z:}', "");;
    Expect(0, 8297, '\p{Bidi_Class=:\Afirststrongisolate\z:}', "");;
    Expect(1, 8296, '\p{Bidi_Class=_First_strong_Isolate}', "");
    Expect(0, 8296, '\p{^Bidi_Class=_First_strong_Isolate}', "");
    Expect(0, 8296, '\P{Bidi_Class=_First_strong_Isolate}', "");
    Expect(1, 8296, '\P{^Bidi_Class=_First_strong_Isolate}', "");
    Expect(0, 8297, '\p{Bidi_Class=_First_strong_Isolate}', "");
    Expect(1, 8297, '\p{^Bidi_Class=_First_strong_Isolate}', "");
    Expect(1, 8297, '\P{Bidi_Class=_First_strong_Isolate}', "");
    Expect(0, 8297, '\P{^Bidi_Class=_First_strong_Isolate}', "");
    Error('\p{Bc:  -FSI/a/}');
    Error('\P{Bc:  -FSI/a/}');
    Expect(1, 8296, '\p{Bc=:\AFSI\z:}', "");;
    Expect(0, 8297, '\p{Bc=:\AFSI\z:}', "");;
    Expect(1, 8296, '\p{Bc=fsi}', "");
    Expect(0, 8296, '\p{^Bc=fsi}', "");
    Expect(0, 8296, '\P{Bc=fsi}', "");
    Expect(1, 8296, '\P{^Bc=fsi}', "");
    Expect(0, 8297, '\p{Bc=fsi}', "");
    Expect(1, 8297, '\p{^Bc=fsi}', "");
    Expect(1, 8297, '\P{Bc=fsi}', "");
    Expect(0, 8297, '\P{^Bc=fsi}', "");
    Expect(1, 8296, '\p{Bc=:\Afsi\z:}', "");;
    Expect(0, 8297, '\p{Bc=:\Afsi\z:}', "");;
    Expect(1, 8296, '\p{Bc=	 FSI}', "");
    Expect(0, 8296, '\p{^Bc=	 FSI}', "");
    Expect(0, 8296, '\P{Bc=	 FSI}', "");
    Expect(1, 8296, '\P{^Bc=	 FSI}', "");
    Expect(0, 8297, '\p{Bc=	 FSI}', "");
    Expect(1, 8297, '\p{^Bc=	 FSI}', "");
    Expect(1, 8297, '\P{Bc=	 FSI}', "");
    Expect(0, 8297, '\P{^Bc=	 FSI}', "");
    Error('\p{Is_Bidi_Class=-/a/first_Strong_Isolate}');
    Error('\P{Is_Bidi_Class=-/a/first_Strong_Isolate}');
    Expect(1, 8296, '\p{Is_Bidi_Class=firststrongisolate}', "");
    Expect(0, 8296, '\p{^Is_Bidi_Class=firststrongisolate}', "");
    Expect(0, 8296, '\P{Is_Bidi_Class=firststrongisolate}', "");
    Expect(1, 8296, '\P{^Is_Bidi_Class=firststrongisolate}', "");
    Expect(0, 8297, '\p{Is_Bidi_Class=firststrongisolate}', "");
    Expect(1, 8297, '\p{^Is_Bidi_Class=firststrongisolate}', "");
    Expect(1, 8297, '\P{Is_Bidi_Class=firststrongisolate}', "");
    Expect(0, 8297, '\P{^Is_Bidi_Class=firststrongisolate}', "");
    Expect(1, 8296, '\p{Is_Bidi_Class=  First_STRONG_Isolate}', "");
    Expect(0, 8296, '\p{^Is_Bidi_Class=  First_STRONG_Isolate}', "");
    Expect(0, 8296, '\P{Is_Bidi_Class=  First_STRONG_Isolate}', "");
    Expect(1, 8296, '\P{^Is_Bidi_Class=  First_STRONG_Isolate}', "");
    Expect(0, 8297, '\p{Is_Bidi_Class=  First_STRONG_Isolate}', "");
    Expect(1, 8297, '\p{^Is_Bidi_Class=  First_STRONG_Isolate}', "");
    Expect(1, 8297, '\P{Is_Bidi_Class=  First_STRONG_Isolate}', "");
    Expect(0, 8297, '\P{^Is_Bidi_Class=  First_STRONG_Isolate}', "");
    Error('\p{Is_Bc=	/a/FSI}');
    Error('\P{Is_Bc=	/a/FSI}');
    Expect(1, 8296, '\p{Is_Bc=fsi}', "");
    Expect(0, 8296, '\p{^Is_Bc=fsi}', "");
    Expect(0, 8296, '\P{Is_Bc=fsi}', "");
    Expect(1, 8296, '\P{^Is_Bc=fsi}', "");
    Expect(0, 8297, '\p{Is_Bc=fsi}', "");
    Expect(1, 8297, '\p{^Is_Bc=fsi}', "");
    Expect(1, 8297, '\P{Is_Bc=fsi}', "");
    Expect(0, 8297, '\P{^Is_Bc=fsi}', "");
    Expect(1, 8296, '\p{Is_Bc=	FSI}', "");
    Expect(0, 8296, '\p{^Is_Bc=	FSI}', "");
    Expect(0, 8296, '\P{Is_Bc=	FSI}', "");
    Expect(1, 8296, '\P{^Is_Bc=	FSI}', "");
    Expect(0, 8297, '\p{Is_Bc=	FSI}', "");
    Expect(1, 8297, '\p{^Is_Bc=	FSI}', "");
    Expect(1, 8297, '\P{Is_Bc=	FSI}', "");
    Expect(0, 8297, '\P{^Is_Bc=	FSI}', "");
    Error('\p{Bidi_Class=	/a/Left_TO_Right}');
    Error('\P{Bidi_Class=	/a/Left_TO_Right}');
    Expect(1, 1114109, '\p{Bidi_Class=:\ALeft_To_Right\z:}', "");;
    Expect(0, 921599, '\p{Bidi_Class=:\ALeft_To_Right\z:}', "");;
    Expect(1, 1114109, '\p{Bidi_Class=lefttoright}', "");
    Expect(0, 1114109, '\p{^Bidi_Class=lefttoright}', "");
    Expect(0, 1114109, '\P{Bidi_Class=lefttoright}', "");
    Expect(1, 1114109, '\P{^Bidi_Class=lefttoright}', "");
    Expect(0, 921599, '\p{Bidi_Class=lefttoright}', "");
    Expect(1, 921599, '\p{^Bidi_Class=lefttoright}', "");
    Expect(1, 921599, '\P{Bidi_Class=lefttoright}', "");
    Expect(0, 921599, '\P{^Bidi_Class=lefttoright}', "");
    Expect(1, 1114109, '\p{Bidi_Class=:\Alefttoright\z:}', "");;
    Expect(0, 921599, '\p{Bidi_Class=:\Alefttoright\z:}', "");;
    Expect(1, 1114109, '\p{Bidi_Class=_-Left_TO_Right}', "");
    Expect(0, 1114109, '\p{^Bidi_Class=_-Left_TO_Right}', "");
    Expect(0, 1114109, '\P{Bidi_Class=_-Left_TO_Right}', "");
    Expect(1, 1114109, '\P{^Bidi_Class=_-Left_TO_Right}', "");
    Expect(0, 921599, '\p{Bidi_Class=_-Left_TO_Right}', "");
    Expect(1, 921599, '\p{^Bidi_Class=_-Left_TO_Right}', "");
    Expect(1, 921599, '\P{Bidi_Class=_-Left_TO_Right}', "");
    Expect(0, 921599, '\P{^Bidi_Class=_-Left_TO_Right}', "");
    Error('\p{Bc=	/a/l}');
    Error('\P{Bc=	/a/l}');
    Expect(1, 1114109, '\p{Bc=:\AL\z:}', "");;
    Expect(0, 921599, '\p{Bc=:\AL\z:}', "");;
    Expect(1, 1114109, '\p{Bc=l}', "");
    Expect(0, 1114109, '\p{^Bc=l}', "");
    Expect(0, 1114109, '\P{Bc=l}', "");
    Expect(1, 1114109, '\P{^Bc=l}', "");
    Expect(0, 921599, '\p{Bc=l}', "");
    Expect(1, 921599, '\p{^Bc=l}', "");
    Expect(1, 921599, '\P{Bc=l}', "");
    Expect(0, 921599, '\P{^Bc=l}', "");
    Expect(1, 1114109, '\p{Bc=:\Al\z:}', "");;
    Expect(0, 921599, '\p{Bc=:\Al\z:}', "");;
    Expect(1, 1114109, '\p{Bc:   - L}', "");
    Expect(0, 1114109, '\p{^Bc:   - L}', "");
    Expect(0, 1114109, '\P{Bc:   - L}', "");
    Expect(1, 1114109, '\P{^Bc:   - L}', "");
    Expect(0, 921599, '\p{Bc:   - L}', "");
    Expect(1, 921599, '\p{^Bc:   - L}', "");
    Expect(1, 921599, '\P{Bc:   - L}', "");
    Expect(0, 921599, '\P{^Bc:   - L}', "");
    Error('\p{Is_Bidi_Class=	/a/Left_To_right}');
    Error('\P{Is_Bidi_Class=	/a/Left_To_right}');
    Expect(1, 1114109, '\p{Is_Bidi_Class=lefttoright}', "");
    Expect(0, 1114109, '\p{^Is_Bidi_Class=lefttoright}', "");
    Expect(0, 1114109, '\P{Is_Bidi_Class=lefttoright}', "");
    Expect(1, 1114109, '\P{^Is_Bidi_Class=lefttoright}', "");
    Expect(0, 921599, '\p{Is_Bidi_Class=lefttoright}', "");
    Expect(1, 921599, '\p{^Is_Bidi_Class=lefttoright}', "");
    Expect(1, 921599, '\P{Is_Bidi_Class=lefttoright}', "");
    Expect(0, 921599, '\P{^Is_Bidi_Class=lefttoright}', "");
    Expect(1, 1114109, '\p{Is_Bidi_Class=	LEFT_TO_Right}', "");
    Expect(0, 1114109, '\p{^Is_Bidi_Class=	LEFT_TO_Right}', "");
    Expect(0, 1114109, '\P{Is_Bidi_Class=	LEFT_TO_Right}', "");
    Expect(1, 1114109, '\P{^Is_Bidi_Class=	LEFT_TO_Right}', "");
    Expect(0, 921599, '\p{Is_Bidi_Class=	LEFT_TO_Right}', "");
    Expect(1, 921599, '\p{^Is_Bidi_Class=	LEFT_TO_Right}', "");
    Expect(1, 921599, '\P{Is_Bidi_Class=	LEFT_TO_Right}', "");
    Expect(0, 921599, '\P{^Is_Bidi_Class=	LEFT_TO_Right}', "");
    Error('\p{Is_Bc=_/a/L}');
    Error('\P{Is_Bc=_/a/L}');
    Expect(1, 1114109, '\p{Is_Bc=l}', "");
    Expect(0, 1114109, '\p{^Is_Bc=l}', "");
    Expect(0, 1114109, '\P{Is_Bc=l}', "");
    Expect(1, 1114109, '\P{^Is_Bc=l}', "");
    Expect(0, 921599, '\p{Is_Bc=l}', "");
    Expect(1, 921599, '\p{^Is_Bc=l}', "");
    Expect(1, 921599, '\P{Is_Bc=l}', "");
    Expect(0, 921599, '\P{^Is_Bc=l}', "");
    Expect(1, 1114109, '\p{Is_Bc=	L}', "");
    Expect(0, 1114109, '\p{^Is_Bc=	L}', "");
    Expect(0, 1114109, '\P{Is_Bc=	L}', "");
    Expect(1, 1114109, '\P{^Is_Bc=	L}', "");
    Expect(0, 921599, '\p{Is_Bc=	L}', "");
    Expect(1, 921599, '\p{^Is_Bc=	L}', "");
    Expect(1, 921599, '\P{Is_Bc=	L}', "");
    Expect(0, 921599, '\P{^Is_Bc=	L}', "");
    Error('\p{Bidi_Class:   /a/-left_to_Right_Embedding}');
    Error('\P{Bidi_Class:   /a/-left_to_Right_Embedding}');
    Expect(1, 8234, '\p{Bidi_Class=:\ALeft_To_Right_Embedding\z:}', "");;
    Expect(0, 8235, '\p{Bidi_Class=:\ALeft_To_Right_Embedding\z:}', "");;
    Expect(1, 8234, '\p{Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8234, '\p{^Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8234, '\P{Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8234, '\P{^Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8235, '\p{Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8235, '\p{^Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8235, '\P{Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8235, '\P{^Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8234, '\p{Bidi_Class=:\Alefttorightembedding\z:}', "");;
    Expect(0, 8235, '\p{Bidi_Class=:\Alefttorightembedding\z:}', "");;
    Expect(1, 8234, '\p{Bidi_Class= _left_To_RIGHT_EMBEDDING}', "");
    Expect(0, 8234, '\p{^Bidi_Class= _left_To_RIGHT_EMBEDDING}', "");
    Expect(0, 8234, '\P{Bidi_Class= _left_To_RIGHT_EMBEDDING}', "");
    Expect(1, 8234, '\P{^Bidi_Class= _left_To_RIGHT_EMBEDDING}', "");
    Expect(0, 8235, '\p{Bidi_Class= _left_To_RIGHT_EMBEDDING}', "");
    Expect(1, 8235, '\p{^Bidi_Class= _left_To_RIGHT_EMBEDDING}', "");
    Expect(1, 8235, '\P{Bidi_Class= _left_To_RIGHT_EMBEDDING}', "");
    Expect(0, 8235, '\P{^Bidi_Class= _left_To_RIGHT_EMBEDDING}', "");
    Error('\p{Bc= :=LRE}');
    Error('\P{Bc= :=LRE}');
    Expect(1, 8234, '\p{Bc=:\ALRE\z:}', "");;
    Expect(0, 8235, '\p{Bc=:\ALRE\z:}', "");;
    Expect(1, 8234, '\p{Bc=lre}', "");
    Expect(0, 8234, '\p{^Bc=lre}', "");
    Expect(0, 8234, '\P{Bc=lre}', "");
    Expect(1, 8234, '\P{^Bc=lre}', "");
    Expect(0, 8235, '\p{Bc=lre}', "");
    Expect(1, 8235, '\p{^Bc=lre}', "");
    Expect(1, 8235, '\P{Bc=lre}', "");
    Expect(0, 8235, '\P{^Bc=lre}', "");
    Expect(1, 8234, '\p{Bc=:\Alre\z:}', "");;
    Expect(0, 8235, '\p{Bc=:\Alre\z:}', "");;
    Expect(1, 8234, '\p{Bc=_ LRE}', "");
    Expect(0, 8234, '\p{^Bc=_ LRE}', "");
    Expect(0, 8234, '\P{Bc=_ LRE}', "");
    Expect(1, 8234, '\P{^Bc=_ LRE}', "");
    Expect(0, 8235, '\p{Bc=_ LRE}', "");
    Expect(1, 8235, '\p{^Bc=_ LRE}', "");
    Expect(1, 8235, '\P{Bc=_ LRE}', "");
    Expect(0, 8235, '\P{^Bc=_ LRE}', "");
    Error('\p{Is_Bidi_Class=/a/LEFT_To_RIGHT_embedding}');
    Error('\P{Is_Bidi_Class=/a/LEFT_To_RIGHT_embedding}');
    Expect(1, 8234, '\p{Is_Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8234, '\p{^Is_Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8234, '\P{Is_Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8234, '\P{^Is_Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8235, '\p{Is_Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8235, '\p{^Is_Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8235, '\P{Is_Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8235, '\P{^Is_Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8234, '\p{Is_Bidi_Class=_Left_To_Right_Embedding}', "");
    Expect(0, 8234, '\p{^Is_Bidi_Class=_Left_To_Right_Embedding}', "");
    Expect(0, 8234, '\P{Is_Bidi_Class=_Left_To_Right_Embedding}', "");
    Expect(1, 8234, '\P{^Is_Bidi_Class=_Left_To_Right_Embedding}', "");
    Expect(0, 8235, '\p{Is_Bidi_Class=_Left_To_Right_Embedding}', "");
    Expect(1, 8235, '\p{^Is_Bidi_Class=_Left_To_Right_Embedding}', "");
    Expect(1, 8235, '\P{Is_Bidi_Class=_Left_To_Right_Embedding}', "");
    Expect(0, 8235, '\P{^Is_Bidi_Class=_Left_To_Right_Embedding}', "");
    Error('\p{Is_Bc: _:=LRE}');
    Error('\P{Is_Bc: _:=LRE}');
    Expect(1, 8234, '\p{Is_Bc=lre}', "");
    Expect(0, 8234, '\p{^Is_Bc=lre}', "");
    Expect(0, 8234, '\P{Is_Bc=lre}', "");
    Expect(1, 8234, '\P{^Is_Bc=lre}', "");
    Expect(0, 8235, '\p{Is_Bc=lre}', "");
    Expect(1, 8235, '\p{^Is_Bc=lre}', "");
    Expect(1, 8235, '\P{Is_Bc=lre}', "");
    Expect(0, 8235, '\P{^Is_Bc=lre}', "");
    Expect(1, 8234, '\p{Is_Bc= _lre}', "");
    Expect(0, 8234, '\p{^Is_Bc= _lre}', "");
    Expect(0, 8234, '\P{Is_Bc= _lre}', "");
    Expect(1, 8234, '\P{^Is_Bc= _lre}', "");
    Expect(0, 8235, '\p{Is_Bc= _lre}', "");
    Expect(1, 8235, '\p{^Is_Bc= _lre}', "");
    Expect(1, 8235, '\P{Is_Bc= _lre}', "");
    Expect(0, 8235, '\P{^Is_Bc= _lre}', "");
    Error('\p{Bidi_Class=-:=left_To_right_ISOLATE}');
    Error('\P{Bidi_Class=-:=left_To_right_ISOLATE}');
    Expect(1, 8294, '\p{Bidi_Class=:\ALeft_To_Right_Isolate\z:}', "");;
    Expect(0, 8295, '\p{Bidi_Class=:\ALeft_To_Right_Isolate\z:}', "");;
    Expect(1, 8294, '\p{Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8294, '\p{^Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8294, '\P{Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8294, '\P{^Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8295, '\p{Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8295, '\p{^Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8295, '\P{Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8295, '\P{^Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8294, '\p{Bidi_Class=:\Alefttorightisolate\z:}', "");;
    Expect(0, 8295, '\p{Bidi_Class=:\Alefttorightisolate\z:}', "");;
    Expect(1, 8294, '\p{Bidi_Class=_-Left_To_RIGHT_ISOLATE}', "");
    Expect(0, 8294, '\p{^Bidi_Class=_-Left_To_RIGHT_ISOLATE}', "");
    Expect(0, 8294, '\P{Bidi_Class=_-Left_To_RIGHT_ISOLATE}', "");
    Expect(1, 8294, '\P{^Bidi_Class=_-Left_To_RIGHT_ISOLATE}', "");
    Expect(0, 8295, '\p{Bidi_Class=_-Left_To_RIGHT_ISOLATE}', "");
    Expect(1, 8295, '\p{^Bidi_Class=_-Left_To_RIGHT_ISOLATE}', "");
    Expect(1, 8295, '\P{Bidi_Class=_-Left_To_RIGHT_ISOLATE}', "");
    Expect(0, 8295, '\P{^Bidi_Class=_-Left_To_RIGHT_ISOLATE}', "");
    Error('\p{Bc=:= -LRI}');
    Error('\P{Bc=:= -LRI}');
    Expect(1, 8294, '\p{Bc=:\ALRI\z:}', "");;
    Expect(0, 8295, '\p{Bc=:\ALRI\z:}', "");;
    Expect(1, 8294, '\p{Bc=lri}', "");
    Expect(0, 8294, '\p{^Bc=lri}', "");
    Expect(0, 8294, '\P{Bc=lri}', "");
    Expect(1, 8294, '\P{^Bc=lri}', "");
    Expect(0, 8295, '\p{Bc=lri}', "");
    Expect(1, 8295, '\p{^Bc=lri}', "");
    Expect(1, 8295, '\P{Bc=lri}', "");
    Expect(0, 8295, '\P{^Bc=lri}', "");
    Expect(1, 8294, '\p{Bc=:\Alri\z:}', "");;
    Expect(0, 8295, '\p{Bc=:\Alri\z:}', "");;
    Expect(1, 8294, '\p{Bc= _lri}', "");
    Expect(0, 8294, '\p{^Bc= _lri}', "");
    Expect(0, 8294, '\P{Bc= _lri}', "");
    Expect(1, 8294, '\P{^Bc= _lri}', "");
    Expect(0, 8295, '\p{Bc= _lri}', "");
    Expect(1, 8295, '\p{^Bc= _lri}', "");
    Expect(1, 8295, '\P{Bc= _lri}', "");
    Expect(0, 8295, '\P{^Bc= _lri}', "");
    Error('\p{Is_Bidi_Class=-/a/LEFT_TO_right_ISOLATE}');
    Error('\P{Is_Bidi_Class=-/a/LEFT_TO_right_ISOLATE}');
    Expect(1, 8294, '\p{Is_Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8294, '\p{^Is_Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8294, '\P{Is_Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8294, '\P{^Is_Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8295, '\p{Is_Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8295, '\p{^Is_Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8295, '\P{Is_Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8295, '\P{^Is_Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8294, '\p{Is_Bidi_Class=_LEFT_to_Right_Isolate}', "");
    Expect(0, 8294, '\p{^Is_Bidi_Class=_LEFT_to_Right_Isolate}', "");
    Expect(0, 8294, '\P{Is_Bidi_Class=_LEFT_to_Right_Isolate}', "");
    Expect(1, 8294, '\P{^Is_Bidi_Class=_LEFT_to_Right_Isolate}', "");
    Expect(0, 8295, '\p{Is_Bidi_Class=_LEFT_to_Right_Isolate}', "");
    Expect(1, 8295, '\p{^Is_Bidi_Class=_LEFT_to_Right_Isolate}', "");
    Expect(1, 8295, '\P{Is_Bidi_Class=_LEFT_to_Right_Isolate}', "");
    Expect(0, 8295, '\P{^Is_Bidi_Class=_LEFT_to_Right_Isolate}', "");
    Error('\p{Is_Bc=_:=lri}');
    Error('\P{Is_Bc=_:=lri}');
    Expect(1, 8294, '\p{Is_Bc=lri}', "");
    Expect(0, 8294, '\p{^Is_Bc=lri}', "");
    Expect(0, 8294, '\P{Is_Bc=lri}', "");
    Expect(1, 8294, '\P{^Is_Bc=lri}', "");
    Expect(0, 8295, '\p{Is_Bc=lri}', "");
    Expect(1, 8295, '\p{^Is_Bc=lri}', "");
    Expect(1, 8295, '\P{Is_Bc=lri}', "");
    Expect(0, 8295, '\P{^Is_Bc=lri}', "");
    Expect(1, 8294, '\p{Is_Bc= 	LRI}', "");
    Expect(0, 8294, '\p{^Is_Bc= 	LRI}', "");
    Expect(0, 8294, '\P{Is_Bc= 	LRI}', "");
    Expect(1, 8294, '\P{^Is_Bc= 	LRI}', "");
    Expect(0, 8295, '\p{Is_Bc= 	LRI}', "");
    Expect(1, 8295, '\p{^Is_Bc= 	LRI}', "");
    Expect(1, 8295, '\P{Is_Bc= 	LRI}', "");
    Expect(0, 8295, '\P{^Is_Bc= 	LRI}', "");
    Error('\p{Bidi_Class=/a/__Left_TO_RIGHT_Override}');
    Error('\P{Bidi_Class=/a/__Left_TO_RIGHT_Override}');
    Expect(1, 8237, '\p{Bidi_Class=:\ALeft_To_Right_Override\z:}', "");;
    Expect(0, 8238, '\p{Bidi_Class=:\ALeft_To_Right_Override\z:}', "");;
    Expect(1, 8237, '\p{Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8237, '\p{^Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8237, '\P{Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8237, '\P{^Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8238, '\p{Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8238, '\p{^Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8238, '\P{Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8238, '\P{^Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8237, '\p{Bidi_Class=:\Alefttorightoverride\z:}', "");;
    Expect(0, 8238, '\p{Bidi_Class=:\Alefttorightoverride\z:}', "");;
    Expect(1, 8237, '\p{Bidi_Class=	Left_TO_Right_override}', "");
    Expect(0, 8237, '\p{^Bidi_Class=	Left_TO_Right_override}', "");
    Expect(0, 8237, '\P{Bidi_Class=	Left_TO_Right_override}', "");
    Expect(1, 8237, '\P{^Bidi_Class=	Left_TO_Right_override}', "");
    Expect(0, 8238, '\p{Bidi_Class=	Left_TO_Right_override}', "");
    Expect(1, 8238, '\p{^Bidi_Class=	Left_TO_Right_override}', "");
    Expect(1, 8238, '\P{Bidi_Class=	Left_TO_Right_override}', "");
    Expect(0, 8238, '\P{^Bidi_Class=	Left_TO_Right_override}', "");
    Error('\p{Bc=	/a/LRO}');
    Error('\P{Bc=	/a/LRO}');
    Expect(1, 8237, '\p{Bc=:\ALRO\z:}', "");;
    Expect(0, 8238, '\p{Bc=:\ALRO\z:}', "");;
    Expect(1, 8237, '\p{Bc=lro}', "");
    Expect(0, 8237, '\p{^Bc=lro}', "");
    Expect(0, 8237, '\P{Bc=lro}', "");
    Expect(1, 8237, '\P{^Bc=lro}', "");
    Expect(0, 8238, '\p{Bc=lro}', "");
    Expect(1, 8238, '\p{^Bc=lro}', "");
    Expect(1, 8238, '\P{Bc=lro}', "");
    Expect(0, 8238, '\P{^Bc=lro}', "");
    Expect(1, 8237, '\p{Bc=:\Alro\z:}', "");;
    Expect(0, 8238, '\p{Bc=:\Alro\z:}', "");;
    Expect(1, 8237, '\p{Bc= -lro}', "");
    Expect(0, 8237, '\p{^Bc= -lro}', "");
    Expect(0, 8237, '\P{Bc= -lro}', "");
    Expect(1, 8237, '\P{^Bc= -lro}', "");
    Expect(0, 8238, '\p{Bc= -lro}', "");
    Expect(1, 8238, '\p{^Bc= -lro}', "");
    Expect(1, 8238, '\P{Bc= -lro}', "");
    Expect(0, 8238, '\P{^Bc= -lro}', "");
    Error('\p{Is_Bidi_Class=_/a/LEFT_to_Right_Override}');
    Error('\P{Is_Bidi_Class=_/a/LEFT_to_Right_Override}');
    Expect(1, 8237, '\p{Is_Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8237, '\p{^Is_Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8237, '\P{Is_Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8237, '\P{^Is_Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8238, '\p{Is_Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8238, '\p{^Is_Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8238, '\P{Is_Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8238, '\P{^Is_Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8237, '\p{Is_Bidi_Class=LEFT_to_right_OVERRIDE}', "");
    Expect(0, 8237, '\p{^Is_Bidi_Class=LEFT_to_right_OVERRIDE}', "");
    Expect(0, 8237, '\P{Is_Bidi_Class=LEFT_to_right_OVERRIDE}', "");
    Expect(1, 8237, '\P{^Is_Bidi_Class=LEFT_to_right_OVERRIDE}', "");
    Expect(0, 8238, '\p{Is_Bidi_Class=LEFT_to_right_OVERRIDE}', "");
    Expect(1, 8238, '\p{^Is_Bidi_Class=LEFT_to_right_OVERRIDE}', "");
    Expect(1, 8238, '\P{Is_Bidi_Class=LEFT_to_right_OVERRIDE}', "");
    Expect(0, 8238, '\P{^Is_Bidi_Class=LEFT_to_right_OVERRIDE}', "");
    Error('\p{Is_Bc:	/a/lro}');
    Error('\P{Is_Bc:	/a/lro}');
    Expect(1, 8237, '\p{Is_Bc:   lro}', "");
    Expect(0, 8237, '\p{^Is_Bc:   lro}', "");
    Expect(0, 8237, '\P{Is_Bc:   lro}', "");
    Expect(1, 8237, '\P{^Is_Bc:   lro}', "");
    Expect(0, 8238, '\p{Is_Bc:   lro}', "");
    Expect(1, 8238, '\p{^Is_Bc:   lro}', "");
    Expect(1, 8238, '\P{Is_Bc:   lro}', "");
    Expect(0, 8238, '\P{^Is_Bc:   lro}', "");
    Error('\p{Bidi_Class=-NONSPACING_Mark/a/}');
    Error('\P{Bidi_Class=-NONSPACING_Mark/a/}');
    Expect(1, 917999, '\p{Bidi_Class=:\ANonspacing_Mark\z:}', "");;
    Expect(0, 918000, '\p{Bidi_Class=:\ANonspacing_Mark\z:}', "");;
    Expect(1, 917999, '\p{Bidi_Class=nonspacingmark}', "");
    Expect(0, 917999, '\p{^Bidi_Class=nonspacingmark}', "");
    Expect(0, 917999, '\P{Bidi_Class=nonspacingmark}', "");
    Expect(1, 917999, '\P{^Bidi_Class=nonspacingmark}', "");
    Expect(0, 918000, '\p{Bidi_Class=nonspacingmark}', "");
    Expect(1, 918000, '\p{^Bidi_Class=nonspacingmark}', "");
    Expect(1, 918000, '\P{Bidi_Class=nonspacingmark}', "");
    Expect(0, 918000, '\P{^Bidi_Class=nonspacingmark}', "");
    Expect(1, 917999, '\p{Bidi_Class=:\Anonspacingmark\z:}', "");;
    Expect(0, 918000, '\p{Bidi_Class=:\Anonspacingmark\z:}', "");;
    Expect(1, 917999, '\p{Bidi_Class=		nonspacing_mark}', "");
    Expect(0, 917999, '\p{^Bidi_Class=		nonspacing_mark}', "");
    Expect(0, 917999, '\P{Bidi_Class=		nonspacing_mark}', "");
    Expect(1, 917999, '\P{^Bidi_Class=		nonspacing_mark}', "");
    Expect(0, 918000, '\p{Bidi_Class=		nonspacing_mark}', "");
    Expect(1, 918000, '\p{^Bidi_Class=		nonspacing_mark}', "");
    Expect(1, 918000, '\P{Bidi_Class=		nonspacing_mark}', "");
    Expect(0, 918000, '\P{^Bidi_Class=		nonspacing_mark}', "");
    Error('\p{Bc=- nsm:=}');
    Error('\P{Bc=- nsm:=}');
    Expect(1, 917999, '\p{Bc=:\ANSM\z:}', "");;
    Expect(0, 918000, '\p{Bc=:\ANSM\z:}', "");;
    Expect(1, 917999, '\p{Bc=nsm}', "");
    Expect(0, 917999, '\p{^Bc=nsm}', "");
    Expect(0, 917999, '\P{Bc=nsm}', "");
    Expect(1, 917999, '\P{^Bc=nsm}', "");
    Expect(0, 918000, '\p{Bc=nsm}', "");
    Expect(1, 918000, '\p{^Bc=nsm}', "");
    Expect(1, 918000, '\P{Bc=nsm}', "");
    Expect(0, 918000, '\P{^Bc=nsm}', "");
    Expect(1, 917999, '\p{Bc=:\Ansm\z:}', "");;
    Expect(0, 918000, '\p{Bc=:\Ansm\z:}', "");;
    Expect(1, 917999, '\p{Bc=_ NSM}', "");
    Expect(0, 917999, '\p{^Bc=_ NSM}', "");
    Expect(0, 917999, '\P{Bc=_ NSM}', "");
    Expect(1, 917999, '\P{^Bc=_ NSM}', "");
    Expect(0, 918000, '\p{Bc=_ NSM}', "");
    Expect(1, 918000, '\p{^Bc=_ NSM}', "");
    Expect(1, 918000, '\P{Bc=_ NSM}', "");
    Expect(0, 918000, '\P{^Bc=_ NSM}', "");
    Error('\p{Is_Bidi_Class=/a/-nonspacing_Mark}');
    Error('\P{Is_Bidi_Class=/a/-nonspacing_Mark}');
    Expect(1, 917999, '\p{Is_Bidi_Class=nonspacingmark}', "");
    Expect(0, 917999, '\p{^Is_Bidi_Class=nonspacingmark}', "");
    Expect(0, 917999, '\P{Is_Bidi_Class=nonspacingmark}', "");
    Expect(1, 917999, '\P{^Is_Bidi_Class=nonspacingmark}', "");
    Expect(0, 918000, '\p{Is_Bidi_Class=nonspacingmark}', "");
    Expect(1, 918000, '\p{^Is_Bidi_Class=nonspacingmark}', "");
    Expect(1, 918000, '\P{Is_Bidi_Class=nonspacingmark}', "");
    Expect(0, 918000, '\P{^Is_Bidi_Class=nonspacingmark}', "");
    Expect(1, 917999, '\p{Is_Bidi_Class=-Nonspacing_mark}', "");
    Expect(0, 917999, '\p{^Is_Bidi_Class=-Nonspacing_mark}', "");
    Expect(0, 917999, '\P{Is_Bidi_Class=-Nonspacing_mark}', "");
    Expect(1, 917999, '\P{^Is_Bidi_Class=-Nonspacing_mark}', "");
    Expect(0, 918000, '\p{Is_Bidi_Class=-Nonspacing_mark}', "");
    Expect(1, 918000, '\p{^Is_Bidi_Class=-Nonspacing_mark}', "");
    Expect(1, 918000, '\P{Is_Bidi_Class=-Nonspacing_mark}', "");
    Expect(0, 918000, '\P{^Is_Bidi_Class=-Nonspacing_mark}', "");
    Error('\p{Is_Bc= nsm:=}');
    Error('\P{Is_Bc= nsm:=}');
    Expect(1, 917999, '\p{Is_Bc=nsm}', "");
    Expect(0, 917999, '\p{^Is_Bc=nsm}', "");
    Expect(0, 917999, '\P{Is_Bc=nsm}', "");
    Expect(1, 917999, '\P{^Is_Bc=nsm}', "");
    Expect(0, 918000, '\p{Is_Bc=nsm}', "");
    Expect(1, 918000, '\p{^Is_Bc=nsm}', "");
    Expect(1, 918000, '\P{Is_Bc=nsm}', "");
    Expect(0, 918000, '\P{^Is_Bc=nsm}', "");
    Expect(1, 917999, '\p{Is_Bc= NSM}', "");
    Expect(0, 917999, '\p{^Is_Bc= NSM}', "");
    Expect(0, 917999, '\P{Is_Bc= NSM}', "");
    Expect(1, 917999, '\P{^Is_Bc= NSM}', "");
    Expect(0, 918000, '\p{Is_Bc= NSM}', "");
    Expect(1, 918000, '\p{^Is_Bc= NSM}', "");
    Expect(1, 918000, '\P{Is_Bc= NSM}', "");
    Expect(0, 918000, '\P{^Is_Bc= NSM}', "");
    Error('\p{Bidi_Class=:=Other_Neutral}');
    Error('\P{Bidi_Class=:=Other_Neutral}');
    Expect(1, 129994, '\p{Bidi_Class=:\AOther_Neutral\z:}', "");;
    Expect(0, 129995, '\p{Bidi_Class=:\AOther_Neutral\z:}', "");;
    Expect(1, 129994, '\p{Bidi_Class=otherneutral}', "");
    Expect(0, 129994, '\p{^Bidi_Class=otherneutral}', "");
    Expect(0, 129994, '\P{Bidi_Class=otherneutral}', "");
    Expect(1, 129994, '\P{^Bidi_Class=otherneutral}', "");
    Expect(0, 129995, '\p{Bidi_Class=otherneutral}', "");
    Expect(1, 129995, '\p{^Bidi_Class=otherneutral}', "");
    Expect(1, 129995, '\P{Bidi_Class=otherneutral}', "");
    Expect(0, 129995, '\P{^Bidi_Class=otherneutral}', "");
    Expect(1, 129994, '\p{Bidi_Class=:\Aotherneutral\z:}', "");;
    Expect(0, 129995, '\p{Bidi_Class=:\Aotherneutral\z:}', "");;
    Expect(1, 129994, '\p{Bidi_Class=-Other_Neutral}', "");
    Expect(0, 129994, '\p{^Bidi_Class=-Other_Neutral}', "");
    Expect(0, 129994, '\P{Bidi_Class=-Other_Neutral}', "");
    Expect(1, 129994, '\P{^Bidi_Class=-Other_Neutral}', "");
    Expect(0, 129995, '\p{Bidi_Class=-Other_Neutral}', "");
    Expect(1, 129995, '\p{^Bidi_Class=-Other_Neutral}', "");
    Expect(1, 129995, '\P{Bidi_Class=-Other_Neutral}', "");
    Expect(0, 129995, '\P{^Bidi_Class=-Other_Neutral}', "");
    Error('\p{Bc=-ON/a/}');
    Error('\P{Bc=-ON/a/}');
    Expect(1, 129994, '\p{Bc=:\AON\z:}', "");;
    Expect(0, 129995, '\p{Bc=:\AON\z:}', "");;
    Expect(1, 129994, '\p{Bc=on}', "");
    Expect(0, 129994, '\p{^Bc=on}', "");
    Expect(0, 129994, '\P{Bc=on}', "");
    Expect(1, 129994, '\P{^Bc=on}', "");
    Expect(0, 129995, '\p{Bc=on}', "");
    Expect(1, 129995, '\p{^Bc=on}', "");
    Expect(1, 129995, '\P{Bc=on}', "");
    Expect(0, 129995, '\P{^Bc=on}', "");
    Expect(1, 129994, '\p{Bc=:\Aon\z:}', "");;
    Expect(0, 129995, '\p{Bc=:\Aon\z:}', "");;
    Expect(1, 129994, '\p{Bc=_-on}', "");
    Expect(0, 129994, '\p{^Bc=_-on}', "");
    Expect(0, 129994, '\P{Bc=_-on}', "");
    Expect(1, 129994, '\P{^Bc=_-on}', "");
    Expect(0, 129995, '\p{Bc=_-on}', "");
    Expect(1, 129995, '\p{^Bc=_-on}', "");
    Expect(1, 129995, '\P{Bc=_-on}', "");
    Expect(0, 129995, '\P{^Bc=_-on}', "");
    Error('\p{Is_Bidi_Class=:=-	OTHER_Neutral}');
    Error('\P{Is_Bidi_Class=:=-	OTHER_Neutral}');
    Expect(1, 129994, '\p{Is_Bidi_Class=otherneutral}', "");
    Expect(0, 129994, '\p{^Is_Bidi_Class=otherneutral}', "");
    Expect(0, 129994, '\P{Is_Bidi_Class=otherneutral}', "");
    Expect(1, 129994, '\P{^Is_Bidi_Class=otherneutral}', "");
    Expect(0, 129995, '\p{Is_Bidi_Class=otherneutral}', "");
    Expect(1, 129995, '\p{^Is_Bidi_Class=otherneutral}', "");
    Expect(1, 129995, '\P{Is_Bidi_Class=otherneutral}', "");
    Expect(0, 129995, '\P{^Is_Bidi_Class=otherneutral}', "");
    Expect(1, 129994, '\p{Is_Bidi_Class=--Other_Neutral}', "");
    Expect(0, 129994, '\p{^Is_Bidi_Class=--Other_Neutral}', "");
    Expect(0, 129994, '\P{Is_Bidi_Class=--Other_Neutral}', "");
    Expect(1, 129994, '\P{^Is_Bidi_Class=--Other_Neutral}', "");
    Expect(0, 129995, '\p{Is_Bidi_Class=--Other_Neutral}', "");
    Expect(1, 129995, '\p{^Is_Bidi_Class=--Other_Neutral}', "");
    Expect(1, 129995, '\P{Is_Bidi_Class=--Other_Neutral}', "");
    Expect(0, 129995, '\P{^Is_Bidi_Class=--Other_Neutral}', "");
    Error('\p{Is_Bc=:=- ON}');
    Error('\P{Is_Bc=:=- ON}');
    Expect(1, 129994, '\p{Is_Bc=on}', "");
    Expect(0, 129994, '\p{^Is_Bc=on}', "");
    Expect(0, 129994, '\P{Is_Bc=on}', "");
    Expect(1, 129994, '\P{^Is_Bc=on}', "");
    Expect(0, 129995, '\p{Is_Bc=on}', "");
    Expect(1, 129995, '\p{^Is_Bc=on}', "");
    Expect(1, 129995, '\P{Is_Bc=on}', "");
    Expect(0, 129995, '\P{^Is_Bc=on}', "");
    Expect(1, 129994, '\p{Is_Bc:- ON}', "");
    Expect(0, 129994, '\p{^Is_Bc:- ON}', "");
    Expect(0, 129994, '\P{Is_Bc:- ON}', "");
    Expect(1, 129994, '\P{^Is_Bc:- ON}', "");
    Expect(0, 129995, '\p{Is_Bc:- ON}', "");
    Expect(1, 129995, '\p{^Is_Bc:- ON}', "");
    Expect(1, 129995, '\P{Is_Bc:- ON}', "");
    Expect(0, 129995, '\P{^Is_Bc:- ON}', "");
    Error('\p{Bidi_Class=/a/--pop_Directional_Format}');
    Error('\P{Bidi_Class=/a/--pop_Directional_Format}');
    Expect(1, 8236, '\p{Bidi_Class=:\APop_Directional_Format\z:}', "");;
    Expect(0, 8237, '\p{Bidi_Class=:\APop_Directional_Format\z:}', "");;
    Expect(1, 8236, '\p{Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8236, '\p{^Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8236, '\P{Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8236, '\P{^Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8237, '\p{Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8237, '\p{^Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8237, '\P{Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8237, '\P{^Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8236, '\p{Bidi_Class=:\Apopdirectionalformat\z:}', "");;
    Expect(0, 8237, '\p{Bidi_Class=:\Apopdirectionalformat\z:}', "");;
    Expect(1, 8236, '\p{Bidi_Class= pop_Directional_format}', "");
    Expect(0, 8236, '\p{^Bidi_Class= pop_Directional_format}', "");
    Expect(0, 8236, '\P{Bidi_Class= pop_Directional_format}', "");
    Expect(1, 8236, '\P{^Bidi_Class= pop_Directional_format}', "");
    Expect(0, 8237, '\p{Bidi_Class= pop_Directional_format}', "");
    Expect(1, 8237, '\p{^Bidi_Class= pop_Directional_format}', "");
    Expect(1, 8237, '\P{Bidi_Class= pop_Directional_format}', "");
    Expect(0, 8237, '\P{^Bidi_Class= pop_Directional_format}', "");
    Error('\p{Bc=	PDF/a/}');
    Error('\P{Bc=	PDF/a/}');
    Expect(1, 8236, '\p{Bc=:\APDF\z:}', "");;
    Expect(0, 8237, '\p{Bc=:\APDF\z:}', "");;
    Expect(1, 8236, '\p{Bc=pdf}', "");
    Expect(0, 8236, '\p{^Bc=pdf}', "");
    Expect(0, 8236, '\P{Bc=pdf}', "");
    Expect(1, 8236, '\P{^Bc=pdf}', "");
    Expect(0, 8237, '\p{Bc=pdf}', "");
    Expect(1, 8237, '\p{^Bc=pdf}', "");
    Expect(1, 8237, '\P{Bc=pdf}', "");
    Expect(0, 8237, '\P{^Bc=pdf}', "");
    Expect(1, 8236, '\p{Bc=:\Apdf\z:}', "");;
    Expect(0, 8237, '\p{Bc=:\Apdf\z:}', "");;
    Expect(1, 8236, '\p{Bc=		pdf}', "");
    Expect(0, 8236, '\p{^Bc=		pdf}', "");
    Expect(0, 8236, '\P{Bc=		pdf}', "");
    Expect(1, 8236, '\P{^Bc=		pdf}', "");
    Expect(0, 8237, '\p{Bc=		pdf}', "");
    Expect(1, 8237, '\p{^Bc=		pdf}', "");
    Expect(1, 8237, '\P{Bc=		pdf}', "");
    Expect(0, 8237, '\P{^Bc=		pdf}', "");
    Error('\p{Is_Bidi_Class:   :=  POP_Directional_FORMAT}');
    Error('\P{Is_Bidi_Class:   :=  POP_Directional_FORMAT}');
    Expect(1, 8236, '\p{Is_Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8236, '\p{^Is_Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8236, '\P{Is_Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8236, '\P{^Is_Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8237, '\p{Is_Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8237, '\p{^Is_Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8237, '\P{Is_Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8237, '\P{^Is_Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8236, '\p{Is_Bidi_Class= _POP_directional_FORMAT}', "");
    Expect(0, 8236, '\p{^Is_Bidi_Class= _POP_directional_FORMAT}', "");
    Expect(0, 8236, '\P{Is_Bidi_Class= _POP_directional_FORMAT}', "");
    Expect(1, 8236, '\P{^Is_Bidi_Class= _POP_directional_FORMAT}', "");
    Expect(0, 8237, '\p{Is_Bidi_Class= _POP_directional_FORMAT}', "");
    Expect(1, 8237, '\p{^Is_Bidi_Class= _POP_directional_FORMAT}', "");
    Expect(1, 8237, '\P{Is_Bidi_Class= _POP_directional_FORMAT}', "");
    Expect(0, 8237, '\P{^Is_Bidi_Class= _POP_directional_FORMAT}', "");
    Error('\p{Is_Bc=	:=PDF}');
    Error('\P{Is_Bc=	:=PDF}');
    Expect(1, 8236, '\p{Is_Bc=pdf}', "");
    Expect(0, 8236, '\p{^Is_Bc=pdf}', "");
    Expect(0, 8236, '\P{Is_Bc=pdf}', "");
    Expect(1, 8236, '\P{^Is_Bc=pdf}', "");
    Expect(0, 8237, '\p{Is_Bc=pdf}', "");
    Expect(1, 8237, '\p{^Is_Bc=pdf}', "");
    Expect(1, 8237, '\P{Is_Bc=pdf}', "");
    Expect(0, 8237, '\P{^Is_Bc=pdf}', "");
    Expect(1, 8236, '\p{Is_Bc=	-pdf}', "");
    Expect(0, 8236, '\p{^Is_Bc=	-pdf}', "");
    Expect(0, 8236, '\P{Is_Bc=	-pdf}', "");
    Expect(1, 8236, '\P{^Is_Bc=	-pdf}', "");
    Expect(0, 8237, '\p{Is_Bc=	-pdf}', "");
    Expect(1, 8237, '\p{^Is_Bc=	-pdf}', "");
    Expect(1, 8237, '\P{Is_Bc=	-pdf}', "");
    Expect(0, 8237, '\P{^Is_Bc=	-pdf}', "");
    Error('\p{Bidi_Class=:=POP_Directional_Isolate}');
    Error('\P{Bidi_Class=:=POP_Directional_Isolate}');
    Expect(1, 8297, '\p{Bidi_Class=:\APop_Directional_Isolate\z:}', "");;
    Expect(0, 8298, '\p{Bidi_Class=:\APop_Directional_Isolate\z:}', "");;
    Expect(1, 8297, '\p{Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8297, '\p{^Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8297, '\P{Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8297, '\P{^Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8298, '\p{Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8298, '\p{^Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8298, '\P{Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8298, '\P{^Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8297, '\p{Bidi_Class=:\Apopdirectionalisolate\z:}', "");;
    Expect(0, 8298, '\p{Bidi_Class=:\Apopdirectionalisolate\z:}', "");;
    Expect(1, 8297, '\p{Bidi_Class=_-pop_directional_Isolate}', "");
    Expect(0, 8297, '\p{^Bidi_Class=_-pop_directional_Isolate}', "");
    Expect(0, 8297, '\P{Bidi_Class=_-pop_directional_Isolate}', "");
    Expect(1, 8297, '\P{^Bidi_Class=_-pop_directional_Isolate}', "");
    Expect(0, 8298, '\p{Bidi_Class=_-pop_directional_Isolate}', "");
    Expect(1, 8298, '\p{^Bidi_Class=_-pop_directional_Isolate}', "");
    Expect(1, 8298, '\P{Bidi_Class=_-pop_directional_Isolate}', "");
    Expect(0, 8298, '\P{^Bidi_Class=_-pop_directional_Isolate}', "");
    Error('\p{Bc=:= pdi}');
    Error('\P{Bc=:= pdi}');
    Expect(1, 8297, '\p{Bc=:\APDI\z:}', "");;
    Expect(0, 8298, '\p{Bc=:\APDI\z:}', "");;
    Expect(1, 8297, '\p{Bc=pdi}', "");
    Expect(0, 8297, '\p{^Bc=pdi}', "");
    Expect(0, 8297, '\P{Bc=pdi}', "");
    Expect(1, 8297, '\P{^Bc=pdi}', "");
    Expect(0, 8298, '\p{Bc=pdi}', "");
    Expect(1, 8298, '\p{^Bc=pdi}', "");
    Expect(1, 8298, '\P{Bc=pdi}', "");
    Expect(0, 8298, '\P{^Bc=pdi}', "");
    Expect(1, 8297, '\p{Bc=:\Apdi\z:}', "");;
    Expect(0, 8298, '\p{Bc=:\Apdi\z:}', "");;
    Expect(1, 8297, '\p{Bc:	 PDI}', "");
    Expect(0, 8297, '\p{^Bc:	 PDI}', "");
    Expect(0, 8297, '\P{Bc:	 PDI}', "");
    Expect(1, 8297, '\P{^Bc:	 PDI}', "");
    Expect(0, 8298, '\p{Bc:	 PDI}', "");
    Expect(1, 8298, '\p{^Bc:	 PDI}', "");
    Expect(1, 8298, '\P{Bc:	 PDI}', "");
    Expect(0, 8298, '\P{^Bc:	 PDI}', "");
    Error('\p{Is_Bidi_Class= _pop_Directional_Isolate/a/}');
    Error('\P{Is_Bidi_Class= _pop_Directional_Isolate/a/}');
    Expect(1, 8297, '\p{Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8297, '\p{^Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8297, '\P{Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8297, '\P{^Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8298, '\p{Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8298, '\p{^Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8298, '\P{Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8298, '\P{^Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8297, '\p{Is_Bidi_Class=-POP_DIRECTIONAL_Isolate}', "");
    Expect(0, 8297, '\p{^Is_Bidi_Class=-POP_DIRECTIONAL_Isolate}', "");
    Expect(0, 8297, '\P{Is_Bidi_Class=-POP_DIRECTIONAL_Isolate}', "");
    Expect(1, 8297, '\P{^Is_Bidi_Class=-POP_DIRECTIONAL_Isolate}', "");
    Expect(0, 8298, '\p{Is_Bidi_Class=-POP_DIRECTIONAL_Isolate}', "");
    Expect(1, 8298, '\p{^Is_Bidi_Class=-POP_DIRECTIONAL_Isolate}', "");
    Expect(1, 8298, '\P{Is_Bidi_Class=-POP_DIRECTIONAL_Isolate}', "");
    Expect(0, 8298, '\P{^Is_Bidi_Class=-POP_DIRECTIONAL_Isolate}', "");
    Error('\p{Is_Bc=/a/ PDI}');
    Error('\P{Is_Bc=/a/ PDI}');
    Expect(1, 8297, '\p{Is_Bc=pdi}', "");
    Expect(0, 8297, '\p{^Is_Bc=pdi}', "");
    Expect(0, 8297, '\P{Is_Bc=pdi}', "");
    Expect(1, 8297, '\P{^Is_Bc=pdi}', "");
    Expect(0, 8298, '\p{Is_Bc=pdi}', "");
    Expect(1, 8298, '\p{^Is_Bc=pdi}', "");
    Expect(1, 8298, '\P{Is_Bc=pdi}', "");
    Expect(0, 8298, '\P{^Is_Bc=pdi}', "");
    Expect(1, 8297, '\p{Is_Bc= 	PDI}', "");
    Expect(0, 8297, '\p{^Is_Bc= 	PDI}', "");
    Expect(0, 8297, '\P{Is_Bc= 	PDI}', "");
    Expect(1, 8297, '\P{^Is_Bc= 	PDI}', "");
    Expect(0, 8298, '\p{Is_Bc= 	PDI}', "");
    Expect(1, 8298, '\p{^Is_Bc= 	PDI}', "");
    Expect(1, 8298, '\P{Is_Bc= 	PDI}', "");
    Expect(0, 8298, '\P{^Is_Bc= 	PDI}', "");
    Error('\p{Bidi_Class=  Right_TO_left:=}');
    Error('\P{Bidi_Class=  Right_TO_left:=}');
    Expect(1, 126975, '\p{Bidi_Class=:\ARight_To_Left\z:}', "");;
    Expect(0, 126976, '\p{Bidi_Class=:\ARight_To_Left\z:}', "");;
    Expect(1, 126975, '\p{Bidi_Class=righttoleft}', "");
    Expect(0, 126975, '\p{^Bidi_Class=righttoleft}', "");
    Expect(0, 126975, '\P{Bidi_Class=righttoleft}', "");
    Expect(1, 126975, '\P{^Bidi_Class=righttoleft}', "");
    Expect(0, 126976, '\p{Bidi_Class=righttoleft}', "");
    Expect(1, 126976, '\p{^Bidi_Class=righttoleft}', "");
    Expect(1, 126976, '\P{Bidi_Class=righttoleft}', "");
    Expect(0, 126976, '\P{^Bidi_Class=righttoleft}', "");
    Expect(1, 126975, '\p{Bidi_Class=:\Arighttoleft\z:}', "");;
    Expect(0, 126976, '\p{Bidi_Class=:\Arighttoleft\z:}', "");;
    Expect(1, 126975, '\p{Bidi_Class:     Right_To_left}', "");
    Expect(0, 126975, '\p{^Bidi_Class:     Right_To_left}', "");
    Expect(0, 126975, '\P{Bidi_Class:     Right_To_left}', "");
    Expect(1, 126975, '\P{^Bidi_Class:     Right_To_left}', "");
    Expect(0, 126976, '\p{Bidi_Class:     Right_To_left}', "");
    Expect(1, 126976, '\p{^Bidi_Class:     Right_To_left}', "");
    Expect(1, 126976, '\P{Bidi_Class:     Right_To_left}', "");
    Expect(0, 126976, '\P{^Bidi_Class:     Right_To_left}', "");
    Error('\p{Bc=--r/a/}');
    Error('\P{Bc=--r/a/}');
    Expect(1, 126975, '\p{Bc=:\AR\z:}', "");;
    Expect(0, 126976, '\p{Bc=:\AR\z:}', "");;
    Expect(1, 126975, '\p{Bc=r}', "");
    Expect(0, 126975, '\p{^Bc=r}', "");
    Expect(0, 126975, '\P{Bc=r}', "");
    Expect(1, 126975, '\P{^Bc=r}', "");
    Expect(0, 126976, '\p{Bc=r}', "");
    Expect(1, 126976, '\p{^Bc=r}', "");
    Expect(1, 126976, '\P{Bc=r}', "");
    Expect(0, 126976, '\P{^Bc=r}', "");
    Expect(1, 126975, '\p{Bc=:\Ar\z:}', "");;
    Expect(0, 126976, '\p{Bc=:\Ar\z:}', "");;
    Expect(1, 126975, '\p{Bc=-_R}', "");
    Expect(0, 126975, '\p{^Bc=-_R}', "");
    Expect(0, 126975, '\P{Bc=-_R}', "");
    Expect(1, 126975, '\P{^Bc=-_R}', "");
    Expect(0, 126976, '\p{Bc=-_R}', "");
    Expect(1, 126976, '\p{^Bc=-_R}', "");
    Expect(1, 126976, '\P{Bc=-_R}', "");
    Expect(0, 126976, '\P{^Bc=-_R}', "");
    Error('\p{Is_Bidi_Class:   right_To_left:=}');
    Error('\P{Is_Bidi_Class:   right_To_left:=}');
    Expect(1, 126975, '\p{Is_Bidi_Class=righttoleft}', "");
    Expect(0, 126975, '\p{^Is_Bidi_Class=righttoleft}', "");
    Expect(0, 126975, '\P{Is_Bidi_Class=righttoleft}', "");
    Expect(1, 126975, '\P{^Is_Bidi_Class=righttoleft}', "");
    Expect(0, 126976, '\p{Is_Bidi_Class=righttoleft}', "");
    Expect(1, 126976, '\p{^Is_Bidi_Class=righttoleft}', "");
    Expect(1, 126976, '\P{Is_Bidi_Class=righttoleft}', "");
    Expect(0, 126976, '\P{^Is_Bidi_Class=righttoleft}', "");
    Expect(1, 126975, '\p{Is_Bidi_Class:   -_Right_To_Left}', "");
    Expect(0, 126975, '\p{^Is_Bidi_Class:   -_Right_To_Left}', "");
    Expect(0, 126975, '\P{Is_Bidi_Class:   -_Right_To_Left}', "");
    Expect(1, 126975, '\P{^Is_Bidi_Class:   -_Right_To_Left}', "");
    Expect(0, 126976, '\p{Is_Bidi_Class:   -_Right_To_Left}', "");
    Expect(1, 126976, '\p{^Is_Bidi_Class:   -_Right_To_Left}', "");
    Expect(1, 126976, '\P{Is_Bidi_Class:   -_Right_To_Left}', "");
    Expect(0, 126976, '\P{^Is_Bidi_Class:   -_Right_To_Left}', "");
    Error('\p{Is_Bc=_/a/R}');
    Error('\P{Is_Bc=_/a/R}');
    Expect(1, 126975, '\p{Is_Bc=r}', "");
    Expect(0, 126975, '\p{^Is_Bc=r}', "");
    Expect(0, 126975, '\P{Is_Bc=r}', "");
    Expect(1, 126975, '\P{^Is_Bc=r}', "");
    Expect(0, 126976, '\p{Is_Bc=r}', "");
    Expect(1, 126976, '\p{^Is_Bc=r}', "");
    Expect(1, 126976, '\P{Is_Bc=r}', "");
    Expect(0, 126976, '\P{^Is_Bc=r}', "");
    Expect(1, 126975, '\p{Is_Bc= -R}', "");
    Expect(0, 126975, '\p{^Is_Bc= -R}', "");
    Expect(0, 126975, '\P{Is_Bc= -R}', "");
    Expect(1, 126975, '\P{^Is_Bc= -R}', "");
    Expect(0, 126976, '\p{Is_Bc= -R}', "");
    Expect(1, 126976, '\p{^Is_Bc= -R}', "");
    Expect(1, 126976, '\P{Is_Bc= -R}', "");
    Expect(0, 126976, '\P{^Is_Bc= -R}', "");
    Error('\p{Bidi_Class=__Right_To_Left_Embedding:=}');
    Error('\P{Bidi_Class=__Right_To_Left_Embedding:=}');
    Expect(1, 8235, '\p{Bidi_Class=:\ARight_To_Left_Embedding\z:}', "");;
    Expect(0, 8236, '\p{Bidi_Class=:\ARight_To_Left_Embedding\z:}', "");;
    Expect(1, 8235, '\p{Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8235, '\p{^Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8235, '\P{Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8235, '\P{^Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8236, '\p{Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8236, '\p{^Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8236, '\P{Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8236, '\P{^Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8235, '\p{Bidi_Class=:\Arighttoleftembedding\z:}', "");;
    Expect(0, 8236, '\p{Bidi_Class=:\Arighttoleftembedding\z:}', "");;
    Expect(1, 8235, '\p{Bidi_Class=	_Right_TO_Left_Embedding}', "");
    Expect(0, 8235, '\p{^Bidi_Class=	_Right_TO_Left_Embedding}', "");
    Expect(0, 8235, '\P{Bidi_Class=	_Right_TO_Left_Embedding}', "");
    Expect(1, 8235, '\P{^Bidi_Class=	_Right_TO_Left_Embedding}', "");
    Expect(0, 8236, '\p{Bidi_Class=	_Right_TO_Left_Embedding}', "");
    Expect(1, 8236, '\p{^Bidi_Class=	_Right_TO_Left_Embedding}', "");
    Expect(1, 8236, '\P{Bidi_Class=	_Right_TO_Left_Embedding}', "");
    Expect(0, 8236, '\P{^Bidi_Class=	_Right_TO_Left_Embedding}', "");
    Error('\p{Bc=		RLE/a/}');
    Error('\P{Bc=		RLE/a/}');
    Expect(1, 8235, '\p{Bc=:\ARLE\z:}', "");;
    Expect(0, 8236, '\p{Bc=:\ARLE\z:}', "");;
    Expect(1, 8235, '\p{Bc=rle}', "");
    Expect(0, 8235, '\p{^Bc=rle}', "");
    Expect(0, 8235, '\P{Bc=rle}', "");
    Expect(1, 8235, '\P{^Bc=rle}', "");
    Expect(0, 8236, '\p{Bc=rle}', "");
    Expect(1, 8236, '\p{^Bc=rle}', "");
    Expect(1, 8236, '\P{Bc=rle}', "");
    Expect(0, 8236, '\P{^Bc=rle}', "");
    Expect(1, 8235, '\p{Bc=:\Arle\z:}', "");;
    Expect(0, 8236, '\p{Bc=:\Arle\z:}', "");;
    Expect(1, 8235, '\p{Bc= _rle}', "");
    Expect(0, 8235, '\p{^Bc= _rle}', "");
    Expect(0, 8235, '\P{Bc= _rle}', "");
    Expect(1, 8235, '\P{^Bc= _rle}', "");
    Expect(0, 8236, '\p{Bc= _rle}', "");
    Expect(1, 8236, '\p{^Bc= _rle}', "");
    Expect(1, 8236, '\P{Bc= _rle}', "");
    Expect(0, 8236, '\P{^Bc= _rle}', "");
    Error('\p{Is_Bidi_Class=/a/RIGHT_to_Left_embedding}');
    Error('\P{Is_Bidi_Class=/a/RIGHT_to_Left_embedding}');
    Expect(1, 8235, '\p{Is_Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8235, '\p{^Is_Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8235, '\P{Is_Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8235, '\P{^Is_Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8236, '\p{Is_Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8236, '\p{^Is_Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8236, '\P{Is_Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8236, '\P{^Is_Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8235, '\p{Is_Bidi_Class=	 RIGHT_to_Left_Embedding}', "");
    Expect(0, 8235, '\p{^Is_Bidi_Class=	 RIGHT_to_Left_Embedding}', "");
    Expect(0, 8235, '\P{Is_Bidi_Class=	 RIGHT_to_Left_Embedding}', "");
    Expect(1, 8235, '\P{^Is_Bidi_Class=	 RIGHT_to_Left_Embedding}', "");
    Expect(0, 8236, '\p{Is_Bidi_Class=	 RIGHT_to_Left_Embedding}', "");
    Expect(1, 8236, '\p{^Is_Bidi_Class=	 RIGHT_to_Left_Embedding}', "");
    Expect(1, 8236, '\P{Is_Bidi_Class=	 RIGHT_to_Left_Embedding}', "");
    Expect(0, 8236, '\P{^Is_Bidi_Class=	 RIGHT_to_Left_Embedding}', "");
    Error('\p{Is_Bc=:=_-RLE}');
    Error('\P{Is_Bc=:=_-RLE}');
    Expect(1, 8235, '\p{Is_Bc=rle}', "");
    Expect(0, 8235, '\p{^Is_Bc=rle}', "");
    Expect(0, 8235, '\P{Is_Bc=rle}', "");
    Expect(1, 8235, '\P{^Is_Bc=rle}', "");
    Expect(0, 8236, '\p{Is_Bc=rle}', "");
    Expect(1, 8236, '\p{^Is_Bc=rle}', "");
    Expect(1, 8236, '\P{Is_Bc=rle}', "");
    Expect(0, 8236, '\P{^Is_Bc=rle}', "");
    Expect(1, 8235, '\p{Is_Bc=	RLE}', "");
    Expect(0, 8235, '\p{^Is_Bc=	RLE}', "");
    Expect(0, 8235, '\P{Is_Bc=	RLE}', "");
    Expect(1, 8235, '\P{^Is_Bc=	RLE}', "");
    Expect(0, 8236, '\p{Is_Bc=	RLE}', "");
    Expect(1, 8236, '\p{^Is_Bc=	RLE}', "");
    Expect(1, 8236, '\P{Is_Bc=	RLE}', "");
    Expect(0, 8236, '\P{^Is_Bc=	RLE}', "");
    Error('\p{Bidi_Class=-	Right_To_LEFT_isolate/a/}');
    Error('\P{Bidi_Class=-	Right_To_LEFT_isolate/a/}');
    Expect(1, 8295, '\p{Bidi_Class=:\ARight_To_Left_Isolate\z:}', "");;
    Expect(0, 8296, '\p{Bidi_Class=:\ARight_To_Left_Isolate\z:}', "");;
    Expect(1, 8295, '\p{Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8295, '\p{^Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8295, '\P{Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8295, '\P{^Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8296, '\p{Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8296, '\p{^Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8296, '\P{Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8296, '\P{^Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8295, '\p{Bidi_Class=:\Arighttoleftisolate\z:}', "");;
    Expect(0, 8296, '\p{Bidi_Class=:\Arighttoleftisolate\z:}', "");;
    Expect(1, 8295, '\p{Bidi_Class= Right_TO_Left_Isolate}', "");
    Expect(0, 8295, '\p{^Bidi_Class= Right_TO_Left_Isolate}', "");
    Expect(0, 8295, '\P{Bidi_Class= Right_TO_Left_Isolate}', "");
    Expect(1, 8295, '\P{^Bidi_Class= Right_TO_Left_Isolate}', "");
    Expect(0, 8296, '\p{Bidi_Class= Right_TO_Left_Isolate}', "");
    Expect(1, 8296, '\p{^Bidi_Class= Right_TO_Left_Isolate}', "");
    Expect(1, 8296, '\P{Bidi_Class= Right_TO_Left_Isolate}', "");
    Expect(0, 8296, '\P{^Bidi_Class= Right_TO_Left_Isolate}', "");
    Error('\p{Bc:   /a/	_RLI}');
    Error('\P{Bc:   /a/	_RLI}');
    Expect(1, 8295, '\p{Bc=:\ARLI\z:}', "");;
    Expect(0, 8296, '\p{Bc=:\ARLI\z:}', "");;
    Expect(1, 8295, '\p{Bc=rli}', "");
    Expect(0, 8295, '\p{^Bc=rli}', "");
    Expect(0, 8295, '\P{Bc=rli}', "");
    Expect(1, 8295, '\P{^Bc=rli}', "");
    Expect(0, 8296, '\p{Bc=rli}', "");
    Expect(1, 8296, '\p{^Bc=rli}', "");
    Expect(1, 8296, '\P{Bc=rli}', "");
    Expect(0, 8296, '\P{^Bc=rli}', "");
    Expect(1, 8295, '\p{Bc=:\Arli\z:}', "");;
    Expect(0, 8296, '\p{Bc=:\Arli\z:}', "");;
    Expect(1, 8295, '\p{Bc=-RLI}', "");
    Expect(0, 8295, '\p{^Bc=-RLI}', "");
    Expect(0, 8295, '\P{Bc=-RLI}', "");
    Expect(1, 8295, '\P{^Bc=-RLI}', "");
    Expect(0, 8296, '\p{Bc=-RLI}', "");
    Expect(1, 8296, '\p{^Bc=-RLI}', "");
    Expect(1, 8296, '\P{Bc=-RLI}', "");
    Expect(0, 8296, '\P{^Bc=-RLI}', "");
    Error('\p{Is_Bidi_Class=/a/	 Right_To_Left_ISOLATE}');
    Error('\P{Is_Bidi_Class=/a/	 Right_To_Left_ISOLATE}');
    Expect(1, 8295, '\p{Is_Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8295, '\p{^Is_Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8295, '\P{Is_Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8295, '\P{^Is_Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8296, '\p{Is_Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8296, '\p{^Is_Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8296, '\P{Is_Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8296, '\P{^Is_Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8295, '\p{Is_Bidi_Class= 	Right_TO_Left_ISOLATE}', "");
    Expect(0, 8295, '\p{^Is_Bidi_Class= 	Right_TO_Left_ISOLATE}', "");
    Expect(0, 8295, '\P{Is_Bidi_Class= 	Right_TO_Left_ISOLATE}', "");
    Expect(1, 8295, '\P{^Is_Bidi_Class= 	Right_TO_Left_ISOLATE}', "");
    Expect(0, 8296, '\p{Is_Bidi_Class= 	Right_TO_Left_ISOLATE}', "");
    Expect(1, 8296, '\p{^Is_Bidi_Class= 	Right_TO_Left_ISOLATE}', "");
    Expect(1, 8296, '\P{Is_Bidi_Class= 	Right_TO_Left_ISOLATE}', "");
    Expect(0, 8296, '\P{^Is_Bidi_Class= 	Right_TO_Left_ISOLATE}', "");
    Error('\p{Is_Bc:	/a/-	rli}');
    Error('\P{Is_Bc:	/a/-	rli}');
    Expect(1, 8295, '\p{Is_Bc=rli}', "");
    Expect(0, 8295, '\p{^Is_Bc=rli}', "");
    Expect(0, 8295, '\P{Is_Bc=rli}', "");
    Expect(1, 8295, '\P{^Is_Bc=rli}', "");
    Expect(0, 8296, '\p{Is_Bc=rli}', "");
    Expect(1, 8296, '\p{^Is_Bc=rli}', "");
    Expect(1, 8296, '\P{Is_Bc=rli}', "");
    Expect(0, 8296, '\P{^Is_Bc=rli}', "");
    Expect(1, 8295, '\p{Is_Bc= -rli}', "");
    Expect(0, 8295, '\p{^Is_Bc= -rli}', "");
    Expect(0, 8295, '\P{Is_Bc= -rli}', "");
    Expect(1, 8295, '\P{^Is_Bc= -rli}', "");
    Expect(0, 8296, '\p{Is_Bc= -rli}', "");
    Expect(1, 8296, '\p{^Is_Bc= -rli}', "");
    Expect(1, 8296, '\P{Is_Bc= -rli}', "");
    Expect(0, 8296, '\P{^Is_Bc= -rli}', "");
    Error('\p{Bidi_Class:/a/Right_to_LEFT_OVERRIDE}');
    Error('\P{Bidi_Class:/a/Right_to_LEFT_OVERRIDE}');
    Expect(1, 8238, '\p{Bidi_Class=:\ARight_To_Left_Override\z:}', "");;
    Expect(0, 8239, '\p{Bidi_Class=:\ARight_To_Left_Override\z:}', "");;
    Expect(1, 8238, '\p{Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8238, '\p{^Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8238, '\P{Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8238, '\P{^Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8239, '\p{Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8239, '\p{^Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8239, '\P{Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8239, '\P{^Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8238, '\p{Bidi_Class=:\Arighttoleftoverride\z:}', "");;
    Expect(0, 8239, '\p{Bidi_Class=:\Arighttoleftoverride\z:}', "");;
    Expect(1, 8238, '\p{Bidi_Class:   _ RIGHT_to_Left_Override}', "");
    Expect(0, 8238, '\p{^Bidi_Class:   _ RIGHT_to_Left_Override}', "");
    Expect(0, 8238, '\P{Bidi_Class:   _ RIGHT_to_Left_Override}', "");
    Expect(1, 8238, '\P{^Bidi_Class:   _ RIGHT_to_Left_Override}', "");
    Expect(0, 8239, '\p{Bidi_Class:   _ RIGHT_to_Left_Override}', "");
    Expect(1, 8239, '\p{^Bidi_Class:   _ RIGHT_to_Left_Override}', "");
    Expect(1, 8239, '\P{Bidi_Class:   _ RIGHT_to_Left_Override}', "");
    Expect(0, 8239, '\P{^Bidi_Class:   _ RIGHT_to_Left_Override}', "");
    Error('\p{Bc=/a/	RLO}');
    Error('\P{Bc=/a/	RLO}');
    Expect(1, 8238, '\p{Bc=:\ARLO\z:}', "");;
    Expect(0, 8239, '\p{Bc=:\ARLO\z:}', "");;
    Expect(1, 8238, '\p{Bc=rlo}', "");
    Expect(0, 8238, '\p{^Bc=rlo}', "");
    Expect(0, 8238, '\P{Bc=rlo}', "");
    Expect(1, 8238, '\P{^Bc=rlo}', "");
    Expect(0, 8239, '\p{Bc=rlo}', "");
    Expect(1, 8239, '\p{^Bc=rlo}', "");
    Expect(1, 8239, '\P{Bc=rlo}', "");
    Expect(0, 8239, '\P{^Bc=rlo}', "");
    Expect(1, 8238, '\p{Bc=:\Arlo\z:}', "");;
    Expect(0, 8239, '\p{Bc=:\Arlo\z:}', "");;
    Expect(1, 8238, '\p{Bc=	 rlo}', "");
    Expect(0, 8238, '\p{^Bc=	 rlo}', "");
    Expect(0, 8238, '\P{Bc=	 rlo}', "");
    Expect(1, 8238, '\P{^Bc=	 rlo}', "");
    Expect(0, 8239, '\p{Bc=	 rlo}', "");
    Expect(1, 8239, '\p{^Bc=	 rlo}', "");
    Expect(1, 8239, '\P{Bc=	 rlo}', "");
    Expect(0, 8239, '\P{^Bc=	 rlo}', "");
    Error('\p{Is_Bidi_Class:_-Right_To_Left_override:=}');
    Error('\P{Is_Bidi_Class:_-Right_To_Left_override:=}');
    Expect(1, 8238, '\p{Is_Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8238, '\p{^Is_Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8238, '\P{Is_Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8238, '\P{^Is_Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8239, '\p{Is_Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8239, '\p{^Is_Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8239, '\P{Is_Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8239, '\P{^Is_Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8238, '\p{Is_Bidi_Class= _RIGHT_To_Left_OVERRIDE}', "");
    Expect(0, 8238, '\p{^Is_Bidi_Class= _RIGHT_To_Left_OVERRIDE}', "");
    Expect(0, 8238, '\P{Is_Bidi_Class= _RIGHT_To_Left_OVERRIDE}', "");
    Expect(1, 8238, '\P{^Is_Bidi_Class= _RIGHT_To_Left_OVERRIDE}', "");
    Expect(0, 8239, '\p{Is_Bidi_Class= _RIGHT_To_Left_OVERRIDE}', "");
    Expect(1, 8239, '\p{^Is_Bidi_Class= _RIGHT_To_Left_OVERRIDE}', "");
    Expect(1, 8239, '\P{Is_Bidi_Class= _RIGHT_To_Left_OVERRIDE}', "");
    Expect(0, 8239, '\P{^Is_Bidi_Class= _RIGHT_To_Left_OVERRIDE}', "");
    Error('\p{Is_Bc=:=- RLO}');
    Error('\P{Is_Bc=:=- RLO}');
    Expect(1, 8238, '\p{Is_Bc=rlo}', "");
    Expect(0, 8238, '\p{^Is_Bc=rlo}', "");
    Expect(0, 8238, '\P{Is_Bc=rlo}', "");
    Expect(1, 8238, '\P{^Is_Bc=rlo}', "");
    Expect(0, 8239, '\p{Is_Bc=rlo}', "");
    Expect(1, 8239, '\p{^Is_Bc=rlo}', "");
    Expect(1, 8239, '\P{Is_Bc=rlo}', "");
    Expect(0, 8239, '\P{^Is_Bc=rlo}', "");
    Expect(1, 8238, '\p{Is_Bc=__RLO}', "");
    Expect(0, 8238, '\p{^Is_Bc=__RLO}', "");
    Expect(0, 8238, '\P{Is_Bc=__RLO}', "");
    Expect(1, 8238, '\P{^Is_Bc=__RLO}', "");
    Expect(0, 8239, '\p{Is_Bc=__RLO}', "");
    Expect(1, 8239, '\p{^Is_Bc=__RLO}', "");
    Expect(1, 8239, '\P{Is_Bc=__RLO}', "");
    Expect(0, 8239, '\P{^Is_Bc=__RLO}', "");
    Error('\p{Bidi_Class: :=-segment_SEPARATOR}');
    Error('\P{Bidi_Class: :=-segment_SEPARATOR}');
    Expect(1, 31, '\p{Bidi_Class=:\ASegment_Separator\z:}', "");;
    Expect(0, 32, '\p{Bidi_Class=:\ASegment_Separator\z:}', "");;
    Expect(1, 31, '\p{Bidi_Class=segmentseparator}', "");
    Expect(0, 31, '\p{^Bidi_Class=segmentseparator}', "");
    Expect(0, 31, '\P{Bidi_Class=segmentseparator}', "");
    Expect(1, 31, '\P{^Bidi_Class=segmentseparator}', "");
    Expect(0, 32, '\p{Bidi_Class=segmentseparator}', "");
    Expect(1, 32, '\p{^Bidi_Class=segmentseparator}', "");
    Expect(1, 32, '\P{Bidi_Class=segmentseparator}', "");
    Expect(0, 32, '\P{^Bidi_Class=segmentseparator}', "");
    Expect(1, 31, '\p{Bidi_Class=:\Asegmentseparator\z:}', "");;
    Expect(0, 32, '\p{Bidi_Class=:\Asegmentseparator\z:}', "");;
    Expect(1, 31, '\p{Bidi_Class=	segment_Separator}', "");
    Expect(0, 31, '\p{^Bidi_Class=	segment_Separator}', "");
    Expect(0, 31, '\P{Bidi_Class=	segment_Separator}', "");
    Expect(1, 31, '\P{^Bidi_Class=	segment_Separator}', "");
    Expect(0, 32, '\p{Bidi_Class=	segment_Separator}', "");
    Expect(1, 32, '\p{^Bidi_Class=	segment_Separator}', "");
    Expect(1, 32, '\P{Bidi_Class=	segment_Separator}', "");
    Expect(0, 32, '\P{^Bidi_Class=	segment_Separator}', "");
    Error('\p{Bc=	 S/a/}');
    Error('\P{Bc=	 S/a/}');
    Expect(1, 31, '\p{Bc=:\AS\z:}', "");;
    Expect(0, 32, '\p{Bc=:\AS\z:}', "");;
    Expect(1, 31, '\p{Bc=s}', "");
    Expect(0, 31, '\p{^Bc=s}', "");
    Expect(0, 31, '\P{Bc=s}', "");
    Expect(1, 31, '\P{^Bc=s}', "");
    Expect(0, 32, '\p{Bc=s}', "");
    Expect(1, 32, '\p{^Bc=s}', "");
    Expect(1, 32, '\P{Bc=s}', "");
    Expect(0, 32, '\P{^Bc=s}', "");
    Expect(1, 31, '\p{Bc=:\As\z:}', "");;
    Expect(0, 32, '\p{Bc=:\As\z:}', "");;
    Expect(1, 31, '\p{Bc=S}', "");
    Expect(0, 31, '\p{^Bc=S}', "");
    Expect(0, 31, '\P{Bc=S}', "");
    Expect(1, 31, '\P{^Bc=S}', "");
    Expect(0, 32, '\p{Bc=S}', "");
    Expect(1, 32, '\p{^Bc=S}', "");
    Expect(1, 32, '\P{Bc=S}', "");
    Expect(0, 32, '\P{^Bc=S}', "");
    Error('\p{Is_Bidi_Class=	Segment_Separator:=}');
    Error('\P{Is_Bidi_Class=	Segment_Separator:=}');
    Expect(1, 31, '\p{Is_Bidi_Class:   segmentseparator}', "");
    Expect(0, 31, '\p{^Is_Bidi_Class:   segmentseparator}', "");
    Expect(0, 31, '\P{Is_Bidi_Class:   segmentseparator}', "");
    Expect(1, 31, '\P{^Is_Bidi_Class:   segmentseparator}', "");
    Expect(0, 32, '\p{Is_Bidi_Class:   segmentseparator}', "");
    Expect(1, 32, '\p{^Is_Bidi_Class:   segmentseparator}', "");
    Expect(1, 32, '\P{Is_Bidi_Class:   segmentseparator}', "");
    Expect(0, 32, '\P{^Is_Bidi_Class:   segmentseparator}', "");
    Expect(1, 31, '\p{Is_Bidi_Class=-segment_Separator}', "");
    Expect(0, 31, '\p{^Is_Bidi_Class=-segment_Separator}', "");
    Expect(0, 31, '\P{Is_Bidi_Class=-segment_Separator}', "");
    Expect(1, 31, '\P{^Is_Bidi_Class=-segment_Separator}', "");
    Expect(0, 32, '\p{Is_Bidi_Class=-segment_Separator}', "");
    Expect(1, 32, '\p{^Is_Bidi_Class=-segment_Separator}', "");
    Expect(1, 32, '\P{Is_Bidi_Class=-segment_Separator}', "");
    Expect(0, 32, '\P{^Is_Bidi_Class=-segment_Separator}', "");
    Error('\p{Is_Bc:	 S/a/}');
    Error('\P{Is_Bc:	 S/a/}');
    Expect(1, 31, '\p{Is_Bc=s}', "");
    Expect(0, 31, '\p{^Is_Bc=s}', "");
    Expect(0, 31, '\P{Is_Bc=s}', "");
    Expect(1, 31, '\P{^Is_Bc=s}', "");
    Expect(0, 32, '\p{Is_Bc=s}', "");
    Expect(1, 32, '\p{^Is_Bc=s}', "");
    Expect(1, 32, '\P{Is_Bc=s}', "");
    Expect(0, 32, '\P{^Is_Bc=s}', "");
    Expect(1, 31, '\p{Is_Bc=_-S}', "");
    Expect(0, 31, '\p{^Is_Bc=_-S}', "");
    Expect(0, 31, '\P{Is_Bc=_-S}', "");
    Expect(1, 31, '\P{^Is_Bc=_-S}', "");
    Expect(0, 32, '\p{Is_Bc=_-S}', "");
    Expect(1, 32, '\p{^Is_Bc=_-S}', "");
    Expect(1, 32, '\P{Is_Bc=_-S}', "");
    Expect(0, 32, '\P{^Is_Bc=_-S}', "");
    Error('\p{Bidi_Class= :=White_Space}');
    Error('\P{Bidi_Class= :=White_Space}');
    Expect(1, 12288, '\p{Bidi_Class=:\AWhite_Space\z:}', "");;
    Expect(0, 12289, '\p{Bidi_Class=:\AWhite_Space\z:}', "");;
    Expect(1, 12288, '\p{Bidi_Class=whitespace}', "");
    Expect(0, 12288, '\p{^Bidi_Class=whitespace}', "");
    Expect(0, 12288, '\P{Bidi_Class=whitespace}', "");
    Expect(1, 12288, '\P{^Bidi_Class=whitespace}', "");
    Expect(0, 12289, '\p{Bidi_Class=whitespace}', "");
    Expect(1, 12289, '\p{^Bidi_Class=whitespace}', "");
    Expect(1, 12289, '\P{Bidi_Class=whitespace}', "");
    Expect(0, 12289, '\P{^Bidi_Class=whitespace}', "");
    Expect(1, 12288, '\p{Bidi_Class=:\Awhitespace\z:}', "");;
    Expect(0, 12289, '\p{Bidi_Class=:\Awhitespace\z:}', "");;
    Expect(1, 12288, '\p{Bidi_Class=	 White_space}', "");
    Expect(0, 12288, '\p{^Bidi_Class=	 White_space}', "");
    Expect(0, 12288, '\P{Bidi_Class=	 White_space}', "");
    Expect(1, 12288, '\P{^Bidi_Class=	 White_space}', "");
    Expect(0, 12289, '\p{Bidi_Class=	 White_space}', "");
    Expect(1, 12289, '\p{^Bidi_Class=	 White_space}', "");
    Expect(1, 12289, '\P{Bidi_Class=	 White_space}', "");
    Expect(0, 12289, '\P{^Bidi_Class=	 White_space}', "");
    Error('\p{Bc=-:=WS}');
    Error('\P{Bc=-:=WS}');
    Expect(1, 12288, '\p{Bc=:\AWS\z:}', "");;
    Expect(0, 12289, '\p{Bc=:\AWS\z:}', "");;
    Expect(1, 12288, '\p{Bc=ws}', "");
    Expect(0, 12288, '\p{^Bc=ws}', "");
    Expect(0, 12288, '\P{Bc=ws}', "");
    Expect(1, 12288, '\P{^Bc=ws}', "");
    Expect(0, 12289, '\p{Bc=ws}', "");
    Expect(1, 12289, '\p{^Bc=ws}', "");
    Expect(1, 12289, '\P{Bc=ws}', "");
    Expect(0, 12289, '\P{^Bc=ws}', "");
    Expect(1, 12288, '\p{Bc=:\Aws\z:}', "");;
    Expect(0, 12289, '\p{Bc=:\Aws\z:}', "");;
    Expect(1, 12288, '\p{Bc=WS}', "");
    Expect(0, 12288, '\p{^Bc=WS}', "");
    Expect(0, 12288, '\P{Bc=WS}', "");
    Expect(1, 12288, '\P{^Bc=WS}', "");
    Expect(0, 12289, '\p{Bc=WS}', "");
    Expect(1, 12289, '\p{^Bc=WS}', "");
    Expect(1, 12289, '\P{Bc=WS}', "");
    Expect(0, 12289, '\P{^Bc=WS}', "");
    Error('\p{Is_Bidi_Class=-_WHITE_SPACE:=}');
    Error('\P{Is_Bidi_Class=-_WHITE_SPACE:=}');
    Expect(1, 12288, '\p{Is_Bidi_Class=whitespace}', "");
    Expect(0, 12288, '\p{^Is_Bidi_Class=whitespace}', "");
    Expect(0, 12288, '\P{Is_Bidi_Class=whitespace}', "");
    Expect(1, 12288, '\P{^Is_Bidi_Class=whitespace}', "");
    Expect(0, 12289, '\p{Is_Bidi_Class=whitespace}', "");
    Expect(1, 12289, '\p{^Is_Bidi_Class=whitespace}', "");
    Expect(1, 12289, '\P{Is_Bidi_Class=whitespace}', "");
    Expect(0, 12289, '\P{^Is_Bidi_Class=whitespace}', "");
    Expect(1, 12288, '\p{Is_Bidi_Class= WHITE_SPACE}', "");
    Expect(0, 12288, '\p{^Is_Bidi_Class= WHITE_SPACE}', "");
    Expect(0, 12288, '\P{Is_Bidi_Class= WHITE_SPACE}', "");
    Expect(1, 12288, '\P{^Is_Bidi_Class= WHITE_SPACE}', "");
    Expect(0, 12289, '\p{Is_Bidi_Class= WHITE_SPACE}', "");
    Expect(1, 12289, '\p{^Is_Bidi_Class= WHITE_SPACE}', "");
    Expect(1, 12289, '\P{Is_Bidi_Class= WHITE_SPACE}', "");
    Expect(0, 12289, '\P{^Is_Bidi_Class= WHITE_SPACE}', "");
    Error('\p{Is_Bc=-/a/WS}');
    Error('\P{Is_Bc=-/a/WS}');
    Expect(1, 12288, '\p{Is_Bc:	ws}', "");
    Expect(0, 12288, '\p{^Is_Bc:	ws}', "");
    Expect(0, 12288, '\P{Is_Bc:	ws}', "");
    Expect(1, 12288, '\P{^Is_Bc:	ws}', "");
    Expect(0, 12289, '\p{Is_Bc:	ws}', "");
    Expect(1, 12289, '\p{^Is_Bc:	ws}', "");
    Expect(1, 12289, '\P{Is_Bc:	ws}', "");
    Expect(0, 12289, '\P{^Is_Bc:	ws}', "");
    Expect(1, 12288, '\p{Is_Bc=-_WS}', "");
    Expect(0, 12288, '\p{^Is_Bc=-_WS}', "");
    Expect(0, 12288, '\P{Is_Bc=-_WS}', "");
    Expect(1, 12288, '\P{^Is_Bc=-_WS}', "");
    Expect(0, 12289, '\p{Is_Bc=-_WS}', "");
    Expect(1, 12289, '\p{^Is_Bc=-_WS}', "");
    Expect(1, 12289, '\P{Is_Bc=-_WS}', "");
    Expect(0, 12289, '\P{^Is_Bc=-_WS}', "");
    Error('\p{Bidi_Control: _:=no}');
    Error('\P{Bidi_Control: _:=no}');
    Expect(1, 8298, '\p{Bidi_Control=:\ANo\z:}', "");;
    Expect(0, 8297, '\p{Bidi_Control=:\ANo\z:}', "");;
    Expect(1, 8298, '\p{Bidi_Control=no}', "");
    Expect(0, 8298, '\p{^Bidi_Control=no}', "");
    Expect(0, 8298, '\P{Bidi_Control=no}', "");
    Expect(1, 8298, '\P{^Bidi_Control=no}', "");
    Expect(0, 8297, '\p{Bidi_Control=no}', "");
    Expect(1, 8297, '\p{^Bidi_Control=no}', "");
    Expect(1, 8297, '\P{Bidi_Control=no}', "");
    Expect(0, 8297, '\P{^Bidi_Control=no}', "");
    Expect(1, 8298, '\p{Bidi_Control=:\Ano\z:}', "");;
    Expect(0, 8297, '\p{Bidi_Control=:\Ano\z:}', "");;
    Expect(1, 8298, '\p{Bidi_Control=_no}', "");
    Expect(0, 8298, '\p{^Bidi_Control=_no}', "");
    Expect(0, 8298, '\P{Bidi_Control=_no}', "");
    Expect(1, 8298, '\P{^Bidi_Control=_no}', "");
    Expect(0, 8297, '\p{Bidi_Control=_no}', "");
    Expect(1, 8297, '\p{^Bidi_Control=_no}', "");
    Expect(1, 8297, '\P{Bidi_Control=_no}', "");
    Expect(0, 8297, '\P{^Bidi_Control=_no}', "");
    Error('\p{Bidi_C=_-N/a/}');
    Error('\P{Bidi_C=_-N/a/}');
    Expect(1, 8298, '\p{Bidi_C=:\AN\z:}', "");;
    Expect(0, 8297, '\p{Bidi_C=:\AN\z:}', "");;
    Expect(1, 8298, '\p{Bidi_C=n}', "");
    Expect(0, 8298, '\p{^Bidi_C=n}', "");
    Expect(0, 8298, '\P{Bidi_C=n}', "");
    Expect(1, 8298, '\P{^Bidi_C=n}', "");
    Expect(0, 8297, '\p{Bidi_C=n}', "");
    Expect(1, 8297, '\p{^Bidi_C=n}', "");
    Expect(1, 8297, '\P{Bidi_C=n}', "");
    Expect(0, 8297, '\P{^Bidi_C=n}', "");
    Expect(1, 8298, '\p{Bidi_C=:\An\z:}', "");;
    Expect(0, 8297, '\p{Bidi_C=:\An\z:}', "");;
    Expect(1, 8298, '\p{Bidi_C= 	N}', "");
    Expect(0, 8298, '\p{^Bidi_C= 	N}', "");
    Expect(0, 8298, '\P{Bidi_C= 	N}', "");
    Expect(1, 8298, '\P{^Bidi_C= 	N}', "");
    Expect(0, 8297, '\p{Bidi_C= 	N}', "");
    Expect(1, 8297, '\p{^Bidi_C= 	N}', "");
    Expect(1, 8297, '\P{Bidi_C= 	N}', "");
    Expect(0, 8297, '\P{^Bidi_C= 	N}', "");
    Error('\p{Is_Bidi_Control=:=_F}');
    Error('\P{Is_Bidi_Control=:=_F}');
    Expect(1, 8298, '\p{Is_Bidi_Control: f}', "");
    Expect(0, 8298, '\p{^Is_Bidi_Control: f}', "");
    Expect(0, 8298, '\P{Is_Bidi_Control: f}', "");
    Expect(1, 8298, '\P{^Is_Bidi_Control: f}', "");
    Expect(0, 8297, '\p{Is_Bidi_Control: f}', "");
    Expect(1, 8297, '\p{^Is_Bidi_Control: f}', "");
    Expect(1, 8297, '\P{Is_Bidi_Control: f}', "");
    Expect(0, 8297, '\P{^Is_Bidi_Control: f}', "");
    Expect(1, 8298, '\p{Is_Bidi_Control=	F}', "");
    Expect(0, 8298, '\p{^Is_Bidi_Control=	F}', "");
    Expect(0, 8298, '\P{Is_Bidi_Control=	F}', "");
    Expect(1, 8298, '\P{^Is_Bidi_Control=	F}', "");
    Expect(0, 8297, '\p{Is_Bidi_Control=	F}', "");
    Expect(1, 8297, '\p{^Is_Bidi_Control=	F}', "");
    Expect(1, 8297, '\P{Is_Bidi_Control=	F}', "");
    Expect(0, 8297, '\P{^Is_Bidi_Control=	F}', "");
    Error('\p{Is_Bidi_C=-false:=}');
    Error('\P{Is_Bidi_C=-false:=}');
    Expect(1, 8298, '\p{Is_Bidi_C=false}', "");
    Expect(0, 8298, '\p{^Is_Bidi_C=false}', "");
    Expect(0, 8298, '\P{Is_Bidi_C=false}', "");
    Expect(1, 8298, '\P{^Is_Bidi_C=false}', "");
    Expect(0, 8297, '\p{Is_Bidi_C=false}', "");
    Expect(1, 8297, '\p{^Is_Bidi_C=false}', "");
    Expect(1, 8297, '\P{Is_Bidi_C=false}', "");
    Expect(0, 8297, '\P{^Is_Bidi_C=false}', "");
    Expect(1, 8298, '\p{Is_Bidi_C=-FALSE}', "");
    Expect(0, 8298, '\p{^Is_Bidi_C=-FALSE}', "");
    Expect(0, 8298, '\P{Is_Bidi_C=-FALSE}', "");
    Expect(1, 8298, '\P{^Is_Bidi_C=-FALSE}', "");
    Expect(0, 8297, '\p{Is_Bidi_C=-FALSE}', "");
    Expect(1, 8297, '\p{^Is_Bidi_C=-FALSE}', "");
    Expect(1, 8297, '\P{Is_Bidi_C=-FALSE}', "");
    Expect(0, 8297, '\P{^Is_Bidi_C=-FALSE}', "");
    Error('\p{Bidi_Control=  Yes:=}');
    Error('\P{Bidi_Control=  Yes:=}');
    Expect(1, 8297, '\p{Bidi_Control=:\AYes\z:}', "");;
    Expect(0, 8298, '\p{Bidi_Control=:\AYes\z:}', "");;
    Expect(1, 8297, '\p{Bidi_Control=yes}', "");
    Expect(0, 8297, '\p{^Bidi_Control=yes}', "");
    Expect(0, 8297, '\P{Bidi_Control=yes}', "");
    Expect(1, 8297, '\P{^Bidi_Control=yes}', "");
    Expect(0, 8298, '\p{Bidi_Control=yes}', "");
    Expect(1, 8298, '\p{^Bidi_Control=yes}', "");
    Expect(1, 8298, '\P{Bidi_Control=yes}', "");
    Expect(0, 8298, '\P{^Bidi_Control=yes}', "");
    Expect(1, 8297, '\p{Bidi_Control=:\Ayes\z:}', "");;
    Expect(0, 8298, '\p{Bidi_Control=:\Ayes\z:}', "");;
    Expect(1, 8297, '\p{Bidi_Control=-YES}', "");
    Expect(0, 8297, '\p{^Bidi_Control=-YES}', "");
    Expect(0, 8297, '\P{Bidi_Control=-YES}', "");
    Expect(1, 8297, '\P{^Bidi_Control=-YES}', "");
    Expect(0, 8298, '\p{Bidi_Control=-YES}', "");
    Expect(1, 8298, '\p{^Bidi_Control=-YES}', "");
    Expect(1, 8298, '\P{Bidi_Control=-YES}', "");
    Expect(0, 8298, '\P{^Bidi_Control=-YES}', "");
    Error('\p{Bidi_C=/a/ Y}');
    Error('\P{Bidi_C=/a/ Y}');
    Expect(1, 8297, '\p{Bidi_C=:\AY\z:}', "");;
    Expect(0, 8298, '\p{Bidi_C=:\AY\z:}', "");;
    Expect(1, 8297, '\p{Bidi_C=y}', "");
    Expect(0, 8297, '\p{^Bidi_C=y}', "");
    Expect(0, 8297, '\P{Bidi_C=y}', "");
    Expect(1, 8297, '\P{^Bidi_C=y}', "");
    Expect(0, 8298, '\p{Bidi_C=y}', "");
    Expect(1, 8298, '\p{^Bidi_C=y}', "");
    Expect(1, 8298, '\P{Bidi_C=y}', "");
    Expect(0, 8298, '\P{^Bidi_C=y}', "");
    Expect(1, 8297, '\p{Bidi_C=:\Ay\z:}', "");;
    Expect(0, 8298, '\p{Bidi_C=:\Ay\z:}', "");;
    Expect(1, 8297, '\p{Bidi_C:Y}', "");
    Expect(0, 8297, '\p{^Bidi_C:Y}', "");
    Expect(0, 8297, '\P{Bidi_C:Y}', "");
    Expect(1, 8297, '\P{^Bidi_C:Y}', "");
    Expect(0, 8298, '\p{Bidi_C:Y}', "");
    Expect(1, 8298, '\p{^Bidi_C:Y}', "");
    Expect(1, 8298, '\P{Bidi_C:Y}', "");
    Expect(0, 8298, '\P{^Bidi_C:Y}', "");
    Error('\p{Is_Bidi_Control=/a/_T}');
    Error('\P{Is_Bidi_Control=/a/_T}');
    Expect(1, 8297, '\p{Is_Bidi_Control=t}', "");
    Expect(0, 8297, '\p{^Is_Bidi_Control=t}', "");
    Expect(0, 8297, '\P{Is_Bidi_Control=t}', "");
    Expect(1, 8297, '\P{^Is_Bidi_Control=t}', "");
    Expect(0, 8298, '\p{Is_Bidi_Control=t}', "");
    Expect(1, 8298, '\p{^Is_Bidi_Control=t}', "");
    Expect(1, 8298, '\P{Is_Bidi_Control=t}', "");
    Expect(0, 8298, '\P{^Is_Bidi_Control=t}', "");
    Expect(1, 8297, '\p{Is_Bidi_Control= T}', "");
    Expect(0, 8297, '\p{^Is_Bidi_Control= T}', "");
    Expect(0, 8297, '\P{Is_Bidi_Control= T}', "");
    Expect(1, 8297, '\P{^Is_Bidi_Control= T}', "");
    Expect(0, 8298, '\p{Is_Bidi_Control= T}', "");
    Expect(1, 8298, '\p{^Is_Bidi_Control= T}', "");
    Expect(1, 8298, '\P{Is_Bidi_Control= T}', "");
    Expect(0, 8298, '\P{^Is_Bidi_Control= T}', "");
    Error('\p{Is_Bidi_C=-True:=}');
    Error('\P{Is_Bidi_C=-True:=}');
    Expect(1, 8297, '\p{Is_Bidi_C=true}', "");
    Expect(0, 8297, '\p{^Is_Bidi_C=true}', "");
    Expect(0, 8297, '\P{Is_Bidi_C=true}', "");
    Expect(1, 8297, '\P{^Is_Bidi_C=true}', "");
    Expect(0, 8298, '\p{Is_Bidi_C=true}', "");
    Expect(1, 8298, '\p{^Is_Bidi_C=true}', "");
    Expect(1, 8298, '\P{Is_Bidi_C=true}', "");
    Expect(0, 8298, '\P{^Is_Bidi_C=true}', "");
    Expect(1, 8297, '\p{Is_Bidi_C=	TRUE}', "");
    Expect(0, 8297, '\p{^Is_Bidi_C=	TRUE}', "");
    Expect(0, 8297, '\P{Is_Bidi_C=	TRUE}', "");
    Expect(1, 8297, '\P{^Is_Bidi_C=	TRUE}', "");
    Expect(0, 8298, '\p{Is_Bidi_C=	TRUE}', "");
    Expect(1, 8298, '\p{^Is_Bidi_C=	TRUE}', "");
    Expect(1, 8298, '\P{Is_Bidi_C=	TRUE}', "");
    Expect(0, 8298, '\P{^Is_Bidi_C=	TRUE}', "");
    Error('\p{Bidi_Mirrored=	_No/a/}');
    Error('\P{Bidi_Mirrored=	_No/a/}');
    Expect(1, 120772, '\p{Bidi_Mirrored=:\ANo\z:}', "");;
    Expect(0, 120771, '\p{Bidi_Mirrored=:\ANo\z:}', "");;
    Expect(1, 120772, '\p{Bidi_Mirrored=no}', "");
    Expect(0, 120772, '\p{^Bidi_Mirrored=no}', "");
    Expect(0, 120772, '\P{Bidi_Mirrored=no}', "");
    Expect(1, 120772, '\P{^Bidi_Mirrored=no}', "");
    Expect(0, 120771, '\p{Bidi_Mirrored=no}', "");
    Expect(1, 120771, '\p{^Bidi_Mirrored=no}', "");
    Expect(1, 120771, '\P{Bidi_Mirrored=no}', "");
    Expect(0, 120771, '\P{^Bidi_Mirrored=no}', "");
    Expect(1, 120772, '\p{Bidi_Mirrored=:\Ano\z:}', "");;
    Expect(0, 120771, '\p{Bidi_Mirrored=:\Ano\z:}', "");;
    Expect(1, 120772, '\p{Bidi_Mirrored=  NO}', "");
    Expect(0, 120772, '\p{^Bidi_Mirrored=  NO}', "");
    Expect(0, 120772, '\P{Bidi_Mirrored=  NO}', "");
    Expect(1, 120772, '\P{^Bidi_Mirrored=  NO}', "");
    Expect(0, 120771, '\p{Bidi_Mirrored=  NO}', "");
    Expect(1, 120771, '\p{^Bidi_Mirrored=  NO}', "");
    Expect(1, 120771, '\P{Bidi_Mirrored=  NO}', "");
    Expect(0, 120771, '\P{^Bidi_Mirrored=  NO}', "");
    Error('\p{Bidi_M:	  N:=}');
    Error('\P{Bidi_M:	  N:=}');
    Expect(1, 120772, '\p{Bidi_M=:\AN\z:}', "");;
    Expect(0, 120771, '\p{Bidi_M=:\AN\z:}', "");;
    Expect(1, 120772, '\p{Bidi_M=n}', "");
    Expect(0, 120772, '\p{^Bidi_M=n}', "");
    Expect(0, 120772, '\P{Bidi_M=n}', "");
    Expect(1, 120772, '\P{^Bidi_M=n}', "");
    Expect(0, 120771, '\p{Bidi_M=n}', "");
    Expect(1, 120771, '\p{^Bidi_M=n}', "");
    Expect(1, 120771, '\P{Bidi_M=n}', "");
    Expect(0, 120771, '\P{^Bidi_M=n}', "");
    Expect(1, 120772, '\p{Bidi_M=:\An\z:}', "");;
    Expect(0, 120771, '\p{Bidi_M=:\An\z:}', "");;
    Expect(1, 120772, '\p{Bidi_M=_N}', "");
    Expect(0, 120772, '\p{^Bidi_M=_N}', "");
    Expect(0, 120772, '\P{Bidi_M=_N}', "");
    Expect(1, 120772, '\P{^Bidi_M=_N}', "");
    Expect(0, 120771, '\p{Bidi_M=_N}', "");
    Expect(1, 120771, '\p{^Bidi_M=_N}', "");
    Expect(1, 120771, '\P{Bidi_M=_N}', "");
    Expect(0, 120771, '\P{^Bidi_M=_N}', "");
    Error('\p{Is_Bidi_Mirrored=:=-F}');
    Error('\P{Is_Bidi_Mirrored=:=-F}');
    Expect(1, 120772, '\p{Is_Bidi_Mirrored=f}', "");
    Expect(0, 120772, '\p{^Is_Bidi_Mirrored=f}', "");
    Expect(0, 120772, '\P{Is_Bidi_Mirrored=f}', "");
    Expect(1, 120772, '\P{^Is_Bidi_Mirrored=f}', "");
    Expect(0, 120771, '\p{Is_Bidi_Mirrored=f}', "");
    Expect(1, 120771, '\p{^Is_Bidi_Mirrored=f}', "");
    Expect(1, 120771, '\P{Is_Bidi_Mirrored=f}', "");
    Expect(0, 120771, '\P{^Is_Bidi_Mirrored=f}', "");
    Expect(1, 120772, '\p{Is_Bidi_Mirrored=-	f}', "");
    Expect(0, 120772, '\p{^Is_Bidi_Mirrored=-	f}', "");
    Expect(0, 120772, '\P{Is_Bidi_Mirrored=-	f}', "");
    Expect(1, 120772, '\P{^Is_Bidi_Mirrored=-	f}', "");
    Expect(0, 120771, '\p{Is_Bidi_Mirrored=-	f}', "");
    Expect(1, 120771, '\p{^Is_Bidi_Mirrored=-	f}', "");
    Expect(1, 120771, '\P{Is_Bidi_Mirrored=-	f}', "");
    Expect(0, 120771, '\P{^Is_Bidi_Mirrored=-	f}', "");
    Error('\p{Is_Bidi_M=:=	 false}');
    Error('\P{Is_Bidi_M=:=	 false}');
    Expect(1, 120772, '\p{Is_Bidi_M=false}', "");
    Expect(0, 120772, '\p{^Is_Bidi_M=false}', "");
    Expect(0, 120772, '\P{Is_Bidi_M=false}', "");
    Expect(1, 120772, '\P{^Is_Bidi_M=false}', "");
    Expect(0, 120771, '\p{Is_Bidi_M=false}', "");
    Expect(1, 120771, '\p{^Is_Bidi_M=false}', "");
    Expect(1, 120771, '\P{Is_Bidi_M=false}', "");
    Expect(0, 120771, '\P{^Is_Bidi_M=false}', "");
    Expect(1, 120772, '\p{Is_Bidi_M: -False}', "");
    Expect(0, 120772, '\p{^Is_Bidi_M: -False}', "");
    Expect(0, 120772, '\P{Is_Bidi_M: -False}', "");
    Expect(1, 120772, '\P{^Is_Bidi_M: -False}', "");
    Expect(0, 120771, '\p{Is_Bidi_M: -False}', "");
    Expect(1, 120771, '\p{^Is_Bidi_M: -False}', "");
    Expect(1, 120771, '\P{Is_Bidi_M: -False}', "");
    Expect(0, 120771, '\P{^Is_Bidi_M: -False}', "");
    Error('\p{Bidi_Mirrored=-:=Yes}');
    Error('\P{Bidi_Mirrored=-:=Yes}');
    Expect(1, 120771, '\p{Bidi_Mirrored=:\AYes\z:}', "");;
    Expect(0, 120772, '\p{Bidi_Mirrored=:\AYes\z:}', "");;
    Expect(1, 120771, '\p{Bidi_Mirrored=yes}', "");
    Expect(0, 120771, '\p{^Bidi_Mirrored=yes}', "");
    Expect(0, 120771, '\P{Bidi_Mirrored=yes}', "");
    Expect(1, 120771, '\P{^Bidi_Mirrored=yes}', "");
    Expect(0, 120772, '\p{Bidi_Mirrored=yes}', "");
    Expect(1, 120772, '\p{^Bidi_Mirrored=yes}', "");
    Expect(1, 120772, '\P{Bidi_Mirrored=yes}', "");
    Expect(0, 120772, '\P{^Bidi_Mirrored=yes}', "");
    Expect(1, 120771, '\p{Bidi_Mirrored=:\Ayes\z:}', "");;
    Expect(0, 120772, '\p{Bidi_Mirrored=:\Ayes\z:}', "");;
    Expect(1, 120771, '\p{Bidi_Mirrored=- Yes}', "");
    Expect(0, 120771, '\p{^Bidi_Mirrored=- Yes}', "");
    Expect(0, 120771, '\P{Bidi_Mirrored=- Yes}', "");
    Expect(1, 120771, '\P{^Bidi_Mirrored=- Yes}', "");
    Expect(0, 120772, '\p{Bidi_Mirrored=- Yes}', "");
    Expect(1, 120772, '\p{^Bidi_Mirrored=- Yes}', "");
    Expect(1, 120772, '\P{Bidi_Mirrored=- Yes}', "");
    Expect(0, 120772, '\P{^Bidi_Mirrored=- Yes}', "");
    Error('\p{Bidi_M=__y/a/}');
    Error('\P{Bidi_M=__y/a/}');
    Expect(1, 120771, '\p{Bidi_M=:\AY\z:}', "");;
    Expect(0, 120772, '\p{Bidi_M=:\AY\z:}', "");;
    Expect(1, 120771, '\p{Bidi_M=y}', "");
    Expect(0, 120771, '\p{^Bidi_M=y}', "");
    Expect(0, 120771, '\P{Bidi_M=y}', "");
    Expect(1, 120771, '\P{^Bidi_M=y}', "");
    Expect(0, 120772, '\p{Bidi_M=y}', "");
    Expect(1, 120772, '\p{^Bidi_M=y}', "");
    Expect(1, 120772, '\P{Bidi_M=y}', "");
    Expect(0, 120772, '\P{^Bidi_M=y}', "");
    Expect(1, 120771, '\p{Bidi_M=:\Ay\z:}', "");;
    Expect(0, 120772, '\p{Bidi_M=:\Ay\z:}', "");;
    Expect(1, 120771, '\p{Bidi_M=	y}', "");
    Expect(0, 120771, '\p{^Bidi_M=	y}', "");
    Expect(0, 120771, '\P{Bidi_M=	y}', "");
    Expect(1, 120771, '\P{^Bidi_M=	y}', "");
    Expect(0, 120772, '\p{Bidi_M=	y}', "");
    Expect(1, 120772, '\p{^Bidi_M=	y}', "");
    Expect(1, 120772, '\P{Bidi_M=	y}', "");
    Expect(0, 120772, '\P{^Bidi_M=	y}', "");
    Error('\p{Is_Bidi_Mirrored=:=T}');
    Error('\P{Is_Bidi_Mirrored=:=T}');
    Expect(1, 120771, '\p{Is_Bidi_Mirrored=t}', "");
    Expect(0, 120771, '\p{^Is_Bidi_Mirrored=t}', "");
    Expect(0, 120771, '\P{Is_Bidi_Mirrored=t}', "");
    Expect(1, 120771, '\P{^Is_Bidi_Mirrored=t}', "");
    Expect(0, 120772, '\p{Is_Bidi_Mirrored=t}', "");
    Expect(1, 120772, '\p{^Is_Bidi_Mirrored=t}', "");
    Expect(1, 120772, '\P{Is_Bidi_Mirrored=t}', "");
    Expect(0, 120772, '\P{^Is_Bidi_Mirrored=t}', "");
    Expect(1, 120771, '\p{Is_Bidi_Mirrored=_ T}', "");
    Expect(0, 120771, '\p{^Is_Bidi_Mirrored=_ T}', "");
    Expect(0, 120771, '\P{Is_Bidi_Mirrored=_ T}', "");
    Expect(1, 120771, '\P{^Is_Bidi_Mirrored=_ T}', "");
    Expect(0, 120772, '\p{Is_Bidi_Mirrored=_ T}', "");
    Expect(1, 120772, '\p{^Is_Bidi_Mirrored=_ T}', "");
    Expect(1, 120772, '\P{Is_Bidi_Mirrored=_ T}', "");
    Expect(0, 120772, '\P{^Is_Bidi_Mirrored=_ T}', "");
    Error('\p{Is_Bidi_M=_-true/a/}');
    Error('\P{Is_Bidi_M=_-true/a/}');
    Expect(1, 120771, '\p{Is_Bidi_M=true}', "");
    Expect(0, 120771, '\p{^Is_Bidi_M=true}', "");
    Expect(0, 120771, '\P{Is_Bidi_M=true}', "");
    Expect(1, 120771, '\P{^Is_Bidi_M=true}', "");
    Expect(0, 120772, '\p{Is_Bidi_M=true}', "");
    Expect(1, 120772, '\p{^Is_Bidi_M=true}', "");
    Expect(1, 120772, '\P{Is_Bidi_M=true}', "");
    Expect(0, 120772, '\P{^Is_Bidi_M=true}', "");
    Expect(1, 120771, '\p{Is_Bidi_M= -TRUE}', "");
    Expect(0, 120771, '\p{^Is_Bidi_M= -TRUE}', "");
    Expect(0, 120771, '\P{Is_Bidi_M= -TRUE}', "");
    Expect(1, 120771, '\P{^Is_Bidi_M= -TRUE}', "");
    Expect(0, 120772, '\p{Is_Bidi_M= -TRUE}', "");
    Expect(1, 120772, '\p{^Is_Bidi_M= -TRUE}', "");
    Expect(1, 120772, '\P{Is_Bidi_M= -TRUE}', "");
    Expect(0, 120772, '\P{^Is_Bidi_M= -TRUE}', "");
    Error('\p{block}');
    Error('\P{block}');
    Error('\p{blk}');
    Error('\P{blk}');
    Error('\p{Block=:=	-Adlam}');
    Error('\P{Block=:=	-Adlam}');
    Expect(1, 125279, '\p{Block=:\AAdlam\z:}', "");;
    Expect(0, 125280, '\p{Block=:\AAdlam\z:}', "");;
    Expect(1, 125279, '\p{Block=adlam}', "");
    Expect(0, 125279, '\p{^Block=adlam}', "");
    Expect(0, 125279, '\P{Block=adlam}', "");
    Expect(1, 125279, '\P{^Block=adlam}', "");
    Expect(0, 125280, '\p{Block=adlam}', "");
    Expect(1, 125280, '\p{^Block=adlam}', "");
    Expect(1, 125280, '\P{Block=adlam}', "");
    Expect(0, 125280, '\P{^Block=adlam}', "");
    Expect(1, 125279, '\p{Block=:\Aadlam\z:}', "");;
    Expect(0, 125280, '\p{Block=:\Aadlam\z:}', "");;
    Expect(1, 125279, '\p{Block=	-ADLAM}', "");
    Expect(0, 125279, '\p{^Block=	-ADLAM}', "");
    Expect(0, 125279, '\P{Block=	-ADLAM}', "");
    Expect(1, 125279, '\P{^Block=	-ADLAM}', "");
    Expect(0, 125280, '\p{Block=	-ADLAM}', "");
    Expect(1, 125280, '\p{^Block=	-ADLAM}', "");
    Expect(1, 125280, '\P{Block=	-ADLAM}', "");
    Expect(0, 125280, '\P{^Block=	-ADLAM}', "");
    Error('\p{Blk=:=_	ADLAM}');
    Error('\P{Blk=:=_	ADLAM}');
    Expect(1, 125279, '\p{Blk=:\AAdlam\z:}', "");;
    Expect(0, 125280, '\p{Blk=:\AAdlam\z:}', "");;
    Expect(1, 125279, '\p{Blk=adlam}', "");
    Expect(0, 125279, '\p{^Blk=adlam}', "");
    Expect(0, 125279, '\P{Blk=adlam}', "");
    Expect(1, 125279, '\P{^Blk=adlam}', "");
    Expect(0, 125280, '\p{Blk=adlam}', "");
    Expect(1, 125280, '\p{^Blk=adlam}', "");
    Expect(1, 125280, '\P{Blk=adlam}', "");
    Expect(0, 125280, '\P{^Blk=adlam}', "");
    Expect(1, 125279, '\p{Blk=:\Aadlam\z:}', "");;
    Expect(0, 125280, '\p{Blk=:\Aadlam\z:}', "");;
    Expect(1, 125279, '\p{Blk= 	Adlam}', "");
    Expect(0, 125279, '\p{^Blk= 	Adlam}', "");
    Expect(0, 125279, '\P{Blk= 	Adlam}', "");
    Expect(1, 125279, '\P{^Blk= 	Adlam}', "");
    Expect(0, 125280, '\p{Blk= 	Adlam}', "");
    Expect(1, 125280, '\p{^Blk= 	Adlam}', "");
    Expect(1, 125280, '\P{Blk= 	Adlam}', "");
    Expect(0, 125280, '\P{^Blk= 	Adlam}', "");
    Error('\p{Is_Block:	_-ADLAM/a/}');
    Error('\P{Is_Block:	_-ADLAM/a/}');
    Expect(1, 125279, '\p{Is_Block=adlam}', "");
    Expect(0, 125279, '\p{^Is_Block=adlam}', "");
    Expect(0, 125279, '\P{Is_Block=adlam}', "");
    Expect(1, 125279, '\P{^Is_Block=adlam}', "");
    Expect(0, 125280, '\p{Is_Block=adlam}', "");
    Expect(1, 125280, '\p{^Is_Block=adlam}', "");
    Expect(1, 125280, '\P{Is_Block=adlam}', "");
    Expect(0, 125280, '\P{^Is_Block=adlam}', "");
    Expect(1, 125279, '\p{Is_Block=__Adlam}', "");
    Expect(0, 125279, '\p{^Is_Block=__Adlam}', "");
    Expect(0, 125279, '\P{Is_Block=__Adlam}', "");
    Expect(1, 125279, '\P{^Is_Block=__Adlam}', "");
    Expect(0, 125280, '\p{Is_Block=__Adlam}', "");
    Expect(1, 125280, '\p{^Is_Block=__Adlam}', "");
    Expect(1, 125280, '\P{Is_Block=__Adlam}', "");
    Expect(0, 125280, '\P{^Is_Block=__Adlam}', "");
    Error('\p{Is_Blk=- adlam/a/}');
    Error('\P{Is_Blk=- adlam/a/}');
    Expect(1, 125279, '\p{Is_Blk=adlam}', "");
    Expect(0, 125279, '\p{^Is_Blk=adlam}', "");
    Expect(0, 125279, '\P{Is_Blk=adlam}', "");
    Expect(1, 125279, '\P{^Is_Blk=adlam}', "");
    Expect(0, 125280, '\p{Is_Blk=adlam}', "");
    Expect(1, 125280, '\p{^Is_Blk=adlam}', "");
    Expect(1, 125280, '\P{Is_Blk=adlam}', "");
    Expect(0, 125280, '\P{^Is_Blk=adlam}', "");
    Expect(1, 125279, '\p{Is_Blk=-_ADLAM}', "");
    Expect(0, 125279, '\p{^Is_Blk=-_ADLAM}', "");
    Expect(0, 125279, '\P{Is_Blk=-_ADLAM}', "");
    Expect(1, 125279, '\P{^Is_Blk=-_ADLAM}', "");
    Expect(0, 125280, '\p{Is_Blk=-_ADLAM}', "");
    Expect(1, 125280, '\p{^Is_Blk=-_ADLAM}', "");
    Expect(1, 125280, '\P{Is_Blk=-_ADLAM}', "");
    Expect(0, 125280, '\P{^Is_Blk=-_ADLAM}', "");
    Error('\p{Block=:=Aegean_numbers}');
    Error('\P{Block=:=Aegean_numbers}');
    Expect(1, 65855, '\p{Block=:\AAegean_Numbers\z:}', "");;
    Expect(0, 65856, '\p{Block=:\AAegean_Numbers\z:}', "");;
    Expect(1, 65855, '\p{Block=aegeannumbers}', "");
    Expect(0, 65855, '\p{^Block=aegeannumbers}', "");
    Expect(0, 65855, '\P{Block=aegeannumbers}', "");
    Expect(1, 65855, '\P{^Block=aegeannumbers}', "");
    Expect(0, 65856, '\p{Block=aegeannumbers}', "");
    Expect(1, 65856, '\p{^Block=aegeannumbers}', "");
    Expect(1, 65856, '\P{Block=aegeannumbers}', "");
    Expect(0, 65856, '\P{^Block=aegeannumbers}', "");
    Expect(1, 65855, '\p{Block=:\Aaegeannumbers\z:}', "");;
    Expect(0, 65856, '\p{Block=:\Aaegeannumbers\z:}', "");;
    Expect(1, 65855, '\p{Block=_-Aegean_Numbers}', "");
    Expect(0, 65855, '\p{^Block=_-Aegean_Numbers}', "");
    Expect(0, 65855, '\P{Block=_-Aegean_Numbers}', "");
    Expect(1, 65855, '\P{^Block=_-Aegean_Numbers}', "");
    Expect(0, 65856, '\p{Block=_-Aegean_Numbers}', "");
    Expect(1, 65856, '\p{^Block=_-Aegean_Numbers}', "");
    Expect(1, 65856, '\P{Block=_-Aegean_Numbers}', "");
    Expect(0, 65856, '\P{^Block=_-Aegean_Numbers}', "");
    Error('\p{Blk=/a/AEGEAN_NUMBERS}');
    Error('\P{Blk=/a/AEGEAN_NUMBERS}');
    Expect(1, 65855, '\p{Blk=:\AAegean_Numbers\z:}', "");;
    Expect(0, 65856, '\p{Blk=:\AAegean_Numbers\z:}', "");;
    Expect(1, 65855, '\p{Blk=aegeannumbers}', "");
    Expect(0, 65855, '\p{^Blk=aegeannumbers}', "");
    Expect(0, 65855, '\P{Blk=aegeannumbers}', "");
    Expect(1, 65855, '\P{^Blk=aegeannumbers}', "");
    Expect(0, 65856, '\p{Blk=aegeannumbers}', "");
    Expect(1, 65856, '\p{^Blk=aegeannumbers}', "");
    Expect(1, 65856, '\P{Blk=aegeannumbers}', "");
    Expect(0, 65856, '\P{^Blk=aegeannumbers}', "");
    Expect(1, 65855, '\p{Blk=:\Aaegeannumbers\z:}', "");;
    Expect(0, 65856, '\p{Blk=:\Aaegeannumbers\z:}', "");;
    Expect(1, 65855, '\p{Blk=-	AEGEAN_numbers}', "");
    Expect(0, 65855, '\p{^Blk=-	AEGEAN_numbers}', "");
    Expect(0, 65855, '\P{Blk=-	AEGEAN_numbers}', "");
    Expect(1, 65855, '\P{^Blk=-	AEGEAN_numbers}', "");
    Expect(0, 65856, '\p{Blk=-	AEGEAN_numbers}', "");
    Expect(1, 65856, '\p{^Blk=-	AEGEAN_numbers}', "");
    Expect(1, 65856, '\P{Blk=-	AEGEAN_numbers}', "");
    Expect(0, 65856, '\P{^Blk=-	AEGEAN_numbers}', "");
    Error('\p{Is_Block=/a/	 aegean_numbers}');
    Error('\P{Is_Block=/a/	 aegean_numbers}');
    Expect(1, 65855, '\p{Is_Block=aegeannumbers}', "");
    Expect(0, 65855, '\p{^Is_Block=aegeannumbers}', "");
    Expect(0, 65855, '\P{Is_Block=aegeannumbers}', "");
    Expect(1, 65855, '\P{^Is_Block=aegeannumbers}', "");
    Expect(0, 65856, '\p{Is_Block=aegeannumbers}', "");
    Expect(1, 65856, '\p{^Is_Block=aegeannumbers}', "");
    Expect(1, 65856, '\P{Is_Block=aegeannumbers}', "");
    Expect(0, 65856, '\P{^Is_Block=aegeannumbers}', "");
    Expect(1, 65855, '\p{Is_Block=	 Aegean_Numbers}', "");
    Expect(0, 65855, '\p{^Is_Block=	 Aegean_Numbers}', "");
    Expect(0, 65855, '\P{Is_Block=	 Aegean_Numbers}', "");
    Expect(1, 65855, '\P{^Is_Block=	 Aegean_Numbers}', "");
    Expect(0, 65856, '\p{Is_Block=	 Aegean_Numbers}', "");
    Expect(1, 65856, '\p{^Is_Block=	 Aegean_Numbers}', "");
    Expect(1, 65856, '\P{Is_Block=	 Aegean_Numbers}', "");
    Expect(0, 65856, '\P{^Is_Block=	 Aegean_Numbers}', "");
    Error('\p{Is_Blk=-aegean_Numbers:=}');
    Error('\P{Is_Blk=-aegean_Numbers:=}');
    Expect(1, 65855, '\p{Is_Blk=aegeannumbers}', "");
    Expect(0, 65855, '\p{^Is_Blk=aegeannumbers}', "");
    Expect(0, 65855, '\P{Is_Blk=aegeannumbers}', "");
    Expect(1, 65855, '\P{^Is_Blk=aegeannumbers}', "");
    Expect(0, 65856, '\p{Is_Blk=aegeannumbers}', "");
    Expect(1, 65856, '\p{^Is_Blk=aegeannumbers}', "");
    Expect(1, 65856, '\P{Is_Blk=aegeannumbers}', "");
    Expect(0, 65856, '\P{^Is_Blk=aegeannumbers}', "");
    Expect(1, 65855, '\p{Is_Blk=	_Aegean_numbers}', "");
    Expect(0, 65855, '\p{^Is_Blk=	_Aegean_numbers}', "");
    Expect(0, 65855, '\P{Is_Blk=	_Aegean_numbers}', "");
    Expect(1, 65855, '\P{^Is_Blk=	_Aegean_numbers}', "");
    Expect(0, 65856, '\p{Is_Blk=	_Aegean_numbers}', "");
    Expect(1, 65856, '\p{^Is_Blk=	_Aegean_numbers}', "");
    Expect(1, 65856, '\P{Is_Blk=	_Aegean_numbers}', "");
    Expect(0, 65856, '\P{^Is_Blk=	_Aegean_numbers}', "");
    Error('\p{Block=_/a/ahom}');
    Error('\P{Block=_/a/ahom}');
    Expect(1, 71503, '\p{Block=:\AAhom\z:}', "");;
    Expect(0, 71504, '\p{Block=:\AAhom\z:}', "");;
    Expect(1, 71503, '\p{Block=ahom}', "");
    Expect(0, 71503, '\p{^Block=ahom}', "");
    Expect(0, 71503, '\P{Block=ahom}', "");
    Expect(1, 71503, '\P{^Block=ahom}', "");
    Expect(0, 71504, '\p{Block=ahom}', "");
    Expect(1, 71504, '\p{^Block=ahom}', "");
    Expect(1, 71504, '\P{Block=ahom}', "");
    Expect(0, 71504, '\P{^Block=ahom}', "");
    Expect(1, 71503, '\p{Block=:\Aahom\z:}', "");;
    Expect(0, 71504, '\p{Block=:\Aahom\z:}', "");;
    Expect(1, 71503, '\p{Block=Ahom}', "");
    Expect(0, 71503, '\p{^Block=Ahom}', "");
    Expect(0, 71503, '\P{Block=Ahom}', "");
    Expect(1, 71503, '\P{^Block=Ahom}', "");
    Expect(0, 71504, '\p{Block=Ahom}', "");
    Expect(1, 71504, '\p{^Block=Ahom}', "");
    Expect(1, 71504, '\P{Block=Ahom}', "");
    Expect(0, 71504, '\P{^Block=Ahom}', "");
    Error('\p{Blk:   _/a/ahom}');
    Error('\P{Blk:   _/a/ahom}');
    Expect(1, 71503, '\p{Blk=:\AAhom\z:}', "");;
    Expect(0, 71504, '\p{Blk=:\AAhom\z:}', "");;
    Expect(1, 71503, '\p{Blk=ahom}', "");
    Expect(0, 71503, '\p{^Blk=ahom}', "");
    Expect(0, 71503, '\P{Blk=ahom}', "");
    Expect(1, 71503, '\P{^Blk=ahom}', "");
    Expect(0, 71504, '\p{Blk=ahom}', "");
    Expect(1, 71504, '\p{^Blk=ahom}', "");
    Expect(1, 71504, '\P{Blk=ahom}', "");
    Expect(0, 71504, '\P{^Blk=ahom}', "");
    Expect(1, 71503, '\p{Blk=:\Aahom\z:}', "");;
    Expect(0, 71504, '\p{Blk=:\Aahom\z:}', "");;
    Expect(1, 71503, '\p{Blk= -ahom}', "");
    Expect(0, 71503, '\p{^Blk= -ahom}', "");
    Expect(0, 71503, '\P{Blk= -ahom}', "");
    Expect(1, 71503, '\P{^Blk= -ahom}', "");
    Expect(0, 71504, '\p{Blk= -ahom}', "");
    Expect(1, 71504, '\p{^Blk= -ahom}', "");
    Expect(1, 71504, '\P{Blk= -ahom}', "");
    Expect(0, 71504, '\P{^Blk= -ahom}', "");
    Error('\p{Is_Block=/a/--ahom}');
    Error('\P{Is_Block=/a/--ahom}');
    Expect(1, 71503, '\p{Is_Block=ahom}', "");
    Expect(0, 71503, '\p{^Is_Block=ahom}', "");
    Expect(0, 71503, '\P{Is_Block=ahom}', "");
    Expect(1, 71503, '\P{^Is_Block=ahom}', "");
    Expect(0, 71504, '\p{Is_Block=ahom}', "");
    Expect(1, 71504, '\p{^Is_Block=ahom}', "");
    Expect(1, 71504, '\P{Is_Block=ahom}', "");
    Expect(0, 71504, '\P{^Is_Block=ahom}', "");
    Expect(1, 71503, '\p{Is_Block= ahom}', "");
    Expect(0, 71503, '\p{^Is_Block= ahom}', "");
    Expect(0, 71503, '\P{Is_Block= ahom}', "");
    Expect(1, 71503, '\P{^Is_Block= ahom}', "");
    Expect(0, 71504, '\p{Is_Block= ahom}', "");
    Expect(1, 71504, '\p{^Is_Block= ahom}', "");
    Expect(1, 71504, '\P{Is_Block= ahom}', "");
    Expect(0, 71504, '\P{^Is_Block= ahom}', "");
    Error('\p{Is_Blk:		/a/AHOM}');
    Error('\P{Is_Blk:		/a/AHOM}');
    Expect(1, 71503, '\p{Is_Blk:ahom}', "");
    Expect(0, 71503, '\p{^Is_Blk:ahom}', "");
    Expect(0, 71503, '\P{Is_Blk:ahom}', "");
    Expect(1, 71503, '\P{^Is_Blk:ahom}', "");
    Expect(0, 71504, '\p{Is_Blk:ahom}', "");
    Expect(1, 71504, '\p{^Is_Blk:ahom}', "");
    Expect(1, 71504, '\P{Is_Blk:ahom}', "");
    Expect(0, 71504, '\P{^Is_Blk:ahom}', "");
    Expect(1, 71503, '\p{Is_Blk= ahom}', "");
    Expect(0, 71503, '\p{^Is_Blk= ahom}', "");
    Expect(0, 71503, '\P{Is_Blk= ahom}', "");
    Expect(1, 71503, '\P{^Is_Blk= ahom}', "");
    Expect(0, 71504, '\p{Is_Blk= ahom}', "");
    Expect(1, 71504, '\p{^Is_Blk= ahom}', "");
    Expect(1, 71504, '\P{Is_Blk= ahom}', "");
    Expect(0, 71504, '\P{^Is_Blk= ahom}', "");
    Error('\p{Block:   	:=alchemical_Symbols}');
    Error('\P{Block:   	:=alchemical_Symbols}');
    Expect(1, 128895, '\p{Block=:\AAlchemical_Symbols\z:}', "");;
    Expect(0, 128896, '\p{Block=:\AAlchemical_Symbols\z:}', "");;
    Expect(1, 128895, '\p{Block=alchemicalsymbols}', "");
    Expect(0, 128895, '\p{^Block=alchemicalsymbols}', "");
    Expect(0, 128895, '\P{Block=alchemicalsymbols}', "");
    Expect(1, 128895, '\P{^Block=alchemicalsymbols}', "");
    Expect(0, 128896, '\p{Block=alchemicalsymbols}', "");
    Expect(1, 128896, '\p{^Block=alchemicalsymbols}', "");
    Expect(1, 128896, '\P{Block=alchemicalsymbols}', "");
    Expect(0, 128896, '\P{^Block=alchemicalsymbols}', "");
    Expect(1, 128895, '\p{Block=:\Aalchemicalsymbols\z:}', "");;
    Expect(0, 128896, '\p{Block=:\Aalchemicalsymbols\z:}', "");;
    Expect(1, 128895, '\p{Block=_-ALCHEMICAL_Symbols}', "");
    Expect(0, 128895, '\p{^Block=_-ALCHEMICAL_Symbols}', "");
    Expect(0, 128895, '\P{Block=_-ALCHEMICAL_Symbols}', "");
    Expect(1, 128895, '\P{^Block=_-ALCHEMICAL_Symbols}', "");
    Expect(0, 128896, '\p{Block=_-ALCHEMICAL_Symbols}', "");
    Expect(1, 128896, '\p{^Block=_-ALCHEMICAL_Symbols}', "");
    Expect(1, 128896, '\P{Block=_-ALCHEMICAL_Symbols}', "");
    Expect(0, 128896, '\P{^Block=_-ALCHEMICAL_Symbols}', "");
    Error('\p{Blk=:=ALCHEMICAL}');
    Error('\P{Blk=:=ALCHEMICAL}');
    Expect(1, 128895, '\p{Blk=:\AAlchemical\z:}', "");;
    Expect(0, 128896, '\p{Blk=:\AAlchemical\z:}', "");;
    Expect(1, 128895, '\p{Blk: alchemical}', "");
    Expect(0, 128895, '\p{^Blk: alchemical}', "");
    Expect(0, 128895, '\P{Blk: alchemical}', "");
    Expect(1, 128895, '\P{^Blk: alchemical}', "");
    Expect(0, 128896, '\p{Blk: alchemical}', "");
    Expect(1, 128896, '\p{^Blk: alchemical}', "");
    Expect(1, 128896, '\P{Blk: alchemical}', "");
    Expect(0, 128896, '\P{^Blk: alchemical}', "");
    Expect(1, 128895, '\p{Blk=:\Aalchemical\z:}', "");;
    Expect(0, 128896, '\p{Blk=:\Aalchemical\z:}', "");;
    Expect(1, 128895, '\p{Blk=--Alchemical}', "");
    Expect(0, 128895, '\p{^Blk=--Alchemical}', "");
    Expect(0, 128895, '\P{Blk=--Alchemical}', "");
    Expect(1, 128895, '\P{^Blk=--Alchemical}', "");
    Expect(0, 128896, '\p{Blk=--Alchemical}', "");
    Expect(1, 128896, '\p{^Blk=--Alchemical}', "");
    Expect(1, 128896, '\P{Blk=--Alchemical}', "");
    Expect(0, 128896, '\P{^Blk=--Alchemical}', "");
    Error('\p{Is_Block=		Alchemical_Symbols/a/}');
    Error('\P{Is_Block=		Alchemical_Symbols/a/}');
    Expect(1, 128895, '\p{Is_Block=alchemicalsymbols}', "");
    Expect(0, 128895, '\p{^Is_Block=alchemicalsymbols}', "");
    Expect(0, 128895, '\P{Is_Block=alchemicalsymbols}', "");
    Expect(1, 128895, '\P{^Is_Block=alchemicalsymbols}', "");
    Expect(0, 128896, '\p{Is_Block=alchemicalsymbols}', "");
    Expect(1, 128896, '\p{^Is_Block=alchemicalsymbols}', "");
    Expect(1, 128896, '\P{Is_Block=alchemicalsymbols}', "");
    Expect(0, 128896, '\P{^Is_Block=alchemicalsymbols}', "");
    Expect(1, 128895, '\p{Is_Block=_Alchemical_Symbols}', "");
    Expect(0, 128895, '\p{^Is_Block=_Alchemical_Symbols}', "");
    Expect(0, 128895, '\P{Is_Block=_Alchemical_Symbols}', "");
    Expect(1, 128895, '\P{^Is_Block=_Alchemical_Symbols}', "");
    Expect(0, 128896, '\p{Is_Block=_Alchemical_Symbols}', "");
    Expect(1, 128896, '\p{^Is_Block=_Alchemical_Symbols}', "");
    Expect(1, 128896, '\P{Is_Block=_Alchemical_Symbols}', "");
    Expect(0, 128896, '\P{^Is_Block=_Alchemical_Symbols}', "");
    Error('\p{Is_Blk=--Alchemical/a/}');
    Error('\P{Is_Blk=--Alchemical/a/}');
    Expect(1, 128895, '\p{Is_Blk:alchemical}', "");
    Expect(0, 128895, '\p{^Is_Blk:alchemical}', "");
    Expect(0, 128895, '\P{Is_Blk:alchemical}', "");
    Expect(1, 128895, '\P{^Is_Blk:alchemical}', "");
    Expect(0, 128896, '\p{Is_Blk:alchemical}', "");
    Expect(1, 128896, '\p{^Is_Blk:alchemical}', "");
    Expect(1, 128896, '\P{Is_Blk:alchemical}', "");
    Expect(0, 128896, '\P{^Is_Blk:alchemical}', "");
    Expect(1, 128895, '\p{Is_Blk=	 ALCHEMICAL}', "");
    Expect(0, 128895, '\p{^Is_Blk=	 ALCHEMICAL}', "");
    Expect(0, 128895, '\P{Is_Blk=	 ALCHEMICAL}', "");
    Expect(1, 128895, '\P{^Is_Blk=	 ALCHEMICAL}', "");
    Expect(0, 128896, '\p{Is_Blk=	 ALCHEMICAL}', "");
    Expect(1, 128896, '\p{^Is_Blk=	 ALCHEMICAL}', "");
    Expect(1, 128896, '\P{Is_Blk=	 ALCHEMICAL}', "");
    Expect(0, 128896, '\P{^Is_Blk=	 ALCHEMICAL}', "");
    Error('\p{Block=		Alphabetic_presentation_FORMS:=}');
    Error('\P{Block=		Alphabetic_presentation_FORMS:=}');
    Expect(1, 64335, '\p{Block=:\AAlphabetic_Presentation_Forms\z:}', "");;
    Expect(0, 64336, '\p{Block=:\AAlphabetic_Presentation_Forms\z:}', "");;
    Expect(1, 64335, '\p{Block=alphabeticpresentationforms}', "");
    Expect(0, 64335, '\p{^Block=alphabeticpresentationforms}', "");
    Expect(0, 64335, '\P{Block=alphabeticpresentationforms}', "");
    Expect(1, 64335, '\P{^Block=alphabeticpresentationforms}', "");
    Expect(0, 64336, '\p{Block=alphabeticpresentationforms}', "");
    Expect(1, 64336, '\p{^Block=alphabeticpresentationforms}', "");
    Expect(1, 64336, '\P{Block=alphabeticpresentationforms}', "");
    Expect(0, 64336, '\P{^Block=alphabeticpresentationforms}', "");
    Expect(1, 64335, '\p{Block=:\Aalphabeticpresentationforms\z:}', "");;
    Expect(0, 64336, '\p{Block=:\Aalphabeticpresentationforms\z:}', "");;
    Expect(1, 64335, '\p{Block=-	alphabetic_Presentation_forms}', "");
    Expect(0, 64335, '\p{^Block=-	alphabetic_Presentation_forms}', "");
    Expect(0, 64335, '\P{Block=-	alphabetic_Presentation_forms}', "");
    Expect(1, 64335, '\P{^Block=-	alphabetic_Presentation_forms}', "");
    Expect(0, 64336, '\p{Block=-	alphabetic_Presentation_forms}', "");
    Expect(1, 64336, '\p{^Block=-	alphabetic_Presentation_forms}', "");
    Expect(1, 64336, '\P{Block=-	alphabetic_Presentation_forms}', "");
    Expect(0, 64336, '\P{^Block=-	alphabetic_Presentation_forms}', "");
    Error('\p{Blk=/a/Alphabetic_PF}');
    Error('\P{Blk=/a/Alphabetic_PF}');
    Expect(1, 64335, '\p{Blk=:\AAlphabetic_PF\z:}', "");;
    Expect(0, 64336, '\p{Blk=:\AAlphabetic_PF\z:}', "");;
    Expect(1, 64335, '\p{Blk=alphabeticpf}', "");
    Expect(0, 64335, '\p{^Blk=alphabeticpf}', "");
    Expect(0, 64335, '\P{Blk=alphabeticpf}', "");
    Expect(1, 64335, '\P{^Blk=alphabeticpf}', "");
    Expect(0, 64336, '\p{Blk=alphabeticpf}', "");
    Expect(1, 64336, '\p{^Blk=alphabeticpf}', "");
    Expect(1, 64336, '\P{Blk=alphabeticpf}', "");
    Expect(0, 64336, '\P{^Blk=alphabeticpf}', "");
    Expect(1, 64335, '\p{Blk=:\Aalphabeticpf\z:}', "");;
    Expect(0, 64336, '\p{Blk=:\Aalphabeticpf\z:}', "");;
    Expect(1, 64335, '\p{Blk=	_Alphabetic_PF}', "");
    Expect(0, 64335, '\p{^Blk=	_Alphabetic_PF}', "");
    Expect(0, 64335, '\P{Blk=	_Alphabetic_PF}', "");
    Expect(1, 64335, '\P{^Blk=	_Alphabetic_PF}', "");
    Expect(0, 64336, '\p{Blk=	_Alphabetic_PF}', "");
    Expect(1, 64336, '\p{^Blk=	_Alphabetic_PF}', "");
    Expect(1, 64336, '\P{Blk=	_Alphabetic_PF}', "");
    Expect(0, 64336, '\P{^Blk=	_Alphabetic_PF}', "");
    Error('\p{Is_Block::=	Alphabetic_Presentation_Forms}');
    Error('\P{Is_Block::=	Alphabetic_Presentation_Forms}');
    Expect(1, 64335, '\p{Is_Block=alphabeticpresentationforms}', "");
    Expect(0, 64335, '\p{^Is_Block=alphabeticpresentationforms}', "");
    Expect(0, 64335, '\P{Is_Block=alphabeticpresentationforms}', "");
    Expect(1, 64335, '\P{^Is_Block=alphabeticpresentationforms}', "");
    Expect(0, 64336, '\p{Is_Block=alphabeticpresentationforms}', "");
    Expect(1, 64336, '\p{^Is_Block=alphabeticpresentationforms}', "");
    Expect(1, 64336, '\P{Is_Block=alphabeticpresentationforms}', "");
    Expect(0, 64336, '\P{^Is_Block=alphabeticpresentationforms}', "");
    Expect(1, 64335, '\p{Is_Block=	ALPHABETIC_PRESENTATION_Forms}', "");
    Expect(0, 64335, '\p{^Is_Block=	ALPHABETIC_PRESENTATION_Forms}', "");
    Expect(0, 64335, '\P{Is_Block=	ALPHABETIC_PRESENTATION_Forms}', "");
    Expect(1, 64335, '\P{^Is_Block=	ALPHABETIC_PRESENTATION_Forms}', "");
    Expect(0, 64336, '\p{Is_Block=	ALPHABETIC_PRESENTATION_Forms}', "");
    Expect(1, 64336, '\p{^Is_Block=	ALPHABETIC_PRESENTATION_Forms}', "");
    Expect(1, 64336, '\P{Is_Block=	ALPHABETIC_PRESENTATION_Forms}', "");
    Expect(0, 64336, '\P{^Is_Block=	ALPHABETIC_PRESENTATION_Forms}', "");
    Error('\p{Is_Blk:	:=ALPHABETIC_PF}');
    Error('\P{Is_Blk:	:=ALPHABETIC_PF}');
    Expect(1, 64335, '\p{Is_Blk=alphabeticpf}', "");
    Expect(0, 64335, '\p{^Is_Blk=alphabeticpf}', "");
    Expect(0, 64335, '\P{Is_Blk=alphabeticpf}', "");
    Expect(1, 64335, '\P{^Is_Blk=alphabeticpf}', "");
    Expect(0, 64336, '\p{Is_Blk=alphabeticpf}', "");
    Expect(1, 64336, '\p{^Is_Blk=alphabeticpf}', "");
    Expect(1, 64336, '\P{Is_Blk=alphabeticpf}', "");
    Expect(0, 64336, '\P{^Is_Blk=alphabeticpf}', "");
    Expect(1, 64335, '\p{Is_Blk=	Alphabetic_PF}', "");
    Expect(0, 64335, '\p{^Is_Blk=	Alphabetic_PF}', "");
    Expect(0, 64335, '\P{Is_Blk=	Alphabetic_PF}', "");
    Expect(1, 64335, '\P{^Is_Blk=	Alphabetic_PF}', "");
    Expect(0, 64336, '\p{Is_Blk=	Alphabetic_PF}', "");
    Expect(1, 64336, '\p{^Is_Blk=	Alphabetic_PF}', "");
    Expect(1, 64336, '\P{Is_Blk=	Alphabetic_PF}', "");
    Expect(0, 64336, '\P{^Is_Blk=	Alphabetic_PF}', "");
    Error('\p{Block=	Anatolian_Hieroglyphs:=}');
    Error('\P{Block=	Anatolian_Hieroglyphs:=}');
    Expect(1, 83583, '\p{Block=:\AAnatolian_Hieroglyphs\z:}', "");;
    Expect(0, 83584, '\p{Block=:\AAnatolian_Hieroglyphs\z:}', "");;
    Expect(1, 83583, '\p{Block=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\p{^Block=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\P{Block=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\P{^Block=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\p{Block=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\p{^Block=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\P{Block=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\P{^Block=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\p{Block=:\Aanatolianhieroglyphs\z:}', "");;
    Expect(0, 83584, '\p{Block=:\Aanatolianhieroglyphs\z:}', "");;
    Expect(1, 83583, '\p{Block=		Anatolian_Hieroglyphs}', "");
    Expect(0, 83583, '\p{^Block=		Anatolian_Hieroglyphs}', "");
    Expect(0, 83583, '\P{Block=		Anatolian_Hieroglyphs}', "");
    Expect(1, 83583, '\P{^Block=		Anatolian_Hieroglyphs}', "");
    Expect(0, 83584, '\p{Block=		Anatolian_Hieroglyphs}', "");
    Expect(1, 83584, '\p{^Block=		Anatolian_Hieroglyphs}', "");
    Expect(1, 83584, '\P{Block=		Anatolian_Hieroglyphs}', "");
    Expect(0, 83584, '\P{^Block=		Anatolian_Hieroglyphs}', "");
    Error('\p{Blk=	-ANATOLIAN_Hieroglyphs:=}');
    Error('\P{Blk=	-ANATOLIAN_Hieroglyphs:=}');
    Expect(1, 83583, '\p{Blk=:\AAnatolian_Hieroglyphs\z:}', "");;
    Expect(0, 83584, '\p{Blk=:\AAnatolian_Hieroglyphs\z:}', "");;
    Expect(1, 83583, '\p{Blk=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\p{^Blk=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\P{Blk=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\P{^Blk=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\p{Blk=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\p{^Blk=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\P{Blk=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\P{^Blk=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\p{Blk=:\Aanatolianhieroglyphs\z:}', "");;
    Expect(0, 83584, '\p{Blk=:\Aanatolianhieroglyphs\z:}', "");;
    Expect(1, 83583, '\p{Blk=  ANATOLIAN_Hieroglyphs}', "");
    Expect(0, 83583, '\p{^Blk=  ANATOLIAN_Hieroglyphs}', "");
    Expect(0, 83583, '\P{Blk=  ANATOLIAN_Hieroglyphs}', "");
    Expect(1, 83583, '\P{^Blk=  ANATOLIAN_Hieroglyphs}', "");
    Expect(0, 83584, '\p{Blk=  ANATOLIAN_Hieroglyphs}', "");
    Expect(1, 83584, '\p{^Blk=  ANATOLIAN_Hieroglyphs}', "");
    Expect(1, 83584, '\P{Blk=  ANATOLIAN_Hieroglyphs}', "");
    Expect(0, 83584, '\P{^Blk=  ANATOLIAN_Hieroglyphs}', "");
    Error('\p{Is_Block=	-anatolian_Hieroglyphs/a/}');
    Error('\P{Is_Block=	-anatolian_Hieroglyphs/a/}');
    Expect(1, 83583, '\p{Is_Block:   anatolianhieroglyphs}', "");
    Expect(0, 83583, '\p{^Is_Block:   anatolianhieroglyphs}', "");
    Expect(0, 83583, '\P{Is_Block:   anatolianhieroglyphs}', "");
    Expect(1, 83583, '\P{^Is_Block:   anatolianhieroglyphs}', "");
    Expect(0, 83584, '\p{Is_Block:   anatolianhieroglyphs}', "");
    Expect(1, 83584, '\p{^Is_Block:   anatolianhieroglyphs}', "");
    Expect(1, 83584, '\P{Is_Block:   anatolianhieroglyphs}', "");
    Expect(0, 83584, '\P{^Is_Block:   anatolianhieroglyphs}', "");
    Expect(1, 83583, '\p{Is_Block=_Anatolian_hieroglyphs}', "");
    Expect(0, 83583, '\p{^Is_Block=_Anatolian_hieroglyphs}', "");
    Expect(0, 83583, '\P{Is_Block=_Anatolian_hieroglyphs}', "");
    Expect(1, 83583, '\P{^Is_Block=_Anatolian_hieroglyphs}', "");
    Expect(0, 83584, '\p{Is_Block=_Anatolian_hieroglyphs}', "");
    Expect(1, 83584, '\p{^Is_Block=_Anatolian_hieroglyphs}', "");
    Expect(1, 83584, '\P{Is_Block=_Anatolian_hieroglyphs}', "");
    Expect(0, 83584, '\P{^Is_Block=_Anatolian_hieroglyphs}', "");
    Error('\p{Is_Blk=/a/Anatolian_HIEROGLYPHS}');
    Error('\P{Is_Blk=/a/Anatolian_HIEROGLYPHS}');
    Expect(1, 83583, '\p{Is_Blk=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\p{^Is_Blk=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\P{Is_Blk=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\P{^Is_Blk=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\p{Is_Blk=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\p{^Is_Blk=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\P{Is_Blk=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\P{^Is_Blk=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\p{Is_Blk: --Anatolian_hieroglyphs}', "");
    Expect(0, 83583, '\p{^Is_Blk: --Anatolian_hieroglyphs}', "");
    Expect(0, 83583, '\P{Is_Blk: --Anatolian_hieroglyphs}', "");
    Expect(1, 83583, '\P{^Is_Blk: --Anatolian_hieroglyphs}', "");
    Expect(0, 83584, '\p{Is_Blk: --Anatolian_hieroglyphs}', "");
    Expect(1, 83584, '\p{^Is_Blk: --Anatolian_hieroglyphs}', "");
    Expect(1, 83584, '\P{Is_Blk: --Anatolian_hieroglyphs}', "");
    Expect(0, 83584, '\P{^Is_Blk: --Anatolian_hieroglyphs}', "");
    Error('\p{Block=:=-	Ancient_GREEK_musical_NOTATION}');
    Error('\P{Block=:=-	Ancient_GREEK_musical_NOTATION}');
    Expect(1, 119375, '\p{Block=:\AAncient_Greek_Musical_Notation\z:}', "");;
    Expect(0, 119376, '\p{Block=:\AAncient_Greek_Musical_Notation\z:}', "");;
    Expect(1, 119375, '\p{Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119375, '\p{^Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119375, '\P{Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119375, '\P{^Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119376, '\p{Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119376, '\p{^Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119376, '\P{Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119376, '\P{^Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119375, '\p{Block=:\Aancientgreekmusicalnotation\z:}', "");;
    Expect(0, 119376, '\p{Block=:\Aancientgreekmusicalnotation\z:}', "");;
    Expect(1, 119375, '\p{Block= -ANCIENT_greek_Musical_NOTATION}', "");
    Expect(0, 119375, '\p{^Block= -ANCIENT_greek_Musical_NOTATION}', "");
    Expect(0, 119375, '\P{Block= -ANCIENT_greek_Musical_NOTATION}', "");
    Expect(1, 119375, '\P{^Block= -ANCIENT_greek_Musical_NOTATION}', "");
    Expect(0, 119376, '\p{Block= -ANCIENT_greek_Musical_NOTATION}', "");
    Expect(1, 119376, '\p{^Block= -ANCIENT_greek_Musical_NOTATION}', "");
    Expect(1, 119376, '\P{Block= -ANCIENT_greek_Musical_NOTATION}', "");
    Expect(0, 119376, '\P{^Block= -ANCIENT_greek_Musical_NOTATION}', "");
    Error('\p{Blk=	 Ancient_greek_music:=}');
    Error('\P{Blk=	 Ancient_greek_music:=}');
    Expect(1, 119375, '\p{Blk=:\AAncient_Greek_Music\z:}', "");;
    Expect(0, 119376, '\p{Blk=:\AAncient_Greek_Music\z:}', "");;
    Expect(1, 119375, '\p{Blk=ancientgreekmusic}', "");
    Expect(0, 119375, '\p{^Blk=ancientgreekmusic}', "");
    Expect(0, 119375, '\P{Blk=ancientgreekmusic}', "");
    Expect(1, 119375, '\P{^Blk=ancientgreekmusic}', "");
    Expect(0, 119376, '\p{Blk=ancientgreekmusic}', "");
    Expect(1, 119376, '\p{^Blk=ancientgreekmusic}', "");
    Expect(1, 119376, '\P{Blk=ancientgreekmusic}', "");
    Expect(0, 119376, '\P{^Blk=ancientgreekmusic}', "");
    Expect(1, 119375, '\p{Blk=:\Aancientgreekmusic\z:}', "");;
    Expect(0, 119376, '\p{Blk=:\Aancientgreekmusic\z:}', "");;
    Expect(1, 119375, '\p{Blk=-_Ancient_greek_MUSIC}', "");
    Expect(0, 119375, '\p{^Blk=-_Ancient_greek_MUSIC}', "");
    Expect(0, 119375, '\P{Blk=-_Ancient_greek_MUSIC}', "");
    Expect(1, 119375, '\P{^Blk=-_Ancient_greek_MUSIC}', "");
    Expect(0, 119376, '\p{Blk=-_Ancient_greek_MUSIC}', "");
    Expect(1, 119376, '\p{^Blk=-_Ancient_greek_MUSIC}', "");
    Expect(1, 119376, '\P{Blk=-_Ancient_greek_MUSIC}', "");
    Expect(0, 119376, '\P{^Blk=-_Ancient_greek_MUSIC}', "");
    Error('\p{Is_Block=--Ancient_Greek_musical_Notation:=}');
    Error('\P{Is_Block=--Ancient_Greek_musical_Notation:=}');
    Expect(1, 119375, '\p{Is_Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119375, '\p{^Is_Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119375, '\P{Is_Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119375, '\P{^Is_Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119376, '\p{Is_Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119376, '\p{^Is_Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119376, '\P{Is_Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119376, '\P{^Is_Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119375, '\p{Is_Block:   	_ancient_Greek_Musical_notation}', "");
    Expect(0, 119375, '\p{^Is_Block:   	_ancient_Greek_Musical_notation}', "");
    Expect(0, 119375, '\P{Is_Block:   	_ancient_Greek_Musical_notation}', "");
    Expect(1, 119375, '\P{^Is_Block:   	_ancient_Greek_Musical_notation}', "");
    Expect(0, 119376, '\p{Is_Block:   	_ancient_Greek_Musical_notation}', "");
    Expect(1, 119376, '\p{^Is_Block:   	_ancient_Greek_Musical_notation}', "");
    Expect(1, 119376, '\P{Is_Block:   	_ancient_Greek_Musical_notation}', "");
    Expect(0, 119376, '\P{^Is_Block:   	_ancient_Greek_Musical_notation}', "");
    Error('\p{Is_Blk=/a/ Ancient_Greek_Music}');
    Error('\P{Is_Blk=/a/ Ancient_Greek_Music}');
    Expect(1, 119375, '\p{Is_Blk=ancientgreekmusic}', "");
    Expect(0, 119375, '\p{^Is_Blk=ancientgreekmusic}', "");
    Expect(0, 119375, '\P{Is_Blk=ancientgreekmusic}', "");
    Expect(1, 119375, '\P{^Is_Blk=ancientgreekmusic}', "");
    Expect(0, 119376, '\p{Is_Blk=ancientgreekmusic}', "");
    Expect(1, 119376, '\p{^Is_Blk=ancientgreekmusic}', "");
    Expect(1, 119376, '\P{Is_Blk=ancientgreekmusic}', "");
    Expect(0, 119376, '\P{^Is_Blk=ancientgreekmusic}', "");
    Expect(1, 119375, '\p{Is_Blk=__Ancient_Greek_music}', "");
    Expect(0, 119375, '\p{^Is_Blk=__Ancient_Greek_music}', "");
    Expect(0, 119375, '\P{Is_Blk=__Ancient_Greek_music}', "");
    Expect(1, 119375, '\P{^Is_Blk=__Ancient_Greek_music}', "");
    Expect(0, 119376, '\p{Is_Blk=__Ancient_Greek_music}', "");
    Expect(1, 119376, '\p{^Is_Blk=__Ancient_Greek_music}', "");
    Expect(1, 119376, '\P{Is_Blk=__Ancient_Greek_music}', "");
    Expect(0, 119376, '\P{^Is_Blk=__Ancient_Greek_music}', "");
    Error('\p{Block=_:=ANCIENT_greek_NUMBERS}');
    Error('\P{Block=_:=ANCIENT_greek_NUMBERS}');
    Expect(1, 65935, '\p{Block=:\AAncient_Greek_Numbers\z:}', "");;
    Expect(0, 65936, '\p{Block=:\AAncient_Greek_Numbers\z:}', "");;
    Expect(1, 65935, '\p{Block=ancientgreeknumbers}', "");
    Expect(0, 65935, '\p{^Block=ancientgreeknumbers}', "");
    Expect(0, 65935, '\P{Block=ancientgreeknumbers}', "");
    Expect(1, 65935, '\P{^Block=ancientgreeknumbers}', "");
    Expect(0, 65936, '\p{Block=ancientgreeknumbers}', "");
    Expect(1, 65936, '\p{^Block=ancientgreeknumbers}', "");
    Expect(1, 65936, '\P{Block=ancientgreeknumbers}', "");
    Expect(0, 65936, '\P{^Block=ancientgreeknumbers}', "");
    Expect(1, 65935, '\p{Block=:\Aancientgreeknumbers\z:}', "");;
    Expect(0, 65936, '\p{Block=:\Aancientgreeknumbers\z:}', "");;
    Expect(1, 65935, '\p{Block=	ancient_GREEK_NUMBERS}', "");
    Expect(0, 65935, '\p{^Block=	ancient_GREEK_NUMBERS}', "");
    Expect(0, 65935, '\P{Block=	ancient_GREEK_NUMBERS}', "");
    Expect(1, 65935, '\P{^Block=	ancient_GREEK_NUMBERS}', "");
    Expect(0, 65936, '\p{Block=	ancient_GREEK_NUMBERS}', "");
    Expect(1, 65936, '\p{^Block=	ancient_GREEK_NUMBERS}', "");
    Expect(1, 65936, '\P{Block=	ancient_GREEK_NUMBERS}', "");
    Expect(0, 65936, '\P{^Block=	ancient_GREEK_NUMBERS}', "");
    Error('\p{Blk=_:=Ancient_GREEK_numbers}');
    Error('\P{Blk=_:=Ancient_GREEK_numbers}');
    Expect(1, 65935, '\p{Blk=:\AAncient_Greek_Numbers\z:}', "");;
    Expect(0, 65936, '\p{Blk=:\AAncient_Greek_Numbers\z:}', "");;
    Expect(1, 65935, '\p{Blk=ancientgreeknumbers}', "");
    Expect(0, 65935, '\p{^Blk=ancientgreeknumbers}', "");
    Expect(0, 65935, '\P{Blk=ancientgreeknumbers}', "");
    Expect(1, 65935, '\P{^Blk=ancientgreeknumbers}', "");
    Expect(0, 65936, '\p{Blk=ancientgreeknumbers}', "");
    Expect(1, 65936, '\p{^Blk=ancientgreeknumbers}', "");
    Expect(1, 65936, '\P{Blk=ancientgreeknumbers}', "");
    Expect(0, 65936, '\P{^Blk=ancientgreeknumbers}', "");
    Expect(1, 65935, '\p{Blk=:\Aancientgreeknumbers\z:}', "");;
    Expect(0, 65936, '\p{Blk=:\Aancientgreeknumbers\z:}', "");;
    Expect(1, 65935, '\p{Blk=	_Ancient_Greek_Numbers}', "");
    Expect(0, 65935, '\p{^Blk=	_Ancient_Greek_Numbers}', "");
    Expect(0, 65935, '\P{Blk=	_Ancient_Greek_Numbers}', "");
    Expect(1, 65935, '\P{^Blk=	_Ancient_Greek_Numbers}', "");
    Expect(0, 65936, '\p{Blk=	_Ancient_Greek_Numbers}', "");
    Expect(1, 65936, '\p{^Blk=	_Ancient_Greek_Numbers}', "");
    Expect(1, 65936, '\P{Blk=	_Ancient_Greek_Numbers}', "");
    Expect(0, 65936, '\P{^Blk=	_Ancient_Greek_Numbers}', "");
    Error('\p{Is_Block= /a/ANCIENT_Greek_numbers}');
    Error('\P{Is_Block= /a/ANCIENT_Greek_numbers}');
    Expect(1, 65935, '\p{Is_Block=ancientgreeknumbers}', "");
    Expect(0, 65935, '\p{^Is_Block=ancientgreeknumbers}', "");
    Expect(0, 65935, '\P{Is_Block=ancientgreeknumbers}', "");
    Expect(1, 65935, '\P{^Is_Block=ancientgreeknumbers}', "");
    Expect(0, 65936, '\p{Is_Block=ancientgreeknumbers}', "");
    Expect(1, 65936, '\p{^Is_Block=ancientgreeknumbers}', "");
    Expect(1, 65936, '\P{Is_Block=ancientgreeknumbers}', "");
    Expect(0, 65936, '\P{^Is_Block=ancientgreeknumbers}', "");
    Expect(1, 65935, '\p{Is_Block= Ancient_GREEK_Numbers}', "");
    Expect(0, 65935, '\p{^Is_Block= Ancient_GREEK_Numbers}', "");
    Expect(0, 65935, '\P{Is_Block= Ancient_GREEK_Numbers}', "");
    Expect(1, 65935, '\P{^Is_Block= Ancient_GREEK_Numbers}', "");
    Expect(0, 65936, '\p{Is_Block= Ancient_GREEK_Numbers}', "");
    Expect(1, 65936, '\p{^Is_Block= Ancient_GREEK_Numbers}', "");
    Expect(1, 65936, '\P{Is_Block= Ancient_GREEK_Numbers}', "");
    Expect(0, 65936, '\P{^Is_Block= Ancient_GREEK_Numbers}', "");
    Error('\p{Is_Blk=	 Ancient_Greek_Numbers:=}');
    Error('\P{Is_Blk=	 Ancient_Greek_Numbers:=}');
    Expect(1, 65935, '\p{Is_Blk=ancientgreeknumbers}', "");
    Expect(0, 65935, '\p{^Is_Blk=ancientgreeknumbers}', "");
    Expect(0, 65935, '\P{Is_Blk=ancientgreeknumbers}', "");
    Expect(1, 65935, '\P{^Is_Blk=ancientgreeknumbers}', "");
    Expect(0, 65936, '\p{Is_Blk=ancientgreeknumbers}', "");
    Expect(1, 65936, '\p{^Is_Blk=ancientgreeknumbers}', "");
    Expect(1, 65936, '\P{Is_Blk=ancientgreeknumbers}', "");
    Expect(0, 65936, '\P{^Is_Blk=ancientgreeknumbers}', "");
    Expect(1, 65935, '\p{Is_Blk=	 Ancient_GREEK_Numbers}', "");
    Expect(0, 65935, '\p{^Is_Blk=	 Ancient_GREEK_Numbers}', "");
    Expect(0, 65935, '\P{Is_Blk=	 Ancient_GREEK_Numbers}', "");
    Expect(1, 65935, '\P{^Is_Blk=	 Ancient_GREEK_Numbers}', "");
    Expect(0, 65936, '\p{Is_Blk=	 Ancient_GREEK_Numbers}', "");
    Expect(1, 65936, '\p{^Is_Blk=	 Ancient_GREEK_Numbers}', "");
    Expect(1, 65936, '\P{Is_Blk=	 Ancient_GREEK_Numbers}', "");
    Expect(0, 65936, '\P{^Is_Blk=	 Ancient_GREEK_Numbers}', "");
    Error('\p{Block=_:=Ancient_Symbols}');
    Error('\P{Block=_:=Ancient_Symbols}');
    Expect(1, 65999, '\p{Block=:\AAncient_Symbols\z:}', "");;
    Expect(0, 66000, '\p{Block=:\AAncient_Symbols\z:}', "");;
    Expect(1, 65999, '\p{Block=ancientsymbols}', "");
    Expect(0, 65999, '\p{^Block=ancientsymbols}', "");
    Expect(0, 65999, '\P{Block=ancientsymbols}', "");
    Expect(1, 65999, '\P{^Block=ancientsymbols}', "");
    Expect(0, 66000, '\p{Block=ancientsymbols}', "");
    Expect(1, 66000, '\p{^Block=ancientsymbols}', "");
    Expect(1, 66000, '\P{Block=ancientsymbols}', "");
    Expect(0, 66000, '\P{^Block=ancientsymbols}', "");
    Expect(1, 65999, '\p{Block=:\Aancientsymbols\z:}', "");;
    Expect(0, 66000, '\p{Block=:\Aancientsymbols\z:}', "");;
    Expect(1, 65999, '\p{Block= -Ancient_SYMBOLS}', "");
    Expect(0, 65999, '\p{^Block= -Ancient_SYMBOLS}', "");
    Expect(0, 65999, '\P{Block= -Ancient_SYMBOLS}', "");
    Expect(1, 65999, '\P{^Block= -Ancient_SYMBOLS}', "");
    Expect(0, 66000, '\p{Block= -Ancient_SYMBOLS}', "");
    Expect(1, 66000, '\p{^Block= -Ancient_SYMBOLS}', "");
    Expect(1, 66000, '\P{Block= -Ancient_SYMBOLS}', "");
    Expect(0, 66000, '\P{^Block= -Ancient_SYMBOLS}', "");
    Error('\p{Blk=:=_ ancient_Symbols}');
    Error('\P{Blk=:=_ ancient_Symbols}');
    Expect(1, 65999, '\p{Blk=:\AAncient_Symbols\z:}', "");;
    Expect(0, 66000, '\p{Blk=:\AAncient_Symbols\z:}', "");;
    Expect(1, 65999, '\p{Blk=ancientsymbols}', "");
    Expect(0, 65999, '\p{^Blk=ancientsymbols}', "");
    Expect(0, 65999, '\P{Blk=ancientsymbols}', "");
    Expect(1, 65999, '\P{^Blk=ancientsymbols}', "");
    Expect(0, 66000, '\p{Blk=ancientsymbols}', "");
    Expect(1, 66000, '\p{^Blk=ancientsymbols}', "");
    Expect(1, 66000, '\P{Blk=ancientsymbols}', "");
    Expect(0, 66000, '\P{^Blk=ancientsymbols}', "");
    Expect(1, 65999, '\p{Blk=:\Aancientsymbols\z:}', "");;
    Expect(0, 66000, '\p{Blk=:\Aancientsymbols\z:}', "");;
    Expect(1, 65999, '\p{Blk=	-Ancient_Symbols}', "");
    Expect(0, 65999, '\p{^Blk=	-Ancient_Symbols}', "");
    Expect(0, 65999, '\P{Blk=	-Ancient_Symbols}', "");
    Expect(1, 65999, '\P{^Blk=	-Ancient_Symbols}', "");
    Expect(0, 66000, '\p{Blk=	-Ancient_Symbols}', "");
    Expect(1, 66000, '\p{^Blk=	-Ancient_Symbols}', "");
    Expect(1, 66000, '\P{Blk=	-Ancient_Symbols}', "");
    Expect(0, 66000, '\P{^Blk=	-Ancient_Symbols}', "");
    Error('\p{Is_Block=-/a/Ancient_Symbols}');
    Error('\P{Is_Block=-/a/Ancient_Symbols}');
    Expect(1, 65999, '\p{Is_Block=ancientsymbols}', "");
    Expect(0, 65999, '\p{^Is_Block=ancientsymbols}', "");
    Expect(0, 65999, '\P{Is_Block=ancientsymbols}', "");
    Expect(1, 65999, '\P{^Is_Block=ancientsymbols}', "");
    Expect(0, 66000, '\p{Is_Block=ancientsymbols}', "");
    Expect(1, 66000, '\p{^Is_Block=ancientsymbols}', "");
    Expect(1, 66000, '\P{Is_Block=ancientsymbols}', "");
    Expect(0, 66000, '\P{^Is_Block=ancientsymbols}', "");
    Expect(1, 65999, '\p{Is_Block:	- Ancient_symbols}', "");
    Expect(0, 65999, '\p{^Is_Block:	- Ancient_symbols}', "");
    Expect(0, 65999, '\P{Is_Block:	- Ancient_symbols}', "");
    Expect(1, 65999, '\P{^Is_Block:	- Ancient_symbols}', "");
    Expect(0, 66000, '\p{Is_Block:	- Ancient_symbols}', "");
    Expect(1, 66000, '\p{^Is_Block:	- Ancient_symbols}', "");
    Expect(1, 66000, '\P{Is_Block:	- Ancient_symbols}', "");
    Expect(0, 66000, '\P{^Is_Block:	- Ancient_symbols}', "");
    Error('\p{Is_Blk= :=Ancient_SYMBOLS}');
    Error('\P{Is_Blk= :=Ancient_SYMBOLS}');
    Expect(1, 65999, '\p{Is_Blk=ancientsymbols}', "");
    Expect(0, 65999, '\p{^Is_Blk=ancientsymbols}', "");
    Expect(0, 65999, '\P{Is_Blk=ancientsymbols}', "");
    Expect(1, 65999, '\P{^Is_Blk=ancientsymbols}', "");
    Expect(0, 66000, '\p{Is_Blk=ancientsymbols}', "");
    Expect(1, 66000, '\p{^Is_Blk=ancientsymbols}', "");
    Expect(1, 66000, '\P{Is_Blk=ancientsymbols}', "");
    Expect(0, 66000, '\P{^Is_Blk=ancientsymbols}', "");
    Expect(1, 65999, '\p{Is_Blk= Ancient_symbols}', "");
    Expect(0, 65999, '\p{^Is_Blk= Ancient_symbols}', "");
    Expect(0, 65999, '\P{Is_Blk= Ancient_symbols}', "");
    Expect(1, 65999, '\P{^Is_Blk= Ancient_symbols}', "");
    Expect(0, 66000, '\p{Is_Blk= Ancient_symbols}', "");
    Expect(1, 66000, '\p{^Is_Blk= Ancient_symbols}', "");
    Expect(1, 66000, '\P{Is_Blk= Ancient_symbols}', "");
    Expect(0, 66000, '\P{^Is_Blk= Ancient_symbols}', "");
    Error('\p{Block=:=-_Arabic}');
    Error('\P{Block=:=-_Arabic}');
    Expect(1, 1791, '\p{Block=:\AArabic\z:}', "");;
    Expect(0, 1792, '\p{Block=:\AArabic\z:}', "");;
    Expect(1, 1791, '\p{Block=arabic}', "");
    Expect(0, 1791, '\p{^Block=arabic}', "");
    Expect(0, 1791, '\P{Block=arabic}', "");
    Expect(1, 1791, '\P{^Block=arabic}', "");
    Expect(0, 1792, '\p{Block=arabic}', "");
    Expect(1, 1792, '\p{^Block=arabic}', "");
    Expect(1, 1792, '\P{Block=arabic}', "");
    Expect(0, 1792, '\P{^Block=arabic}', "");
    Expect(1, 1791, '\p{Block=:\Aarabic\z:}', "");;
    Expect(0, 1792, '\p{Block=:\Aarabic\z:}', "");;
    Expect(1, 1791, '\p{Block=_arabic}', "");
    Expect(0, 1791, '\p{^Block=_arabic}', "");
    Expect(0, 1791, '\P{Block=_arabic}', "");
    Expect(1, 1791, '\P{^Block=_arabic}', "");
    Expect(0, 1792, '\p{Block=_arabic}', "");
    Expect(1, 1792, '\p{^Block=_arabic}', "");
    Expect(1, 1792, '\P{Block=_arabic}', "");
    Expect(0, 1792, '\P{^Block=_arabic}', "");
    Error('\p{Blk= 	arabic/a/}');
    Error('\P{Blk= 	arabic/a/}');
    Expect(1, 1791, '\p{Blk=:\AArabic\z:}', "");;
    Expect(0, 1792, '\p{Blk=:\AArabic\z:}', "");;
    Expect(1, 1791, '\p{Blk=arabic}', "");
    Expect(0, 1791, '\p{^Blk=arabic}', "");
    Expect(0, 1791, '\P{Blk=arabic}', "");
    Expect(1, 1791, '\P{^Blk=arabic}', "");
    Expect(0, 1792, '\p{Blk=arabic}', "");
    Expect(1, 1792, '\p{^Blk=arabic}', "");
    Expect(1, 1792, '\P{Blk=arabic}', "");
    Expect(0, 1792, '\P{^Blk=arabic}', "");
    Expect(1, 1791, '\p{Blk=:\Aarabic\z:}', "");;
    Expect(0, 1792, '\p{Blk=:\Aarabic\z:}', "");;
    Expect(1, 1791, '\p{Blk=- arabic}', "");
    Expect(0, 1791, '\p{^Blk=- arabic}', "");
    Expect(0, 1791, '\P{Blk=- arabic}', "");
    Expect(1, 1791, '\P{^Blk=- arabic}', "");
    Expect(0, 1792, '\p{Blk=- arabic}', "");
    Expect(1, 1792, '\p{^Blk=- arabic}', "");
    Expect(1, 1792, '\P{Blk=- arabic}', "");
    Expect(0, 1792, '\P{^Blk=- arabic}', "");
    Error('\p{Is_Block:	/a/ -Arabic}');
    Error('\P{Is_Block:	/a/ -Arabic}');
    Expect(1, 1791, '\p{Is_Block=arabic}', "");
    Expect(0, 1791, '\p{^Is_Block=arabic}', "");
    Expect(0, 1791, '\P{Is_Block=arabic}', "");
    Expect(1, 1791, '\P{^Is_Block=arabic}', "");
    Expect(0, 1792, '\p{Is_Block=arabic}', "");
    Expect(1, 1792, '\p{^Is_Block=arabic}', "");
    Expect(1, 1792, '\P{Is_Block=arabic}', "");
    Expect(0, 1792, '\P{^Is_Block=arabic}', "");
    Expect(1, 1791, '\p{Is_Block=__arabic}', "");
    Expect(0, 1791, '\p{^Is_Block=__arabic}', "");
    Expect(0, 1791, '\P{Is_Block=__arabic}', "");
    Expect(1, 1791, '\P{^Is_Block=__arabic}', "");
    Expect(0, 1792, '\p{Is_Block=__arabic}', "");
    Expect(1, 1792, '\p{^Is_Block=__arabic}', "");
    Expect(1, 1792, '\P{Is_Block=__arabic}', "");
    Expect(0, 1792, '\P{^Is_Block=__arabic}', "");
    Error('\p{Is_Blk=:=Arabic}');
    Error('\P{Is_Blk=:=Arabic}');
    Expect(1, 1791, '\p{Is_Blk=arabic}', "");
    Expect(0, 1791, '\p{^Is_Blk=arabic}', "");
    Expect(0, 1791, '\P{Is_Blk=arabic}', "");
    Expect(1, 1791, '\P{^Is_Blk=arabic}', "");
    Expect(0, 1792, '\p{Is_Blk=arabic}', "");
    Expect(1, 1792, '\p{^Is_Blk=arabic}', "");
    Expect(1, 1792, '\P{Is_Blk=arabic}', "");
    Expect(0, 1792, '\P{^Is_Blk=arabic}', "");
    Expect(1, 1791, '\p{Is_Blk:	ARABIC}', "");
    Expect(0, 1791, '\p{^Is_Blk:	ARABIC}', "");
    Expect(0, 1791, '\P{Is_Blk:	ARABIC}', "");
    Expect(1, 1791, '\P{^Is_Blk:	ARABIC}', "");
    Expect(0, 1792, '\p{Is_Blk:	ARABIC}', "");
    Expect(1, 1792, '\p{^Is_Blk:	ARABIC}', "");
    Expect(1, 1792, '\P{Is_Blk:	ARABIC}', "");
    Expect(0, 1792, '\P{^Is_Blk:	ARABIC}', "");
    Error('\p{Block= _ARABIC_EXTENDED_A:=}');
    Error('\P{Block= _ARABIC_EXTENDED_A:=}');
    Expect(1, 2303, '\p{Block=:\AArabic_Extended_A\z:}', "");;
    Expect(0, 2304, '\p{Block=:\AArabic_Extended_A\z:}', "");;
    Expect(1, 2303, '\p{Block=arabicextendeda}', "");
    Expect(0, 2303, '\p{^Block=arabicextendeda}', "");
    Expect(0, 2303, '\P{Block=arabicextendeda}', "");
    Expect(1, 2303, '\P{^Block=arabicextendeda}', "");
    Expect(0, 2304, '\p{Block=arabicextendeda}', "");
    Expect(1, 2304, '\p{^Block=arabicextendeda}', "");
    Expect(1, 2304, '\P{Block=arabicextendeda}', "");
    Expect(0, 2304, '\P{^Block=arabicextendeda}', "");
    Expect(1, 2303, '\p{Block=:\Aarabicextendeda\z:}', "");;
    Expect(0, 2304, '\p{Block=:\Aarabicextendeda\z:}', "");;
    Expect(1, 2303, '\p{Block=Arabic_Extended_a}', "");
    Expect(0, 2303, '\p{^Block=Arabic_Extended_a}', "");
    Expect(0, 2303, '\P{Block=Arabic_Extended_a}', "");
    Expect(1, 2303, '\P{^Block=Arabic_Extended_a}', "");
    Expect(0, 2304, '\p{Block=Arabic_Extended_a}', "");
    Expect(1, 2304, '\p{^Block=Arabic_Extended_a}', "");
    Expect(1, 2304, '\P{Block=Arabic_Extended_a}', "");
    Expect(0, 2304, '\P{^Block=Arabic_Extended_a}', "");
    Error('\p{Blk=-_Arabic_EXT_a:=}');
    Error('\P{Blk=-_Arabic_EXT_a:=}');
    Expect(1, 2303, '\p{Blk=:\AArabic_Ext_A\z:}', "");;
    Expect(0, 2304, '\p{Blk=:\AArabic_Ext_A\z:}', "");;
    Expect(1, 2303, '\p{Blk=arabicexta}', "");
    Expect(0, 2303, '\p{^Blk=arabicexta}', "");
    Expect(0, 2303, '\P{Blk=arabicexta}', "");
    Expect(1, 2303, '\P{^Blk=arabicexta}', "");
    Expect(0, 2304, '\p{Blk=arabicexta}', "");
    Expect(1, 2304, '\p{^Blk=arabicexta}', "");
    Expect(1, 2304, '\P{Blk=arabicexta}', "");
    Expect(0, 2304, '\P{^Blk=arabicexta}', "");
    Expect(1, 2303, '\p{Blk=:\Aarabicexta\z:}', "");;
    Expect(0, 2304, '\p{Blk=:\Aarabicexta\z:}', "");;
    Expect(1, 2303, '\p{Blk= 	Arabic_EXT_A}', "");
    Expect(0, 2303, '\p{^Blk= 	Arabic_EXT_A}', "");
    Expect(0, 2303, '\P{Blk= 	Arabic_EXT_A}', "");
    Expect(1, 2303, '\P{^Blk= 	Arabic_EXT_A}', "");
    Expect(0, 2304, '\p{Blk= 	Arabic_EXT_A}', "");
    Expect(1, 2304, '\p{^Blk= 	Arabic_EXT_A}', "");
    Expect(1, 2304, '\P{Blk= 	Arabic_EXT_A}', "");
    Expect(0, 2304, '\P{^Blk= 	Arabic_EXT_A}', "");
    Error('\p{Is_Block=- Arabic_Extended_a/a/}');
    Error('\P{Is_Block=- Arabic_Extended_a/a/}');
    Expect(1, 2303, '\p{Is_Block=arabicextendeda}', "");
    Expect(0, 2303, '\p{^Is_Block=arabicextendeda}', "");
    Expect(0, 2303, '\P{Is_Block=arabicextendeda}', "");
    Expect(1, 2303, '\P{^Is_Block=arabicextendeda}', "");
    Expect(0, 2304, '\p{Is_Block=arabicextendeda}', "");
    Expect(1, 2304, '\p{^Is_Block=arabicextendeda}', "");
    Expect(1, 2304, '\P{Is_Block=arabicextendeda}', "");
    Expect(0, 2304, '\P{^Is_Block=arabicextendeda}', "");
    Expect(1, 2303, '\p{Is_Block: __ARABIC_extended_A}', "");
    Expect(0, 2303, '\p{^Is_Block: __ARABIC_extended_A}', "");
    Expect(0, 2303, '\P{Is_Block: __ARABIC_extended_A}', "");
    Expect(1, 2303, '\P{^Is_Block: __ARABIC_extended_A}', "");
    Expect(0, 2304, '\p{Is_Block: __ARABIC_extended_A}', "");
    Expect(1, 2304, '\p{^Is_Block: __ARABIC_extended_A}', "");
    Expect(1, 2304, '\P{Is_Block: __ARABIC_extended_A}', "");
    Expect(0, 2304, '\P{^Is_Block: __ARABIC_extended_A}', "");
    Error('\p{Is_Blk=:=	_Arabic_ext_A}');
    Error('\P{Is_Blk=:=	_Arabic_ext_A}');
    Expect(1, 2303, '\p{Is_Blk=arabicexta}', "");
    Expect(0, 2303, '\p{^Is_Blk=arabicexta}', "");
    Expect(0, 2303, '\P{Is_Blk=arabicexta}', "");
    Expect(1, 2303, '\P{^Is_Blk=arabicexta}', "");
    Expect(0, 2304, '\p{Is_Blk=arabicexta}', "");
    Expect(1, 2304, '\p{^Is_Blk=arabicexta}', "");
    Expect(1, 2304, '\P{Is_Blk=arabicexta}', "");
    Expect(0, 2304, '\P{^Is_Blk=arabicexta}', "");
    Expect(1, 2303, '\p{Is_Blk=- Arabic_Ext_A}', "");
    Expect(0, 2303, '\p{^Is_Blk=- Arabic_Ext_A}', "");
    Expect(0, 2303, '\P{Is_Blk=- Arabic_Ext_A}', "");
    Expect(1, 2303, '\P{^Is_Blk=- Arabic_Ext_A}', "");
    Expect(0, 2304, '\p{Is_Blk=- Arabic_Ext_A}', "");
    Expect(1, 2304, '\p{^Is_Blk=- Arabic_Ext_A}', "");
    Expect(1, 2304, '\P{Is_Blk=- Arabic_Ext_A}', "");
    Expect(0, 2304, '\P{^Is_Blk=- Arabic_Ext_A}', "");
    Error('\p{Block=-:=ARABIC_extended_B}');
    Error('\P{Block=-:=ARABIC_extended_B}');
    Expect(1, 2207, '\p{Block=:\AArabic_Extended_B\z:}', "");;
    Expect(0, 2208, '\p{Block=:\AArabic_Extended_B\z:}', "");;
    Expect(1, 2207, '\p{Block=arabicextendedb}', "");
    Expect(0, 2207, '\p{^Block=arabicextendedb}', "");
    Expect(0, 2207, '\P{Block=arabicextendedb}', "");
    Expect(1, 2207, '\P{^Block=arabicextendedb}', "");
    Expect(0, 2208, '\p{Block=arabicextendedb}', "");
    Expect(1, 2208, '\p{^Block=arabicextendedb}', "");
    Expect(1, 2208, '\P{Block=arabicextendedb}', "");
    Expect(0, 2208, '\P{^Block=arabicextendedb}', "");
    Expect(1, 2207, '\p{Block=:\Aarabicextendedb\z:}', "");;
    Expect(0, 2208, '\p{Block=:\Aarabicextendedb\z:}', "");;
    Expect(1, 2207, '\p{Block=		ARABIC_Extended_B}', "");
    Expect(0, 2207, '\p{^Block=		ARABIC_Extended_B}', "");
    Expect(0, 2207, '\P{Block=		ARABIC_Extended_B}', "");
    Expect(1, 2207, '\P{^Block=		ARABIC_Extended_B}', "");
    Expect(0, 2208, '\p{Block=		ARABIC_Extended_B}', "");
    Expect(1, 2208, '\p{^Block=		ARABIC_Extended_B}', "");
    Expect(1, 2208, '\P{Block=		ARABIC_Extended_B}', "");
    Expect(0, 2208, '\P{^Block=		ARABIC_Extended_B}', "");
    Error('\p{Blk=	-ARABIC_ext_B:=}');
    Error('\P{Blk=	-ARABIC_ext_B:=}');
    Expect(1, 2207, '\p{Blk=:\AArabic_Ext_B\z:}', "");;
    Expect(0, 2208, '\p{Blk=:\AArabic_Ext_B\z:}', "");;
    Expect(1, 2207, '\p{Blk=arabicextb}', "");
    Expect(0, 2207, '\p{^Blk=arabicextb}', "");
    Expect(0, 2207, '\P{Blk=arabicextb}', "");
    Expect(1, 2207, '\P{^Blk=arabicextb}', "");
    Expect(0, 2208, '\p{Blk=arabicextb}', "");
    Expect(1, 2208, '\p{^Blk=arabicextb}', "");
    Expect(1, 2208, '\P{Blk=arabicextb}', "");
    Expect(0, 2208, '\P{^Blk=arabicextb}', "");
    Expect(1, 2207, '\p{Blk=:\Aarabicextb\z:}', "");;
    Expect(0, 2208, '\p{Blk=:\Aarabicextb\z:}', "");;
    Expect(1, 2207, '\p{Blk:	--ARABIC_Ext_b}', "");
    Expect(0, 2207, '\p{^Blk:	--ARABIC_Ext_b}', "");
    Expect(0, 2207, '\P{Blk:	--ARABIC_Ext_b}', "");
    Expect(1, 2207, '\P{^Blk:	--ARABIC_Ext_b}', "");
    Expect(0, 2208, '\p{Blk:	--ARABIC_Ext_b}', "");
    Expect(1, 2208, '\p{^Blk:	--ARABIC_Ext_b}', "");
    Expect(1, 2208, '\P{Blk:	--ARABIC_Ext_b}', "");
    Expect(0, 2208, '\P{^Blk:	--ARABIC_Ext_b}', "");
    Error('\p{Is_Block=/a/  arabic_EXTENDED_B}');
    Error('\P{Is_Block=/a/  arabic_EXTENDED_B}');
    Expect(1, 2207, '\p{Is_Block=arabicextendedb}', "");
    Expect(0, 2207, '\p{^Is_Block=arabicextendedb}', "");
    Expect(0, 2207, '\P{Is_Block=arabicextendedb}', "");
    Expect(1, 2207, '\P{^Is_Block=arabicextendedb}', "");
    Expect(0, 2208, '\p{Is_Block=arabicextendedb}', "");
    Expect(1, 2208, '\p{^Is_Block=arabicextendedb}', "");
    Expect(1, 2208, '\P{Is_Block=arabicextendedb}', "");
    Expect(0, 2208, '\P{^Is_Block=arabicextendedb}', "");
    Expect(1, 2207, '\p{Is_Block=- Arabic_Extended_B}', "");
    Expect(0, 2207, '\p{^Is_Block=- Arabic_Extended_B}', "");
    Expect(0, 2207, '\P{Is_Block=- Arabic_Extended_B}', "");
    Expect(1, 2207, '\P{^Is_Block=- Arabic_Extended_B}', "");
    Expect(0, 2208, '\p{Is_Block=- Arabic_Extended_B}', "");
    Expect(1, 2208, '\p{^Is_Block=- Arabic_Extended_B}', "");
    Expect(1, 2208, '\P{Is_Block=- Arabic_Extended_B}', "");
    Expect(0, 2208, '\P{^Is_Block=- Arabic_Extended_B}', "");
    Error('\p{Is_Blk=/a/ 	arabic_Ext_B}');
    Error('\P{Is_Blk=/a/ 	arabic_Ext_B}');
    Expect(1, 2207, '\p{Is_Blk=arabicextb}', "");
    Expect(0, 2207, '\p{^Is_Blk=arabicextb}', "");
    Expect(0, 2207, '\P{Is_Blk=arabicextb}', "");
    Expect(1, 2207, '\P{^Is_Blk=arabicextb}', "");
    Expect(0, 2208, '\p{Is_Blk=arabicextb}', "");
    Expect(1, 2208, '\p{^Is_Blk=arabicextb}', "");
    Expect(1, 2208, '\P{Is_Blk=arabicextb}', "");
    Expect(0, 2208, '\P{^Is_Blk=arabicextb}', "");
    Expect(1, 2207, '\p{Is_Blk= _ARABIC_Ext_B}', "");
    Expect(0, 2207, '\p{^Is_Blk= _ARABIC_Ext_B}', "");
    Expect(0, 2207, '\P{Is_Blk= _ARABIC_Ext_B}', "");
    Expect(1, 2207, '\P{^Is_Blk= _ARABIC_Ext_B}', "");
    Expect(0, 2208, '\p{Is_Blk= _ARABIC_Ext_B}', "");
    Expect(1, 2208, '\p{^Is_Blk= _ARABIC_Ext_B}', "");
    Expect(1, 2208, '\P{Is_Blk= _ARABIC_Ext_B}', "");
    Expect(0, 2208, '\P{^Is_Blk= _ARABIC_Ext_B}', "");
    Error('\p{Block= _arabic_Extended_C/a/}');
    Error('\P{Block= _arabic_Extended_C/a/}');
    Expect(1, 69375, '\p{Block=:\AArabic_Extended_C\z:}', "");;
    Expect(0, 69376, '\p{Block=:\AArabic_Extended_C\z:}', "");;
    Expect(1, 69375, '\p{Block=arabicextendedc}', "");
    Expect(0, 69375, '\p{^Block=arabicextendedc}', "");
    Expect(0, 69375, '\P{Block=arabicextendedc}', "");
    Expect(1, 69375, '\P{^Block=arabicextendedc}', "");
    Expect(0, 69376, '\p{Block=arabicextendedc}', "");
    Expect(1, 69376, '\p{^Block=arabicextendedc}', "");
    Expect(1, 69376, '\P{Block=arabicextendedc}', "");
    Expect(0, 69376, '\P{^Block=arabicextendedc}', "");
    Expect(1, 69375, '\p{Block=:\Aarabicextendedc\z:}', "");;
    Expect(0, 69376, '\p{Block=:\Aarabicextendedc\z:}', "");;
    Expect(1, 69375, '\p{Block=-arabic_Extended_C}', "");
    Expect(0, 69375, '\p{^Block=-arabic_Extended_C}', "");
    Expect(0, 69375, '\P{Block=-arabic_Extended_C}', "");
    Expect(1, 69375, '\P{^Block=-arabic_Extended_C}', "");
    Expect(0, 69376, '\p{Block=-arabic_Extended_C}', "");
    Expect(1, 69376, '\p{^Block=-arabic_Extended_C}', "");
    Expect(1, 69376, '\P{Block=-arabic_Extended_C}', "");
    Expect(0, 69376, '\P{^Block=-arabic_Extended_C}', "");
    Error('\p{Blk=_:=Arabic_ext_C}');
    Error('\P{Blk=_:=Arabic_ext_C}');
    Expect(1, 69375, '\p{Blk=:\AArabic_Ext_C\z:}', "");;
    Expect(0, 69376, '\p{Blk=:\AArabic_Ext_C\z:}', "");;
    Expect(1, 69375, '\p{Blk=arabicextc}', "");
    Expect(0, 69375, '\p{^Blk=arabicextc}', "");
    Expect(0, 69375, '\P{Blk=arabicextc}', "");
    Expect(1, 69375, '\P{^Blk=arabicextc}', "");
    Expect(0, 69376, '\p{Blk=arabicextc}', "");
    Expect(1, 69376, '\p{^Blk=arabicextc}', "");
    Expect(1, 69376, '\P{Blk=arabicextc}', "");
    Expect(0, 69376, '\P{^Blk=arabicextc}', "");
    Expect(1, 69375, '\p{Blk=:\Aarabicextc\z:}', "");;
    Expect(0, 69376, '\p{Blk=:\Aarabicextc\z:}', "");;
    Expect(1, 69375, '\p{Blk=_arabic_ext_C}', "");
    Expect(0, 69375, '\p{^Blk=_arabic_ext_C}', "");
    Expect(0, 69375, '\P{Blk=_arabic_ext_C}', "");
    Expect(1, 69375, '\P{^Blk=_arabic_ext_C}', "");
    Expect(0, 69376, '\p{Blk=_arabic_ext_C}', "");
    Expect(1, 69376, '\p{^Blk=_arabic_ext_C}', "");
    Expect(1, 69376, '\P{Blk=_arabic_ext_C}', "");
    Expect(0, 69376, '\P{^Blk=_arabic_ext_C}', "");
    Error('\p{Is_Block=	 arabic_Extended_C:=}');
    Error('\P{Is_Block=	 arabic_Extended_C:=}');
    Expect(1, 69375, '\p{Is_Block=arabicextendedc}', "");
    Expect(0, 69375, '\p{^Is_Block=arabicextendedc}', "");
    Expect(0, 69375, '\P{Is_Block=arabicextendedc}', "");
    Expect(1, 69375, '\P{^Is_Block=arabicextendedc}', "");
    Expect(0, 69376, '\p{Is_Block=arabicextendedc}', "");
    Expect(1, 69376, '\p{^Is_Block=arabicextendedc}', "");
    Expect(1, 69376, '\P{Is_Block=arabicextendedc}', "");
    Expect(0, 69376, '\P{^Is_Block=arabicextendedc}', "");
    Expect(1, 69375, '\p{Is_Block=_	ARABIC_Extended_C}', "");
    Expect(0, 69375, '\p{^Is_Block=_	ARABIC_Extended_C}', "");
    Expect(0, 69375, '\P{Is_Block=_	ARABIC_Extended_C}', "");
    Expect(1, 69375, '\P{^Is_Block=_	ARABIC_Extended_C}', "");
    Expect(0, 69376, '\p{Is_Block=_	ARABIC_Extended_C}', "");
    Expect(1, 69376, '\p{^Is_Block=_	ARABIC_Extended_C}', "");
    Expect(1, 69376, '\P{Is_Block=_	ARABIC_Extended_C}', "");
    Expect(0, 69376, '\P{^Is_Block=_	ARABIC_Extended_C}', "");
    Error('\p{Is_Blk=	:=ARABIC_Ext_C}');
    Error('\P{Is_Blk=	:=ARABIC_Ext_C}');
    Expect(1, 69375, '\p{Is_Blk=arabicextc}', "");
    Expect(0, 69375, '\p{^Is_Blk=arabicextc}', "");
    Expect(0, 69375, '\P{Is_Blk=arabicextc}', "");
    Expect(1, 69375, '\P{^Is_Blk=arabicextc}', "");
    Expect(0, 69376, '\p{Is_Blk=arabicextc}', "");
    Expect(1, 69376, '\p{^Is_Blk=arabicextc}', "");
    Expect(1, 69376, '\P{Is_Blk=arabicextc}', "");
    Expect(0, 69376, '\P{^Is_Blk=arabicextc}', "");
    Expect(1, 69375, '\p{Is_Blk= 	arabic_EXT_C}', "");
    Expect(0, 69375, '\p{^Is_Blk= 	arabic_EXT_C}', "");
    Expect(0, 69375, '\P{Is_Blk= 	arabic_EXT_C}', "");
    Expect(1, 69375, '\P{^Is_Blk= 	arabic_EXT_C}', "");
    Expect(0, 69376, '\p{Is_Blk= 	arabic_EXT_C}', "");
    Expect(1, 69376, '\p{^Is_Blk= 	arabic_EXT_C}', "");
    Expect(1, 69376, '\P{Is_Blk= 	arabic_EXT_C}', "");
    Expect(0, 69376, '\P{^Is_Blk= 	arabic_EXT_C}', "");
    Error('\p{Block=/a/ARABIC_Mathematical_Alphabetic_symbols}');
    Error('\P{Block=/a/ARABIC_Mathematical_Alphabetic_symbols}');
    Expect(1, 126719, '\p{Block=:\AArabic_Mathematical_Alphabetic_Symbols\z:}', "");;
    Expect(0, 126720, '\p{Block=:\AArabic_Mathematical_Alphabetic_Symbols\z:}', "");;
    Expect(1, 126719, '\p{Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126719, '\p{^Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126719, '\P{Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126719, '\P{^Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126720, '\p{Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126720, '\p{^Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126720, '\P{Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126720, '\P{^Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126719, '\p{Block=:\Aarabicmathematicalalphabeticsymbols\z:}', "");;
    Expect(0, 126720, '\p{Block=:\Aarabicmathematicalalphabeticsymbols\z:}', "");;
    Expect(1, 126719, '\p{Block=-arabic_Mathematical_alphabetic_SYMBOLS}', "");
    Expect(0, 126719, '\p{^Block=-arabic_Mathematical_alphabetic_SYMBOLS}', "");
    Expect(0, 126719, '\P{Block=-arabic_Mathematical_alphabetic_SYMBOLS}', "");
    Expect(1, 126719, '\P{^Block=-arabic_Mathematical_alphabetic_SYMBOLS}', "");
    Expect(0, 126720, '\p{Block=-arabic_Mathematical_alphabetic_SYMBOLS}', "");
    Expect(1, 126720, '\p{^Block=-arabic_Mathematical_alphabetic_SYMBOLS}', "");
    Expect(1, 126720, '\P{Block=-arabic_Mathematical_alphabetic_SYMBOLS}', "");
    Expect(0, 126720, '\P{^Block=-arabic_Mathematical_alphabetic_SYMBOLS}', "");
    Error('\p{Blk=:=__arabic_MATH}');
    Error('\P{Blk=:=__arabic_MATH}');
    Expect(1, 126719, '\p{Blk=:\AArabic_Math\z:}', "");;
    Expect(0, 126720, '\p{Blk=:\AArabic_Math\z:}', "");;
    Expect(1, 126719, '\p{Blk=arabicmath}', "");
    Expect(0, 126719, '\p{^Blk=arabicmath}', "");
    Expect(0, 126719, '\P{Blk=arabicmath}', "");
    Expect(1, 126719, '\P{^Blk=arabicmath}', "");
    Expect(0, 126720, '\p{Blk=arabicmath}', "");
    Expect(1, 126720, '\p{^Blk=arabicmath}', "");
    Expect(1, 126720, '\P{Blk=arabicmath}', "");
    Expect(0, 126720, '\P{^Blk=arabicmath}', "");
    Expect(1, 126719, '\p{Blk=:\Aarabicmath\z:}', "");;
    Expect(0, 126720, '\p{Blk=:\Aarabicmath\z:}', "");;
    Expect(1, 126719, '\p{Blk=-arabic_Math}', "");
    Expect(0, 126719, '\p{^Blk=-arabic_Math}', "");
    Expect(0, 126719, '\P{Blk=-arabic_Math}', "");
    Expect(1, 126719, '\P{^Blk=-arabic_Math}', "");
    Expect(0, 126720, '\p{Blk=-arabic_Math}', "");
    Expect(1, 126720, '\p{^Blk=-arabic_Math}', "");
    Expect(1, 126720, '\P{Blk=-arabic_Math}', "");
    Expect(0, 126720, '\P{^Blk=-arabic_Math}', "");
    Error('\p{Is_Block=__Arabic_Mathematical_alphabetic_symbols:=}');
    Error('\P{Is_Block=__Arabic_Mathematical_alphabetic_symbols:=}');
    Expect(1, 126719, '\p{Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126719, '\p{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126719, '\P{Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126719, '\P{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126720, '\p{Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126720, '\p{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126720, '\P{Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126720, '\P{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126719, '\p{Is_Block= ARABIC_Mathematical_Alphabetic_Symbols}', "");
    Expect(0, 126719, '\p{^Is_Block= ARABIC_Mathematical_Alphabetic_Symbols}', "");
    Expect(0, 126719, '\P{Is_Block= ARABIC_Mathematical_Alphabetic_Symbols}', "");
    Expect(1, 126719, '\P{^Is_Block= ARABIC_Mathematical_Alphabetic_Symbols}', "");
    Expect(0, 126720, '\p{Is_Block= ARABIC_Mathematical_Alphabetic_Symbols}', "");
    Expect(1, 126720, '\p{^Is_Block= ARABIC_Mathematical_Alphabetic_Symbols}', "");
    Expect(1, 126720, '\P{Is_Block= ARABIC_Mathematical_Alphabetic_Symbols}', "");
    Expect(0, 126720, '\P{^Is_Block= ARABIC_Mathematical_Alphabetic_Symbols}', "");
    Error('\p{Is_Blk:   __arabic_MATH/a/}');
    Error('\P{Is_Blk:   __arabic_MATH/a/}');
    Expect(1, 126719, '\p{Is_Blk=arabicmath}', "");
    Expect(0, 126719, '\p{^Is_Blk=arabicmath}', "");
    Expect(0, 126719, '\P{Is_Blk=arabicmath}', "");
    Expect(1, 126719, '\P{^Is_Blk=arabicmath}', "");
    Expect(0, 126720, '\p{Is_Blk=arabicmath}', "");
    Expect(1, 126720, '\p{^Is_Blk=arabicmath}', "");
    Expect(1, 126720, '\P{Is_Blk=arabicmath}', "");
    Expect(0, 126720, '\P{^Is_Blk=arabicmath}', "");
    Expect(1, 126719, '\p{Is_Blk=__ARABIC_math}', "");
    Expect(0, 126719, '\p{^Is_Blk=__ARABIC_math}', "");
    Expect(0, 126719, '\P{Is_Blk=__ARABIC_math}', "");
    Expect(1, 126719, '\P{^Is_Blk=__ARABIC_math}', "");
    Expect(0, 126720, '\p{Is_Blk=__ARABIC_math}', "");
    Expect(1, 126720, '\p{^Is_Blk=__ARABIC_math}', "");
    Expect(1, 126720, '\P{Is_Blk=__ARABIC_math}', "");
    Expect(0, 126720, '\P{^Is_Blk=__ARABIC_math}', "");
    Error('\p{Block:	/a/ARABIC_PRESENTATION_Forms_A}');
    Error('\P{Block:	/a/ARABIC_PRESENTATION_Forms_A}');
    Expect(1, 65023, '\p{Block=:\AArabic_Presentation_Forms_A\z:}', "");;
    Expect(0, 65024, '\p{Block=:\AArabic_Presentation_Forms_A\z:}', "");;
    Expect(1, 65023, '\p{Block=arabicpresentationformsa}', "");
    Expect(0, 65023, '\p{^Block=arabicpresentationformsa}', "");
    Expect(0, 65023, '\P{Block=arabicpresentationformsa}', "");
    Expect(1, 65023, '\P{^Block=arabicpresentationformsa}', "");
    Expect(0, 65024, '\p{Block=arabicpresentationformsa}', "");
    Expect(1, 65024, '\p{^Block=arabicpresentationformsa}', "");
    Expect(1, 65024, '\P{Block=arabicpresentationformsa}', "");
    Expect(0, 65024, '\P{^Block=arabicpresentationformsa}', "");
    Expect(1, 65023, '\p{Block=:\Aarabicpresentationformsa\z:}', "");;
    Expect(0, 65024, '\p{Block=:\Aarabicpresentationformsa\z:}', "");;
    Expect(1, 65023, '\p{Block=		ARABIC_Presentation_FORMS_A}', "");
    Expect(0, 65023, '\p{^Block=		ARABIC_Presentation_FORMS_A}', "");
    Expect(0, 65023, '\P{Block=		ARABIC_Presentation_FORMS_A}', "");
    Expect(1, 65023, '\P{^Block=		ARABIC_Presentation_FORMS_A}', "");
    Expect(0, 65024, '\p{Block=		ARABIC_Presentation_FORMS_A}', "");
    Expect(1, 65024, '\p{^Block=		ARABIC_Presentation_FORMS_A}', "");
    Expect(1, 65024, '\P{Block=		ARABIC_Presentation_FORMS_A}', "");
    Expect(0, 65024, '\P{^Block=		ARABIC_Presentation_FORMS_A}', "");
    Error('\p{Blk=_arabic_PF_A/a/}');
    Error('\P{Blk=_arabic_PF_A/a/}');
    Expect(1, 65023, '\p{Blk=:\AArabic_PF_A\z:}', "");;
    Expect(0, 65024, '\p{Blk=:\AArabic_PF_A\z:}', "");;
    Expect(1, 65023, '\p{Blk=arabicpfa}', "");
    Expect(0, 65023, '\p{^Blk=arabicpfa}', "");
    Expect(0, 65023, '\P{Blk=arabicpfa}', "");
    Expect(1, 65023, '\P{^Blk=arabicpfa}', "");
    Expect(0, 65024, '\p{Blk=arabicpfa}', "");
    Expect(1, 65024, '\p{^Blk=arabicpfa}', "");
    Expect(1, 65024, '\P{Blk=arabicpfa}', "");
    Expect(0, 65024, '\P{^Blk=arabicpfa}', "");
    Expect(1, 65023, '\p{Blk=:\Aarabicpfa\z:}', "");;
    Expect(0, 65024, '\p{Blk=:\Aarabicpfa\z:}', "");;
    Expect(1, 65023, '\p{Blk=	 Arabic_PF_a}', "");
    Expect(0, 65023, '\p{^Blk=	 Arabic_PF_a}', "");
    Expect(0, 65023, '\P{Blk=	 Arabic_PF_a}', "");
    Expect(1, 65023, '\P{^Blk=	 Arabic_PF_a}', "");
    Expect(0, 65024, '\p{Blk=	 Arabic_PF_a}', "");
    Expect(1, 65024, '\p{^Blk=	 Arabic_PF_a}', "");
    Expect(1, 65024, '\P{Blk=	 Arabic_PF_a}', "");
    Expect(0, 65024, '\P{^Blk=	 Arabic_PF_a}', "");
    Error('\p{Is_Block=:=- Arabic_Presentation_FORMS_A}');
    Error('\P{Is_Block=:=- Arabic_Presentation_FORMS_A}');
    Expect(1, 65023, '\p{Is_Block=arabicpresentationformsa}', "");
    Expect(0, 65023, '\p{^Is_Block=arabicpresentationformsa}', "");
    Expect(0, 65023, '\P{Is_Block=arabicpresentationformsa}', "");
    Expect(1, 65023, '\P{^Is_Block=arabicpresentationformsa}', "");
    Expect(0, 65024, '\p{Is_Block=arabicpresentationformsa}', "");
    Expect(1, 65024, '\p{^Is_Block=arabicpresentationformsa}', "");
    Expect(1, 65024, '\P{Is_Block=arabicpresentationformsa}', "");
    Expect(0, 65024, '\P{^Is_Block=arabicpresentationformsa}', "");
    Expect(1, 65023, '\p{Is_Block=_ ARABIC_Presentation_Forms_A}', "");
    Expect(0, 65023, '\p{^Is_Block=_ ARABIC_Presentation_Forms_A}', "");
    Expect(0, 65023, '\P{Is_Block=_ ARABIC_Presentation_Forms_A}', "");
    Expect(1, 65023, '\P{^Is_Block=_ ARABIC_Presentation_Forms_A}', "");
    Expect(0, 65024, '\p{Is_Block=_ ARABIC_Presentation_Forms_A}', "");
    Expect(1, 65024, '\p{^Is_Block=_ ARABIC_Presentation_Forms_A}', "");
    Expect(1, 65024, '\P{Is_Block=_ ARABIC_Presentation_Forms_A}', "");
    Expect(0, 65024, '\P{^Is_Block=_ ARABIC_Presentation_Forms_A}', "");
    Error('\p{Is_Blk=	_Arabic_PF_A/a/}');
    Error('\P{Is_Blk=	_Arabic_PF_A/a/}');
    Expect(1, 65023, '\p{Is_Blk=arabicpfa}', "");
    Expect(0, 65023, '\p{^Is_Blk=arabicpfa}', "");
    Expect(0, 65023, '\P{Is_Blk=arabicpfa}', "");
    Expect(1, 65023, '\P{^Is_Blk=arabicpfa}', "");
    Expect(0, 65024, '\p{Is_Blk=arabicpfa}', "");
    Expect(1, 65024, '\p{^Is_Blk=arabicpfa}', "");
    Expect(1, 65024, '\P{Is_Blk=arabicpfa}', "");
    Expect(0, 65024, '\P{^Is_Blk=arabicpfa}', "");
    Expect(1, 65023, '\p{Is_Blk= ARABIC_PF_a}', "");
    Expect(0, 65023, '\p{^Is_Blk= ARABIC_PF_a}', "");
    Expect(0, 65023, '\P{Is_Blk= ARABIC_PF_a}', "");
    Expect(1, 65023, '\P{^Is_Blk= ARABIC_PF_a}', "");
    Expect(0, 65024, '\p{Is_Blk= ARABIC_PF_a}', "");
    Expect(1, 65024, '\p{^Is_Blk= ARABIC_PF_a}', "");
    Expect(1, 65024, '\P{Is_Blk= ARABIC_PF_a}', "");
    Expect(0, 65024, '\P{^Is_Blk= ARABIC_PF_a}', "");
    Error('\p{Block=_:=Arabic_Presentation_Forms_b}');
    Error('\P{Block=_:=Arabic_Presentation_Forms_b}');
    Expect(1, 65279, '\p{Block=:\AArabic_Presentation_Forms_B\z:}', "");;
    Expect(0, 65280, '\p{Block=:\AArabic_Presentation_Forms_B\z:}', "");;
    Expect(1, 65279, '\p{Block=arabicpresentationformsb}', "");
    Expect(0, 65279, '\p{^Block=arabicpresentationformsb}', "");
    Expect(0, 65279, '\P{Block=arabicpresentationformsb}', "");
    Expect(1, 65279, '\P{^Block=arabicpresentationformsb}', "");
    Expect(0, 65280, '\p{Block=arabicpresentationformsb}', "");
    Expect(1, 65280, '\p{^Block=arabicpresentationformsb}', "");
    Expect(1, 65280, '\P{Block=arabicpresentationformsb}', "");
    Expect(0, 65280, '\P{^Block=arabicpresentationformsb}', "");
    Expect(1, 65279, '\p{Block=:\Aarabicpresentationformsb\z:}', "");;
    Expect(0, 65280, '\p{Block=:\Aarabicpresentationformsb\z:}', "");;
    Expect(1, 65279, '\p{Block: 	_ARABIC_presentation_FORMS_b}', "");
    Expect(0, 65279, '\p{^Block: 	_ARABIC_presentation_FORMS_b}', "");
    Expect(0, 65279, '\P{Block: 	_ARABIC_presentation_FORMS_b}', "");
    Expect(1, 65279, '\P{^Block: 	_ARABIC_presentation_FORMS_b}', "");
    Expect(0, 65280, '\p{Block: 	_ARABIC_presentation_FORMS_b}', "");
    Expect(1, 65280, '\p{^Block: 	_ARABIC_presentation_FORMS_b}', "");
    Expect(1, 65280, '\P{Block: 	_ARABIC_presentation_FORMS_b}', "");
    Expect(0, 65280, '\P{^Block: 	_ARABIC_presentation_FORMS_b}', "");
    Error('\p{Blk=--Arabic_PF_B/a/}');
    Error('\P{Blk=--Arabic_PF_B/a/}');
    Expect(1, 65279, '\p{Blk=:\AArabic_PF_B\z:}', "");;
    Expect(0, 65280, '\p{Blk=:\AArabic_PF_B\z:}', "");;
    Expect(1, 65279, '\p{Blk=arabicpfb}', "");
    Expect(0, 65279, '\p{^Blk=arabicpfb}', "");
    Expect(0, 65279, '\P{Blk=arabicpfb}', "");
    Expect(1, 65279, '\P{^Blk=arabicpfb}', "");
    Expect(0, 65280, '\p{Blk=arabicpfb}', "");
    Expect(1, 65280, '\p{^Blk=arabicpfb}', "");
    Expect(1, 65280, '\P{Blk=arabicpfb}', "");
    Expect(0, 65280, '\P{^Blk=arabicpfb}', "");
    Expect(1, 65279, '\p{Blk=:\Aarabicpfb\z:}', "");;
    Expect(0, 65280, '\p{Blk=:\Aarabicpfb\z:}', "");;
    Expect(1, 65279, '\p{Blk: _	Arabic_pf_B}', "");
    Expect(0, 65279, '\p{^Blk: _	Arabic_pf_B}', "");
    Expect(0, 65279, '\P{Blk: _	Arabic_pf_B}', "");
    Expect(1, 65279, '\P{^Blk: _	Arabic_pf_B}', "");
    Expect(0, 65280, '\p{Blk: _	Arabic_pf_B}', "");
    Expect(1, 65280, '\p{^Blk: _	Arabic_pf_B}', "");
    Expect(1, 65280, '\P{Blk: _	Arabic_pf_B}', "");
    Expect(0, 65280, '\P{^Blk: _	Arabic_pf_B}', "");
    Error('\p{Is_Block=-Arabic_presentation_Forms_B/a/}');
    Error('\P{Is_Block=-Arabic_presentation_Forms_B/a/}');
    Expect(1, 65279, '\p{Is_Block=arabicpresentationformsb}', "");
    Expect(0, 65279, '\p{^Is_Block=arabicpresentationformsb}', "");
    Expect(0, 65279, '\P{Is_Block=arabicpresentationformsb}', "");
    Expect(1, 65279, '\P{^Is_Block=arabicpresentationformsb}', "");
    Expect(0, 65280, '\p{Is_Block=arabicpresentationformsb}', "");
    Expect(1, 65280, '\p{^Is_Block=arabicpresentationformsb}', "");
    Expect(1, 65280, '\P{Is_Block=arabicpresentationformsb}', "");
    Expect(0, 65280, '\P{^Is_Block=arabicpresentationformsb}', "");
    Expect(1, 65279, '\p{Is_Block=_Arabic_Presentation_Forms_b}', "");
    Expect(0, 65279, '\p{^Is_Block=_Arabic_Presentation_Forms_b}', "");
    Expect(0, 65279, '\P{Is_Block=_Arabic_Presentation_Forms_b}', "");
    Expect(1, 65279, '\P{^Is_Block=_Arabic_Presentation_Forms_b}', "");
    Expect(0, 65280, '\p{Is_Block=_Arabic_Presentation_Forms_b}', "");
    Expect(1, 65280, '\p{^Is_Block=_Arabic_Presentation_Forms_b}', "");
    Expect(1, 65280, '\P{Is_Block=_Arabic_Presentation_Forms_b}', "");
    Expect(0, 65280, '\P{^Is_Block=_Arabic_Presentation_Forms_b}', "");
    Error('\p{Is_Blk=	:=Arabic_PF_B}');
    Error('\P{Is_Blk=	:=Arabic_PF_B}');
    Expect(1, 65279, '\p{Is_Blk=arabicpfb}', "");
    Expect(0, 65279, '\p{^Is_Blk=arabicpfb}', "");
    Expect(0, 65279, '\P{Is_Blk=arabicpfb}', "");
    Expect(1, 65279, '\P{^Is_Blk=arabicpfb}', "");
    Expect(0, 65280, '\p{Is_Blk=arabicpfb}', "");
    Expect(1, 65280, '\p{^Is_Blk=arabicpfb}', "");
    Expect(1, 65280, '\P{Is_Blk=arabicpfb}', "");
    Expect(0, 65280, '\P{^Is_Blk=arabicpfb}', "");
    Expect(1, 65279, '\p{Is_Blk=	_ARABIC_pf_B}', "");
    Expect(0, 65279, '\p{^Is_Blk=	_ARABIC_pf_B}', "");
    Expect(0, 65279, '\P{Is_Blk=	_ARABIC_pf_B}', "");
    Expect(1, 65279, '\P{^Is_Blk=	_ARABIC_pf_B}', "");
    Expect(0, 65280, '\p{Is_Blk=	_ARABIC_pf_B}', "");
    Expect(1, 65280, '\p{^Is_Blk=	_ARABIC_pf_B}', "");
    Expect(1, 65280, '\P{Is_Blk=	_ARABIC_pf_B}', "");
    Expect(0, 65280, '\P{^Is_Blk=	_ARABIC_pf_B}', "");
    Error('\p{Block=/a/_arabic_supplement}');
    Error('\P{Block=/a/_arabic_supplement}');
    Expect(1, 1919, '\p{Block=:\AArabic_Supplement\z:}', "");;
    Expect(0, 1920, '\p{Block=:\AArabic_Supplement\z:}', "");;
    Expect(1, 1919, '\p{Block=arabicsupplement}', "");
    Expect(0, 1919, '\p{^Block=arabicsupplement}', "");
    Expect(0, 1919, '\P{Block=arabicsupplement}', "");
    Expect(1, 1919, '\P{^Block=arabicsupplement}', "");
    Expect(0, 1920, '\p{Block=arabicsupplement}', "");
    Expect(1, 1920, '\p{^Block=arabicsupplement}', "");
    Expect(1, 1920, '\P{Block=arabicsupplement}', "");
    Expect(0, 1920, '\P{^Block=arabicsupplement}', "");
    Expect(1, 1919, '\p{Block=:\Aarabicsupplement\z:}', "");;
    Expect(0, 1920, '\p{Block=:\Aarabicsupplement\z:}', "");;
    Expect(1, 1919, '\p{Block=__Arabic_Supplement}', "");
    Expect(0, 1919, '\p{^Block=__Arabic_Supplement}', "");
    Expect(0, 1919, '\P{Block=__Arabic_Supplement}', "");
    Expect(1, 1919, '\P{^Block=__Arabic_Supplement}', "");
    Expect(0, 1920, '\p{Block=__Arabic_Supplement}', "");
    Expect(1, 1920, '\p{^Block=__Arabic_Supplement}', "");
    Expect(1, 1920, '\P{Block=__Arabic_Supplement}', "");
    Expect(0, 1920, '\P{^Block=__Arabic_Supplement}', "");
    Error('\p{Blk= /a/arabic_Sup}');
    Error('\P{Blk= /a/arabic_Sup}');
    Expect(1, 1919, '\p{Blk=:\AArabic_Sup\z:}', "");;
    Expect(0, 1920, '\p{Blk=:\AArabic_Sup\z:}', "");;
    Expect(1, 1919, '\p{Blk: arabicsup}', "");
    Expect(0, 1919, '\p{^Blk: arabicsup}', "");
    Expect(0, 1919, '\P{Blk: arabicsup}', "");
    Expect(1, 1919, '\P{^Blk: arabicsup}', "");
    Expect(0, 1920, '\p{Blk: arabicsup}', "");
    Expect(1, 1920, '\p{^Blk: arabicsup}', "");
    Expect(1, 1920, '\P{Blk: arabicsup}', "");
    Expect(0, 1920, '\P{^Blk: arabicsup}', "");
    Expect(1, 1919, '\p{Blk=:\Aarabicsup\z:}', "");;
    Expect(0, 1920, '\p{Blk=:\Aarabicsup\z:}', "");;
    Expect(1, 1919, '\p{Blk=_	ARABIC_Sup}', "");
    Expect(0, 1919, '\p{^Blk=_	ARABIC_Sup}', "");
    Expect(0, 1919, '\P{Blk=_	ARABIC_Sup}', "");
    Expect(1, 1919, '\P{^Blk=_	ARABIC_Sup}', "");
    Expect(0, 1920, '\p{Blk=_	ARABIC_Sup}', "");
    Expect(1, 1920, '\p{^Blk=_	ARABIC_Sup}', "");
    Expect(1, 1920, '\P{Blk=_	ARABIC_Sup}', "");
    Expect(0, 1920, '\P{^Blk=_	ARABIC_Sup}', "");
    Error('\p{Is_Block=_:=Arabic_Supplement}');
    Error('\P{Is_Block=_:=Arabic_Supplement}');
    Expect(1, 1919, '\p{Is_Block=arabicsupplement}', "");
    Expect(0, 1919, '\p{^Is_Block=arabicsupplement}', "");
    Expect(0, 1919, '\P{Is_Block=arabicsupplement}', "");
    Expect(1, 1919, '\P{^Is_Block=arabicsupplement}', "");
    Expect(0, 1920, '\p{Is_Block=arabicsupplement}', "");
    Expect(1, 1920, '\p{^Is_Block=arabicsupplement}', "");
    Expect(1, 1920, '\P{Is_Block=arabicsupplement}', "");
    Expect(0, 1920, '\P{^Is_Block=arabicsupplement}', "");
    Expect(1, 1919, '\p{Is_Block:_Arabic_Supplement}', "");
    Expect(0, 1919, '\p{^Is_Block:_Arabic_Supplement}', "");
    Expect(0, 1919, '\P{Is_Block:_Arabic_Supplement}', "");
    Expect(1, 1919, '\P{^Is_Block:_Arabic_Supplement}', "");
    Expect(0, 1920, '\p{Is_Block:_Arabic_Supplement}', "");
    Expect(1, 1920, '\p{^Is_Block:_Arabic_Supplement}', "");
    Expect(1, 1920, '\P{Is_Block:_Arabic_Supplement}', "");
    Expect(0, 1920, '\P{^Is_Block:_Arabic_Supplement}', "");
    Error('\p{Is_Blk=_ ARABIC_Sup:=}');
    Error('\P{Is_Blk=_ ARABIC_Sup:=}');
    Expect(1, 1919, '\p{Is_Blk=arabicsup}', "");
    Expect(0, 1919, '\p{^Is_Blk=arabicsup}', "");
    Expect(0, 1919, '\P{Is_Blk=arabicsup}', "");
    Expect(1, 1919, '\P{^Is_Blk=arabicsup}', "");
    Expect(0, 1920, '\p{Is_Blk=arabicsup}', "");
    Expect(1, 1920, '\p{^Is_Blk=arabicsup}', "");
    Expect(1, 1920, '\P{Is_Blk=arabicsup}', "");
    Expect(0, 1920, '\P{^Is_Blk=arabicsup}', "");
    Expect(1, 1919, '\p{Is_Blk:	Arabic_Sup}', "");
    Expect(0, 1919, '\p{^Is_Blk:	Arabic_Sup}', "");
    Expect(0, 1919, '\P{Is_Blk:	Arabic_Sup}', "");
    Expect(1, 1919, '\P{^Is_Blk:	Arabic_Sup}', "");
    Expect(0, 1920, '\p{Is_Blk:	Arabic_Sup}', "");
    Expect(1, 1920, '\p{^Is_Blk:	Arabic_Sup}', "");
    Expect(1, 1920, '\P{Is_Blk:	Arabic_Sup}', "");
    Expect(0, 1920, '\P{^Is_Blk:	Arabic_Sup}', "");
    Error('\p{Block=_/a/Armenian}');
    Error('\P{Block=_/a/Armenian}');
    Expect(1, 1423, '\p{Block=:\AArmenian\z:}', "");;
    Expect(0, 1424, '\p{Block=:\AArmenian\z:}', "");;
    Expect(1, 1423, '\p{Block=armenian}', "");
    Expect(0, 1423, '\p{^Block=armenian}', "");
    Expect(0, 1423, '\P{Block=armenian}', "");
    Expect(1, 1423, '\P{^Block=armenian}', "");
    Expect(0, 1424, '\p{Block=armenian}', "");
    Expect(1, 1424, '\p{^Block=armenian}', "");
    Expect(1, 1424, '\P{Block=armenian}', "");
    Expect(0, 1424, '\P{^Block=armenian}', "");
    Expect(1, 1423, '\p{Block=:\Aarmenian\z:}', "");;
    Expect(0, 1424, '\p{Block=:\Aarmenian\z:}', "");;
    Expect(1, 1423, '\p{Block=_ARMENIAN}', "");
    Expect(0, 1423, '\p{^Block=_ARMENIAN}', "");
    Expect(0, 1423, '\P{Block=_ARMENIAN}', "");
    Expect(1, 1423, '\P{^Block=_ARMENIAN}', "");
    Expect(0, 1424, '\p{Block=_ARMENIAN}', "");
    Expect(1, 1424, '\p{^Block=_ARMENIAN}', "");
    Expect(1, 1424, '\P{Block=_ARMENIAN}', "");
    Expect(0, 1424, '\P{^Block=_ARMENIAN}', "");
    Error('\p{Blk=-_Armenian/a/}');
    Error('\P{Blk=-_Armenian/a/}');
    Expect(1, 1423, '\p{Blk=:\AArmenian\z:}', "");;
    Expect(0, 1424, '\p{Blk=:\AArmenian\z:}', "");;
    Expect(1, 1423, '\p{Blk=armenian}', "");
    Expect(0, 1423, '\p{^Blk=armenian}', "");
    Expect(0, 1423, '\P{Blk=armenian}', "");
    Expect(1, 1423, '\P{^Blk=armenian}', "");
    Expect(0, 1424, '\p{Blk=armenian}', "");
    Expect(1, 1424, '\p{^Blk=armenian}', "");
    Expect(1, 1424, '\P{Blk=armenian}', "");
    Expect(0, 1424, '\P{^Blk=armenian}', "");
    Expect(1, 1423, '\p{Blk=:\Aarmenian\z:}', "");;
    Expect(0, 1424, '\p{Blk=:\Aarmenian\z:}', "");;
    Expect(1, 1423, '\p{Blk=_-Armenian}', "");
    Expect(0, 1423, '\p{^Blk=_-Armenian}', "");
    Expect(0, 1423, '\P{Blk=_-Armenian}', "");
    Expect(1, 1423, '\P{^Blk=_-Armenian}', "");
    Expect(0, 1424, '\p{Blk=_-Armenian}', "");
    Expect(1, 1424, '\p{^Blk=_-Armenian}', "");
    Expect(1, 1424, '\P{Blk=_-Armenian}', "");
    Expect(0, 1424, '\P{^Blk=_-Armenian}', "");
    Error('\p{Is_Block= ARMENIAN:=}');
    Error('\P{Is_Block= ARMENIAN:=}');
    Expect(1, 1423, '\p{Is_Block=armenian}', "");
    Expect(0, 1423, '\p{^Is_Block=armenian}', "");
    Expect(0, 1423, '\P{Is_Block=armenian}', "");
    Expect(1, 1423, '\P{^Is_Block=armenian}', "");
    Expect(0, 1424, '\p{Is_Block=armenian}', "");
    Expect(1, 1424, '\p{^Is_Block=armenian}', "");
    Expect(1, 1424, '\P{Is_Block=armenian}', "");
    Expect(0, 1424, '\P{^Is_Block=armenian}', "");
    Expect(1, 1423, '\p{Is_Block=		armenian}', "");
    Expect(0, 1423, '\p{^Is_Block=		armenian}', "");
    Expect(0, 1423, '\P{Is_Block=		armenian}', "");
    Expect(1, 1423, '\P{^Is_Block=		armenian}', "");
    Expect(0, 1424, '\p{Is_Block=		armenian}', "");
    Expect(1, 1424, '\p{^Is_Block=		armenian}', "");
    Expect(1, 1424, '\P{Is_Block=		armenian}', "");
    Expect(0, 1424, '\P{^Is_Block=		armenian}', "");
    Error('\p{Is_Blk=:= _armenian}');
    Error('\P{Is_Blk=:= _armenian}');
    Expect(1, 1423, '\p{Is_Blk:   armenian}', "");
    Expect(0, 1423, '\p{^Is_Blk:   armenian}', "");
    Expect(0, 1423, '\P{Is_Blk:   armenian}', "");
    Expect(1, 1423, '\P{^Is_Blk:   armenian}', "");
    Expect(0, 1424, '\p{Is_Blk:   armenian}', "");
    Expect(1, 1424, '\p{^Is_Blk:   armenian}', "");
    Expect(1, 1424, '\P{Is_Blk:   armenian}', "");
    Expect(0, 1424, '\P{^Is_Blk:   armenian}', "");
    Expect(1, 1423, '\p{Is_Blk=-	ARMENIAN}', "");
    Expect(0, 1423, '\p{^Is_Blk=-	ARMENIAN}', "");
    Expect(0, 1423, '\P{Is_Blk=-	ARMENIAN}', "");
    Expect(1, 1423, '\P{^Is_Blk=-	ARMENIAN}', "");
    Expect(0, 1424, '\p{Is_Blk=-	ARMENIAN}', "");
    Expect(1, 1424, '\p{^Is_Blk=-	ARMENIAN}', "");
    Expect(1, 1424, '\P{Is_Blk=-	ARMENIAN}', "");
    Expect(0, 1424, '\P{^Is_Blk=-	ARMENIAN}', "");
    Error('\p{Block=_ Arrows/a/}');
    Error('\P{Block=_ Arrows/a/}');
    Expect(1, 8703, '\p{Block=:\AArrows\z:}', "");;
    Expect(0, 8704, '\p{Block=:\AArrows\z:}', "");;
    Expect(1, 8703, '\p{Block:   arrows}', "");
    Expect(0, 8703, '\p{^Block:   arrows}', "");
    Expect(0, 8703, '\P{Block:   arrows}', "");
    Expect(1, 8703, '\P{^Block:   arrows}', "");
    Expect(0, 8704, '\p{Block:   arrows}', "");
    Expect(1, 8704, '\p{^Block:   arrows}', "");
    Expect(1, 8704, '\P{Block:   arrows}', "");
    Expect(0, 8704, '\P{^Block:   arrows}', "");
    Expect(1, 8703, '\p{Block=:\Aarrows\z:}', "");;
    Expect(0, 8704, '\p{Block=:\Aarrows\z:}', "");;
    Expect(1, 8703, '\p{Block=	ARROWS}', "");
    Expect(0, 8703, '\p{^Block=	ARROWS}', "");
    Expect(0, 8703, '\P{Block=	ARROWS}', "");
    Expect(1, 8703, '\P{^Block=	ARROWS}', "");
    Expect(0, 8704, '\p{Block=	ARROWS}', "");
    Expect(1, 8704, '\p{^Block=	ARROWS}', "");
    Expect(1, 8704, '\P{Block=	ARROWS}', "");
    Expect(0, 8704, '\P{^Block=	ARROWS}', "");
    Error('\p{Blk: _Arrows/a/}');
    Error('\P{Blk: _Arrows/a/}');
    Expect(1, 8703, '\p{Blk=:\AArrows\z:}', "");;
    Expect(0, 8704, '\p{Blk=:\AArrows\z:}', "");;
    Expect(1, 8703, '\p{Blk=arrows}', "");
    Expect(0, 8703, '\p{^Blk=arrows}', "");
    Expect(0, 8703, '\P{Blk=arrows}', "");
    Expect(1, 8703, '\P{^Blk=arrows}', "");
    Expect(0, 8704, '\p{Blk=arrows}', "");
    Expect(1, 8704, '\p{^Blk=arrows}', "");
    Expect(1, 8704, '\P{Blk=arrows}', "");
    Expect(0, 8704, '\P{^Blk=arrows}', "");
    Expect(1, 8703, '\p{Blk=:\Aarrows\z:}', "");;
    Expect(0, 8704, '\p{Blk=:\Aarrows\z:}', "");;
    Expect(1, 8703, '\p{Blk=_arrows}', "");
    Expect(0, 8703, '\p{^Blk=_arrows}', "");
    Expect(0, 8703, '\P{Blk=_arrows}', "");
    Expect(1, 8703, '\P{^Blk=_arrows}', "");
    Expect(0, 8704, '\p{Blk=_arrows}', "");
    Expect(1, 8704, '\p{^Blk=_arrows}', "");
    Expect(1, 8704, '\P{Blk=_arrows}', "");
    Expect(0, 8704, '\P{^Blk=_arrows}', "");
    Error('\p{Is_Block=-	Arrows/a/}');
    Error('\P{Is_Block=-	Arrows/a/}');
    Expect(1, 8703, '\p{Is_Block: arrows}', "");
    Expect(0, 8703, '\p{^Is_Block: arrows}', "");
    Expect(0, 8703, '\P{Is_Block: arrows}', "");
    Expect(1, 8703, '\P{^Is_Block: arrows}', "");
    Expect(0, 8704, '\p{Is_Block: arrows}', "");
    Expect(1, 8704, '\p{^Is_Block: arrows}', "");
    Expect(1, 8704, '\P{Is_Block: arrows}', "");
    Expect(0, 8704, '\P{^Is_Block: arrows}', "");
    Expect(1, 8703, '\p{Is_Block=	_ARROWS}', "");
    Expect(0, 8703, '\p{^Is_Block=	_ARROWS}', "");
    Expect(0, 8703, '\P{Is_Block=	_ARROWS}', "");
    Expect(1, 8703, '\P{^Is_Block=	_ARROWS}', "");
    Expect(0, 8704, '\p{Is_Block=	_ARROWS}', "");
    Expect(1, 8704, '\p{^Is_Block=	_ARROWS}', "");
    Expect(1, 8704, '\P{Is_Block=	_ARROWS}', "");
    Expect(0, 8704, '\P{^Is_Block=	_ARROWS}', "");
    Error('\p{Is_Blk=-_Arrows:=}');
    Error('\P{Is_Blk=-_Arrows:=}');
    Expect(1, 8703, '\p{Is_Blk=arrows}', "");
    Expect(0, 8703, '\p{^Is_Blk=arrows}', "");
    Expect(0, 8703, '\P{Is_Blk=arrows}', "");
    Expect(1, 8703, '\P{^Is_Blk=arrows}', "");
    Expect(0, 8704, '\p{Is_Blk=arrows}', "");
    Expect(1, 8704, '\p{^Is_Blk=arrows}', "");
    Expect(1, 8704, '\P{Is_Blk=arrows}', "");
    Expect(0, 8704, '\P{^Is_Blk=arrows}', "");
    Expect(1, 8703, '\p{Is_Blk=-_ARROWS}', "");
    Expect(0, 8703, '\p{^Is_Blk=-_ARROWS}', "");
    Expect(0, 8703, '\P{Is_Blk=-_ARROWS}', "");
    Expect(1, 8703, '\P{^Is_Blk=-_ARROWS}', "");
    Expect(0, 8704, '\p{Is_Blk=-_ARROWS}', "");
    Expect(1, 8704, '\p{^Is_Blk=-_ARROWS}', "");
    Expect(1, 8704, '\P{Is_Blk=-_ARROWS}', "");
    Expect(0, 8704, '\P{^Is_Blk=-_ARROWS}', "");
    Error('\p{Block:	 Basic_LATIN:=}');
    Error('\P{Block:	 Basic_LATIN:=}');
    Expect(1, 127, '\p{Block=:\ABasic_Latin\z:}', "");;
    Expect(0, 128, '\p{Block=:\ABasic_Latin\z:}', "");;
    Expect(1, 127, '\p{Block=basiclatin}', "");
    Expect(0, 127, '\p{^Block=basiclatin}', "");
    Expect(0, 127, '\P{Block=basiclatin}', "");
    Expect(1, 127, '\P{^Block=basiclatin}', "");
    Expect(0, 128, '\p{Block=basiclatin}', "");
    Expect(1, 128, '\p{^Block=basiclatin}', "");
    Expect(1, 128, '\P{Block=basiclatin}', "");
    Expect(0, 128, '\P{^Block=basiclatin}', "");
    Expect(1, 127, '\p{Block=:\Abasiclatin\z:}', "");;
    Expect(0, 128, '\p{Block=:\Abasiclatin\z:}', "");;
    Expect(1, 127, '\p{Block:	_Basic_Latin}', "");
    Expect(0, 127, '\p{^Block:	_Basic_Latin}', "");
    Expect(0, 127, '\P{Block:	_Basic_Latin}', "");
    Expect(1, 127, '\P{^Block:	_Basic_Latin}', "");
    Expect(0, 128, '\p{Block:	_Basic_Latin}', "");
    Expect(1, 128, '\p{^Block:	_Basic_Latin}', "");
    Expect(1, 128, '\P{Block:	_Basic_Latin}', "");
    Expect(0, 128, '\P{^Block:	_Basic_Latin}', "");
    Error('\p{Blk=__ASCII:=}');
    Error('\P{Blk=__ASCII:=}');
    Expect(1, 127, '\p{Blk=:\AASCII\z:}', "");;
    Expect(0, 128, '\p{Blk=:\AASCII\z:}', "");;
    Expect(1, 127, '\p{Blk=ascii}', "");
    Expect(0, 127, '\p{^Blk=ascii}', "");
    Expect(0, 127, '\P{Blk=ascii}', "");
    Expect(1, 127, '\P{^Blk=ascii}', "");
    Expect(0, 128, '\p{Blk=ascii}', "");
    Expect(1, 128, '\p{^Blk=ascii}', "");
    Expect(1, 128, '\P{Blk=ascii}', "");
    Expect(0, 128, '\P{^Blk=ascii}', "");
    Expect(1, 127, '\p{Blk=:\Aascii\z:}', "");;
    Expect(0, 128, '\p{Blk=:\Aascii\z:}', "");;
    Expect(1, 127, '\p{Blk=_-ASCII}', "");
    Expect(0, 127, '\p{^Blk=_-ASCII}', "");
    Expect(0, 127, '\P{Blk=_-ASCII}', "");
    Expect(1, 127, '\P{^Blk=_-ASCII}', "");
    Expect(0, 128, '\p{Blk=_-ASCII}', "");
    Expect(1, 128, '\p{^Blk=_-ASCII}', "");
    Expect(1, 128, '\P{Blk=_-ASCII}', "");
    Expect(0, 128, '\P{^Blk=_-ASCII}', "");
    Error('\p{Is_Block= /a/Basic_LATIN}');
    Error('\P{Is_Block= /a/Basic_LATIN}');
    Expect(1, 127, '\p{Is_Block=basiclatin}', "");
    Expect(0, 127, '\p{^Is_Block=basiclatin}', "");
    Expect(0, 127, '\P{Is_Block=basiclatin}', "");
    Expect(1, 127, '\P{^Is_Block=basiclatin}', "");
    Expect(0, 128, '\p{Is_Block=basiclatin}', "");
    Expect(1, 128, '\p{^Is_Block=basiclatin}', "");
    Expect(1, 128, '\P{Is_Block=basiclatin}', "");
    Expect(0, 128, '\P{^Is_Block=basiclatin}', "");
    Expect(1, 127, '\p{Is_Block=  Basic_Latin}', "");
    Expect(0, 127, '\p{^Is_Block=  Basic_Latin}', "");
    Expect(0, 127, '\P{Is_Block=  Basic_Latin}', "");
    Expect(1, 127, '\P{^Is_Block=  Basic_Latin}', "");
    Expect(0, 128, '\p{Is_Block=  Basic_Latin}', "");
    Expect(1, 128, '\p{^Is_Block=  Basic_Latin}', "");
    Expect(1, 128, '\P{Is_Block=  Basic_Latin}', "");
    Expect(0, 128, '\P{^Is_Block=  Basic_Latin}', "");
    Error('\p{Is_Blk=-/a/ASCII}');
    Error('\P{Is_Blk=-/a/ASCII}');
    Expect(1, 127, '\p{Is_Blk:   ascii}', "");
    Expect(0, 127, '\p{^Is_Blk:   ascii}', "");
    Expect(0, 127, '\P{Is_Blk:   ascii}', "");
    Expect(1, 127, '\P{^Is_Blk:   ascii}', "");
    Expect(0, 128, '\p{Is_Blk:   ascii}', "");
    Expect(1, 128, '\p{^Is_Blk:   ascii}', "");
    Expect(1, 128, '\P{Is_Blk:   ascii}', "");
    Expect(0, 128, '\P{^Is_Blk:   ascii}', "");
    Expect(1, 127, '\p{Is_Blk= _ASCII}', "");
    Expect(0, 127, '\p{^Is_Blk= _ASCII}', "");
    Expect(0, 127, '\P{Is_Blk= _ASCII}', "");
    Expect(1, 127, '\P{^Is_Blk= _ASCII}', "");
    Expect(0, 128, '\p{Is_Blk= _ASCII}', "");
    Expect(1, 128, '\p{^Is_Blk= _ASCII}', "");
    Expect(1, 128, '\P{Is_Blk= _ASCII}', "");
    Expect(0, 128, '\P{^Is_Blk= _ASCII}', "");
    Error('\p{Block: /a/-	avestan}');
    Error('\P{Block: /a/-	avestan}');
    Expect(1, 68415, '\p{Block=:\AAvestan\z:}', "");;
    Expect(0, 68416, '\p{Block=:\AAvestan\z:}', "");;
    Expect(1, 68415, '\p{Block:avestan}', "");
    Expect(0, 68415, '\p{^Block:avestan}', "");
    Expect(0, 68415, '\P{Block:avestan}', "");
    Expect(1, 68415, '\P{^Block:avestan}', "");
    Expect(0, 68416, '\p{Block:avestan}', "");
    Expect(1, 68416, '\p{^Block:avestan}', "");
    Expect(1, 68416, '\P{Block:avestan}', "");
    Expect(0, 68416, '\P{^Block:avestan}', "");
    Expect(1, 68415, '\p{Block=:\Aavestan\z:}', "");;
    Expect(0, 68416, '\p{Block=:\Aavestan\z:}', "");;
    Expect(1, 68415, '\p{Block= Avestan}', "");
    Expect(0, 68415, '\p{^Block= Avestan}', "");
    Expect(0, 68415, '\P{Block= Avestan}', "");
    Expect(1, 68415, '\P{^Block= Avestan}', "");
    Expect(0, 68416, '\p{Block= Avestan}', "");
    Expect(1, 68416, '\p{^Block= Avestan}', "");
    Expect(1, 68416, '\P{Block= Avestan}', "");
    Expect(0, 68416, '\P{^Block= Avestan}', "");
    Error('\p{Blk=:=_ Avestan}');
    Error('\P{Blk=:=_ Avestan}');
    Expect(1, 68415, '\p{Blk=:\AAvestan\z:}', "");;
    Expect(0, 68416, '\p{Blk=:\AAvestan\z:}', "");;
    Expect(1, 68415, '\p{Blk=avestan}', "");
    Expect(0, 68415, '\p{^Blk=avestan}', "");
    Expect(0, 68415, '\P{Blk=avestan}', "");
    Expect(1, 68415, '\P{^Blk=avestan}', "");
    Expect(0, 68416, '\p{Blk=avestan}', "");
    Expect(1, 68416, '\p{^Blk=avestan}', "");
    Expect(1, 68416, '\P{Blk=avestan}', "");
    Expect(0, 68416, '\P{^Blk=avestan}', "");
    Expect(1, 68415, '\p{Blk=:\Aavestan\z:}', "");;
    Expect(0, 68416, '\p{Blk=:\Aavestan\z:}', "");;
    Expect(1, 68415, '\p{Blk:	Avestan}', "");
    Expect(0, 68415, '\p{^Blk:	Avestan}', "");
    Expect(0, 68415, '\P{Blk:	Avestan}', "");
    Expect(1, 68415, '\P{^Blk:	Avestan}', "");
    Expect(0, 68416, '\p{Blk:	Avestan}', "");
    Expect(1, 68416, '\p{^Blk:	Avestan}', "");
    Expect(1, 68416, '\P{Blk:	Avestan}', "");
    Expect(0, 68416, '\P{^Blk:	Avestan}', "");
    Error('\p{Is_Block=- Avestan:=}');
    Error('\P{Is_Block=- Avestan:=}');
    Expect(1, 68415, '\p{Is_Block=avestan}', "");
    Expect(0, 68415, '\p{^Is_Block=avestan}', "");
    Expect(0, 68415, '\P{Is_Block=avestan}', "");
    Expect(1, 68415, '\P{^Is_Block=avestan}', "");
    Expect(0, 68416, '\p{Is_Block=avestan}', "");
    Expect(1, 68416, '\p{^Is_Block=avestan}', "");
    Expect(1, 68416, '\P{Is_Block=avestan}', "");
    Expect(0, 68416, '\P{^Is_Block=avestan}', "");
    Expect(1, 68415, '\p{Is_Block:   -AVESTAN}', "");
    Expect(0, 68415, '\p{^Is_Block:   -AVESTAN}', "");
    Expect(0, 68415, '\P{Is_Block:   -AVESTAN}', "");
    Expect(1, 68415, '\P{^Is_Block:   -AVESTAN}', "");
    Expect(0, 68416, '\p{Is_Block:   -AVESTAN}', "");
    Expect(1, 68416, '\p{^Is_Block:   -AVESTAN}', "");
    Expect(1, 68416, '\P{Is_Block:   -AVESTAN}', "");
    Expect(0, 68416, '\P{^Is_Block:   -AVESTAN}', "");
    Error('\p{Is_Blk=_:=avestan}');
    Error('\P{Is_Blk=_:=avestan}');
    Expect(1, 68415, '\p{Is_Blk:   avestan}', "");
    Expect(0, 68415, '\p{^Is_Blk:   avestan}', "");
    Expect(0, 68415, '\P{Is_Blk:   avestan}', "");
    Expect(1, 68415, '\P{^Is_Blk:   avestan}', "");
    Expect(0, 68416, '\p{Is_Blk:   avestan}', "");
    Expect(1, 68416, '\p{^Is_Blk:   avestan}', "");
    Expect(1, 68416, '\P{Is_Blk:   avestan}', "");
    Expect(0, 68416, '\P{^Is_Blk:   avestan}', "");
    Expect(1, 68415, '\p{Is_Blk= AVESTAN}', "");
    Expect(0, 68415, '\p{^Is_Blk= AVESTAN}', "");
    Expect(0, 68415, '\P{Is_Blk= AVESTAN}', "");
    Expect(1, 68415, '\P{^Is_Blk= AVESTAN}', "");
    Expect(0, 68416, '\p{Is_Blk= AVESTAN}', "");
    Expect(1, 68416, '\p{^Is_Blk= AVESTAN}', "");
    Expect(1, 68416, '\P{Is_Blk= AVESTAN}', "");
    Expect(0, 68416, '\P{^Is_Blk= AVESTAN}', "");
    Error('\p{Block:   _/a/Balinese}');
    Error('\P{Block:   _/a/Balinese}');
    Expect(1, 7039, '\p{Block=:\ABalinese\z:}', "");;
    Expect(0, 7040, '\p{Block=:\ABalinese\z:}', "");;
    Expect(1, 7039, '\p{Block=balinese}', "");
    Expect(0, 7039, '\p{^Block=balinese}', "");
    Expect(0, 7039, '\P{Block=balinese}', "");
    Expect(1, 7039, '\P{^Block=balinese}', "");
    Expect(0, 7040, '\p{Block=balinese}', "");
    Expect(1, 7040, '\p{^Block=balinese}', "");
    Expect(1, 7040, '\P{Block=balinese}', "");
    Expect(0, 7040, '\P{^Block=balinese}', "");
    Expect(1, 7039, '\p{Block=:\Abalinese\z:}', "");;
    Expect(0, 7040, '\p{Block=:\Abalinese\z:}', "");;
    Expect(1, 7039, '\p{Block=_-Balinese}', "");
    Expect(0, 7039, '\p{^Block=_-Balinese}', "");
    Expect(0, 7039, '\P{Block=_-Balinese}', "");
    Expect(1, 7039, '\P{^Block=_-Balinese}', "");
    Expect(0, 7040, '\p{Block=_-Balinese}', "");
    Expect(1, 7040, '\p{^Block=_-Balinese}', "");
    Expect(1, 7040, '\P{Block=_-Balinese}', "");
    Expect(0, 7040, '\P{^Block=_-Balinese}', "");
    Error('\p{Blk= _Balinese:=}');
    Error('\P{Blk= _Balinese:=}');
    Expect(1, 7039, '\p{Blk=:\ABalinese\z:}', "");;
    Expect(0, 7040, '\p{Blk=:\ABalinese\z:}', "");;
    Expect(1, 7039, '\p{Blk=balinese}', "");
    Expect(0, 7039, '\p{^Blk=balinese}', "");
    Expect(0, 7039, '\P{Blk=balinese}', "");
    Expect(1, 7039, '\P{^Blk=balinese}', "");
    Expect(0, 7040, '\p{Blk=balinese}', "");
    Expect(1, 7040, '\p{^Blk=balinese}', "");
    Expect(1, 7040, '\P{Blk=balinese}', "");
    Expect(0, 7040, '\P{^Blk=balinese}', "");
    Expect(1, 7039, '\p{Blk=:\Abalinese\z:}', "");;
    Expect(0, 7040, '\p{Blk=:\Abalinese\z:}', "");;
    Expect(1, 7039, '\p{Blk=  Balinese}', "");
    Expect(0, 7039, '\p{^Blk=  Balinese}', "");
    Expect(0, 7039, '\P{Blk=  Balinese}', "");
    Expect(1, 7039, '\P{^Blk=  Balinese}', "");
    Expect(0, 7040, '\p{Blk=  Balinese}', "");
    Expect(1, 7040, '\p{^Blk=  Balinese}', "");
    Expect(1, 7040, '\P{Blk=  Balinese}', "");
    Expect(0, 7040, '\P{^Blk=  Balinese}', "");
    Error('\p{Is_Block=_:=BALINESE}');
    Error('\P{Is_Block=_:=BALINESE}');
    Expect(1, 7039, '\p{Is_Block=balinese}', "");
    Expect(0, 7039, '\p{^Is_Block=balinese}', "");
    Expect(0, 7039, '\P{Is_Block=balinese}', "");
    Expect(1, 7039, '\P{^Is_Block=balinese}', "");
    Expect(0, 7040, '\p{Is_Block=balinese}', "");
    Expect(1, 7040, '\p{^Is_Block=balinese}', "");
    Expect(1, 7040, '\P{Is_Block=balinese}', "");
    Expect(0, 7040, '\P{^Is_Block=balinese}', "");
    Expect(1, 7039, '\p{Is_Block=	-balinese}', "");
    Expect(0, 7039, '\p{^Is_Block=	-balinese}', "");
    Expect(0, 7039, '\P{Is_Block=	-balinese}', "");
    Expect(1, 7039, '\P{^Is_Block=	-balinese}', "");
    Expect(0, 7040, '\p{Is_Block=	-balinese}', "");
    Expect(1, 7040, '\p{^Is_Block=	-balinese}', "");
    Expect(1, 7040, '\P{Is_Block=	-balinese}', "");
    Expect(0, 7040, '\P{^Is_Block=	-balinese}', "");
    Error('\p{Is_Blk= Balinese/a/}');
    Error('\P{Is_Blk= Balinese/a/}');
    Expect(1, 7039, '\p{Is_Blk=balinese}', "");
    Expect(0, 7039, '\p{^Is_Blk=balinese}', "");
    Expect(0, 7039, '\P{Is_Blk=balinese}', "");
    Expect(1, 7039, '\P{^Is_Blk=balinese}', "");
    Expect(0, 7040, '\p{Is_Blk=balinese}', "");
    Expect(1, 7040, '\p{^Is_Blk=balinese}', "");
    Expect(1, 7040, '\P{Is_Blk=balinese}', "");
    Expect(0, 7040, '\P{^Is_Blk=balinese}', "");
    Expect(1, 7039, '\p{Is_Blk:	  balinese}', "");
    Expect(0, 7039, '\p{^Is_Blk:	  balinese}', "");
    Expect(0, 7039, '\P{Is_Blk:	  balinese}', "");
    Expect(1, 7039, '\P{^Is_Blk:	  balinese}', "");
    Expect(0, 7040, '\p{Is_Blk:	  balinese}', "");
    Expect(1, 7040, '\p{^Is_Blk:	  balinese}', "");
    Expect(1, 7040, '\P{Is_Blk:	  balinese}', "");
    Expect(0, 7040, '\P{^Is_Blk:	  balinese}', "");
    Error('\p{Block:_	BAMUM/a/}');
    Error('\P{Block:_	BAMUM/a/}');
    Expect(1, 42751, '\p{Block=:\ABamum\z:}', "");;
    Expect(0, 42752, '\p{Block=:\ABamum\z:}', "");;
    Expect(1, 42751, '\p{Block=bamum}', "");
    Expect(0, 42751, '\p{^Block=bamum}', "");
    Expect(0, 42751, '\P{Block=bamum}', "");
    Expect(1, 42751, '\P{^Block=bamum}', "");
    Expect(0, 42752, '\p{Block=bamum}', "");
    Expect(1, 42752, '\p{^Block=bamum}', "");
    Expect(1, 42752, '\P{Block=bamum}', "");
    Expect(0, 42752, '\P{^Block=bamum}', "");
    Expect(1, 42751, '\p{Block=:\Abamum\z:}', "");;
    Expect(0, 42752, '\p{Block=:\Abamum\z:}', "");;
    Expect(1, 42751, '\p{Block=	 Bamum}', "");
    Expect(0, 42751, '\p{^Block=	 Bamum}', "");
    Expect(0, 42751, '\P{Block=	 Bamum}', "");
    Expect(1, 42751, '\P{^Block=	 Bamum}', "");
    Expect(0, 42752, '\p{Block=	 Bamum}', "");
    Expect(1, 42752, '\p{^Block=	 Bamum}', "");
    Expect(1, 42752, '\P{Block=	 Bamum}', "");
    Expect(0, 42752, '\P{^Block=	 Bamum}', "");
    Error('\p{Blk=/a/- BAMUM}');
    Error('\P{Blk=/a/- BAMUM}');
    Expect(1, 42751, '\p{Blk=:\ABamum\z:}', "");;
    Expect(0, 42752, '\p{Blk=:\ABamum\z:}', "");;
    Expect(1, 42751, '\p{Blk=bamum}', "");
    Expect(0, 42751, '\p{^Blk=bamum}', "");
    Expect(0, 42751, '\P{Blk=bamum}', "");
    Expect(1, 42751, '\P{^Blk=bamum}', "");
    Expect(0, 42752, '\p{Blk=bamum}', "");
    Expect(1, 42752, '\p{^Blk=bamum}', "");
    Expect(1, 42752, '\P{Blk=bamum}', "");
    Expect(0, 42752, '\P{^Blk=bamum}', "");
    Expect(1, 42751, '\p{Blk=:\Abamum\z:}', "");;
    Expect(0, 42752, '\p{Blk=:\Abamum\z:}', "");;
    Expect(1, 42751, '\p{Blk=	Bamum}', "");
    Expect(0, 42751, '\p{^Blk=	Bamum}', "");
    Expect(0, 42751, '\P{Blk=	Bamum}', "");
    Expect(1, 42751, '\P{^Blk=	Bamum}', "");
    Expect(0, 42752, '\p{Blk=	Bamum}', "");
    Expect(1, 42752, '\p{^Blk=	Bamum}', "");
    Expect(1, 42752, '\P{Blk=	Bamum}', "");
    Expect(0, 42752, '\P{^Blk=	Bamum}', "");
    Error('\p{Is_Block=	bamum/a/}');
    Error('\P{Is_Block=	bamum/a/}');
    Expect(1, 42751, '\p{Is_Block: bamum}', "");
    Expect(0, 42751, '\p{^Is_Block: bamum}', "");
    Expect(0, 42751, '\P{Is_Block: bamum}', "");
    Expect(1, 42751, '\P{^Is_Block: bamum}', "");
    Expect(0, 42752, '\p{Is_Block: bamum}', "");
    Expect(1, 42752, '\p{^Is_Block: bamum}', "");
    Expect(1, 42752, '\P{Is_Block: bamum}', "");
    Expect(0, 42752, '\P{^Is_Block: bamum}', "");
    Expect(1, 42751, '\p{Is_Block=-Bamum}', "");
    Expect(0, 42751, '\p{^Is_Block=-Bamum}', "");
    Expect(0, 42751, '\P{Is_Block=-Bamum}', "");
    Expect(1, 42751, '\P{^Is_Block=-Bamum}', "");
    Expect(0, 42752, '\p{Is_Block=-Bamum}', "");
    Expect(1, 42752, '\p{^Is_Block=-Bamum}', "");
    Expect(1, 42752, '\P{Is_Block=-Bamum}', "");
    Expect(0, 42752, '\P{^Is_Block=-Bamum}', "");
    Error('\p{Is_Blk:   :=  Bamum}');
    Error('\P{Is_Blk:   :=  Bamum}');
    Expect(1, 42751, '\p{Is_Blk=bamum}', "");
    Expect(0, 42751, '\p{^Is_Blk=bamum}', "");
    Expect(0, 42751, '\P{Is_Blk=bamum}', "");
    Expect(1, 42751, '\P{^Is_Blk=bamum}', "");
    Expect(0, 42752, '\p{Is_Blk=bamum}', "");
    Expect(1, 42752, '\p{^Is_Blk=bamum}', "");
    Expect(1, 42752, '\P{Is_Blk=bamum}', "");
    Expect(0, 42752, '\P{^Is_Blk=bamum}', "");
    Expect(1, 42751, '\p{Is_Blk=	 BAMUM}', "");
    Expect(0, 42751, '\p{^Is_Blk=	 BAMUM}', "");
    Expect(0, 42751, '\P{Is_Blk=	 BAMUM}', "");
    Expect(1, 42751, '\P{^Is_Blk=	 BAMUM}', "");
    Expect(0, 42752, '\p{Is_Blk=	 BAMUM}', "");
    Expect(1, 42752, '\p{^Is_Blk=	 BAMUM}', "");
    Expect(1, 42752, '\P{Is_Blk=	 BAMUM}', "");
    Expect(0, 42752, '\P{^Is_Blk=	 BAMUM}', "");
    Error('\p{Block=/a/		bamum_supplement}');
    Error('\P{Block=/a/		bamum_supplement}');
    Expect(1, 92735, '\p{Block=:\ABamum_Supplement\z:}', "");;
    Expect(0, 92736, '\p{Block=:\ABamum_Supplement\z:}', "");;
    Expect(1, 92735, '\p{Block=bamumsupplement}', "");
    Expect(0, 92735, '\p{^Block=bamumsupplement}', "");
    Expect(0, 92735, '\P{Block=bamumsupplement}', "");
    Expect(1, 92735, '\P{^Block=bamumsupplement}', "");
    Expect(0, 92736, '\p{Block=bamumsupplement}', "");
    Expect(1, 92736, '\p{^Block=bamumsupplement}', "");
    Expect(1, 92736, '\P{Block=bamumsupplement}', "");
    Expect(0, 92736, '\P{^Block=bamumsupplement}', "");
    Expect(1, 92735, '\p{Block=:\Abamumsupplement\z:}', "");;
    Expect(0, 92736, '\p{Block=:\Abamumsupplement\z:}', "");;
    Expect(1, 92735, '\p{Block=_BAMUM_Supplement}', "");
    Expect(0, 92735, '\p{^Block=_BAMUM_Supplement}', "");
    Expect(0, 92735, '\P{Block=_BAMUM_Supplement}', "");
    Expect(1, 92735, '\P{^Block=_BAMUM_Supplement}', "");
    Expect(0, 92736, '\p{Block=_BAMUM_Supplement}', "");
    Expect(1, 92736, '\p{^Block=_BAMUM_Supplement}', "");
    Expect(1, 92736, '\P{Block=_BAMUM_Supplement}', "");
    Expect(0, 92736, '\P{^Block=_BAMUM_Supplement}', "");
    Error('\p{Blk= /a/bamum_Sup}');
    Error('\P{Blk= /a/bamum_Sup}');
    Expect(1, 92735, '\p{Blk=:\ABamum_Sup\z:}', "");;
    Expect(0, 92736, '\p{Blk=:\ABamum_Sup\z:}', "");;
    Expect(1, 92735, '\p{Blk:bamumsup}', "");
    Expect(0, 92735, '\p{^Blk:bamumsup}', "");
    Expect(0, 92735, '\P{Blk:bamumsup}', "");
    Expect(1, 92735, '\P{^Blk:bamumsup}', "");
    Expect(0, 92736, '\p{Blk:bamumsup}', "");
    Expect(1, 92736, '\p{^Blk:bamumsup}', "");
    Expect(1, 92736, '\P{Blk:bamumsup}', "");
    Expect(0, 92736, '\P{^Blk:bamumsup}', "");
    Expect(1, 92735, '\p{Blk=:\Abamumsup\z:}', "");;
    Expect(0, 92736, '\p{Blk=:\Abamumsup\z:}', "");;
    Expect(1, 92735, '\p{Blk= bamum_SUP}', "");
    Expect(0, 92735, '\p{^Blk= bamum_SUP}', "");
    Expect(0, 92735, '\P{Blk= bamum_SUP}', "");
    Expect(1, 92735, '\P{^Blk= bamum_SUP}', "");
    Expect(0, 92736, '\p{Blk= bamum_SUP}', "");
    Expect(1, 92736, '\p{^Blk= bamum_SUP}', "");
    Expect(1, 92736, '\P{Blk= bamum_SUP}', "");
    Expect(0, 92736, '\P{^Blk= bamum_SUP}', "");
    Error('\p{Is_Block=_	bamum_supplement/a/}');
    Error('\P{Is_Block=_	bamum_supplement/a/}');
    Expect(1, 92735, '\p{Is_Block=bamumsupplement}', "");
    Expect(0, 92735, '\p{^Is_Block=bamumsupplement}', "");
    Expect(0, 92735, '\P{Is_Block=bamumsupplement}', "");
    Expect(1, 92735, '\P{^Is_Block=bamumsupplement}', "");
    Expect(0, 92736, '\p{Is_Block=bamumsupplement}', "");
    Expect(1, 92736, '\p{^Is_Block=bamumsupplement}', "");
    Expect(1, 92736, '\P{Is_Block=bamumsupplement}', "");
    Expect(0, 92736, '\P{^Is_Block=bamumsupplement}', "");
    Expect(1, 92735, '\p{Is_Block=-Bamum_supplement}', "");
    Expect(0, 92735, '\p{^Is_Block=-Bamum_supplement}', "");
    Expect(0, 92735, '\P{Is_Block=-Bamum_supplement}', "");
    Expect(1, 92735, '\P{^Is_Block=-Bamum_supplement}', "");
    Expect(0, 92736, '\p{Is_Block=-Bamum_supplement}', "");
    Expect(1, 92736, '\p{^Is_Block=-Bamum_supplement}', "");
    Expect(1, 92736, '\P{Is_Block=-Bamum_supplement}', "");
    Expect(0, 92736, '\P{^Is_Block=-Bamum_supplement}', "");
    Error('\p{Is_Blk=-BAMUM_Sup:=}');
    Error('\P{Is_Blk=-BAMUM_Sup:=}');
    Expect(1, 92735, '\p{Is_Blk=bamumsup}', "");
    Expect(0, 92735, '\p{^Is_Blk=bamumsup}', "");
    Expect(0, 92735, '\P{Is_Blk=bamumsup}', "");
    Expect(1, 92735, '\P{^Is_Blk=bamumsup}', "");
    Expect(0, 92736, '\p{Is_Blk=bamumsup}', "");
    Expect(1, 92736, '\p{^Is_Blk=bamumsup}', "");
    Expect(1, 92736, '\P{Is_Blk=bamumsup}', "");
    Expect(0, 92736, '\P{^Is_Blk=bamumsup}', "");
    Expect(1, 92735, '\p{Is_Blk= -Bamum_sup}', "");
    Expect(0, 92735, '\p{^Is_Blk= -Bamum_sup}', "");
    Expect(0, 92735, '\P{Is_Blk= -Bamum_sup}', "");
    Expect(1, 92735, '\P{^Is_Blk= -Bamum_sup}', "");
    Expect(0, 92736, '\p{Is_Blk= -Bamum_sup}', "");
    Expect(1, 92736, '\p{^Is_Blk= -Bamum_sup}', "");
    Expect(1, 92736, '\P{Is_Blk= -Bamum_sup}', "");
    Expect(0, 92736, '\P{^Is_Blk= -Bamum_sup}', "");
    Error('\p{Block: 	Bassa_vah/a/}');
    Error('\P{Block: 	Bassa_vah/a/}');
    Expect(1, 92927, '\p{Block=:\ABassa_Vah\z:}', "");;
    Expect(0, 92928, '\p{Block=:\ABassa_Vah\z:}', "");;
    Expect(1, 92927, '\p{Block=bassavah}', "");
    Expect(0, 92927, '\p{^Block=bassavah}', "");
    Expect(0, 92927, '\P{Block=bassavah}', "");
    Expect(1, 92927, '\P{^Block=bassavah}', "");
    Expect(0, 92928, '\p{Block=bassavah}', "");
    Expect(1, 92928, '\p{^Block=bassavah}', "");
    Expect(1, 92928, '\P{Block=bassavah}', "");
    Expect(0, 92928, '\P{^Block=bassavah}', "");
    Expect(1, 92927, '\p{Block=:\Abassavah\z:}', "");;
    Expect(0, 92928, '\p{Block=:\Abassavah\z:}', "");;
    Expect(1, 92927, '\p{Block:	_ Bassa_VAH}', "");
    Expect(0, 92927, '\p{^Block:	_ Bassa_VAH}', "");
    Expect(0, 92927, '\P{Block:	_ Bassa_VAH}', "");
    Expect(1, 92927, '\P{^Block:	_ Bassa_VAH}', "");
    Expect(0, 92928, '\p{Block:	_ Bassa_VAH}', "");
    Expect(1, 92928, '\p{^Block:	_ Bassa_VAH}', "");
    Expect(1, 92928, '\P{Block:	_ Bassa_VAH}', "");
    Expect(0, 92928, '\P{^Block:	_ Bassa_VAH}', "");
    Error('\p{Blk=_BASSA_Vah:=}');
    Error('\P{Blk=_BASSA_Vah:=}');
    Expect(1, 92927, '\p{Blk=:\ABassa_Vah\z:}', "");;
    Expect(0, 92928, '\p{Blk=:\ABassa_Vah\z:}', "");;
    Expect(1, 92927, '\p{Blk=bassavah}', "");
    Expect(0, 92927, '\p{^Blk=bassavah}', "");
    Expect(0, 92927, '\P{Blk=bassavah}', "");
    Expect(1, 92927, '\P{^Blk=bassavah}', "");
    Expect(0, 92928, '\p{Blk=bassavah}', "");
    Expect(1, 92928, '\p{^Blk=bassavah}', "");
    Expect(1, 92928, '\P{Blk=bassavah}', "");
    Expect(0, 92928, '\P{^Blk=bassavah}', "");
    Expect(1, 92927, '\p{Blk=:\Abassavah\z:}', "");;
    Expect(0, 92928, '\p{Blk=:\Abassavah\z:}', "");;
    Expect(1, 92927, '\p{Blk=  Bassa_Vah}', "");
    Expect(0, 92927, '\p{^Blk=  Bassa_Vah}', "");
    Expect(0, 92927, '\P{Blk=  Bassa_Vah}', "");
    Expect(1, 92927, '\P{^Blk=  Bassa_Vah}', "");
    Expect(0, 92928, '\p{Blk=  Bassa_Vah}', "");
    Expect(1, 92928, '\p{^Blk=  Bassa_Vah}', "");
    Expect(1, 92928, '\P{Blk=  Bassa_Vah}', "");
    Expect(0, 92928, '\P{^Blk=  Bassa_Vah}', "");
    Error('\p{Is_Block=-BASSA_VAH/a/}');
    Error('\P{Is_Block=-BASSA_VAH/a/}');
    Expect(1, 92927, '\p{Is_Block=bassavah}', "");
    Expect(0, 92927, '\p{^Is_Block=bassavah}', "");
    Expect(0, 92927, '\P{Is_Block=bassavah}', "");
    Expect(1, 92927, '\P{^Is_Block=bassavah}', "");
    Expect(0, 92928, '\p{Is_Block=bassavah}', "");
    Expect(1, 92928, '\p{^Is_Block=bassavah}', "");
    Expect(1, 92928, '\P{Is_Block=bassavah}', "");
    Expect(0, 92928, '\P{^Is_Block=bassavah}', "");
    Expect(1, 92927, '\p{Is_Block=	 Bassa_Vah}', "");
    Expect(0, 92927, '\p{^Is_Block=	 Bassa_Vah}', "");
    Expect(0, 92927, '\P{Is_Block=	 Bassa_Vah}', "");
    Expect(1, 92927, '\P{^Is_Block=	 Bassa_Vah}', "");
    Expect(0, 92928, '\p{Is_Block=	 Bassa_Vah}', "");
    Expect(1, 92928, '\p{^Is_Block=	 Bassa_Vah}', "");
    Expect(1, 92928, '\P{Is_Block=	 Bassa_Vah}', "");
    Expect(0, 92928, '\P{^Is_Block=	 Bassa_Vah}', "");
    Error('\p{Is_Blk=/a/		Bassa_Vah}');
    Error('\P{Is_Blk=/a/		Bassa_Vah}');
    Expect(1, 92927, '\p{Is_Blk=bassavah}', "");
    Expect(0, 92927, '\p{^Is_Blk=bassavah}', "");
    Expect(0, 92927, '\P{Is_Blk=bassavah}', "");
    Expect(1, 92927, '\P{^Is_Blk=bassavah}', "");
    Expect(0, 92928, '\p{Is_Blk=bassavah}', "");
    Expect(1, 92928, '\p{^Is_Blk=bassavah}', "");
    Expect(1, 92928, '\P{Is_Blk=bassavah}', "");
    Expect(0, 92928, '\P{^Is_Blk=bassavah}', "");
    Expect(1, 92927, '\p{Is_Blk=_Bassa_Vah}', "");
    Expect(0, 92927, '\p{^Is_Blk=_Bassa_Vah}', "");
    Expect(0, 92927, '\P{Is_Blk=_Bassa_Vah}', "");
    Expect(1, 92927, '\P{^Is_Blk=_Bassa_Vah}', "");
    Expect(0, 92928, '\p{Is_Blk=_Bassa_Vah}', "");
    Expect(1, 92928, '\p{^Is_Blk=_Bassa_Vah}', "");
    Expect(1, 92928, '\P{Is_Blk=_Bassa_Vah}', "");
    Expect(0, 92928, '\P{^Is_Blk=_Bassa_Vah}', "");
    Error('\p{Block=/a/		BATAK}');
    Error('\P{Block=/a/		BATAK}');
    Expect(1, 7167, '\p{Block=:\ABatak\z:}', "");;
    Expect(0, 7168, '\p{Block=:\ABatak\z:}', "");;
    Expect(1, 7167, '\p{Block=batak}', "");
    Expect(0, 7167, '\p{^Block=batak}', "");
    Expect(0, 7167, '\P{Block=batak}', "");
    Expect(1, 7167, '\P{^Block=batak}', "");
    Expect(0, 7168, '\p{Block=batak}', "");
    Expect(1, 7168, '\p{^Block=batak}', "");
    Expect(1, 7168, '\P{Block=batak}', "");
    Expect(0, 7168, '\P{^Block=batak}', "");
    Expect(1, 7167, '\p{Block=:\Abatak\z:}', "");;
    Expect(0, 7168, '\p{Block=:\Abatak\z:}', "");;
    Expect(1, 7167, '\p{Block:   		BATAK}', "");
    Expect(0, 7167, '\p{^Block:   		BATAK}', "");
    Expect(0, 7167, '\P{Block:   		BATAK}', "");
    Expect(1, 7167, '\P{^Block:   		BATAK}', "");
    Expect(0, 7168, '\p{Block:   		BATAK}', "");
    Expect(1, 7168, '\p{^Block:   		BATAK}', "");
    Expect(1, 7168, '\P{Block:   		BATAK}', "");
    Expect(0, 7168, '\P{^Block:   		BATAK}', "");
    Error('\p{Blk=	Batak:=}');
    Error('\P{Blk=	Batak:=}');
    Expect(1, 7167, '\p{Blk=:\ABatak\z:}', "");;
    Expect(0, 7168, '\p{Blk=:\ABatak\z:}', "");;
    Expect(1, 7167, '\p{Blk=batak}', "");
    Expect(0, 7167, '\p{^Blk=batak}', "");
    Expect(0, 7167, '\P{Blk=batak}', "");
    Expect(1, 7167, '\P{^Blk=batak}', "");
    Expect(0, 7168, '\p{Blk=batak}', "");
    Expect(1, 7168, '\p{^Blk=batak}', "");
    Expect(1, 7168, '\P{Blk=batak}', "");
    Expect(0, 7168, '\P{^Blk=batak}', "");
    Expect(1, 7167, '\p{Blk=:\Abatak\z:}', "");;
    Expect(0, 7168, '\p{Blk=:\Abatak\z:}', "");;
    Expect(1, 7167, '\p{Blk:   -Batak}', "");
    Expect(0, 7167, '\p{^Blk:   -Batak}', "");
    Expect(0, 7167, '\P{Blk:   -Batak}', "");
    Expect(1, 7167, '\P{^Blk:   -Batak}', "");
    Expect(0, 7168, '\p{Blk:   -Batak}', "");
    Expect(1, 7168, '\p{^Blk:   -Batak}', "");
    Expect(1, 7168, '\P{Blk:   -Batak}', "");
    Expect(0, 7168, '\P{^Blk:   -Batak}', "");
    Error('\p{Is_Block:	-_batak:=}');
    Error('\P{Is_Block:	-_batak:=}');
    Expect(1, 7167, '\p{Is_Block=batak}', "");
    Expect(0, 7167, '\p{^Is_Block=batak}', "");
    Expect(0, 7167, '\P{Is_Block=batak}', "");
    Expect(1, 7167, '\P{^Is_Block=batak}', "");
    Expect(0, 7168, '\p{Is_Block=batak}', "");
    Expect(1, 7168, '\p{^Is_Block=batak}', "");
    Expect(1, 7168, '\P{Is_Block=batak}', "");
    Expect(0, 7168, '\P{^Is_Block=batak}', "");
    Expect(1, 7167, '\p{Is_Block=_Batak}', "");
    Expect(0, 7167, '\p{^Is_Block=_Batak}', "");
    Expect(0, 7167, '\P{Is_Block=_Batak}', "");
    Expect(1, 7167, '\P{^Is_Block=_Batak}', "");
    Expect(0, 7168, '\p{Is_Block=_Batak}', "");
    Expect(1, 7168, '\p{^Is_Block=_Batak}', "");
    Expect(1, 7168, '\P{Is_Block=_Batak}', "");
    Expect(0, 7168, '\P{^Is_Block=_Batak}', "");
    Error('\p{Is_Blk:/a/batak}');
    Error('\P{Is_Blk:/a/batak}');
    Expect(1, 7167, '\p{Is_Blk=batak}', "");
    Expect(0, 7167, '\p{^Is_Blk=batak}', "");
    Expect(0, 7167, '\P{Is_Blk=batak}', "");
    Expect(1, 7167, '\P{^Is_Blk=batak}', "");
    Expect(0, 7168, '\p{Is_Blk=batak}', "");
    Expect(1, 7168, '\p{^Is_Blk=batak}', "");
    Expect(1, 7168, '\P{Is_Blk=batak}', "");
    Expect(0, 7168, '\P{^Is_Blk=batak}', "");
    Expect(1, 7167, '\p{Is_Blk=	Batak}', "");
    Expect(0, 7167, '\p{^Is_Blk=	Batak}', "");
    Expect(0, 7167, '\P{Is_Blk=	Batak}', "");
    Expect(1, 7167, '\P{^Is_Blk=	Batak}', "");
    Expect(0, 7168, '\p{Is_Blk=	Batak}', "");
    Expect(1, 7168, '\p{^Is_Blk=	Batak}', "");
    Expect(1, 7168, '\P{Is_Blk=	Batak}', "");
    Expect(0, 7168, '\P{^Is_Blk=	Batak}', "");
    Error('\p{Block:-/a/Bengali}');
    Error('\P{Block:-/a/Bengali}');
    Expect(1, 2559, '\p{Block=:\ABengali\z:}', "");;
    Expect(0, 2560, '\p{Block=:\ABengali\z:}', "");;
    Expect(1, 2559, '\p{Block:   bengali}', "");
    Expect(0, 2559, '\p{^Block:   bengali}', "");
    Expect(0, 2559, '\P{Block:   bengali}', "");
    Expect(1, 2559, '\P{^Block:   bengali}', "");
    Expect(0, 2560, '\p{Block:   bengali}', "");
    Expect(1, 2560, '\p{^Block:   bengali}', "");
    Expect(1, 2560, '\P{Block:   bengali}', "");
    Expect(0, 2560, '\P{^Block:   bengali}', "");
    Expect(1, 2559, '\p{Block=:\Abengali\z:}', "");;
    Expect(0, 2560, '\p{Block=:\Abengali\z:}', "");;
    Expect(1, 2559, '\p{Block=__Bengali}', "");
    Expect(0, 2559, '\p{^Block=__Bengali}', "");
    Expect(0, 2559, '\P{Block=__Bengali}', "");
    Expect(1, 2559, '\P{^Block=__Bengali}', "");
    Expect(0, 2560, '\p{Block=__Bengali}', "");
    Expect(1, 2560, '\p{^Block=__Bengali}', "");
    Expect(1, 2560, '\P{Block=__Bengali}', "");
    Expect(0, 2560, '\P{^Block=__Bengali}', "");
    Error('\p{Blk=	:=bengali}');
    Error('\P{Blk=	:=bengali}');
    Expect(1, 2559, '\p{Blk=:\ABengali\z:}', "");;
    Expect(0, 2560, '\p{Blk=:\ABengali\z:}', "");;
    Expect(1, 2559, '\p{Blk=bengali}', "");
    Expect(0, 2559, '\p{^Blk=bengali}', "");
    Expect(0, 2559, '\P{Blk=bengali}', "");
    Expect(1, 2559, '\P{^Blk=bengali}', "");
    Expect(0, 2560, '\p{Blk=bengali}', "");
    Expect(1, 2560, '\p{^Blk=bengali}', "");
    Expect(1, 2560, '\P{Blk=bengali}', "");
    Expect(0, 2560, '\P{^Blk=bengali}', "");
    Expect(1, 2559, '\p{Blk=:\Abengali\z:}', "");;
    Expect(0, 2560, '\p{Blk=:\Abengali\z:}', "");;
    Expect(1, 2559, '\p{Blk=_-bengali}', "");
    Expect(0, 2559, '\p{^Blk=_-bengali}', "");
    Expect(0, 2559, '\P{Blk=_-bengali}', "");
    Expect(1, 2559, '\P{^Blk=_-bengali}', "");
    Expect(0, 2560, '\p{Blk=_-bengali}', "");
    Expect(1, 2560, '\p{^Blk=_-bengali}', "");
    Expect(1, 2560, '\P{Blk=_-bengali}', "");
    Expect(0, 2560, '\P{^Blk=_-bengali}', "");
    Error('\p{Is_Block=:= -bengali}');
    Error('\P{Is_Block=:= -bengali}');
    Expect(1, 2559, '\p{Is_Block=bengali}', "");
    Expect(0, 2559, '\p{^Is_Block=bengali}', "");
    Expect(0, 2559, '\P{Is_Block=bengali}', "");
    Expect(1, 2559, '\P{^Is_Block=bengali}', "");
    Expect(0, 2560, '\p{Is_Block=bengali}', "");
    Expect(1, 2560, '\p{^Is_Block=bengali}', "");
    Expect(1, 2560, '\P{Is_Block=bengali}', "");
    Expect(0, 2560, '\P{^Is_Block=bengali}', "");
    Expect(1, 2559, '\p{Is_Block:   -bengali}', "");
    Expect(0, 2559, '\p{^Is_Block:   -bengali}', "");
    Expect(0, 2559, '\P{Is_Block:   -bengali}', "");
    Expect(1, 2559, '\P{^Is_Block:   -bengali}', "");
    Expect(0, 2560, '\p{Is_Block:   -bengali}', "");
    Expect(1, 2560, '\p{^Is_Block:   -bengali}', "");
    Expect(1, 2560, '\P{Is_Block:   -bengali}', "");
    Expect(0, 2560, '\P{^Is_Block:   -bengali}', "");
    Error('\p{Is_Blk=:=- Bengali}');
    Error('\P{Is_Blk=:=- Bengali}');
    Expect(1, 2559, '\p{Is_Blk:	bengali}', "");
    Expect(0, 2559, '\p{^Is_Blk:	bengali}', "");
    Expect(0, 2559, '\P{Is_Blk:	bengali}', "");
    Expect(1, 2559, '\P{^Is_Blk:	bengali}', "");
    Expect(0, 2560, '\p{Is_Blk:	bengali}', "");
    Expect(1, 2560, '\p{^Is_Blk:	bengali}', "");
    Expect(1, 2560, '\P{Is_Blk:	bengali}', "");
    Expect(0, 2560, '\P{^Is_Blk:	bengali}', "");
    Expect(1, 2559, '\p{Is_Blk=	Bengali}', "");
    Expect(0, 2559, '\p{^Is_Blk=	Bengali}', "");
    Expect(0, 2559, '\P{Is_Blk=	Bengali}', "");
    Expect(1, 2559, '\P{^Is_Blk=	Bengali}', "");
    Expect(0, 2560, '\p{Is_Blk=	Bengali}', "");
    Expect(1, 2560, '\p{^Is_Blk=	Bengali}', "");
    Expect(1, 2560, '\P{Is_Blk=	Bengali}', "");
    Expect(0, 2560, '\P{^Is_Blk=	Bengali}', "");
    Error('\p{Block=/a/ BHAIKSUKI}');
    Error('\P{Block=/a/ BHAIKSUKI}');
    Expect(1, 72815, '\p{Block=:\ABhaiksuki\z:}', "");;
    Expect(0, 72816, '\p{Block=:\ABhaiksuki\z:}', "");;
    Expect(1, 72815, '\p{Block=bhaiksuki}', "");
    Expect(0, 72815, '\p{^Block=bhaiksuki}', "");
    Expect(0, 72815, '\P{Block=bhaiksuki}', "");
    Expect(1, 72815, '\P{^Block=bhaiksuki}', "");
    Expect(0, 72816, '\p{Block=bhaiksuki}', "");
    Expect(1, 72816, '\p{^Block=bhaiksuki}', "");
    Expect(1, 72816, '\P{Block=bhaiksuki}', "");
    Expect(0, 72816, '\P{^Block=bhaiksuki}', "");
    Expect(1, 72815, '\p{Block=:\Abhaiksuki\z:}', "");;
    Expect(0, 72816, '\p{Block=:\Abhaiksuki\z:}', "");;
    Expect(1, 72815, '\p{Block:			Bhaiksuki}', "");
    Expect(0, 72815, '\p{^Block:			Bhaiksuki}', "");
    Expect(0, 72815, '\P{Block:			Bhaiksuki}', "");
    Expect(1, 72815, '\P{^Block:			Bhaiksuki}', "");
    Expect(0, 72816, '\p{Block:			Bhaiksuki}', "");
    Expect(1, 72816, '\p{^Block:			Bhaiksuki}', "");
    Expect(1, 72816, '\P{Block:			Bhaiksuki}', "");
    Expect(0, 72816, '\P{^Block:			Bhaiksuki}', "");
    Error('\p{Blk=/a/	_BHAIKSUKI}');
    Error('\P{Blk=/a/	_BHAIKSUKI}');
    Expect(1, 72815, '\p{Blk=:\ABhaiksuki\z:}', "");;
    Expect(0, 72816, '\p{Blk=:\ABhaiksuki\z:}', "");;
    Expect(1, 72815, '\p{Blk=bhaiksuki}', "");
    Expect(0, 72815, '\p{^Blk=bhaiksuki}', "");
    Expect(0, 72815, '\P{Blk=bhaiksuki}', "");
    Expect(1, 72815, '\P{^Blk=bhaiksuki}', "");
    Expect(0, 72816, '\p{Blk=bhaiksuki}', "");
    Expect(1, 72816, '\p{^Blk=bhaiksuki}', "");
    Expect(1, 72816, '\P{Blk=bhaiksuki}', "");
    Expect(0, 72816, '\P{^Blk=bhaiksuki}', "");
    Expect(1, 72815, '\p{Blk=:\Abhaiksuki\z:}', "");;
    Expect(0, 72816, '\p{Blk=:\Abhaiksuki\z:}', "");;
    Expect(1, 72815, '\p{Blk=--Bhaiksuki}', "");
    Expect(0, 72815, '\p{^Blk=--Bhaiksuki}', "");
    Expect(0, 72815, '\P{Blk=--Bhaiksuki}', "");
    Expect(1, 72815, '\P{^Blk=--Bhaiksuki}', "");
    Expect(0, 72816, '\p{Blk=--Bhaiksuki}', "");
    Expect(1, 72816, '\p{^Blk=--Bhaiksuki}', "");
    Expect(1, 72816, '\P{Blk=--Bhaiksuki}', "");
    Expect(0, 72816, '\P{^Blk=--Bhaiksuki}', "");
    Error('\p{Is_Block=:=Bhaiksuki}');
    Error('\P{Is_Block=:=Bhaiksuki}');
    Expect(1, 72815, '\p{Is_Block=bhaiksuki}', "");
    Expect(0, 72815, '\p{^Is_Block=bhaiksuki}', "");
    Expect(0, 72815, '\P{Is_Block=bhaiksuki}', "");
    Expect(1, 72815, '\P{^Is_Block=bhaiksuki}', "");
    Expect(0, 72816, '\p{Is_Block=bhaiksuki}', "");
    Expect(1, 72816, '\p{^Is_Block=bhaiksuki}', "");
    Expect(1, 72816, '\P{Is_Block=bhaiksuki}', "");
    Expect(0, 72816, '\P{^Is_Block=bhaiksuki}', "");
    Expect(1, 72815, '\p{Is_Block=_	Bhaiksuki}', "");
    Expect(0, 72815, '\p{^Is_Block=_	Bhaiksuki}', "");
    Expect(0, 72815, '\P{Is_Block=_	Bhaiksuki}', "");
    Expect(1, 72815, '\P{^Is_Block=_	Bhaiksuki}', "");
    Expect(0, 72816, '\p{Is_Block=_	Bhaiksuki}', "");
    Expect(1, 72816, '\p{^Is_Block=_	Bhaiksuki}', "");
    Expect(1, 72816, '\P{Is_Block=_	Bhaiksuki}', "");
    Expect(0, 72816, '\P{^Is_Block=_	Bhaiksuki}', "");
    Error('\p{Is_Blk:/a/  Bhaiksuki}');
    Error('\P{Is_Blk:/a/  Bhaiksuki}');
    Expect(1, 72815, '\p{Is_Blk=bhaiksuki}', "");
    Expect(0, 72815, '\p{^Is_Blk=bhaiksuki}', "");
    Expect(0, 72815, '\P{Is_Blk=bhaiksuki}', "");
    Expect(1, 72815, '\P{^Is_Blk=bhaiksuki}', "");
    Expect(0, 72816, '\p{Is_Blk=bhaiksuki}', "");
    Expect(1, 72816, '\p{^Is_Blk=bhaiksuki}', "");
    Expect(1, 72816, '\P{Is_Blk=bhaiksuki}', "");
    Expect(0, 72816, '\P{^Is_Blk=bhaiksuki}', "");
    Expect(1, 72815, '\p{Is_Blk=	-Bhaiksuki}', "");
    Expect(0, 72815, '\p{^Is_Blk=	-Bhaiksuki}', "");
    Expect(0, 72815, '\P{Is_Blk=	-Bhaiksuki}', "");
    Expect(1, 72815, '\P{^Is_Blk=	-Bhaiksuki}', "");
    Expect(0, 72816, '\p{Is_Blk=	-Bhaiksuki}', "");
    Expect(1, 72816, '\p{^Is_Blk=	-Bhaiksuki}', "");
    Expect(1, 72816, '\P{Is_Blk=	-Bhaiksuki}', "");
    Expect(0, 72816, '\P{^Is_Blk=	-Bhaiksuki}', "");
    Error('\p{Block=:=_	Block_Elements}');
    Error('\P{Block=:=_	Block_Elements}');
    Expect(1, 9631, '\p{Block=:\ABlock_Elements\z:}', "");;
    Expect(0, 9632, '\p{Block=:\ABlock_Elements\z:}', "");;
    Expect(1, 9631, '\p{Block:blockelements}', "");
    Expect(0, 9631, '\p{^Block:blockelements}', "");
    Expect(0, 9631, '\P{Block:blockelements}', "");
    Expect(1, 9631, '\P{^Block:blockelements}', "");
    Expect(0, 9632, '\p{Block:blockelements}', "");
    Expect(1, 9632, '\p{^Block:blockelements}', "");
    Expect(1, 9632, '\P{Block:blockelements}', "");
    Expect(0, 9632, '\P{^Block:blockelements}', "");
    Expect(1, 9631, '\p{Block=:\Ablockelements\z:}', "");;
    Expect(0, 9632, '\p{Block=:\Ablockelements\z:}', "");;
    Expect(1, 9631, '\p{Block:  BLOCK_elements}', "");
    Expect(0, 9631, '\p{^Block:  BLOCK_elements}', "");
    Expect(0, 9631, '\P{Block:  BLOCK_elements}', "");
    Expect(1, 9631, '\P{^Block:  BLOCK_elements}', "");
    Expect(0, 9632, '\p{Block:  BLOCK_elements}', "");
    Expect(1, 9632, '\p{^Block:  BLOCK_elements}', "");
    Expect(1, 9632, '\P{Block:  BLOCK_elements}', "");
    Expect(0, 9632, '\P{^Block:  BLOCK_elements}', "");
    Error('\p{Blk=_:=BLOCK_elements}');
    Error('\P{Blk=_:=BLOCK_elements}');
    Expect(1, 9631, '\p{Blk=:\ABlock_Elements\z:}', "");;
    Expect(0, 9632, '\p{Blk=:\ABlock_Elements\z:}', "");;
    Expect(1, 9631, '\p{Blk:	blockelements}', "");
    Expect(0, 9631, '\p{^Blk:	blockelements}', "");
    Expect(0, 9631, '\P{Blk:	blockelements}', "");
    Expect(1, 9631, '\P{^Blk:	blockelements}', "");
    Expect(0, 9632, '\p{Blk:	blockelements}', "");
    Expect(1, 9632, '\p{^Blk:	blockelements}', "");
    Expect(1, 9632, '\P{Blk:	blockelements}', "");
    Expect(0, 9632, '\P{^Blk:	blockelements}', "");
    Expect(1, 9631, '\p{Blk=:\Ablockelements\z:}', "");;
    Expect(0, 9632, '\p{Blk=:\Ablockelements\z:}', "");;
    Expect(1, 9631, '\p{Blk=	_Block_elements}', "");
    Expect(0, 9631, '\p{^Blk=	_Block_elements}', "");
    Expect(0, 9631, '\P{Blk=	_Block_elements}', "");
    Expect(1, 9631, '\P{^Blk=	_Block_elements}', "");
    Expect(0, 9632, '\p{Blk=	_Block_elements}', "");
    Expect(1, 9632, '\p{^Blk=	_Block_elements}', "");
    Expect(1, 9632, '\P{Blk=	_Block_elements}', "");
    Expect(0, 9632, '\P{^Blk=	_Block_elements}', "");
    Error('\p{Is_Block=	 BLOCK_Elements:=}');
    Error('\P{Is_Block=	 BLOCK_Elements:=}');
    Expect(1, 9631, '\p{Is_Block=blockelements}', "");
    Expect(0, 9631, '\p{^Is_Block=blockelements}', "");
    Expect(0, 9631, '\P{Is_Block=blockelements}', "");
    Expect(1, 9631, '\P{^Is_Block=blockelements}', "");
    Expect(0, 9632, '\p{Is_Block=blockelements}', "");
    Expect(1, 9632, '\p{^Is_Block=blockelements}', "");
    Expect(1, 9632, '\P{Is_Block=blockelements}', "");
    Expect(0, 9632, '\P{^Is_Block=blockelements}', "");
    Expect(1, 9631, '\p{Is_Block=BLOCK_Elements}', "");
    Expect(0, 9631, '\p{^Is_Block=BLOCK_Elements}', "");
    Expect(0, 9631, '\P{Is_Block=BLOCK_Elements}', "");
    Expect(1, 9631, '\P{^Is_Block=BLOCK_Elements}', "");
    Expect(0, 9632, '\p{Is_Block=BLOCK_Elements}', "");
    Expect(1, 9632, '\p{^Is_Block=BLOCK_Elements}', "");
    Expect(1, 9632, '\P{Is_Block=BLOCK_Elements}', "");
    Expect(0, 9632, '\P{^Is_Block=BLOCK_Elements}', "");
    Error('\p{Is_Blk=	:=Block_Elements}');
    Error('\P{Is_Blk=	:=Block_Elements}');
    Expect(1, 9631, '\p{Is_Blk=blockelements}', "");
    Expect(0, 9631, '\p{^Is_Blk=blockelements}', "");
    Expect(0, 9631, '\P{Is_Blk=blockelements}', "");
    Expect(1, 9631, '\P{^Is_Blk=blockelements}', "");
    Expect(0, 9632, '\p{Is_Blk=blockelements}', "");
    Expect(1, 9632, '\p{^Is_Blk=blockelements}', "");
    Expect(1, 9632, '\P{Is_Blk=blockelements}', "");
    Expect(0, 9632, '\P{^Is_Blk=blockelements}', "");
    Expect(1, 9631, '\p{Is_Blk=- Block_Elements}', "");
    Expect(0, 9631, '\p{^Is_Blk=- Block_Elements}', "");
    Expect(0, 9631, '\P{Is_Blk=- Block_Elements}', "");
    Expect(1, 9631, '\P{^Is_Blk=- Block_Elements}', "");
    Expect(0, 9632, '\p{Is_Blk=- Block_Elements}', "");
    Expect(1, 9632, '\p{^Is_Blk=- Block_Elements}', "");
    Expect(1, 9632, '\P{Is_Blk=- Block_Elements}', "");
    Expect(0, 9632, '\P{^Is_Blk=- Block_Elements}', "");
    Error('\p{Block=  Bopomofo:=}');
    Error('\P{Block=  Bopomofo:=}');
    Expect(1, 12591, '\p{Block=:\ABopomofo\z:}', "");;
    Expect(0, 12592, '\p{Block=:\ABopomofo\z:}', "");;
    Expect(1, 12591, '\p{Block:	bopomofo}', "");
    Expect(0, 12591, '\p{^Block:	bopomofo}', "");
    Expect(0, 12591, '\P{Block:	bopomofo}', "");
    Expect(1, 12591, '\P{^Block:	bopomofo}', "");
    Expect(0, 12592, '\p{Block:	bopomofo}', "");
    Expect(1, 12592, '\p{^Block:	bopomofo}', "");
    Expect(1, 12592, '\P{Block:	bopomofo}', "");
    Expect(0, 12592, '\P{^Block:	bopomofo}', "");
    Expect(1, 12591, '\p{Block=:\Abopomofo\z:}', "");;
    Expect(0, 12592, '\p{Block=:\Abopomofo\z:}', "");;
    Expect(1, 12591, '\p{Block=	BOPOMOFO}', "");
    Expect(0, 12591, '\p{^Block=	BOPOMOFO}', "");
    Expect(0, 12591, '\P{Block=	BOPOMOFO}', "");
    Expect(1, 12591, '\P{^Block=	BOPOMOFO}', "");
    Expect(0, 12592, '\p{Block=	BOPOMOFO}', "");
    Expect(1, 12592, '\p{^Block=	BOPOMOFO}', "");
    Expect(1, 12592, '\P{Block=	BOPOMOFO}', "");
    Expect(0, 12592, '\P{^Block=	BOPOMOFO}', "");
    Error('\p{Blk=	-bopomofo:=}');
    Error('\P{Blk=	-bopomofo:=}');
    Expect(1, 12591, '\p{Blk=:\ABopomofo\z:}', "");;
    Expect(0, 12592, '\p{Blk=:\ABopomofo\z:}', "");;
    Expect(1, 12591, '\p{Blk=bopomofo}', "");
    Expect(0, 12591, '\p{^Blk=bopomofo}', "");
    Expect(0, 12591, '\P{Blk=bopomofo}', "");
    Expect(1, 12591, '\P{^Blk=bopomofo}', "");
    Expect(0, 12592, '\p{Blk=bopomofo}', "");
    Expect(1, 12592, '\p{^Blk=bopomofo}', "");
    Expect(1, 12592, '\P{Blk=bopomofo}', "");
    Expect(0, 12592, '\P{^Blk=bopomofo}', "");
    Expect(1, 12591, '\p{Blk=:\Abopomofo\z:}', "");;
    Expect(0, 12592, '\p{Blk=:\Abopomofo\z:}', "");;
    Expect(1, 12591, '\p{Blk=	bopomofo}', "");
    Expect(0, 12591, '\p{^Blk=	bopomofo}', "");
    Expect(0, 12591, '\P{Blk=	bopomofo}', "");
    Expect(1, 12591, '\P{^Blk=	bopomofo}', "");
    Expect(0, 12592, '\p{Blk=	bopomofo}', "");
    Expect(1, 12592, '\p{^Blk=	bopomofo}', "");
    Expect(1, 12592, '\P{Blk=	bopomofo}', "");
    Expect(0, 12592, '\P{^Blk=	bopomofo}', "");
    Error('\p{Is_Block:	/a/Bopomofo}');
    Error('\P{Is_Block:	/a/Bopomofo}');
    Expect(1, 12591, '\p{Is_Block=bopomofo}', "");
    Expect(0, 12591, '\p{^Is_Block=bopomofo}', "");
    Expect(0, 12591, '\P{Is_Block=bopomofo}', "");
    Expect(1, 12591, '\P{^Is_Block=bopomofo}', "");
    Expect(0, 12592, '\p{Is_Block=bopomofo}', "");
    Expect(1, 12592, '\p{^Is_Block=bopomofo}', "");
    Expect(1, 12592, '\P{Is_Block=bopomofo}', "");
    Expect(0, 12592, '\P{^Is_Block=bopomofo}', "");
    Expect(1, 12591, '\p{Is_Block= _bopomofo}', "");
    Expect(0, 12591, '\p{^Is_Block= _bopomofo}', "");
    Expect(0, 12591, '\P{Is_Block= _bopomofo}', "");
    Expect(1, 12591, '\P{^Is_Block= _bopomofo}', "");
    Expect(0, 12592, '\p{Is_Block= _bopomofo}', "");
    Expect(1, 12592, '\p{^Is_Block= _bopomofo}', "");
    Expect(1, 12592, '\P{Is_Block= _bopomofo}', "");
    Expect(0, 12592, '\P{^Is_Block= _bopomofo}', "");
    Error('\p{Is_Blk=:=_-bopomofo}');
    Error('\P{Is_Blk=:=_-bopomofo}');
    Expect(1, 12591, '\p{Is_Blk=bopomofo}', "");
    Expect(0, 12591, '\p{^Is_Blk=bopomofo}', "");
    Expect(0, 12591, '\P{Is_Blk=bopomofo}', "");
    Expect(1, 12591, '\P{^Is_Blk=bopomofo}', "");
    Expect(0, 12592, '\p{Is_Blk=bopomofo}', "");
    Expect(1, 12592, '\p{^Is_Blk=bopomofo}', "");
    Expect(1, 12592, '\P{Is_Blk=bopomofo}', "");
    Expect(0, 12592, '\P{^Is_Blk=bopomofo}', "");
    Expect(1, 12591, '\p{Is_Blk=	_bopomofo}', "");
    Expect(0, 12591, '\p{^Is_Blk=	_bopomofo}', "");
    Expect(0, 12591, '\P{Is_Blk=	_bopomofo}', "");
    Expect(1, 12591, '\P{^Is_Blk=	_bopomofo}', "");
    Expect(0, 12592, '\p{Is_Blk=	_bopomofo}', "");
    Expect(1, 12592, '\p{^Is_Blk=	_bopomofo}', "");
    Expect(1, 12592, '\P{Is_Blk=	_bopomofo}', "");
    Expect(0, 12592, '\P{^Is_Blk=	_bopomofo}', "");
    Error('\p{Block=/a/bopomofo_EXTENDED}');
    Error('\P{Block=/a/bopomofo_EXTENDED}');
    Expect(1, 12735, '\p{Block=:\ABopomofo_Extended\z:}', "");;
    Expect(0, 12736, '\p{Block=:\ABopomofo_Extended\z:}', "");;
    Expect(1, 12735, '\p{Block=bopomofoextended}', "");
    Expect(0, 12735, '\p{^Block=bopomofoextended}', "");
    Expect(0, 12735, '\P{Block=bopomofoextended}', "");
    Expect(1, 12735, '\P{^Block=bopomofoextended}', "");
    Expect(0, 12736, '\p{Block=bopomofoextended}', "");
    Expect(1, 12736, '\p{^Block=bopomofoextended}', "");
    Expect(1, 12736, '\P{Block=bopomofoextended}', "");
    Expect(0, 12736, '\P{^Block=bopomofoextended}', "");
    Expect(1, 12735, '\p{Block=:\Abopomofoextended\z:}', "");;
    Expect(0, 12736, '\p{Block=:\Abopomofoextended\z:}', "");;
    Expect(1, 12735, '\p{Block=-Bopomofo_Extended}', "");
    Expect(0, 12735, '\p{^Block=-Bopomofo_Extended}', "");
    Expect(0, 12735, '\P{Block=-Bopomofo_Extended}', "");
    Expect(1, 12735, '\P{^Block=-Bopomofo_Extended}', "");
    Expect(0, 12736, '\p{Block=-Bopomofo_Extended}', "");
    Expect(1, 12736, '\p{^Block=-Bopomofo_Extended}', "");
    Expect(1, 12736, '\P{Block=-Bopomofo_Extended}', "");
    Expect(0, 12736, '\P{^Block=-Bopomofo_Extended}', "");
    Error('\p{Blk:	_/a/bopomofo_ext}');
    Error('\P{Blk:	_/a/bopomofo_ext}');
    Expect(1, 12735, '\p{Blk=:\ABopomofo_Ext\z:}', "");;
    Expect(0, 12736, '\p{Blk=:\ABopomofo_Ext\z:}', "");;
    Expect(1, 12735, '\p{Blk=bopomofoext}', "");
    Expect(0, 12735, '\p{^Blk=bopomofoext}', "");
    Expect(0, 12735, '\P{Blk=bopomofoext}', "");
    Expect(1, 12735, '\P{^Blk=bopomofoext}', "");
    Expect(0, 12736, '\p{Blk=bopomofoext}', "");
    Expect(1, 12736, '\p{^Blk=bopomofoext}', "");
    Expect(1, 12736, '\P{Blk=bopomofoext}', "");
    Expect(0, 12736, '\P{^Blk=bopomofoext}', "");
    Expect(1, 12735, '\p{Blk=:\Abopomofoext\z:}', "");;
    Expect(0, 12736, '\p{Blk=:\Abopomofoext\z:}', "");;
    Expect(1, 12735, '\p{Blk=_-Bopomofo_Ext}', "");
    Expect(0, 12735, '\p{^Blk=_-Bopomofo_Ext}', "");
    Expect(0, 12735, '\P{Blk=_-Bopomofo_Ext}', "");
    Expect(1, 12735, '\P{^Blk=_-Bopomofo_Ext}', "");
    Expect(0, 12736, '\p{Blk=_-Bopomofo_Ext}', "");
    Expect(1, 12736, '\p{^Blk=_-Bopomofo_Ext}', "");
    Expect(1, 12736, '\P{Blk=_-Bopomofo_Ext}', "");
    Expect(0, 12736, '\P{^Blk=_-Bopomofo_Ext}', "");
    Error('\p{Is_Block=:=Bopomofo_extended}');
    Error('\P{Is_Block=:=Bopomofo_extended}');
    Expect(1, 12735, '\p{Is_Block=bopomofoextended}', "");
    Expect(0, 12735, '\p{^Is_Block=bopomofoextended}', "");
    Expect(0, 12735, '\P{Is_Block=bopomofoextended}', "");
    Expect(1, 12735, '\P{^Is_Block=bopomofoextended}', "");
    Expect(0, 12736, '\p{Is_Block=bopomofoextended}', "");
    Expect(1, 12736, '\p{^Is_Block=bopomofoextended}', "");
    Expect(1, 12736, '\P{Is_Block=bopomofoextended}', "");
    Expect(0, 12736, '\P{^Is_Block=bopomofoextended}', "");
    Expect(1, 12735, '\p{Is_Block=	_bopomofo_EXTENDED}', "");
    Expect(0, 12735, '\p{^Is_Block=	_bopomofo_EXTENDED}', "");
    Expect(0, 12735, '\P{Is_Block=	_bopomofo_EXTENDED}', "");
    Expect(1, 12735, '\P{^Is_Block=	_bopomofo_EXTENDED}', "");
    Expect(0, 12736, '\p{Is_Block=	_bopomofo_EXTENDED}', "");
    Expect(1, 12736, '\p{^Is_Block=	_bopomofo_EXTENDED}', "");
    Expect(1, 12736, '\P{Is_Block=	_bopomofo_EXTENDED}', "");
    Expect(0, 12736, '\P{^Is_Block=	_bopomofo_EXTENDED}', "");
    Error('\p{Is_Blk=/a/-bopomofo_EXT}');
    Error('\P{Is_Blk=/a/-bopomofo_EXT}');
    Expect(1, 12735, '\p{Is_Blk=bopomofoext}', "");
    Expect(0, 12735, '\p{^Is_Blk=bopomofoext}', "");
    Expect(0, 12735, '\P{Is_Blk=bopomofoext}', "");
    Expect(1, 12735, '\P{^Is_Blk=bopomofoext}', "");
    Expect(0, 12736, '\p{Is_Blk=bopomofoext}', "");
    Expect(1, 12736, '\p{^Is_Blk=bopomofoext}', "");
    Expect(1, 12736, '\P{Is_Blk=bopomofoext}', "");
    Expect(0, 12736, '\P{^Is_Blk=bopomofoext}', "");
    Expect(1, 12735, '\p{Is_Blk=-	Bopomofo_Ext}', "");
    Expect(0, 12735, '\p{^Is_Blk=-	Bopomofo_Ext}', "");
    Expect(0, 12735, '\P{Is_Blk=-	Bopomofo_Ext}', "");
    Expect(1, 12735, '\P{^Is_Blk=-	Bopomofo_Ext}', "");
    Expect(0, 12736, '\p{Is_Blk=-	Bopomofo_Ext}', "");
    Expect(1, 12736, '\p{^Is_Blk=-	Bopomofo_Ext}', "");
    Expect(1, 12736, '\P{Is_Blk=-	Bopomofo_Ext}', "");
    Expect(0, 12736, '\P{^Is_Blk=-	Bopomofo_Ext}', "");
    Error('\p{Block=:=-Box_drawing}');
    Error('\P{Block=:=-Box_drawing}');
    Expect(1, 9599, '\p{Block=:\ABox_Drawing\z:}', "");;
    Expect(0, 9600, '\p{Block=:\ABox_Drawing\z:}', "");;
    Expect(1, 9599, '\p{Block=boxdrawing}', "");
    Expect(0, 9599, '\p{^Block=boxdrawing}', "");
    Expect(0, 9599, '\P{Block=boxdrawing}', "");
    Expect(1, 9599, '\P{^Block=boxdrawing}', "");
    Expect(0, 9600, '\p{Block=boxdrawing}', "");
    Expect(1, 9600, '\p{^Block=boxdrawing}', "");
    Expect(1, 9600, '\P{Block=boxdrawing}', "");
    Expect(0, 9600, '\P{^Block=boxdrawing}', "");
    Expect(1, 9599, '\p{Block=:\Aboxdrawing\z:}', "");;
    Expect(0, 9600, '\p{Block=:\Aboxdrawing\z:}', "");;
    Expect(1, 9599, '\p{Block=_-Box_Drawing}', "");
    Expect(0, 9599, '\p{^Block=_-Box_Drawing}', "");
    Expect(0, 9599, '\P{Block=_-Box_Drawing}', "");
    Expect(1, 9599, '\P{^Block=_-Box_Drawing}', "");
    Expect(0, 9600, '\p{Block=_-Box_Drawing}', "");
    Expect(1, 9600, '\p{^Block=_-Box_Drawing}', "");
    Expect(1, 9600, '\P{Block=_-Box_Drawing}', "");
    Expect(0, 9600, '\P{^Block=_-Box_Drawing}', "");
    Error('\p{Blk=:=_	Box_Drawing}');
    Error('\P{Blk=:=_	Box_Drawing}');
    Expect(1, 9599, '\p{Blk=:\ABox_Drawing\z:}', "");;
    Expect(0, 9600, '\p{Blk=:\ABox_Drawing\z:}', "");;
    Expect(1, 9599, '\p{Blk=boxdrawing}', "");
    Expect(0, 9599, '\p{^Blk=boxdrawing}', "");
    Expect(0, 9599, '\P{Blk=boxdrawing}', "");
    Expect(1, 9599, '\P{^Blk=boxdrawing}', "");
    Expect(0, 9600, '\p{Blk=boxdrawing}', "");
    Expect(1, 9600, '\p{^Blk=boxdrawing}', "");
    Expect(1, 9600, '\P{Blk=boxdrawing}', "");
    Expect(0, 9600, '\P{^Blk=boxdrawing}', "");
    Expect(1, 9599, '\p{Blk=:\Aboxdrawing\z:}', "");;
    Expect(0, 9600, '\p{Blk=:\Aboxdrawing\z:}', "");;
    Expect(1, 9599, '\p{Blk=-Box_DRAWING}', "");
    Expect(0, 9599, '\p{^Blk=-Box_DRAWING}', "");
    Expect(0, 9599, '\P{Blk=-Box_DRAWING}', "");
    Expect(1, 9599, '\P{^Blk=-Box_DRAWING}', "");
    Expect(0, 9600, '\p{Blk=-Box_DRAWING}', "");
    Expect(1, 9600, '\p{^Blk=-Box_DRAWING}', "");
    Expect(1, 9600, '\P{Blk=-Box_DRAWING}', "");
    Expect(0, 9600, '\P{^Blk=-Box_DRAWING}', "");
    Error('\p{Is_Block=	:=Box_drawing}');
    Error('\P{Is_Block=	:=Box_drawing}');
    Expect(1, 9599, '\p{Is_Block:   boxdrawing}', "");
    Expect(0, 9599, '\p{^Is_Block:   boxdrawing}', "");
    Expect(0, 9599, '\P{Is_Block:   boxdrawing}', "");
    Expect(1, 9599, '\P{^Is_Block:   boxdrawing}', "");
    Expect(0, 9600, '\p{Is_Block:   boxdrawing}', "");
    Expect(1, 9600, '\p{^Is_Block:   boxdrawing}', "");
    Expect(1, 9600, '\P{Is_Block:   boxdrawing}', "");
    Expect(0, 9600, '\P{^Is_Block:   boxdrawing}', "");
    Expect(1, 9599, '\p{Is_Block:  -box_Drawing}', "");
    Expect(0, 9599, '\p{^Is_Block:  -box_Drawing}', "");
    Expect(0, 9599, '\P{Is_Block:  -box_Drawing}', "");
    Expect(1, 9599, '\P{^Is_Block:  -box_Drawing}', "");
    Expect(0, 9600, '\p{Is_Block:  -box_Drawing}', "");
    Expect(1, 9600, '\p{^Is_Block:  -box_Drawing}', "");
    Expect(1, 9600, '\P{Is_Block:  -box_Drawing}', "");
    Expect(0, 9600, '\P{^Is_Block:  -box_Drawing}', "");
    Error('\p{Is_Blk=_ BOX_drawing:=}');
    Error('\P{Is_Blk=_ BOX_drawing:=}');
    Expect(1, 9599, '\p{Is_Blk=boxdrawing}', "");
    Expect(0, 9599, '\p{^Is_Blk=boxdrawing}', "");
    Expect(0, 9599, '\P{Is_Blk=boxdrawing}', "");
    Expect(1, 9599, '\P{^Is_Blk=boxdrawing}', "");
    Expect(0, 9600, '\p{Is_Blk=boxdrawing}', "");
    Expect(1, 9600, '\p{^Is_Blk=boxdrawing}', "");
    Expect(1, 9600, '\P{Is_Blk=boxdrawing}', "");
    Expect(0, 9600, '\P{^Is_Blk=boxdrawing}', "");
    Expect(1, 9599, '\p{Is_Blk=-_box_DRAWING}', "");
    Expect(0, 9599, '\p{^Is_Blk=-_box_DRAWING}', "");
    Expect(0, 9599, '\P{Is_Blk=-_box_DRAWING}', "");
    Expect(1, 9599, '\P{^Is_Blk=-_box_DRAWING}', "");
    Expect(0, 9600, '\p{Is_Blk=-_box_DRAWING}', "");
    Expect(1, 9600, '\p{^Is_Blk=-_box_DRAWING}', "");
    Expect(1, 9600, '\P{Is_Blk=-_box_DRAWING}', "");
    Expect(0, 9600, '\P{^Is_Blk=-_box_DRAWING}', "");
    Error('\p{Block=_:=BRAHMI}');
    Error('\P{Block=_:=BRAHMI}');
    Expect(1, 69759, '\p{Block=:\ABrahmi\z:}', "");;
    Expect(0, 69760, '\p{Block=:\ABrahmi\z:}', "");;
    Expect(1, 69759, '\p{Block=brahmi}', "");
    Expect(0, 69759, '\p{^Block=brahmi}', "");
    Expect(0, 69759, '\P{Block=brahmi}', "");
    Expect(1, 69759, '\P{^Block=brahmi}', "");
    Expect(0, 69760, '\p{Block=brahmi}', "");
    Expect(1, 69760, '\p{^Block=brahmi}', "");
    Expect(1, 69760, '\P{Block=brahmi}', "");
    Expect(0, 69760, '\P{^Block=brahmi}', "");
    Expect(1, 69759, '\p{Block=:\Abrahmi\z:}', "");;
    Expect(0, 69760, '\p{Block=:\Abrahmi\z:}', "");;
    Expect(1, 69759, '\p{Block=_	brahmi}', "");
    Expect(0, 69759, '\p{^Block=_	brahmi}', "");
    Expect(0, 69759, '\P{Block=_	brahmi}', "");
    Expect(1, 69759, '\P{^Block=_	brahmi}', "");
    Expect(0, 69760, '\p{Block=_	brahmi}', "");
    Expect(1, 69760, '\p{^Block=_	brahmi}', "");
    Expect(1, 69760, '\P{Block=_	brahmi}', "");
    Expect(0, 69760, '\P{^Block=_	brahmi}', "");
    Error('\p{Blk=-:=Brahmi}');
    Error('\P{Blk=-:=Brahmi}');
    Expect(1, 69759, '\p{Blk=:\ABrahmi\z:}', "");;
    Expect(0, 69760, '\p{Blk=:\ABrahmi\z:}', "");;
    Expect(1, 69759, '\p{Blk:brahmi}', "");
    Expect(0, 69759, '\p{^Blk:brahmi}', "");
    Expect(0, 69759, '\P{Blk:brahmi}', "");
    Expect(1, 69759, '\P{^Blk:brahmi}', "");
    Expect(0, 69760, '\p{Blk:brahmi}', "");
    Expect(1, 69760, '\p{^Blk:brahmi}', "");
    Expect(1, 69760, '\P{Blk:brahmi}', "");
    Expect(0, 69760, '\P{^Blk:brahmi}', "");
    Expect(1, 69759, '\p{Blk=:\Abrahmi\z:}', "");;
    Expect(0, 69760, '\p{Blk=:\Abrahmi\z:}', "");;
    Expect(1, 69759, '\p{Blk=--Brahmi}', "");
    Expect(0, 69759, '\p{^Blk=--Brahmi}', "");
    Expect(0, 69759, '\P{Blk=--Brahmi}', "");
    Expect(1, 69759, '\P{^Blk=--Brahmi}', "");
    Expect(0, 69760, '\p{Blk=--Brahmi}', "");
    Expect(1, 69760, '\p{^Blk=--Brahmi}', "");
    Expect(1, 69760, '\P{Blk=--Brahmi}', "");
    Expect(0, 69760, '\P{^Blk=--Brahmi}', "");
    Error('\p{Is_Block=_:=BRAHMI}');
    Error('\P{Is_Block=_:=BRAHMI}');
    Expect(1, 69759, '\p{Is_Block=brahmi}', "");
    Expect(0, 69759, '\p{^Is_Block=brahmi}', "");
    Expect(0, 69759, '\P{Is_Block=brahmi}', "");
    Expect(1, 69759, '\P{^Is_Block=brahmi}', "");
    Expect(0, 69760, '\p{Is_Block=brahmi}', "");
    Expect(1, 69760, '\p{^Is_Block=brahmi}', "");
    Expect(1, 69760, '\P{Is_Block=brahmi}', "");
    Expect(0, 69760, '\P{^Is_Block=brahmi}', "");
    Expect(1, 69759, '\p{Is_Block=_Brahmi}', "");
    Expect(0, 69759, '\p{^Is_Block=_Brahmi}', "");
    Expect(0, 69759, '\P{Is_Block=_Brahmi}', "");
    Expect(1, 69759, '\P{^Is_Block=_Brahmi}', "");
    Expect(0, 69760, '\p{Is_Block=_Brahmi}', "");
    Expect(1, 69760, '\p{^Is_Block=_Brahmi}', "");
    Expect(1, 69760, '\P{Is_Block=_Brahmi}', "");
    Expect(0, 69760, '\P{^Is_Block=_Brahmi}', "");
    Error('\p{Is_Blk=:=Brahmi}');
    Error('\P{Is_Blk=:=Brahmi}');
    Expect(1, 69759, '\p{Is_Blk=brahmi}', "");
    Expect(0, 69759, '\p{^Is_Blk=brahmi}', "");
    Expect(0, 69759, '\P{Is_Blk=brahmi}', "");
    Expect(1, 69759, '\P{^Is_Blk=brahmi}', "");
    Expect(0, 69760, '\p{Is_Blk=brahmi}', "");
    Expect(1, 69760, '\p{^Is_Blk=brahmi}', "");
    Expect(1, 69760, '\P{Is_Blk=brahmi}', "");
    Expect(0, 69760, '\P{^Is_Blk=brahmi}', "");
    Error('\p{Block=-:=braille_Patterns}');
    Error('\P{Block=-:=braille_Patterns}');
    Expect(1, 10495, '\p{Block=:\ABraille_Patterns\z:}', "");;
    Expect(0, 10496, '\p{Block=:\ABraille_Patterns\z:}', "");;
    Expect(1, 10495, '\p{Block=braillepatterns}', "");
    Expect(0, 10495, '\p{^Block=braillepatterns}', "");
    Expect(0, 10495, '\P{Block=braillepatterns}', "");
    Expect(1, 10495, '\P{^Block=braillepatterns}', "");
    Expect(0, 10496, '\p{Block=braillepatterns}', "");
    Expect(1, 10496, '\p{^Block=braillepatterns}', "");
    Expect(1, 10496, '\P{Block=braillepatterns}', "");
    Expect(0, 10496, '\P{^Block=braillepatterns}', "");
    Expect(1, 10495, '\p{Block=:\Abraillepatterns\z:}', "");;
    Expect(0, 10496, '\p{Block=:\Abraillepatterns\z:}', "");;
    Expect(1, 10495, '\p{Block=	Braille_PATTERNS}', "");
    Expect(0, 10495, '\p{^Block=	Braille_PATTERNS}', "");
    Expect(0, 10495, '\P{Block=	Braille_PATTERNS}', "");
    Expect(1, 10495, '\P{^Block=	Braille_PATTERNS}', "");
    Expect(0, 10496, '\p{Block=	Braille_PATTERNS}', "");
    Expect(1, 10496, '\p{^Block=	Braille_PATTERNS}', "");
    Expect(1, 10496, '\P{Block=	Braille_PATTERNS}', "");
    Expect(0, 10496, '\P{^Block=	Braille_PATTERNS}', "");
    Error('\p{Blk=:=		braille}');
    Error('\P{Blk=:=		braille}');
    Expect(1, 10495, '\p{Blk=:\ABraille\z:}', "");;
    Expect(0, 10496, '\p{Blk=:\ABraille\z:}', "");;
    Expect(1, 10495, '\p{Blk=braille}', "");
    Expect(0, 10495, '\p{^Blk=braille}', "");
    Expect(0, 10495, '\P{Blk=braille}', "");
    Expect(1, 10495, '\P{^Blk=braille}', "");
    Expect(0, 10496, '\p{Blk=braille}', "");
    Expect(1, 10496, '\p{^Blk=braille}', "");
    Expect(1, 10496, '\P{Blk=braille}', "");
    Expect(0, 10496, '\P{^Blk=braille}', "");
    Expect(1, 10495, '\p{Blk=:\Abraille\z:}', "");;
    Expect(0, 10496, '\p{Blk=:\Abraille\z:}', "");;
    Expect(1, 10495, '\p{Blk=		BRAILLE}', "");
    Expect(0, 10495, '\p{^Blk=		BRAILLE}', "");
    Expect(0, 10495, '\P{Blk=		BRAILLE}', "");
    Expect(1, 10495, '\P{^Blk=		BRAILLE}', "");
    Expect(0, 10496, '\p{Blk=		BRAILLE}', "");
    Expect(1, 10496, '\p{^Blk=		BRAILLE}', "");
    Expect(1, 10496, '\P{Blk=		BRAILLE}', "");
    Expect(0, 10496, '\P{^Blk=		BRAILLE}', "");
    Error('\p{Is_Block=_	braille_Patterns:=}');
    Error('\P{Is_Block=_	braille_Patterns:=}');
    Expect(1, 10495, '\p{Is_Block=braillepatterns}', "");
    Expect(0, 10495, '\p{^Is_Block=braillepatterns}', "");
    Expect(0, 10495, '\P{Is_Block=braillepatterns}', "");
    Expect(1, 10495, '\P{^Is_Block=braillepatterns}', "");
    Expect(0, 10496, '\p{Is_Block=braillepatterns}', "");
    Expect(1, 10496, '\p{^Is_Block=braillepatterns}', "");
    Expect(1, 10496, '\P{Is_Block=braillepatterns}', "");
    Expect(0, 10496, '\P{^Is_Block=braillepatterns}', "");
    Expect(1, 10495, '\p{Is_Block=braille_PATTERNS}', "");
    Expect(0, 10495, '\p{^Is_Block=braille_PATTERNS}', "");
    Expect(0, 10495, '\P{Is_Block=braille_PATTERNS}', "");
    Expect(1, 10495, '\P{^Is_Block=braille_PATTERNS}', "");
    Expect(0, 10496, '\p{Is_Block=braille_PATTERNS}', "");
    Expect(1, 10496, '\p{^Is_Block=braille_PATTERNS}', "");
    Expect(1, 10496, '\P{Is_Block=braille_PATTERNS}', "");
    Expect(0, 10496, '\P{^Is_Block=braille_PATTERNS}', "");
    Error('\p{Is_Blk=_/a/Braille}');
    Error('\P{Is_Blk=_/a/Braille}');
    Expect(1, 10495, '\p{Is_Blk=braille}', "");
    Expect(0, 10495, '\p{^Is_Blk=braille}', "");
    Expect(0, 10495, '\P{Is_Blk=braille}', "");
    Expect(1, 10495, '\P{^Is_Blk=braille}', "");
    Expect(0, 10496, '\p{Is_Blk=braille}', "");
    Expect(1, 10496, '\p{^Is_Blk=braille}', "");
    Expect(1, 10496, '\P{Is_Blk=braille}', "");
    Expect(0, 10496, '\P{^Is_Blk=braille}', "");
    Expect(1, 10495, '\p{Is_Blk=_-BRAILLE}', "");
    Expect(0, 10495, '\p{^Is_Blk=_-BRAILLE}', "");
    Expect(0, 10495, '\P{Is_Blk=_-BRAILLE}', "");
    Expect(1, 10495, '\P{^Is_Blk=_-BRAILLE}', "");
    Expect(0, 10496, '\p{Is_Blk=_-BRAILLE}', "");
    Expect(1, 10496, '\p{^Is_Blk=_-BRAILLE}', "");
    Expect(1, 10496, '\P{Is_Blk=_-BRAILLE}', "");
    Expect(0, 10496, '\P{^Is_Blk=_-BRAILLE}', "");
    Error('\p{Block=_:=BUGINESE}');
    Error('\P{Block=_:=BUGINESE}');
    Expect(1, 6687, '\p{Block=:\ABuginese\z:}', "");;
    Expect(0, 6688, '\p{Block=:\ABuginese\z:}', "");;
    Expect(1, 6687, '\p{Block=buginese}', "");
    Expect(0, 6687, '\p{^Block=buginese}', "");
    Expect(0, 6687, '\P{Block=buginese}', "");
    Expect(1, 6687, '\P{^Block=buginese}', "");
    Expect(0, 6688, '\p{Block=buginese}', "");
    Expect(1, 6688, '\p{^Block=buginese}', "");
    Expect(1, 6688, '\P{Block=buginese}', "");
    Expect(0, 6688, '\P{^Block=buginese}', "");
    Expect(1, 6687, '\p{Block=:\Abuginese\z:}', "");;
    Expect(0, 6688, '\p{Block=:\Abuginese\z:}', "");;
    Expect(1, 6687, '\p{Block: _	Buginese}', "");
    Expect(0, 6687, '\p{^Block: _	Buginese}', "");
    Expect(0, 6687, '\P{Block: _	Buginese}', "");
    Expect(1, 6687, '\P{^Block: _	Buginese}', "");
    Expect(0, 6688, '\p{Block: _	Buginese}', "");
    Expect(1, 6688, '\p{^Block: _	Buginese}', "");
    Expect(1, 6688, '\P{Block: _	Buginese}', "");
    Expect(0, 6688, '\P{^Block: _	Buginese}', "");
    Error('\p{Blk=-/a/BUGINESE}');
    Error('\P{Blk=-/a/BUGINESE}');
    Expect(1, 6687, '\p{Blk=:\ABuginese\z:}', "");;
    Expect(0, 6688, '\p{Blk=:\ABuginese\z:}', "");;
    Expect(1, 6687, '\p{Blk=buginese}', "");
    Expect(0, 6687, '\p{^Blk=buginese}', "");
    Expect(0, 6687, '\P{Blk=buginese}', "");
    Expect(1, 6687, '\P{^Blk=buginese}', "");
    Expect(0, 6688, '\p{Blk=buginese}', "");
    Expect(1, 6688, '\p{^Blk=buginese}', "");
    Expect(1, 6688, '\P{Blk=buginese}', "");
    Expect(0, 6688, '\P{^Blk=buginese}', "");
    Expect(1, 6687, '\p{Blk=:\Abuginese\z:}', "");;
    Expect(0, 6688, '\p{Blk=:\Abuginese\z:}', "");;
    Expect(1, 6687, '\p{Blk:BUGINESE}', "");
    Expect(0, 6687, '\p{^Blk:BUGINESE}', "");
    Expect(0, 6687, '\P{Blk:BUGINESE}', "");
    Expect(1, 6687, '\P{^Blk:BUGINESE}', "");
    Expect(0, 6688, '\p{Blk:BUGINESE}', "");
    Expect(1, 6688, '\p{^Blk:BUGINESE}', "");
    Expect(1, 6688, '\P{Blk:BUGINESE}', "");
    Expect(0, 6688, '\P{^Blk:BUGINESE}', "");
    Error('\p{Is_Block: Buginese:=}');
    Error('\P{Is_Block: Buginese:=}');
    Expect(1, 6687, '\p{Is_Block=buginese}', "");
    Expect(0, 6687, '\p{^Is_Block=buginese}', "");
    Expect(0, 6687, '\P{Is_Block=buginese}', "");
    Expect(1, 6687, '\P{^Is_Block=buginese}', "");
    Expect(0, 6688, '\p{Is_Block=buginese}', "");
    Expect(1, 6688, '\p{^Is_Block=buginese}', "");
    Expect(1, 6688, '\P{Is_Block=buginese}', "");
    Expect(0, 6688, '\P{^Is_Block=buginese}', "");
    Expect(1, 6687, '\p{Is_Block=_-BUGINESE}', "");
    Expect(0, 6687, '\p{^Is_Block=_-BUGINESE}', "");
    Expect(0, 6687, '\P{Is_Block=_-BUGINESE}', "");
    Expect(1, 6687, '\P{^Is_Block=_-BUGINESE}', "");
    Expect(0, 6688, '\p{Is_Block=_-BUGINESE}', "");
    Expect(1, 6688, '\p{^Is_Block=_-BUGINESE}', "");
    Expect(1, 6688, '\P{Is_Block=_-BUGINESE}', "");
    Expect(0, 6688, '\P{^Is_Block=_-BUGINESE}', "");
    Error('\p{Is_Blk: /a/		Buginese}');
    Error('\P{Is_Blk: /a/		Buginese}');
    Expect(1, 6687, '\p{Is_Blk=buginese}', "");
    Expect(0, 6687, '\p{^Is_Blk=buginese}', "");
    Expect(0, 6687, '\P{Is_Blk=buginese}', "");
    Expect(1, 6687, '\P{^Is_Blk=buginese}', "");
    Expect(0, 6688, '\p{Is_Blk=buginese}', "");
    Expect(1, 6688, '\p{^Is_Blk=buginese}', "");
    Expect(1, 6688, '\P{Is_Blk=buginese}', "");
    Expect(0, 6688, '\P{^Is_Blk=buginese}', "");
    Expect(1, 6687, '\p{Is_Blk= 	buginese}', "");
    Expect(0, 6687, '\p{^Is_Blk= 	buginese}', "");
    Expect(0, 6687, '\P{Is_Blk= 	buginese}', "");
    Expect(1, 6687, '\P{^Is_Blk= 	buginese}', "");
    Expect(0, 6688, '\p{Is_Blk= 	buginese}', "");
    Expect(1, 6688, '\p{^Is_Blk= 	buginese}', "");
    Expect(1, 6688, '\P{Is_Blk= 	buginese}', "");
    Expect(0, 6688, '\P{^Is_Blk= 	buginese}', "");
    Error('\p{Block= buhid:=}');
    Error('\P{Block= buhid:=}');
    Expect(1, 5983, '\p{Block=:\ABuhid\z:}', "");;
    Expect(0, 5984, '\p{Block=:\ABuhid\z:}', "");;
    Expect(1, 5983, '\p{Block=buhid}', "");
    Expect(0, 5983, '\p{^Block=buhid}', "");
    Expect(0, 5983, '\P{Block=buhid}', "");
    Expect(1, 5983, '\P{^Block=buhid}', "");
    Expect(0, 5984, '\p{Block=buhid}', "");
    Expect(1, 5984, '\p{^Block=buhid}', "");
    Expect(1, 5984, '\P{Block=buhid}', "");
    Expect(0, 5984, '\P{^Block=buhid}', "");
    Expect(1, 5983, '\p{Block=:\Abuhid\z:}', "");;
    Expect(0, 5984, '\p{Block=:\Abuhid\z:}', "");;
    Expect(1, 5983, '\p{Block=BUHID}', "");
    Expect(0, 5983, '\p{^Block=BUHID}', "");
    Expect(0, 5983, '\P{Block=BUHID}', "");
    Expect(1, 5983, '\P{^Block=BUHID}', "");
    Expect(0, 5984, '\p{Block=BUHID}', "");
    Expect(1, 5984, '\p{^Block=BUHID}', "");
    Expect(1, 5984, '\P{Block=BUHID}', "");
    Expect(0, 5984, '\P{^Block=BUHID}', "");
    Error('\p{Blk= :=buhid}');
    Error('\P{Blk= :=buhid}');
    Expect(1, 5983, '\p{Blk=:\ABuhid\z:}', "");;
    Expect(0, 5984, '\p{Blk=:\ABuhid\z:}', "");;
    Expect(1, 5983, '\p{Blk=buhid}', "");
    Expect(0, 5983, '\p{^Blk=buhid}', "");
    Expect(0, 5983, '\P{Blk=buhid}', "");
    Expect(1, 5983, '\P{^Blk=buhid}', "");
    Expect(0, 5984, '\p{Blk=buhid}', "");
    Expect(1, 5984, '\p{^Blk=buhid}', "");
    Expect(1, 5984, '\P{Blk=buhid}', "");
    Expect(0, 5984, '\P{^Blk=buhid}', "");
    Expect(1, 5983, '\p{Blk=:\Abuhid\z:}', "");;
    Expect(0, 5984, '\p{Blk=:\Abuhid\z:}', "");;
    Expect(1, 5983, '\p{Blk: _BUHID}', "");
    Expect(0, 5983, '\p{^Blk: _BUHID}', "");
    Expect(0, 5983, '\P{Blk: _BUHID}', "");
    Expect(1, 5983, '\P{^Blk: _BUHID}', "");
    Expect(0, 5984, '\p{Blk: _BUHID}', "");
    Expect(1, 5984, '\p{^Blk: _BUHID}', "");
    Expect(1, 5984, '\P{Blk: _BUHID}', "");
    Expect(0, 5984, '\P{^Blk: _BUHID}', "");
    Error('\p{Is_Block: :=_-buhid}');
    Error('\P{Is_Block: :=_-buhid}');
    Expect(1, 5983, '\p{Is_Block=buhid}', "");
    Expect(0, 5983, '\p{^Is_Block=buhid}', "");
    Expect(0, 5983, '\P{Is_Block=buhid}', "");
    Expect(1, 5983, '\P{^Is_Block=buhid}', "");
    Expect(0, 5984, '\p{Is_Block=buhid}', "");
    Expect(1, 5984, '\p{^Is_Block=buhid}', "");
    Expect(1, 5984, '\P{Is_Block=buhid}', "");
    Expect(0, 5984, '\P{^Is_Block=buhid}', "");
    Expect(1, 5983, '\p{Is_Block=_-Buhid}', "");
    Expect(0, 5983, '\p{^Is_Block=_-Buhid}', "");
    Expect(0, 5983, '\P{Is_Block=_-Buhid}', "");
    Expect(1, 5983, '\P{^Is_Block=_-Buhid}', "");
    Expect(0, 5984, '\p{Is_Block=_-Buhid}', "");
    Expect(1, 5984, '\p{^Is_Block=_-Buhid}', "");
    Expect(1, 5984, '\P{Is_Block=_-Buhid}', "");
    Expect(0, 5984, '\P{^Is_Block=_-Buhid}', "");
    Error('\p{Is_Blk=/a/BUHID}');
    Error('\P{Is_Blk=/a/BUHID}');
    Expect(1, 5983, '\p{Is_Blk=buhid}', "");
    Expect(0, 5983, '\p{^Is_Blk=buhid}', "");
    Expect(0, 5983, '\P{Is_Blk=buhid}', "");
    Expect(1, 5983, '\P{^Is_Blk=buhid}', "");
    Expect(0, 5984, '\p{Is_Blk=buhid}', "");
    Expect(1, 5984, '\p{^Is_Blk=buhid}', "");
    Expect(1, 5984, '\P{Is_Blk=buhid}', "");
    Expect(0, 5984, '\P{^Is_Blk=buhid}', "");
    Expect(1, 5983, '\p{Is_Blk=_BUHID}', "");
    Expect(0, 5983, '\p{^Is_Blk=_BUHID}', "");
    Expect(0, 5983, '\P{Is_Blk=_BUHID}', "");
    Expect(1, 5983, '\P{^Is_Blk=_BUHID}', "");
    Expect(0, 5984, '\p{Is_Blk=_BUHID}', "");
    Expect(1, 5984, '\p{^Is_Blk=_BUHID}', "");
    Expect(1, 5984, '\P{Is_Blk=_BUHID}', "");
    Expect(0, 5984, '\P{^Is_Blk=_BUHID}', "");
    Error('\p{Block=	/a/byzantine_Musical_Symbols}');
    Error('\P{Block=	/a/byzantine_Musical_Symbols}');
    Expect(1, 119039, '\p{Block=:\AByzantine_Musical_Symbols\z:}', "");;
    Expect(0, 119040, '\p{Block=:\AByzantine_Musical_Symbols\z:}', "");;
    Expect(1, 119039, '\p{Block=byzantinemusicalsymbols}', "");
    Expect(0, 119039, '\p{^Block=byzantinemusicalsymbols}', "");
    Expect(0, 119039, '\P{Block=byzantinemusicalsymbols}', "");
    Expect(1, 119039, '\P{^Block=byzantinemusicalsymbols}', "");
    Expect(0, 119040, '\p{Block=byzantinemusicalsymbols}', "");
    Expect(1, 119040, '\p{^Block=byzantinemusicalsymbols}', "");
    Expect(1, 119040, '\P{Block=byzantinemusicalsymbols}', "");
    Expect(0, 119040, '\P{^Block=byzantinemusicalsymbols}', "");
    Expect(1, 119039, '\p{Block=:\Abyzantinemusicalsymbols\z:}', "");;
    Expect(0, 119040, '\p{Block=:\Abyzantinemusicalsymbols\z:}', "");;
    Expect(1, 119039, '\p{Block=byzantine_Musical_Symbols}', "");
    Expect(0, 119039, '\p{^Block=byzantine_Musical_Symbols}', "");
    Expect(0, 119039, '\P{Block=byzantine_Musical_Symbols}', "");
    Expect(1, 119039, '\P{^Block=byzantine_Musical_Symbols}', "");
    Expect(0, 119040, '\p{Block=byzantine_Musical_Symbols}', "");
    Expect(1, 119040, '\p{^Block=byzantine_Musical_Symbols}', "");
    Expect(1, 119040, '\P{Block=byzantine_Musical_Symbols}', "");
    Expect(0, 119040, '\P{^Block=byzantine_Musical_Symbols}', "");
    Error('\p{Blk=-:=Byzantine_music}');
    Error('\P{Blk=-:=Byzantine_music}');
    Expect(1, 119039, '\p{Blk=:\AByzantine_Music\z:}', "");;
    Expect(0, 119040, '\p{Blk=:\AByzantine_Music\z:}', "");;
    Expect(1, 119039, '\p{Blk=byzantinemusic}', "");
    Expect(0, 119039, '\p{^Blk=byzantinemusic}', "");
    Expect(0, 119039, '\P{Blk=byzantinemusic}', "");
    Expect(1, 119039, '\P{^Blk=byzantinemusic}', "");
    Expect(0, 119040, '\p{Blk=byzantinemusic}', "");
    Expect(1, 119040, '\p{^Blk=byzantinemusic}', "");
    Expect(1, 119040, '\P{Blk=byzantinemusic}', "");
    Expect(0, 119040, '\P{^Blk=byzantinemusic}', "");
    Expect(1, 119039, '\p{Blk=:\Abyzantinemusic\z:}', "");;
    Expect(0, 119040, '\p{Blk=:\Abyzantinemusic\z:}', "");;
    Expect(1, 119039, '\p{Blk= Byzantine_Music}', "");
    Expect(0, 119039, '\p{^Blk= Byzantine_Music}', "");
    Expect(0, 119039, '\P{Blk= Byzantine_Music}', "");
    Expect(1, 119039, '\P{^Blk= Byzantine_Music}', "");
    Expect(0, 119040, '\p{Blk= Byzantine_Music}', "");
    Expect(1, 119040, '\p{^Blk= Byzantine_Music}', "");
    Expect(1, 119040, '\P{Blk= Byzantine_Music}', "");
    Expect(0, 119040, '\P{^Blk= Byzantine_Music}', "");
    Error('\p{Is_Block=/a/ BYZANTINE_Musical_Symbols}');
    Error('\P{Is_Block=/a/ BYZANTINE_Musical_Symbols}');
    Expect(1, 119039, '\p{Is_Block=byzantinemusicalsymbols}', "");
    Expect(0, 119039, '\p{^Is_Block=byzantinemusicalsymbols}', "");
    Expect(0, 119039, '\P{Is_Block=byzantinemusicalsymbols}', "");
    Expect(1, 119039, '\P{^Is_Block=byzantinemusicalsymbols}', "");
    Expect(0, 119040, '\p{Is_Block=byzantinemusicalsymbols}', "");
    Expect(1, 119040, '\p{^Is_Block=byzantinemusicalsymbols}', "");
    Expect(1, 119040, '\P{Is_Block=byzantinemusicalsymbols}', "");
    Expect(0, 119040, '\P{^Is_Block=byzantinemusicalsymbols}', "");
    Expect(1, 119039, '\p{Is_Block=-	Byzantine_MUSICAL_Symbols}', "");
    Expect(0, 119039, '\p{^Is_Block=-	Byzantine_MUSICAL_Symbols}', "");
    Expect(0, 119039, '\P{Is_Block=-	Byzantine_MUSICAL_Symbols}', "");
    Expect(1, 119039, '\P{^Is_Block=-	Byzantine_MUSICAL_Symbols}', "");
    Expect(0, 119040, '\p{Is_Block=-	Byzantine_MUSICAL_Symbols}', "");
    Expect(1, 119040, '\p{^Is_Block=-	Byzantine_MUSICAL_Symbols}', "");
    Expect(1, 119040, '\P{Is_Block=-	Byzantine_MUSICAL_Symbols}', "");
    Expect(0, 119040, '\P{^Is_Block=-	Byzantine_MUSICAL_Symbols}', "");
    Error('\p{Is_Blk=_	Byzantine_Music/a/}');
    Error('\P{Is_Blk=_	Byzantine_Music/a/}');
    Expect(1, 119039, '\p{Is_Blk:   byzantinemusic}', "");
    Expect(0, 119039, '\p{^Is_Blk:   byzantinemusic}', "");
    Expect(0, 119039, '\P{Is_Blk:   byzantinemusic}', "");
    Expect(1, 119039, '\P{^Is_Blk:   byzantinemusic}', "");
    Expect(0, 119040, '\p{Is_Blk:   byzantinemusic}', "");
    Expect(1, 119040, '\p{^Is_Blk:   byzantinemusic}', "");
    Expect(1, 119040, '\P{Is_Blk:   byzantinemusic}', "");
    Expect(0, 119040, '\P{^Is_Blk:   byzantinemusic}', "");
    Expect(1, 119039, '\p{Is_Blk=BYZANTINE_MUSIC}', "");
    Expect(0, 119039, '\p{^Is_Blk=BYZANTINE_MUSIC}', "");
    Expect(0, 119039, '\P{Is_Blk=BYZANTINE_MUSIC}', "");
    Expect(1, 119039, '\P{^Is_Blk=BYZANTINE_MUSIC}', "");
    Expect(0, 119040, '\p{Is_Blk=BYZANTINE_MUSIC}', "");
    Expect(1, 119040, '\p{^Is_Blk=BYZANTINE_MUSIC}', "");
    Expect(1, 119040, '\P{Is_Blk=BYZANTINE_MUSIC}', "");
    Expect(0, 119040, '\P{^Is_Blk=BYZANTINE_MUSIC}', "");
    Error('\p{Block=:= CARIAN}');
    Error('\P{Block=:= CARIAN}');
    Expect(1, 66271, '\p{Block=:\ACarian\z:}', "");;
    Expect(0, 66272, '\p{Block=:\ACarian\z:}', "");;
    Expect(1, 66271, '\p{Block=carian}', "");
    Expect(0, 66271, '\p{^Block=carian}', "");
    Expect(0, 66271, '\P{Block=carian}', "");
    Expect(1, 66271, '\P{^Block=carian}', "");
    Expect(0, 66272, '\p{Block=carian}', "");
    Expect(1, 66272, '\p{^Block=carian}', "");
    Expect(1, 66272, '\P{Block=carian}', "");
    Expect(0, 66272, '\P{^Block=carian}', "");
    Expect(1, 66271, '\p{Block=:\Acarian\z:}', "");;
    Expect(0, 66272, '\p{Block=:\Acarian\z:}', "");;
    Expect(1, 66271, '\p{Block:	 	CARIAN}', "");
    Expect(0, 66271, '\p{^Block:	 	CARIAN}', "");
    Expect(0, 66271, '\P{Block:	 	CARIAN}', "");
    Expect(1, 66271, '\P{^Block:	 	CARIAN}', "");
    Expect(0, 66272, '\p{Block:	 	CARIAN}', "");
    Expect(1, 66272, '\p{^Block:	 	CARIAN}', "");
    Expect(1, 66272, '\P{Block:	 	CARIAN}', "");
    Expect(0, 66272, '\P{^Block:	 	CARIAN}', "");
    Error('\p{Blk=	:=Carian}');
    Error('\P{Blk=	:=Carian}');
    Expect(1, 66271, '\p{Blk=:\ACarian\z:}', "");;
    Expect(0, 66272, '\p{Blk=:\ACarian\z:}', "");;
    Expect(1, 66271, '\p{Blk=carian}', "");
    Expect(0, 66271, '\p{^Blk=carian}', "");
    Expect(0, 66271, '\P{Blk=carian}', "");
    Expect(1, 66271, '\P{^Blk=carian}', "");
    Expect(0, 66272, '\p{Blk=carian}', "");
    Expect(1, 66272, '\p{^Blk=carian}', "");
    Expect(1, 66272, '\P{Blk=carian}', "");
    Expect(0, 66272, '\P{^Blk=carian}', "");
    Expect(1, 66271, '\p{Blk=:\Acarian\z:}', "");;
    Expect(0, 66272, '\p{Blk=:\Acarian\z:}', "");;
    Expect(1, 66271, '\p{Blk=--Carian}', "");
    Expect(0, 66271, '\p{^Blk=--Carian}', "");
    Expect(0, 66271, '\P{Blk=--Carian}', "");
    Expect(1, 66271, '\P{^Blk=--Carian}', "");
    Expect(0, 66272, '\p{Blk=--Carian}', "");
    Expect(1, 66272, '\p{^Blk=--Carian}', "");
    Expect(1, 66272, '\P{Blk=--Carian}', "");
    Expect(0, 66272, '\P{^Blk=--Carian}', "");
    Error('\p{Is_Block=-_Carian:=}');
    Error('\P{Is_Block=-_Carian:=}');
    Expect(1, 66271, '\p{Is_Block=carian}', "");
    Expect(0, 66271, '\p{^Is_Block=carian}', "");
    Expect(0, 66271, '\P{Is_Block=carian}', "");
    Expect(1, 66271, '\P{^Is_Block=carian}', "");
    Expect(0, 66272, '\p{Is_Block=carian}', "");
    Expect(1, 66272, '\p{^Is_Block=carian}', "");
    Expect(1, 66272, '\P{Is_Block=carian}', "");
    Expect(0, 66272, '\P{^Is_Block=carian}', "");
    Expect(1, 66271, '\p{Is_Block:  CARIAN}', "");
    Expect(0, 66271, '\p{^Is_Block:  CARIAN}', "");
    Expect(0, 66271, '\P{Is_Block:  CARIAN}', "");
    Expect(1, 66271, '\P{^Is_Block:  CARIAN}', "");
    Expect(0, 66272, '\p{Is_Block:  CARIAN}', "");
    Expect(1, 66272, '\p{^Is_Block:  CARIAN}', "");
    Expect(1, 66272, '\P{Is_Block:  CARIAN}', "");
    Expect(0, 66272, '\P{^Is_Block:  CARIAN}', "");
    Error('\p{Is_Blk=:=_-Carian}');
    Error('\P{Is_Blk=:=_-Carian}');
    Expect(1, 66271, '\p{Is_Blk=carian}', "");
    Expect(0, 66271, '\p{^Is_Blk=carian}', "");
    Expect(0, 66271, '\P{Is_Blk=carian}', "");
    Expect(1, 66271, '\P{^Is_Blk=carian}', "");
    Expect(0, 66272, '\p{Is_Blk=carian}', "");
    Expect(1, 66272, '\p{^Is_Blk=carian}', "");
    Expect(1, 66272, '\P{Is_Blk=carian}', "");
    Expect(0, 66272, '\P{^Is_Blk=carian}', "");
    Expect(1, 66271, '\p{Is_Blk=-	CARIAN}', "");
    Expect(0, 66271, '\p{^Is_Blk=-	CARIAN}', "");
    Expect(0, 66271, '\P{Is_Blk=-	CARIAN}', "");
    Expect(1, 66271, '\P{^Is_Blk=-	CARIAN}', "");
    Expect(0, 66272, '\p{Is_Blk=-	CARIAN}', "");
    Expect(1, 66272, '\p{^Is_Blk=-	CARIAN}', "");
    Expect(1, 66272, '\P{Is_Blk=-	CARIAN}', "");
    Expect(0, 66272, '\P{^Is_Blk=-	CARIAN}', "");
    Error('\p{Block=_Caucasian_Albanian/a/}');
    Error('\P{Block=_Caucasian_Albanian/a/}');
    Expect(1, 66927, '\p{Block=:\ACaucasian_Albanian\z:}', "");;
    Expect(0, 66928, '\p{Block=:\ACaucasian_Albanian\z:}', "");;
    Expect(1, 66927, '\p{Block=caucasianalbanian}', "");
    Expect(0, 66927, '\p{^Block=caucasianalbanian}', "");
    Expect(0, 66927, '\P{Block=caucasianalbanian}', "");
    Expect(1, 66927, '\P{^Block=caucasianalbanian}', "");
    Expect(0, 66928, '\p{Block=caucasianalbanian}', "");
    Expect(1, 66928, '\p{^Block=caucasianalbanian}', "");
    Expect(1, 66928, '\P{Block=caucasianalbanian}', "");
    Expect(0, 66928, '\P{^Block=caucasianalbanian}', "");
    Expect(1, 66927, '\p{Block=:\Acaucasianalbanian\z:}', "");;
    Expect(0, 66928, '\p{Block=:\Acaucasianalbanian\z:}', "");;
    Expect(1, 66927, '\p{Block=-caucasian_albanian}', "");
    Expect(0, 66927, '\p{^Block=-caucasian_albanian}', "");
    Expect(0, 66927, '\P{Block=-caucasian_albanian}', "");
    Expect(1, 66927, '\P{^Block=-caucasian_albanian}', "");
    Expect(0, 66928, '\p{Block=-caucasian_albanian}', "");
    Expect(1, 66928, '\p{^Block=-caucasian_albanian}', "");
    Expect(1, 66928, '\P{Block=-caucasian_albanian}', "");
    Expect(0, 66928, '\P{^Block=-caucasian_albanian}', "");
    Error('\p{Blk: :=_-CAUCASIAN_Albanian}');
    Error('\P{Blk: :=_-CAUCASIAN_Albanian}');
    Expect(1, 66927, '\p{Blk=:\ACaucasian_Albanian\z:}', "");;
    Expect(0, 66928, '\p{Blk=:\ACaucasian_Albanian\z:}', "");;
    Expect(1, 66927, '\p{Blk=caucasianalbanian}', "");
    Expect(0, 66927, '\p{^Blk=caucasianalbanian}', "");
    Expect(0, 66927, '\P{Blk=caucasianalbanian}', "");
    Expect(1, 66927, '\P{^Blk=caucasianalbanian}', "");
    Expect(0, 66928, '\p{Blk=caucasianalbanian}', "");
    Expect(1, 66928, '\p{^Blk=caucasianalbanian}', "");
    Expect(1, 66928, '\P{Blk=caucasianalbanian}', "");
    Expect(0, 66928, '\P{^Blk=caucasianalbanian}', "");
    Expect(1, 66927, '\p{Blk=:\Acaucasianalbanian\z:}', "");;
    Expect(0, 66928, '\p{Blk=:\Acaucasianalbanian\z:}', "");;
    Expect(1, 66927, '\p{Blk= -Caucasian_albanian}', "");
    Expect(0, 66927, '\p{^Blk= -Caucasian_albanian}', "");
    Expect(0, 66927, '\P{Blk= -Caucasian_albanian}', "");
    Expect(1, 66927, '\P{^Blk= -Caucasian_albanian}', "");
    Expect(0, 66928, '\p{Blk= -Caucasian_albanian}', "");
    Expect(1, 66928, '\p{^Blk= -Caucasian_albanian}', "");
    Expect(1, 66928, '\P{Blk= -Caucasian_albanian}', "");
    Expect(0, 66928, '\P{^Blk= -Caucasian_albanian}', "");
    Error('\p{Is_Block=:=_	Caucasian_ALBANIAN}');
    Error('\P{Is_Block=:=_	Caucasian_ALBANIAN}');
    Expect(1, 66927, '\p{Is_Block=caucasianalbanian}', "");
    Expect(0, 66927, '\p{^Is_Block=caucasianalbanian}', "");
    Expect(0, 66927, '\P{Is_Block=caucasianalbanian}', "");
    Expect(1, 66927, '\P{^Is_Block=caucasianalbanian}', "");
    Expect(0, 66928, '\p{Is_Block=caucasianalbanian}', "");
    Expect(1, 66928, '\p{^Is_Block=caucasianalbanian}', "");
    Expect(1, 66928, '\P{Is_Block=caucasianalbanian}', "");
    Expect(0, 66928, '\P{^Is_Block=caucasianalbanian}', "");
    Expect(1, 66927, '\p{Is_Block=- CAUCASIAN_ALBANIAN}', "");
    Expect(0, 66927, '\p{^Is_Block=- CAUCASIAN_ALBANIAN}', "");
    Expect(0, 66927, '\P{Is_Block=- CAUCASIAN_ALBANIAN}', "");
    Expect(1, 66927, '\P{^Is_Block=- CAUCASIAN_ALBANIAN}', "");
    Expect(0, 66928, '\p{Is_Block=- CAUCASIAN_ALBANIAN}', "");
    Expect(1, 66928, '\p{^Is_Block=- CAUCASIAN_ALBANIAN}', "");
    Expect(1, 66928, '\P{Is_Block=- CAUCASIAN_ALBANIAN}', "");
    Expect(0, 66928, '\P{^Is_Block=- CAUCASIAN_ALBANIAN}', "");
    Error('\p{Is_Blk=_/a/Caucasian_Albanian}');
    Error('\P{Is_Blk=_/a/Caucasian_Albanian}');
    Expect(1, 66927, '\p{Is_Blk=caucasianalbanian}', "");
    Expect(0, 66927, '\p{^Is_Blk=caucasianalbanian}', "");
    Expect(0, 66927, '\P{Is_Blk=caucasianalbanian}', "");
    Expect(1, 66927, '\P{^Is_Blk=caucasianalbanian}', "");
    Expect(0, 66928, '\p{Is_Blk=caucasianalbanian}', "");
    Expect(1, 66928, '\p{^Is_Blk=caucasianalbanian}', "");
    Expect(1, 66928, '\P{Is_Blk=caucasianalbanian}', "");
    Expect(0, 66928, '\P{^Is_Blk=caucasianalbanian}', "");
    Expect(1, 66927, '\p{Is_Blk=_CAUCASIAN_ALBANIAN}', "");
    Expect(0, 66927, '\p{^Is_Blk=_CAUCASIAN_ALBANIAN}', "");
    Expect(0, 66927, '\P{Is_Blk=_CAUCASIAN_ALBANIAN}', "");
    Expect(1, 66927, '\P{^Is_Blk=_CAUCASIAN_ALBANIAN}', "");
    Expect(0, 66928, '\p{Is_Blk=_CAUCASIAN_ALBANIAN}', "");
    Expect(1, 66928, '\p{^Is_Blk=_CAUCASIAN_ALBANIAN}', "");
    Expect(1, 66928, '\P{Is_Blk=_CAUCASIAN_ALBANIAN}', "");
    Expect(0, 66928, '\P{^Is_Blk=_CAUCASIAN_ALBANIAN}', "");
    Error('\p{Block=/a/Chakma}');
    Error('\P{Block=/a/Chakma}');
    Expect(1, 69967, '\p{Block=:\AChakma\z:}', "");;
    Expect(0, 69968, '\p{Block=:\AChakma\z:}', "");;
    Expect(1, 69967, '\p{Block=chakma}', "");
    Expect(0, 69967, '\p{^Block=chakma}', "");
    Expect(0, 69967, '\P{Block=chakma}', "");
    Expect(1, 69967, '\P{^Block=chakma}', "");
    Expect(0, 69968, '\p{Block=chakma}', "");
    Expect(1, 69968, '\p{^Block=chakma}', "");
    Expect(1, 69968, '\P{Block=chakma}', "");
    Expect(0, 69968, '\P{^Block=chakma}', "");
    Expect(1, 69967, '\p{Block=:\Achakma\z:}', "");;
    Expect(0, 69968, '\p{Block=:\Achakma\z:}', "");;
    Expect(1, 69967, '\p{Block=	 chakma}', "");
    Expect(0, 69967, '\p{^Block=	 chakma}', "");
    Expect(0, 69967, '\P{Block=	 chakma}', "");
    Expect(1, 69967, '\P{^Block=	 chakma}', "");
    Expect(0, 69968, '\p{Block=	 chakma}', "");
    Expect(1, 69968, '\p{^Block=	 chakma}', "");
    Expect(1, 69968, '\P{Block=	 chakma}', "");
    Expect(0, 69968, '\P{^Block=	 chakma}', "");
    Error('\p{Blk=_Chakma/a/}');
    Error('\P{Blk=_Chakma/a/}');
    Expect(1, 69967, '\p{Blk=:\AChakma\z:}', "");;
    Expect(0, 69968, '\p{Blk=:\AChakma\z:}', "");;
    Expect(1, 69967, '\p{Blk=chakma}', "");
    Expect(0, 69967, '\p{^Blk=chakma}', "");
    Expect(0, 69967, '\P{Blk=chakma}', "");
    Expect(1, 69967, '\P{^Blk=chakma}', "");
    Expect(0, 69968, '\p{Blk=chakma}', "");
    Expect(1, 69968, '\p{^Blk=chakma}', "");
    Expect(1, 69968, '\P{Blk=chakma}', "");
    Expect(0, 69968, '\P{^Blk=chakma}', "");
    Expect(1, 69967, '\p{Blk=:\Achakma\z:}', "");;
    Expect(0, 69968, '\p{Blk=:\Achakma\z:}', "");;
    Expect(1, 69967, '\p{Blk=	_Chakma}', "");
    Expect(0, 69967, '\p{^Blk=	_Chakma}', "");
    Expect(0, 69967, '\P{Blk=	_Chakma}', "");
    Expect(1, 69967, '\P{^Blk=	_Chakma}', "");
    Expect(0, 69968, '\p{Blk=	_Chakma}', "");
    Expect(1, 69968, '\p{^Blk=	_Chakma}', "");
    Expect(1, 69968, '\P{Blk=	_Chakma}', "");
    Expect(0, 69968, '\P{^Blk=	_Chakma}', "");
    Error('\p{Is_Block=:=	-Chakma}');
    Error('\P{Is_Block=:=	-Chakma}');
    Expect(1, 69967, '\p{Is_Block=chakma}', "");
    Expect(0, 69967, '\p{^Is_Block=chakma}', "");
    Expect(0, 69967, '\P{Is_Block=chakma}', "");
    Expect(1, 69967, '\P{^Is_Block=chakma}', "");
    Expect(0, 69968, '\p{Is_Block=chakma}', "");
    Expect(1, 69968, '\p{^Is_Block=chakma}', "");
    Expect(1, 69968, '\P{Is_Block=chakma}', "");
    Expect(0, 69968, '\P{^Is_Block=chakma}', "");
    Expect(1, 69967, '\p{Is_Block= _chakma}', "");
    Expect(0, 69967, '\p{^Is_Block= _chakma}', "");
    Expect(0, 69967, '\P{Is_Block= _chakma}', "");
    Expect(1, 69967, '\P{^Is_Block= _chakma}', "");
    Expect(0, 69968, '\p{Is_Block= _chakma}', "");
    Expect(1, 69968, '\p{^Is_Block= _chakma}', "");
    Expect(1, 69968, '\P{Is_Block= _chakma}', "");
    Expect(0, 69968, '\P{^Is_Block= _chakma}', "");
    Error('\p{Is_Blk=:= -Chakma}');
    Error('\P{Is_Blk=:= -Chakma}');
    Expect(1, 69967, '\p{Is_Blk=chakma}', "");
    Expect(0, 69967, '\p{^Is_Blk=chakma}', "");
    Expect(0, 69967, '\P{Is_Blk=chakma}', "");
    Expect(1, 69967, '\P{^Is_Blk=chakma}', "");
    Expect(0, 69968, '\p{Is_Blk=chakma}', "");
    Expect(1, 69968, '\p{^Is_Blk=chakma}', "");
    Expect(1, 69968, '\P{Is_Blk=chakma}', "");
    Expect(0, 69968, '\P{^Is_Blk=chakma}', "");
    Expect(1, 69967, '\p{Is_Blk=	-Chakma}', "");
    Expect(0, 69967, '\p{^Is_Blk=	-Chakma}', "");
    Expect(0, 69967, '\P{Is_Blk=	-Chakma}', "");
    Expect(1, 69967, '\P{^Is_Blk=	-Chakma}', "");
    Expect(0, 69968, '\p{Is_Blk=	-Chakma}', "");
    Expect(1, 69968, '\p{^Is_Blk=	-Chakma}', "");
    Expect(1, 69968, '\P{Is_Blk=	-Chakma}', "");
    Expect(0, 69968, '\P{^Is_Blk=	-Chakma}', "");
    Error('\p{Block=:=_-CHAM}');
    Error('\P{Block=:=_-CHAM}');
    Expect(1, 43615, '\p{Block=:\ACham\z:}', "");;
    Expect(0, 43616, '\p{Block=:\ACham\z:}', "");;
    Expect(1, 43615, '\p{Block=cham}', "");
    Expect(0, 43615, '\p{^Block=cham}', "");
    Expect(0, 43615, '\P{Block=cham}', "");
    Expect(1, 43615, '\P{^Block=cham}', "");
    Expect(0, 43616, '\p{Block=cham}', "");
    Expect(1, 43616, '\p{^Block=cham}', "");
    Expect(1, 43616, '\P{Block=cham}', "");
    Expect(0, 43616, '\P{^Block=cham}', "");
    Expect(1, 43615, '\p{Block=:\Acham\z:}', "");;
    Expect(0, 43616, '\p{Block=:\Acham\z:}', "");;
    Expect(1, 43615, '\p{Block= 	Cham}', "");
    Expect(0, 43615, '\p{^Block= 	Cham}', "");
    Expect(0, 43615, '\P{Block= 	Cham}', "");
    Expect(1, 43615, '\P{^Block= 	Cham}', "");
    Expect(0, 43616, '\p{Block= 	Cham}', "");
    Expect(1, 43616, '\p{^Block= 	Cham}', "");
    Expect(1, 43616, '\P{Block= 	Cham}', "");
    Expect(0, 43616, '\P{^Block= 	Cham}', "");
    Error('\p{Blk=_:=cham}');
    Error('\P{Blk=_:=cham}');
    Expect(1, 43615, '\p{Blk=:\ACham\z:}', "");;
    Expect(0, 43616, '\p{Blk=:\ACham\z:}', "");;
    Expect(1, 43615, '\p{Blk=cham}', "");
    Expect(0, 43615, '\p{^Blk=cham}', "");
    Expect(0, 43615, '\P{Blk=cham}', "");
    Expect(1, 43615, '\P{^Blk=cham}', "");
    Expect(0, 43616, '\p{Blk=cham}', "");
    Expect(1, 43616, '\p{^Blk=cham}', "");
    Expect(1, 43616, '\P{Blk=cham}', "");
    Expect(0, 43616, '\P{^Blk=cham}', "");
    Expect(1, 43615, '\p{Blk=:\Acham\z:}', "");;
    Expect(0, 43616, '\p{Blk=:\Acham\z:}', "");;
    Expect(1, 43615, '\p{Blk: 	Cham}', "");
    Expect(0, 43615, '\p{^Blk: 	Cham}', "");
    Expect(0, 43615, '\P{Blk: 	Cham}', "");
    Expect(1, 43615, '\P{^Blk: 	Cham}', "");
    Expect(0, 43616, '\p{Blk: 	Cham}', "");
    Expect(1, 43616, '\p{^Blk: 	Cham}', "");
    Expect(1, 43616, '\P{Blk: 	Cham}', "");
    Expect(0, 43616, '\P{^Blk: 	Cham}', "");
    Error('\p{Is_Block=-:=Cham}');
    Error('\P{Is_Block=-:=Cham}');
    Expect(1, 43615, '\p{Is_Block=cham}', "");
    Expect(0, 43615, '\p{^Is_Block=cham}', "");
    Expect(0, 43615, '\P{Is_Block=cham}', "");
    Expect(1, 43615, '\P{^Is_Block=cham}', "");
    Expect(0, 43616, '\p{Is_Block=cham}', "");
    Expect(1, 43616, '\p{^Is_Block=cham}', "");
    Expect(1, 43616, '\P{Is_Block=cham}', "");
    Expect(0, 43616, '\P{^Is_Block=cham}', "");
    Expect(1, 43615, '\p{Is_Block= 	Cham}', "");
    Expect(0, 43615, '\p{^Is_Block= 	Cham}', "");
    Expect(0, 43615, '\P{Is_Block= 	Cham}', "");
    Expect(1, 43615, '\P{^Is_Block= 	Cham}', "");
    Expect(0, 43616, '\p{Is_Block= 	Cham}', "");
    Expect(1, 43616, '\p{^Is_Block= 	Cham}', "");
    Expect(1, 43616, '\P{Is_Block= 	Cham}', "");
    Expect(0, 43616, '\P{^Is_Block= 	Cham}', "");
    Error('\p{Is_Blk=:=	_Cham}');
    Error('\P{Is_Blk=:=	_Cham}');
    Expect(1, 43615, '\p{Is_Blk=cham}', "");
    Expect(0, 43615, '\p{^Is_Blk=cham}', "");
    Expect(0, 43615, '\P{Is_Blk=cham}', "");
    Expect(1, 43615, '\P{^Is_Blk=cham}', "");
    Expect(0, 43616, '\p{Is_Blk=cham}', "");
    Expect(1, 43616, '\p{^Is_Blk=cham}', "");
    Expect(1, 43616, '\P{Is_Blk=cham}', "");
    Expect(0, 43616, '\P{^Is_Blk=cham}', "");
    Expect(1, 43615, '\p{Is_Blk=	 cham}', "");
    Expect(0, 43615, '\p{^Is_Blk=	 cham}', "");
    Expect(0, 43615, '\P{Is_Blk=	 cham}', "");
    Expect(1, 43615, '\P{^Is_Blk=	 cham}', "");
    Expect(0, 43616, '\p{Is_Blk=	 cham}', "");
    Expect(1, 43616, '\p{^Is_Blk=	 cham}', "");
    Expect(1, 43616, '\P{Is_Blk=	 cham}', "");
    Expect(0, 43616, '\P{^Is_Blk=	 cham}', "");
    Error('\p{Block:   	/a/Cherokee}');
    Error('\P{Block:   	/a/Cherokee}');
    Expect(1, 5119, '\p{Block=:\ACherokee\z:}', "");;
    Expect(0, 5120, '\p{Block=:\ACherokee\z:}', "");;
    Expect(1, 5119, '\p{Block=cherokee}', "");
    Expect(0, 5119, '\p{^Block=cherokee}', "");
    Expect(0, 5119, '\P{Block=cherokee}', "");
    Expect(1, 5119, '\P{^Block=cherokee}', "");
    Expect(0, 5120, '\p{Block=cherokee}', "");
    Expect(1, 5120, '\p{^Block=cherokee}', "");
    Expect(1, 5120, '\P{Block=cherokee}', "");
    Expect(0, 5120, '\P{^Block=cherokee}', "");
    Expect(1, 5119, '\p{Block=:\Acherokee\z:}', "");;
    Expect(0, 5120, '\p{Block=:\Acherokee\z:}', "");;
    Expect(1, 5119, '\p{Block=		CHEROKEE}', "");
    Expect(0, 5119, '\p{^Block=		CHEROKEE}', "");
    Expect(0, 5119, '\P{Block=		CHEROKEE}', "");
    Expect(1, 5119, '\P{^Block=		CHEROKEE}', "");
    Expect(0, 5120, '\p{Block=		CHEROKEE}', "");
    Expect(1, 5120, '\p{^Block=		CHEROKEE}', "");
    Expect(1, 5120, '\P{Block=		CHEROKEE}', "");
    Expect(0, 5120, '\P{^Block=		CHEROKEE}', "");
    Error('\p{Blk=:=-	CHEROKEE}');
    Error('\P{Blk=:=-	CHEROKEE}');
    Expect(1, 5119, '\p{Blk=:\ACherokee\z:}', "");;
    Expect(0, 5120, '\p{Blk=:\ACherokee\z:}', "");;
    Expect(1, 5119, '\p{Blk=cherokee}', "");
    Expect(0, 5119, '\p{^Blk=cherokee}', "");
    Expect(0, 5119, '\P{Blk=cherokee}', "");
    Expect(1, 5119, '\P{^Blk=cherokee}', "");
    Expect(0, 5120, '\p{Blk=cherokee}', "");
    Expect(1, 5120, '\p{^Blk=cherokee}', "");
    Expect(1, 5120, '\P{Blk=cherokee}', "");
    Expect(0, 5120, '\P{^Blk=cherokee}', "");
    Expect(1, 5119, '\p{Blk=:\Acherokee\z:}', "");;
    Expect(0, 5120, '\p{Blk=:\Acherokee\z:}', "");;
    Expect(1, 5119, '\p{Blk=-_cherokee}', "");
    Expect(0, 5119, '\p{^Blk=-_cherokee}', "");
    Expect(0, 5119, '\P{Blk=-_cherokee}', "");
    Expect(1, 5119, '\P{^Blk=-_cherokee}', "");
    Expect(0, 5120, '\p{Blk=-_cherokee}', "");
    Expect(1, 5120, '\p{^Blk=-_cherokee}', "");
    Expect(1, 5120, '\P{Blk=-_cherokee}', "");
    Expect(0, 5120, '\P{^Blk=-_cherokee}', "");
    Error('\p{Is_Block=	-cherokee:=}');
    Error('\P{Is_Block=	-cherokee:=}');
    Expect(1, 5119, '\p{Is_Block=cherokee}', "");
    Expect(0, 5119, '\p{^Is_Block=cherokee}', "");
    Expect(0, 5119, '\P{Is_Block=cherokee}', "");
    Expect(1, 5119, '\P{^Is_Block=cherokee}', "");
    Expect(0, 5120, '\p{Is_Block=cherokee}', "");
    Expect(1, 5120, '\p{^Is_Block=cherokee}', "");
    Expect(1, 5120, '\P{Is_Block=cherokee}', "");
    Expect(0, 5120, '\P{^Is_Block=cherokee}', "");
    Expect(1, 5119, '\p{Is_Block=  Cherokee}', "");
    Expect(0, 5119, '\p{^Is_Block=  Cherokee}', "");
    Expect(0, 5119, '\P{Is_Block=  Cherokee}', "");
    Expect(1, 5119, '\P{^Is_Block=  Cherokee}', "");
    Expect(0, 5120, '\p{Is_Block=  Cherokee}', "");
    Expect(1, 5120, '\p{^Is_Block=  Cherokee}', "");
    Expect(1, 5120, '\P{Is_Block=  Cherokee}', "");
    Expect(0, 5120, '\P{^Is_Block=  Cherokee}', "");
    Error('\p{Is_Blk=_	Cherokee/a/}');
    Error('\P{Is_Blk=_	Cherokee/a/}');
    Expect(1, 5119, '\p{Is_Blk=cherokee}', "");
    Expect(0, 5119, '\p{^Is_Blk=cherokee}', "");
    Expect(0, 5119, '\P{Is_Blk=cherokee}', "");
    Expect(1, 5119, '\P{^Is_Blk=cherokee}', "");
    Expect(0, 5120, '\p{Is_Blk=cherokee}', "");
    Expect(1, 5120, '\p{^Is_Blk=cherokee}', "");
    Expect(1, 5120, '\P{Is_Blk=cherokee}', "");
    Expect(0, 5120, '\P{^Is_Blk=cherokee}', "");
    Expect(1, 5119, '\p{Is_Blk=	-CHEROKEE}', "");
    Expect(0, 5119, '\p{^Is_Blk=	-CHEROKEE}', "");
    Expect(0, 5119, '\P{Is_Blk=	-CHEROKEE}', "");
    Expect(1, 5119, '\P{^Is_Blk=	-CHEROKEE}', "");
    Expect(0, 5120, '\p{Is_Blk=	-CHEROKEE}', "");
    Expect(1, 5120, '\p{^Is_Blk=	-CHEROKEE}', "");
    Expect(1, 5120, '\P{Is_Blk=	-CHEROKEE}', "");
    Expect(0, 5120, '\P{^Is_Blk=	-CHEROKEE}', "");
    Error('\p{Block=	:=Cherokee_Supplement}');
    Error('\P{Block=	:=Cherokee_Supplement}');
    Expect(1, 43967, '\p{Block=:\ACherokee_Supplement\z:}', "");;
    Expect(0, 43968, '\p{Block=:\ACherokee_Supplement\z:}', "");;
    Expect(1, 43967, '\p{Block=cherokeesupplement}', "");
    Expect(0, 43967, '\p{^Block=cherokeesupplement}', "");
    Expect(0, 43967, '\P{Block=cherokeesupplement}', "");
    Expect(1, 43967, '\P{^Block=cherokeesupplement}', "");
    Expect(0, 43968, '\p{Block=cherokeesupplement}', "");
    Expect(1, 43968, '\p{^Block=cherokeesupplement}', "");
    Expect(1, 43968, '\P{Block=cherokeesupplement}', "");
    Expect(0, 43968, '\P{^Block=cherokeesupplement}', "");
    Expect(1, 43967, '\p{Block=:\Acherokeesupplement\z:}', "");;
    Expect(0, 43968, '\p{Block=:\Acherokeesupplement\z:}', "");;
    Expect(1, 43967, '\p{Block= CHEROKEE_Supplement}', "");
    Expect(0, 43967, '\p{^Block= CHEROKEE_Supplement}', "");
    Expect(0, 43967, '\P{Block= CHEROKEE_Supplement}', "");
    Expect(1, 43967, '\P{^Block= CHEROKEE_Supplement}', "");
    Expect(0, 43968, '\p{Block= CHEROKEE_Supplement}', "");
    Expect(1, 43968, '\p{^Block= CHEROKEE_Supplement}', "");
    Expect(1, 43968, '\P{Block= CHEROKEE_Supplement}', "");
    Expect(0, 43968, '\P{^Block= CHEROKEE_Supplement}', "");
    Error('\p{Blk=- CHEROKEE_Sup:=}');
    Error('\P{Blk=- CHEROKEE_Sup:=}');
    Expect(1, 43967, '\p{Blk=:\ACherokee_Sup\z:}', "");;
    Expect(0, 43968, '\p{Blk=:\ACherokee_Sup\z:}', "");;
    Expect(1, 43967, '\p{Blk:	cherokeesup}', "");
    Expect(0, 43967, '\p{^Blk:	cherokeesup}', "");
    Expect(0, 43967, '\P{Blk:	cherokeesup}', "");
    Expect(1, 43967, '\P{^Blk:	cherokeesup}', "");
    Expect(0, 43968, '\p{Blk:	cherokeesup}', "");
    Expect(1, 43968, '\p{^Blk:	cherokeesup}', "");
    Expect(1, 43968, '\P{Blk:	cherokeesup}', "");
    Expect(0, 43968, '\P{^Blk:	cherokeesup}', "");
    Expect(1, 43967, '\p{Blk=:\Acherokeesup\z:}', "");;
    Expect(0, 43968, '\p{Blk=:\Acherokeesup\z:}', "");;
    Expect(1, 43967, '\p{Blk= 	Cherokee_Sup}', "");
    Expect(0, 43967, '\p{^Blk= 	Cherokee_Sup}', "");
    Expect(0, 43967, '\P{Blk= 	Cherokee_Sup}', "");
    Expect(1, 43967, '\P{^Blk= 	Cherokee_Sup}', "");
    Expect(0, 43968, '\p{Blk= 	Cherokee_Sup}', "");
    Expect(1, 43968, '\p{^Blk= 	Cherokee_Sup}', "");
    Expect(1, 43968, '\P{Blk= 	Cherokee_Sup}', "");
    Expect(0, 43968, '\P{^Blk= 	Cherokee_Sup}', "");
    Error('\p{Is_Block= :=cherokee_Supplement}');
    Error('\P{Is_Block= :=cherokee_Supplement}');
    Expect(1, 43967, '\p{Is_Block:cherokeesupplement}', "");
    Expect(0, 43967, '\p{^Is_Block:cherokeesupplement}', "");
    Expect(0, 43967, '\P{Is_Block:cherokeesupplement}', "");
    Expect(1, 43967, '\P{^Is_Block:cherokeesupplement}', "");
    Expect(0, 43968, '\p{Is_Block:cherokeesupplement}', "");
    Expect(1, 43968, '\p{^Is_Block:cherokeesupplement}', "");
    Expect(1, 43968, '\P{Is_Block:cherokeesupplement}', "");
    Expect(0, 43968, '\P{^Is_Block:cherokeesupplement}', "");
    Expect(1, 43967, '\p{Is_Block= -cherokee_Supplement}', "");
    Expect(0, 43967, '\p{^Is_Block= -cherokee_Supplement}', "");
    Expect(0, 43967, '\P{Is_Block= -cherokee_Supplement}', "");
    Expect(1, 43967, '\P{^Is_Block= -cherokee_Supplement}', "");
    Expect(0, 43968, '\p{Is_Block= -cherokee_Supplement}', "");
    Expect(1, 43968, '\p{^Is_Block= -cherokee_Supplement}', "");
    Expect(1, 43968, '\P{Is_Block= -cherokee_Supplement}', "");
    Expect(0, 43968, '\P{^Is_Block= -cherokee_Supplement}', "");
    Error('\p{Is_Blk=:= -cherokee_SUP}');
    Error('\P{Is_Blk=:= -cherokee_SUP}');
    Expect(1, 43967, '\p{Is_Blk:cherokeesup}', "");
    Expect(0, 43967, '\p{^Is_Blk:cherokeesup}', "");
    Expect(0, 43967, '\P{Is_Blk:cherokeesup}', "");
    Expect(1, 43967, '\P{^Is_Blk:cherokeesup}', "");
    Expect(0, 43968, '\p{Is_Blk:cherokeesup}', "");
    Expect(1, 43968, '\p{^Is_Blk:cherokeesup}', "");
    Expect(1, 43968, '\P{Is_Blk:cherokeesup}', "");
    Expect(0, 43968, '\P{^Is_Blk:cherokeesup}', "");
    Expect(1, 43967, '\p{Is_Blk=  CHEROKEE_sup}', "");
    Expect(0, 43967, '\p{^Is_Blk=  CHEROKEE_sup}', "");
    Expect(0, 43967, '\P{Is_Blk=  CHEROKEE_sup}', "");
    Expect(1, 43967, '\P{^Is_Blk=  CHEROKEE_sup}', "");
    Expect(0, 43968, '\p{Is_Blk=  CHEROKEE_sup}', "");
    Expect(1, 43968, '\p{^Is_Blk=  CHEROKEE_sup}', "");
    Expect(1, 43968, '\P{Is_Blk=  CHEROKEE_sup}', "");
    Expect(0, 43968, '\P{^Is_Blk=  CHEROKEE_sup}', "");
    Error('\p{Block: _:=CHESS_Symbols}');
    Error('\P{Block: _:=CHESS_Symbols}');
    Expect(1, 129647, '\p{Block=:\AChess_Symbols\z:}', "");;
    Expect(0, 129648, '\p{Block=:\AChess_Symbols\z:}', "");;
    Expect(1, 129647, '\p{Block:   chesssymbols}', "");
    Expect(0, 129647, '\p{^Block:   chesssymbols}', "");
    Expect(0, 129647, '\P{Block:   chesssymbols}', "");
    Expect(1, 129647, '\P{^Block:   chesssymbols}', "");
    Expect(0, 129648, '\p{Block:   chesssymbols}', "");
    Expect(1, 129648, '\p{^Block:   chesssymbols}', "");
    Expect(1, 129648, '\P{Block:   chesssymbols}', "");
    Expect(0, 129648, '\P{^Block:   chesssymbols}', "");
    Expect(1, 129647, '\p{Block=:\Achesssymbols\z:}', "");;
    Expect(0, 129648, '\p{Block=:\Achesssymbols\z:}', "");;
    Expect(1, 129647, '\p{Block= -CHESS_Symbols}', "");
    Expect(0, 129647, '\p{^Block= -CHESS_Symbols}', "");
    Expect(0, 129647, '\P{Block= -CHESS_Symbols}', "");
    Expect(1, 129647, '\P{^Block= -CHESS_Symbols}', "");
    Expect(0, 129648, '\p{Block= -CHESS_Symbols}', "");
    Expect(1, 129648, '\p{^Block= -CHESS_Symbols}', "");
    Expect(1, 129648, '\P{Block= -CHESS_Symbols}', "");
    Expect(0, 129648, '\P{^Block= -CHESS_Symbols}', "");
    Error('\p{Blk:	:=chess_Symbols}');
    Error('\P{Blk:	:=chess_Symbols}');
    Expect(1, 129647, '\p{Blk=:\AChess_Symbols\z:}', "");;
    Expect(0, 129648, '\p{Blk=:\AChess_Symbols\z:}', "");;
    Expect(1, 129647, '\p{Blk=chesssymbols}', "");
    Expect(0, 129647, '\p{^Blk=chesssymbols}', "");
    Expect(0, 129647, '\P{Blk=chesssymbols}', "");
    Expect(1, 129647, '\P{^Blk=chesssymbols}', "");
    Expect(0, 129648, '\p{Blk=chesssymbols}', "");
    Expect(1, 129648, '\p{^Blk=chesssymbols}', "");
    Expect(1, 129648, '\P{Blk=chesssymbols}', "");
    Expect(0, 129648, '\P{^Blk=chesssymbols}', "");
    Expect(1, 129647, '\p{Blk=:\Achesssymbols\z:}', "");;
    Expect(0, 129648, '\p{Blk=:\Achesssymbols\z:}', "");;
    Expect(1, 129647, '\p{Blk=--Chess_Symbols}', "");
    Expect(0, 129647, '\p{^Blk=--Chess_Symbols}', "");
    Expect(0, 129647, '\P{Blk=--Chess_Symbols}', "");
    Expect(1, 129647, '\P{^Blk=--Chess_Symbols}', "");
    Expect(0, 129648, '\p{Blk=--Chess_Symbols}', "");
    Expect(1, 129648, '\p{^Blk=--Chess_Symbols}', "");
    Expect(1, 129648, '\P{Blk=--Chess_Symbols}', "");
    Expect(0, 129648, '\P{^Blk=--Chess_Symbols}', "");
    Error('\p{Is_Block=/a/__chess_SYMBOLS}');
    Error('\P{Is_Block=/a/__chess_SYMBOLS}');
    Expect(1, 129647, '\p{Is_Block=chesssymbols}', "");
    Expect(0, 129647, '\p{^Is_Block=chesssymbols}', "");
    Expect(0, 129647, '\P{Is_Block=chesssymbols}', "");
    Expect(1, 129647, '\P{^Is_Block=chesssymbols}', "");
    Expect(0, 129648, '\p{Is_Block=chesssymbols}', "");
    Expect(1, 129648, '\p{^Is_Block=chesssymbols}', "");
    Expect(1, 129648, '\P{Is_Block=chesssymbols}', "");
    Expect(0, 129648, '\P{^Is_Block=chesssymbols}', "");
    Expect(1, 129647, '\p{Is_Block: Chess_Symbols}', "");
    Expect(0, 129647, '\p{^Is_Block: Chess_Symbols}', "");
    Expect(0, 129647, '\P{Is_Block: Chess_Symbols}', "");
    Expect(1, 129647, '\P{^Is_Block: Chess_Symbols}', "");
    Expect(0, 129648, '\p{Is_Block: Chess_Symbols}', "");
    Expect(1, 129648, '\p{^Is_Block: Chess_Symbols}', "");
    Expect(1, 129648, '\P{Is_Block: Chess_Symbols}', "");
    Expect(0, 129648, '\P{^Is_Block: Chess_Symbols}', "");
    Error('\p{Is_Blk=	/a/CHESS_SYMBOLS}');
    Error('\P{Is_Blk=	/a/CHESS_SYMBOLS}');
    Expect(1, 129647, '\p{Is_Blk=chesssymbols}', "");
    Expect(0, 129647, '\p{^Is_Blk=chesssymbols}', "");
    Expect(0, 129647, '\P{Is_Blk=chesssymbols}', "");
    Expect(1, 129647, '\P{^Is_Blk=chesssymbols}', "");
    Expect(0, 129648, '\p{Is_Blk=chesssymbols}', "");
    Expect(1, 129648, '\p{^Is_Blk=chesssymbols}', "");
    Expect(1, 129648, '\P{Is_Blk=chesssymbols}', "");
    Expect(0, 129648, '\P{^Is_Blk=chesssymbols}', "");
    Expect(1, 129647, '\p{Is_Blk= 	Chess_SYMBOLS}', "");
    Expect(0, 129647, '\p{^Is_Blk= 	Chess_SYMBOLS}', "");
    Expect(0, 129647, '\P{Is_Blk= 	Chess_SYMBOLS}', "");
    Expect(1, 129647, '\P{^Is_Blk= 	Chess_SYMBOLS}', "");
    Expect(0, 129648, '\p{Is_Blk= 	Chess_SYMBOLS}', "");
    Expect(1, 129648, '\p{^Is_Blk= 	Chess_SYMBOLS}', "");
    Expect(1, 129648, '\P{Is_Blk= 	Chess_SYMBOLS}', "");
    Expect(0, 129648, '\P{^Is_Blk= 	Chess_SYMBOLS}', "");
    Error('\p{Block:	 chorasmian:=}');
    Error('\P{Block:	 chorasmian:=}');
    Expect(1, 69599, '\p{Block=:\AChorasmian\z:}', "");;
    Expect(0, 69600, '\p{Block=:\AChorasmian\z:}', "");;
    Expect(1, 69599, '\p{Block=chorasmian}', "");
    Expect(0, 69599, '\p{^Block=chorasmian}', "");
    Expect(0, 69599, '\P{Block=chorasmian}', "");
    Expect(1, 69599, '\P{^Block=chorasmian}', "");
    Expect(0, 69600, '\p{Block=chorasmian}', "");
    Expect(1, 69600, '\p{^Block=chorasmian}', "");
    Expect(1, 69600, '\P{Block=chorasmian}', "");
    Expect(0, 69600, '\P{^Block=chorasmian}', "");
    Expect(1, 69599, '\p{Block=:\Achorasmian\z:}', "");;
    Expect(0, 69600, '\p{Block=:\Achorasmian\z:}', "");;
    Expect(1, 69599, '\p{Block:			Chorasmian}', "");
    Expect(0, 69599, '\p{^Block:			Chorasmian}', "");
    Expect(0, 69599, '\P{Block:			Chorasmian}', "");
    Expect(1, 69599, '\P{^Block:			Chorasmian}', "");
    Expect(0, 69600, '\p{Block:			Chorasmian}', "");
    Expect(1, 69600, '\p{^Block:			Chorasmian}', "");
    Expect(1, 69600, '\P{Block:			Chorasmian}', "");
    Expect(0, 69600, '\P{^Block:			Chorasmian}', "");
    Error('\p{Blk=-Chorasmian:=}');
    Error('\P{Blk=-Chorasmian:=}');
    Expect(1, 69599, '\p{Blk=:\AChorasmian\z:}', "");;
    Expect(0, 69600, '\p{Blk=:\AChorasmian\z:}', "");;
    Expect(1, 69599, '\p{Blk=chorasmian}', "");
    Expect(0, 69599, '\p{^Blk=chorasmian}', "");
    Expect(0, 69599, '\P{Blk=chorasmian}', "");
    Expect(1, 69599, '\P{^Blk=chorasmian}', "");
    Expect(0, 69600, '\p{Blk=chorasmian}', "");
    Expect(1, 69600, '\p{^Blk=chorasmian}', "");
    Expect(1, 69600, '\P{Blk=chorasmian}', "");
    Expect(0, 69600, '\P{^Blk=chorasmian}', "");
    Expect(1, 69599, '\p{Blk=:\Achorasmian\z:}', "");;
    Expect(0, 69600, '\p{Blk=:\Achorasmian\z:}', "");;
    Expect(1, 69599, '\p{Blk=	Chorasmian}', "");
    Expect(0, 69599, '\p{^Blk=	Chorasmian}', "");
    Expect(0, 69599, '\P{Blk=	Chorasmian}', "");
    Expect(1, 69599, '\P{^Blk=	Chorasmian}', "");
    Expect(0, 69600, '\p{Blk=	Chorasmian}', "");
    Expect(1, 69600, '\p{^Blk=	Chorasmian}', "");
    Expect(1, 69600, '\P{Blk=	Chorasmian}', "");
    Expect(0, 69600, '\P{^Blk=	Chorasmian}', "");
    Error('\p{Is_Block=:=  CHORASMIAN}');
    Error('\P{Is_Block=:=  CHORASMIAN}');
    Expect(1, 69599, '\p{Is_Block=chorasmian}', "");
    Expect(0, 69599, '\p{^Is_Block=chorasmian}', "");
    Expect(0, 69599, '\P{Is_Block=chorasmian}', "");
    Expect(1, 69599, '\P{^Is_Block=chorasmian}', "");
    Expect(0, 69600, '\p{Is_Block=chorasmian}', "");
    Expect(1, 69600, '\p{^Is_Block=chorasmian}', "");
    Expect(1, 69600, '\P{Is_Block=chorasmian}', "");
    Expect(0, 69600, '\P{^Is_Block=chorasmian}', "");
    Expect(1, 69599, '\p{Is_Block= _chorasmian}', "");
    Expect(0, 69599, '\p{^Is_Block= _chorasmian}', "");
    Expect(0, 69599, '\P{Is_Block= _chorasmian}', "");
    Expect(1, 69599, '\P{^Is_Block= _chorasmian}', "");
    Expect(0, 69600, '\p{Is_Block= _chorasmian}', "");
    Expect(1, 69600, '\p{^Is_Block= _chorasmian}', "");
    Expect(1, 69600, '\P{Is_Block= _chorasmian}', "");
    Expect(0, 69600, '\P{^Is_Block= _chorasmian}', "");
    Error('\p{Is_Blk=-	Chorasmian/a/}');
    Error('\P{Is_Blk=-	Chorasmian/a/}');
    Expect(1, 69599, '\p{Is_Blk=chorasmian}', "");
    Expect(0, 69599, '\p{^Is_Blk=chorasmian}', "");
    Expect(0, 69599, '\P{Is_Blk=chorasmian}', "");
    Expect(1, 69599, '\P{^Is_Blk=chorasmian}', "");
    Expect(0, 69600, '\p{Is_Blk=chorasmian}', "");
    Expect(1, 69600, '\p{^Is_Blk=chorasmian}', "");
    Expect(1, 69600, '\P{Is_Blk=chorasmian}', "");
    Expect(0, 69600, '\P{^Is_Blk=chorasmian}', "");
    Expect(1, 69599, '\p{Is_Blk=		chorasmian}', "");
    Expect(0, 69599, '\p{^Is_Blk=		chorasmian}', "");
    Expect(0, 69599, '\P{Is_Blk=		chorasmian}', "");
    Expect(1, 69599, '\P{^Is_Blk=		chorasmian}', "");
    Expect(0, 69600, '\p{Is_Blk=		chorasmian}', "");
    Expect(1, 69600, '\p{^Is_Blk=		chorasmian}', "");
    Expect(1, 69600, '\P{Is_Blk=		chorasmian}', "");
    Expect(0, 69600, '\P{^Is_Blk=		chorasmian}', "");
    Error('\p{Block=/a/ -CJK_Unified_ideographs}');
    Error('\P{Block=/a/ -CJK_Unified_ideographs}');
    Expect(1, 40959, '\p{Block=:\ACJK_Unified_Ideographs\z:}', "");;
    Expect(0, 40960, '\p{Block=:\ACJK_Unified_Ideographs\z:}', "");;
    Expect(1, 40959, '\p{Block=cjkunifiedideographs}', "");
    Expect(0, 40959, '\p{^Block=cjkunifiedideographs}', "");
    Expect(0, 40959, '\P{Block=cjkunifiedideographs}', "");
    Expect(1, 40959, '\P{^Block=cjkunifiedideographs}', "");
    Expect(0, 40960, '\p{Block=cjkunifiedideographs}', "");
    Expect(1, 40960, '\p{^Block=cjkunifiedideographs}', "");
    Expect(1, 40960, '\P{Block=cjkunifiedideographs}', "");
    Expect(0, 40960, '\P{^Block=cjkunifiedideographs}', "");
    Expect(1, 40959, '\p{Block=:\Acjkunifiedideographs\z:}', "");;
    Expect(0, 40960, '\p{Block=:\Acjkunifiedideographs\z:}', "");;
    Expect(1, 40959, '\p{Block=--CJK_Unified_Ideographs}', "");
    Expect(0, 40959, '\p{^Block=--CJK_Unified_Ideographs}', "");
    Expect(0, 40959, '\P{Block=--CJK_Unified_Ideographs}', "");
    Expect(1, 40959, '\P{^Block=--CJK_Unified_Ideographs}', "");
    Expect(0, 40960, '\p{Block=--CJK_Unified_Ideographs}', "");
    Expect(1, 40960, '\p{^Block=--CJK_Unified_Ideographs}', "");
    Expect(1, 40960, '\P{Block=--CJK_Unified_Ideographs}', "");
    Expect(0, 40960, '\P{^Block=--CJK_Unified_Ideographs}', "");
    Error('\p{Blk=:=_ CJK}');
    Error('\P{Blk=:=_ CJK}');
    Expect(1, 40959, '\p{Blk=:\ACJK\z:}', "");;
    Expect(0, 40960, '\p{Blk=:\ACJK\z:}', "");;
    Expect(1, 40959, '\p{Blk=cjk}', "");
    Expect(0, 40959, '\p{^Blk=cjk}', "");
    Expect(0, 40959, '\P{Blk=cjk}', "");
    Expect(1, 40959, '\P{^Blk=cjk}', "");
    Expect(0, 40960, '\p{Blk=cjk}', "");
    Expect(1, 40960, '\p{^Blk=cjk}', "");
    Expect(1, 40960, '\P{Blk=cjk}', "");
    Expect(0, 40960, '\P{^Blk=cjk}', "");
    Expect(1, 40959, '\p{Blk=:\Acjk\z:}', "");;
    Expect(0, 40960, '\p{Blk=:\Acjk\z:}', "");;
    Expect(1, 40959, '\p{Blk:		_cjk}', "");
    Expect(0, 40959, '\p{^Blk:		_cjk}', "");
    Expect(0, 40959, '\P{Blk:		_cjk}', "");
    Expect(1, 40959, '\P{^Blk:		_cjk}', "");
    Expect(0, 40960, '\p{Blk:		_cjk}', "");
    Expect(1, 40960, '\p{^Blk:		_cjk}', "");
    Expect(1, 40960, '\P{Blk:		_cjk}', "");
    Expect(0, 40960, '\P{^Blk:		_cjk}', "");
    Error('\p{Is_Block=:=-_cjk_Unified_ideographs}');
    Error('\P{Is_Block=:=-_cjk_Unified_ideographs}');
    Expect(1, 40959, '\p{Is_Block=cjkunifiedideographs}', "");
    Expect(0, 40959, '\p{^Is_Block=cjkunifiedideographs}', "");
    Expect(0, 40959, '\P{Is_Block=cjkunifiedideographs}', "");
    Expect(1, 40959, '\P{^Is_Block=cjkunifiedideographs}', "");
    Expect(0, 40960, '\p{Is_Block=cjkunifiedideographs}', "");
    Expect(1, 40960, '\p{^Is_Block=cjkunifiedideographs}', "");
    Expect(1, 40960, '\P{Is_Block=cjkunifiedideographs}', "");
    Expect(0, 40960, '\P{^Is_Block=cjkunifiedideographs}', "");
    Expect(1, 40959, '\p{Is_Block=_ CJK_Unified_Ideographs}', "");
    Expect(0, 40959, '\p{^Is_Block=_ CJK_Unified_Ideographs}', "");
    Expect(0, 40959, '\P{Is_Block=_ CJK_Unified_Ideographs}', "");
    Expect(1, 40959, '\P{^Is_Block=_ CJK_Unified_Ideographs}', "");
    Expect(0, 40960, '\p{Is_Block=_ CJK_Unified_Ideographs}', "");
    Expect(1, 40960, '\p{^Is_Block=_ CJK_Unified_Ideographs}', "");
    Expect(1, 40960, '\P{Is_Block=_ CJK_Unified_Ideographs}', "");
    Expect(0, 40960, '\P{^Is_Block=_ CJK_Unified_Ideographs}', "");
    Error('\p{Is_Blk=:= cjk}');
    Error('\P{Is_Blk=:= cjk}');
    Expect(1, 40959, '\p{Is_Blk=cjk}', "");
    Expect(0, 40959, '\p{^Is_Blk=cjk}', "");
    Expect(0, 40959, '\P{Is_Blk=cjk}', "");
    Expect(1, 40959, '\P{^Is_Blk=cjk}', "");
    Expect(0, 40960, '\p{Is_Blk=cjk}', "");
    Expect(1, 40960, '\p{^Is_Blk=cjk}', "");
    Expect(1, 40960, '\P{Is_Blk=cjk}', "");
    Expect(0, 40960, '\P{^Is_Blk=cjk}', "");
    Expect(1, 40959, '\p{Is_Blk= 	cjk}', "");
    Expect(0, 40959, '\p{^Is_Blk= 	cjk}', "");
    Expect(0, 40959, '\P{Is_Blk= 	cjk}', "");
    Expect(1, 40959, '\P{^Is_Blk= 	cjk}', "");
    Expect(0, 40960, '\p{Is_Blk= 	cjk}', "");
    Expect(1, 40960, '\p{^Is_Blk= 	cjk}', "");
    Expect(1, 40960, '\P{Is_Blk= 	cjk}', "");
    Expect(0, 40960, '\P{^Is_Blk= 	cjk}', "");
    Error('\p{Block:   		CJK_Compatibility:=}');
    Error('\P{Block:   		CJK_Compatibility:=}');
    Expect(1, 13311, '\p{Block=:\ACJK_Compatibility\z:}', "");;
    Expect(0, 13312, '\p{Block=:\ACJK_Compatibility\z:}', "");;
    Expect(1, 13311, '\p{Block:	cjkcompatibility}', "");
    Expect(0, 13311, '\p{^Block:	cjkcompatibility}', "");
    Expect(0, 13311, '\P{Block:	cjkcompatibility}', "");
    Expect(1, 13311, '\P{^Block:	cjkcompatibility}', "");
    Expect(0, 13312, '\p{Block:	cjkcompatibility}', "");
    Expect(1, 13312, '\p{^Block:	cjkcompatibility}', "");
    Expect(1, 13312, '\P{Block:	cjkcompatibility}', "");
    Expect(0, 13312, '\P{^Block:	cjkcompatibility}', "");
    Expect(1, 13311, '\p{Block=:\Acjkcompatibility\z:}', "");;
    Expect(0, 13312, '\p{Block=:\Acjkcompatibility\z:}', "");;
    Expect(1, 13311, '\p{Block= _CJK_compatibility}', "");
    Expect(0, 13311, '\p{^Block= _CJK_compatibility}', "");
    Expect(0, 13311, '\P{Block= _CJK_compatibility}', "");
    Expect(1, 13311, '\P{^Block= _CJK_compatibility}', "");
    Expect(0, 13312, '\p{Block= _CJK_compatibility}', "");
    Expect(1, 13312, '\p{^Block= _CJK_compatibility}', "");
    Expect(1, 13312, '\P{Block= _CJK_compatibility}', "");
    Expect(0, 13312, '\P{^Block= _CJK_compatibility}', "");
    Error('\p{Blk=-:=cjk_compat}');
    Error('\P{Blk=-:=cjk_compat}');
    Expect(1, 13311, '\p{Blk=:\ACJK_Compat\z:}', "");;
    Expect(0, 13312, '\p{Blk=:\ACJK_Compat\z:}', "");;
    Expect(1, 13311, '\p{Blk=cjkcompat}', "");
    Expect(0, 13311, '\p{^Blk=cjkcompat}', "");
    Expect(0, 13311, '\P{Blk=cjkcompat}', "");
    Expect(1, 13311, '\P{^Blk=cjkcompat}', "");
    Expect(0, 13312, '\p{Blk=cjkcompat}', "");
    Expect(1, 13312, '\p{^Blk=cjkcompat}', "");
    Expect(1, 13312, '\P{Blk=cjkcompat}', "");
    Expect(0, 13312, '\P{^Blk=cjkcompat}', "");
    Expect(1, 13311, '\p{Blk=:\Acjkcompat\z:}', "");;
    Expect(0, 13312, '\p{Blk=:\Acjkcompat\z:}', "");;
    Expect(1, 13311, '\p{Blk=-CJK_Compat}', "");
    Expect(0, 13311, '\p{^Blk=-CJK_Compat}', "");
    Expect(0, 13311, '\P{Blk=-CJK_Compat}', "");
    Expect(1, 13311, '\P{^Blk=-CJK_Compat}', "");
    Expect(0, 13312, '\p{Blk=-CJK_Compat}', "");
    Expect(1, 13312, '\p{^Blk=-CJK_Compat}', "");
    Expect(1, 13312, '\P{Blk=-CJK_Compat}', "");
    Expect(0, 13312, '\P{^Blk=-CJK_Compat}', "");
    Error('\p{Is_Block=_/a/CJK_Compatibility}');
    Error('\P{Is_Block=_/a/CJK_Compatibility}');
    Expect(1, 13311, '\p{Is_Block: cjkcompatibility}', "");
    Expect(0, 13311, '\p{^Is_Block: cjkcompatibility}', "");
    Expect(0, 13311, '\P{Is_Block: cjkcompatibility}', "");
    Expect(1, 13311, '\P{^Is_Block: cjkcompatibility}', "");
    Expect(0, 13312, '\p{Is_Block: cjkcompatibility}', "");
    Expect(1, 13312, '\p{^Is_Block: cjkcompatibility}', "");
    Expect(1, 13312, '\P{Is_Block: cjkcompatibility}', "");
    Expect(0, 13312, '\P{^Is_Block: cjkcompatibility}', "");
    Expect(1, 13311, '\p{Is_Block= CJK_Compatibility}', "");
    Expect(0, 13311, '\p{^Is_Block= CJK_Compatibility}', "");
    Expect(0, 13311, '\P{Is_Block= CJK_Compatibility}', "");
    Expect(1, 13311, '\P{^Is_Block= CJK_Compatibility}', "");
    Expect(0, 13312, '\p{Is_Block= CJK_Compatibility}', "");
    Expect(1, 13312, '\p{^Is_Block= CJK_Compatibility}', "");
    Expect(1, 13312, '\P{Is_Block= CJK_Compatibility}', "");
    Expect(0, 13312, '\P{^Is_Block= CJK_Compatibility}', "");
    Error('\p{Is_Blk=/a/ cjk_Compat}');
    Error('\P{Is_Blk=/a/ cjk_Compat}');
    Expect(1, 13311, '\p{Is_Blk=cjkcompat}', "");
    Expect(0, 13311, '\p{^Is_Blk=cjkcompat}', "");
    Expect(0, 13311, '\P{Is_Blk=cjkcompat}', "");
    Expect(1, 13311, '\P{^Is_Blk=cjkcompat}', "");
    Expect(0, 13312, '\p{Is_Blk=cjkcompat}', "");
    Expect(1, 13312, '\p{^Is_Blk=cjkcompat}', "");
    Expect(1, 13312, '\P{Is_Blk=cjkcompat}', "");
    Expect(0, 13312, '\P{^Is_Blk=cjkcompat}', "");
    Expect(1, 13311, '\p{Is_Blk=		CJK_compat}', "");
    Expect(0, 13311, '\p{^Is_Blk=		CJK_compat}', "");
    Expect(0, 13311, '\P{Is_Blk=		CJK_compat}', "");
    Expect(1, 13311, '\P{^Is_Blk=		CJK_compat}', "");
    Expect(0, 13312, '\p{Is_Blk=		CJK_compat}', "");
    Expect(1, 13312, '\p{^Is_Blk=		CJK_compat}', "");
    Expect(1, 13312, '\P{Is_Blk=		CJK_compat}', "");
    Expect(0, 13312, '\P{^Is_Blk=		CJK_compat}', "");
    Error('\p{Block=:=-CJK_Compatibility_FORMS}');
    Error('\P{Block=:=-CJK_Compatibility_FORMS}');
    Expect(1, 65103, '\p{Block=:\ACJK_Compatibility_Forms\z:}', "");;
    Expect(0, 65104, '\p{Block=:\ACJK_Compatibility_Forms\z:}', "");;
    Expect(1, 65103, '\p{Block=cjkcompatibilityforms}', "");
    Expect(0, 65103, '\p{^Block=cjkcompatibilityforms}', "");
    Expect(0, 65103, '\P{Block=cjkcompatibilityforms}', "");
    Expect(1, 65103, '\P{^Block=cjkcompatibilityforms}', "");
    Expect(0, 65104, '\p{Block=cjkcompatibilityforms}', "");
    Expect(1, 65104, '\p{^Block=cjkcompatibilityforms}', "");
    Expect(1, 65104, '\P{Block=cjkcompatibilityforms}', "");
    Expect(0, 65104, '\P{^Block=cjkcompatibilityforms}', "");
    Expect(1, 65103, '\p{Block=:\Acjkcompatibilityforms\z:}', "");;
    Expect(0, 65104, '\p{Block=:\Acjkcompatibilityforms\z:}', "");;
    Expect(1, 65103, '\p{Block=	_CJK_compatibility_Forms}', "");
    Expect(0, 65103, '\p{^Block=	_CJK_compatibility_Forms}', "");
    Expect(0, 65103, '\P{Block=	_CJK_compatibility_Forms}', "");
    Expect(1, 65103, '\P{^Block=	_CJK_compatibility_Forms}', "");
    Expect(0, 65104, '\p{Block=	_CJK_compatibility_Forms}', "");
    Expect(1, 65104, '\p{^Block=	_CJK_compatibility_Forms}', "");
    Expect(1, 65104, '\P{Block=	_CJK_compatibility_Forms}', "");
    Expect(0, 65104, '\P{^Block=	_CJK_compatibility_Forms}', "");
    Error('\p{Blk=-CJK_compat_Forms/a/}');
    Error('\P{Blk=-CJK_compat_Forms/a/}');
    Expect(1, 65103, '\p{Blk=:\ACJK_Compat_Forms\z:}', "");;
    Expect(0, 65104, '\p{Blk=:\ACJK_Compat_Forms\z:}', "");;
    Expect(1, 65103, '\p{Blk=cjkcompatforms}', "");
    Expect(0, 65103, '\p{^Blk=cjkcompatforms}', "");
    Expect(0, 65103, '\P{Blk=cjkcompatforms}', "");
    Expect(1, 65103, '\P{^Blk=cjkcompatforms}', "");
    Expect(0, 65104, '\p{Blk=cjkcompatforms}', "");
    Expect(1, 65104, '\p{^Blk=cjkcompatforms}', "");
    Expect(1, 65104, '\P{Blk=cjkcompatforms}', "");
    Expect(0, 65104, '\P{^Blk=cjkcompatforms}', "");
    Expect(1, 65103, '\p{Blk=:\Acjkcompatforms\z:}', "");;
    Expect(0, 65104, '\p{Blk=:\Acjkcompatforms\z:}', "");;
    Expect(1, 65103, '\p{Blk= 	cjk_Compat_Forms}', "");
    Expect(0, 65103, '\p{^Blk= 	cjk_Compat_Forms}', "");
    Expect(0, 65103, '\P{Blk= 	cjk_Compat_Forms}', "");
    Expect(1, 65103, '\P{^Blk= 	cjk_Compat_Forms}', "");
    Expect(0, 65104, '\p{Blk= 	cjk_Compat_Forms}', "");
    Expect(1, 65104, '\p{^Blk= 	cjk_Compat_Forms}', "");
    Expect(1, 65104, '\P{Blk= 	cjk_Compat_Forms}', "");
    Expect(0, 65104, '\P{^Blk= 	cjk_Compat_Forms}', "");
    Error('\p{Is_Block: :=-CJK_Compatibility_FORMS}');
    Error('\P{Is_Block: :=-CJK_Compatibility_FORMS}');
    Expect(1, 65103, '\p{Is_Block=cjkcompatibilityforms}', "");
    Expect(0, 65103, '\p{^Is_Block=cjkcompatibilityforms}', "");
    Expect(0, 65103, '\P{Is_Block=cjkcompatibilityforms}', "");
    Expect(1, 65103, '\P{^Is_Block=cjkcompatibilityforms}', "");
    Expect(0, 65104, '\p{Is_Block=cjkcompatibilityforms}', "");
    Expect(1, 65104, '\p{^Is_Block=cjkcompatibilityforms}', "");
    Expect(1, 65104, '\P{Is_Block=cjkcompatibilityforms}', "");
    Expect(0, 65104, '\P{^Is_Block=cjkcompatibilityforms}', "");
    Expect(1, 65103, '\p{Is_Block:    CJK_Compatibility_FORMS}', "");
    Expect(0, 65103, '\p{^Is_Block:    CJK_Compatibility_FORMS}', "");
    Expect(0, 65103, '\P{Is_Block:    CJK_Compatibility_FORMS}', "");
    Expect(1, 65103, '\P{^Is_Block:    CJK_Compatibility_FORMS}', "");
    Expect(0, 65104, '\p{Is_Block:    CJK_Compatibility_FORMS}', "");
    Expect(1, 65104, '\p{^Is_Block:    CJK_Compatibility_FORMS}', "");
    Expect(1, 65104, '\P{Is_Block:    CJK_Compatibility_FORMS}', "");
    Expect(0, 65104, '\P{^Is_Block:    CJK_Compatibility_FORMS}', "");
    Error('\p{Is_Blk=_:=CJK_compat_FORMS}');
    Error('\P{Is_Blk=_:=CJK_compat_FORMS}');
    Expect(1, 65103, '\p{Is_Blk=cjkcompatforms}', "");
    Expect(0, 65103, '\p{^Is_Blk=cjkcompatforms}', "");
    Expect(0, 65103, '\P{Is_Blk=cjkcompatforms}', "");
    Expect(1, 65103, '\P{^Is_Blk=cjkcompatforms}', "");
    Expect(0, 65104, '\p{Is_Blk=cjkcompatforms}', "");
    Expect(1, 65104, '\p{^Is_Blk=cjkcompatforms}', "");
    Expect(1, 65104, '\P{Is_Blk=cjkcompatforms}', "");
    Expect(0, 65104, '\P{^Is_Blk=cjkcompatforms}', "");
    Expect(1, 65103, '\p{Is_Blk= _CJK_Compat_forms}', "");
    Expect(0, 65103, '\p{^Is_Blk= _CJK_Compat_forms}', "");
    Expect(0, 65103, '\P{Is_Blk= _CJK_Compat_forms}', "");
    Expect(1, 65103, '\P{^Is_Blk= _CJK_Compat_forms}', "");
    Expect(0, 65104, '\p{Is_Blk= _CJK_Compat_forms}', "");
    Expect(1, 65104, '\p{^Is_Blk= _CJK_Compat_forms}', "");
    Expect(1, 65104, '\P{Is_Blk= _CJK_Compat_forms}', "");
    Expect(0, 65104, '\P{^Is_Blk= _CJK_Compat_forms}', "");
    Error('\p{Block=/a/- CJK_COMPATIBILITY_IDEOGRAPHS}');
    Error('\P{Block=/a/- CJK_COMPATIBILITY_IDEOGRAPHS}');
    Expect(1, 64255, '\p{Block=:\ACJK_Compatibility_Ideographs\z:}', "");;
    Expect(0, 64256, '\p{Block=:\ACJK_Compatibility_Ideographs\z:}', "");;
    Expect(1, 64255, '\p{Block=cjkcompatibilityideographs}', "");
    Expect(0, 64255, '\p{^Block=cjkcompatibilityideographs}', "");
    Expect(0, 64255, '\P{Block=cjkcompatibilityideographs}', "");
    Expect(1, 64255, '\P{^Block=cjkcompatibilityideographs}', "");
    Expect(0, 64256, '\p{Block=cjkcompatibilityideographs}', "");
    Expect(1, 64256, '\p{^Block=cjkcompatibilityideographs}', "");
    Expect(1, 64256, '\P{Block=cjkcompatibilityideographs}', "");
    Expect(0, 64256, '\P{^Block=cjkcompatibilityideographs}', "");
    Expect(1, 64255, '\p{Block=:\Acjkcompatibilityideographs\z:}', "");;
    Expect(0, 64256, '\p{Block=:\Acjkcompatibilityideographs\z:}', "");;
    Expect(1, 64255, '\p{Block=	_CJK_COMPATIBILITY_IDEOGRAPHS}', "");
    Expect(0, 64255, '\p{^Block=	_CJK_COMPATIBILITY_IDEOGRAPHS}', "");
    Expect(0, 64255, '\P{Block=	_CJK_COMPATIBILITY_IDEOGRAPHS}', "");
    Expect(1, 64255, '\P{^Block=	_CJK_COMPATIBILITY_IDEOGRAPHS}', "");
    Expect(0, 64256, '\p{Block=	_CJK_COMPATIBILITY_IDEOGRAPHS}', "");
    Expect(1, 64256, '\p{^Block=	_CJK_COMPATIBILITY_IDEOGRAPHS}', "");
    Expect(1, 64256, '\P{Block=	_CJK_COMPATIBILITY_IDEOGRAPHS}', "");
    Expect(0, 64256, '\P{^Block=	_CJK_COMPATIBILITY_IDEOGRAPHS}', "");
    Error('\p{Blk=-/a/CJK_compat_IDEOGRAPHS}');
    Error('\P{Blk=-/a/CJK_compat_IDEOGRAPHS}');
    Expect(1, 64255, '\p{Blk=:\ACJK_Compat_Ideographs\z:}', "");;
    Expect(0, 64256, '\p{Blk=:\ACJK_Compat_Ideographs\z:}', "");;
    Expect(1, 64255, '\p{Blk=cjkcompatideographs}', "");
    Expect(0, 64255, '\p{^Blk=cjkcompatideographs}', "");
    Expect(0, 64255, '\P{Blk=cjkcompatideographs}', "");
    Expect(1, 64255, '\P{^Blk=cjkcompatideographs}', "");
    Expect(0, 64256, '\p{Blk=cjkcompatideographs}', "");
    Expect(1, 64256, '\p{^Blk=cjkcompatideographs}', "");
    Expect(1, 64256, '\P{Blk=cjkcompatideographs}', "");
    Expect(0, 64256, '\P{^Blk=cjkcompatideographs}', "");
    Expect(1, 64255, '\p{Blk=:\Acjkcompatideographs\z:}', "");;
    Expect(0, 64256, '\p{Blk=:\Acjkcompatideographs\z:}', "");;
    Expect(1, 64255, '\p{Blk= _cjk_COMPAT_IDEOGRAPHS}', "");
    Expect(0, 64255, '\p{^Blk= _cjk_COMPAT_IDEOGRAPHS}', "");
    Expect(0, 64255, '\P{Blk= _cjk_COMPAT_IDEOGRAPHS}', "");
    Expect(1, 64255, '\P{^Blk= _cjk_COMPAT_IDEOGRAPHS}', "");
    Expect(0, 64256, '\p{Blk= _cjk_COMPAT_IDEOGRAPHS}', "");
    Expect(1, 64256, '\p{^Blk= _cjk_COMPAT_IDEOGRAPHS}', "");
    Expect(1, 64256, '\P{Blk= _cjk_COMPAT_IDEOGRAPHS}', "");
    Expect(0, 64256, '\P{^Blk= _cjk_COMPAT_IDEOGRAPHS}', "");
    Error('\p{Is_Block=-/a/CJK_Compatibility_Ideographs}');
    Error('\P{Is_Block=-/a/CJK_Compatibility_Ideographs}');
    Expect(1, 64255, '\p{Is_Block=cjkcompatibilityideographs}', "");
    Expect(0, 64255, '\p{^Is_Block=cjkcompatibilityideographs}', "");
    Expect(0, 64255, '\P{Is_Block=cjkcompatibilityideographs}', "");
    Expect(1, 64255, '\P{^Is_Block=cjkcompatibilityideographs}', "");
    Expect(0, 64256, '\p{Is_Block=cjkcompatibilityideographs}', "");
    Expect(1, 64256, '\p{^Is_Block=cjkcompatibilityideographs}', "");
    Expect(1, 64256, '\P{Is_Block=cjkcompatibilityideographs}', "");
    Expect(0, 64256, '\P{^Is_Block=cjkcompatibilityideographs}', "");
    Expect(1, 64255, '\p{Is_Block= 	cjk_Compatibility_IDEOGRAPHS}', "");
    Expect(0, 64255, '\p{^Is_Block= 	cjk_Compatibility_IDEOGRAPHS}', "");
    Expect(0, 64255, '\P{Is_Block= 	cjk_Compatibility_IDEOGRAPHS}', "");
    Expect(1, 64255, '\P{^Is_Block= 	cjk_Compatibility_IDEOGRAPHS}', "");
    Expect(0, 64256, '\p{Is_Block= 	cjk_Compatibility_IDEOGRAPHS}', "");
    Expect(1, 64256, '\p{^Is_Block= 	cjk_Compatibility_IDEOGRAPHS}', "");
    Expect(1, 64256, '\P{Is_Block= 	cjk_Compatibility_IDEOGRAPHS}', "");
    Expect(0, 64256, '\P{^Is_Block= 	cjk_Compatibility_IDEOGRAPHS}', "");
    Error('\p{Is_Blk=/a/--cjk_COMPAT_IDEOGRAPHS}');
    Error('\P{Is_Blk=/a/--cjk_COMPAT_IDEOGRAPHS}');
    Expect(1, 64255, '\p{Is_Blk:cjkcompatideographs}', "");
    Expect(0, 64255, '\p{^Is_Blk:cjkcompatideographs}', "");
    Expect(0, 64255, '\P{Is_Blk:cjkcompatideographs}', "");
    Expect(1, 64255, '\P{^Is_Blk:cjkcompatideographs}', "");
    Expect(0, 64256, '\p{Is_Blk:cjkcompatideographs}', "");
    Expect(1, 64256, '\p{^Is_Blk:cjkcompatideographs}', "");
    Expect(1, 64256, '\P{Is_Blk:cjkcompatideographs}', "");
    Expect(0, 64256, '\P{^Is_Blk:cjkcompatideographs}', "");
    Expect(1, 64255, '\p{Is_Blk=- cjk_COMPAT_Ideographs}', "");
    Expect(0, 64255, '\p{^Is_Blk=- cjk_COMPAT_Ideographs}', "");
    Expect(0, 64255, '\P{Is_Blk=- cjk_COMPAT_Ideographs}', "");
    Expect(1, 64255, '\P{^Is_Blk=- cjk_COMPAT_Ideographs}', "");
    Expect(0, 64256, '\p{Is_Blk=- cjk_COMPAT_Ideographs}', "");
    Expect(1, 64256, '\p{^Is_Blk=- cjk_COMPAT_Ideographs}', "");
    Expect(1, 64256, '\P{Is_Blk=- cjk_COMPAT_Ideographs}', "");
    Expect(0, 64256, '\P{^Is_Blk=- cjk_COMPAT_Ideographs}', "");
    Error('\p{Block=:= _cjk_Compatibility_ideographs_Supplement}');
    Error('\P{Block=:= _cjk_Compatibility_ideographs_Supplement}');
    Expect(1, 195103, '\p{Block=:\ACJK_Compatibility_Ideographs_Supplement\z:}', "");;
    Expect(0, 195104, '\p{Block=:\ACJK_Compatibility_Ideographs_Supplement\z:}', "");;
    Expect(1, 195103, '\p{Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195103, '\p{^Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195103, '\P{Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195103, '\P{^Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195104, '\p{Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195104, '\p{^Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195104, '\P{Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195104, '\P{^Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195103, '\p{Block=:\Acjkcompatibilityideographssupplement\z:}', "");;
    Expect(0, 195104, '\p{Block=:\Acjkcompatibilityideographssupplement\z:}', "");;
    Expect(1, 195103, '\p{Block:_	CJK_COMPATIBILITY_Ideographs_supplement}', "");
    Expect(0, 195103, '\p{^Block:_	CJK_COMPATIBILITY_Ideographs_supplement}', "");
    Expect(0, 195103, '\P{Block:_	CJK_COMPATIBILITY_Ideographs_supplement}', "");
    Expect(1, 195103, '\P{^Block:_	CJK_COMPATIBILITY_Ideographs_supplement}', "");
    Expect(0, 195104, '\p{Block:_	CJK_COMPATIBILITY_Ideographs_supplement}', "");
    Expect(1, 195104, '\p{^Block:_	CJK_COMPATIBILITY_Ideographs_supplement}', "");
    Expect(1, 195104, '\P{Block:_	CJK_COMPATIBILITY_Ideographs_supplement}', "");
    Expect(0, 195104, '\P{^Block:_	CJK_COMPATIBILITY_Ideographs_supplement}', "");
    Error('\p{Blk::=-CJK_Compat_IDEOGRAPHS_Sup}');
    Error('\P{Blk::=-CJK_Compat_IDEOGRAPHS_Sup}');
    Expect(1, 195103, '\p{Blk=:\ACJK_Compat_Ideographs_Sup\z:}', "");;
    Expect(0, 195104, '\p{Blk=:\ACJK_Compat_Ideographs_Sup\z:}', "");;
    Expect(1, 195103, '\p{Blk=cjkcompatideographssup}', "");
    Expect(0, 195103, '\p{^Blk=cjkcompatideographssup}', "");
    Expect(0, 195103, '\P{Blk=cjkcompatideographssup}', "");
    Expect(1, 195103, '\P{^Blk=cjkcompatideographssup}', "");
    Expect(0, 195104, '\p{Blk=cjkcompatideographssup}', "");
    Expect(1, 195104, '\p{^Blk=cjkcompatideographssup}', "");
    Expect(1, 195104, '\P{Blk=cjkcompatideographssup}', "");
    Expect(0, 195104, '\P{^Blk=cjkcompatideographssup}', "");
    Expect(1, 195103, '\p{Blk=:\Acjkcompatideographssup\z:}', "");;
    Expect(0, 195104, '\p{Blk=:\Acjkcompatideographssup\z:}', "");;
    Expect(1, 195103, '\p{Blk:   	 CJK_COMPAT_Ideographs_Sup}', "");
    Expect(0, 195103, '\p{^Blk:   	 CJK_COMPAT_Ideographs_Sup}', "");
    Expect(0, 195103, '\P{Blk:   	 CJK_COMPAT_Ideographs_Sup}', "");
    Expect(1, 195103, '\P{^Blk:   	 CJK_COMPAT_Ideographs_Sup}', "");
    Expect(0, 195104, '\p{Blk:   	 CJK_COMPAT_Ideographs_Sup}', "");
    Expect(1, 195104, '\p{^Blk:   	 CJK_COMPAT_Ideographs_Sup}', "");
    Expect(1, 195104, '\P{Blk:   	 CJK_COMPAT_Ideographs_Sup}', "");
    Expect(0, 195104, '\P{^Blk:   	 CJK_COMPAT_Ideographs_Sup}', "");
    Error('\p{Is_Block:	/a/CJK_Compatibility_IDEOGRAPHS_Supplement}');
    Error('\P{Is_Block:	/a/CJK_Compatibility_IDEOGRAPHS_Supplement}');
    Expect(1, 195103, '\p{Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195103, '\p{^Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195103, '\P{Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195103, '\P{^Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195104, '\p{Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195104, '\p{^Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195104, '\P{Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195104, '\P{^Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195103, '\p{Is_Block= -cjk_compatibility_Ideographs_SUPPLEMENT}', "");
    Expect(0, 195103, '\p{^Is_Block= -cjk_compatibility_Ideographs_SUPPLEMENT}', "");
    Expect(0, 195103, '\P{Is_Block= -cjk_compatibility_Ideographs_SUPPLEMENT}', "");
    Expect(1, 195103, '\P{^Is_Block= -cjk_compatibility_Ideographs_SUPPLEMENT}', "");
    Expect(0, 195104, '\p{Is_Block= -cjk_compatibility_Ideographs_SUPPLEMENT}', "");
    Expect(1, 195104, '\p{^Is_Block= -cjk_compatibility_Ideographs_SUPPLEMENT}', "");
    Expect(1, 195104, '\P{Is_Block= -cjk_compatibility_Ideographs_SUPPLEMENT}', "");
    Expect(0, 195104, '\P{^Is_Block= -cjk_compatibility_Ideographs_SUPPLEMENT}', "");
    Error('\p{Is_Blk=/a/__CJK_compat_IDEOGRAPHS_SUP}');
    Error('\P{Is_Blk=/a/__CJK_compat_IDEOGRAPHS_SUP}');
    Expect(1, 195103, '\p{Is_Blk=cjkcompatideographssup}', "");
    Expect(0, 195103, '\p{^Is_Blk=cjkcompatideographssup}', "");
    Expect(0, 195103, '\P{Is_Blk=cjkcompatideographssup}', "");
    Expect(1, 195103, '\P{^Is_Blk=cjkcompatideographssup}', "");
    Expect(0, 195104, '\p{Is_Blk=cjkcompatideographssup}', "");
    Expect(1, 195104, '\p{^Is_Blk=cjkcompatideographssup}', "");
    Expect(1, 195104, '\P{Is_Blk=cjkcompatideographssup}', "");
    Expect(0, 195104, '\P{^Is_Blk=cjkcompatideographssup}', "");
    Expect(1, 195103, '\p{Is_Blk= 	CJK_compat_Ideographs_sup}', "");
    Expect(0, 195103, '\p{^Is_Blk= 	CJK_compat_Ideographs_sup}', "");
    Expect(0, 195103, '\P{Is_Blk= 	CJK_compat_Ideographs_sup}', "");
    Expect(1, 195103, '\P{^Is_Blk= 	CJK_compat_Ideographs_sup}', "");
    Expect(0, 195104, '\p{Is_Blk= 	CJK_compat_Ideographs_sup}', "");
    Expect(1, 195104, '\p{^Is_Blk= 	CJK_compat_Ideographs_sup}', "");
    Expect(1, 195104, '\P{Is_Blk= 	CJK_compat_Ideographs_sup}', "");
    Expect(0, 195104, '\P{^Is_Blk= 	CJK_compat_Ideographs_sup}', "");
    Error('\p{Block: _cjk_Unified_Ideographs_Extension_A:=}');
    Error('\P{Block: _cjk_Unified_Ideographs_Extension_A:=}');
    Expect(1, 19903, '\p{Block=:\ACJK_Unified_Ideographs_Extension_A\z:}', "");;
    Expect(0, 19904, '\p{Block=:\ACJK_Unified_Ideographs_Extension_A\z:}', "");;
    Expect(1, 19903, '\p{Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19903, '\p{^Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19903, '\P{Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19903, '\P{^Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19904, '\p{Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19904, '\p{^Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19904, '\P{Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19904, '\P{^Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19903, '\p{Block=:\Acjkunifiedideographsextensiona\z:}', "");;
    Expect(0, 19904, '\p{Block=:\Acjkunifiedideographsextensiona\z:}', "");;
    Expect(1, 19903, '\p{Block= -cjk_UNIFIED_IDEOGRAPHS_extension_A}', "");
    Expect(0, 19903, '\p{^Block= -cjk_UNIFIED_IDEOGRAPHS_extension_A}', "");
    Expect(0, 19903, '\P{Block= -cjk_UNIFIED_IDEOGRAPHS_extension_A}', "");
    Expect(1, 19903, '\P{^Block= -cjk_UNIFIED_IDEOGRAPHS_extension_A}', "");
    Expect(0, 19904, '\p{Block= -cjk_UNIFIED_IDEOGRAPHS_extension_A}', "");
    Expect(1, 19904, '\p{^Block= -cjk_UNIFIED_IDEOGRAPHS_extension_A}', "");
    Expect(1, 19904, '\P{Block= -cjk_UNIFIED_IDEOGRAPHS_extension_A}', "");
    Expect(0, 19904, '\P{^Block= -cjk_UNIFIED_IDEOGRAPHS_extension_A}', "");
    Error('\p{Blk=		CJK_Ext_A:=}');
    Error('\P{Blk=		CJK_Ext_A:=}');
    Expect(1, 19903, '\p{Blk=:\ACJK_Ext_A\z:}', "");;
    Expect(0, 19904, '\p{Blk=:\ACJK_Ext_A\z:}', "");;
    Expect(1, 19903, '\p{Blk=cjkexta}', "");
    Expect(0, 19903, '\p{^Blk=cjkexta}', "");
    Expect(0, 19903, '\P{Blk=cjkexta}', "");
    Expect(1, 19903, '\P{^Blk=cjkexta}', "");
    Expect(0, 19904, '\p{Blk=cjkexta}', "");
    Expect(1, 19904, '\p{^Blk=cjkexta}', "");
    Expect(1, 19904, '\P{Blk=cjkexta}', "");
    Expect(0, 19904, '\P{^Blk=cjkexta}', "");
    Expect(1, 19903, '\p{Blk=:\Acjkexta\z:}', "");;
    Expect(0, 19904, '\p{Blk=:\Acjkexta\z:}', "");;
    Expect(1, 19903, '\p{Blk= 	CJK_EXT_A}', "");
    Expect(0, 19903, '\p{^Blk= 	CJK_EXT_A}', "");
    Expect(0, 19903, '\P{Blk= 	CJK_EXT_A}', "");
    Expect(1, 19903, '\P{^Blk= 	CJK_EXT_A}', "");
    Expect(0, 19904, '\p{Blk= 	CJK_EXT_A}', "");
    Expect(1, 19904, '\p{^Blk= 	CJK_EXT_A}', "");
    Expect(1, 19904, '\P{Blk= 	CJK_EXT_A}', "");
    Expect(0, 19904, '\P{^Blk= 	CJK_EXT_A}', "");
    Error('\p{Is_Block=	_cjk_UNIFIED_ideographs_Extension_A:=}');
    Error('\P{Is_Block=	_cjk_UNIFIED_ideographs_Extension_A:=}');
    Expect(1, 19903, '\p{Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19903, '\p{^Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19903, '\P{Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19903, '\P{^Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19904, '\p{Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19904, '\p{^Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19904, '\P{Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19904, '\P{^Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19903, '\p{Is_Block= CJK_Unified_Ideographs_extension_A}', "");
    Expect(0, 19903, '\p{^Is_Block= CJK_Unified_Ideographs_extension_A}', "");
    Expect(0, 19903, '\P{Is_Block= CJK_Unified_Ideographs_extension_A}', "");
    Expect(1, 19903, '\P{^Is_Block= CJK_Unified_Ideographs_extension_A}', "");
    Expect(0, 19904, '\p{Is_Block= CJK_Unified_Ideographs_extension_A}', "");
    Expect(1, 19904, '\p{^Is_Block= CJK_Unified_Ideographs_extension_A}', "");
    Expect(1, 19904, '\P{Is_Block= CJK_Unified_Ideographs_extension_A}', "");
    Expect(0, 19904, '\P{^Is_Block= CJK_Unified_Ideographs_extension_A}', "");
    Error('\p{Is_Blk=-/a/CJK_EXT_A}');
    Error('\P{Is_Blk=-/a/CJK_EXT_A}');
    Expect(1, 19903, '\p{Is_Blk=cjkexta}', "");
    Expect(0, 19903, '\p{^Is_Blk=cjkexta}', "");
    Expect(0, 19903, '\P{Is_Blk=cjkexta}', "");
    Expect(1, 19903, '\P{^Is_Blk=cjkexta}', "");
    Expect(0, 19904, '\p{Is_Blk=cjkexta}', "");
    Expect(1, 19904, '\p{^Is_Blk=cjkexta}', "");
    Expect(1, 19904, '\P{Is_Blk=cjkexta}', "");
    Expect(0, 19904, '\P{^Is_Blk=cjkexta}', "");
    Expect(1, 19903, '\p{Is_Blk=-CJK_Ext_A}', "");
    Expect(0, 19903, '\p{^Is_Blk=-CJK_Ext_A}', "");
    Expect(0, 19903, '\P{Is_Blk=-CJK_Ext_A}', "");
    Expect(1, 19903, '\P{^Is_Blk=-CJK_Ext_A}', "");
    Expect(0, 19904, '\p{Is_Blk=-CJK_Ext_A}', "");
    Expect(1, 19904, '\p{^Is_Blk=-CJK_Ext_A}', "");
    Expect(1, 19904, '\P{Is_Blk=-CJK_Ext_A}', "");
    Expect(0, 19904, '\P{^Is_Blk=-CJK_Ext_A}', "");
    Error('\p{Block=/a/cjk_unified_ideographs_Extension_B}');
    Error('\P{Block=/a/cjk_unified_ideographs_Extension_B}');
    Expect(1, 173791, '\p{Block=:\ACJK_Unified_Ideographs_Extension_B\z:}', "");;
    Expect(0, 173792, '\p{Block=:\ACJK_Unified_Ideographs_Extension_B\z:}', "");;
    Expect(1, 173791, '\p{Block: cjkunifiedideographsextensionb}', "");
    Expect(0, 173791, '\p{^Block: cjkunifiedideographsextensionb}', "");
    Expect(0, 173791, '\P{Block: cjkunifiedideographsextensionb}', "");
    Expect(1, 173791, '\P{^Block: cjkunifiedideographsextensionb}', "");
    Expect(0, 173792, '\p{Block: cjkunifiedideographsextensionb}', "");
    Expect(1, 173792, '\p{^Block: cjkunifiedideographsextensionb}', "");
    Expect(1, 173792, '\P{Block: cjkunifiedideographsextensionb}', "");
    Expect(0, 173792, '\P{^Block: cjkunifiedideographsextensionb}', "");
    Expect(1, 173791, '\p{Block=:\Acjkunifiedideographsextensionb\z:}', "");;
    Expect(0, 173792, '\p{Block=:\Acjkunifiedideographsextensionb\z:}', "");;
    Expect(1, 173791, '\p{Block= 	cjk_Unified_Ideographs_extension_B}', "");
    Expect(0, 173791, '\p{^Block= 	cjk_Unified_Ideographs_extension_B}', "");
    Expect(0, 173791, '\P{Block= 	cjk_Unified_Ideographs_extension_B}', "");
    Expect(1, 173791, '\P{^Block= 	cjk_Unified_Ideographs_extension_B}', "");
    Expect(0, 173792, '\p{Block= 	cjk_Unified_Ideographs_extension_B}', "");
    Expect(1, 173792, '\p{^Block= 	cjk_Unified_Ideographs_extension_B}', "");
    Expect(1, 173792, '\P{Block= 	cjk_Unified_Ideographs_extension_B}', "");
    Expect(0, 173792, '\P{^Block= 	cjk_Unified_Ideographs_extension_B}', "");
    Error('\p{Blk=:= CJK_Ext_B}');
    Error('\P{Blk=:= CJK_Ext_B}');
    Expect(1, 173791, '\p{Blk=:\ACJK_Ext_B\z:}', "");;
    Expect(0, 173792, '\p{Blk=:\ACJK_Ext_B\z:}', "");;
    Expect(1, 173791, '\p{Blk=cjkextb}', "");
    Expect(0, 173791, '\p{^Blk=cjkextb}', "");
    Expect(0, 173791, '\P{Blk=cjkextb}', "");
    Expect(1, 173791, '\P{^Blk=cjkextb}', "");
    Expect(0, 173792, '\p{Blk=cjkextb}', "");
    Expect(1, 173792, '\p{^Blk=cjkextb}', "");
    Expect(1, 173792, '\P{Blk=cjkextb}', "");
    Expect(0, 173792, '\P{^Blk=cjkextb}', "");
    Expect(1, 173791, '\p{Blk=:\Acjkextb\z:}', "");;
    Expect(0, 173792, '\p{Blk=:\Acjkextb\z:}', "");;
    Expect(1, 173791, '\p{Blk= 	cjk_EXT_B}', "");
    Expect(0, 173791, '\p{^Blk= 	cjk_EXT_B}', "");
    Expect(0, 173791, '\P{Blk= 	cjk_EXT_B}', "");
    Expect(1, 173791, '\P{^Blk= 	cjk_EXT_B}', "");
    Expect(0, 173792, '\p{Blk= 	cjk_EXT_B}', "");
    Expect(1, 173792, '\p{^Blk= 	cjk_EXT_B}', "");
    Expect(1, 173792, '\P{Blk= 	cjk_EXT_B}', "");
    Expect(0, 173792, '\P{^Blk= 	cjk_EXT_B}', "");
    Error('\p{Is_Block=/a/_ cjk_UNIFIED_Ideographs_Extension_B}');
    Error('\P{Is_Block=/a/_ cjk_UNIFIED_Ideographs_Extension_B}');
    Expect(1, 173791, '\p{Is_Block: cjkunifiedideographsextensionb}', "");
    Expect(0, 173791, '\p{^Is_Block: cjkunifiedideographsextensionb}', "");
    Expect(0, 173791, '\P{Is_Block: cjkunifiedideographsextensionb}', "");
    Expect(1, 173791, '\P{^Is_Block: cjkunifiedideographsextensionb}', "");
    Expect(0, 173792, '\p{Is_Block: cjkunifiedideographsextensionb}', "");
    Expect(1, 173792, '\p{^Is_Block: cjkunifiedideographsextensionb}', "");
    Expect(1, 173792, '\P{Is_Block: cjkunifiedideographsextensionb}', "");
    Expect(0, 173792, '\P{^Is_Block: cjkunifiedideographsextensionb}', "");
    Expect(1, 173791, '\p{Is_Block=_	CJK_Unified_Ideographs_Extension_b}', "");
    Expect(0, 173791, '\p{^Is_Block=_	CJK_Unified_Ideographs_Extension_b}', "");
    Expect(0, 173791, '\P{Is_Block=_	CJK_Unified_Ideographs_Extension_b}', "");
    Expect(1, 173791, '\P{^Is_Block=_	CJK_Unified_Ideographs_Extension_b}', "");
    Expect(0, 173792, '\p{Is_Block=_	CJK_Unified_Ideographs_Extension_b}', "");
    Expect(1, 173792, '\p{^Is_Block=_	CJK_Unified_Ideographs_Extension_b}', "");
    Expect(1, 173792, '\P{Is_Block=_	CJK_Unified_Ideographs_Extension_b}', "");
    Expect(0, 173792, '\P{^Is_Block=_	CJK_Unified_Ideographs_Extension_b}', "");
    Error('\p{Is_Blk:	_-CJK_EXT_b/a/}');
    Error('\P{Is_Blk:	_-CJK_EXT_b/a/}');
    Expect(1, 173791, '\p{Is_Blk:	cjkextb}', "");
    Expect(0, 173791, '\p{^Is_Blk:	cjkextb}', "");
    Expect(0, 173791, '\P{Is_Blk:	cjkextb}', "");
    Expect(1, 173791, '\P{^Is_Blk:	cjkextb}', "");
    Expect(0, 173792, '\p{Is_Blk:	cjkextb}', "");
    Expect(1, 173792, '\p{^Is_Blk:	cjkextb}', "");
    Expect(1, 173792, '\P{Is_Blk:	cjkextb}', "");
    Expect(0, 173792, '\P{^Is_Blk:	cjkextb}', "");
    Expect(1, 173791, '\p{Is_Blk=__CJK_EXT_B}', "");
    Expect(0, 173791, '\p{^Is_Blk=__CJK_EXT_B}', "");
    Expect(0, 173791, '\P{Is_Blk=__CJK_EXT_B}', "");
    Expect(1, 173791, '\P{^Is_Blk=__CJK_EXT_B}', "");
    Expect(0, 173792, '\p{Is_Blk=__CJK_EXT_B}', "");
    Expect(1, 173792, '\p{^Is_Blk=__CJK_EXT_B}', "");
    Expect(1, 173792, '\P{Is_Blk=__CJK_EXT_B}', "");
    Expect(0, 173792, '\P{^Is_Blk=__CJK_EXT_B}', "");
    Error('\p{Block:	/a/  CJK_UNIFIED_IDEOGRAPHS_Extension_C}');
    Error('\P{Block:	/a/  CJK_UNIFIED_IDEOGRAPHS_Extension_C}');
    Expect(1, 177983, '\p{Block=:\ACJK_Unified_Ideographs_Extension_C\z:}', "");;
    Expect(0, 177984, '\p{Block=:\ACJK_Unified_Ideographs_Extension_C\z:}', "");;
    Expect(1, 177983, '\p{Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177983, '\p{^Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177983, '\P{Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177983, '\P{^Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177984, '\p{Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177984, '\p{^Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177984, '\P{Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177984, '\P{^Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177983, '\p{Block=:\Acjkunifiedideographsextensionc\z:}', "");;
    Expect(0, 177984, '\p{Block=:\Acjkunifiedideographsextensionc\z:}', "");;
    Expect(1, 177983, '\p{Block=	CJK_UNIFIED_ideographs_Extension_C}', "");
    Expect(0, 177983, '\p{^Block=	CJK_UNIFIED_ideographs_Extension_C}', "");
    Expect(0, 177983, '\P{Block=	CJK_UNIFIED_ideographs_Extension_C}', "");
    Expect(1, 177983, '\P{^Block=	CJK_UNIFIED_ideographs_Extension_C}', "");
    Expect(0, 177984, '\p{Block=	CJK_UNIFIED_ideographs_Extension_C}', "");
    Expect(1, 177984, '\p{^Block=	CJK_UNIFIED_ideographs_Extension_C}', "");
    Expect(1, 177984, '\P{Block=	CJK_UNIFIED_ideographs_Extension_C}', "");
    Expect(0, 177984, '\P{^Block=	CJK_UNIFIED_ideographs_Extension_C}', "");
    Error('\p{Blk: /a/CJK_Ext_C}');
    Error('\P{Blk: /a/CJK_Ext_C}');
    Expect(1, 177983, '\p{Blk=:\ACJK_Ext_C\z:}', "");;
    Expect(0, 177984, '\p{Blk=:\ACJK_Ext_C\z:}', "");;
    Expect(1, 177983, '\p{Blk=cjkextc}', "");
    Expect(0, 177983, '\p{^Blk=cjkextc}', "");
    Expect(0, 177983, '\P{Blk=cjkextc}', "");
    Expect(1, 177983, '\P{^Blk=cjkextc}', "");
    Expect(0, 177984, '\p{Blk=cjkextc}', "");
    Expect(1, 177984, '\p{^Blk=cjkextc}', "");
    Expect(1, 177984, '\P{Blk=cjkextc}', "");
    Expect(0, 177984, '\P{^Blk=cjkextc}', "");
    Expect(1, 177983, '\p{Blk=:\Acjkextc\z:}', "");;
    Expect(0, 177984, '\p{Blk=:\Acjkextc\z:}', "");;
    Expect(1, 177983, '\p{Blk=	 cjk_Ext_C}', "");
    Expect(0, 177983, '\p{^Blk=	 cjk_Ext_C}', "");
    Expect(0, 177983, '\P{Blk=	 cjk_Ext_C}', "");
    Expect(1, 177983, '\P{^Blk=	 cjk_Ext_C}', "");
    Expect(0, 177984, '\p{Blk=	 cjk_Ext_C}', "");
    Expect(1, 177984, '\p{^Blk=	 cjk_Ext_C}', "");
    Expect(1, 177984, '\P{Blk=	 cjk_Ext_C}', "");
    Expect(0, 177984, '\P{^Blk=	 cjk_Ext_C}', "");
    Error('\p{Is_Block:_ CJK_Unified_ideographs_extension_c/a/}');
    Error('\P{Is_Block:_ CJK_Unified_ideographs_extension_c/a/}');
    Expect(1, 177983, '\p{Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177983, '\p{^Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177983, '\P{Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177983, '\P{^Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177984, '\p{Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177984, '\p{^Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177984, '\P{Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177984, '\P{^Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177983, '\p{Is_Block= _CJK_unified_Ideographs_extension_c}', "");
    Expect(0, 177983, '\p{^Is_Block= _CJK_unified_Ideographs_extension_c}', "");
    Expect(0, 177983, '\P{Is_Block= _CJK_unified_Ideographs_extension_c}', "");
    Expect(1, 177983, '\P{^Is_Block= _CJK_unified_Ideographs_extension_c}', "");
    Expect(0, 177984, '\p{Is_Block= _CJK_unified_Ideographs_extension_c}', "");
    Expect(1, 177984, '\p{^Is_Block= _CJK_unified_Ideographs_extension_c}', "");
    Expect(1, 177984, '\P{Is_Block= _CJK_unified_Ideographs_extension_c}', "");
    Expect(0, 177984, '\P{^Is_Block= _CJK_unified_Ideographs_extension_c}', "");
    Error('\p{Is_Blk::= -cjk_Ext_C}');
    Error('\P{Is_Blk::= -cjk_Ext_C}');
    Expect(1, 177983, '\p{Is_Blk=cjkextc}', "");
    Expect(0, 177983, '\p{^Is_Blk=cjkextc}', "");
    Expect(0, 177983, '\P{Is_Blk=cjkextc}', "");
    Expect(1, 177983, '\P{^Is_Blk=cjkextc}', "");
    Expect(0, 177984, '\p{Is_Blk=cjkextc}', "");
    Expect(1, 177984, '\p{^Is_Blk=cjkextc}', "");
    Expect(1, 177984, '\P{Is_Blk=cjkextc}', "");
    Expect(0, 177984, '\P{^Is_Blk=cjkextc}', "");
    Expect(1, 177983, '\p{Is_Blk= 	CJK_ext_C}', "");
    Expect(0, 177983, '\p{^Is_Blk= 	CJK_ext_C}', "");
    Expect(0, 177983, '\P{Is_Blk= 	CJK_ext_C}', "");
    Expect(1, 177983, '\P{^Is_Blk= 	CJK_ext_C}', "");
    Expect(0, 177984, '\p{Is_Blk= 	CJK_ext_C}', "");
    Expect(1, 177984, '\p{^Is_Blk= 	CJK_ext_C}', "");
    Expect(1, 177984, '\P{Is_Blk= 	CJK_ext_C}', "");
    Expect(0, 177984, '\P{^Is_Blk= 	CJK_ext_C}', "");
    Error('\p{Block=	CJK_unified_IDEOGRAPHS_EXTENSION_D/a/}');
    Error('\P{Block=	CJK_unified_IDEOGRAPHS_EXTENSION_D/a/}');
    Expect(1, 178207, '\p{Block=:\ACJK_Unified_Ideographs_Extension_D\z:}', "");;
    Expect(0, 178208, '\p{Block=:\ACJK_Unified_Ideographs_Extension_D\z:}', "");;
    Expect(1, 178207, '\p{Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178207, '\p{^Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178207, '\P{Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178207, '\P{^Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178208, '\p{Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178208, '\p{^Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178208, '\P{Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178208, '\P{^Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178207, '\p{Block=:\Acjkunifiedideographsextensiond\z:}', "");;
    Expect(0, 178208, '\p{Block=:\Acjkunifiedideographsextensiond\z:}', "");;
    Expect(1, 178207, '\p{Block=	_CJK_UNIFIED_Ideographs_Extension_D}', "");
    Expect(0, 178207, '\p{^Block=	_CJK_UNIFIED_Ideographs_Extension_D}', "");
    Expect(0, 178207, '\P{Block=	_CJK_UNIFIED_Ideographs_Extension_D}', "");
    Expect(1, 178207, '\P{^Block=	_CJK_UNIFIED_Ideographs_Extension_D}', "");
    Expect(0, 178208, '\p{Block=	_CJK_UNIFIED_Ideographs_Extension_D}', "");
    Expect(1, 178208, '\p{^Block=	_CJK_UNIFIED_Ideographs_Extension_D}', "");
    Expect(1, 178208, '\P{Block=	_CJK_UNIFIED_Ideographs_Extension_D}', "");
    Expect(0, 178208, '\P{^Block=	_CJK_UNIFIED_Ideographs_Extension_D}', "");
    Error('\p{Blk: /a/cjk_Ext_D}');
    Error('\P{Blk: /a/cjk_Ext_D}');
    Expect(1, 178207, '\p{Blk=:\ACJK_Ext_D\z:}', "");;
    Expect(0, 178208, '\p{Blk=:\ACJK_Ext_D\z:}', "");;
    Expect(1, 178207, '\p{Blk=cjkextd}', "");
    Expect(0, 178207, '\p{^Blk=cjkextd}', "");
    Expect(0, 178207, '\P{Blk=cjkextd}', "");
    Expect(1, 178207, '\P{^Blk=cjkextd}', "");
    Expect(0, 178208, '\p{Blk=cjkextd}', "");
    Expect(1, 178208, '\p{^Blk=cjkextd}', "");
    Expect(1, 178208, '\P{Blk=cjkextd}', "");
    Expect(0, 178208, '\P{^Blk=cjkextd}', "");
    Expect(1, 178207, '\p{Blk=:\Acjkextd\z:}', "");;
    Expect(0, 178208, '\p{Blk=:\Acjkextd\z:}', "");;
    Expect(1, 178207, '\p{Blk= -CJK_EXT_D}', "");
    Expect(0, 178207, '\p{^Blk= -CJK_EXT_D}', "");
    Expect(0, 178207, '\P{Blk= -CJK_EXT_D}', "");
    Expect(1, 178207, '\P{^Blk= -CJK_EXT_D}', "");
    Expect(0, 178208, '\p{Blk= -CJK_EXT_D}', "");
    Expect(1, 178208, '\p{^Blk= -CJK_EXT_D}', "");
    Expect(1, 178208, '\P{Blk= -CJK_EXT_D}', "");
    Expect(0, 178208, '\P{^Blk= -CJK_EXT_D}', "");
    Error('\p{Is_Block=-CJK_UNIFIED_Ideographs_Extension_D:=}');
    Error('\P{Is_Block=-CJK_UNIFIED_Ideographs_Extension_D:=}');
    Expect(1, 178207, '\p{Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178207, '\p{^Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178207, '\P{Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178207, '\P{^Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178208, '\p{Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178208, '\p{^Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178208, '\P{Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178208, '\P{^Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178207, '\p{Is_Block= CJK_Unified_Ideographs_EXTENSION_D}', "");
    Expect(0, 178207, '\p{^Is_Block= CJK_Unified_Ideographs_EXTENSION_D}', "");
    Expect(0, 178207, '\P{Is_Block= CJK_Unified_Ideographs_EXTENSION_D}', "");
    Expect(1, 178207, '\P{^Is_Block= CJK_Unified_Ideographs_EXTENSION_D}', "");
    Expect(0, 178208, '\p{Is_Block= CJK_Unified_Ideographs_EXTENSION_D}', "");
    Expect(1, 178208, '\p{^Is_Block= CJK_Unified_Ideographs_EXTENSION_D}', "");
    Expect(1, 178208, '\P{Is_Block= CJK_Unified_Ideographs_EXTENSION_D}', "");
    Expect(0, 178208, '\P{^Is_Block= CJK_Unified_Ideographs_EXTENSION_D}', "");
    Error('\p{Is_Blk:_ CJK_Ext_d:=}');
    Error('\P{Is_Blk:_ CJK_Ext_d:=}');
    Expect(1, 178207, '\p{Is_Blk:cjkextd}', "");
    Expect(0, 178207, '\p{^Is_Blk:cjkextd}', "");
    Expect(0, 178207, '\P{Is_Blk:cjkextd}', "");
    Expect(1, 178207, '\P{^Is_Blk:cjkextd}', "");
    Expect(0, 178208, '\p{Is_Blk:cjkextd}', "");
    Expect(1, 178208, '\p{^Is_Blk:cjkextd}', "");
    Expect(1, 178208, '\P{Is_Blk:cjkextd}', "");
    Expect(0, 178208, '\P{^Is_Blk:cjkextd}', "");
    Expect(1, 178207, '\p{Is_Blk= -cjk_Ext_D}', "");
    Expect(0, 178207, '\p{^Is_Blk= -cjk_Ext_D}', "");
    Expect(0, 178207, '\P{Is_Blk= -cjk_Ext_D}', "");
    Expect(1, 178207, '\P{^Is_Blk= -cjk_Ext_D}', "");
    Expect(0, 178208, '\p{Is_Blk= -cjk_Ext_D}', "");
    Expect(1, 178208, '\p{^Is_Blk= -cjk_Ext_D}', "");
    Expect(1, 178208, '\P{Is_Blk= -cjk_Ext_D}', "");
    Expect(0, 178208, '\P{^Is_Blk= -cjk_Ext_D}', "");
    Error('\p{Block=-_CJK_UNIFIED_Ideographs_Extension_E:=}');
    Error('\P{Block=-_CJK_UNIFIED_Ideographs_Extension_E:=}');
    Expect(1, 183983, '\p{Block=:\ACJK_Unified_Ideographs_Extension_E\z:}', "");;
    Expect(0, 183984, '\p{Block=:\ACJK_Unified_Ideographs_Extension_E\z:}', "");;
    Expect(1, 183983, '\p{Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183983, '\p{^Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183983, '\P{Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183983, '\P{^Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183984, '\p{Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183984, '\p{^Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183984, '\P{Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183984, '\P{^Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183983, '\p{Block=:\Acjkunifiedideographsextensione\z:}', "");;
    Expect(0, 183984, '\p{Block=:\Acjkunifiedideographsextensione\z:}', "");;
    Expect(1, 183983, '\p{Block=	-cjk_Unified_ideographs_extension_E}', "");
    Expect(0, 183983, '\p{^Block=	-cjk_Unified_ideographs_extension_E}', "");
    Expect(0, 183983, '\P{Block=	-cjk_Unified_ideographs_extension_E}', "");
    Expect(1, 183983, '\P{^Block=	-cjk_Unified_ideographs_extension_E}', "");
    Expect(0, 183984, '\p{Block=	-cjk_Unified_ideographs_extension_E}', "");
    Expect(1, 183984, '\p{^Block=	-cjk_Unified_ideographs_extension_E}', "");
    Expect(1, 183984, '\P{Block=	-cjk_Unified_ideographs_extension_E}', "");
    Expect(0, 183984, '\P{^Block=	-cjk_Unified_ideographs_extension_E}', "");
    Error('\p{Blk=:= CJK_ext_E}');
    Error('\P{Blk=:= CJK_ext_E}');
    Expect(1, 183983, '\p{Blk=:\ACJK_Ext_E\z:}', "");;
    Expect(0, 183984, '\p{Blk=:\ACJK_Ext_E\z:}', "");;
    Expect(1, 183983, '\p{Blk=cjkexte}', "");
    Expect(0, 183983, '\p{^Blk=cjkexte}', "");
    Expect(0, 183983, '\P{Blk=cjkexte}', "");
    Expect(1, 183983, '\P{^Blk=cjkexte}', "");
    Expect(0, 183984, '\p{Blk=cjkexte}', "");
    Expect(1, 183984, '\p{^Blk=cjkexte}', "");
    Expect(1, 183984, '\P{Blk=cjkexte}', "");
    Expect(0, 183984, '\P{^Blk=cjkexte}', "");
    Expect(1, 183983, '\p{Blk=:\Acjkexte\z:}', "");;
    Expect(0, 183984, '\p{Blk=:\Acjkexte\z:}', "");;
    Expect(1, 183983, '\p{Blk=__CJK_EXT_E}', "");
    Expect(0, 183983, '\p{^Blk=__CJK_EXT_E}', "");
    Expect(0, 183983, '\P{Blk=__CJK_EXT_E}', "");
    Expect(1, 183983, '\P{^Blk=__CJK_EXT_E}', "");
    Expect(0, 183984, '\p{Blk=__CJK_EXT_E}', "");
    Expect(1, 183984, '\p{^Blk=__CJK_EXT_E}', "");
    Expect(1, 183984, '\P{Blk=__CJK_EXT_E}', "");
    Expect(0, 183984, '\P{^Blk=__CJK_EXT_E}', "");
    Error('\p{Is_Block=/a/CJK_Unified_ideographs_extension_E}');
    Error('\P{Is_Block=/a/CJK_Unified_ideographs_extension_E}');
    Expect(1, 183983, '\p{Is_Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183983, '\p{^Is_Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183983, '\P{Is_Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183983, '\P{^Is_Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183984, '\p{Is_Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183984, '\p{^Is_Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183984, '\P{Is_Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183984, '\P{^Is_Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183983, '\p{Is_Block=_-CJK_unified_ideographs_extension_E}', "");
    Expect(0, 183983, '\p{^Is_Block=_-CJK_unified_ideographs_extension_E}', "");
    Expect(0, 183983, '\P{Is_Block=_-CJK_unified_ideographs_extension_E}', "");
    Expect(1, 183983, '\P{^Is_Block=_-CJK_unified_ideographs_extension_E}', "");
    Expect(0, 183984, '\p{Is_Block=_-CJK_unified_ideographs_extension_E}', "");
    Expect(1, 183984, '\p{^Is_Block=_-CJK_unified_ideographs_extension_E}', "");
    Expect(1, 183984, '\P{Is_Block=_-CJK_unified_ideographs_extension_E}', "");
    Expect(0, 183984, '\P{^Is_Block=_-CJK_unified_ideographs_extension_E}', "");
    Error('\p{Is_Blk=:=-CJK_Ext_E}');
    Error('\P{Is_Blk=:=-CJK_Ext_E}');
    Expect(1, 183983, '\p{Is_Blk=cjkexte}', "");
    Expect(0, 183983, '\p{^Is_Blk=cjkexte}', "");
    Expect(0, 183983, '\P{Is_Blk=cjkexte}', "");
    Expect(1, 183983, '\P{^Is_Blk=cjkexte}', "");
    Expect(0, 183984, '\p{Is_Blk=cjkexte}', "");
    Expect(1, 183984, '\p{^Is_Blk=cjkexte}', "");
    Expect(1, 183984, '\P{Is_Blk=cjkexte}', "");
    Expect(0, 183984, '\P{^Is_Blk=cjkexte}', "");
    Expect(1, 183983, '\p{Is_Blk=--CJK_Ext_E}', "");
    Expect(0, 183983, '\p{^Is_Blk=--CJK_Ext_E}', "");
    Expect(0, 183983, '\P{Is_Blk=--CJK_Ext_E}', "");
    Expect(1, 183983, '\P{^Is_Blk=--CJK_Ext_E}', "");
    Expect(0, 183984, '\p{Is_Blk=--CJK_Ext_E}', "");
    Expect(1, 183984, '\p{^Is_Blk=--CJK_Ext_E}', "");
    Expect(1, 183984, '\P{Is_Blk=--CJK_Ext_E}', "");
    Expect(0, 183984, '\P{^Is_Blk=--CJK_Ext_E}', "");
    Error('\p{Block= :=CJK_Unified_ideographs_EXTENSION_F}');
    Error('\P{Block= :=CJK_Unified_ideographs_EXTENSION_F}');
    Expect(1, 191471, '\p{Block=:\ACJK_Unified_Ideographs_Extension_F\z:}', "");;
    Expect(0, 191472, '\p{Block=:\ACJK_Unified_Ideographs_Extension_F\z:}', "");;
    Expect(1, 191471, '\p{Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191471, '\p{^Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191471, '\P{Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191471, '\P{^Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191472, '\p{Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191472, '\p{^Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191472, '\P{Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191472, '\P{^Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191471, '\p{Block=:\Acjkunifiedideographsextensionf\z:}', "");;
    Expect(0, 191472, '\p{Block=:\Acjkunifiedideographsextensionf\z:}', "");;
    Expect(1, 191471, '\p{Block=	_cjk_Unified_Ideographs_extension_F}', "");
    Expect(0, 191471, '\p{^Block=	_cjk_Unified_Ideographs_extension_F}', "");
    Expect(0, 191471, '\P{Block=	_cjk_Unified_Ideographs_extension_F}', "");
    Expect(1, 191471, '\P{^Block=	_cjk_Unified_Ideographs_extension_F}', "");
    Expect(0, 191472, '\p{Block=	_cjk_Unified_Ideographs_extension_F}', "");
    Expect(1, 191472, '\p{^Block=	_cjk_Unified_Ideographs_extension_F}', "");
    Expect(1, 191472, '\P{Block=	_cjk_Unified_Ideographs_extension_F}', "");
    Expect(0, 191472, '\P{^Block=	_cjk_Unified_Ideographs_extension_F}', "");
    Error('\p{Blk=_/a/CJK_Ext_F}');
    Error('\P{Blk=_/a/CJK_Ext_F}');
    Expect(1, 191471, '\p{Blk=:\ACJK_Ext_F\z:}', "");;
    Expect(0, 191472, '\p{Blk=:\ACJK_Ext_F\z:}', "");;
    Expect(1, 191471, '\p{Blk=cjkextf}', "");
    Expect(0, 191471, '\p{^Blk=cjkextf}', "");
    Expect(0, 191471, '\P{Blk=cjkextf}', "");
    Expect(1, 191471, '\P{^Blk=cjkextf}', "");
    Expect(0, 191472, '\p{Blk=cjkextf}', "");
    Expect(1, 191472, '\p{^Blk=cjkextf}', "");
    Expect(1, 191472, '\P{Blk=cjkextf}', "");
    Expect(0, 191472, '\P{^Blk=cjkextf}', "");
    Expect(1, 191471, '\p{Blk=:\Acjkextf\z:}', "");;
    Expect(0, 191472, '\p{Blk=:\Acjkextf\z:}', "");;
    Expect(1, 191471, '\p{Blk=--CJK_EXT_F}', "");
    Expect(0, 191471, '\p{^Blk=--CJK_EXT_F}', "");
    Expect(0, 191471, '\P{Blk=--CJK_EXT_F}', "");
    Expect(1, 191471, '\P{^Blk=--CJK_EXT_F}', "");
    Expect(0, 191472, '\p{Blk=--CJK_EXT_F}', "");
    Expect(1, 191472, '\p{^Blk=--CJK_EXT_F}', "");
    Expect(1, 191472, '\P{Blk=--CJK_EXT_F}', "");
    Expect(0, 191472, '\P{^Blk=--CJK_EXT_F}', "");
    Error('\p{Is_Block=/a/-cjk_unified_Ideographs_Extension_f}');
    Error('\P{Is_Block=/a/-cjk_unified_Ideographs_Extension_f}');
    Expect(1, 191471, '\p{Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191471, '\p{^Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191471, '\P{Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191471, '\P{^Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191472, '\p{Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191472, '\p{^Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191472, '\P{Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191472, '\P{^Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191471, '\p{Is_Block= CJK_Unified_ideographs_Extension_F}', "");
    Expect(0, 191471, '\p{^Is_Block= CJK_Unified_ideographs_Extension_F}', "");
    Expect(0, 191471, '\P{Is_Block= CJK_Unified_ideographs_Extension_F}', "");
    Expect(1, 191471, '\P{^Is_Block= CJK_Unified_ideographs_Extension_F}', "");
    Expect(0, 191472, '\p{Is_Block= CJK_Unified_ideographs_Extension_F}', "");
    Expect(1, 191472, '\p{^Is_Block= CJK_Unified_ideographs_Extension_F}', "");
    Expect(1, 191472, '\P{Is_Block= CJK_Unified_ideographs_Extension_F}', "");
    Expect(0, 191472, '\P{^Is_Block= CJK_Unified_ideographs_Extension_F}', "");
    Error('\p{Is_Blk= CJK_Ext_f/a/}');
    Error('\P{Is_Blk= CJK_Ext_f/a/}');
    Expect(1, 191471, '\p{Is_Blk:	cjkextf}', "");
    Expect(0, 191471, '\p{^Is_Blk:	cjkextf}', "");
    Expect(0, 191471, '\P{Is_Blk:	cjkextf}', "");
    Expect(1, 191471, '\P{^Is_Blk:	cjkextf}', "");
    Expect(0, 191472, '\p{Is_Blk:	cjkextf}', "");
    Expect(1, 191472, '\p{^Is_Blk:	cjkextf}', "");
    Expect(1, 191472, '\P{Is_Blk:	cjkextf}', "");
    Expect(0, 191472, '\P{^Is_Blk:	cjkextf}', "");
    Expect(1, 191471, '\p{Is_Blk=  CJK_Ext_F}', "");
    Expect(0, 191471, '\p{^Is_Blk=  CJK_Ext_F}', "");
    Expect(0, 191471, '\P{Is_Blk=  CJK_Ext_F}', "");
    Expect(1, 191471, '\P{^Is_Blk=  CJK_Ext_F}', "");
    Expect(0, 191472, '\p{Is_Blk=  CJK_Ext_F}', "");
    Expect(1, 191472, '\p{^Is_Blk=  CJK_Ext_F}', "");
    Expect(1, 191472, '\P{Is_Blk=  CJK_Ext_F}', "");
    Expect(0, 191472, '\P{^Is_Blk=  CJK_Ext_F}', "");
    Error('\p{Block=CJK_Unified_ideographs_EXTENSION_G/a/}');
    Error('\P{Block=CJK_Unified_ideographs_EXTENSION_G/a/}');
    Expect(1, 201551, '\p{Block=:\ACJK_Unified_Ideographs_Extension_G\z:}', "");;
    Expect(0, 201552, '\p{Block=:\ACJK_Unified_Ideographs_Extension_G\z:}', "");;
    Expect(1, 201551, '\p{Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201551, '\p{^Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201551, '\P{Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201551, '\P{^Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201552, '\p{Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201552, '\p{^Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201552, '\P{Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201552, '\P{^Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201551, '\p{Block=:\Acjkunifiedideographsextensiong\z:}', "");;
    Expect(0, 201552, '\p{Block=:\Acjkunifiedideographsextensiong\z:}', "");;
    Expect(1, 201551, '\p{Block:  CJK_UNIFIED_IDEOGRAPHS_Extension_G}', "");
    Expect(0, 201551, '\p{^Block:  CJK_UNIFIED_IDEOGRAPHS_Extension_G}', "");
    Expect(0, 201551, '\P{Block:  CJK_UNIFIED_IDEOGRAPHS_Extension_G}', "");
    Expect(1, 201551, '\P{^Block:  CJK_UNIFIED_IDEOGRAPHS_Extension_G}', "");
    Expect(0, 201552, '\p{Block:  CJK_UNIFIED_IDEOGRAPHS_Extension_G}', "");
    Expect(1, 201552, '\p{^Block:  CJK_UNIFIED_IDEOGRAPHS_Extension_G}', "");
    Expect(1, 201552, '\P{Block:  CJK_UNIFIED_IDEOGRAPHS_Extension_G}', "");
    Expect(0, 201552, '\P{^Block:  CJK_UNIFIED_IDEOGRAPHS_Extension_G}', "");
    Error('\p{Blk= /a/CJK_Ext_G}');
    Error('\P{Blk= /a/CJK_Ext_G}');
    Expect(1, 201551, '\p{Blk=:\ACJK_Ext_G\z:}', "");;
    Expect(0, 201552, '\p{Blk=:\ACJK_Ext_G\z:}', "");;
    Expect(1, 201551, '\p{Blk=cjkextg}', "");
    Expect(0, 201551, '\p{^Blk=cjkextg}', "");
    Expect(0, 201551, '\P{Blk=cjkextg}', "");
    Expect(1, 201551, '\P{^Blk=cjkextg}', "");
    Expect(0, 201552, '\p{Blk=cjkextg}', "");
    Expect(1, 201552, '\p{^Blk=cjkextg}', "");
    Expect(1, 201552, '\P{Blk=cjkextg}', "");
    Expect(0, 201552, '\P{^Blk=cjkextg}', "");
    Expect(1, 201551, '\p{Blk=:\Acjkextg\z:}', "");;
    Expect(0, 201552, '\p{Blk=:\Acjkextg\z:}', "");;
    Expect(1, 201551, '\p{Blk=	-CJK_Ext_g}', "");
    Expect(0, 201551, '\p{^Blk=	-CJK_Ext_g}', "");
    Expect(0, 201551, '\P{Blk=	-CJK_Ext_g}', "");
    Expect(1, 201551, '\P{^Blk=	-CJK_Ext_g}', "");
    Expect(0, 201552, '\p{Blk=	-CJK_Ext_g}', "");
    Expect(1, 201552, '\p{^Blk=	-CJK_Ext_g}', "");
    Expect(1, 201552, '\P{Blk=	-CJK_Ext_g}', "");
    Expect(0, 201552, '\P{^Blk=	-CJK_Ext_g}', "");
    Error('\p{Is_Block=-cjk_UNIFIED_Ideographs_Extension_G/a/}');
    Error('\P{Is_Block=-cjk_UNIFIED_Ideographs_Extension_G/a/}');
    Expect(1, 201551, '\p{Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201551, '\p{^Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201551, '\P{Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201551, '\P{^Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201552, '\p{Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201552, '\p{^Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201552, '\P{Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201552, '\P{^Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201551, '\p{Is_Block=__CJK_unified_Ideographs_Extension_G}', "");
    Expect(0, 201551, '\p{^Is_Block=__CJK_unified_Ideographs_Extension_G}', "");
    Expect(0, 201551, '\P{Is_Block=__CJK_unified_Ideographs_Extension_G}', "");
    Expect(1, 201551, '\P{^Is_Block=__CJK_unified_Ideographs_Extension_G}', "");
    Expect(0, 201552, '\p{Is_Block=__CJK_unified_Ideographs_Extension_G}', "");
    Expect(1, 201552, '\p{^Is_Block=__CJK_unified_Ideographs_Extension_G}', "");
    Expect(1, 201552, '\P{Is_Block=__CJK_unified_Ideographs_Extension_G}', "");
    Expect(0, 201552, '\P{^Is_Block=__CJK_unified_Ideographs_Extension_G}', "");
    Error('\p{Is_Blk= 	CJK_Ext_g/a/}');
    Error('\P{Is_Blk= 	CJK_Ext_g/a/}');
    Expect(1, 201551, '\p{Is_Blk=cjkextg}', "");
    Expect(0, 201551, '\p{^Is_Blk=cjkextg}', "");
    Expect(0, 201551, '\P{Is_Blk=cjkextg}', "");
    Expect(1, 201551, '\P{^Is_Blk=cjkextg}', "");
    Expect(0, 201552, '\p{Is_Blk=cjkextg}', "");
    Expect(1, 201552, '\p{^Is_Blk=cjkextg}', "");
    Expect(1, 201552, '\P{Is_Blk=cjkextg}', "");
    Expect(0, 201552, '\P{^Is_Blk=cjkextg}', "");
    Expect(1, 201551, '\p{Is_Blk=-CJK_Ext_G}', "");
    Expect(0, 201551, '\p{^Is_Blk=-CJK_Ext_G}', "");
    Expect(0, 201551, '\P{Is_Blk=-CJK_Ext_G}', "");
    Expect(1, 201551, '\P{^Is_Blk=-CJK_Ext_G}', "");
    Expect(0, 201552, '\p{Is_Blk=-CJK_Ext_G}', "");
    Expect(1, 201552, '\p{^Is_Blk=-CJK_Ext_G}', "");
    Expect(1, 201552, '\P{Is_Blk=-CJK_Ext_G}', "");
    Expect(0, 201552, '\P{^Is_Blk=-CJK_Ext_G}', "");
    Error('\p{Block=-CJK_UNIFIED_ideographs_EXTENSION_H:=}');
    Error('\P{Block=-CJK_UNIFIED_ideographs_EXTENSION_H:=}');
    Expect(1, 205743, '\p{Block=:\ACJK_Unified_Ideographs_Extension_H\z:}', "");;
    Expect(0, 205744, '\p{Block=:\ACJK_Unified_Ideographs_Extension_H\z:}', "");;
    Expect(1, 205743, '\p{Block=cjkunifiedideographsextensionh}', "");
    Expect(0, 205743, '\p{^Block=cjkunifiedideographsextensionh}', "");
    Expect(0, 205743, '\P{Block=cjkunifiedideographsextensionh}', "");
    Expect(1, 205743, '\P{^Block=cjkunifiedideographsextensionh}', "");
    Expect(0, 205744, '\p{Block=cjkunifiedideographsextensionh}', "");
    Expect(1, 205744, '\p{^Block=cjkunifiedideographsextensionh}', "");
    Expect(1, 205744, '\P{Block=cjkunifiedideographsextensionh}', "");
    Expect(0, 205744, '\P{^Block=cjkunifiedideographsextensionh}', "");
    Expect(1, 205743, '\p{Block=:\Acjkunifiedideographsextensionh\z:}', "");;
    Expect(0, 205744, '\p{Block=:\Acjkunifiedideographsextensionh\z:}', "");;
    Expect(1, 205743, '\p{Block=	-CJK_UNIFIED_Ideographs_Extension_H}', "");
    Expect(0, 205743, '\p{^Block=	-CJK_UNIFIED_Ideographs_Extension_H}', "");
    Expect(0, 205743, '\P{Block=	-CJK_UNIFIED_Ideographs_Extension_H}', "");
    Expect(1, 205743, '\P{^Block=	-CJK_UNIFIED_Ideographs_Extension_H}', "");
    Expect(0, 205744, '\p{Block=	-CJK_UNIFIED_Ideographs_Extension_H}', "");
    Expect(1, 205744, '\p{^Block=	-CJK_UNIFIED_Ideographs_Extension_H}', "");
    Expect(1, 205744, '\P{Block=	-CJK_UNIFIED_Ideographs_Extension_H}', "");
    Expect(0, 205744, '\P{^Block=	-CJK_UNIFIED_Ideographs_Extension_H}', "");
    Error('\p{Blk=-_CJK_ext_H:=}');
    Error('\P{Blk=-_CJK_ext_H:=}');
    Expect(1, 205743, '\p{Blk=:\ACJK_Ext_H\z:}', "");;
    Expect(0, 205744, '\p{Blk=:\ACJK_Ext_H\z:}', "");;
    Expect(1, 205743, '\p{Blk=cjkexth}', "");
    Expect(0, 205743, '\p{^Blk=cjkexth}', "");
    Expect(0, 205743, '\P{Blk=cjkexth}', "");
    Expect(1, 205743, '\P{^Blk=cjkexth}', "");
    Expect(0, 205744, '\p{Blk=cjkexth}', "");
    Expect(1, 205744, '\p{^Blk=cjkexth}', "");
    Expect(1, 205744, '\P{Blk=cjkexth}', "");
    Expect(0, 205744, '\P{^Blk=cjkexth}', "");
    Expect(1, 205743, '\p{Blk=:\Acjkexth\z:}', "");;
    Expect(0, 205744, '\p{Blk=:\Acjkexth\z:}', "");;
    Expect(1, 205743, '\p{Blk=	cjk_Ext_H}', "");
    Expect(0, 205743, '\p{^Blk=	cjk_Ext_H}', "");
    Expect(0, 205743, '\P{Blk=	cjk_Ext_H}', "");
    Expect(1, 205743, '\P{^Blk=	cjk_Ext_H}', "");
    Expect(0, 205744, '\p{Blk=	cjk_Ext_H}', "");
    Expect(1, 205744, '\p{^Blk=	cjk_Ext_H}', "");
    Expect(1, 205744, '\P{Blk=	cjk_Ext_H}', "");
    Expect(0, 205744, '\P{^Blk=	cjk_Ext_H}', "");
    Error('\p{Is_Block=	/a/CJK_unified_ideographs_Extension_h}');
    Error('\P{Is_Block=	/a/CJK_unified_ideographs_Extension_h}');
    Expect(1, 205743, '\p{Is_Block=cjkunifiedideographsextensionh}', "");
    Expect(0, 205743, '\p{^Is_Block=cjkunifiedideographsextensionh}', "");
    Expect(0, 205743, '\P{Is_Block=cjkunifiedideographsextensionh}', "");
    Expect(1, 205743, '\P{^Is_Block=cjkunifiedideographsextensionh}', "");
    Expect(0, 205744, '\p{Is_Block=cjkunifiedideographsextensionh}', "");
    Expect(1, 205744, '\p{^Is_Block=cjkunifiedideographsextensionh}', "");
    Expect(1, 205744, '\P{Is_Block=cjkunifiedideographsextensionh}', "");
    Expect(0, 205744, '\P{^Is_Block=cjkunifiedideographsextensionh}', "");
    Expect(1, 205743, '\p{Is_Block=-	CJK_UNIFIED_IDEOGRAPHS_EXTENSION_H}', "");
    Expect(0, 205743, '\p{^Is_Block=-	CJK_UNIFIED_IDEOGRAPHS_EXTENSION_H}', "");
    Expect(0, 205743, '\P{Is_Block=-	CJK_UNIFIED_IDEOGRAPHS_EXTENSION_H}', "");
    Expect(1, 205743, '\P{^Is_Block=-	CJK_UNIFIED_IDEOGRAPHS_EXTENSION_H}', "");
    Expect(0, 205744, '\p{Is_Block=-	CJK_UNIFIED_IDEOGRAPHS_EXTENSION_H}', "");
    Expect(1, 205744, '\p{^Is_Block=-	CJK_UNIFIED_IDEOGRAPHS_EXTENSION_H}', "");
    Expect(1, 205744, '\P{Is_Block=-	CJK_UNIFIED_IDEOGRAPHS_EXTENSION_H}', "");
    Expect(0, 205744, '\P{^Is_Block=-	CJK_UNIFIED_IDEOGRAPHS_EXTENSION_H}', "");
    Error('\p{Is_Blk=:=	CJK_ext_H}');
    Error('\P{Is_Blk=:=	CJK_ext_H}');
    Expect(1, 205743, '\p{Is_Blk=cjkexth}', "");
    Expect(0, 205743, '\p{^Is_Blk=cjkexth}', "");
    Expect(0, 205743, '\P{Is_Blk=cjkexth}', "");
    Expect(1, 205743, '\P{^Is_Blk=cjkexth}', "");
    Expect(0, 205744, '\p{Is_Blk=cjkexth}', "");
    Expect(1, 205744, '\p{^Is_Blk=cjkexth}', "");
    Expect(1, 205744, '\P{Is_Blk=cjkexth}', "");
    Expect(0, 205744, '\P{^Is_Blk=cjkexth}', "");
    Expect(1, 205743, '\p{Is_Blk=- CJK_Ext_H}', "");
    Expect(0, 205743, '\p{^Is_Blk=- CJK_Ext_H}', "");
    Expect(0, 205743, '\P{Is_Blk=- CJK_Ext_H}', "");
    Expect(1, 205743, '\P{^Is_Blk=- CJK_Ext_H}', "");
    Expect(0, 205744, '\p{Is_Blk=- CJK_Ext_H}', "");
    Expect(1, 205744, '\p{^Is_Blk=- CJK_Ext_H}', "");
    Expect(1, 205744, '\P{Is_Blk=- CJK_Ext_H}', "");
    Expect(0, 205744, '\P{^Is_Blk=- CJK_Ext_H}', "");
    Error('\p{Block=-:=cjk_radicals_SUPPLEMENT}');
    Error('\P{Block=-:=cjk_radicals_SUPPLEMENT}');
    Expect(1, 12031, '\p{Block=:\ACJK_Radicals_Supplement\z:}', "");;
    Expect(0, 12032, '\p{Block=:\ACJK_Radicals_Supplement\z:}', "");;
    Expect(1, 12031, '\p{Block=cjkradicalssupplement}', "");
    Expect(0, 12031, '\p{^Block=cjkradicalssupplement}', "");
    Expect(0, 12031, '\P{Block=cjkradicalssupplement}', "");
    Expect(1, 12031, '\P{^Block=cjkradicalssupplement}', "");
    Expect(0, 12032, '\p{Block=cjkradicalssupplement}', "");
    Expect(1, 12032, '\p{^Block=cjkradicalssupplement}', "");
    Expect(1, 12032, '\P{Block=cjkradicalssupplement}', "");
    Expect(0, 12032, '\P{^Block=cjkradicalssupplement}', "");
    Expect(1, 12031, '\p{Block=:\Acjkradicalssupplement\z:}', "");;
    Expect(0, 12032, '\p{Block=:\Acjkradicalssupplement\z:}', "");;
    Expect(1, 12031, '\p{Block=_	CJK_Radicals_SUPPLEMENT}', "");
    Expect(0, 12031, '\p{^Block=_	CJK_Radicals_SUPPLEMENT}', "");
    Expect(0, 12031, '\P{Block=_	CJK_Radicals_SUPPLEMENT}', "");
    Expect(1, 12031, '\P{^Block=_	CJK_Radicals_SUPPLEMENT}', "");
    Expect(0, 12032, '\p{Block=_	CJK_Radicals_SUPPLEMENT}', "");
    Expect(1, 12032, '\p{^Block=_	CJK_Radicals_SUPPLEMENT}', "");
    Expect(1, 12032, '\P{Block=_	CJK_Radicals_SUPPLEMENT}', "");
    Expect(0, 12032, '\P{^Block=_	CJK_Radicals_SUPPLEMENT}', "");
    Error('\p{Blk=	:=CJK_radicals_Sup}');
    Error('\P{Blk=	:=CJK_radicals_Sup}');
    Expect(1, 12031, '\p{Blk=:\ACJK_Radicals_Sup\z:}', "");;
    Expect(0, 12032, '\p{Blk=:\ACJK_Radicals_Sup\z:}', "");;
    Expect(1, 12031, '\p{Blk=cjkradicalssup}', "");
    Expect(0, 12031, '\p{^Blk=cjkradicalssup}', "");
    Expect(0, 12031, '\P{Blk=cjkradicalssup}', "");
    Expect(1, 12031, '\P{^Blk=cjkradicalssup}', "");
    Expect(0, 12032, '\p{Blk=cjkradicalssup}', "");
    Expect(1, 12032, '\p{^Blk=cjkradicalssup}', "");
    Expect(1, 12032, '\P{Blk=cjkradicalssup}', "");
    Expect(0, 12032, '\P{^Blk=cjkradicalssup}', "");
    Expect(1, 12031, '\p{Blk=:\Acjkradicalssup\z:}', "");;
    Expect(0, 12032, '\p{Blk=:\Acjkradicalssup\z:}', "");;
    Expect(1, 12031, '\p{Blk=_ CJK_RADICALS_Sup}', "");
    Expect(0, 12031, '\p{^Blk=_ CJK_RADICALS_Sup}', "");
    Expect(0, 12031, '\P{Blk=_ CJK_RADICALS_Sup}', "");
    Expect(1, 12031, '\P{^Blk=_ CJK_RADICALS_Sup}', "");
    Expect(0, 12032, '\p{Blk=_ CJK_RADICALS_Sup}', "");
    Expect(1, 12032, '\p{^Blk=_ CJK_RADICALS_Sup}', "");
    Expect(1, 12032, '\P{Blk=_ CJK_RADICALS_Sup}', "");
    Expect(0, 12032, '\P{^Blk=_ CJK_RADICALS_Sup}', "");
    Error('\p{Is_Block=:=CJK_RADICALS_Supplement}');
    Error('\P{Is_Block=:=CJK_RADICALS_Supplement}');
    Expect(1, 12031, '\p{Is_Block=cjkradicalssupplement}', "");
    Expect(0, 12031, '\p{^Is_Block=cjkradicalssupplement}', "");
    Expect(0, 12031, '\P{Is_Block=cjkradicalssupplement}', "");
    Expect(1, 12031, '\P{^Is_Block=cjkradicalssupplement}', "");
    Expect(0, 12032, '\p{Is_Block=cjkradicalssupplement}', "");
    Expect(1, 12032, '\p{^Is_Block=cjkradicalssupplement}', "");
    Expect(1, 12032, '\P{Is_Block=cjkradicalssupplement}', "");
    Expect(0, 12032, '\P{^Is_Block=cjkradicalssupplement}', "");
    Expect(1, 12031, '\p{Is_Block=		cjk_Radicals_supplement}', "");
    Expect(0, 12031, '\p{^Is_Block=		cjk_Radicals_supplement}', "");
    Expect(0, 12031, '\P{Is_Block=		cjk_Radicals_supplement}', "");
    Expect(1, 12031, '\P{^Is_Block=		cjk_Radicals_supplement}', "");
    Expect(0, 12032, '\p{Is_Block=		cjk_Radicals_supplement}', "");
    Expect(1, 12032, '\p{^Is_Block=		cjk_Radicals_supplement}', "");
    Expect(1, 12032, '\P{Is_Block=		cjk_Radicals_supplement}', "");
    Expect(0, 12032, '\P{^Is_Block=		cjk_Radicals_supplement}', "");
    Error('\p{Is_Blk=_CJK_Radicals_Sup:=}');
    Error('\P{Is_Blk=_CJK_Radicals_Sup:=}');
    Expect(1, 12031, '\p{Is_Blk=cjkradicalssup}', "");
    Expect(0, 12031, '\p{^Is_Blk=cjkradicalssup}', "");
    Expect(0, 12031, '\P{Is_Blk=cjkradicalssup}', "");
    Expect(1, 12031, '\P{^Is_Blk=cjkradicalssup}', "");
    Expect(0, 12032, '\p{Is_Blk=cjkradicalssup}', "");
    Expect(1, 12032, '\p{^Is_Blk=cjkradicalssup}', "");
    Expect(1, 12032, '\P{Is_Blk=cjkradicalssup}', "");
    Expect(0, 12032, '\P{^Is_Blk=cjkradicalssup}', "");
    Expect(1, 12031, '\p{Is_Blk=--CJK_Radicals_sup}', "");
    Expect(0, 12031, '\p{^Is_Blk=--CJK_Radicals_sup}', "");
    Expect(0, 12031, '\P{Is_Blk=--CJK_Radicals_sup}', "");
    Expect(1, 12031, '\P{^Is_Blk=--CJK_Radicals_sup}', "");
    Expect(0, 12032, '\p{Is_Blk=--CJK_Radicals_sup}', "");
    Expect(1, 12032, '\p{^Is_Blk=--CJK_Radicals_sup}', "");
    Expect(1, 12032, '\P{Is_Blk=--CJK_Radicals_sup}', "");
    Expect(0, 12032, '\P{^Is_Blk=--CJK_Radicals_sup}', "");
    Error('\p{Block= _CJK_Strokes/a/}');
    Error('\P{Block= _CJK_Strokes/a/}');
    Expect(1, 12783, '\p{Block=:\ACJK_Strokes\z:}', "");;
    Expect(0, 12784, '\p{Block=:\ACJK_Strokes\z:}', "");;
    Expect(1, 12783, '\p{Block=cjkstrokes}', "");
    Expect(0, 12783, '\p{^Block=cjkstrokes}', "");
    Expect(0, 12783, '\P{Block=cjkstrokes}', "");
    Expect(1, 12783, '\P{^Block=cjkstrokes}', "");
    Expect(0, 12784, '\p{Block=cjkstrokes}', "");
    Expect(1, 12784, '\p{^Block=cjkstrokes}', "");
    Expect(1, 12784, '\P{Block=cjkstrokes}', "");
    Expect(0, 12784, '\P{^Block=cjkstrokes}', "");
    Expect(1, 12783, '\p{Block=:\Acjkstrokes\z:}', "");;
    Expect(0, 12784, '\p{Block=:\Acjkstrokes\z:}', "");;
    Expect(1, 12783, '\p{Block= CJK_strokes}', "");
    Expect(0, 12783, '\p{^Block= CJK_strokes}', "");
    Expect(0, 12783, '\P{Block= CJK_strokes}', "");
    Expect(1, 12783, '\P{^Block= CJK_strokes}', "");
    Expect(0, 12784, '\p{Block= CJK_strokes}', "");
    Expect(1, 12784, '\p{^Block= CJK_strokes}', "");
    Expect(1, 12784, '\P{Block= CJK_strokes}', "");
    Expect(0, 12784, '\P{^Block= CJK_strokes}', "");
    Error('\p{Blk=-	cjk_strokes:=}');
    Error('\P{Blk=-	cjk_strokes:=}');
    Expect(1, 12783, '\p{Blk=:\ACJK_Strokes\z:}', "");;
    Expect(0, 12784, '\p{Blk=:\ACJK_Strokes\z:}', "");;
    Expect(1, 12783, '\p{Blk:	cjkstrokes}', "");
    Expect(0, 12783, '\p{^Blk:	cjkstrokes}', "");
    Expect(0, 12783, '\P{Blk:	cjkstrokes}', "");
    Expect(1, 12783, '\P{^Blk:	cjkstrokes}', "");
    Expect(0, 12784, '\p{Blk:	cjkstrokes}', "");
    Expect(1, 12784, '\p{^Blk:	cjkstrokes}', "");
    Expect(1, 12784, '\P{Blk:	cjkstrokes}', "");
    Expect(0, 12784, '\P{^Blk:	cjkstrokes}', "");
    Expect(1, 12783, '\p{Blk=:\Acjkstrokes\z:}', "");;
    Expect(0, 12784, '\p{Blk=:\Acjkstrokes\z:}', "");;
    Expect(1, 12783, '\p{Blk=	 CJK_Strokes}', "");
    Expect(0, 12783, '\p{^Blk=	 CJK_Strokes}', "");
    Expect(0, 12783, '\P{Blk=	 CJK_Strokes}', "");
    Expect(1, 12783, '\P{^Blk=	 CJK_Strokes}', "");
    Expect(0, 12784, '\p{Blk=	 CJK_Strokes}', "");
    Expect(1, 12784, '\p{^Blk=	 CJK_Strokes}', "");
    Expect(1, 12784, '\P{Blk=	 CJK_Strokes}', "");
    Expect(0, 12784, '\P{^Blk=	 CJK_Strokes}', "");
    Error('\p{Is_Block= _CJK_strokes:=}');
    Error('\P{Is_Block= _CJK_strokes:=}');
    Expect(1, 12783, '\p{Is_Block=cjkstrokes}', "");
    Expect(0, 12783, '\p{^Is_Block=cjkstrokes}', "");
    Expect(0, 12783, '\P{Is_Block=cjkstrokes}', "");
    Expect(1, 12783, '\P{^Is_Block=cjkstrokes}', "");
    Expect(0, 12784, '\p{Is_Block=cjkstrokes}', "");
    Expect(1, 12784, '\p{^Is_Block=cjkstrokes}', "");
    Expect(1, 12784, '\P{Is_Block=cjkstrokes}', "");
    Expect(0, 12784, '\P{^Is_Block=cjkstrokes}', "");
    Expect(1, 12783, '\p{Is_Block=-CJK_Strokes}', "");
    Expect(0, 12783, '\p{^Is_Block=-CJK_Strokes}', "");
    Expect(0, 12783, '\P{Is_Block=-CJK_Strokes}', "");
    Expect(1, 12783, '\P{^Is_Block=-CJK_Strokes}', "");
    Expect(0, 12784, '\p{Is_Block=-CJK_Strokes}', "");
    Expect(1, 12784, '\p{^Is_Block=-CJK_Strokes}', "");
    Expect(1, 12784, '\P{Is_Block=-CJK_Strokes}', "");
    Expect(0, 12784, '\P{^Is_Block=-CJK_Strokes}', "");
    Error('\p{Is_Blk=_CJK_STROKES/a/}');
    Error('\P{Is_Blk=_CJK_STROKES/a/}');
    Expect(1, 12783, '\p{Is_Blk: cjkstrokes}', "");
    Expect(0, 12783, '\p{^Is_Blk: cjkstrokes}', "");
    Expect(0, 12783, '\P{Is_Blk: cjkstrokes}', "");
    Expect(1, 12783, '\P{^Is_Blk: cjkstrokes}', "");
    Expect(0, 12784, '\p{Is_Blk: cjkstrokes}', "");
    Expect(1, 12784, '\p{^Is_Blk: cjkstrokes}', "");
    Expect(1, 12784, '\P{Is_Blk: cjkstrokes}', "");
    Expect(0, 12784, '\P{^Is_Blk: cjkstrokes}', "");
    Expect(1, 12783, '\p{Is_Blk: _CJK_Strokes}', "");
    Expect(0, 12783, '\p{^Is_Blk: _CJK_Strokes}', "");
    Expect(0, 12783, '\P{Is_Blk: _CJK_Strokes}', "");
    Expect(1, 12783, '\P{^Is_Blk: _CJK_Strokes}', "");
    Expect(0, 12784, '\p{Is_Blk: _CJK_Strokes}', "");
    Expect(1, 12784, '\p{^Is_Blk: _CJK_Strokes}', "");
    Expect(1, 12784, '\P{Is_Blk: _CJK_Strokes}', "");
    Expect(0, 12784, '\P{^Is_Blk: _CJK_Strokes}', "");
    Error('\p{Block=:=	_CJK_symbols_And_Punctuation}');
    Error('\P{Block=:=	_CJK_symbols_And_Punctuation}');
    Expect(1, 12351, '\p{Block=:\ACJK_Symbols_And_Punctuation\z:}', "");;
    Expect(0, 12352, '\p{Block=:\ACJK_Symbols_And_Punctuation\z:}', "");;
    Expect(1, 12351, '\p{Block:   cjksymbolsandpunctuation}', "");
    Expect(0, 12351, '\p{^Block:   cjksymbolsandpunctuation}', "");
    Expect(0, 12351, '\P{Block:   cjksymbolsandpunctuation}', "");
    Expect(1, 12351, '\P{^Block:   cjksymbolsandpunctuation}', "");
    Expect(0, 12352, '\p{Block:   cjksymbolsandpunctuation}', "");
    Expect(1, 12352, '\p{^Block:   cjksymbolsandpunctuation}', "");
    Expect(1, 12352, '\P{Block:   cjksymbolsandpunctuation}', "");
    Expect(0, 12352, '\P{^Block:   cjksymbolsandpunctuation}', "");
    Expect(1, 12351, '\p{Block=:\Acjksymbolsandpunctuation\z:}', "");;
    Expect(0, 12352, '\p{Block=:\Acjksymbolsandpunctuation\z:}', "");;
    Expect(1, 12351, '\p{Block=- CJK_SYMBOLS_and_punctuation}', "");
    Expect(0, 12351, '\p{^Block=- CJK_SYMBOLS_and_punctuation}', "");
    Expect(0, 12351, '\P{Block=- CJK_SYMBOLS_and_punctuation}', "");
    Expect(1, 12351, '\P{^Block=- CJK_SYMBOLS_and_punctuation}', "");
    Expect(0, 12352, '\p{Block=- CJK_SYMBOLS_and_punctuation}', "");
    Expect(1, 12352, '\p{^Block=- CJK_SYMBOLS_and_punctuation}', "");
    Expect(1, 12352, '\P{Block=- CJK_SYMBOLS_and_punctuation}', "");
    Expect(0, 12352, '\P{^Block=- CJK_SYMBOLS_and_punctuation}', "");
    Error('\p{Blk: --CJK_SYMBOLS:=}');
    Error('\P{Blk: --CJK_SYMBOLS:=}');
    Expect(1, 12351, '\p{Blk=:\ACJK_Symbols\z:}', "");;
    Expect(0, 12352, '\p{Blk=:\ACJK_Symbols\z:}', "");;
    Expect(1, 12351, '\p{Blk=cjksymbols}', "");
    Expect(0, 12351, '\p{^Blk=cjksymbols}', "");
    Expect(0, 12351, '\P{Blk=cjksymbols}', "");
    Expect(1, 12351, '\P{^Blk=cjksymbols}', "");
    Expect(0, 12352, '\p{Blk=cjksymbols}', "");
    Expect(1, 12352, '\p{^Blk=cjksymbols}', "");
    Expect(1, 12352, '\P{Blk=cjksymbols}', "");
    Expect(0, 12352, '\P{^Blk=cjksymbols}', "");
    Expect(1, 12351, '\p{Blk=:\Acjksymbols\z:}', "");;
    Expect(0, 12352, '\p{Blk=:\Acjksymbols\z:}', "");;
    Expect(1, 12351, '\p{Blk=__cjk_Symbols}', "");
    Expect(0, 12351, '\p{^Blk=__cjk_Symbols}', "");
    Expect(0, 12351, '\P{Blk=__cjk_Symbols}', "");
    Expect(1, 12351, '\P{^Blk=__cjk_Symbols}', "");
    Expect(0, 12352, '\p{Blk=__cjk_Symbols}', "");
    Expect(1, 12352, '\p{^Blk=__cjk_Symbols}', "");
    Expect(1, 12352, '\P{Blk=__cjk_Symbols}', "");
    Expect(0, 12352, '\P{^Blk=__cjk_Symbols}', "");
    Error('\p{Is_Block= /a/CJK_symbols_And_punctuation}');
    Error('\P{Is_Block= /a/CJK_symbols_And_punctuation}');
    Expect(1, 12351, '\p{Is_Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12351, '\p{^Is_Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12351, '\P{Is_Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12351, '\P{^Is_Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12352, '\p{Is_Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12352, '\p{^Is_Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12352, '\P{Is_Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12352, '\P{^Is_Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12351, '\p{Is_Block=-cjk_Symbols_and_punctuation}', "");
    Expect(0, 12351, '\p{^Is_Block=-cjk_Symbols_and_punctuation}', "");
    Expect(0, 12351, '\P{Is_Block=-cjk_Symbols_and_punctuation}', "");
    Expect(1, 12351, '\P{^Is_Block=-cjk_Symbols_and_punctuation}', "");
    Expect(0, 12352, '\p{Is_Block=-cjk_Symbols_and_punctuation}', "");
    Expect(1, 12352, '\p{^Is_Block=-cjk_Symbols_and_punctuation}', "");
    Expect(1, 12352, '\P{Is_Block=-cjk_Symbols_and_punctuation}', "");
    Expect(0, 12352, '\P{^Is_Block=-cjk_Symbols_and_punctuation}', "");
    Error('\p{Is_Blk=-CJK_SYMBOLS:=}');
    Error('\P{Is_Blk=-CJK_SYMBOLS:=}');
    Expect(1, 12351, '\p{Is_Blk:	cjksymbols}', "");
    Expect(0, 12351, '\p{^Is_Blk:	cjksymbols}', "");
    Expect(0, 12351, '\P{Is_Blk:	cjksymbols}', "");
    Expect(1, 12351, '\P{^Is_Blk:	cjksymbols}', "");
    Expect(0, 12352, '\p{Is_Blk:	cjksymbols}', "");
    Expect(1, 12352, '\p{^Is_Blk:	cjksymbols}', "");
    Expect(1, 12352, '\P{Is_Blk:	cjksymbols}', "");
    Expect(0, 12352, '\P{^Is_Blk:	cjksymbols}', "");
    Expect(1, 12351, '\p{Is_Blk=	-CJK_SYMBOLS}', "");
    Expect(0, 12351, '\p{^Is_Blk=	-CJK_SYMBOLS}', "");
    Expect(0, 12351, '\P{Is_Blk=	-CJK_SYMBOLS}', "");
    Expect(1, 12351, '\P{^Is_Blk=	-CJK_SYMBOLS}', "");
    Expect(0, 12352, '\p{Is_Blk=	-CJK_SYMBOLS}', "");
    Expect(1, 12352, '\p{^Is_Blk=	-CJK_SYMBOLS}', "");
    Expect(1, 12352, '\P{Is_Blk=	-CJK_SYMBOLS}', "");
    Expect(0, 12352, '\P{^Is_Blk=	-CJK_SYMBOLS}', "");
    Error('\p{Block=/a/--Hangul_Compatibility_JAMO}');
    Error('\P{Block=/a/--Hangul_Compatibility_JAMO}');
    Expect(1, 12687, '\p{Block=:\AHangul_Compatibility_Jamo\z:}', "");;
    Expect(0, 12688, '\p{Block=:\AHangul_Compatibility_Jamo\z:}', "");;
    Expect(1, 12687, '\p{Block=hangulcompatibilityjamo}', "");
    Expect(0, 12687, '\p{^Block=hangulcompatibilityjamo}', "");
    Expect(0, 12687, '\P{Block=hangulcompatibilityjamo}', "");
    Expect(1, 12687, '\P{^Block=hangulcompatibilityjamo}', "");
    Expect(0, 12688, '\p{Block=hangulcompatibilityjamo}', "");
    Expect(1, 12688, '\p{^Block=hangulcompatibilityjamo}', "");
    Expect(1, 12688, '\P{Block=hangulcompatibilityjamo}', "");
    Expect(0, 12688, '\P{^Block=hangulcompatibilityjamo}', "");
    Expect(1, 12687, '\p{Block=:\Ahangulcompatibilityjamo\z:}', "");;
    Expect(0, 12688, '\p{Block=:\Ahangulcompatibilityjamo\z:}', "");;
    Expect(1, 12687, '\p{Block=--HANGUL_Compatibility_JAMO}', "");
    Expect(0, 12687, '\p{^Block=--HANGUL_Compatibility_JAMO}', "");
    Expect(0, 12687, '\P{Block=--HANGUL_Compatibility_JAMO}', "");
    Expect(1, 12687, '\P{^Block=--HANGUL_Compatibility_JAMO}', "");
    Expect(0, 12688, '\p{Block=--HANGUL_Compatibility_JAMO}', "");
    Expect(1, 12688, '\p{^Block=--HANGUL_Compatibility_JAMO}', "");
    Expect(1, 12688, '\P{Block=--HANGUL_Compatibility_JAMO}', "");
    Expect(0, 12688, '\P{^Block=--HANGUL_Compatibility_JAMO}', "");
    Error('\p{Blk=/a/-compat_JAMO}');
    Error('\P{Blk=/a/-compat_JAMO}');
    Expect(1, 12687, '\p{Blk=:\ACompat_Jamo\z:}', "");;
    Expect(0, 12688, '\p{Blk=:\ACompat_Jamo\z:}', "");;
    Expect(1, 12687, '\p{Blk=compatjamo}', "");
    Expect(0, 12687, '\p{^Blk=compatjamo}', "");
    Expect(0, 12687, '\P{Blk=compatjamo}', "");
    Expect(1, 12687, '\P{^Blk=compatjamo}', "");
    Expect(0, 12688, '\p{Blk=compatjamo}', "");
    Expect(1, 12688, '\p{^Blk=compatjamo}', "");
    Expect(1, 12688, '\P{Blk=compatjamo}', "");
    Expect(0, 12688, '\P{^Blk=compatjamo}', "");
    Expect(1, 12687, '\p{Blk=:\Acompatjamo\z:}', "");;
    Expect(0, 12688, '\p{Blk=:\Acompatjamo\z:}', "");;
    Expect(1, 12687, '\p{Blk=	-Compat_jamo}', "");
    Expect(0, 12687, '\p{^Blk=	-Compat_jamo}', "");
    Expect(0, 12687, '\P{Blk=	-Compat_jamo}', "");
    Expect(1, 12687, '\P{^Blk=	-Compat_jamo}', "");
    Expect(0, 12688, '\p{Blk=	-Compat_jamo}', "");
    Expect(1, 12688, '\p{^Blk=	-Compat_jamo}', "");
    Expect(1, 12688, '\P{Blk=	-Compat_jamo}', "");
    Expect(0, 12688, '\P{^Blk=	-Compat_jamo}', "");
    Error('\p{Is_Block=/a/_Hangul_Compatibility_Jamo}');
    Error('\P{Is_Block=/a/_Hangul_Compatibility_Jamo}');
    Expect(1, 12687, '\p{Is_Block=hangulcompatibilityjamo}', "");
    Expect(0, 12687, '\p{^Is_Block=hangulcompatibilityjamo}', "");
    Expect(0, 12687, '\P{Is_Block=hangulcompatibilityjamo}', "");
    Expect(1, 12687, '\P{^Is_Block=hangulcompatibilityjamo}', "");
    Expect(0, 12688, '\p{Is_Block=hangulcompatibilityjamo}', "");
    Expect(1, 12688, '\p{^Is_Block=hangulcompatibilityjamo}', "");
    Expect(1, 12688, '\P{Is_Block=hangulcompatibilityjamo}', "");
    Expect(0, 12688, '\P{^Is_Block=hangulcompatibilityjamo}', "");
    Expect(1, 12687, '\p{Is_Block=_-Hangul_Compatibility_JAMO}', "");
    Expect(0, 12687, '\p{^Is_Block=_-Hangul_Compatibility_JAMO}', "");
    Expect(0, 12687, '\P{Is_Block=_-Hangul_Compatibility_JAMO}', "");
    Expect(1, 12687, '\P{^Is_Block=_-Hangul_Compatibility_JAMO}', "");
    Expect(0, 12688, '\p{Is_Block=_-Hangul_Compatibility_JAMO}', "");
    Expect(1, 12688, '\p{^Is_Block=_-Hangul_Compatibility_JAMO}', "");
    Expect(1, 12688, '\P{Is_Block=_-Hangul_Compatibility_JAMO}', "");
    Expect(0, 12688, '\P{^Is_Block=_-Hangul_Compatibility_JAMO}', "");
    Error('\p{Is_Blk=/a/ Compat_JAMO}');
    Error('\P{Is_Blk=/a/ Compat_JAMO}');
    Expect(1, 12687, '\p{Is_Blk=compatjamo}', "");
    Expect(0, 12687, '\p{^Is_Blk=compatjamo}', "");
    Expect(0, 12687, '\P{Is_Blk=compatjamo}', "");
    Expect(1, 12687, '\P{^Is_Blk=compatjamo}', "");
    Expect(0, 12688, '\p{Is_Blk=compatjamo}', "");
    Expect(1, 12688, '\p{^Is_Blk=compatjamo}', "");
    Expect(1, 12688, '\P{Is_Blk=compatjamo}', "");
    Expect(0, 12688, '\P{^Is_Blk=compatjamo}', "");
    Expect(1, 12687, '\p{Is_Blk=-_Compat_JAMO}', "");
    Expect(0, 12687, '\p{^Is_Blk=-_Compat_JAMO}', "");
    Expect(0, 12687, '\P{Is_Blk=-_Compat_JAMO}', "");
    Expect(1, 12687, '\P{^Is_Blk=-_Compat_JAMO}', "");
    Expect(0, 12688, '\p{Is_Blk=-_Compat_JAMO}', "");
    Expect(1, 12688, '\p{^Is_Blk=-_Compat_JAMO}', "");
    Expect(1, 12688, '\P{Is_Blk=-_Compat_JAMO}', "");
    Expect(0, 12688, '\P{^Is_Blk=-_Compat_JAMO}', "");
    Error('\p{Block=/a/Control_Pictures}');
    Error('\P{Block=/a/Control_Pictures}');
    Expect(1, 9279, '\p{Block=:\AControl_Pictures\z:}', "");;
    Expect(0, 9280, '\p{Block=:\AControl_Pictures\z:}', "");;
    Expect(1, 9279, '\p{Block: controlpictures}', "");
    Expect(0, 9279, '\p{^Block: controlpictures}', "");
    Expect(0, 9279, '\P{Block: controlpictures}', "");
    Expect(1, 9279, '\P{^Block: controlpictures}', "");
    Expect(0, 9280, '\p{Block: controlpictures}', "");
    Expect(1, 9280, '\p{^Block: controlpictures}', "");
    Expect(1, 9280, '\P{Block: controlpictures}', "");
    Expect(0, 9280, '\P{^Block: controlpictures}', "");
    Expect(1, 9279, '\p{Block=:\Acontrolpictures\z:}', "");;
    Expect(0, 9280, '\p{Block=:\Acontrolpictures\z:}', "");;
    Expect(1, 9279, '\p{Block=-_Control_PICTURES}', "");
    Expect(0, 9279, '\p{^Block=-_Control_PICTURES}', "");
    Expect(0, 9279, '\P{Block=-_Control_PICTURES}', "");
    Expect(1, 9279, '\P{^Block=-_Control_PICTURES}', "");
    Expect(0, 9280, '\p{Block=-_Control_PICTURES}', "");
    Expect(1, 9280, '\p{^Block=-_Control_PICTURES}', "");
    Expect(1, 9280, '\P{Block=-_Control_PICTURES}', "");
    Expect(0, 9280, '\P{^Block=-_Control_PICTURES}', "");
    Error('\p{Blk=:=	 Control_PICTURES}');
    Error('\P{Blk=:=	 Control_PICTURES}');
    Expect(1, 9279, '\p{Blk=:\AControl_Pictures\z:}', "");;
    Expect(0, 9280, '\p{Blk=:\AControl_Pictures\z:}', "");;
    Expect(1, 9279, '\p{Blk=controlpictures}', "");
    Expect(0, 9279, '\p{^Blk=controlpictures}', "");
    Expect(0, 9279, '\P{Blk=controlpictures}', "");
    Expect(1, 9279, '\P{^Blk=controlpictures}', "");
    Expect(0, 9280, '\p{Blk=controlpictures}', "");
    Expect(1, 9280, '\p{^Blk=controlpictures}', "");
    Expect(1, 9280, '\P{Blk=controlpictures}', "");
    Expect(0, 9280, '\P{^Blk=controlpictures}', "");
    Expect(1, 9279, '\p{Blk=:\Acontrolpictures\z:}', "");;
    Expect(0, 9280, '\p{Blk=:\Acontrolpictures\z:}', "");;
    Expect(1, 9279, '\p{Blk= 	control_PICTURES}', "");
    Expect(0, 9279, '\p{^Blk= 	control_PICTURES}', "");
    Expect(0, 9279, '\P{Blk= 	control_PICTURES}', "");
    Expect(1, 9279, '\P{^Blk= 	control_PICTURES}', "");
    Expect(0, 9280, '\p{Blk= 	control_PICTURES}', "");
    Expect(1, 9280, '\p{^Blk= 	control_PICTURES}', "");
    Expect(1, 9280, '\P{Blk= 	control_PICTURES}', "");
    Expect(0, 9280, '\P{^Blk= 	control_PICTURES}', "");
    Error('\p{Is_Block=:=	Control_Pictures}');
    Error('\P{Is_Block=:=	Control_Pictures}');
    Expect(1, 9279, '\p{Is_Block=controlpictures}', "");
    Expect(0, 9279, '\p{^Is_Block=controlpictures}', "");
    Expect(0, 9279, '\P{Is_Block=controlpictures}', "");
    Expect(1, 9279, '\P{^Is_Block=controlpictures}', "");
    Expect(0, 9280, '\p{Is_Block=controlpictures}', "");
    Expect(1, 9280, '\p{^Is_Block=controlpictures}', "");
    Expect(1, 9280, '\P{Is_Block=controlpictures}', "");
    Expect(0, 9280, '\P{^Is_Block=controlpictures}', "");
    Expect(1, 9279, '\p{Is_Block=	_Control_pictures}', "");
    Expect(0, 9279, '\p{^Is_Block=	_Control_pictures}', "");
    Expect(0, 9279, '\P{Is_Block=	_Control_pictures}', "");
    Expect(1, 9279, '\P{^Is_Block=	_Control_pictures}', "");
    Expect(0, 9280, '\p{Is_Block=	_Control_pictures}', "");
    Expect(1, 9280, '\p{^Is_Block=	_Control_pictures}', "");
    Expect(1, 9280, '\P{Is_Block=	_Control_pictures}', "");
    Expect(0, 9280, '\P{^Is_Block=	_Control_pictures}', "");
    Error('\p{Is_Blk=:=  CONTROL_Pictures}');
    Error('\P{Is_Blk=:=  CONTROL_Pictures}');
    Expect(1, 9279, '\p{Is_Blk: controlpictures}', "");
    Expect(0, 9279, '\p{^Is_Blk: controlpictures}', "");
    Expect(0, 9279, '\P{Is_Blk: controlpictures}', "");
    Expect(1, 9279, '\P{^Is_Blk: controlpictures}', "");
    Expect(0, 9280, '\p{Is_Blk: controlpictures}', "");
    Expect(1, 9280, '\p{^Is_Blk: controlpictures}', "");
    Expect(1, 9280, '\P{Is_Blk: controlpictures}', "");
    Expect(0, 9280, '\P{^Is_Blk: controlpictures}', "");
    Expect(1, 9279, '\p{Is_Blk=	Control_pictures}', "");
    Expect(0, 9279, '\p{^Is_Blk=	Control_pictures}', "");
    Expect(0, 9279, '\P{Is_Blk=	Control_pictures}', "");
    Expect(1, 9279, '\P{^Is_Blk=	Control_pictures}', "");
    Expect(0, 9280, '\p{Is_Blk=	Control_pictures}', "");
    Expect(1, 9280, '\p{^Is_Blk=	Control_pictures}', "");
    Expect(1, 9280, '\P{Is_Blk=	Control_pictures}', "");
    Expect(0, 9280, '\P{^Is_Blk=	Control_pictures}', "");
    Error('\p{Block=_:=COPTIC}');
    Error('\P{Block=_:=COPTIC}');
    Expect(1, 11519, '\p{Block=:\ACoptic\z:}', "");;
    Expect(0, 11520, '\p{Block=:\ACoptic\z:}', "");;
    Expect(1, 11519, '\p{Block=coptic}', "");
    Expect(0, 11519, '\p{^Block=coptic}', "");
    Expect(0, 11519, '\P{Block=coptic}', "");
    Expect(1, 11519, '\P{^Block=coptic}', "");
    Expect(0, 11520, '\p{Block=coptic}', "");
    Expect(1, 11520, '\p{^Block=coptic}', "");
    Expect(1, 11520, '\P{Block=coptic}', "");
    Expect(0, 11520, '\P{^Block=coptic}', "");
    Expect(1, 11519, '\p{Block=:\Acoptic\z:}', "");;
    Expect(0, 11520, '\p{Block=:\Acoptic\z:}', "");;
    Expect(1, 11519, '\p{Block=	_COPTIC}', "");
    Expect(0, 11519, '\p{^Block=	_COPTIC}', "");
    Expect(0, 11519, '\P{Block=	_COPTIC}', "");
    Expect(1, 11519, '\P{^Block=	_COPTIC}', "");
    Expect(0, 11520, '\p{Block=	_COPTIC}', "");
    Expect(1, 11520, '\p{^Block=	_COPTIC}', "");
    Expect(1, 11520, '\P{Block=	_COPTIC}', "");
    Expect(0, 11520, '\P{^Block=	_COPTIC}', "");
    Error('\p{Blk=	/a/Coptic}');
    Error('\P{Blk=	/a/Coptic}');
    Expect(1, 11519, '\p{Blk=:\ACoptic\z:}', "");;
    Expect(0, 11520, '\p{Blk=:\ACoptic\z:}', "");;
    Expect(1, 11519, '\p{Blk=coptic}', "");
    Expect(0, 11519, '\p{^Blk=coptic}', "");
    Expect(0, 11519, '\P{Blk=coptic}', "");
    Expect(1, 11519, '\P{^Blk=coptic}', "");
    Expect(0, 11520, '\p{Blk=coptic}', "");
    Expect(1, 11520, '\p{^Blk=coptic}', "");
    Expect(1, 11520, '\P{Blk=coptic}', "");
    Expect(0, 11520, '\P{^Blk=coptic}', "");
    Expect(1, 11519, '\p{Blk=:\Acoptic\z:}', "");;
    Expect(0, 11520, '\p{Blk=:\Acoptic\z:}', "");;
    Expect(1, 11519, '\p{Blk=_	coptic}', "");
    Expect(0, 11519, '\p{^Blk=_	coptic}', "");
    Expect(0, 11519, '\P{Blk=_	coptic}', "");
    Expect(1, 11519, '\P{^Blk=_	coptic}', "");
    Expect(0, 11520, '\p{Blk=_	coptic}', "");
    Expect(1, 11520, '\p{^Blk=_	coptic}', "");
    Expect(1, 11520, '\P{Blk=_	coptic}', "");
    Expect(0, 11520, '\P{^Blk=_	coptic}', "");
    Error('\p{Is_Block=	 Coptic/a/}');
    Error('\P{Is_Block=	 Coptic/a/}');
    Expect(1, 11519, '\p{Is_Block=coptic}', "");
    Expect(0, 11519, '\p{^Is_Block=coptic}', "");
    Expect(0, 11519, '\P{Is_Block=coptic}', "");
    Expect(1, 11519, '\P{^Is_Block=coptic}', "");
    Expect(0, 11520, '\p{Is_Block=coptic}', "");
    Expect(1, 11520, '\p{^Is_Block=coptic}', "");
    Expect(1, 11520, '\P{Is_Block=coptic}', "");
    Expect(0, 11520, '\P{^Is_Block=coptic}', "");
    Expect(1, 11519, '\p{Is_Block=-COPTIC}', "");
    Expect(0, 11519, '\p{^Is_Block=-COPTIC}', "");
    Expect(0, 11519, '\P{Is_Block=-COPTIC}', "");
    Expect(1, 11519, '\P{^Is_Block=-COPTIC}', "");
    Expect(0, 11520, '\p{Is_Block=-COPTIC}', "");
    Expect(1, 11520, '\p{^Is_Block=-COPTIC}', "");
    Expect(1, 11520, '\P{Is_Block=-COPTIC}', "");
    Expect(0, 11520, '\P{^Is_Block=-COPTIC}', "");
    Error('\p{Is_Blk=/a/-COPTIC}');
    Error('\P{Is_Blk=/a/-COPTIC}');
    Expect(1, 11519, '\p{Is_Blk=coptic}', "");
    Expect(0, 11519, '\p{^Is_Blk=coptic}', "");
    Expect(0, 11519, '\P{Is_Blk=coptic}', "");
    Expect(1, 11519, '\P{^Is_Blk=coptic}', "");
    Expect(0, 11520, '\p{Is_Blk=coptic}', "");
    Expect(1, 11520, '\p{^Is_Blk=coptic}', "");
    Expect(1, 11520, '\P{Is_Blk=coptic}', "");
    Expect(0, 11520, '\P{^Is_Blk=coptic}', "");
    Expect(1, 11519, '\p{Is_Blk=-_COPTIC}', "");
    Expect(0, 11519, '\p{^Is_Blk=-_COPTIC}', "");
    Expect(0, 11519, '\P{Is_Blk=-_COPTIC}', "");
    Expect(1, 11519, '\P{^Is_Blk=-_COPTIC}', "");
    Expect(0, 11520, '\p{Is_Blk=-_COPTIC}', "");
    Expect(1, 11520, '\p{^Is_Blk=-_COPTIC}', "");
    Expect(1, 11520, '\P{Is_Blk=-_COPTIC}', "");
    Expect(0, 11520, '\P{^Is_Blk=-_COPTIC}', "");
    Error('\p{Block=:=_-Coptic_EPACT_NUMBERS}');
    Error('\P{Block=:=_-Coptic_EPACT_NUMBERS}');
    Expect(1, 66303, '\p{Block=:\ACoptic_Epact_Numbers\z:}', "");;
    Expect(0, 66304, '\p{Block=:\ACoptic_Epact_Numbers\z:}', "");;
    Expect(1, 66303, '\p{Block:copticepactnumbers}', "");
    Expect(0, 66303, '\p{^Block:copticepactnumbers}', "");
    Expect(0, 66303, '\P{Block:copticepactnumbers}', "");
    Expect(1, 66303, '\P{^Block:copticepactnumbers}', "");
    Expect(0, 66304, '\p{Block:copticepactnumbers}', "");
    Expect(1, 66304, '\p{^Block:copticepactnumbers}', "");
    Expect(1, 66304, '\P{Block:copticepactnumbers}', "");
    Expect(0, 66304, '\P{^Block:copticepactnumbers}', "");
    Expect(1, 66303, '\p{Block=:\Acopticepactnumbers\z:}', "");;
    Expect(0, 66304, '\p{Block=:\Acopticepactnumbers\z:}', "");;
    Expect(1, 66303, '\p{Block=	 coptic_EPACT_numbers}', "");
    Expect(0, 66303, '\p{^Block=	 coptic_EPACT_numbers}', "");
    Expect(0, 66303, '\P{Block=	 coptic_EPACT_numbers}', "");
    Expect(1, 66303, '\P{^Block=	 coptic_EPACT_numbers}', "");
    Expect(0, 66304, '\p{Block=	 coptic_EPACT_numbers}', "");
    Expect(1, 66304, '\p{^Block=	 coptic_EPACT_numbers}', "");
    Expect(1, 66304, '\P{Block=	 coptic_EPACT_numbers}', "");
    Expect(0, 66304, '\P{^Block=	 coptic_EPACT_numbers}', "");
    Error('\p{Blk= /a/Coptic_EPACT_NUMBERS}');
    Error('\P{Blk= /a/Coptic_EPACT_NUMBERS}');
    Expect(1, 66303, '\p{Blk=:\ACoptic_Epact_Numbers\z:}', "");;
    Expect(0, 66304, '\p{Blk=:\ACoptic_Epact_Numbers\z:}', "");;
    Expect(1, 66303, '\p{Blk: copticepactnumbers}', "");
    Expect(0, 66303, '\p{^Blk: copticepactnumbers}', "");
    Expect(0, 66303, '\P{Blk: copticepactnumbers}', "");
    Expect(1, 66303, '\P{^Blk: copticepactnumbers}', "");
    Expect(0, 66304, '\p{Blk: copticepactnumbers}', "");
    Expect(1, 66304, '\p{^Blk: copticepactnumbers}', "");
    Expect(1, 66304, '\P{Blk: copticepactnumbers}', "");
    Expect(0, 66304, '\P{^Blk: copticepactnumbers}', "");
    Expect(1, 66303, '\p{Blk=:\Acopticepactnumbers\z:}', "");;
    Expect(0, 66304, '\p{Blk=:\Acopticepactnumbers\z:}', "");;
    Expect(1, 66303, '\p{Blk:   -coptic_Epact_numbers}', "");
    Expect(0, 66303, '\p{^Blk:   -coptic_Epact_numbers}', "");
    Expect(0, 66303, '\P{Blk:   -coptic_Epact_numbers}', "");
    Expect(1, 66303, '\P{^Blk:   -coptic_Epact_numbers}', "");
    Expect(0, 66304, '\p{Blk:   -coptic_Epact_numbers}', "");
    Expect(1, 66304, '\p{^Blk:   -coptic_Epact_numbers}', "");
    Expect(1, 66304, '\P{Blk:   -coptic_Epact_numbers}', "");
    Expect(0, 66304, '\P{^Blk:   -coptic_Epact_numbers}', "");
    Error('\p{Is_Block=-/a/Coptic_Epact_NUMBERS}');
    Error('\P{Is_Block=-/a/Coptic_Epact_NUMBERS}');
    Expect(1, 66303, '\p{Is_Block:	copticepactnumbers}', "");
    Expect(0, 66303, '\p{^Is_Block:	copticepactnumbers}', "");
    Expect(0, 66303, '\P{Is_Block:	copticepactnumbers}', "");
    Expect(1, 66303, '\P{^Is_Block:	copticepactnumbers}', "");
    Expect(0, 66304, '\p{Is_Block:	copticepactnumbers}', "");
    Expect(1, 66304, '\p{^Is_Block:	copticepactnumbers}', "");
    Expect(1, 66304, '\P{Is_Block:	copticepactnumbers}', "");
    Expect(0, 66304, '\P{^Is_Block:	copticepactnumbers}', "");
    Expect(1, 66303, '\p{Is_Block=-_COPTIC_Epact_Numbers}', "");
    Expect(0, 66303, '\p{^Is_Block=-_COPTIC_Epact_Numbers}', "");
    Expect(0, 66303, '\P{Is_Block=-_COPTIC_Epact_Numbers}', "");
    Expect(1, 66303, '\P{^Is_Block=-_COPTIC_Epact_Numbers}', "");
    Expect(0, 66304, '\p{Is_Block=-_COPTIC_Epact_Numbers}', "");
    Expect(1, 66304, '\p{^Is_Block=-_COPTIC_Epact_Numbers}', "");
    Expect(1, 66304, '\P{Is_Block=-_COPTIC_Epact_Numbers}', "");
    Expect(0, 66304, '\P{^Is_Block=-_COPTIC_Epact_Numbers}', "");
    Error('\p{Is_Blk= _Coptic_epact_Numbers/a/}');
    Error('\P{Is_Blk= _Coptic_epact_Numbers/a/}');
    Expect(1, 66303, '\p{Is_Blk:copticepactnumbers}', "");
    Expect(0, 66303, '\p{^Is_Blk:copticepactnumbers}', "");
    Expect(0, 66303, '\P{Is_Blk:copticepactnumbers}', "");
    Expect(1, 66303, '\P{^Is_Blk:copticepactnumbers}', "");
    Expect(0, 66304, '\p{Is_Blk:copticepactnumbers}', "");
    Expect(1, 66304, '\p{^Is_Blk:copticepactnumbers}', "");
    Expect(1, 66304, '\P{Is_Blk:copticepactnumbers}', "");
    Expect(0, 66304, '\P{^Is_Blk:copticepactnumbers}', "");
    Expect(1, 66303, '\p{Is_Blk=	coptic_Epact_Numbers}', "");
    Expect(0, 66303, '\p{^Is_Blk=	coptic_Epact_Numbers}', "");
    Expect(0, 66303, '\P{Is_Blk=	coptic_Epact_Numbers}', "");
    Expect(1, 66303, '\P{^Is_Blk=	coptic_Epact_Numbers}', "");
    Expect(0, 66304, '\p{Is_Blk=	coptic_Epact_Numbers}', "");
    Expect(1, 66304, '\p{^Is_Blk=	coptic_Epact_Numbers}', "");
    Expect(1, 66304, '\P{Is_Blk=	coptic_Epact_Numbers}', "");
    Expect(0, 66304, '\P{^Is_Blk=	coptic_Epact_Numbers}', "");
    Error('\p{Block=  counting_rod_Numerals/a/}');
    Error('\P{Block=  counting_rod_Numerals/a/}');
    Expect(1, 119679, '\p{Block=:\ACounting_Rod_Numerals\z:}', "");;
    Expect(0, 119680, '\p{Block=:\ACounting_Rod_Numerals\z:}', "");;
    Expect(1, 119679, '\p{Block=countingrodnumerals}', "");
    Expect(0, 119679, '\p{^Block=countingrodnumerals}', "");
    Expect(0, 119679, '\P{Block=countingrodnumerals}', "");
    Expect(1, 119679, '\P{^Block=countingrodnumerals}', "");
    Expect(0, 119680, '\p{Block=countingrodnumerals}', "");
    Expect(1, 119680, '\p{^Block=countingrodnumerals}', "");
    Expect(1, 119680, '\P{Block=countingrodnumerals}', "");
    Expect(0, 119680, '\P{^Block=countingrodnumerals}', "");
    Expect(1, 119679, '\p{Block=:\Acountingrodnumerals\z:}', "");;
    Expect(0, 119680, '\p{Block=:\Acountingrodnumerals\z:}', "");;
    Expect(1, 119679, '\p{Block=	-counting_Rod_numerals}', "");
    Expect(0, 119679, '\p{^Block=	-counting_Rod_numerals}', "");
    Expect(0, 119679, '\P{Block=	-counting_Rod_numerals}', "");
    Expect(1, 119679, '\P{^Block=	-counting_Rod_numerals}', "");
    Expect(0, 119680, '\p{Block=	-counting_Rod_numerals}', "");
    Expect(1, 119680, '\p{^Block=	-counting_Rod_numerals}', "");
    Expect(1, 119680, '\P{Block=	-counting_Rod_numerals}', "");
    Expect(0, 119680, '\P{^Block=	-counting_Rod_numerals}', "");
    Error('\p{Blk=/a/_ COUNTING_Rod}');
    Error('\P{Blk=/a/_ COUNTING_Rod}');
    Expect(1, 119679, '\p{Blk=:\ACounting_Rod\z:}', "");;
    Expect(0, 119680, '\p{Blk=:\ACounting_Rod\z:}', "");;
    Expect(1, 119679, '\p{Blk=countingrod}', "");
    Expect(0, 119679, '\p{^Blk=countingrod}', "");
    Expect(0, 119679, '\P{Blk=countingrod}', "");
    Expect(1, 119679, '\P{^Blk=countingrod}', "");
    Expect(0, 119680, '\p{Blk=countingrod}', "");
    Expect(1, 119680, '\p{^Blk=countingrod}', "");
    Expect(1, 119680, '\P{Blk=countingrod}', "");
    Expect(0, 119680, '\P{^Blk=countingrod}', "");
    Expect(1, 119679, '\p{Blk=:\Acountingrod\z:}', "");;
    Expect(0, 119680, '\p{Blk=:\Acountingrod\z:}', "");;
    Expect(1, 119679, '\p{Blk=  Counting_Rod}', "");
    Expect(0, 119679, '\p{^Blk=  Counting_Rod}', "");
    Expect(0, 119679, '\P{Blk=  Counting_Rod}', "");
    Expect(1, 119679, '\P{^Blk=  Counting_Rod}', "");
    Expect(0, 119680, '\p{Blk=  Counting_Rod}', "");
    Expect(1, 119680, '\p{^Blk=  Counting_Rod}', "");
    Expect(1, 119680, '\P{Blk=  Counting_Rod}', "");
    Expect(0, 119680, '\P{^Blk=  Counting_Rod}', "");
    Error('\p{Is_Block=/a/ _counting_ROD_Numerals}');
    Error('\P{Is_Block=/a/ _counting_ROD_Numerals}');
    Expect(1, 119679, '\p{Is_Block=countingrodnumerals}', "");
    Expect(0, 119679, '\p{^Is_Block=countingrodnumerals}', "");
    Expect(0, 119679, '\P{Is_Block=countingrodnumerals}', "");
    Expect(1, 119679, '\P{^Is_Block=countingrodnumerals}', "");
    Expect(0, 119680, '\p{Is_Block=countingrodnumerals}', "");
    Expect(1, 119680, '\p{^Is_Block=countingrodnumerals}', "");
    Expect(1, 119680, '\P{Is_Block=countingrodnumerals}', "");
    Expect(0, 119680, '\P{^Is_Block=countingrodnumerals}', "");
    Expect(1, 119679, '\p{Is_Block=	COUNTING_ROD_NUMERALS}', "");
    Expect(0, 119679, '\p{^Is_Block=	COUNTING_ROD_NUMERALS}', "");
    Expect(0, 119679, '\P{Is_Block=	COUNTING_ROD_NUMERALS}', "");
    Expect(1, 119679, '\P{^Is_Block=	COUNTING_ROD_NUMERALS}', "");
    Expect(0, 119680, '\p{Is_Block=	COUNTING_ROD_NUMERALS}', "");
    Expect(1, 119680, '\p{^Is_Block=	COUNTING_ROD_NUMERALS}', "");
    Expect(1, 119680, '\P{Is_Block=	COUNTING_ROD_NUMERALS}', "");
    Expect(0, 119680, '\P{^Is_Block=	COUNTING_ROD_NUMERALS}', "");
    Error('\p{Is_Blk=/a/_Counting_Rod}');
    Error('\P{Is_Blk=/a/_Counting_Rod}');
    Expect(1, 119679, '\p{Is_Blk=countingrod}', "");
    Expect(0, 119679, '\p{^Is_Blk=countingrod}', "");
    Expect(0, 119679, '\P{Is_Blk=countingrod}', "");
    Expect(1, 119679, '\P{^Is_Blk=countingrod}', "");
    Expect(0, 119680, '\p{Is_Blk=countingrod}', "");
    Expect(1, 119680, '\p{^Is_Blk=countingrod}', "");
    Expect(1, 119680, '\P{Is_Blk=countingrod}', "");
    Expect(0, 119680, '\P{^Is_Blk=countingrod}', "");
    Expect(1, 119679, '\p{Is_Blk=-	counting_Rod}', "");
    Expect(0, 119679, '\p{^Is_Blk=-	counting_Rod}', "");
    Expect(0, 119679, '\P{Is_Blk=-	counting_Rod}', "");
    Expect(1, 119679, '\P{^Is_Blk=-	counting_Rod}', "");
    Expect(0, 119680, '\p{Is_Blk=-	counting_Rod}', "");
    Expect(1, 119680, '\p{^Is_Blk=-	counting_Rod}', "");
    Expect(1, 119680, '\P{Is_Blk=-	counting_Rod}', "");
    Expect(0, 119680, '\P{^Is_Blk=-	counting_Rod}', "");
    Error('\p{Block=/a/_	CUNEIFORM}');
    Error('\P{Block=/a/_	CUNEIFORM}');
    Expect(1, 74751, '\p{Block=:\ACuneiform\z:}', "");;
    Expect(0, 74752, '\p{Block=:\ACuneiform\z:}', "");;
    Expect(1, 74751, '\p{Block=cuneiform}', "");
    Expect(0, 74751, '\p{^Block=cuneiform}', "");
    Expect(0, 74751, '\P{Block=cuneiform}', "");
    Expect(1, 74751, '\P{^Block=cuneiform}', "");
    Expect(0, 74752, '\p{Block=cuneiform}', "");
    Expect(1, 74752, '\p{^Block=cuneiform}', "");
    Expect(1, 74752, '\P{Block=cuneiform}', "");
    Expect(0, 74752, '\P{^Block=cuneiform}', "");
    Expect(1, 74751, '\p{Block=:\Acuneiform\z:}', "");;
    Expect(0, 74752, '\p{Block=:\Acuneiform\z:}', "");;
    Expect(1, 74751, '\p{Block=_	Cuneiform}', "");
    Expect(0, 74751, '\p{^Block=_	Cuneiform}', "");
    Expect(0, 74751, '\P{Block=_	Cuneiform}', "");
    Expect(1, 74751, '\P{^Block=_	Cuneiform}', "");
    Expect(0, 74752, '\p{Block=_	Cuneiform}', "");
    Expect(1, 74752, '\p{^Block=_	Cuneiform}', "");
    Expect(1, 74752, '\P{Block=_	Cuneiform}', "");
    Expect(0, 74752, '\P{^Block=_	Cuneiform}', "");
    Error('\p{Blk=:=	Cuneiform}');
    Error('\P{Blk=:=	Cuneiform}');
    Expect(1, 74751, '\p{Blk=:\ACuneiform\z:}', "");;
    Expect(0, 74752, '\p{Blk=:\ACuneiform\z:}', "");;
    Expect(1, 74751, '\p{Blk=cuneiform}', "");
    Expect(0, 74751, '\p{^Blk=cuneiform}', "");
    Expect(0, 74751, '\P{Blk=cuneiform}', "");
    Expect(1, 74751, '\P{^Blk=cuneiform}', "");
    Expect(0, 74752, '\p{Blk=cuneiform}', "");
    Expect(1, 74752, '\p{^Blk=cuneiform}', "");
    Expect(1, 74752, '\P{Blk=cuneiform}', "");
    Expect(0, 74752, '\P{^Blk=cuneiform}', "");
    Expect(1, 74751, '\p{Blk=:\Acuneiform\z:}', "");;
    Expect(0, 74752, '\p{Blk=:\Acuneiform\z:}', "");;
    Expect(1, 74751, '\p{Blk:		cuneiform}', "");
    Expect(0, 74751, '\p{^Blk:		cuneiform}', "");
    Expect(0, 74751, '\P{Blk:		cuneiform}', "");
    Expect(1, 74751, '\P{^Blk:		cuneiform}', "");
    Expect(0, 74752, '\p{Blk:		cuneiform}', "");
    Expect(1, 74752, '\p{^Blk:		cuneiform}', "");
    Expect(1, 74752, '\P{Blk:		cuneiform}', "");
    Expect(0, 74752, '\P{^Blk:		cuneiform}', "");
    Error('\p{Is_Block=/a/  cuneiform}');
    Error('\P{Is_Block=/a/  cuneiform}');
    Expect(1, 74751, '\p{Is_Block:   cuneiform}', "");
    Expect(0, 74751, '\p{^Is_Block:   cuneiform}', "");
    Expect(0, 74751, '\P{Is_Block:   cuneiform}', "");
    Expect(1, 74751, '\P{^Is_Block:   cuneiform}', "");
    Expect(0, 74752, '\p{Is_Block:   cuneiform}', "");
    Expect(1, 74752, '\p{^Is_Block:   cuneiform}', "");
    Expect(1, 74752, '\P{Is_Block:   cuneiform}', "");
    Expect(0, 74752, '\P{^Is_Block:   cuneiform}', "");
    Expect(1, 74751, '\p{Is_Block=__CUNEIFORM}', "");
    Expect(0, 74751, '\p{^Is_Block=__CUNEIFORM}', "");
    Expect(0, 74751, '\P{Is_Block=__CUNEIFORM}', "");
    Expect(1, 74751, '\P{^Is_Block=__CUNEIFORM}', "");
    Expect(0, 74752, '\p{Is_Block=__CUNEIFORM}', "");
    Expect(1, 74752, '\p{^Is_Block=__CUNEIFORM}', "");
    Expect(1, 74752, '\P{Is_Block=__CUNEIFORM}', "");
    Expect(0, 74752, '\P{^Is_Block=__CUNEIFORM}', "");
    Error('\p{Is_Blk:   	:=cuneiform}');
    Error('\P{Is_Blk:   	:=cuneiform}');
    Expect(1, 74751, '\p{Is_Blk=cuneiform}', "");
    Expect(0, 74751, '\p{^Is_Blk=cuneiform}', "");
    Expect(0, 74751, '\P{Is_Blk=cuneiform}', "");
    Expect(1, 74751, '\P{^Is_Blk=cuneiform}', "");
    Expect(0, 74752, '\p{Is_Blk=cuneiform}', "");
    Expect(1, 74752, '\p{^Is_Blk=cuneiform}', "");
    Expect(1, 74752, '\P{Is_Blk=cuneiform}', "");
    Expect(0, 74752, '\P{^Is_Blk=cuneiform}', "");
    Expect(1, 74751, '\p{Is_Blk=  cuneiform}', "");
    Expect(0, 74751, '\p{^Is_Blk=  cuneiform}', "");
    Expect(0, 74751, '\P{Is_Blk=  cuneiform}', "");
    Expect(1, 74751, '\P{^Is_Blk=  cuneiform}', "");
    Expect(0, 74752, '\p{Is_Blk=  cuneiform}', "");
    Expect(1, 74752, '\p{^Is_Blk=  cuneiform}', "");
    Expect(1, 74752, '\P{Is_Blk=  cuneiform}', "");
    Expect(0, 74752, '\P{^Is_Blk=  cuneiform}', "");
    Error('\p{Block=:=_cuneiform_numbers_And_Punctuation}');
    Error('\P{Block=:=_cuneiform_numbers_And_Punctuation}');
    Expect(1, 74879, '\p{Block=:\ACuneiform_Numbers_And_Punctuation\z:}', "");;
    Expect(0, 74880, '\p{Block=:\ACuneiform_Numbers_And_Punctuation\z:}', "");;
    Expect(1, 74879, '\p{Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74879, '\p{^Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74879, '\P{Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74879, '\P{^Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74880, '\p{Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74880, '\p{^Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74880, '\P{Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74880, '\P{^Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74879, '\p{Block=:\Acuneiformnumbersandpunctuation\z:}', "");;
    Expect(0, 74880, '\p{Block=:\Acuneiformnumbersandpunctuation\z:}', "");;
    Expect(1, 74879, '\p{Block= 	Cuneiform_numbers_AND_punctuation}', "");
    Expect(0, 74879, '\p{^Block= 	Cuneiform_numbers_AND_punctuation}', "");
    Expect(0, 74879, '\P{Block= 	Cuneiform_numbers_AND_punctuation}', "");
    Expect(1, 74879, '\P{^Block= 	Cuneiform_numbers_AND_punctuation}', "");
    Expect(0, 74880, '\p{Block= 	Cuneiform_numbers_AND_punctuation}', "");
    Expect(1, 74880, '\p{^Block= 	Cuneiform_numbers_AND_punctuation}', "");
    Expect(1, 74880, '\P{Block= 	Cuneiform_numbers_AND_punctuation}', "");
    Expect(0, 74880, '\P{^Block= 	Cuneiform_numbers_AND_punctuation}', "");
    Error('\p{Blk=/a/ 	cuneiform_Numbers}');
    Error('\P{Blk=/a/ 	cuneiform_Numbers}');
    Expect(1, 74879, '\p{Blk=:\ACuneiform_Numbers\z:}', "");;
    Expect(0, 74880, '\p{Blk=:\ACuneiform_Numbers\z:}', "");;
    Expect(1, 74879, '\p{Blk=cuneiformnumbers}', "");
    Expect(0, 74879, '\p{^Blk=cuneiformnumbers}', "");
    Expect(0, 74879, '\P{Blk=cuneiformnumbers}', "");
    Expect(1, 74879, '\P{^Blk=cuneiformnumbers}', "");
    Expect(0, 74880, '\p{Blk=cuneiformnumbers}', "");
    Expect(1, 74880, '\p{^Blk=cuneiformnumbers}', "");
    Expect(1, 74880, '\P{Blk=cuneiformnumbers}', "");
    Expect(0, 74880, '\P{^Blk=cuneiformnumbers}', "");
    Expect(1, 74879, '\p{Blk=:\Acuneiformnumbers\z:}', "");;
    Expect(0, 74880, '\p{Blk=:\Acuneiformnumbers\z:}', "");;
    Expect(1, 74879, '\p{Blk=_cuneiform_numbers}', "");
    Expect(0, 74879, '\p{^Blk=_cuneiform_numbers}', "");
    Expect(0, 74879, '\P{Blk=_cuneiform_numbers}', "");
    Expect(1, 74879, '\P{^Blk=_cuneiform_numbers}', "");
    Expect(0, 74880, '\p{Blk=_cuneiform_numbers}', "");
    Expect(1, 74880, '\p{^Blk=_cuneiform_numbers}', "");
    Expect(1, 74880, '\P{Blk=_cuneiform_numbers}', "");
    Expect(0, 74880, '\P{^Blk=_cuneiform_numbers}', "");
    Error('\p{Is_Block=	:=Cuneiform_Numbers_AND_Punctuation}');
    Error('\P{Is_Block=	:=Cuneiform_Numbers_AND_Punctuation}');
    Expect(1, 74879, '\p{Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74879, '\p{^Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74879, '\P{Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74879, '\P{^Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74880, '\p{Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74880, '\p{^Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74880, '\P{Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74880, '\P{^Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74879, '\p{Is_Block=_ Cuneiform_NUMBERS_And_Punctuation}', "");
    Expect(0, 74879, '\p{^Is_Block=_ Cuneiform_NUMBERS_And_Punctuation}', "");
    Expect(0, 74879, '\P{Is_Block=_ Cuneiform_NUMBERS_And_Punctuation}', "");
    Expect(1, 74879, '\P{^Is_Block=_ Cuneiform_NUMBERS_And_Punctuation}', "");
    Expect(0, 74880, '\p{Is_Block=_ Cuneiform_NUMBERS_And_Punctuation}', "");
    Expect(1, 74880, '\p{^Is_Block=_ Cuneiform_NUMBERS_And_Punctuation}', "");
    Expect(1, 74880, '\P{Is_Block=_ Cuneiform_NUMBERS_And_Punctuation}', "");
    Expect(0, 74880, '\P{^Is_Block=_ Cuneiform_NUMBERS_And_Punctuation}', "");
    Error('\p{Is_Blk= CUNEIFORM_NUMBERS:=}');
    Error('\P{Is_Blk= CUNEIFORM_NUMBERS:=}');
    Expect(1, 74879, '\p{Is_Blk=cuneiformnumbers}', "");
    Expect(0, 74879, '\p{^Is_Blk=cuneiformnumbers}', "");
    Expect(0, 74879, '\P{Is_Blk=cuneiformnumbers}', "");
    Expect(1, 74879, '\P{^Is_Blk=cuneiformnumbers}', "");
    Expect(0, 74880, '\p{Is_Blk=cuneiformnumbers}', "");
    Expect(1, 74880, '\p{^Is_Blk=cuneiformnumbers}', "");
    Expect(1, 74880, '\P{Is_Blk=cuneiformnumbers}', "");
    Expect(0, 74880, '\P{^Is_Blk=cuneiformnumbers}', "");
    Expect(1, 74879, '\p{Is_Blk=		cuneiform_numbers}', "");
    Expect(0, 74879, '\p{^Is_Blk=		cuneiform_numbers}', "");
    Expect(0, 74879, '\P{Is_Blk=		cuneiform_numbers}', "");
    Expect(1, 74879, '\P{^Is_Blk=		cuneiform_numbers}', "");
    Expect(0, 74880, '\p{Is_Blk=		cuneiform_numbers}', "");
    Expect(1, 74880, '\p{^Is_Blk=		cuneiform_numbers}', "");
    Expect(1, 74880, '\P{Is_Blk=		cuneiform_numbers}', "");
    Expect(0, 74880, '\P{^Is_Blk=		cuneiform_numbers}', "");
    Error('\p{Block=		Currency_Symbols/a/}');
    Error('\P{Block=		Currency_Symbols/a/}');
    Expect(1, 8399, '\p{Block=:\ACurrency_Symbols\z:}', "");;
    Expect(0, 8400, '\p{Block=:\ACurrency_Symbols\z:}', "");;
    Expect(1, 8399, '\p{Block=currencysymbols}', "");
    Expect(0, 8399, '\p{^Block=currencysymbols}', "");
    Expect(0, 8399, '\P{Block=currencysymbols}', "");
    Expect(1, 8399, '\P{^Block=currencysymbols}', "");
    Expect(0, 8400, '\p{Block=currencysymbols}', "");
    Expect(1, 8400, '\p{^Block=currencysymbols}', "");
    Expect(1, 8400, '\P{Block=currencysymbols}', "");
    Expect(0, 8400, '\P{^Block=currencysymbols}', "");
    Expect(1, 8399, '\p{Block=:\Acurrencysymbols\z:}', "");;
    Expect(0, 8400, '\p{Block=:\Acurrencysymbols\z:}', "");;
    Expect(1, 8399, '\p{Block=Currency_Symbols}', "");
    Expect(0, 8399, '\p{^Block=Currency_Symbols}', "");
    Expect(0, 8399, '\P{Block=Currency_Symbols}', "");
    Expect(1, 8399, '\P{^Block=Currency_Symbols}', "");
    Expect(0, 8400, '\p{Block=Currency_Symbols}', "");
    Expect(1, 8400, '\p{^Block=Currency_Symbols}', "");
    Expect(1, 8400, '\P{Block=Currency_Symbols}', "");
    Expect(0, 8400, '\P{^Block=Currency_Symbols}', "");
    Error('\p{Blk=Currency_Symbols/a/}');
    Error('\P{Blk=Currency_Symbols/a/}');
    Expect(1, 8399, '\p{Blk=:\ACurrency_Symbols\z:}', "");;
    Expect(0, 8400, '\p{Blk=:\ACurrency_Symbols\z:}', "");;
    Expect(1, 8399, '\p{Blk=currencysymbols}', "");
    Expect(0, 8399, '\p{^Blk=currencysymbols}', "");
    Expect(0, 8399, '\P{Blk=currencysymbols}', "");
    Expect(1, 8399, '\P{^Blk=currencysymbols}', "");
    Expect(0, 8400, '\p{Blk=currencysymbols}', "");
    Expect(1, 8400, '\p{^Blk=currencysymbols}', "");
    Expect(1, 8400, '\P{Blk=currencysymbols}', "");
    Expect(0, 8400, '\P{^Blk=currencysymbols}', "");
    Expect(1, 8399, '\p{Blk=:\Acurrencysymbols\z:}', "");;
    Expect(0, 8400, '\p{Blk=:\Acurrencysymbols\z:}', "");;
    Expect(1, 8399, '\p{Blk:	- Currency_Symbols}', "");
    Expect(0, 8399, '\p{^Blk:	- Currency_Symbols}', "");
    Expect(0, 8399, '\P{Blk:	- Currency_Symbols}', "");
    Expect(1, 8399, '\P{^Blk:	- Currency_Symbols}', "");
    Expect(0, 8400, '\p{Blk:	- Currency_Symbols}', "");
    Expect(1, 8400, '\p{^Blk:	- Currency_Symbols}', "");
    Expect(1, 8400, '\P{Blk:	- Currency_Symbols}', "");
    Expect(0, 8400, '\P{^Blk:	- Currency_Symbols}', "");
    Error('\p{Is_Block=	_Currency_symbols/a/}');
    Error('\P{Is_Block=	_Currency_symbols/a/}');
    Expect(1, 8399, '\p{Is_Block=currencysymbols}', "");
    Expect(0, 8399, '\p{^Is_Block=currencysymbols}', "");
    Expect(0, 8399, '\P{Is_Block=currencysymbols}', "");
    Expect(1, 8399, '\P{^Is_Block=currencysymbols}', "");
    Expect(0, 8400, '\p{Is_Block=currencysymbols}', "");
    Expect(1, 8400, '\p{^Is_Block=currencysymbols}', "");
    Expect(1, 8400, '\P{Is_Block=currencysymbols}', "");
    Expect(0, 8400, '\P{^Is_Block=currencysymbols}', "");
    Expect(1, 8399, '\p{Is_Block=-	Currency_SYMBOLS}', "");
    Expect(0, 8399, '\p{^Is_Block=-	Currency_SYMBOLS}', "");
    Expect(0, 8399, '\P{Is_Block=-	Currency_SYMBOLS}', "");
    Expect(1, 8399, '\P{^Is_Block=-	Currency_SYMBOLS}', "");
    Expect(0, 8400, '\p{Is_Block=-	Currency_SYMBOLS}', "");
    Expect(1, 8400, '\p{^Is_Block=-	Currency_SYMBOLS}', "");
    Expect(1, 8400, '\P{Is_Block=-	Currency_SYMBOLS}', "");
    Expect(0, 8400, '\P{^Is_Block=-	Currency_SYMBOLS}', "");
    Error('\p{Is_Blk= currency_symbols/a/}');
    Error('\P{Is_Blk= currency_symbols/a/}');
    Expect(1, 8399, '\p{Is_Blk=currencysymbols}', "");
    Expect(0, 8399, '\p{^Is_Blk=currencysymbols}', "");
    Expect(0, 8399, '\P{Is_Blk=currencysymbols}', "");
    Expect(1, 8399, '\P{^Is_Blk=currencysymbols}', "");
    Expect(0, 8400, '\p{Is_Blk=currencysymbols}', "");
    Expect(1, 8400, '\p{^Is_Blk=currencysymbols}', "");
    Expect(1, 8400, '\P{Is_Blk=currencysymbols}', "");
    Expect(0, 8400, '\P{^Is_Blk=currencysymbols}', "");
    Expect(1, 8399, '\p{Is_Blk=	-Currency_Symbols}', "");
    Expect(0, 8399, '\p{^Is_Blk=	-Currency_Symbols}', "");
    Expect(0, 8399, '\P{Is_Blk=	-Currency_Symbols}', "");
    Expect(1, 8399, '\P{^Is_Blk=	-Currency_Symbols}', "");
    Expect(0, 8400, '\p{Is_Blk=	-Currency_Symbols}', "");
    Expect(1, 8400, '\p{^Is_Blk=	-Currency_Symbols}', "");
    Expect(1, 8400, '\P{Is_Blk=	-Currency_Symbols}', "");
    Expect(0, 8400, '\P{^Is_Blk=	-Currency_Symbols}', "");
    Error('\p{Block=  Cypriot_SYLLABARY/a/}');
    Error('\P{Block=  Cypriot_SYLLABARY/a/}');
    Expect(1, 67647, '\p{Block=:\ACypriot_Syllabary\z:}', "");;
    Expect(0, 67648, '\p{Block=:\ACypriot_Syllabary\z:}', "");;
    Expect(1, 67647, '\p{Block=cypriotsyllabary}', "");
    Expect(0, 67647, '\p{^Block=cypriotsyllabary}', "");
    Expect(0, 67647, '\P{Block=cypriotsyllabary}', "");
    Expect(1, 67647, '\P{^Block=cypriotsyllabary}', "");
    Expect(0, 67648, '\p{Block=cypriotsyllabary}', "");
    Expect(1, 67648, '\p{^Block=cypriotsyllabary}', "");
    Expect(1, 67648, '\P{Block=cypriotsyllabary}', "");
    Expect(0, 67648, '\P{^Block=cypriotsyllabary}', "");
    Expect(1, 67647, '\p{Block=:\Acypriotsyllabary\z:}', "");;
    Expect(0, 67648, '\p{Block=:\Acypriotsyllabary\z:}', "");;
    Expect(1, 67647, '\p{Block=	Cypriot_Syllabary}', "");
    Expect(0, 67647, '\p{^Block=	Cypriot_Syllabary}', "");
    Expect(0, 67647, '\P{Block=	Cypriot_Syllabary}', "");
    Expect(1, 67647, '\P{^Block=	Cypriot_Syllabary}', "");
    Expect(0, 67648, '\p{Block=	Cypriot_Syllabary}', "");
    Expect(1, 67648, '\p{^Block=	Cypriot_Syllabary}', "");
    Expect(1, 67648, '\P{Block=	Cypriot_Syllabary}', "");
    Expect(0, 67648, '\P{^Block=	Cypriot_Syllabary}', "");
    Error('\p{Blk=:=cypriot_SYLLABARY}');
    Error('\P{Blk=:=cypriot_SYLLABARY}');
    Expect(1, 67647, '\p{Blk=:\ACypriot_Syllabary\z:}', "");;
    Expect(0, 67648, '\p{Blk=:\ACypriot_Syllabary\z:}', "");;
    Expect(1, 67647, '\p{Blk=cypriotsyllabary}', "");
    Expect(0, 67647, '\p{^Blk=cypriotsyllabary}', "");
    Expect(0, 67647, '\P{Blk=cypriotsyllabary}', "");
    Expect(1, 67647, '\P{^Blk=cypriotsyllabary}', "");
    Expect(0, 67648, '\p{Blk=cypriotsyllabary}', "");
    Expect(1, 67648, '\p{^Blk=cypriotsyllabary}', "");
    Expect(1, 67648, '\P{Blk=cypriotsyllabary}', "");
    Expect(0, 67648, '\P{^Blk=cypriotsyllabary}', "");
    Expect(1, 67647, '\p{Blk=:\Acypriotsyllabary\z:}', "");;
    Expect(0, 67648, '\p{Blk=:\Acypriotsyllabary\z:}', "");;
    Expect(1, 67647, '\p{Blk=		CYPRIOT_syllabary}', "");
    Expect(0, 67647, '\p{^Blk=		CYPRIOT_syllabary}', "");
    Expect(0, 67647, '\P{Blk=		CYPRIOT_syllabary}', "");
    Expect(1, 67647, '\P{^Blk=		CYPRIOT_syllabary}', "");
    Expect(0, 67648, '\p{Blk=		CYPRIOT_syllabary}', "");
    Expect(1, 67648, '\p{^Blk=		CYPRIOT_syllabary}', "");
    Expect(1, 67648, '\P{Blk=		CYPRIOT_syllabary}', "");
    Expect(0, 67648, '\P{^Blk=		CYPRIOT_syllabary}', "");
    Error('\p{Is_Block=:= -Cypriot_Syllabary}');
    Error('\P{Is_Block=:= -Cypriot_Syllabary}');
    Expect(1, 67647, '\p{Is_Block=cypriotsyllabary}', "");
    Expect(0, 67647, '\p{^Is_Block=cypriotsyllabary}', "");
    Expect(0, 67647, '\P{Is_Block=cypriotsyllabary}', "");
    Expect(1, 67647, '\P{^Is_Block=cypriotsyllabary}', "");
    Expect(0, 67648, '\p{Is_Block=cypriotsyllabary}', "");
    Expect(1, 67648, '\p{^Is_Block=cypriotsyllabary}', "");
    Expect(1, 67648, '\P{Is_Block=cypriotsyllabary}', "");
    Expect(0, 67648, '\P{^Is_Block=cypriotsyllabary}', "");
    Expect(1, 67647, '\p{Is_Block=-Cypriot_Syllabary}', "");
    Expect(0, 67647, '\p{^Is_Block=-Cypriot_Syllabary}', "");
    Expect(0, 67647, '\P{Is_Block=-Cypriot_Syllabary}', "");
    Expect(1, 67647, '\P{^Is_Block=-Cypriot_Syllabary}', "");
    Expect(0, 67648, '\p{Is_Block=-Cypriot_Syllabary}', "");
    Expect(1, 67648, '\p{^Is_Block=-Cypriot_Syllabary}', "");
    Expect(1, 67648, '\P{Is_Block=-Cypriot_Syllabary}', "");
    Expect(0, 67648, '\P{^Is_Block=-Cypriot_Syllabary}', "");
    Error('\p{Is_Blk=/a/-cypriot_SYLLABARY}');
    Error('\P{Is_Blk=/a/-cypriot_SYLLABARY}');
    Expect(1, 67647, '\p{Is_Blk=cypriotsyllabary}', "");
    Expect(0, 67647, '\p{^Is_Blk=cypriotsyllabary}', "");
    Expect(0, 67647, '\P{Is_Blk=cypriotsyllabary}', "");
    Expect(1, 67647, '\P{^Is_Blk=cypriotsyllabary}', "");
    Expect(0, 67648, '\p{Is_Blk=cypriotsyllabary}', "");
    Expect(1, 67648, '\p{^Is_Blk=cypriotsyllabary}', "");
    Expect(1, 67648, '\P{Is_Blk=cypriotsyllabary}', "");
    Expect(0, 67648, '\P{^Is_Blk=cypriotsyllabary}', "");
    Expect(1, 67647, '\p{Is_Blk= cypriot_syllabary}', "");
    Expect(0, 67647, '\p{^Is_Blk= cypriot_syllabary}', "");
    Expect(0, 67647, '\P{Is_Blk= cypriot_syllabary}', "");
    Expect(1, 67647, '\P{^Is_Blk= cypriot_syllabary}', "");
    Expect(0, 67648, '\p{Is_Blk= cypriot_syllabary}', "");
    Expect(1, 67648, '\p{^Is_Blk= cypriot_syllabary}', "");
    Expect(1, 67648, '\P{Is_Blk= cypriot_syllabary}', "");
    Expect(0, 67648, '\P{^Is_Blk= cypriot_syllabary}', "");
    Error('\p{Block=- cypro_MINOAN:=}');
    Error('\P{Block=- cypro_MINOAN:=}');
    Expect(1, 77823, '\p{Block=:\ACypro_Minoan\z:}', "");;
    Expect(0, 77824, '\p{Block=:\ACypro_Minoan\z:}', "");;
    Expect(1, 77823, '\p{Block=cyprominoan}', "");
    Expect(0, 77823, '\p{^Block=cyprominoan}', "");
    Expect(0, 77823, '\P{Block=cyprominoan}', "");
    Expect(1, 77823, '\P{^Block=cyprominoan}', "");
    Expect(0, 77824, '\p{Block=cyprominoan}', "");
    Expect(1, 77824, '\p{^Block=cyprominoan}', "");
    Expect(1, 77824, '\P{Block=cyprominoan}', "");
    Expect(0, 77824, '\P{^Block=cyprominoan}', "");
    Expect(1, 77823, '\p{Block=:\Acyprominoan\z:}', "");;
    Expect(0, 77824, '\p{Block=:\Acyprominoan\z:}', "");;
    Expect(1, 77823, '\p{Block=_-Cypro_Minoan}', "");
    Expect(0, 77823, '\p{^Block=_-Cypro_Minoan}', "");
    Expect(0, 77823, '\P{Block=_-Cypro_Minoan}', "");
    Expect(1, 77823, '\P{^Block=_-Cypro_Minoan}', "");
    Expect(0, 77824, '\p{Block=_-Cypro_Minoan}', "");
    Expect(1, 77824, '\p{^Block=_-Cypro_Minoan}', "");
    Expect(1, 77824, '\P{Block=_-Cypro_Minoan}', "");
    Expect(0, 77824, '\P{^Block=_-Cypro_Minoan}', "");
    Error('\p{Blk= -CYPRO_Minoan:=}');
    Error('\P{Blk= -CYPRO_Minoan:=}');
    Expect(1, 77823, '\p{Blk=:\ACypro_Minoan\z:}', "");;
    Expect(0, 77824, '\p{Blk=:\ACypro_Minoan\z:}', "");;
    Expect(1, 77823, '\p{Blk=cyprominoan}', "");
    Expect(0, 77823, '\p{^Blk=cyprominoan}', "");
    Expect(0, 77823, '\P{Blk=cyprominoan}', "");
    Expect(1, 77823, '\P{^Blk=cyprominoan}', "");
    Expect(0, 77824, '\p{Blk=cyprominoan}', "");
    Expect(1, 77824, '\p{^Blk=cyprominoan}', "");
    Expect(1, 77824, '\P{Blk=cyprominoan}', "");
    Expect(0, 77824, '\P{^Blk=cyprominoan}', "");
    Expect(1, 77823, '\p{Blk=:\Acyprominoan\z:}', "");;
    Expect(0, 77824, '\p{Blk=:\Acyprominoan\z:}', "");;
    Expect(1, 77823, '\p{Blk=--Cypro_MINOAN}', "");
    Expect(0, 77823, '\p{^Blk=--Cypro_MINOAN}', "");
    Expect(0, 77823, '\P{Blk=--Cypro_MINOAN}', "");
    Expect(1, 77823, '\P{^Blk=--Cypro_MINOAN}', "");
    Expect(0, 77824, '\p{Blk=--Cypro_MINOAN}', "");
    Expect(1, 77824, '\p{^Blk=--Cypro_MINOAN}', "");
    Expect(1, 77824, '\P{Blk=--Cypro_MINOAN}', "");
    Expect(0, 77824, '\P{^Blk=--Cypro_MINOAN}', "");
    Error('\p{Is_Block=-:=cypro_Minoan}');
    Error('\P{Is_Block=-:=cypro_Minoan}');
    Expect(1, 77823, '\p{Is_Block=cyprominoan}', "");
    Expect(0, 77823, '\p{^Is_Block=cyprominoan}', "");
    Expect(0, 77823, '\P{Is_Block=cyprominoan}', "");
    Expect(1, 77823, '\P{^Is_Block=cyprominoan}', "");
    Expect(0, 77824, '\p{Is_Block=cyprominoan}', "");
    Expect(1, 77824, '\p{^Is_Block=cyprominoan}', "");
    Expect(1, 77824, '\P{Is_Block=cyprominoan}', "");
    Expect(0, 77824, '\P{^Is_Block=cyprominoan}', "");
    Expect(1, 77823, '\p{Is_Block=__cypro_MINOAN}', "");
    Expect(0, 77823, '\p{^Is_Block=__cypro_MINOAN}', "");
    Expect(0, 77823, '\P{Is_Block=__cypro_MINOAN}', "");
    Expect(1, 77823, '\P{^Is_Block=__cypro_MINOAN}', "");
    Expect(0, 77824, '\p{Is_Block=__cypro_MINOAN}', "");
    Expect(1, 77824, '\p{^Is_Block=__cypro_MINOAN}', "");
    Expect(1, 77824, '\P{Is_Block=__cypro_MINOAN}', "");
    Expect(0, 77824, '\P{^Is_Block=__cypro_MINOAN}', "");
    Error('\p{Is_Blk=	/a/Cypro_minoan}');
    Error('\P{Is_Blk=	/a/Cypro_minoan}');
    Expect(1, 77823, '\p{Is_Blk=cyprominoan}', "");
    Expect(0, 77823, '\p{^Is_Blk=cyprominoan}', "");
    Expect(0, 77823, '\P{Is_Blk=cyprominoan}', "");
    Expect(1, 77823, '\P{^Is_Blk=cyprominoan}', "");
    Expect(0, 77824, '\p{Is_Blk=cyprominoan}', "");
    Expect(1, 77824, '\p{^Is_Blk=cyprominoan}', "");
    Expect(1, 77824, '\P{Is_Blk=cyprominoan}', "");
    Expect(0, 77824, '\P{^Is_Blk=cyprominoan}', "");
    Expect(1, 77823, '\p{Is_Blk=	-Cypro_Minoan}', "");
    Expect(0, 77823, '\p{^Is_Blk=	-Cypro_Minoan}', "");
    Expect(0, 77823, '\P{Is_Blk=	-Cypro_Minoan}', "");
    Expect(1, 77823, '\P{^Is_Blk=	-Cypro_Minoan}', "");
    Expect(0, 77824, '\p{Is_Blk=	-Cypro_Minoan}', "");
    Expect(1, 77824, '\p{^Is_Blk=	-Cypro_Minoan}', "");
    Expect(1, 77824, '\P{Is_Blk=	-Cypro_Minoan}', "");
    Expect(0, 77824, '\P{^Is_Blk=	-Cypro_Minoan}', "");
    Error('\p{Block=	-cyrillic:=}');
    Error('\P{Block=	-cyrillic:=}');
    Expect(1, 1279, '\p{Block=:\ACyrillic\z:}', "");;
    Expect(0, 1280, '\p{Block=:\ACyrillic\z:}', "");;
    Expect(1, 1279, '\p{Block=cyrillic}', "");
    Expect(0, 1279, '\p{^Block=cyrillic}', "");
    Expect(0, 1279, '\P{Block=cyrillic}', "");
    Expect(1, 1279, '\P{^Block=cyrillic}', "");
    Expect(0, 1280, '\p{Block=cyrillic}', "");
    Expect(1, 1280, '\p{^Block=cyrillic}', "");
    Expect(1, 1280, '\P{Block=cyrillic}', "");
    Expect(0, 1280, '\P{^Block=cyrillic}', "");
    Expect(1, 1279, '\p{Block=:\Acyrillic\z:}', "");;
    Expect(0, 1280, '\p{Block=:\Acyrillic\z:}', "");;
    Expect(1, 1279, '\p{Block=	CYRILLIC}', "");
    Expect(0, 1279, '\p{^Block=	CYRILLIC}', "");
    Expect(0, 1279, '\P{Block=	CYRILLIC}', "");
    Expect(1, 1279, '\P{^Block=	CYRILLIC}', "");
    Expect(0, 1280, '\p{Block=	CYRILLIC}', "");
    Expect(1, 1280, '\p{^Block=	CYRILLIC}', "");
    Expect(1, 1280, '\P{Block=	CYRILLIC}', "");
    Expect(0, 1280, '\P{^Block=	CYRILLIC}', "");
    Error('\p{Blk=/a/-_cyrillic}');
    Error('\P{Blk=/a/-_cyrillic}');
    Expect(1, 1279, '\p{Blk=:\ACyrillic\z:}', "");;
    Expect(0, 1280, '\p{Blk=:\ACyrillic\z:}', "");;
    Expect(1, 1279, '\p{Blk=cyrillic}', "");
    Expect(0, 1279, '\p{^Blk=cyrillic}', "");
    Expect(0, 1279, '\P{Blk=cyrillic}', "");
    Expect(1, 1279, '\P{^Blk=cyrillic}', "");
    Expect(0, 1280, '\p{Blk=cyrillic}', "");
    Expect(1, 1280, '\p{^Blk=cyrillic}', "");
    Expect(1, 1280, '\P{Blk=cyrillic}', "");
    Expect(0, 1280, '\P{^Blk=cyrillic}', "");
    Expect(1, 1279, '\p{Blk=:\Acyrillic\z:}', "");;
    Expect(0, 1280, '\p{Blk=:\Acyrillic\z:}', "");;
    Expect(1, 1279, '\p{Blk=_ Cyrillic}', "");
    Expect(0, 1279, '\p{^Blk=_ Cyrillic}', "");
    Expect(0, 1279, '\P{Blk=_ Cyrillic}', "");
    Expect(1, 1279, '\P{^Blk=_ Cyrillic}', "");
    Expect(0, 1280, '\p{Blk=_ Cyrillic}', "");
    Expect(1, 1280, '\p{^Blk=_ Cyrillic}', "");
    Expect(1, 1280, '\P{Blk=_ Cyrillic}', "");
    Expect(0, 1280, '\P{^Blk=_ Cyrillic}', "");
    Error('\p{Is_Block:/a/	CYRILLIC}');
    Error('\P{Is_Block:/a/	CYRILLIC}');
    Expect(1, 1279, '\p{Is_Block=cyrillic}', "");
    Expect(0, 1279, '\p{^Is_Block=cyrillic}', "");
    Expect(0, 1279, '\P{Is_Block=cyrillic}', "");
    Expect(1, 1279, '\P{^Is_Block=cyrillic}', "");
    Expect(0, 1280, '\p{Is_Block=cyrillic}', "");
    Expect(1, 1280, '\p{^Is_Block=cyrillic}', "");
    Expect(1, 1280, '\P{Is_Block=cyrillic}', "");
    Expect(0, 1280, '\P{^Is_Block=cyrillic}', "");
    Expect(1, 1279, '\p{Is_Block= -Cyrillic}', "");
    Expect(0, 1279, '\p{^Is_Block= -Cyrillic}', "");
    Expect(0, 1279, '\P{Is_Block= -Cyrillic}', "");
    Expect(1, 1279, '\P{^Is_Block= -Cyrillic}', "");
    Expect(0, 1280, '\p{Is_Block= -Cyrillic}', "");
    Expect(1, 1280, '\p{^Is_Block= -Cyrillic}', "");
    Expect(1, 1280, '\P{Is_Block= -Cyrillic}', "");
    Expect(0, 1280, '\P{^Is_Block= -Cyrillic}', "");
    Error('\p{Is_Blk=_:=CYRILLIC}');
    Error('\P{Is_Blk=_:=CYRILLIC}');
    Expect(1, 1279, '\p{Is_Blk:	cyrillic}', "");
    Expect(0, 1279, '\p{^Is_Blk:	cyrillic}', "");
    Expect(0, 1279, '\P{Is_Blk:	cyrillic}', "");
    Expect(1, 1279, '\P{^Is_Blk:	cyrillic}', "");
    Expect(0, 1280, '\p{Is_Blk:	cyrillic}', "");
    Expect(1, 1280, '\p{^Is_Blk:	cyrillic}', "");
    Expect(1, 1280, '\P{Is_Blk:	cyrillic}', "");
    Expect(0, 1280, '\P{^Is_Blk:	cyrillic}', "");
    Expect(1, 1279, '\p{Is_Blk=-	cyrillic}', "");
    Expect(0, 1279, '\p{^Is_Blk=-	cyrillic}', "");
    Expect(0, 1279, '\P{Is_Blk=-	cyrillic}', "");
    Expect(1, 1279, '\P{^Is_Blk=-	cyrillic}', "");
    Expect(0, 1280, '\p{Is_Blk=-	cyrillic}', "");
    Expect(1, 1280, '\p{^Is_Blk=-	cyrillic}', "");
    Expect(1, 1280, '\P{Is_Blk=-	cyrillic}', "");
    Expect(0, 1280, '\P{^Is_Blk=-	cyrillic}', "");
    Error('\p{Block=_Cyrillic_Extended_A/a/}');
    Error('\P{Block=_Cyrillic_Extended_A/a/}');
    Expect(1, 11775, '\p{Block=:\ACyrillic_Extended_A\z:}', "");;
    Expect(0, 11776, '\p{Block=:\ACyrillic_Extended_A\z:}', "");;
    Expect(1, 11775, '\p{Block=cyrillicextendeda}', "");
    Expect(0, 11775, '\p{^Block=cyrillicextendeda}', "");
    Expect(0, 11775, '\P{Block=cyrillicextendeda}', "");
    Expect(1, 11775, '\P{^Block=cyrillicextendeda}', "");
    Expect(0, 11776, '\p{Block=cyrillicextendeda}', "");
    Expect(1, 11776, '\p{^Block=cyrillicextendeda}', "");
    Expect(1, 11776, '\P{Block=cyrillicextendeda}', "");
    Expect(0, 11776, '\P{^Block=cyrillicextendeda}', "");
    Expect(1, 11775, '\p{Block=:\Acyrillicextendeda\z:}', "");;
    Expect(0, 11776, '\p{Block=:\Acyrillicextendeda\z:}', "");;
    Expect(1, 11775, '\p{Block=-Cyrillic_Extended_A}', "");
    Expect(0, 11775, '\p{^Block=-Cyrillic_Extended_A}', "");
    Expect(0, 11775, '\P{Block=-Cyrillic_Extended_A}', "");
    Expect(1, 11775, '\P{^Block=-Cyrillic_Extended_A}', "");
    Expect(0, 11776, '\p{Block=-Cyrillic_Extended_A}', "");
    Expect(1, 11776, '\p{^Block=-Cyrillic_Extended_A}', "");
    Expect(1, 11776, '\P{Block=-Cyrillic_Extended_A}', "");
    Expect(0, 11776, '\P{^Block=-Cyrillic_Extended_A}', "");
    Error('\p{Blk:   _/a/CYRILLIC_ext_A}');
    Error('\P{Blk:   _/a/CYRILLIC_ext_A}');
    Expect(1, 11775, '\p{Blk=:\ACyrillic_Ext_A\z:}', "");;
    Expect(0, 11776, '\p{Blk=:\ACyrillic_Ext_A\z:}', "");;
    Expect(1, 11775, '\p{Blk=cyrillicexta}', "");
    Expect(0, 11775, '\p{^Blk=cyrillicexta}', "");
    Expect(0, 11775, '\P{Blk=cyrillicexta}', "");
    Expect(1, 11775, '\P{^Blk=cyrillicexta}', "");
    Expect(0, 11776, '\p{Blk=cyrillicexta}', "");
    Expect(1, 11776, '\p{^Blk=cyrillicexta}', "");
    Expect(1, 11776, '\P{Blk=cyrillicexta}', "");
    Expect(0, 11776, '\P{^Blk=cyrillicexta}', "");
    Expect(1, 11775, '\p{Blk=:\Acyrillicexta\z:}', "");;
    Expect(0, 11776, '\p{Blk=:\Acyrillicexta\z:}', "");;
    Expect(1, 11775, '\p{Blk=_CYRILLIC_ext_A}', "");
    Expect(0, 11775, '\p{^Blk=_CYRILLIC_ext_A}', "");
    Expect(0, 11775, '\P{Blk=_CYRILLIC_ext_A}', "");
    Expect(1, 11775, '\P{^Blk=_CYRILLIC_ext_A}', "");
    Expect(0, 11776, '\p{Blk=_CYRILLIC_ext_A}', "");
    Expect(1, 11776, '\p{^Blk=_CYRILLIC_ext_A}', "");
    Expect(1, 11776, '\P{Blk=_CYRILLIC_ext_A}', "");
    Expect(0, 11776, '\P{^Blk=_CYRILLIC_ext_A}', "");
    Error('\p{Is_Block= cyrillic_Extended_A:=}');
    Error('\P{Is_Block= cyrillic_Extended_A:=}');
    Expect(1, 11775, '\p{Is_Block=cyrillicextendeda}', "");
    Expect(0, 11775, '\p{^Is_Block=cyrillicextendeda}', "");
    Expect(0, 11775, '\P{Is_Block=cyrillicextendeda}', "");
    Expect(1, 11775, '\P{^Is_Block=cyrillicextendeda}', "");
    Expect(0, 11776, '\p{Is_Block=cyrillicextendeda}', "");
    Expect(1, 11776, '\p{^Is_Block=cyrillicextendeda}', "");
    Expect(1, 11776, '\P{Is_Block=cyrillicextendeda}', "");
    Expect(0, 11776, '\P{^Is_Block=cyrillicextendeda}', "");
    Expect(1, 11775, '\p{Is_Block=  Cyrillic_Extended_A}', "");
    Expect(0, 11775, '\p{^Is_Block=  Cyrillic_Extended_A}', "");
    Expect(0, 11775, '\P{Is_Block=  Cyrillic_Extended_A}', "");
    Expect(1, 11775, '\P{^Is_Block=  Cyrillic_Extended_A}', "");
    Expect(0, 11776, '\p{Is_Block=  Cyrillic_Extended_A}', "");
    Expect(1, 11776, '\p{^Is_Block=  Cyrillic_Extended_A}', "");
    Expect(1, 11776, '\P{Is_Block=  Cyrillic_Extended_A}', "");
    Expect(0, 11776, '\P{^Is_Block=  Cyrillic_Extended_A}', "");
    Error('\p{Is_Blk=/a/		cyrillic_Ext_A}');
    Error('\P{Is_Blk=/a/		cyrillic_Ext_A}');
    Expect(1, 11775, '\p{Is_Blk=cyrillicexta}', "");
    Expect(0, 11775, '\p{^Is_Blk=cyrillicexta}', "");
    Expect(0, 11775, '\P{Is_Blk=cyrillicexta}', "");
    Expect(1, 11775, '\P{^Is_Blk=cyrillicexta}', "");
    Expect(0, 11776, '\p{Is_Blk=cyrillicexta}', "");
    Expect(1, 11776, '\p{^Is_Blk=cyrillicexta}', "");
    Expect(1, 11776, '\P{Is_Blk=cyrillicexta}', "");
    Expect(0, 11776, '\P{^Is_Blk=cyrillicexta}', "");
    Expect(1, 11775, '\p{Is_Blk=	 CYRILLIC_ext_A}', "");
    Expect(0, 11775, '\p{^Is_Blk=	 CYRILLIC_ext_A}', "");
    Expect(0, 11775, '\P{Is_Blk=	 CYRILLIC_ext_A}', "");
    Expect(1, 11775, '\P{^Is_Blk=	 CYRILLIC_ext_A}', "");
    Expect(0, 11776, '\p{Is_Blk=	 CYRILLIC_ext_A}', "");
    Expect(1, 11776, '\p{^Is_Blk=	 CYRILLIC_ext_A}', "");
    Expect(1, 11776, '\P{Is_Blk=	 CYRILLIC_ext_A}', "");
    Expect(0, 11776, '\P{^Is_Blk=	 CYRILLIC_ext_A}', "");
    Error('\p{Block=_:=cyrillic_extended_B}');
    Error('\P{Block=_:=cyrillic_extended_B}');
    Expect(1, 42655, '\p{Block=:\ACyrillic_Extended_B\z:}', "");;
    Expect(0, 42656, '\p{Block=:\ACyrillic_Extended_B\z:}', "");;
    Expect(1, 42655, '\p{Block:cyrillicextendedb}', "");
    Expect(0, 42655, '\p{^Block:cyrillicextendedb}', "");
    Expect(0, 42655, '\P{Block:cyrillicextendedb}', "");
    Expect(1, 42655, '\P{^Block:cyrillicextendedb}', "");
    Expect(0, 42656, '\p{Block:cyrillicextendedb}', "");
    Expect(1, 42656, '\p{^Block:cyrillicextendedb}', "");
    Expect(1, 42656, '\P{Block:cyrillicextendedb}', "");
    Expect(0, 42656, '\P{^Block:cyrillicextendedb}', "");
    Expect(1, 42655, '\p{Block=:\Acyrillicextendedb\z:}', "");;
    Expect(0, 42656, '\p{Block=:\Acyrillicextendedb\z:}', "");;
    Expect(1, 42655, '\p{Block=	 CYRILLIC_EXTENDED_B}', "");
    Expect(0, 42655, '\p{^Block=	 CYRILLIC_EXTENDED_B}', "");
    Expect(0, 42655, '\P{Block=	 CYRILLIC_EXTENDED_B}', "");
    Expect(1, 42655, '\P{^Block=	 CYRILLIC_EXTENDED_B}', "");
    Expect(0, 42656, '\p{Block=	 CYRILLIC_EXTENDED_B}', "");
    Expect(1, 42656, '\p{^Block=	 CYRILLIC_EXTENDED_B}', "");
    Expect(1, 42656, '\P{Block=	 CYRILLIC_EXTENDED_B}', "");
    Expect(0, 42656, '\P{^Block=	 CYRILLIC_EXTENDED_B}', "");
    Error('\p{Blk=/a/ 	CYRILLIC_EXT_B}');
    Error('\P{Blk=/a/ 	CYRILLIC_EXT_B}');
    Expect(1, 42655, '\p{Blk=:\ACyrillic_Ext_B\z:}', "");;
    Expect(0, 42656, '\p{Blk=:\ACyrillic_Ext_B\z:}', "");;
    Expect(1, 42655, '\p{Blk=cyrillicextb}', "");
    Expect(0, 42655, '\p{^Blk=cyrillicextb}', "");
    Expect(0, 42655, '\P{Blk=cyrillicextb}', "");
    Expect(1, 42655, '\P{^Blk=cyrillicextb}', "");
    Expect(0, 42656, '\p{Blk=cyrillicextb}', "");
    Expect(1, 42656, '\p{^Blk=cyrillicextb}', "");
    Expect(1, 42656, '\P{Blk=cyrillicextb}', "");
    Expect(0, 42656, '\P{^Blk=cyrillicextb}', "");
    Expect(1, 42655, '\p{Blk=:\Acyrillicextb\z:}', "");;
    Expect(0, 42656, '\p{Blk=:\Acyrillicextb\z:}', "");;
    Expect(1, 42655, '\p{Blk= -Cyrillic_EXT_B}', "");
    Expect(0, 42655, '\p{^Blk= -Cyrillic_EXT_B}', "");
    Expect(0, 42655, '\P{Blk= -Cyrillic_EXT_B}', "");
    Expect(1, 42655, '\P{^Blk= -Cyrillic_EXT_B}', "");
    Expect(0, 42656, '\p{Blk= -Cyrillic_EXT_B}', "");
    Expect(1, 42656, '\p{^Blk= -Cyrillic_EXT_B}', "");
    Expect(1, 42656, '\P{Blk= -Cyrillic_EXT_B}', "");
    Expect(0, 42656, '\P{^Blk= -Cyrillic_EXT_B}', "");
    Error('\p{Is_Block=_:=Cyrillic_Extended_b}');
    Error('\P{Is_Block=_:=Cyrillic_Extended_b}');
    Expect(1, 42655, '\p{Is_Block=cyrillicextendedb}', "");
    Expect(0, 42655, '\p{^Is_Block=cyrillicextendedb}', "");
    Expect(0, 42655, '\P{Is_Block=cyrillicextendedb}', "");
    Expect(1, 42655, '\P{^Is_Block=cyrillicextendedb}', "");
    Expect(0, 42656, '\p{Is_Block=cyrillicextendedb}', "");
    Expect(1, 42656, '\p{^Is_Block=cyrillicextendedb}', "");
    Expect(1, 42656, '\P{Is_Block=cyrillicextendedb}', "");
    Expect(0, 42656, '\P{^Is_Block=cyrillicextendedb}', "");
    Expect(1, 42655, '\p{Is_Block=-Cyrillic_Extended_B}', "");
    Expect(0, 42655, '\p{^Is_Block=-Cyrillic_Extended_B}', "");
    Expect(0, 42655, '\P{Is_Block=-Cyrillic_Extended_B}', "");
    Expect(1, 42655, '\P{^Is_Block=-Cyrillic_Extended_B}', "");
    Expect(0, 42656, '\p{Is_Block=-Cyrillic_Extended_B}', "");
    Expect(1, 42656, '\p{^Is_Block=-Cyrillic_Extended_B}', "");
    Expect(1, 42656, '\P{Is_Block=-Cyrillic_Extended_B}', "");
    Expect(0, 42656, '\P{^Is_Block=-Cyrillic_Extended_B}', "");
    Error('\p{Is_Blk=-:=Cyrillic_EXT_b}');
    Error('\P{Is_Blk=-:=Cyrillic_EXT_b}');
    Expect(1, 42655, '\p{Is_Blk=cyrillicextb}', "");
    Expect(0, 42655, '\p{^Is_Blk=cyrillicextb}', "");
    Expect(0, 42655, '\P{Is_Blk=cyrillicextb}', "");
    Expect(1, 42655, '\P{^Is_Blk=cyrillicextb}', "");
    Expect(0, 42656, '\p{Is_Blk=cyrillicextb}', "");
    Expect(1, 42656, '\p{^Is_Blk=cyrillicextb}', "");
    Expect(1, 42656, '\P{Is_Blk=cyrillicextb}', "");
    Expect(0, 42656, '\P{^Is_Blk=cyrillicextb}', "");
    Expect(1, 42655, '\p{Is_Blk=	-CYRILLIC_EXT_B}', "");
    Expect(0, 42655, '\p{^Is_Blk=	-CYRILLIC_EXT_B}', "");
    Expect(0, 42655, '\P{Is_Blk=	-CYRILLIC_EXT_B}', "");
    Expect(1, 42655, '\P{^Is_Blk=	-CYRILLIC_EXT_B}', "");
    Expect(0, 42656, '\p{Is_Blk=	-CYRILLIC_EXT_B}', "");
    Expect(1, 42656, '\p{^Is_Blk=	-CYRILLIC_EXT_B}', "");
    Expect(1, 42656, '\P{Is_Blk=	-CYRILLIC_EXT_B}', "");
    Expect(0, 42656, '\P{^Is_Blk=	-CYRILLIC_EXT_B}', "");
    Error('\p{Block= -cyrillic_Extended_c/a/}');
    Error('\P{Block= -cyrillic_Extended_c/a/}');
    Expect(1, 7311, '\p{Block=:\ACyrillic_Extended_C\z:}', "");;
    Expect(0, 7312, '\p{Block=:\ACyrillic_Extended_C\z:}', "");;
    Expect(1, 7311, '\p{Block=cyrillicextendedc}', "");
    Expect(0, 7311, '\p{^Block=cyrillicextendedc}', "");
    Expect(0, 7311, '\P{Block=cyrillicextendedc}', "");
    Expect(1, 7311, '\P{^Block=cyrillicextendedc}', "");
    Expect(0, 7312, '\p{Block=cyrillicextendedc}', "");
    Expect(1, 7312, '\p{^Block=cyrillicextendedc}', "");
    Expect(1, 7312, '\P{Block=cyrillicextendedc}', "");
    Expect(0, 7312, '\P{^Block=cyrillicextendedc}', "");
    Expect(1, 7311, '\p{Block=:\Acyrillicextendedc\z:}', "");;
    Expect(0, 7312, '\p{Block=:\Acyrillicextendedc\z:}', "");;
    Expect(1, 7311, '\p{Block=__Cyrillic_Extended_C}', "");
    Expect(0, 7311, '\p{^Block=__Cyrillic_Extended_C}', "");
    Expect(0, 7311, '\P{Block=__Cyrillic_Extended_C}', "");
    Expect(1, 7311, '\P{^Block=__Cyrillic_Extended_C}', "");
    Expect(0, 7312, '\p{Block=__Cyrillic_Extended_C}', "");
    Expect(1, 7312, '\p{^Block=__Cyrillic_Extended_C}', "");
    Expect(1, 7312, '\P{Block=__Cyrillic_Extended_C}', "");
    Expect(0, 7312, '\P{^Block=__Cyrillic_Extended_C}', "");
    Error('\p{Blk= 	Cyrillic_EXT_c/a/}');
    Error('\P{Blk= 	Cyrillic_EXT_c/a/}');
    Expect(1, 7311, '\p{Blk=:\ACyrillic_Ext_C\z:}', "");;
    Expect(0, 7312, '\p{Blk=:\ACyrillic_Ext_C\z:}', "");;
    Expect(1, 7311, '\p{Blk=cyrillicextc}', "");
    Expect(0, 7311, '\p{^Blk=cyrillicextc}', "");
    Expect(0, 7311, '\P{Blk=cyrillicextc}', "");
    Expect(1, 7311, '\P{^Blk=cyrillicextc}', "");
    Expect(0, 7312, '\p{Blk=cyrillicextc}', "");
    Expect(1, 7312, '\p{^Blk=cyrillicextc}', "");
    Expect(1, 7312, '\P{Blk=cyrillicextc}', "");
    Expect(0, 7312, '\P{^Blk=cyrillicextc}', "");
    Expect(1, 7311, '\p{Blk=:\Acyrillicextc\z:}', "");;
    Expect(0, 7312, '\p{Blk=:\Acyrillicextc\z:}', "");;
    Expect(1, 7311, '\p{Blk=	-Cyrillic_Ext_C}', "");
    Expect(0, 7311, '\p{^Blk=	-Cyrillic_Ext_C}', "");
    Expect(0, 7311, '\P{Blk=	-Cyrillic_Ext_C}', "");
    Expect(1, 7311, '\P{^Blk=	-Cyrillic_Ext_C}', "");
    Expect(0, 7312, '\p{Blk=	-Cyrillic_Ext_C}', "");
    Expect(1, 7312, '\p{^Blk=	-Cyrillic_Ext_C}', "");
    Expect(1, 7312, '\P{Blk=	-Cyrillic_Ext_C}', "");
    Expect(0, 7312, '\P{^Blk=	-Cyrillic_Ext_C}', "");
    Error('\p{Is_Block=/a/__CYRILLIC_extended_C}');
    Error('\P{Is_Block=/a/__CYRILLIC_extended_C}');
    Expect(1, 7311, '\p{Is_Block=cyrillicextendedc}', "");
    Expect(0, 7311, '\p{^Is_Block=cyrillicextendedc}', "");
    Expect(0, 7311, '\P{Is_Block=cyrillicextendedc}', "");
    Expect(1, 7311, '\P{^Is_Block=cyrillicextendedc}', "");
    Expect(0, 7312, '\p{Is_Block=cyrillicextendedc}', "");
    Expect(1, 7312, '\p{^Is_Block=cyrillicextendedc}', "");
    Expect(1, 7312, '\P{Is_Block=cyrillicextendedc}', "");
    Expect(0, 7312, '\P{^Is_Block=cyrillicextendedc}', "");
    Expect(1, 7311, '\p{Is_Block=-cyrillic_Extended_C}', "");
    Expect(0, 7311, '\p{^Is_Block=-cyrillic_Extended_C}', "");
    Expect(0, 7311, '\P{Is_Block=-cyrillic_Extended_C}', "");
    Expect(1, 7311, '\P{^Is_Block=-cyrillic_Extended_C}', "");
    Expect(0, 7312, '\p{Is_Block=-cyrillic_Extended_C}', "");
    Expect(1, 7312, '\p{^Is_Block=-cyrillic_Extended_C}', "");
    Expect(1, 7312, '\P{Is_Block=-cyrillic_Extended_C}', "");
    Expect(0, 7312, '\P{^Is_Block=-cyrillic_Extended_C}', "");
    Error('\p{Is_Blk= -cyrillic_ext_C/a/}');
    Error('\P{Is_Blk= -cyrillic_ext_C/a/}');
    Expect(1, 7311, '\p{Is_Blk=cyrillicextc}', "");
    Expect(0, 7311, '\p{^Is_Blk=cyrillicextc}', "");
    Expect(0, 7311, '\P{Is_Blk=cyrillicextc}', "");
    Expect(1, 7311, '\P{^Is_Blk=cyrillicextc}', "");
    Expect(0, 7312, '\p{Is_Blk=cyrillicextc}', "");
    Expect(1, 7312, '\p{^Is_Blk=cyrillicextc}', "");
    Expect(1, 7312, '\P{Is_Blk=cyrillicextc}', "");
    Expect(0, 7312, '\P{^Is_Blk=cyrillicextc}', "");
    Expect(1, 7311, '\p{Is_Blk=_-CYRILLIC_Ext_C}', "");
    Expect(0, 7311, '\p{^Is_Blk=_-CYRILLIC_Ext_C}', "");
    Expect(0, 7311, '\P{Is_Blk=_-CYRILLIC_Ext_C}', "");
    Expect(1, 7311, '\P{^Is_Blk=_-CYRILLIC_Ext_C}', "");
    Expect(0, 7312, '\p{Is_Blk=_-CYRILLIC_Ext_C}', "");
    Expect(1, 7312, '\p{^Is_Blk=_-CYRILLIC_Ext_C}', "");
    Expect(1, 7312, '\P{Is_Blk=_-CYRILLIC_Ext_C}', "");
    Expect(0, 7312, '\P{^Is_Blk=_-CYRILLIC_Ext_C}', "");
    Error('\p{Block=:=CYRILLIC_extended_D}');
    Error('\P{Block=:=CYRILLIC_extended_D}');
    Expect(1, 123023, '\p{Block=:\ACyrillic_Extended_D\z:}', "");;
    Expect(0, 123024, '\p{Block=:\ACyrillic_Extended_D\z:}', "");;
    Expect(1, 123023, '\p{Block=cyrillicextendedd}', "");
    Expect(0, 123023, '\p{^Block=cyrillicextendedd}', "");
    Expect(0, 123023, '\P{Block=cyrillicextendedd}', "");
    Expect(1, 123023, '\P{^Block=cyrillicextendedd}', "");
    Expect(0, 123024, '\p{Block=cyrillicextendedd}', "");
    Expect(1, 123024, '\p{^Block=cyrillicextendedd}', "");
    Expect(1, 123024, '\P{Block=cyrillicextendedd}', "");
    Expect(0, 123024, '\P{^Block=cyrillicextendedd}', "");
    Expect(1, 123023, '\p{Block=:\Acyrillicextendedd\z:}', "");;
    Expect(0, 123024, '\p{Block=:\Acyrillicextendedd\z:}', "");;
    Expect(1, 123023, '\p{Block=-Cyrillic_Extended_D}', "");
    Expect(0, 123023, '\p{^Block=-Cyrillic_Extended_D}', "");
    Expect(0, 123023, '\P{Block=-Cyrillic_Extended_D}', "");
    Expect(1, 123023, '\P{^Block=-Cyrillic_Extended_D}', "");
    Expect(0, 123024, '\p{Block=-Cyrillic_Extended_D}', "");
    Expect(1, 123024, '\p{^Block=-Cyrillic_Extended_D}', "");
    Expect(1, 123024, '\P{Block=-Cyrillic_Extended_D}', "");
    Expect(0, 123024, '\P{^Block=-Cyrillic_Extended_D}', "");
    Error('\p{Blk=:=CYRILLIC_ext_D}');
    Error('\P{Blk=:=CYRILLIC_ext_D}');
    Expect(1, 123023, '\p{Blk=:\ACyrillic_Ext_D\z:}', "");;
    Expect(0, 123024, '\p{Blk=:\ACyrillic_Ext_D\z:}', "");;
    Expect(1, 123023, '\p{Blk=cyrillicextd}', "");
    Expect(0, 123023, '\p{^Blk=cyrillicextd}', "");
    Expect(0, 123023, '\P{Blk=cyrillicextd}', "");
    Expect(1, 123023, '\P{^Blk=cyrillicextd}', "");
    Expect(0, 123024, '\p{Blk=cyrillicextd}', "");
    Expect(1, 123024, '\p{^Blk=cyrillicextd}', "");
    Expect(1, 123024, '\P{Blk=cyrillicextd}', "");
    Expect(0, 123024, '\P{^Blk=cyrillicextd}', "");
    Expect(1, 123023, '\p{Blk=:\Acyrillicextd\z:}', "");;
    Expect(0, 123024, '\p{Blk=:\Acyrillicextd\z:}', "");;
    Expect(1, 123023, '\p{Blk=  CYRILLIC_EXT_D}', "");
    Expect(0, 123023, '\p{^Blk=  CYRILLIC_EXT_D}', "");
    Expect(0, 123023, '\P{Blk=  CYRILLIC_EXT_D}', "");
    Expect(1, 123023, '\P{^Blk=  CYRILLIC_EXT_D}', "");
    Expect(0, 123024, '\p{Blk=  CYRILLIC_EXT_D}', "");
    Expect(1, 123024, '\p{^Blk=  CYRILLIC_EXT_D}', "");
    Expect(1, 123024, '\P{Blk=  CYRILLIC_EXT_D}', "");
    Expect(0, 123024, '\P{^Blk=  CYRILLIC_EXT_D}', "");
    Error('\p{Is_Block=_/a/Cyrillic_Extended_D}');
    Error('\P{Is_Block=_/a/Cyrillic_Extended_D}');
    Expect(1, 123023, '\p{Is_Block=cyrillicextendedd}', "");
    Expect(0, 123023, '\p{^Is_Block=cyrillicextendedd}', "");
    Expect(0, 123023, '\P{Is_Block=cyrillicextendedd}', "");
    Expect(1, 123023, '\P{^Is_Block=cyrillicextendedd}', "");
    Expect(0, 123024, '\p{Is_Block=cyrillicextendedd}', "");
    Expect(1, 123024, '\p{^Is_Block=cyrillicextendedd}', "");
    Expect(1, 123024, '\P{Is_Block=cyrillicextendedd}', "");
    Expect(0, 123024, '\P{^Is_Block=cyrillicextendedd}', "");
    Expect(1, 123023, '\p{Is_Block= cyrillic_EXTENDED_D}', "");
    Expect(0, 123023, '\p{^Is_Block= cyrillic_EXTENDED_D}', "");
    Expect(0, 123023, '\P{Is_Block= cyrillic_EXTENDED_D}', "");
    Expect(1, 123023, '\P{^Is_Block= cyrillic_EXTENDED_D}', "");
    Expect(0, 123024, '\p{Is_Block= cyrillic_EXTENDED_D}', "");
    Expect(1, 123024, '\p{^Is_Block= cyrillic_EXTENDED_D}', "");
    Expect(1, 123024, '\P{Is_Block= cyrillic_EXTENDED_D}', "");
    Expect(0, 123024, '\P{^Is_Block= cyrillic_EXTENDED_D}', "");
    Error('\p{Is_Blk= :=CYRILLIC_Ext_d}');
    Error('\P{Is_Blk= :=CYRILLIC_Ext_d}');
    Expect(1, 123023, '\p{Is_Blk=cyrillicextd}', "");
    Expect(0, 123023, '\p{^Is_Blk=cyrillicextd}', "");
    Expect(0, 123023, '\P{Is_Blk=cyrillicextd}', "");
    Expect(1, 123023, '\P{^Is_Blk=cyrillicextd}', "");
    Expect(0, 123024, '\p{Is_Blk=cyrillicextd}', "");
    Expect(1, 123024, '\p{^Is_Blk=cyrillicextd}', "");
    Expect(1, 123024, '\P{Is_Blk=cyrillicextd}', "");
    Expect(0, 123024, '\P{^Is_Blk=cyrillicextd}', "");
    Expect(1, 123023, '\p{Is_Blk=	cyrillic_EXT_D}', "");
    Expect(0, 123023, '\p{^Is_Blk=	cyrillic_EXT_D}', "");
    Expect(0, 123023, '\P{Is_Blk=	cyrillic_EXT_D}', "");
    Expect(1, 123023, '\P{^Is_Blk=	cyrillic_EXT_D}', "");
    Expect(0, 123024, '\p{Is_Blk=	cyrillic_EXT_D}', "");
    Expect(1, 123024, '\p{^Is_Blk=	cyrillic_EXT_D}', "");
    Expect(1, 123024, '\P{Is_Blk=	cyrillic_EXT_D}', "");
    Expect(0, 123024, '\P{^Is_Blk=	cyrillic_EXT_D}', "");
    Error('\p{Block=_ cyrillic_Supplement:=}');
    Error('\P{Block=_ cyrillic_Supplement:=}');
    Expect(1, 1327, '\p{Block=:\ACyrillic_Supplement\z:}', "");;
    Expect(0, 1328, '\p{Block=:\ACyrillic_Supplement\z:}', "");;
    Expect(1, 1327, '\p{Block=cyrillicsupplement}', "");
    Expect(0, 1327, '\p{^Block=cyrillicsupplement}', "");
    Expect(0, 1327, '\P{Block=cyrillicsupplement}', "");
    Expect(1, 1327, '\P{^Block=cyrillicsupplement}', "");
    Expect(0, 1328, '\p{Block=cyrillicsupplement}', "");
    Expect(1, 1328, '\p{^Block=cyrillicsupplement}', "");
    Expect(1, 1328, '\P{Block=cyrillicsupplement}', "");
    Expect(0, 1328, '\P{^Block=cyrillicsupplement}', "");
    Expect(1, 1327, '\p{Block=:\Acyrillicsupplement\z:}', "");;
    Expect(0, 1328, '\p{Block=:\Acyrillicsupplement\z:}', "");;
    Expect(1, 1327, '\p{Block:    Cyrillic_Supplement}', "");
    Expect(0, 1327, '\p{^Block:    Cyrillic_Supplement}', "");
    Expect(0, 1327, '\P{Block:    Cyrillic_Supplement}', "");
    Expect(1, 1327, '\P{^Block:    Cyrillic_Supplement}', "");
    Expect(0, 1328, '\p{Block:    Cyrillic_Supplement}', "");
    Expect(1, 1328, '\p{^Block:    Cyrillic_Supplement}', "");
    Expect(1, 1328, '\P{Block:    Cyrillic_Supplement}', "");
    Expect(0, 1328, '\P{^Block:    Cyrillic_Supplement}', "");
    Error('\p{Blk: /a/cyrillic_sup}');
    Error('\P{Blk: /a/cyrillic_sup}');
    Expect(1, 1327, '\p{Blk=:\ACyrillic_Sup\z:}', "");;
    Expect(0, 1328, '\p{Blk=:\ACyrillic_Sup\z:}', "");;
    Expect(1, 1327, '\p{Blk:   cyrillicsup}', "");
    Expect(0, 1327, '\p{^Blk:   cyrillicsup}', "");
    Expect(0, 1327, '\P{Blk:   cyrillicsup}', "");
    Expect(1, 1327, '\P{^Blk:   cyrillicsup}', "");
    Expect(0, 1328, '\p{Blk:   cyrillicsup}', "");
    Expect(1, 1328, '\p{^Blk:   cyrillicsup}', "");
    Expect(1, 1328, '\P{Blk:   cyrillicsup}', "");
    Expect(0, 1328, '\P{^Blk:   cyrillicsup}', "");
    Expect(1, 1327, '\p{Blk=:\Acyrillicsup\z:}', "");;
    Expect(0, 1328, '\p{Blk=:\Acyrillicsup\z:}', "");;
    Expect(1, 1327, '\p{Blk:-cyrillic_sup}', "");
    Expect(0, 1327, '\p{^Blk:-cyrillic_sup}', "");
    Expect(0, 1327, '\P{Blk:-cyrillic_sup}', "");
    Expect(1, 1327, '\P{^Blk:-cyrillic_sup}', "");
    Expect(0, 1328, '\p{Blk:-cyrillic_sup}', "");
    Expect(1, 1328, '\p{^Blk:-cyrillic_sup}', "");
    Expect(1, 1328, '\P{Blk:-cyrillic_sup}', "");
    Expect(0, 1328, '\P{^Blk:-cyrillic_sup}', "");
    Error('\p{Is_Block=_/a/Cyrillic_Supplementary}');
    Error('\P{Is_Block=_/a/Cyrillic_Supplementary}');
    Expect(1, 1327, '\p{Is_Block=cyrillicsupplementary}', "");
    Expect(0, 1327, '\p{^Is_Block=cyrillicsupplementary}', "");
    Expect(0, 1327, '\P{Is_Block=cyrillicsupplementary}', "");
    Expect(1, 1327, '\P{^Is_Block=cyrillicsupplementary}', "");
    Expect(0, 1328, '\p{Is_Block=cyrillicsupplementary}', "");
    Expect(1, 1328, '\p{^Is_Block=cyrillicsupplementary}', "");
    Expect(1, 1328, '\P{Is_Block=cyrillicsupplementary}', "");
    Expect(0, 1328, '\P{^Is_Block=cyrillicsupplementary}', "");
    Expect(1, 1327, '\p{Is_Block=		Cyrillic_Supplementary}', "");
    Expect(0, 1327, '\p{^Is_Block=		Cyrillic_Supplementary}', "");
    Expect(0, 1327, '\P{Is_Block=		Cyrillic_Supplementary}', "");
    Expect(1, 1327, '\P{^Is_Block=		Cyrillic_Supplementary}', "");
    Expect(0, 1328, '\p{Is_Block=		Cyrillic_Supplementary}', "");
    Expect(1, 1328, '\p{^Is_Block=		Cyrillic_Supplementary}', "");
    Expect(1, 1328, '\P{Is_Block=		Cyrillic_Supplementary}', "");
    Expect(0, 1328, '\P{^Is_Block=		Cyrillic_Supplementary}', "");
    Error('\p{Is_Blk=:= Cyrillic_supplement}');
    Error('\P{Is_Blk=:= Cyrillic_supplement}');
    Expect(1, 1327, '\p{Is_Blk=cyrillicsupplement}', "");
    Expect(0, 1327, '\p{^Is_Blk=cyrillicsupplement}', "");
    Expect(0, 1327, '\P{Is_Blk=cyrillicsupplement}', "");
    Expect(1, 1327, '\P{^Is_Blk=cyrillicsupplement}', "");
    Expect(0, 1328, '\p{Is_Blk=cyrillicsupplement}', "");
    Expect(1, 1328, '\p{^Is_Blk=cyrillicsupplement}', "");
    Expect(1, 1328, '\P{Is_Blk=cyrillicsupplement}', "");
    Expect(0, 1328, '\P{^Is_Blk=cyrillicsupplement}', "");
    Expect(1, 1327, '\p{Is_Blk=	-Cyrillic_Supplement}', "");
    Expect(0, 1327, '\p{^Is_Blk=	-Cyrillic_Supplement}', "");
    Expect(0, 1327, '\P{Is_Blk=	-Cyrillic_Supplement}', "");
    Expect(1, 1327, '\P{^Is_Blk=	-Cyrillic_Supplement}', "");
    Expect(0, 1328, '\p{Is_Blk=	-Cyrillic_Supplement}', "");
    Expect(1, 1328, '\p{^Is_Blk=	-Cyrillic_Supplement}', "");
    Expect(1, 1328, '\P{Is_Blk=	-Cyrillic_Supplement}', "");
    Expect(0, 1328, '\P{^Is_Blk=	-Cyrillic_Supplement}', "");
    Error('\p{Block= /a/Deseret}');
    Error('\P{Block= /a/Deseret}');
    Expect(1, 66639, '\p{Block=:\ADeseret\z:}', "");;
    Expect(0, 66640, '\p{Block=:\ADeseret\z:}', "");;
    Expect(1, 66639, '\p{Block=deseret}', "");
    Expect(0, 66639, '\p{^Block=deseret}', "");
    Expect(0, 66639, '\P{Block=deseret}', "");
    Expect(1, 66639, '\P{^Block=deseret}', "");
    Expect(0, 66640, '\p{Block=deseret}', "");
    Expect(1, 66640, '\p{^Block=deseret}', "");
    Expect(1, 66640, '\P{Block=deseret}', "");
    Expect(0, 66640, '\P{^Block=deseret}', "");
    Expect(1, 66639, '\p{Block=:\Adeseret\z:}', "");;
    Expect(0, 66640, '\p{Block=:\Adeseret\z:}', "");;
    Expect(1, 66639, '\p{Block=  Deseret}', "");
    Expect(0, 66639, '\p{^Block=  Deseret}', "");
    Expect(0, 66639, '\P{Block=  Deseret}', "");
    Expect(1, 66639, '\P{^Block=  Deseret}', "");
    Expect(0, 66640, '\p{Block=  Deseret}', "");
    Expect(1, 66640, '\p{^Block=  Deseret}', "");
    Expect(1, 66640, '\P{Block=  Deseret}', "");
    Expect(0, 66640, '\P{^Block=  Deseret}', "");
    Error('\p{Blk=/a/Deseret}');
    Error('\P{Blk=/a/Deseret}');
    Expect(1, 66639, '\p{Blk=:\ADeseret\z:}', "");;
    Expect(0, 66640, '\p{Blk=:\ADeseret\z:}', "");;
    Expect(1, 66639, '\p{Blk=deseret}', "");
    Expect(0, 66639, '\p{^Blk=deseret}', "");
    Expect(0, 66639, '\P{Blk=deseret}', "");
    Expect(1, 66639, '\P{^Blk=deseret}', "");
    Expect(0, 66640, '\p{Blk=deseret}', "");
    Expect(1, 66640, '\p{^Blk=deseret}', "");
    Expect(1, 66640, '\P{Blk=deseret}', "");
    Expect(0, 66640, '\P{^Blk=deseret}', "");
    Expect(1, 66639, '\p{Blk=:\Adeseret\z:}', "");;
    Expect(0, 66640, '\p{Blk=:\Adeseret\z:}', "");;
    Expect(1, 66639, '\p{Blk=_Deseret}', "");
    Expect(0, 66639, '\p{^Blk=_Deseret}', "");
    Expect(0, 66639, '\P{Blk=_Deseret}', "");
    Expect(1, 66639, '\P{^Blk=_Deseret}', "");
    Expect(0, 66640, '\p{Blk=_Deseret}', "");
    Expect(1, 66640, '\p{^Blk=_Deseret}', "");
    Expect(1, 66640, '\P{Blk=_Deseret}', "");
    Expect(0, 66640, '\P{^Blk=_Deseret}', "");
    Error('\p{Is_Block=/a/-deseret}');
    Error('\P{Is_Block=/a/-deseret}');
    Expect(1, 66639, '\p{Is_Block=deseret}', "");
    Expect(0, 66639, '\p{^Is_Block=deseret}', "");
    Expect(0, 66639, '\P{Is_Block=deseret}', "");
    Expect(1, 66639, '\P{^Is_Block=deseret}', "");
    Expect(0, 66640, '\p{Is_Block=deseret}', "");
    Expect(1, 66640, '\p{^Is_Block=deseret}', "");
    Expect(1, 66640, '\P{Is_Block=deseret}', "");
    Expect(0, 66640, '\P{^Is_Block=deseret}', "");
    Expect(1, 66639, '\p{Is_Block=	 Deseret}', "");
    Expect(0, 66639, '\p{^Is_Block=	 Deseret}', "");
    Expect(0, 66639, '\P{Is_Block=	 Deseret}', "");
    Expect(1, 66639, '\P{^Is_Block=	 Deseret}', "");
    Expect(0, 66640, '\p{Is_Block=	 Deseret}', "");
    Expect(1, 66640, '\p{^Is_Block=	 Deseret}', "");
    Expect(1, 66640, '\P{Is_Block=	 Deseret}', "");
    Expect(0, 66640, '\P{^Is_Block=	 Deseret}', "");
    Error('\p{Is_Blk=-Deseret:=}');
    Error('\P{Is_Blk=-Deseret:=}');
    Expect(1, 66639, '\p{Is_Blk=deseret}', "");
    Expect(0, 66639, '\p{^Is_Blk=deseret}', "");
    Expect(0, 66639, '\P{Is_Blk=deseret}', "");
    Expect(1, 66639, '\P{^Is_Blk=deseret}', "");
    Expect(0, 66640, '\p{Is_Blk=deseret}', "");
    Expect(1, 66640, '\p{^Is_Blk=deseret}', "");
    Expect(1, 66640, '\P{Is_Blk=deseret}', "");
    Expect(0, 66640, '\P{^Is_Blk=deseret}', "");
    Expect(1, 66639, '\p{Is_Blk=	Deseret}', "");
    Expect(0, 66639, '\p{^Is_Blk=	Deseret}', "");
    Expect(0, 66639, '\P{Is_Blk=	Deseret}', "");
    Expect(1, 66639, '\P{^Is_Blk=	Deseret}', "");
    Expect(0, 66640, '\p{Is_Blk=	Deseret}', "");
    Expect(1, 66640, '\p{^Is_Blk=	Deseret}', "");
    Expect(1, 66640, '\P{Is_Blk=	Deseret}', "");
    Expect(0, 66640, '\P{^Is_Blk=	Deseret}', "");
    Error('\p{Block=:=_-Devanagari}');
    Error('\P{Block=:=_-Devanagari}');
    Expect(1, 2431, '\p{Block=:\ADevanagari\z:}', "");;
    Expect(0, 2432, '\p{Block=:\ADevanagari\z:}', "");;
    Expect(1, 2431, '\p{Block: devanagari}', "");
    Expect(0, 2431, '\p{^Block: devanagari}', "");
    Expect(0, 2431, '\P{Block: devanagari}', "");
    Expect(1, 2431, '\P{^Block: devanagari}', "");
    Expect(0, 2432, '\p{Block: devanagari}', "");
    Expect(1, 2432, '\p{^Block: devanagari}', "");
    Expect(1, 2432, '\P{Block: devanagari}', "");
    Expect(0, 2432, '\P{^Block: devanagari}', "");
    Expect(1, 2431, '\p{Block=:\Adevanagari\z:}', "");;
    Expect(0, 2432, '\p{Block=:\Adevanagari\z:}', "");;
    Expect(1, 2431, '\p{Block=  Devanagari}', "");
    Expect(0, 2431, '\p{^Block=  Devanagari}', "");
    Expect(0, 2431, '\P{Block=  Devanagari}', "");
    Expect(1, 2431, '\P{^Block=  Devanagari}', "");
    Expect(0, 2432, '\p{Block=  Devanagari}', "");
    Expect(1, 2432, '\p{^Block=  Devanagari}', "");
    Expect(1, 2432, '\P{Block=  Devanagari}', "");
    Expect(0, 2432, '\P{^Block=  Devanagari}', "");
    Error('\p{Blk=	/a/DEVANAGARI}');
    Error('\P{Blk=	/a/DEVANAGARI}');
    Expect(1, 2431, '\p{Blk=:\ADevanagari\z:}', "");;
    Expect(0, 2432, '\p{Blk=:\ADevanagari\z:}', "");;
    Expect(1, 2431, '\p{Blk: devanagari}', "");
    Expect(0, 2431, '\p{^Blk: devanagari}', "");
    Expect(0, 2431, '\P{Blk: devanagari}', "");
    Expect(1, 2431, '\P{^Blk: devanagari}', "");
    Expect(0, 2432, '\p{Blk: devanagari}', "");
    Expect(1, 2432, '\p{^Blk: devanagari}', "");
    Expect(1, 2432, '\P{Blk: devanagari}', "");
    Expect(0, 2432, '\P{^Blk: devanagari}', "");
    Expect(1, 2431, '\p{Blk=:\Adevanagari\z:}', "");;
    Expect(0, 2432, '\p{Blk=:\Adevanagari\z:}', "");;
    Expect(1, 2431, '\p{Blk=-devanagari}', "");
    Expect(0, 2431, '\p{^Blk=-devanagari}', "");
    Expect(0, 2431, '\P{Blk=-devanagari}', "");
    Expect(1, 2431, '\P{^Blk=-devanagari}', "");
    Expect(0, 2432, '\p{Blk=-devanagari}', "");
    Expect(1, 2432, '\p{^Blk=-devanagari}', "");
    Expect(1, 2432, '\P{Blk=-devanagari}', "");
    Expect(0, 2432, '\P{^Blk=-devanagari}', "");
    Error('\p{Is_Block=:=_devanagari}');
    Error('\P{Is_Block=:=_devanagari}');
    Expect(1, 2431, '\p{Is_Block=devanagari}', "");
    Expect(0, 2431, '\p{^Is_Block=devanagari}', "");
    Expect(0, 2431, '\P{Is_Block=devanagari}', "");
    Expect(1, 2431, '\P{^Is_Block=devanagari}', "");
    Expect(0, 2432, '\p{Is_Block=devanagari}', "");
    Expect(1, 2432, '\p{^Is_Block=devanagari}', "");
    Expect(1, 2432, '\P{Is_Block=devanagari}', "");
    Expect(0, 2432, '\P{^Is_Block=devanagari}', "");
    Expect(1, 2431, '\p{Is_Block=	 Devanagari}', "");
    Expect(0, 2431, '\p{^Is_Block=	 Devanagari}', "");
    Expect(0, 2431, '\P{Is_Block=	 Devanagari}', "");
    Expect(1, 2431, '\P{^Is_Block=	 Devanagari}', "");
    Expect(0, 2432, '\p{Is_Block=	 Devanagari}', "");
    Expect(1, 2432, '\p{^Is_Block=	 Devanagari}', "");
    Expect(1, 2432, '\P{Is_Block=	 Devanagari}', "");
    Expect(0, 2432, '\P{^Is_Block=	 Devanagari}', "");
    Error('\p{Is_Blk=_-Devanagari:=}');
    Error('\P{Is_Blk=_-Devanagari:=}');
    Expect(1, 2431, '\p{Is_Blk=devanagari}', "");
    Expect(0, 2431, '\p{^Is_Blk=devanagari}', "");
    Expect(0, 2431, '\P{Is_Blk=devanagari}', "");
    Expect(1, 2431, '\P{^Is_Blk=devanagari}', "");
    Expect(0, 2432, '\p{Is_Blk=devanagari}', "");
    Expect(1, 2432, '\p{^Is_Blk=devanagari}', "");
    Expect(1, 2432, '\P{Is_Blk=devanagari}', "");
    Expect(0, 2432, '\P{^Is_Blk=devanagari}', "");
    Expect(1, 2431, '\p{Is_Blk=	 Devanagari}', "");
    Expect(0, 2431, '\p{^Is_Blk=	 Devanagari}', "");
    Expect(0, 2431, '\P{Is_Blk=	 Devanagari}', "");
    Expect(1, 2431, '\P{^Is_Blk=	 Devanagari}', "");
    Expect(0, 2432, '\p{Is_Blk=	 Devanagari}', "");
    Expect(1, 2432, '\p{^Is_Blk=	 Devanagari}', "");
    Expect(1, 2432, '\P{Is_Blk=	 Devanagari}', "");
    Expect(0, 2432, '\P{^Is_Blk=	 Devanagari}', "");
    Error('\p{Block= 	DEVANAGARI_extended:=}');
    Error('\P{Block= 	DEVANAGARI_extended:=}');
    Expect(1, 43263, '\p{Block=:\ADevanagari_Extended\z:}', "");;
    Expect(0, 43264, '\p{Block=:\ADevanagari_Extended\z:}', "");;
    Expect(1, 43263, '\p{Block=devanagariextended}', "");
    Expect(0, 43263, '\p{^Block=devanagariextended}', "");
    Expect(0, 43263, '\P{Block=devanagariextended}', "");
    Expect(1, 43263, '\P{^Block=devanagariextended}', "");
    Expect(0, 43264, '\p{Block=devanagariextended}', "");
    Expect(1, 43264, '\p{^Block=devanagariextended}', "");
    Expect(1, 43264, '\P{Block=devanagariextended}', "");
    Expect(0, 43264, '\P{^Block=devanagariextended}', "");
    Expect(1, 43263, '\p{Block=:\Adevanagariextended\z:}', "");;
    Expect(0, 43264, '\p{Block=:\Adevanagariextended\z:}', "");;
    Expect(1, 43263, '\p{Block=DEVANAGARI_Extended}', "");
    Expect(0, 43263, '\p{^Block=DEVANAGARI_Extended}', "");
    Expect(0, 43263, '\P{Block=DEVANAGARI_Extended}', "");
    Expect(1, 43263, '\P{^Block=DEVANAGARI_Extended}', "");
    Expect(0, 43264, '\p{Block=DEVANAGARI_Extended}', "");
    Expect(1, 43264, '\p{^Block=DEVANAGARI_Extended}', "");
    Expect(1, 43264, '\P{Block=DEVANAGARI_Extended}', "");
    Expect(0, 43264, '\P{^Block=DEVANAGARI_Extended}', "");
    Error('\p{Blk=:= _Devanagari_Ext}');
    Error('\P{Blk=:= _Devanagari_Ext}');
    Expect(1, 43263, '\p{Blk=:\ADevanagari_Ext\z:}', "");;
    Expect(0, 43264, '\p{Blk=:\ADevanagari_Ext\z:}', "");;
    Expect(1, 43263, '\p{Blk=devanagariext}', "");
    Expect(0, 43263, '\p{^Blk=devanagariext}', "");
    Expect(0, 43263, '\P{Blk=devanagariext}', "");
    Expect(1, 43263, '\P{^Blk=devanagariext}', "");
    Expect(0, 43264, '\p{Blk=devanagariext}', "");
    Expect(1, 43264, '\p{^Blk=devanagariext}', "");
    Expect(1, 43264, '\P{Blk=devanagariext}', "");
    Expect(0, 43264, '\P{^Blk=devanagariext}', "");
    Expect(1, 43263, '\p{Blk=:\Adevanagariext\z:}', "");;
    Expect(0, 43264, '\p{Blk=:\Adevanagariext\z:}', "");;
    Expect(1, 43263, '\p{Blk=--devanagari_Ext}', "");
    Expect(0, 43263, '\p{^Blk=--devanagari_Ext}', "");
    Expect(0, 43263, '\P{Blk=--devanagari_Ext}', "");
    Expect(1, 43263, '\P{^Blk=--devanagari_Ext}', "");
    Expect(0, 43264, '\p{Blk=--devanagari_Ext}', "");
    Expect(1, 43264, '\p{^Blk=--devanagari_Ext}', "");
    Expect(1, 43264, '\P{Blk=--devanagari_Ext}', "");
    Expect(0, 43264, '\P{^Blk=--devanagari_Ext}', "");
    Error('\p{Is_Block=/a/ -Devanagari_Extended}');
    Error('\P{Is_Block=/a/ -Devanagari_Extended}');
    Expect(1, 43263, '\p{Is_Block=devanagariextended}', "");
    Expect(0, 43263, '\p{^Is_Block=devanagariextended}', "");
    Expect(0, 43263, '\P{Is_Block=devanagariextended}', "");
    Expect(1, 43263, '\P{^Is_Block=devanagariextended}', "");
    Expect(0, 43264, '\p{Is_Block=devanagariextended}', "");
    Expect(1, 43264, '\p{^Is_Block=devanagariextended}', "");
    Expect(1, 43264, '\P{Is_Block=devanagariextended}', "");
    Expect(0, 43264, '\P{^Is_Block=devanagariextended}', "");
    Expect(1, 43263, '\p{Is_Block=Devanagari_EXTENDED}', "");
    Expect(0, 43263, '\p{^Is_Block=Devanagari_EXTENDED}', "");
    Expect(0, 43263, '\P{Is_Block=Devanagari_EXTENDED}', "");
    Expect(1, 43263, '\P{^Is_Block=Devanagari_EXTENDED}', "");
    Expect(0, 43264, '\p{Is_Block=Devanagari_EXTENDED}', "");
    Expect(1, 43264, '\p{^Is_Block=Devanagari_EXTENDED}', "");
    Expect(1, 43264, '\P{Is_Block=Devanagari_EXTENDED}', "");
    Expect(0, 43264, '\P{^Is_Block=Devanagari_EXTENDED}', "");
    Error('\p{Is_Blk=-DEVANAGARI_Ext/a/}');
    Error('\P{Is_Blk=-DEVANAGARI_Ext/a/}');
    Expect(1, 43263, '\p{Is_Blk=devanagariext}', "");
    Expect(0, 43263, '\p{^Is_Blk=devanagariext}', "");
    Expect(0, 43263, '\P{Is_Blk=devanagariext}', "");
    Expect(1, 43263, '\P{^Is_Blk=devanagariext}', "");
    Expect(0, 43264, '\p{Is_Blk=devanagariext}', "");
    Expect(1, 43264, '\p{^Is_Blk=devanagariext}', "");
    Expect(1, 43264, '\P{Is_Blk=devanagariext}', "");
    Expect(0, 43264, '\P{^Is_Blk=devanagariext}', "");
    Expect(1, 43263, '\p{Is_Blk= _Devanagari_Ext}', "");
    Expect(0, 43263, '\p{^Is_Blk= _Devanagari_Ext}', "");
    Expect(0, 43263, '\P{Is_Blk= _Devanagari_Ext}', "");
    Expect(1, 43263, '\P{^Is_Blk= _Devanagari_Ext}', "");
    Expect(0, 43264, '\p{Is_Blk= _Devanagari_Ext}', "");
    Expect(1, 43264, '\p{^Is_Blk= _Devanagari_Ext}', "");
    Expect(1, 43264, '\P{Is_Blk= _Devanagari_Ext}', "");
    Expect(0, 43264, '\P{^Is_Blk= _Devanagari_Ext}', "");
    Error('\p{Block=Devanagari_extended_A/a/}');
    Error('\P{Block=Devanagari_extended_A/a/}');
    Expect(1, 72543, '\p{Block=:\ADevanagari_Extended_A\z:}', "");;
    Expect(0, 72544, '\p{Block=:\ADevanagari_Extended_A\z:}', "");;
    Expect(1, 72543, '\p{Block: devanagariextendeda}', "");
    Expect(0, 72543, '\p{^Block: devanagariextendeda}', "");
    Expect(0, 72543, '\P{Block: devanagariextendeda}', "");
    Expect(1, 72543, '\P{^Block: devanagariextendeda}', "");
    Expect(0, 72544, '\p{Block: devanagariextendeda}', "");
    Expect(1, 72544, '\p{^Block: devanagariextendeda}', "");
    Expect(1, 72544, '\P{Block: devanagariextendeda}', "");
    Expect(0, 72544, '\P{^Block: devanagariextendeda}', "");
    Expect(1, 72543, '\p{Block=:\Adevanagariextendeda\z:}', "");;
    Expect(0, 72544, '\p{Block=:\Adevanagariextendeda\z:}', "");;
    Expect(1, 72543, '\p{Block=	_DEVANAGARI_Extended_A}', "");
    Expect(0, 72543, '\p{^Block=	_DEVANAGARI_Extended_A}', "");
    Expect(0, 72543, '\P{Block=	_DEVANAGARI_Extended_A}', "");
    Expect(1, 72543, '\P{^Block=	_DEVANAGARI_Extended_A}', "");
    Expect(0, 72544, '\p{Block=	_DEVANAGARI_Extended_A}', "");
    Expect(1, 72544, '\p{^Block=	_DEVANAGARI_Extended_A}', "");
    Expect(1, 72544, '\P{Block=	_DEVANAGARI_Extended_A}', "");
    Expect(0, 72544, '\P{^Block=	_DEVANAGARI_Extended_A}', "");
    Error('\p{Blk=	 DEVANAGARI_Ext_A/a/}');
    Error('\P{Blk=	 DEVANAGARI_Ext_A/a/}');
    Expect(1, 72543, '\p{Blk=:\ADevanagari_Ext_A\z:}', "");;
    Expect(0, 72544, '\p{Blk=:\ADevanagari_Ext_A\z:}', "");;
    Expect(1, 72543, '\p{Blk=devanagariexta}', "");
    Expect(0, 72543, '\p{^Blk=devanagariexta}', "");
    Expect(0, 72543, '\P{Blk=devanagariexta}', "");
    Expect(1, 72543, '\P{^Blk=devanagariexta}', "");
    Expect(0, 72544, '\p{Blk=devanagariexta}', "");
    Expect(1, 72544, '\p{^Blk=devanagariexta}', "");
    Expect(1, 72544, '\P{Blk=devanagariexta}', "");
    Expect(0, 72544, '\P{^Blk=devanagariexta}', "");
    Expect(1, 72543, '\p{Blk=:\Adevanagariexta\z:}', "");;
    Expect(0, 72544, '\p{Blk=:\Adevanagariexta\z:}', "");;
    Expect(1, 72543, '\p{Blk=	DEVANAGARI_ext_A}', "");
    Expect(0, 72543, '\p{^Blk=	DEVANAGARI_ext_A}', "");
    Expect(0, 72543, '\P{Blk=	DEVANAGARI_ext_A}', "");
    Expect(1, 72543, '\P{^Blk=	DEVANAGARI_ext_A}', "");
    Expect(0, 72544, '\p{Blk=	DEVANAGARI_ext_A}', "");
    Expect(1, 72544, '\p{^Blk=	DEVANAGARI_ext_A}', "");
    Expect(1, 72544, '\P{Blk=	DEVANAGARI_ext_A}', "");
    Expect(0, 72544, '\P{^Blk=	DEVANAGARI_ext_A}', "");
    Error('\p{Is_Block=	/a/DEVANAGARI_Extended_a}');
    Error('\P{Is_Block=	/a/DEVANAGARI_Extended_a}');
    Expect(1, 72543, '\p{Is_Block:   devanagariextendeda}', "");
    Expect(0, 72543, '\p{^Is_Block:   devanagariextendeda}', "");
    Expect(0, 72543, '\P{Is_Block:   devanagariextendeda}', "");
    Expect(1, 72543, '\P{^Is_Block:   devanagariextendeda}', "");
    Expect(0, 72544, '\p{Is_Block:   devanagariextendeda}', "");
    Expect(1, 72544, '\p{^Is_Block:   devanagariextendeda}', "");
    Expect(1, 72544, '\P{Is_Block:   devanagariextendeda}', "");
    Expect(0, 72544, '\P{^Is_Block:   devanagariextendeda}', "");
    Expect(1, 72543, '\p{Is_Block=-	Devanagari_Extended_A}', "");
    Expect(0, 72543, '\p{^Is_Block=-	Devanagari_Extended_A}', "");
    Expect(0, 72543, '\P{Is_Block=-	Devanagari_Extended_A}', "");
    Expect(1, 72543, '\P{^Is_Block=-	Devanagari_Extended_A}', "");
    Expect(0, 72544, '\p{Is_Block=-	Devanagari_Extended_A}', "");
    Expect(1, 72544, '\p{^Is_Block=-	Devanagari_Extended_A}', "");
    Expect(1, 72544, '\P{Is_Block=-	Devanagari_Extended_A}', "");
    Expect(0, 72544, '\P{^Is_Block=-	Devanagari_Extended_A}', "");
    Error('\p{Is_Blk=_devanagari_EXT_A:=}');
    Error('\P{Is_Blk=_devanagari_EXT_A:=}');
    Expect(1, 72543, '\p{Is_Blk=devanagariexta}', "");
    Expect(0, 72543, '\p{^Is_Blk=devanagariexta}', "");
    Expect(0, 72543, '\P{Is_Blk=devanagariexta}', "");
    Expect(1, 72543, '\P{^Is_Blk=devanagariexta}', "");
    Expect(0, 72544, '\p{Is_Blk=devanagariexta}', "");
    Expect(1, 72544, '\p{^Is_Blk=devanagariexta}', "");
    Expect(1, 72544, '\P{Is_Blk=devanagariexta}', "");
    Expect(0, 72544, '\P{^Is_Blk=devanagariexta}', "");
    Expect(1, 72543, '\p{Is_Blk= 	Devanagari_EXT_A}', "");
    Expect(0, 72543, '\p{^Is_Blk= 	Devanagari_EXT_A}', "");
    Expect(0, 72543, '\P{Is_Blk= 	Devanagari_EXT_A}', "");
    Expect(1, 72543, '\P{^Is_Blk= 	Devanagari_EXT_A}', "");
    Expect(0, 72544, '\p{Is_Blk= 	Devanagari_EXT_A}', "");
    Expect(1, 72544, '\p{^Is_Blk= 	Devanagari_EXT_A}', "");
    Expect(1, 72544, '\P{Is_Blk= 	Devanagari_EXT_A}', "");
    Expect(0, 72544, '\P{^Is_Blk= 	Devanagari_EXT_A}', "");
    Error('\p{Block=_/a/Combining_diacritical_MARKS}');
    Error('\P{Block=_/a/Combining_diacritical_MARKS}');
    Expect(1, 879, '\p{Block=:\ACombining_Diacritical_Marks\z:}', "");;
    Expect(0, 880, '\p{Block=:\ACombining_Diacritical_Marks\z:}', "");;
    Expect(1, 879, '\p{Block=combiningdiacriticalmarks}', "");
    Expect(0, 879, '\p{^Block=combiningdiacriticalmarks}', "");
    Expect(0, 879, '\P{Block=combiningdiacriticalmarks}', "");
    Expect(1, 879, '\P{^Block=combiningdiacriticalmarks}', "");
    Expect(0, 880, '\p{Block=combiningdiacriticalmarks}', "");
    Expect(1, 880, '\p{^Block=combiningdiacriticalmarks}', "");
    Expect(1, 880, '\P{Block=combiningdiacriticalmarks}', "");
    Expect(0, 880, '\P{^Block=combiningdiacriticalmarks}', "");
    Expect(1, 879, '\p{Block=:\Acombiningdiacriticalmarks\z:}', "");;
    Expect(0, 880, '\p{Block=:\Acombiningdiacriticalmarks\z:}', "");;
    Expect(1, 879, '\p{Block=_Combining_Diacritical_marks}', "");
    Expect(0, 879, '\p{^Block=_Combining_Diacritical_marks}', "");
    Expect(0, 879, '\P{Block=_Combining_Diacritical_marks}', "");
    Expect(1, 879, '\P{^Block=_Combining_Diacritical_marks}', "");
    Expect(0, 880, '\p{Block=_Combining_Diacritical_marks}', "");
    Expect(1, 880, '\p{^Block=_Combining_Diacritical_marks}', "");
    Expect(1, 880, '\P{Block=_Combining_Diacritical_marks}', "");
    Expect(0, 880, '\P{^Block=_Combining_Diacritical_marks}', "");
    Error('\p{Blk:    :=diacriticals}');
    Error('\P{Blk:    :=diacriticals}');
    Expect(1, 879, '\p{Blk=:\ADiacriticals\z:}', "");;
    Expect(0, 880, '\p{Blk=:\ADiacriticals\z:}', "");;
    Expect(1, 879, '\p{Blk: diacriticals}', "");
    Expect(0, 879, '\p{^Blk: diacriticals}', "");
    Expect(0, 879, '\P{Blk: diacriticals}', "");
    Expect(1, 879, '\P{^Blk: diacriticals}', "");
    Expect(0, 880, '\p{Blk: diacriticals}', "");
    Expect(1, 880, '\p{^Blk: diacriticals}', "");
    Expect(1, 880, '\P{Blk: diacriticals}', "");
    Expect(0, 880, '\P{^Blk: diacriticals}', "");
    Expect(1, 879, '\p{Blk=:\Adiacriticals\z:}', "");;
    Expect(0, 880, '\p{Blk=:\Adiacriticals\z:}', "");;
    Expect(1, 879, '\p{Blk=	_DIACRITICALS}', "");
    Expect(0, 879, '\p{^Blk=	_DIACRITICALS}', "");
    Expect(0, 879, '\P{Blk=	_DIACRITICALS}', "");
    Expect(1, 879, '\P{^Blk=	_DIACRITICALS}', "");
    Expect(0, 880, '\p{Blk=	_DIACRITICALS}', "");
    Expect(1, 880, '\p{^Blk=	_DIACRITICALS}', "");
    Expect(1, 880, '\P{Blk=	_DIACRITICALS}', "");
    Expect(0, 880, '\P{^Blk=	_DIACRITICALS}', "");
    Error('\p{Is_Block=_/a/combining_Diacritical_marks}');
    Error('\P{Is_Block=_/a/combining_Diacritical_marks}');
    Expect(1, 879, '\p{Is_Block=combiningdiacriticalmarks}', "");
    Expect(0, 879, '\p{^Is_Block=combiningdiacriticalmarks}', "");
    Expect(0, 879, '\P{Is_Block=combiningdiacriticalmarks}', "");
    Expect(1, 879, '\P{^Is_Block=combiningdiacriticalmarks}', "");
    Expect(0, 880, '\p{Is_Block=combiningdiacriticalmarks}', "");
    Expect(1, 880, '\p{^Is_Block=combiningdiacriticalmarks}', "");
    Expect(1, 880, '\P{Is_Block=combiningdiacriticalmarks}', "");
    Expect(0, 880, '\P{^Is_Block=combiningdiacriticalmarks}', "");
    Expect(1, 879, '\p{Is_Block=_-Combining_Diacritical_Marks}', "");
    Expect(0, 879, '\p{^Is_Block=_-Combining_Diacritical_Marks}', "");
    Expect(0, 879, '\P{Is_Block=_-Combining_Diacritical_Marks}', "");
    Expect(1, 879, '\P{^Is_Block=_-Combining_Diacritical_Marks}', "");
    Expect(0, 880, '\p{Is_Block=_-Combining_Diacritical_Marks}', "");
    Expect(1, 880, '\p{^Is_Block=_-Combining_Diacritical_Marks}', "");
    Expect(1, 880, '\P{Is_Block=_-Combining_Diacritical_Marks}', "");
    Expect(0, 880, '\P{^Is_Block=_-Combining_Diacritical_Marks}', "");
    Error('\p{Is_Blk= Diacriticals:=}');
    Error('\P{Is_Blk= Diacriticals:=}');
    Expect(1, 879, '\p{Is_Blk=diacriticals}', "");
    Expect(0, 879, '\p{^Is_Blk=diacriticals}', "");
    Expect(0, 879, '\P{Is_Blk=diacriticals}', "");
    Expect(1, 879, '\P{^Is_Blk=diacriticals}', "");
    Expect(0, 880, '\p{Is_Blk=diacriticals}', "");
    Expect(1, 880, '\p{^Is_Blk=diacriticals}', "");
    Expect(1, 880, '\P{Is_Blk=diacriticals}', "");
    Expect(0, 880, '\P{^Is_Blk=diacriticals}', "");
    Expect(1, 879, '\p{Is_Blk= Diacriticals}', "");
    Expect(0, 879, '\p{^Is_Blk= Diacriticals}', "");
    Expect(0, 879, '\P{Is_Blk= Diacriticals}', "");
    Expect(1, 879, '\P{^Is_Blk= Diacriticals}', "");
    Expect(0, 880, '\p{Is_Blk= Diacriticals}', "");
    Expect(1, 880, '\p{^Is_Blk= Diacriticals}', "");
    Expect(1, 880, '\P{Is_Blk= Diacriticals}', "");
    Expect(0, 880, '\P{^Is_Blk= Diacriticals}', "");
    Error('\p{Block:  /a/combining_Diacritical_Marks_extended}');
    Error('\P{Block:  /a/combining_Diacritical_Marks_extended}');
    Expect(1, 6911, '\p{Block=:\ACombining_Diacritical_Marks_Extended\z:}', "");;
    Expect(0, 6912, '\p{Block=:\ACombining_Diacritical_Marks_Extended\z:}', "");;
    Expect(1, 6911, '\p{Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6911, '\p{^Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6911, '\P{Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6911, '\P{^Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6912, '\p{Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6912, '\p{^Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6912, '\P{Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6912, '\P{^Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6911, '\p{Block=:\Acombiningdiacriticalmarksextended\z:}', "");;
    Expect(0, 6912, '\p{Block=:\Acombiningdiacriticalmarksextended\z:}', "");;
    Expect(1, 6911, '\p{Block=-COMBINING_Diacritical_Marks_extended}', "");
    Expect(0, 6911, '\p{^Block=-COMBINING_Diacritical_Marks_extended}', "");
    Expect(0, 6911, '\P{Block=-COMBINING_Diacritical_Marks_extended}', "");
    Expect(1, 6911, '\P{^Block=-COMBINING_Diacritical_Marks_extended}', "");
    Expect(0, 6912, '\p{Block=-COMBINING_Diacritical_Marks_extended}', "");
    Expect(1, 6912, '\p{^Block=-COMBINING_Diacritical_Marks_extended}', "");
    Expect(1, 6912, '\P{Block=-COMBINING_Diacritical_Marks_extended}', "");
    Expect(0, 6912, '\P{^Block=-COMBINING_Diacritical_Marks_extended}', "");
    Error('\p{Blk=	/a/Diacriticals_EXT}');
    Error('\P{Blk=	/a/Diacriticals_EXT}');
    Expect(1, 6911, '\p{Blk=:\ADiacriticals_Ext\z:}', "");;
    Expect(0, 6912, '\p{Blk=:\ADiacriticals_Ext\z:}', "");;
    Expect(1, 6911, '\p{Blk=diacriticalsext}', "");
    Expect(0, 6911, '\p{^Blk=diacriticalsext}', "");
    Expect(0, 6911, '\P{Blk=diacriticalsext}', "");
    Expect(1, 6911, '\P{^Blk=diacriticalsext}', "");
    Expect(0, 6912, '\p{Blk=diacriticalsext}', "");
    Expect(1, 6912, '\p{^Blk=diacriticalsext}', "");
    Expect(1, 6912, '\P{Blk=diacriticalsext}', "");
    Expect(0, 6912, '\P{^Blk=diacriticalsext}', "");
    Expect(1, 6911, '\p{Blk=:\Adiacriticalsext\z:}', "");;
    Expect(0, 6912, '\p{Blk=:\Adiacriticalsext\z:}', "");;
    Expect(1, 6911, '\p{Blk=_-Diacriticals_EXT}', "");
    Expect(0, 6911, '\p{^Blk=_-Diacriticals_EXT}', "");
    Expect(0, 6911, '\P{Blk=_-Diacriticals_EXT}', "");
    Expect(1, 6911, '\P{^Blk=_-Diacriticals_EXT}', "");
    Expect(0, 6912, '\p{Blk=_-Diacriticals_EXT}', "");
    Expect(1, 6912, '\p{^Blk=_-Diacriticals_EXT}', "");
    Expect(1, 6912, '\P{Blk=_-Diacriticals_EXT}', "");
    Expect(0, 6912, '\P{^Blk=_-Diacriticals_EXT}', "");
    Error('\p{Is_Block=--combining_DIACRITICAL_marks_Extended/a/}');
    Error('\P{Is_Block=--combining_DIACRITICAL_marks_Extended/a/}');
    Expect(1, 6911, '\p{Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6911, '\p{^Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6911, '\P{Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6911, '\P{^Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6912, '\p{Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6912, '\p{^Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6912, '\P{Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6912, '\P{^Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6911, '\p{Is_Block=  COMBINING_diacritical_Marks_Extended}', "");
    Expect(0, 6911, '\p{^Is_Block=  COMBINING_diacritical_Marks_Extended}', "");
    Expect(0, 6911, '\P{Is_Block=  COMBINING_diacritical_Marks_Extended}', "");
    Expect(1, 6911, '\P{^Is_Block=  COMBINING_diacritical_Marks_Extended}', "");
    Expect(0, 6912, '\p{Is_Block=  COMBINING_diacritical_Marks_Extended}', "");
    Expect(1, 6912, '\p{^Is_Block=  COMBINING_diacritical_Marks_Extended}', "");
    Expect(1, 6912, '\P{Is_Block=  COMBINING_diacritical_Marks_Extended}', "");
    Expect(0, 6912, '\P{^Is_Block=  COMBINING_diacritical_Marks_Extended}', "");
    Error('\p{Is_Blk=-DIACRITICALS_ext/a/}');
    Error('\P{Is_Blk=-DIACRITICALS_ext/a/}');
    Expect(1, 6911, '\p{Is_Blk=diacriticalsext}', "");
    Expect(0, 6911, '\p{^Is_Blk=diacriticalsext}', "");
    Expect(0, 6911, '\P{Is_Blk=diacriticalsext}', "");
    Expect(1, 6911, '\P{^Is_Blk=diacriticalsext}', "");
    Expect(0, 6912, '\p{Is_Blk=diacriticalsext}', "");
    Expect(1, 6912, '\p{^Is_Blk=diacriticalsext}', "");
    Expect(1, 6912, '\P{Is_Blk=diacriticalsext}', "");
    Expect(0, 6912, '\P{^Is_Blk=diacriticalsext}', "");
    Expect(1, 6911, '\p{Is_Blk=-Diacriticals_ext}', "");
    Expect(0, 6911, '\p{^Is_Blk=-Diacriticals_ext}', "");
    Expect(0, 6911, '\P{Is_Blk=-Diacriticals_ext}', "");
    Expect(1, 6911, '\P{^Is_Blk=-Diacriticals_ext}', "");
    Expect(0, 6912, '\p{Is_Blk=-Diacriticals_ext}', "");
    Expect(1, 6912, '\p{^Is_Blk=-Diacriticals_ext}', "");
    Expect(1, 6912, '\P{Is_Blk=-Diacriticals_ext}', "");
    Expect(0, 6912, '\P{^Is_Blk=-Diacriticals_ext}', "");
    Error('\p{Block=		Combining_Diacritical_Marks_For_SYMBOLS:=}');
    Error('\P{Block=		Combining_Diacritical_Marks_For_SYMBOLS:=}');
    Expect(1, 8447, '\p{Block=:\ACombining_Diacritical_Marks_For_Symbols\z:}', "");;
    Expect(0, 8448, '\p{Block=:\ACombining_Diacritical_Marks_For_Symbols\z:}', "");;
    Expect(1, 8447, '\p{Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8447, '\p{^Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8447, '\P{Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8447, '\P{^Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8448, '\p{Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8448, '\p{^Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8448, '\P{Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8448, '\P{^Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8447, '\p{Block=:\Acombiningdiacriticalmarksforsymbols\z:}', "");;
    Expect(0, 8448, '\p{Block=:\Acombiningdiacriticalmarksforsymbols\z:}', "");;
    Expect(1, 8447, '\p{Block=_ combining_DIACRITICAL_marks_For_Symbols}', "");
    Expect(0, 8447, '\p{^Block=_ combining_DIACRITICAL_marks_For_Symbols}', "");
    Expect(0, 8447, '\P{Block=_ combining_DIACRITICAL_marks_For_Symbols}', "");
    Expect(1, 8447, '\P{^Block=_ combining_DIACRITICAL_marks_For_Symbols}', "");
    Expect(0, 8448, '\p{Block=_ combining_DIACRITICAL_marks_For_Symbols}', "");
    Expect(1, 8448, '\p{^Block=_ combining_DIACRITICAL_marks_For_Symbols}', "");
    Expect(1, 8448, '\P{Block=_ combining_DIACRITICAL_marks_For_Symbols}', "");
    Expect(0, 8448, '\P{^Block=_ combining_DIACRITICAL_marks_For_Symbols}', "");
    Error('\p{Blk=	Diacriticals_For_SYMBOLS:=}');
    Error('\P{Blk=	Diacriticals_For_SYMBOLS:=}');
    Expect(1, 8447, '\p{Blk=:\ADiacriticals_For_Symbols\z:}', "");;
    Expect(0, 8448, '\p{Blk=:\ADiacriticals_For_Symbols\z:}', "");;
    Expect(1, 8447, '\p{Blk=diacriticalsforsymbols}', "");
    Expect(0, 8447, '\p{^Blk=diacriticalsforsymbols}', "");
    Expect(0, 8447, '\P{Blk=diacriticalsforsymbols}', "");
    Expect(1, 8447, '\P{^Blk=diacriticalsforsymbols}', "");
    Expect(0, 8448, '\p{Blk=diacriticalsforsymbols}', "");
    Expect(1, 8448, '\p{^Blk=diacriticalsforsymbols}', "");
    Expect(1, 8448, '\P{Blk=diacriticalsforsymbols}', "");
    Expect(0, 8448, '\P{^Blk=diacriticalsforsymbols}', "");
    Expect(1, 8447, '\p{Blk=:\Adiacriticalsforsymbols\z:}', "");;
    Expect(0, 8448, '\p{Blk=:\Adiacriticalsforsymbols\z:}', "");;
    Expect(1, 8447, '\p{Blk=_	diacriticals_For_Symbols}', "");
    Expect(0, 8447, '\p{^Blk=_	diacriticals_For_Symbols}', "");
    Expect(0, 8447, '\P{Blk=_	diacriticals_For_Symbols}', "");
    Expect(1, 8447, '\P{^Blk=_	diacriticals_For_Symbols}', "");
    Expect(0, 8448, '\p{Blk=_	diacriticals_For_Symbols}', "");
    Expect(1, 8448, '\p{^Blk=_	diacriticals_For_Symbols}', "");
    Expect(1, 8448, '\P{Blk=_	diacriticals_For_Symbols}', "");
    Expect(0, 8448, '\P{^Blk=_	diacriticals_For_Symbols}', "");
    Error('\p{Is_Block=-Combining_Marks_for_Symbols:=}');
    Error('\P{Is_Block=-Combining_Marks_for_Symbols:=}');
    Expect(1, 8447, '\p{Is_Block: combiningmarksforsymbols}', "");
    Expect(0, 8447, '\p{^Is_Block: combiningmarksforsymbols}', "");
    Expect(0, 8447, '\P{Is_Block: combiningmarksforsymbols}', "");
    Expect(1, 8447, '\P{^Is_Block: combiningmarksforsymbols}', "");
    Expect(0, 8448, '\p{Is_Block: combiningmarksforsymbols}', "");
    Expect(1, 8448, '\p{^Is_Block: combiningmarksforsymbols}', "");
    Expect(1, 8448, '\P{Is_Block: combiningmarksforsymbols}', "");
    Expect(0, 8448, '\P{^Is_Block: combiningmarksforsymbols}', "");
    Expect(1, 8447, '\p{Is_Block=Combining_marks_FOR_Symbols}', "");
    Expect(0, 8447, '\p{^Is_Block=Combining_marks_FOR_Symbols}', "");
    Expect(0, 8447, '\P{Is_Block=Combining_marks_FOR_Symbols}', "");
    Expect(1, 8447, '\P{^Is_Block=Combining_marks_FOR_Symbols}', "");
    Expect(0, 8448, '\p{Is_Block=Combining_marks_FOR_Symbols}', "");
    Expect(1, 8448, '\p{^Is_Block=Combining_marks_FOR_Symbols}', "");
    Expect(1, 8448, '\P{Is_Block=Combining_marks_FOR_Symbols}', "");
    Expect(0, 8448, '\P{^Is_Block=Combining_marks_FOR_Symbols}', "");
    Error('\p{Is_Blk= :=combining_diacritical_MARKS_for_symbols}');
    Error('\P{Is_Blk= :=combining_diacritical_MARKS_for_symbols}');
    Expect(1, 8447, '\p{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8447, '\p{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8447, '\P{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8447, '\P{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8448, '\p{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8448, '\p{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8448, '\P{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8448, '\P{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8447, '\p{Is_Blk=-combining_Diacritical_Marks_For_symbols}', "");
    Expect(0, 8447, '\p{^Is_Blk=-combining_Diacritical_Marks_For_symbols}', "");
    Expect(0, 8447, '\P{Is_Blk=-combining_Diacritical_Marks_For_symbols}', "");
    Expect(1, 8447, '\P{^Is_Blk=-combining_Diacritical_Marks_For_symbols}', "");
    Expect(0, 8448, '\p{Is_Blk=-combining_Diacritical_Marks_For_symbols}', "");
    Expect(1, 8448, '\p{^Is_Blk=-combining_Diacritical_Marks_For_symbols}', "");
    Expect(1, 8448, '\P{Is_Blk=-combining_Diacritical_Marks_For_symbols}', "");
    Expect(0, 8448, '\P{^Is_Blk=-combining_Diacritical_Marks_For_symbols}', "");
    Error('\p{Block: 	/a/Combining_Diacritical_MARKS_supplement}');
    Error('\P{Block: 	/a/Combining_Diacritical_MARKS_supplement}');
    Expect(1, 7679, '\p{Block=:\ACombining_Diacritical_Marks_Supplement\z:}', "");;
    Expect(0, 7680, '\p{Block=:\ACombining_Diacritical_Marks_Supplement\z:}', "");;
    Expect(1, 7679, '\p{Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7679, '\p{^Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7679, '\P{Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7679, '\P{^Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7680, '\p{Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7680, '\p{^Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7680, '\P{Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7680, '\P{^Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7679, '\p{Block=:\Acombiningdiacriticalmarkssupplement\z:}', "");;
    Expect(0, 7680, '\p{Block=:\Acombiningdiacriticalmarkssupplement\z:}', "");;
    Expect(1, 7679, '\p{Block=--combining_Diacritical_MARKS_Supplement}', "");
    Expect(0, 7679, '\p{^Block=--combining_Diacritical_MARKS_Supplement}', "");
    Expect(0, 7679, '\P{Block=--combining_Diacritical_MARKS_Supplement}', "");
    Expect(1, 7679, '\P{^Block=--combining_Diacritical_MARKS_Supplement}', "");
    Expect(0, 7680, '\p{Block=--combining_Diacritical_MARKS_Supplement}', "");
    Expect(1, 7680, '\p{^Block=--combining_Diacritical_MARKS_Supplement}', "");
    Expect(1, 7680, '\P{Block=--combining_Diacritical_MARKS_Supplement}', "");
    Expect(0, 7680, '\P{^Block=--combining_Diacritical_MARKS_Supplement}', "");
    Error('\p{Blk=_:=Diacriticals_sup}');
    Error('\P{Blk=_:=Diacriticals_sup}');
    Expect(1, 7679, '\p{Blk=:\ADiacriticals_Sup\z:}', "");;
    Expect(0, 7680, '\p{Blk=:\ADiacriticals_Sup\z:}', "");;
    Expect(1, 7679, '\p{Blk=diacriticalssup}', "");
    Expect(0, 7679, '\p{^Blk=diacriticalssup}', "");
    Expect(0, 7679, '\P{Blk=diacriticalssup}', "");
    Expect(1, 7679, '\P{^Blk=diacriticalssup}', "");
    Expect(0, 7680, '\p{Blk=diacriticalssup}', "");
    Expect(1, 7680, '\p{^Blk=diacriticalssup}', "");
    Expect(1, 7680, '\P{Blk=diacriticalssup}', "");
    Expect(0, 7680, '\P{^Blk=diacriticalssup}', "");
    Expect(1, 7679, '\p{Blk=:\Adiacriticalssup\z:}', "");;
    Expect(0, 7680, '\p{Blk=:\Adiacriticalssup\z:}', "");;
    Expect(1, 7679, '\p{Blk: Diacriticals_sup}', "");
    Expect(0, 7679, '\p{^Blk: Diacriticals_sup}', "");
    Expect(0, 7679, '\P{Blk: Diacriticals_sup}', "");
    Expect(1, 7679, '\P{^Blk: Diacriticals_sup}', "");
    Expect(0, 7680, '\p{Blk: Diacriticals_sup}', "");
    Expect(1, 7680, '\p{^Blk: Diacriticals_sup}', "");
    Expect(1, 7680, '\P{Blk: Diacriticals_sup}', "");
    Expect(0, 7680, '\P{^Blk: Diacriticals_sup}', "");
    Error('\p{Is_Block=	combining_diacritical_Marks_Supplement/a/}');
    Error('\P{Is_Block=	combining_diacritical_Marks_Supplement/a/}');
    Expect(1, 7679, '\p{Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7679, '\p{^Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7679, '\P{Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7679, '\P{^Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7680, '\p{Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7680, '\p{^Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7680, '\P{Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7680, '\P{^Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7679, '\p{Is_Block=	_Combining_Diacritical_Marks_Supplement}', "");
    Expect(0, 7679, '\p{^Is_Block=	_Combining_Diacritical_Marks_Supplement}', "");
    Expect(0, 7679, '\P{Is_Block=	_Combining_Diacritical_Marks_Supplement}', "");
    Expect(1, 7679, '\P{^Is_Block=	_Combining_Diacritical_Marks_Supplement}', "");
    Expect(0, 7680, '\p{Is_Block=	_Combining_Diacritical_Marks_Supplement}', "");
    Expect(1, 7680, '\p{^Is_Block=	_Combining_Diacritical_Marks_Supplement}', "");
    Expect(1, 7680, '\P{Is_Block=	_Combining_Diacritical_Marks_Supplement}', "");
    Expect(0, 7680, '\P{^Is_Block=	_Combining_Diacritical_Marks_Supplement}', "");
    Error('\p{Is_Blk=/a/__DIACRITICALS_Sup}');
    Error('\P{Is_Blk=/a/__DIACRITICALS_Sup}');
    Expect(1, 7679, '\p{Is_Blk=diacriticalssup}', "");
    Expect(0, 7679, '\p{^Is_Blk=diacriticalssup}', "");
    Expect(0, 7679, '\P{Is_Blk=diacriticalssup}', "");
    Expect(1, 7679, '\P{^Is_Blk=diacriticalssup}', "");
    Expect(0, 7680, '\p{Is_Blk=diacriticalssup}', "");
    Expect(1, 7680, '\p{^Is_Blk=diacriticalssup}', "");
    Expect(1, 7680, '\P{Is_Blk=diacriticalssup}', "");
    Expect(0, 7680, '\P{^Is_Blk=diacriticalssup}', "");
    Expect(1, 7679, '\p{Is_Blk=-diacriticals_Sup}', "");
    Expect(0, 7679, '\p{^Is_Blk=-diacriticals_Sup}', "");
    Expect(0, 7679, '\P{Is_Blk=-diacriticals_Sup}', "");
    Expect(1, 7679, '\P{^Is_Blk=-diacriticals_Sup}', "");
    Expect(0, 7680, '\p{Is_Blk=-diacriticals_Sup}', "");
    Expect(1, 7680, '\p{^Is_Blk=-diacriticals_Sup}', "");
    Expect(1, 7680, '\P{Is_Blk=-diacriticals_Sup}', "");
    Expect(0, 7680, '\P{^Is_Blk=-diacriticals_Sup}', "");
    Error('\p{Block=:=	-DINGBATS}');
    Error('\P{Block=:=	-DINGBATS}');
    Expect(1, 10175, '\p{Block=:\ADingbats\z:}', "");;
    Expect(0, 10176, '\p{Block=:\ADingbats\z:}', "");;
    Expect(1, 10175, '\p{Block=dingbats}', "");
    Expect(0, 10175, '\p{^Block=dingbats}', "");
    Expect(0, 10175, '\P{Block=dingbats}', "");
    Expect(1, 10175, '\P{^Block=dingbats}', "");
    Expect(0, 10176, '\p{Block=dingbats}', "");
    Expect(1, 10176, '\p{^Block=dingbats}', "");
    Expect(1, 10176, '\P{Block=dingbats}', "");
    Expect(0, 10176, '\P{^Block=dingbats}', "");
    Expect(1, 10175, '\p{Block=:\Adingbats\z:}', "");;
    Expect(0, 10176, '\p{Block=:\Adingbats\z:}', "");;
    Expect(1, 10175, '\p{Block=- Dingbats}', "");
    Expect(0, 10175, '\p{^Block=- Dingbats}', "");
    Expect(0, 10175, '\P{Block=- Dingbats}', "");
    Expect(1, 10175, '\P{^Block=- Dingbats}', "");
    Expect(0, 10176, '\p{Block=- Dingbats}', "");
    Expect(1, 10176, '\p{^Block=- Dingbats}', "");
    Expect(1, 10176, '\P{Block=- Dingbats}', "");
    Expect(0, 10176, '\P{^Block=- Dingbats}', "");
    Error('\p{Blk=-DINGBATS/a/}');
    Error('\P{Blk=-DINGBATS/a/}');
    Expect(1, 10175, '\p{Blk=:\ADingbats\z:}', "");;
    Expect(0, 10176, '\p{Blk=:\ADingbats\z:}', "");;
    Expect(1, 10175, '\p{Blk=dingbats}', "");
    Expect(0, 10175, '\p{^Blk=dingbats}', "");
    Expect(0, 10175, '\P{Blk=dingbats}', "");
    Expect(1, 10175, '\P{^Blk=dingbats}', "");
    Expect(0, 10176, '\p{Blk=dingbats}', "");
    Expect(1, 10176, '\p{^Blk=dingbats}', "");
    Expect(1, 10176, '\P{Blk=dingbats}', "");
    Expect(0, 10176, '\P{^Blk=dingbats}', "");
    Expect(1, 10175, '\p{Blk=:\Adingbats\z:}', "");;
    Expect(0, 10176, '\p{Blk=:\Adingbats\z:}', "");;
    Expect(1, 10175, '\p{Blk= -Dingbats}', "");
    Expect(0, 10175, '\p{^Blk= -Dingbats}', "");
    Expect(0, 10175, '\P{Blk= -Dingbats}', "");
    Expect(1, 10175, '\P{^Blk= -Dingbats}', "");
    Expect(0, 10176, '\p{Blk= -Dingbats}', "");
    Expect(1, 10176, '\p{^Blk= -Dingbats}', "");
    Expect(1, 10176, '\P{Blk= -Dingbats}', "");
    Expect(0, 10176, '\P{^Blk= -Dingbats}', "");
    Error('\p{Is_Block=DINGBATS:=}');
    Error('\P{Is_Block=DINGBATS:=}');
    Expect(1, 10175, '\p{Is_Block=dingbats}', "");
    Expect(0, 10175, '\p{^Is_Block=dingbats}', "");
    Expect(0, 10175, '\P{Is_Block=dingbats}', "");
    Expect(1, 10175, '\P{^Is_Block=dingbats}', "");
    Expect(0, 10176, '\p{Is_Block=dingbats}', "");
    Expect(1, 10176, '\p{^Is_Block=dingbats}', "");
    Expect(1, 10176, '\P{Is_Block=dingbats}', "");
    Expect(0, 10176, '\P{^Is_Block=dingbats}', "");
    Expect(1, 10175, '\p{Is_Block=		dingbats}', "");
    Expect(0, 10175, '\p{^Is_Block=		dingbats}', "");
    Expect(0, 10175, '\P{Is_Block=		dingbats}', "");
    Expect(1, 10175, '\P{^Is_Block=		dingbats}', "");
    Expect(0, 10176, '\p{Is_Block=		dingbats}', "");
    Expect(1, 10176, '\p{^Is_Block=		dingbats}', "");
    Expect(1, 10176, '\P{Is_Block=		dingbats}', "");
    Expect(0, 10176, '\P{^Is_Block=		dingbats}', "");
    Error('\p{Is_Blk=:=dingbats}');
    Error('\P{Is_Blk=:=dingbats}');
    Expect(1, 10175, '\p{Is_Blk=dingbats}', "");
    Expect(0, 10175, '\p{^Is_Blk=dingbats}', "");
    Expect(0, 10175, '\P{Is_Blk=dingbats}', "");
    Expect(1, 10175, '\P{^Is_Blk=dingbats}', "");
    Expect(0, 10176, '\p{Is_Blk=dingbats}', "");
    Expect(1, 10176, '\p{^Is_Blk=dingbats}', "");
    Expect(1, 10176, '\P{Is_Blk=dingbats}', "");
    Expect(0, 10176, '\P{^Is_Blk=dingbats}', "");
    Expect(1, 10175, '\p{Is_Blk=_dingbats}', "");
    Expect(0, 10175, '\p{^Is_Blk=_dingbats}', "");
    Expect(0, 10175, '\P{Is_Blk=_dingbats}', "");
    Expect(1, 10175, '\P{^Is_Blk=_dingbats}', "");
    Expect(0, 10176, '\p{Is_Blk=_dingbats}', "");
    Expect(1, 10176, '\p{^Is_Blk=_dingbats}', "");
    Expect(1, 10176, '\P{Is_Blk=_dingbats}', "");
    Expect(0, 10176, '\P{^Is_Blk=_dingbats}', "");
    Error('\p{Block=/a/-dives_AKURU}');
    Error('\P{Block=/a/-dives_AKURU}');
    Expect(1, 72031, '\p{Block=:\ADives_Akuru\z:}', "");;
    Expect(0, 72032, '\p{Block=:\ADives_Akuru\z:}', "");;
    Expect(1, 72031, '\p{Block=divesakuru}', "");
    Expect(0, 72031, '\p{^Block=divesakuru}', "");
    Expect(0, 72031, '\P{Block=divesakuru}', "");
    Expect(1, 72031, '\P{^Block=divesakuru}', "");
    Expect(0, 72032, '\p{Block=divesakuru}', "");
    Expect(1, 72032, '\p{^Block=divesakuru}', "");
    Expect(1, 72032, '\P{Block=divesakuru}', "");
    Expect(0, 72032, '\P{^Block=divesakuru}', "");
    Expect(1, 72031, '\p{Block=:\Adivesakuru\z:}', "");;
    Expect(0, 72032, '\p{Block=:\Adivesakuru\z:}', "");;
    Expect(1, 72031, '\p{Block:  -Dives_Akuru}', "");
    Expect(0, 72031, '\p{^Block:  -Dives_Akuru}', "");
    Expect(0, 72031, '\P{Block:  -Dives_Akuru}', "");
    Expect(1, 72031, '\P{^Block:  -Dives_Akuru}', "");
    Expect(0, 72032, '\p{Block:  -Dives_Akuru}', "");
    Expect(1, 72032, '\p{^Block:  -Dives_Akuru}', "");
    Expect(1, 72032, '\P{Block:  -Dives_Akuru}', "");
    Expect(0, 72032, '\P{^Block:  -Dives_Akuru}', "");
    Error('\p{Blk=:=--DIVES_AKURU}');
    Error('\P{Blk=:=--DIVES_AKURU}');
    Expect(1, 72031, '\p{Blk=:\ADives_Akuru\z:}', "");;
    Expect(0, 72032, '\p{Blk=:\ADives_Akuru\z:}', "");;
    Expect(1, 72031, '\p{Blk=divesakuru}', "");
    Expect(0, 72031, '\p{^Blk=divesakuru}', "");
    Expect(0, 72031, '\P{Blk=divesakuru}', "");
    Expect(1, 72031, '\P{^Blk=divesakuru}', "");
    Expect(0, 72032, '\p{Blk=divesakuru}', "");
    Expect(1, 72032, '\p{^Blk=divesakuru}', "");
    Expect(1, 72032, '\P{Blk=divesakuru}', "");
    Expect(0, 72032, '\P{^Blk=divesakuru}', "");
    Expect(1, 72031, '\p{Blk=:\Adivesakuru\z:}', "");;
    Expect(0, 72032, '\p{Blk=:\Adivesakuru\z:}', "");;
    Expect(1, 72031, '\p{Blk=_DIVES_Akuru}', "");
    Expect(0, 72031, '\p{^Blk=_DIVES_Akuru}', "");
    Expect(0, 72031, '\P{Blk=_DIVES_Akuru}', "");
    Expect(1, 72031, '\P{^Blk=_DIVES_Akuru}', "");
    Expect(0, 72032, '\p{Blk=_DIVES_Akuru}', "");
    Expect(1, 72032, '\p{^Blk=_DIVES_Akuru}', "");
    Expect(1, 72032, '\P{Blk=_DIVES_Akuru}', "");
    Expect(0, 72032, '\P{^Blk=_DIVES_Akuru}', "");
    Error('\p{Is_Block=/a/--DIVES_Akuru}');
    Error('\P{Is_Block=/a/--DIVES_Akuru}');
    Expect(1, 72031, '\p{Is_Block:   divesakuru}', "");
    Expect(0, 72031, '\p{^Is_Block:   divesakuru}', "");
    Expect(0, 72031, '\P{Is_Block:   divesakuru}', "");
    Expect(1, 72031, '\P{^Is_Block:   divesakuru}', "");
    Expect(0, 72032, '\p{Is_Block:   divesakuru}', "");
    Expect(1, 72032, '\p{^Is_Block:   divesakuru}', "");
    Expect(1, 72032, '\P{Is_Block:   divesakuru}', "");
    Expect(0, 72032, '\P{^Is_Block:   divesakuru}', "");
    Expect(1, 72031, '\p{Is_Block=_Dives_Akuru}', "");
    Expect(0, 72031, '\p{^Is_Block=_Dives_Akuru}', "");
    Expect(0, 72031, '\P{Is_Block=_Dives_Akuru}', "");
    Expect(1, 72031, '\P{^Is_Block=_Dives_Akuru}', "");
    Expect(0, 72032, '\p{Is_Block=_Dives_Akuru}', "");
    Expect(1, 72032, '\p{^Is_Block=_Dives_Akuru}', "");
    Expect(1, 72032, '\P{Is_Block=_Dives_Akuru}', "");
    Expect(0, 72032, '\P{^Is_Block=_Dives_Akuru}', "");
    Error('\p{Is_Blk=__DIVES_Akuru/a/}');
    Error('\P{Is_Blk=__DIVES_Akuru/a/}');
    Expect(1, 72031, '\p{Is_Blk=divesakuru}', "");
    Expect(0, 72031, '\p{^Is_Blk=divesakuru}', "");
    Expect(0, 72031, '\P{Is_Blk=divesakuru}', "");
    Expect(1, 72031, '\P{^Is_Blk=divesakuru}', "");
    Expect(0, 72032, '\p{Is_Blk=divesakuru}', "");
    Expect(1, 72032, '\p{^Is_Blk=divesakuru}', "");
    Expect(1, 72032, '\P{Is_Blk=divesakuru}', "");
    Expect(0, 72032, '\P{^Is_Blk=divesakuru}', "");
    Expect(1, 72031, '\p{Is_Blk=	 Dives_Akuru}', "");
    Expect(0, 72031, '\p{^Is_Blk=	 Dives_Akuru}', "");
    Expect(0, 72031, '\P{Is_Blk=	 Dives_Akuru}', "");
    Expect(1, 72031, '\P{^Is_Blk=	 Dives_Akuru}', "");
    Expect(0, 72032, '\p{Is_Blk=	 Dives_Akuru}', "");
    Expect(1, 72032, '\p{^Is_Blk=	 Dives_Akuru}', "");
    Expect(1, 72032, '\P{Is_Blk=	 Dives_Akuru}', "");
    Expect(0, 72032, '\P{^Is_Blk=	 Dives_Akuru}', "");
    Error('\p{Block=:=	_Dogra}');
    Error('\P{Block=:=	_Dogra}');
    Expect(1, 71759, '\p{Block=:\ADogra\z:}', "");;
    Expect(0, 71760, '\p{Block=:\ADogra\z:}', "");;
    Expect(1, 71759, '\p{Block=dogra}', "");
    Expect(0, 71759, '\p{^Block=dogra}', "");
    Expect(0, 71759, '\P{Block=dogra}', "");
    Expect(1, 71759, '\P{^Block=dogra}', "");
    Expect(0, 71760, '\p{Block=dogra}', "");
    Expect(1, 71760, '\p{^Block=dogra}', "");
    Expect(1, 71760, '\P{Block=dogra}', "");
    Expect(0, 71760, '\P{^Block=dogra}', "");
    Expect(1, 71759, '\p{Block=:\Adogra\z:}', "");;
    Expect(0, 71760, '\p{Block=:\Adogra\z:}', "");;
    Expect(1, 71759, '\p{Block= dogra}', "");
    Expect(0, 71759, '\p{^Block= dogra}', "");
    Expect(0, 71759, '\P{Block= dogra}', "");
    Expect(1, 71759, '\P{^Block= dogra}', "");
    Expect(0, 71760, '\p{Block= dogra}', "");
    Expect(1, 71760, '\p{^Block= dogra}', "");
    Expect(1, 71760, '\P{Block= dogra}', "");
    Expect(0, 71760, '\P{^Block= dogra}', "");
    Error('\p{Blk= 	dogra/a/}');
    Error('\P{Blk= 	dogra/a/}');
    Expect(1, 71759, '\p{Blk=:\ADogra\z:}', "");;
    Expect(0, 71760, '\p{Blk=:\ADogra\z:}', "");;
    Expect(1, 71759, '\p{Blk=dogra}', "");
    Expect(0, 71759, '\p{^Blk=dogra}', "");
    Expect(0, 71759, '\P{Blk=dogra}', "");
    Expect(1, 71759, '\P{^Blk=dogra}', "");
    Expect(0, 71760, '\p{Blk=dogra}', "");
    Expect(1, 71760, '\p{^Blk=dogra}', "");
    Expect(1, 71760, '\P{Blk=dogra}', "");
    Expect(0, 71760, '\P{^Blk=dogra}', "");
    Expect(1, 71759, '\p{Blk=:\Adogra\z:}', "");;
    Expect(0, 71760, '\p{Blk=:\Adogra\z:}', "");;
    Expect(1, 71759, '\p{Blk=__dogra}', "");
    Expect(0, 71759, '\p{^Blk=__dogra}', "");
    Expect(0, 71759, '\P{Blk=__dogra}', "");
    Expect(1, 71759, '\P{^Blk=__dogra}', "");
    Expect(0, 71760, '\p{Blk=__dogra}', "");
    Expect(1, 71760, '\p{^Blk=__dogra}', "");
    Expect(1, 71760, '\P{Blk=__dogra}', "");
    Expect(0, 71760, '\P{^Blk=__dogra}', "");
    Error('\p{Is_Block=_Dogra/a/}');
    Error('\P{Is_Block=_Dogra/a/}');
    Expect(1, 71759, '\p{Is_Block=dogra}', "");
    Expect(0, 71759, '\p{^Is_Block=dogra}', "");
    Expect(0, 71759, '\P{Is_Block=dogra}', "");
    Expect(1, 71759, '\P{^Is_Block=dogra}', "");
    Expect(0, 71760, '\p{Is_Block=dogra}', "");
    Expect(1, 71760, '\p{^Is_Block=dogra}', "");
    Expect(1, 71760, '\P{Is_Block=dogra}', "");
    Expect(0, 71760, '\P{^Is_Block=dogra}', "");
    Expect(1, 71759, '\p{Is_Block= dogra}', "");
    Expect(0, 71759, '\p{^Is_Block= dogra}', "");
    Expect(0, 71759, '\P{Is_Block= dogra}', "");
    Expect(1, 71759, '\P{^Is_Block= dogra}', "");
    Expect(0, 71760, '\p{Is_Block= dogra}', "");
    Expect(1, 71760, '\p{^Is_Block= dogra}', "");
    Expect(1, 71760, '\P{Is_Block= dogra}', "");
    Expect(0, 71760, '\P{^Is_Block= dogra}', "");
    Error('\p{Is_Blk=_/a/Dogra}');
    Error('\P{Is_Blk=_/a/Dogra}');
    Expect(1, 71759, '\p{Is_Blk=dogra}', "");
    Expect(0, 71759, '\p{^Is_Blk=dogra}', "");
    Expect(0, 71759, '\P{Is_Blk=dogra}', "");
    Expect(1, 71759, '\P{^Is_Blk=dogra}', "");
    Expect(0, 71760, '\p{Is_Blk=dogra}', "");
    Expect(1, 71760, '\p{^Is_Blk=dogra}', "");
    Expect(1, 71760, '\P{Is_Blk=dogra}', "");
    Expect(0, 71760, '\P{^Is_Blk=dogra}', "");
    Expect(1, 71759, '\p{Is_Blk=--Dogra}', "");
    Expect(0, 71759, '\p{^Is_Blk=--Dogra}', "");
    Expect(0, 71759, '\P{Is_Blk=--Dogra}', "");
    Expect(1, 71759, '\P{^Is_Blk=--Dogra}', "");
    Expect(0, 71760, '\p{Is_Blk=--Dogra}', "");
    Expect(1, 71760, '\p{^Is_Blk=--Dogra}', "");
    Expect(1, 71760, '\P{Is_Blk=--Dogra}', "");
    Expect(0, 71760, '\P{^Is_Blk=--Dogra}', "");
    Error('\p{Block=		Domino_TILES/a/}');
    Error('\P{Block=		Domino_TILES/a/}');
    Expect(1, 127135, '\p{Block=:\ADomino_Tiles\z:}', "");;
    Expect(0, 127136, '\p{Block=:\ADomino_Tiles\z:}', "");;
    Expect(1, 127135, '\p{Block=dominotiles}', "");
    Expect(0, 127135, '\p{^Block=dominotiles}', "");
    Expect(0, 127135, '\P{Block=dominotiles}', "");
    Expect(1, 127135, '\P{^Block=dominotiles}', "");
    Expect(0, 127136, '\p{Block=dominotiles}', "");
    Expect(1, 127136, '\p{^Block=dominotiles}', "");
    Expect(1, 127136, '\P{Block=dominotiles}', "");
    Expect(0, 127136, '\P{^Block=dominotiles}', "");
    Expect(1, 127135, '\p{Block=:\Adominotiles\z:}', "");;
    Expect(0, 127136, '\p{Block=:\Adominotiles\z:}', "");;
    Expect(1, 127135, '\p{Block=-Domino_Tiles}', "");
    Expect(0, 127135, '\p{^Block=-Domino_Tiles}', "");
    Expect(0, 127135, '\P{Block=-Domino_Tiles}', "");
    Expect(1, 127135, '\P{^Block=-Domino_Tiles}', "");
    Expect(0, 127136, '\p{Block=-Domino_Tiles}', "");
    Expect(1, 127136, '\p{^Block=-Domino_Tiles}', "");
    Expect(1, 127136, '\P{Block=-Domino_Tiles}', "");
    Expect(0, 127136, '\P{^Block=-Domino_Tiles}', "");
    Error('\p{Blk: -/a/Domino}');
    Error('\P{Blk: -/a/Domino}');
    Expect(1, 127135, '\p{Blk=:\ADomino\z:}', "");;
    Expect(0, 127136, '\p{Blk=:\ADomino\z:}', "");;
    Expect(1, 127135, '\p{Blk=domino}', "");
    Expect(0, 127135, '\p{^Blk=domino}', "");
    Expect(0, 127135, '\P{Blk=domino}', "");
    Expect(1, 127135, '\P{^Blk=domino}', "");
    Expect(0, 127136, '\p{Blk=domino}', "");
    Expect(1, 127136, '\p{^Blk=domino}', "");
    Expect(1, 127136, '\P{Blk=domino}', "");
    Expect(0, 127136, '\P{^Blk=domino}', "");
    Expect(1, 127135, '\p{Blk=:\Adomino\z:}', "");;
    Expect(0, 127136, '\p{Blk=:\Adomino\z:}', "");;
    Expect(1, 127135, '\p{Blk=	 DOMINO}', "");
    Expect(0, 127135, '\p{^Blk=	 DOMINO}', "");
    Expect(0, 127135, '\P{Blk=	 DOMINO}', "");
    Expect(1, 127135, '\P{^Blk=	 DOMINO}', "");
    Expect(0, 127136, '\p{Blk=	 DOMINO}', "");
    Expect(1, 127136, '\p{^Blk=	 DOMINO}', "");
    Expect(1, 127136, '\P{Blk=	 DOMINO}', "");
    Expect(0, 127136, '\P{^Blk=	 DOMINO}', "");
    Error('\p{Is_Block=:=_Domino_tiles}');
    Error('\P{Is_Block=:=_Domino_tiles}');
    Expect(1, 127135, '\p{Is_Block=dominotiles}', "");
    Expect(0, 127135, '\p{^Is_Block=dominotiles}', "");
    Expect(0, 127135, '\P{Is_Block=dominotiles}', "");
    Expect(1, 127135, '\P{^Is_Block=dominotiles}', "");
    Expect(0, 127136, '\p{Is_Block=dominotiles}', "");
    Expect(1, 127136, '\p{^Is_Block=dominotiles}', "");
    Expect(1, 127136, '\P{Is_Block=dominotiles}', "");
    Expect(0, 127136, '\P{^Is_Block=dominotiles}', "");
    Expect(1, 127135, '\p{Is_Block=  domino_TILES}', "");
    Expect(0, 127135, '\p{^Is_Block=  domino_TILES}', "");
    Expect(0, 127135, '\P{Is_Block=  domino_TILES}', "");
    Expect(1, 127135, '\P{^Is_Block=  domino_TILES}', "");
    Expect(0, 127136, '\p{Is_Block=  domino_TILES}', "");
    Expect(1, 127136, '\p{^Is_Block=  domino_TILES}', "");
    Expect(1, 127136, '\P{Is_Block=  domino_TILES}', "");
    Expect(0, 127136, '\P{^Is_Block=  domino_TILES}', "");
    Error('\p{Is_Blk=:=	-Domino}');
    Error('\P{Is_Blk=:=	-Domino}');
    Expect(1, 127135, '\p{Is_Blk: domino}', "");
    Expect(0, 127135, '\p{^Is_Blk: domino}', "");
    Expect(0, 127135, '\P{Is_Blk: domino}', "");
    Expect(1, 127135, '\P{^Is_Blk: domino}', "");
    Expect(0, 127136, '\p{Is_Blk: domino}', "");
    Expect(1, 127136, '\p{^Is_Blk: domino}', "");
    Expect(1, 127136, '\P{Is_Blk: domino}', "");
    Expect(0, 127136, '\P{^Is_Blk: domino}', "");
    Expect(1, 127135, '\p{Is_Blk=-	Domino}', "");
    Expect(0, 127135, '\p{^Is_Blk=-	Domino}', "");
    Expect(0, 127135, '\P{Is_Blk=-	Domino}', "");
    Expect(1, 127135, '\P{^Is_Blk=-	Domino}', "");
    Expect(0, 127136, '\p{Is_Blk=-	Domino}', "");
    Expect(1, 127136, '\p{^Is_Blk=-	Domino}', "");
    Expect(1, 127136, '\P{Is_Blk=-	Domino}', "");
    Expect(0, 127136, '\P{^Is_Blk=-	Domino}', "");
    Error('\p{Block=/a/ _DUPLOYAN}');
    Error('\P{Block=/a/ _DUPLOYAN}');
    Expect(1, 113823, '\p{Block=:\ADuployan\z:}', "");;
    Expect(0, 113824, '\p{Block=:\ADuployan\z:}', "");;
    Expect(1, 113823, '\p{Block=duployan}', "");
    Expect(0, 113823, '\p{^Block=duployan}', "");
    Expect(0, 113823, '\P{Block=duployan}', "");
    Expect(1, 113823, '\P{^Block=duployan}', "");
    Expect(0, 113824, '\p{Block=duployan}', "");
    Expect(1, 113824, '\p{^Block=duployan}', "");
    Expect(1, 113824, '\P{Block=duployan}', "");
    Expect(0, 113824, '\P{^Block=duployan}', "");
    Expect(1, 113823, '\p{Block=:\Aduployan\z:}', "");;
    Expect(0, 113824, '\p{Block=:\Aduployan\z:}', "");;
    Expect(1, 113823, '\p{Block:		-DUPLOYAN}', "");
    Expect(0, 113823, '\p{^Block:		-DUPLOYAN}', "");
    Expect(0, 113823, '\P{Block:		-DUPLOYAN}', "");
    Expect(1, 113823, '\P{^Block:		-DUPLOYAN}', "");
    Expect(0, 113824, '\p{Block:		-DUPLOYAN}', "");
    Expect(1, 113824, '\p{^Block:		-DUPLOYAN}', "");
    Expect(1, 113824, '\P{Block:		-DUPLOYAN}', "");
    Expect(0, 113824, '\P{^Block:		-DUPLOYAN}', "");
    Error('\p{Blk=/a/duployan}');
    Error('\P{Blk=/a/duployan}');
    Expect(1, 113823, '\p{Blk=:\ADuployan\z:}', "");;
    Expect(0, 113824, '\p{Blk=:\ADuployan\z:}', "");;
    Expect(1, 113823, '\p{Blk:	duployan}', "");
    Expect(0, 113823, '\p{^Blk:	duployan}', "");
    Expect(0, 113823, '\P{Blk:	duployan}', "");
    Expect(1, 113823, '\P{^Blk:	duployan}', "");
    Expect(0, 113824, '\p{Blk:	duployan}', "");
    Expect(1, 113824, '\p{^Blk:	duployan}', "");
    Expect(1, 113824, '\P{Blk:	duployan}', "");
    Expect(0, 113824, '\P{^Blk:	duployan}', "");
    Expect(1, 113823, '\p{Blk=:\Aduployan\z:}', "");;
    Expect(0, 113824, '\p{Blk=:\Aduployan\z:}', "");;
    Expect(1, 113823, '\p{Blk=  duployan}', "");
    Expect(0, 113823, '\p{^Blk=  duployan}', "");
    Expect(0, 113823, '\P{Blk=  duployan}', "");
    Expect(1, 113823, '\P{^Blk=  duployan}', "");
    Expect(0, 113824, '\p{Blk=  duployan}', "");
    Expect(1, 113824, '\p{^Blk=  duployan}', "");
    Expect(1, 113824, '\P{Blk=  duployan}', "");
    Expect(0, 113824, '\P{^Blk=  duployan}', "");
    Error('\p{Is_Block=_Duployan:=}');
    Error('\P{Is_Block=_Duployan:=}');
    Expect(1, 113823, '\p{Is_Block=duployan}', "");
    Expect(0, 113823, '\p{^Is_Block=duployan}', "");
    Expect(0, 113823, '\P{Is_Block=duployan}', "");
    Expect(1, 113823, '\P{^Is_Block=duployan}', "");
    Expect(0, 113824, '\p{Is_Block=duployan}', "");
    Expect(1, 113824, '\p{^Is_Block=duployan}', "");
    Expect(1, 113824, '\P{Is_Block=duployan}', "");
    Expect(0, 113824, '\P{^Is_Block=duployan}', "");
    Expect(1, 113823, '\p{Is_Block=-	Duployan}', "");
    Expect(0, 113823, '\p{^Is_Block=-	Duployan}', "");
    Expect(0, 113823, '\P{Is_Block=-	Duployan}', "");
    Expect(1, 113823, '\P{^Is_Block=-	Duployan}', "");
    Expect(0, 113824, '\p{Is_Block=-	Duployan}', "");
    Expect(1, 113824, '\p{^Is_Block=-	Duployan}', "");
    Expect(1, 113824, '\P{Is_Block=-	Duployan}', "");
    Expect(0, 113824, '\P{^Is_Block=-	Duployan}', "");
    Error('\p{Is_Blk=:=_-Duployan}');
    Error('\P{Is_Blk=:=_-Duployan}');
    Expect(1, 113823, '\p{Is_Blk:   duployan}', "");
    Expect(0, 113823, '\p{^Is_Blk:   duployan}', "");
    Expect(0, 113823, '\P{Is_Blk:   duployan}', "");
    Expect(1, 113823, '\P{^Is_Blk:   duployan}', "");
    Expect(0, 113824, '\p{Is_Blk:   duployan}', "");
    Expect(1, 113824, '\p{^Is_Blk:   duployan}', "");
    Expect(1, 113824, '\P{Is_Blk:   duployan}', "");
    Expect(0, 113824, '\P{^Is_Blk:   duployan}', "");
    Expect(1, 113823, '\p{Is_Blk= duployan}', "");
    Expect(0, 113823, '\p{^Is_Blk= duployan}', "");
    Expect(0, 113823, '\P{Is_Blk= duployan}', "");
    Expect(1, 113823, '\P{^Is_Blk= duployan}', "");
    Expect(0, 113824, '\p{Is_Blk= duployan}', "");
    Expect(1, 113824, '\p{^Is_Blk= duployan}', "");
    Expect(1, 113824, '\P{Is_Blk= duployan}', "");
    Expect(0, 113824, '\P{^Is_Blk= duployan}', "");
    Error('\p{Block=:=__EARLY_Dynastic_CUNEIFORM}');
    Error('\P{Block=:=__EARLY_Dynastic_CUNEIFORM}');
    Expect(1, 75087, '\p{Block=:\AEarly_Dynastic_Cuneiform\z:}', "");;
    Expect(0, 75088, '\p{Block=:\AEarly_Dynastic_Cuneiform\z:}', "");;
    Expect(1, 75087, '\p{Block=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\p{^Block=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\P{Block=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\P{^Block=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\p{Block=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\p{^Block=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\P{Block=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\P{^Block=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\p{Block=:\Aearlydynasticcuneiform\z:}', "");;
    Expect(0, 75088, '\p{Block=:\Aearlydynasticcuneiform\z:}', "");;
    Expect(1, 75087, '\p{Block:  Early_Dynastic_cuneiform}', "");
    Expect(0, 75087, '\p{^Block:  Early_Dynastic_cuneiform}', "");
    Expect(0, 75087, '\P{Block:  Early_Dynastic_cuneiform}', "");
    Expect(1, 75087, '\P{^Block:  Early_Dynastic_cuneiform}', "");
    Expect(0, 75088, '\p{Block:  Early_Dynastic_cuneiform}', "");
    Expect(1, 75088, '\p{^Block:  Early_Dynastic_cuneiform}', "");
    Expect(1, 75088, '\P{Block:  Early_Dynastic_cuneiform}', "");
    Expect(0, 75088, '\P{^Block:  Early_Dynastic_cuneiform}', "");
    Error('\p{Blk=/a/		early_Dynastic_Cuneiform}');
    Error('\P{Blk=/a/		early_Dynastic_Cuneiform}');
    Expect(1, 75087, '\p{Blk=:\AEarly_Dynastic_Cuneiform\z:}', "");;
    Expect(0, 75088, '\p{Blk=:\AEarly_Dynastic_Cuneiform\z:}', "");;
    Expect(1, 75087, '\p{Blk=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\p{^Blk=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\P{Blk=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\P{^Blk=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\p{Blk=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\p{^Blk=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\P{Blk=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\P{^Blk=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\p{Blk=:\Aearlydynasticcuneiform\z:}', "");;
    Expect(0, 75088, '\p{Blk=:\Aearlydynasticcuneiform\z:}', "");;
    Expect(1, 75087, '\p{Blk=_early_Dynastic_Cuneiform}', "");
    Expect(0, 75087, '\p{^Blk=_early_Dynastic_Cuneiform}', "");
    Expect(0, 75087, '\P{Blk=_early_Dynastic_Cuneiform}', "");
    Expect(1, 75087, '\P{^Blk=_early_Dynastic_Cuneiform}', "");
    Expect(0, 75088, '\p{Blk=_early_Dynastic_Cuneiform}', "");
    Expect(1, 75088, '\p{^Blk=_early_Dynastic_Cuneiform}', "");
    Expect(1, 75088, '\P{Blk=_early_Dynastic_Cuneiform}', "");
    Expect(0, 75088, '\P{^Blk=_early_Dynastic_Cuneiform}', "");
    Error('\p{Is_Block=/a/	 early_DYNASTIC_Cuneiform}');
    Error('\P{Is_Block=/a/	 early_DYNASTIC_Cuneiform}');
    Expect(1, 75087, '\p{Is_Block=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\p{^Is_Block=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\P{Is_Block=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\P{^Is_Block=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\p{Is_Block=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\p{^Is_Block=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\P{Is_Block=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\P{^Is_Block=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\p{Is_Block= 	Early_Dynastic_Cuneiform}', "");
    Expect(0, 75087, '\p{^Is_Block= 	Early_Dynastic_Cuneiform}', "");
    Expect(0, 75087, '\P{Is_Block= 	Early_Dynastic_Cuneiform}', "");
    Expect(1, 75087, '\P{^Is_Block= 	Early_Dynastic_Cuneiform}', "");
    Expect(0, 75088, '\p{Is_Block= 	Early_Dynastic_Cuneiform}', "");
    Expect(1, 75088, '\p{^Is_Block= 	Early_Dynastic_Cuneiform}', "");
    Expect(1, 75088, '\P{Is_Block= 	Early_Dynastic_Cuneiform}', "");
    Expect(0, 75088, '\P{^Is_Block= 	Early_Dynastic_Cuneiform}', "");
    Error('\p{Is_Blk= early_DYNASTIC_Cuneiform:=}');
    Error('\P{Is_Blk= early_DYNASTIC_Cuneiform:=}');
    Expect(1, 75087, '\p{Is_Blk=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\p{^Is_Blk=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\P{Is_Blk=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\P{^Is_Blk=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\p{Is_Blk=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\p{^Is_Blk=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\P{Is_Blk=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\P{^Is_Blk=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\p{Is_Blk= early_DYNASTIC_Cuneiform}', "");
    Expect(0, 75087, '\p{^Is_Blk= early_DYNASTIC_Cuneiform}', "");
    Expect(0, 75087, '\P{Is_Blk= early_DYNASTIC_Cuneiform}', "");
    Expect(1, 75087, '\P{^Is_Blk= early_DYNASTIC_Cuneiform}', "");
    Expect(0, 75088, '\p{Is_Blk= early_DYNASTIC_Cuneiform}', "");
    Expect(1, 75088, '\p{^Is_Blk= early_DYNASTIC_Cuneiform}', "");
    Expect(1, 75088, '\P{Is_Blk= early_DYNASTIC_Cuneiform}', "");
    Expect(0, 75088, '\P{^Is_Blk= early_DYNASTIC_Cuneiform}', "");
    Error('\p{Block=:= -egyptian_HIEROGLYPH_FORMAT_controls}');
    Error('\P{Block=:= -egyptian_HIEROGLYPH_FORMAT_controls}');
    Expect(1, 78943, '\p{Block=:\AEgyptian_Hieroglyph_Format_Controls\z:}', "");;
    Expect(0, 78944, '\p{Block=:\AEgyptian_Hieroglyph_Format_Controls\z:}', "");;
    Expect(1, 78943, '\p{Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78943, '\p{^Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78943, '\P{Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78943, '\P{^Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78944, '\p{Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78944, '\p{^Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78944, '\P{Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78944, '\P{^Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78943, '\p{Block=:\Aegyptianhieroglyphformatcontrols\z:}', "");;
    Expect(0, 78944, '\p{Block=:\Aegyptianhieroglyphformatcontrols\z:}', "");;
    Expect(1, 78943, '\p{Block=_-egyptian_Hieroglyph_Format_controls}', "");
    Expect(0, 78943, '\p{^Block=_-egyptian_Hieroglyph_Format_controls}', "");
    Expect(0, 78943, '\P{Block=_-egyptian_Hieroglyph_Format_controls}', "");
    Expect(1, 78943, '\P{^Block=_-egyptian_Hieroglyph_Format_controls}', "");
    Expect(0, 78944, '\p{Block=_-egyptian_Hieroglyph_Format_controls}', "");
    Expect(1, 78944, '\p{^Block=_-egyptian_Hieroglyph_Format_controls}', "");
    Expect(1, 78944, '\P{Block=_-egyptian_Hieroglyph_Format_controls}', "");
    Expect(0, 78944, '\P{^Block=_-egyptian_Hieroglyph_Format_controls}', "");
    Error('\p{Blk:-Egyptian_HIEROGLYPH_FORMAT_Controls/a/}');
    Error('\P{Blk:-Egyptian_HIEROGLYPH_FORMAT_Controls/a/}');
    Expect(1, 78943, '\p{Blk=:\AEgyptian_Hieroglyph_Format_Controls\z:}', "");;
    Expect(0, 78944, '\p{Blk=:\AEgyptian_Hieroglyph_Format_Controls\z:}', "");;
    Expect(1, 78943, '\p{Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78943, '\p{^Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78943, '\P{Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78943, '\P{^Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78944, '\p{Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78944, '\p{^Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78944, '\P{Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78944, '\P{^Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78943, '\p{Blk=:\Aegyptianhieroglyphformatcontrols\z:}', "");;
    Expect(0, 78944, '\p{Blk=:\Aegyptianhieroglyphformatcontrols\z:}', "");;
    Expect(1, 78943, '\p{Blk=__EGYPTIAN_HIEROGLYPH_Format_controls}', "");
    Expect(0, 78943, '\p{^Blk=__EGYPTIAN_HIEROGLYPH_Format_controls}', "");
    Expect(0, 78943, '\P{Blk=__EGYPTIAN_HIEROGLYPH_Format_controls}', "");
    Expect(1, 78943, '\P{^Blk=__EGYPTIAN_HIEROGLYPH_Format_controls}', "");
    Expect(0, 78944, '\p{Blk=__EGYPTIAN_HIEROGLYPH_Format_controls}', "");
    Expect(1, 78944, '\p{^Blk=__EGYPTIAN_HIEROGLYPH_Format_controls}', "");
    Expect(1, 78944, '\P{Blk=__EGYPTIAN_HIEROGLYPH_Format_controls}', "");
    Expect(0, 78944, '\P{^Blk=__EGYPTIAN_HIEROGLYPH_Format_controls}', "");
    Error('\p{Is_Block=:=egyptian_Hieroglyph_format_Controls}');
    Error('\P{Is_Block=:=egyptian_Hieroglyph_format_Controls}');
    Expect(1, 78943, '\p{Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78943, '\p{^Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78943, '\P{Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78943, '\P{^Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78944, '\p{Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78944, '\p{^Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78944, '\P{Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78944, '\P{^Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78943, '\p{Is_Block=Egyptian_hieroglyph_FORMAT_CONTROLS}', "");
    Expect(0, 78943, '\p{^Is_Block=Egyptian_hieroglyph_FORMAT_CONTROLS}', "");
    Expect(0, 78943, '\P{Is_Block=Egyptian_hieroglyph_FORMAT_CONTROLS}', "");
    Expect(1, 78943, '\P{^Is_Block=Egyptian_hieroglyph_FORMAT_CONTROLS}', "");
    Expect(0, 78944, '\p{Is_Block=Egyptian_hieroglyph_FORMAT_CONTROLS}', "");
    Expect(1, 78944, '\p{^Is_Block=Egyptian_hieroglyph_FORMAT_CONTROLS}', "");
    Expect(1, 78944, '\P{Is_Block=Egyptian_hieroglyph_FORMAT_CONTROLS}', "");
    Expect(0, 78944, '\P{^Is_Block=Egyptian_hieroglyph_FORMAT_CONTROLS}', "");
    Error('\p{Is_Blk=:=_egyptian_hieroglyph_Format_Controls}');
    Error('\P{Is_Blk=:=_egyptian_hieroglyph_Format_Controls}');
    Expect(1, 78943, '\p{Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78943, '\p{^Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78943, '\P{Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78943, '\P{^Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78944, '\p{Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78944, '\p{^Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78944, '\P{Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78944, '\P{^Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78943, '\p{Is_Blk=	egyptian_HIEROGLYPH_Format_CONTROLS}', "");
    Expect(0, 78943, '\p{^Is_Blk=	egyptian_HIEROGLYPH_Format_CONTROLS}', "");
    Expect(0, 78943, '\P{Is_Blk=	egyptian_HIEROGLYPH_Format_CONTROLS}', "");
    Expect(1, 78943, '\P{^Is_Blk=	egyptian_HIEROGLYPH_Format_CONTROLS}', "");
    Expect(0, 78944, '\p{Is_Blk=	egyptian_HIEROGLYPH_Format_CONTROLS}', "");
    Expect(1, 78944, '\p{^Is_Blk=	egyptian_HIEROGLYPH_Format_CONTROLS}', "");
    Expect(1, 78944, '\P{Is_Blk=	egyptian_HIEROGLYPH_Format_CONTROLS}', "");
    Expect(0, 78944, '\P{^Is_Blk=	egyptian_HIEROGLYPH_Format_CONTROLS}', "");
    Error('\p{Block=/a/Egyptian_hieroglyphs}');
    Error('\P{Block=/a/Egyptian_hieroglyphs}');
    Expect(1, 78895, '\p{Block=:\AEgyptian_Hieroglyphs\z:}', "");;
    Expect(0, 78896, '\p{Block=:\AEgyptian_Hieroglyphs\z:}', "");;
    Expect(1, 78895, '\p{Block=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\p{^Block=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\P{Block=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\P{^Block=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\p{Block=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\p{^Block=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\P{Block=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\P{^Block=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\p{Block=:\Aegyptianhieroglyphs\z:}', "");;
    Expect(0, 78896, '\p{Block=:\Aegyptianhieroglyphs\z:}', "");;
    Expect(1, 78895, '\p{Block=_Egyptian_HIEROGLYPHS}', "");
    Expect(0, 78895, '\p{^Block=_Egyptian_HIEROGLYPHS}', "");
    Expect(0, 78895, '\P{Block=_Egyptian_HIEROGLYPHS}', "");
    Expect(1, 78895, '\P{^Block=_Egyptian_HIEROGLYPHS}', "");
    Expect(0, 78896, '\p{Block=_Egyptian_HIEROGLYPHS}', "");
    Expect(1, 78896, '\p{^Block=_Egyptian_HIEROGLYPHS}', "");
    Expect(1, 78896, '\P{Block=_Egyptian_HIEROGLYPHS}', "");
    Expect(0, 78896, '\P{^Block=_Egyptian_HIEROGLYPHS}', "");
    Error('\p{Blk=/a/		EGYPTIAN_hieroglyphs}');
    Error('\P{Blk=/a/		EGYPTIAN_hieroglyphs}');
    Expect(1, 78895, '\p{Blk=:\AEgyptian_Hieroglyphs\z:}', "");;
    Expect(0, 78896, '\p{Blk=:\AEgyptian_Hieroglyphs\z:}', "");;
    Expect(1, 78895, '\p{Blk=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\p{^Blk=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\P{Blk=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\P{^Blk=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\p{Blk=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\p{^Blk=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\P{Blk=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\P{^Blk=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\p{Blk=:\Aegyptianhieroglyphs\z:}', "");;
    Expect(0, 78896, '\p{Blk=:\Aegyptianhieroglyphs\z:}', "");;
    Expect(1, 78895, '\p{Blk=_	Egyptian_hieroglyphs}', "");
    Expect(0, 78895, '\p{^Blk=_	Egyptian_hieroglyphs}', "");
    Expect(0, 78895, '\P{Blk=_	Egyptian_hieroglyphs}', "");
    Expect(1, 78895, '\P{^Blk=_	Egyptian_hieroglyphs}', "");
    Expect(0, 78896, '\p{Blk=_	Egyptian_hieroglyphs}', "");
    Expect(1, 78896, '\p{^Blk=_	Egyptian_hieroglyphs}', "");
    Expect(1, 78896, '\P{Blk=_	Egyptian_hieroglyphs}', "");
    Expect(0, 78896, '\P{^Blk=_	Egyptian_hieroglyphs}', "");
    Error('\p{Is_Block=-	Egyptian_HIEROGLYPHS:=}');
    Error('\P{Is_Block=-	Egyptian_HIEROGLYPHS:=}');
    Expect(1, 78895, '\p{Is_Block=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\p{^Is_Block=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\P{Is_Block=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\P{^Is_Block=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\p{Is_Block=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\p{^Is_Block=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\P{Is_Block=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\P{^Is_Block=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\p{Is_Block=_	EGYPTIAN_hieroglyphs}', "");
    Expect(0, 78895, '\p{^Is_Block=_	EGYPTIAN_hieroglyphs}', "");
    Expect(0, 78895, '\P{Is_Block=_	EGYPTIAN_hieroglyphs}', "");
    Expect(1, 78895, '\P{^Is_Block=_	EGYPTIAN_hieroglyphs}', "");
    Expect(0, 78896, '\p{Is_Block=_	EGYPTIAN_hieroglyphs}', "");
    Expect(1, 78896, '\p{^Is_Block=_	EGYPTIAN_hieroglyphs}', "");
    Expect(1, 78896, '\P{Is_Block=_	EGYPTIAN_hieroglyphs}', "");
    Expect(0, 78896, '\P{^Is_Block=_	EGYPTIAN_hieroglyphs}', "");
    Error('\p{Is_Blk=-/a/egyptian_Hieroglyphs}');
    Error('\P{Is_Blk=-/a/egyptian_Hieroglyphs}');
    Expect(1, 78895, '\p{Is_Blk=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\p{^Is_Blk=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\P{Is_Blk=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\P{^Is_Blk=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\p{Is_Blk=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\p{^Is_Blk=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\P{Is_Blk=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\P{^Is_Blk=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\p{Is_Blk=--Egyptian_Hieroglyphs}', "");
    Expect(0, 78895, '\p{^Is_Blk=--Egyptian_Hieroglyphs}', "");
    Expect(0, 78895, '\P{Is_Blk=--Egyptian_Hieroglyphs}', "");
    Expect(1, 78895, '\P{^Is_Blk=--Egyptian_Hieroglyphs}', "");
    Expect(0, 78896, '\p{Is_Blk=--Egyptian_Hieroglyphs}', "");
    Expect(1, 78896, '\p{^Is_Blk=--Egyptian_Hieroglyphs}', "");
    Expect(1, 78896, '\P{Is_Blk=--Egyptian_Hieroglyphs}', "");
    Expect(0, 78896, '\P{^Is_Blk=--Egyptian_Hieroglyphs}', "");
    Error('\p{Block=_-elbasan:=}');
    Error('\P{Block=_-elbasan:=}');
    Expect(1, 66863, '\p{Block=:\AElbasan\z:}', "");;
    Expect(0, 66864, '\p{Block=:\AElbasan\z:}', "");;
    Expect(1, 66863, '\p{Block=elbasan}', "");
    Expect(0, 66863, '\p{^Block=elbasan}', "");
    Expect(0, 66863, '\P{Block=elbasan}', "");
    Expect(1, 66863, '\P{^Block=elbasan}', "");
    Expect(0, 66864, '\p{Block=elbasan}', "");
    Expect(1, 66864, '\p{^Block=elbasan}', "");
    Expect(1, 66864, '\P{Block=elbasan}', "");
    Expect(0, 66864, '\P{^Block=elbasan}', "");
    Expect(1, 66863, '\p{Block=:\Aelbasan\z:}', "");;
    Expect(0, 66864, '\p{Block=:\Aelbasan\z:}', "");;
    Expect(1, 66863, '\p{Block=--Elbasan}', "");
    Expect(0, 66863, '\p{^Block=--Elbasan}', "");
    Expect(0, 66863, '\P{Block=--Elbasan}', "");
    Expect(1, 66863, '\P{^Block=--Elbasan}', "");
    Expect(0, 66864, '\p{Block=--Elbasan}', "");
    Expect(1, 66864, '\p{^Block=--Elbasan}', "");
    Expect(1, 66864, '\P{Block=--Elbasan}', "");
    Expect(0, 66864, '\P{^Block=--Elbasan}', "");
    Error('\p{Blk=/a/	 Elbasan}');
    Error('\P{Blk=/a/	 Elbasan}');
    Expect(1, 66863, '\p{Blk=:\AElbasan\z:}', "");;
    Expect(0, 66864, '\p{Blk=:\AElbasan\z:}', "");;
    Expect(1, 66863, '\p{Blk=elbasan}', "");
    Expect(0, 66863, '\p{^Blk=elbasan}', "");
    Expect(0, 66863, '\P{Blk=elbasan}', "");
    Expect(1, 66863, '\P{^Blk=elbasan}', "");
    Expect(0, 66864, '\p{Blk=elbasan}', "");
    Expect(1, 66864, '\p{^Blk=elbasan}', "");
    Expect(1, 66864, '\P{Blk=elbasan}', "");
    Expect(0, 66864, '\P{^Blk=elbasan}', "");
    Expect(1, 66863, '\p{Blk=:\Aelbasan\z:}', "");;
    Expect(0, 66864, '\p{Blk=:\Aelbasan\z:}', "");;
    Expect(1, 66863, '\p{Blk= 	Elbasan}', "");
    Expect(0, 66863, '\p{^Blk= 	Elbasan}', "");
    Expect(0, 66863, '\P{Blk= 	Elbasan}', "");
    Expect(1, 66863, '\P{^Blk= 	Elbasan}', "");
    Expect(0, 66864, '\p{Blk= 	Elbasan}', "");
    Expect(1, 66864, '\p{^Blk= 	Elbasan}', "");
    Expect(1, 66864, '\P{Blk= 	Elbasan}', "");
    Expect(0, 66864, '\P{^Blk= 	Elbasan}', "");
    Error('\p{Is_Block=:=-	elbasan}');
    Error('\P{Is_Block=:=-	elbasan}');
    Expect(1, 66863, '\p{Is_Block=elbasan}', "");
    Expect(0, 66863, '\p{^Is_Block=elbasan}', "");
    Expect(0, 66863, '\P{Is_Block=elbasan}', "");
    Expect(1, 66863, '\P{^Is_Block=elbasan}', "");
    Expect(0, 66864, '\p{Is_Block=elbasan}', "");
    Expect(1, 66864, '\p{^Is_Block=elbasan}', "");
    Expect(1, 66864, '\P{Is_Block=elbasan}', "");
    Expect(0, 66864, '\P{^Is_Block=elbasan}', "");
    Expect(1, 66863, '\p{Is_Block:   -Elbasan}', "");
    Expect(0, 66863, '\p{^Is_Block:   -Elbasan}', "");
    Expect(0, 66863, '\P{Is_Block:   -Elbasan}', "");
    Expect(1, 66863, '\P{^Is_Block:   -Elbasan}', "");
    Expect(0, 66864, '\p{Is_Block:   -Elbasan}', "");
    Expect(1, 66864, '\p{^Is_Block:   -Elbasan}', "");
    Expect(1, 66864, '\P{Is_Block:   -Elbasan}', "");
    Expect(0, 66864, '\P{^Is_Block:   -Elbasan}', "");
    Error('\p{Is_Blk=:= -elbasan}');
    Error('\P{Is_Blk=:= -elbasan}');
    Expect(1, 66863, '\p{Is_Blk=elbasan}', "");
    Expect(0, 66863, '\p{^Is_Blk=elbasan}', "");
    Expect(0, 66863, '\P{Is_Blk=elbasan}', "");
    Expect(1, 66863, '\P{^Is_Blk=elbasan}', "");
    Expect(0, 66864, '\p{Is_Blk=elbasan}', "");
    Expect(1, 66864, '\p{^Is_Blk=elbasan}', "");
    Expect(1, 66864, '\P{Is_Blk=elbasan}', "");
    Expect(0, 66864, '\P{^Is_Blk=elbasan}', "");
    Expect(1, 66863, '\p{Is_Blk:   -elbasan}', "");
    Expect(0, 66863, '\p{^Is_Blk:   -elbasan}', "");
    Expect(0, 66863, '\P{Is_Blk:   -elbasan}', "");
    Expect(1, 66863, '\P{^Is_Blk:   -elbasan}', "");
    Expect(0, 66864, '\p{Is_Blk:   -elbasan}', "");
    Expect(1, 66864, '\p{^Is_Blk:   -elbasan}', "");
    Expect(1, 66864, '\P{Is_Blk:   -elbasan}', "");
    Expect(0, 66864, '\P{^Is_Blk:   -elbasan}', "");
    Error('\p{Block=:= ELYMAIC}');
    Error('\P{Block=:= ELYMAIC}');
    Expect(1, 69631, '\p{Block=:\AElymaic\z:}', "");;
    Expect(0, 69632, '\p{Block=:\AElymaic\z:}', "");;
    Expect(1, 69631, '\p{Block=elymaic}', "");
    Expect(0, 69631, '\p{^Block=elymaic}', "");
    Expect(0, 69631, '\P{Block=elymaic}', "");
    Expect(1, 69631, '\P{^Block=elymaic}', "");
    Expect(0, 69632, '\p{Block=elymaic}', "");
    Expect(1, 69632, '\p{^Block=elymaic}', "");
    Expect(1, 69632, '\P{Block=elymaic}', "");
    Expect(0, 69632, '\P{^Block=elymaic}', "");
    Expect(1, 69631, '\p{Block=:\Aelymaic\z:}', "");;
    Expect(0, 69632, '\p{Block=:\Aelymaic\z:}', "");;
    Expect(1, 69631, '\p{Block: -	Elymaic}', "");
    Expect(0, 69631, '\p{^Block: -	Elymaic}', "");
    Expect(0, 69631, '\P{Block: -	Elymaic}', "");
    Expect(1, 69631, '\P{^Block: -	Elymaic}', "");
    Expect(0, 69632, '\p{Block: -	Elymaic}', "");
    Expect(1, 69632, '\p{^Block: -	Elymaic}', "");
    Expect(1, 69632, '\P{Block: -	Elymaic}', "");
    Expect(0, 69632, '\P{^Block: -	Elymaic}', "");
    Error('\p{Blk= :=elymaic}');
    Error('\P{Blk= :=elymaic}');
    Expect(1, 69631, '\p{Blk=:\AElymaic\z:}', "");;
    Expect(0, 69632, '\p{Blk=:\AElymaic\z:}', "");;
    Expect(1, 69631, '\p{Blk=elymaic}', "");
    Expect(0, 69631, '\p{^Blk=elymaic}', "");
    Expect(0, 69631, '\P{Blk=elymaic}', "");
    Expect(1, 69631, '\P{^Blk=elymaic}', "");
    Expect(0, 69632, '\p{Blk=elymaic}', "");
    Expect(1, 69632, '\p{^Blk=elymaic}', "");
    Expect(1, 69632, '\P{Blk=elymaic}', "");
    Expect(0, 69632, '\P{^Blk=elymaic}', "");
    Expect(1, 69631, '\p{Blk=:\Aelymaic\z:}', "");;
    Expect(0, 69632, '\p{Blk=:\Aelymaic\z:}', "");;
    Expect(1, 69631, '\p{Blk=	Elymaic}', "");
    Expect(0, 69631, '\p{^Blk=	Elymaic}', "");
    Expect(0, 69631, '\P{Blk=	Elymaic}', "");
    Expect(1, 69631, '\P{^Blk=	Elymaic}', "");
    Expect(0, 69632, '\p{Blk=	Elymaic}', "");
    Expect(1, 69632, '\p{^Blk=	Elymaic}', "");
    Expect(1, 69632, '\P{Blk=	Elymaic}', "");
    Expect(0, 69632, '\P{^Blk=	Elymaic}', "");
    Error('\p{Is_Block= Elymaic:=}');
    Error('\P{Is_Block= Elymaic:=}');
    Expect(1, 69631, '\p{Is_Block:elymaic}', "");
    Expect(0, 69631, '\p{^Is_Block:elymaic}', "");
    Expect(0, 69631, '\P{Is_Block:elymaic}', "");
    Expect(1, 69631, '\P{^Is_Block:elymaic}', "");
    Expect(0, 69632, '\p{Is_Block:elymaic}', "");
    Expect(1, 69632, '\p{^Is_Block:elymaic}', "");
    Expect(1, 69632, '\P{Is_Block:elymaic}', "");
    Expect(0, 69632, '\P{^Is_Block:elymaic}', "");
    Expect(1, 69631, '\p{Is_Block=-_ELYMAIC}', "");
    Expect(0, 69631, '\p{^Is_Block=-_ELYMAIC}', "");
    Expect(0, 69631, '\P{Is_Block=-_ELYMAIC}', "");
    Expect(1, 69631, '\P{^Is_Block=-_ELYMAIC}', "");
    Expect(0, 69632, '\p{Is_Block=-_ELYMAIC}', "");
    Expect(1, 69632, '\p{^Is_Block=-_ELYMAIC}', "");
    Expect(1, 69632, '\P{Is_Block=-_ELYMAIC}', "");
    Expect(0, 69632, '\P{^Is_Block=-_ELYMAIC}', "");
    Error('\p{Is_Blk=/a/Elymaic}');
    Error('\P{Is_Blk=/a/Elymaic}');
    Expect(1, 69631, '\p{Is_Blk=elymaic}', "");
    Expect(0, 69631, '\p{^Is_Blk=elymaic}', "");
    Expect(0, 69631, '\P{Is_Blk=elymaic}', "");
    Expect(1, 69631, '\P{^Is_Blk=elymaic}', "");
    Expect(0, 69632, '\p{Is_Blk=elymaic}', "");
    Expect(1, 69632, '\p{^Is_Blk=elymaic}', "");
    Expect(1, 69632, '\P{Is_Blk=elymaic}', "");
    Expect(0, 69632, '\P{^Is_Blk=elymaic}', "");
    Expect(1, 69631, '\p{Is_Blk= -elymaic}', "");
    Expect(0, 69631, '\p{^Is_Blk= -elymaic}', "");
    Expect(0, 69631, '\P{Is_Blk= -elymaic}', "");
    Expect(1, 69631, '\P{^Is_Blk= -elymaic}', "");
    Expect(0, 69632, '\p{Is_Blk= -elymaic}', "");
    Expect(1, 69632, '\p{^Is_Blk= -elymaic}', "");
    Expect(1, 69632, '\P{Is_Blk= -elymaic}', "");
    Expect(0, 69632, '\P{^Is_Blk= -elymaic}', "");
    Error('\p{Block=:=__EMOTICONS}');
    Error('\P{Block=:=__EMOTICONS}');
    Expect(1, 128591, '\p{Block=:\AEmoticons\z:}', "");;
    Expect(0, 128592, '\p{Block=:\AEmoticons\z:}', "");;
    Expect(1, 128591, '\p{Block=emoticons}', "");
    Expect(0, 128591, '\p{^Block=emoticons}', "");
    Expect(0, 128591, '\P{Block=emoticons}', "");
    Expect(1, 128591, '\P{^Block=emoticons}', "");
    Expect(0, 128592, '\p{Block=emoticons}', "");
    Expect(1, 128592, '\p{^Block=emoticons}', "");
    Expect(1, 128592, '\P{Block=emoticons}', "");
    Expect(0, 128592, '\P{^Block=emoticons}', "");
    Expect(1, 128591, '\p{Block=:\Aemoticons\z:}', "");;
    Expect(0, 128592, '\p{Block=:\Aemoticons\z:}', "");;
    Expect(1, 128591, '\p{Block= emoticons}', "");
    Expect(0, 128591, '\p{^Block= emoticons}', "");
    Expect(0, 128591, '\P{Block= emoticons}', "");
    Expect(1, 128591, '\P{^Block= emoticons}', "");
    Expect(0, 128592, '\p{Block= emoticons}', "");
    Expect(1, 128592, '\p{^Block= emoticons}', "");
    Expect(1, 128592, '\P{Block= emoticons}', "");
    Expect(0, 128592, '\P{^Block= emoticons}', "");
    Error('\p{Blk=:=_ emoticons}');
    Error('\P{Blk=:=_ emoticons}');
    Expect(1, 128591, '\p{Blk=:\AEmoticons\z:}', "");;
    Expect(0, 128592, '\p{Blk=:\AEmoticons\z:}', "");;
    Expect(1, 128591, '\p{Blk:emoticons}', "");
    Expect(0, 128591, '\p{^Blk:emoticons}', "");
    Expect(0, 128591, '\P{Blk:emoticons}', "");
    Expect(1, 128591, '\P{^Blk:emoticons}', "");
    Expect(0, 128592, '\p{Blk:emoticons}', "");
    Expect(1, 128592, '\p{^Blk:emoticons}', "");
    Expect(1, 128592, '\P{Blk:emoticons}', "");
    Expect(0, 128592, '\P{^Blk:emoticons}', "");
    Expect(1, 128591, '\p{Blk=:\Aemoticons\z:}', "");;
    Expect(0, 128592, '\p{Blk=:\Aemoticons\z:}', "");;
    Expect(1, 128591, '\p{Blk=	emoticons}', "");
    Expect(0, 128591, '\p{^Blk=	emoticons}', "");
    Expect(0, 128591, '\P{Blk=	emoticons}', "");
    Expect(1, 128591, '\P{^Blk=	emoticons}', "");
    Expect(0, 128592, '\p{Blk=	emoticons}', "");
    Expect(1, 128592, '\p{^Blk=	emoticons}', "");
    Expect(1, 128592, '\P{Blk=	emoticons}', "");
    Expect(0, 128592, '\P{^Blk=	emoticons}', "");
    Error('\p{Is_Block=-/a/Emoticons}');
    Error('\P{Is_Block=-/a/Emoticons}');
    Expect(1, 128591, '\p{Is_Block=emoticons}', "");
    Expect(0, 128591, '\p{^Is_Block=emoticons}', "");
    Expect(0, 128591, '\P{Is_Block=emoticons}', "");
    Expect(1, 128591, '\P{^Is_Block=emoticons}', "");
    Expect(0, 128592, '\p{Is_Block=emoticons}', "");
    Expect(1, 128592, '\p{^Is_Block=emoticons}', "");
    Expect(1, 128592, '\P{Is_Block=emoticons}', "");
    Expect(0, 128592, '\P{^Is_Block=emoticons}', "");
    Expect(1, 128591, '\p{Is_Block=  EMOTICONS}', "");
    Expect(0, 128591, '\p{^Is_Block=  EMOTICONS}', "");
    Expect(0, 128591, '\P{Is_Block=  EMOTICONS}', "");
    Expect(1, 128591, '\P{^Is_Block=  EMOTICONS}', "");
    Expect(0, 128592, '\p{Is_Block=  EMOTICONS}', "");
    Expect(1, 128592, '\p{^Is_Block=  EMOTICONS}', "");
    Expect(1, 128592, '\P{Is_Block=  EMOTICONS}', "");
    Expect(0, 128592, '\P{^Is_Block=  EMOTICONS}', "");
    Error('\p{Is_Blk=	:=Emoticons}');
    Error('\P{Is_Blk=	:=Emoticons}');
    Expect(1, 128591, '\p{Is_Blk=emoticons}', "");
    Expect(0, 128591, '\p{^Is_Blk=emoticons}', "");
    Expect(0, 128591, '\P{Is_Blk=emoticons}', "");
    Expect(1, 128591, '\P{^Is_Blk=emoticons}', "");
    Expect(0, 128592, '\p{Is_Blk=emoticons}', "");
    Expect(1, 128592, '\p{^Is_Blk=emoticons}', "");
    Expect(1, 128592, '\P{Is_Blk=emoticons}', "");
    Expect(0, 128592, '\P{^Is_Blk=emoticons}', "");
    Expect(1, 128591, '\p{Is_Blk=	EMOTICONS}', "");
    Expect(0, 128591, '\p{^Is_Blk=	EMOTICONS}', "");
    Expect(0, 128591, '\P{Is_Blk=	EMOTICONS}', "");
    Expect(1, 128591, '\P{^Is_Blk=	EMOTICONS}', "");
    Expect(0, 128592, '\p{Is_Blk=	EMOTICONS}', "");
    Expect(1, 128592, '\p{^Is_Blk=	EMOTICONS}', "");
    Expect(1, 128592, '\P{Is_Blk=	EMOTICONS}', "");
    Expect(0, 128592, '\P{^Is_Blk=	EMOTICONS}', "");
    Error('\p{Block: /a/ Enclosed_Alphanumerics}');
    Error('\P{Block: /a/ Enclosed_Alphanumerics}');
    Expect(1, 9471, '\p{Block=:\AEnclosed_Alphanumerics\z:}', "");;
    Expect(0, 9472, '\p{Block=:\AEnclosed_Alphanumerics\z:}', "");;
    Expect(1, 9471, '\p{Block=enclosedalphanumerics}', "");
    Expect(0, 9471, '\p{^Block=enclosedalphanumerics}', "");
    Expect(0, 9471, '\P{Block=enclosedalphanumerics}', "");
    Expect(1, 9471, '\P{^Block=enclosedalphanumerics}', "");
    Expect(0, 9472, '\p{Block=enclosedalphanumerics}', "");
    Expect(1, 9472, '\p{^Block=enclosedalphanumerics}', "");
    Expect(1, 9472, '\P{Block=enclosedalphanumerics}', "");
    Expect(0, 9472, '\P{^Block=enclosedalphanumerics}', "");
    Expect(1, 9471, '\p{Block=:\Aenclosedalphanumerics\z:}', "");;
    Expect(0, 9472, '\p{Block=:\Aenclosedalphanumerics\z:}', "");;
    Expect(1, 9471, '\p{Block=- Enclosed_alphanumerics}', "");
    Expect(0, 9471, '\p{^Block=- Enclosed_alphanumerics}', "");
    Expect(0, 9471, '\P{Block=- Enclosed_alphanumerics}', "");
    Expect(1, 9471, '\P{^Block=- Enclosed_alphanumerics}', "");
    Expect(0, 9472, '\p{Block=- Enclosed_alphanumerics}', "");
    Expect(1, 9472, '\p{^Block=- Enclosed_alphanumerics}', "");
    Expect(1, 9472, '\P{Block=- Enclosed_alphanumerics}', "");
    Expect(0, 9472, '\P{^Block=- Enclosed_alphanumerics}', "");
    Error('\p{Blk=:=_ENCLOSED_ALPHANUM}');
    Error('\P{Blk=:=_ENCLOSED_ALPHANUM}');
    Expect(1, 9471, '\p{Blk=:\AEnclosed_Alphanum\z:}', "");;
    Expect(0, 9472, '\p{Blk=:\AEnclosed_Alphanum\z:}', "");;
    Expect(1, 9471, '\p{Blk=enclosedalphanum}', "");
    Expect(0, 9471, '\p{^Blk=enclosedalphanum}', "");
    Expect(0, 9471, '\P{Blk=enclosedalphanum}', "");
    Expect(1, 9471, '\P{^Blk=enclosedalphanum}', "");
    Expect(0, 9472, '\p{Blk=enclosedalphanum}', "");
    Expect(1, 9472, '\p{^Blk=enclosedalphanum}', "");
    Expect(1, 9472, '\P{Blk=enclosedalphanum}', "");
    Expect(0, 9472, '\P{^Blk=enclosedalphanum}', "");
    Expect(1, 9471, '\p{Blk=:\Aenclosedalphanum\z:}', "");;
    Expect(0, 9472, '\p{Blk=:\Aenclosedalphanum\z:}', "");;
    Expect(1, 9471, '\p{Blk=__enclosed_Alphanum}', "");
    Expect(0, 9471, '\p{^Blk=__enclosed_Alphanum}', "");
    Expect(0, 9471, '\P{Blk=__enclosed_Alphanum}', "");
    Expect(1, 9471, '\P{^Blk=__enclosed_Alphanum}', "");
    Expect(0, 9472, '\p{Blk=__enclosed_Alphanum}', "");
    Expect(1, 9472, '\p{^Blk=__enclosed_Alphanum}', "");
    Expect(1, 9472, '\P{Blk=__enclosed_Alphanum}', "");
    Expect(0, 9472, '\P{^Blk=__enclosed_Alphanum}', "");
    Error('\p{Is_Block=:= Enclosed_Alphanumerics}');
    Error('\P{Is_Block=:= Enclosed_Alphanumerics}');
    Expect(1, 9471, '\p{Is_Block=enclosedalphanumerics}', "");
    Expect(0, 9471, '\p{^Is_Block=enclosedalphanumerics}', "");
    Expect(0, 9471, '\P{Is_Block=enclosedalphanumerics}', "");
    Expect(1, 9471, '\P{^Is_Block=enclosedalphanumerics}', "");
    Expect(0, 9472, '\p{Is_Block=enclosedalphanumerics}', "");
    Expect(1, 9472, '\p{^Is_Block=enclosedalphanumerics}', "");
    Expect(1, 9472, '\P{Is_Block=enclosedalphanumerics}', "");
    Expect(0, 9472, '\P{^Is_Block=enclosedalphanumerics}', "");
    Expect(1, 9471, '\p{Is_Block= Enclosed_Alphanumerics}', "");
    Expect(0, 9471, '\p{^Is_Block= Enclosed_Alphanumerics}', "");
    Expect(0, 9471, '\P{Is_Block= Enclosed_Alphanumerics}', "");
    Expect(1, 9471, '\P{^Is_Block= Enclosed_Alphanumerics}', "");
    Expect(0, 9472, '\p{Is_Block= Enclosed_Alphanumerics}', "");
    Expect(1, 9472, '\p{^Is_Block= Enclosed_Alphanumerics}', "");
    Expect(1, 9472, '\P{Is_Block= Enclosed_Alphanumerics}', "");
    Expect(0, 9472, '\P{^Is_Block= Enclosed_Alphanumerics}', "");
    Error('\p{Is_Blk=-/a/enclosed_Alphanum}');
    Error('\P{Is_Blk=-/a/enclosed_Alphanum}');
    Expect(1, 9471, '\p{Is_Blk=enclosedalphanum}', "");
    Expect(0, 9471, '\p{^Is_Blk=enclosedalphanum}', "");
    Expect(0, 9471, '\P{Is_Blk=enclosedalphanum}', "");
    Expect(1, 9471, '\P{^Is_Blk=enclosedalphanum}', "");
    Expect(0, 9472, '\p{Is_Blk=enclosedalphanum}', "");
    Expect(1, 9472, '\p{^Is_Blk=enclosedalphanum}', "");
    Expect(1, 9472, '\P{Is_Blk=enclosedalphanum}', "");
    Expect(0, 9472, '\P{^Is_Blk=enclosedalphanum}', "");
    Expect(1, 9471, '\p{Is_Blk= _Enclosed_ALPHANUM}', "");
    Expect(0, 9471, '\p{^Is_Blk= _Enclosed_ALPHANUM}', "");
    Expect(0, 9471, '\P{Is_Blk= _Enclosed_ALPHANUM}', "");
    Expect(1, 9471, '\P{^Is_Blk= _Enclosed_ALPHANUM}', "");
    Expect(0, 9472, '\p{Is_Blk= _Enclosed_ALPHANUM}', "");
    Expect(1, 9472, '\p{^Is_Blk= _Enclosed_ALPHANUM}', "");
    Expect(1, 9472, '\P{Is_Blk= _Enclosed_ALPHANUM}', "");
    Expect(0, 9472, '\P{^Is_Blk= _Enclosed_ALPHANUM}', "");
    Error('\p{Block=/a/_Enclosed_ALPHANUMERIC_Supplement}');
    Error('\P{Block=/a/_Enclosed_ALPHANUMERIC_Supplement}');
    Expect(1, 127487, '\p{Block=:\AEnclosed_Alphanumeric_Supplement\z:}', "");;
    Expect(0, 127488, '\p{Block=:\AEnclosed_Alphanumeric_Supplement\z:}', "");;
    Expect(1, 127487, '\p{Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127487, '\p{^Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127487, '\P{Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127487, '\P{^Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127488, '\p{Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127488, '\p{^Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127488, '\P{Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127488, '\P{^Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127487, '\p{Block=:\Aenclosedalphanumericsupplement\z:}', "");;
    Expect(0, 127488, '\p{Block=:\Aenclosedalphanumericsupplement\z:}', "");;
    Expect(1, 127487, '\p{Block:		 Enclosed_Alphanumeric_Supplement}', "");
    Expect(0, 127487, '\p{^Block:		 Enclosed_Alphanumeric_Supplement}', "");
    Expect(0, 127487, '\P{Block:		 Enclosed_Alphanumeric_Supplement}', "");
    Expect(1, 127487, '\P{^Block:		 Enclosed_Alphanumeric_Supplement}', "");
    Expect(0, 127488, '\p{Block:		 Enclosed_Alphanumeric_Supplement}', "");
    Expect(1, 127488, '\p{^Block:		 Enclosed_Alphanumeric_Supplement}', "");
    Expect(1, 127488, '\P{Block:		 Enclosed_Alphanumeric_Supplement}', "");
    Expect(0, 127488, '\P{^Block:		 Enclosed_Alphanumeric_Supplement}', "");
    Error('\p{Blk=_ENCLOSED_ALPHANUM_Sup/a/}');
    Error('\P{Blk=_ENCLOSED_ALPHANUM_Sup/a/}');
    Expect(1, 127487, '\p{Blk=:\AEnclosed_Alphanum_Sup\z:}', "");;
    Expect(0, 127488, '\p{Blk=:\AEnclosed_Alphanum_Sup\z:}', "");;
    Expect(1, 127487, '\p{Blk=enclosedalphanumsup}', "");
    Expect(0, 127487, '\p{^Blk=enclosedalphanumsup}', "");
    Expect(0, 127487, '\P{Blk=enclosedalphanumsup}', "");
    Expect(1, 127487, '\P{^Blk=enclosedalphanumsup}', "");
    Expect(0, 127488, '\p{Blk=enclosedalphanumsup}', "");
    Expect(1, 127488, '\p{^Blk=enclosedalphanumsup}', "");
    Expect(1, 127488, '\P{Blk=enclosedalphanumsup}', "");
    Expect(0, 127488, '\P{^Blk=enclosedalphanumsup}', "");
    Expect(1, 127487, '\p{Blk=:\Aenclosedalphanumsup\z:}', "");;
    Expect(0, 127488, '\p{Blk=:\Aenclosedalphanumsup\z:}', "");;
    Expect(1, 127487, '\p{Blk=	 enclosed_Alphanum_Sup}', "");
    Expect(0, 127487, '\p{^Blk=	 enclosed_Alphanum_Sup}', "");
    Expect(0, 127487, '\P{Blk=	 enclosed_Alphanum_Sup}', "");
    Expect(1, 127487, '\P{^Blk=	 enclosed_Alphanum_Sup}', "");
    Expect(0, 127488, '\p{Blk=	 enclosed_Alphanum_Sup}', "");
    Expect(1, 127488, '\p{^Blk=	 enclosed_Alphanum_Sup}', "");
    Expect(1, 127488, '\P{Blk=	 enclosed_Alphanum_Sup}', "");
    Expect(0, 127488, '\P{^Blk=	 enclosed_Alphanum_Sup}', "");
    Error('\p{Is_Block:	/a/-	ENCLOSED_alphanumeric_Supplement}');
    Error('\P{Is_Block:	/a/-	ENCLOSED_alphanumeric_Supplement}');
    Expect(1, 127487, '\p{Is_Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127487, '\p{^Is_Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127487, '\P{Is_Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127487, '\P{^Is_Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127488, '\p{Is_Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127488, '\p{^Is_Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127488, '\P{Is_Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127488, '\P{^Is_Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127487, '\p{Is_Block= -Enclosed_alphanumeric_Supplement}', "");
    Expect(0, 127487, '\p{^Is_Block= -Enclosed_alphanumeric_Supplement}', "");
    Expect(0, 127487, '\P{Is_Block= -Enclosed_alphanumeric_Supplement}', "");
    Expect(1, 127487, '\P{^Is_Block= -Enclosed_alphanumeric_Supplement}', "");
    Expect(0, 127488, '\p{Is_Block= -Enclosed_alphanumeric_Supplement}', "");
    Expect(1, 127488, '\p{^Is_Block= -Enclosed_alphanumeric_Supplement}', "");
    Expect(1, 127488, '\P{Is_Block= -Enclosed_alphanumeric_Supplement}', "");
    Expect(0, 127488, '\P{^Is_Block= -Enclosed_alphanumeric_Supplement}', "");
    Error('\p{Is_Blk=:=  ENCLOSED_Alphanum_SUP}');
    Error('\P{Is_Blk=:=  ENCLOSED_Alphanum_SUP}');
    Expect(1, 127487, '\p{Is_Blk=enclosedalphanumsup}', "");
    Expect(0, 127487, '\p{^Is_Blk=enclosedalphanumsup}', "");
    Expect(0, 127487, '\P{Is_Blk=enclosedalphanumsup}', "");
    Expect(1, 127487, '\P{^Is_Blk=enclosedalphanumsup}', "");
    Expect(0, 127488, '\p{Is_Blk=enclosedalphanumsup}', "");
    Expect(1, 127488, '\p{^Is_Blk=enclosedalphanumsup}', "");
    Expect(1, 127488, '\P{Is_Blk=enclosedalphanumsup}', "");
    Expect(0, 127488, '\P{^Is_Blk=enclosedalphanumsup}', "");
    Expect(1, 127487, '\p{Is_Blk=_ ENCLOSED_alphanum_Sup}', "");
    Expect(0, 127487, '\p{^Is_Blk=_ ENCLOSED_alphanum_Sup}', "");
    Expect(0, 127487, '\P{Is_Blk=_ ENCLOSED_alphanum_Sup}', "");
    Expect(1, 127487, '\P{^Is_Blk=_ ENCLOSED_alphanum_Sup}', "");
    Expect(0, 127488, '\p{Is_Blk=_ ENCLOSED_alphanum_Sup}', "");
    Expect(1, 127488, '\p{^Is_Blk=_ ENCLOSED_alphanum_Sup}', "");
    Expect(1, 127488, '\P{Is_Blk=_ ENCLOSED_alphanum_Sup}', "");
    Expect(0, 127488, '\P{^Is_Blk=_ ENCLOSED_alphanum_Sup}', "");
    Error('\p{Block=	Enclosed_CJK_Letters_And_Months:=}');
    Error('\P{Block=	Enclosed_CJK_Letters_And_Months:=}');
    Expect(1, 13055, '\p{Block=:\AEnclosed_CJK_Letters_And_Months\z:}', "");;
    Expect(0, 13056, '\p{Block=:\AEnclosed_CJK_Letters_And_Months\z:}', "");;
    Expect(1, 13055, '\p{Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13055, '\p{^Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13055, '\P{Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13055, '\P{^Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13056, '\p{Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13056, '\p{^Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13056, '\P{Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13056, '\P{^Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13055, '\p{Block=:\Aenclosedcjklettersandmonths\z:}', "");;
    Expect(0, 13056, '\p{Block=:\Aenclosedcjklettersandmonths\z:}', "");;
    Expect(1, 13055, '\p{Block=  enclosed_CJK_LETTERS_And_Months}', "");
    Expect(0, 13055, '\p{^Block=  enclosed_CJK_LETTERS_And_Months}', "");
    Expect(0, 13055, '\P{Block=  enclosed_CJK_LETTERS_And_Months}', "");
    Expect(1, 13055, '\P{^Block=  enclosed_CJK_LETTERS_And_Months}', "");
    Expect(0, 13056, '\p{Block=  enclosed_CJK_LETTERS_And_Months}', "");
    Expect(1, 13056, '\p{^Block=  enclosed_CJK_LETTERS_And_Months}', "");
    Expect(1, 13056, '\P{Block=  enclosed_CJK_LETTERS_And_Months}', "");
    Expect(0, 13056, '\P{^Block=  enclosed_CJK_LETTERS_And_Months}', "");
    Error('\p{Blk=-_Enclosed_CJK:=}');
    Error('\P{Blk=-_Enclosed_CJK:=}');
    Expect(1, 13055, '\p{Blk=:\AEnclosed_CJK\z:}', "");;
    Expect(0, 13056, '\p{Blk=:\AEnclosed_CJK\z:}', "");;
    Expect(1, 13055, '\p{Blk=enclosedcjk}', "");
    Expect(0, 13055, '\p{^Blk=enclosedcjk}', "");
    Expect(0, 13055, '\P{Blk=enclosedcjk}', "");
    Expect(1, 13055, '\P{^Blk=enclosedcjk}', "");
    Expect(0, 13056, '\p{Blk=enclosedcjk}', "");
    Expect(1, 13056, '\p{^Blk=enclosedcjk}', "");
    Expect(1, 13056, '\P{Blk=enclosedcjk}', "");
    Expect(0, 13056, '\P{^Blk=enclosedcjk}', "");
    Expect(1, 13055, '\p{Blk=:\Aenclosedcjk\z:}', "");;
    Expect(0, 13056, '\p{Blk=:\Aenclosedcjk\z:}', "");;
    Expect(1, 13055, '\p{Blk= -enclosed_cjk}', "");
    Expect(0, 13055, '\p{^Blk= -enclosed_cjk}', "");
    Expect(0, 13055, '\P{Blk= -enclosed_cjk}', "");
    Expect(1, 13055, '\P{^Blk= -enclosed_cjk}', "");
    Expect(0, 13056, '\p{Blk= -enclosed_cjk}', "");
    Expect(1, 13056, '\p{^Blk= -enclosed_cjk}', "");
    Expect(1, 13056, '\P{Blk= -enclosed_cjk}', "");
    Expect(0, 13056, '\P{^Blk= -enclosed_cjk}', "");
    Error('\p{Is_Block=:=-Enclosed_cjk_letters_And_Months}');
    Error('\P{Is_Block=:=-Enclosed_cjk_letters_And_Months}');
    Expect(1, 13055, '\p{Is_Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13055, '\p{^Is_Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13055, '\P{Is_Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13055, '\P{^Is_Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13056, '\p{Is_Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13056, '\p{^Is_Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13056, '\P{Is_Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13056, '\P{^Is_Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13055, '\p{Is_Block=-Enclosed_CJK_LETTERS_And_Months}', "");
    Expect(0, 13055, '\p{^Is_Block=-Enclosed_CJK_LETTERS_And_Months}', "");
    Expect(0, 13055, '\P{Is_Block=-Enclosed_CJK_LETTERS_And_Months}', "");
    Expect(1, 13055, '\P{^Is_Block=-Enclosed_CJK_LETTERS_And_Months}', "");
    Expect(0, 13056, '\p{Is_Block=-Enclosed_CJK_LETTERS_And_Months}', "");
    Expect(1, 13056, '\p{^Is_Block=-Enclosed_CJK_LETTERS_And_Months}', "");
    Expect(1, 13056, '\P{Is_Block=-Enclosed_CJK_LETTERS_And_Months}', "");
    Expect(0, 13056, '\P{^Is_Block=-Enclosed_CJK_LETTERS_And_Months}', "");
    Error('\p{Is_Blk=__Enclosed_CJK/a/}');
    Error('\P{Is_Blk=__Enclosed_CJK/a/}');
    Expect(1, 13055, '\p{Is_Blk=enclosedcjk}', "");
    Expect(0, 13055, '\p{^Is_Blk=enclosedcjk}', "");
    Expect(0, 13055, '\P{Is_Blk=enclosedcjk}', "");
    Expect(1, 13055, '\P{^Is_Blk=enclosedcjk}', "");
    Expect(0, 13056, '\p{Is_Blk=enclosedcjk}', "");
    Expect(1, 13056, '\p{^Is_Blk=enclosedcjk}', "");
    Expect(1, 13056, '\P{Is_Blk=enclosedcjk}', "");
    Expect(0, 13056, '\P{^Is_Blk=enclosedcjk}', "");
    Expect(1, 13055, '\p{Is_Blk=		Enclosed_CJK}', "");
    Expect(0, 13055, '\p{^Is_Blk=		Enclosed_CJK}', "");
    Expect(0, 13055, '\P{Is_Blk=		Enclosed_CJK}', "");
    Expect(1, 13055, '\P{^Is_Blk=		Enclosed_CJK}', "");
    Expect(0, 13056, '\p{Is_Blk=		Enclosed_CJK}', "");
    Expect(1, 13056, '\p{^Is_Blk=		Enclosed_CJK}', "");
    Expect(1, 13056, '\P{Is_Blk=		Enclosed_CJK}', "");
    Expect(0, 13056, '\P{^Is_Blk=		Enclosed_CJK}', "");
    Error('\p{Block=	/a/Enclosed_Ideographic_Supplement}');
    Error('\P{Block=	/a/Enclosed_Ideographic_Supplement}');
    Expect(1, 127743, '\p{Block=:\AEnclosed_Ideographic_Supplement\z:}', "");;
    Expect(0, 127744, '\p{Block=:\AEnclosed_Ideographic_Supplement\z:}', "");;
    Expect(1, 127743, '\p{Block=enclosedideographicsupplement}', "");
    Expect(0, 127743, '\p{^Block=enclosedideographicsupplement}', "");
    Expect(0, 127743, '\P{Block=enclosedideographicsupplement}', "");
    Expect(1, 127743, '\P{^Block=enclosedideographicsupplement}', "");
    Expect(0, 127744, '\p{Block=enclosedideographicsupplement}', "");
    Expect(1, 127744, '\p{^Block=enclosedideographicsupplement}', "");
    Expect(1, 127744, '\P{Block=enclosedideographicsupplement}', "");
    Expect(0, 127744, '\P{^Block=enclosedideographicsupplement}', "");
    Expect(1, 127743, '\p{Block=:\Aenclosedideographicsupplement\z:}', "");;
    Expect(0, 127744, '\p{Block=:\Aenclosedideographicsupplement\z:}', "");;
    Expect(1, 127743, '\p{Block=_Enclosed_IDEOGRAPHIC_Supplement}', "");
    Expect(0, 127743, '\p{^Block=_Enclosed_IDEOGRAPHIC_Supplement}', "");
    Expect(0, 127743, '\P{Block=_Enclosed_IDEOGRAPHIC_Supplement}', "");
    Expect(1, 127743, '\P{^Block=_Enclosed_IDEOGRAPHIC_Supplement}', "");
    Expect(0, 127744, '\p{Block=_Enclosed_IDEOGRAPHIC_Supplement}', "");
    Expect(1, 127744, '\p{^Block=_Enclosed_IDEOGRAPHIC_Supplement}', "");
    Expect(1, 127744, '\P{Block=_Enclosed_IDEOGRAPHIC_Supplement}', "");
    Expect(0, 127744, '\P{^Block=_Enclosed_IDEOGRAPHIC_Supplement}', "");
    Error('\p{Blk=_ENCLOSED_ideographic_Sup/a/}');
    Error('\P{Blk=_ENCLOSED_ideographic_Sup/a/}');
    Expect(1, 127743, '\p{Blk=:\AEnclosed_Ideographic_Sup\z:}', "");;
    Expect(0, 127744, '\p{Blk=:\AEnclosed_Ideographic_Sup\z:}', "");;
    Expect(1, 127743, '\p{Blk:enclosedideographicsup}', "");
    Expect(0, 127743, '\p{^Blk:enclosedideographicsup}', "");
    Expect(0, 127743, '\P{Blk:enclosedideographicsup}', "");
    Expect(1, 127743, '\P{^Blk:enclosedideographicsup}', "");
    Expect(0, 127744, '\p{Blk:enclosedideographicsup}', "");
    Expect(1, 127744, '\p{^Blk:enclosedideographicsup}', "");
    Expect(1, 127744, '\P{Blk:enclosedideographicsup}', "");
    Expect(0, 127744, '\P{^Blk:enclosedideographicsup}', "");
    Expect(1, 127743, '\p{Blk=:\Aenclosedideographicsup\z:}', "");;
    Expect(0, 127744, '\p{Blk=:\Aenclosedideographicsup\z:}', "");;
    Expect(1, 127743, '\p{Blk=- Enclosed_ideographic_SUP}', "");
    Expect(0, 127743, '\p{^Blk=- Enclosed_ideographic_SUP}', "");
    Expect(0, 127743, '\P{Blk=- Enclosed_ideographic_SUP}', "");
    Expect(1, 127743, '\P{^Blk=- Enclosed_ideographic_SUP}', "");
    Expect(0, 127744, '\p{Blk=- Enclosed_ideographic_SUP}', "");
    Expect(1, 127744, '\p{^Blk=- Enclosed_ideographic_SUP}', "");
    Expect(1, 127744, '\P{Blk=- Enclosed_ideographic_SUP}', "");
    Expect(0, 127744, '\P{^Blk=- Enclosed_ideographic_SUP}', "");
    Error('\p{Is_Block=_Enclosed_IDEOGRAPHIC_supplement:=}');
    Error('\P{Is_Block=_Enclosed_IDEOGRAPHIC_supplement:=}');
    Expect(1, 127743, '\p{Is_Block=enclosedideographicsupplement}', "");
    Expect(0, 127743, '\p{^Is_Block=enclosedideographicsupplement}', "");
    Expect(0, 127743, '\P{Is_Block=enclosedideographicsupplement}', "");
    Expect(1, 127743, '\P{^Is_Block=enclosedideographicsupplement}', "");
    Expect(0, 127744, '\p{Is_Block=enclosedideographicsupplement}', "");
    Expect(1, 127744, '\p{^Is_Block=enclosedideographicsupplement}', "");
    Expect(1, 127744, '\P{Is_Block=enclosedideographicsupplement}', "");
    Expect(0, 127744, '\P{^Is_Block=enclosedideographicsupplement}', "");
    Expect(1, 127743, '\p{Is_Block=-ENCLOSED_Ideographic_Supplement}', "");
    Expect(0, 127743, '\p{^Is_Block=-ENCLOSED_Ideographic_Supplement}', "");
    Expect(0, 127743, '\P{Is_Block=-ENCLOSED_Ideographic_Supplement}', "");
    Expect(1, 127743, '\P{^Is_Block=-ENCLOSED_Ideographic_Supplement}', "");
    Expect(0, 127744, '\p{Is_Block=-ENCLOSED_Ideographic_Supplement}', "");
    Expect(1, 127744, '\p{^Is_Block=-ENCLOSED_Ideographic_Supplement}', "");
    Expect(1, 127744, '\P{Is_Block=-ENCLOSED_Ideographic_Supplement}', "");
    Expect(0, 127744, '\P{^Is_Block=-ENCLOSED_Ideographic_Supplement}', "");
    Error('\p{Is_Blk=/a/-enclosed_Ideographic_Sup}');
    Error('\P{Is_Blk=/a/-enclosed_Ideographic_Sup}');
    Expect(1, 127743, '\p{Is_Blk=enclosedideographicsup}', "");
    Expect(0, 127743, '\p{^Is_Blk=enclosedideographicsup}', "");
    Expect(0, 127743, '\P{Is_Blk=enclosedideographicsup}', "");
    Expect(1, 127743, '\P{^Is_Blk=enclosedideographicsup}', "");
    Expect(0, 127744, '\p{Is_Blk=enclosedideographicsup}', "");
    Expect(1, 127744, '\p{^Is_Blk=enclosedideographicsup}', "");
    Expect(1, 127744, '\P{Is_Blk=enclosedideographicsup}', "");
    Expect(0, 127744, '\P{^Is_Blk=enclosedideographicsup}', "");
    Expect(1, 127743, '\p{Is_Blk=_	Enclosed_Ideographic_sup}', "");
    Expect(0, 127743, '\p{^Is_Blk=_	Enclosed_Ideographic_sup}', "");
    Expect(0, 127743, '\P{Is_Blk=_	Enclosed_Ideographic_sup}', "");
    Expect(1, 127743, '\P{^Is_Blk=_	Enclosed_Ideographic_sup}', "");
    Expect(0, 127744, '\p{Is_Blk=_	Enclosed_Ideographic_sup}', "");
    Expect(1, 127744, '\p{^Is_Blk=_	Enclosed_Ideographic_sup}', "");
    Expect(1, 127744, '\P{Is_Blk=_	Enclosed_Ideographic_sup}', "");
    Expect(0, 127744, '\P{^Is_Blk=_	Enclosed_Ideographic_sup}', "");
    Error('\p{Block=-ETHIOPIC/a/}');
    Error('\P{Block=-ETHIOPIC/a/}');
    Expect(1, 4991, '\p{Block=:\AEthiopic\z:}', "");;
    Expect(0, 4992, '\p{Block=:\AEthiopic\z:}', "");;
    Expect(1, 4991, '\p{Block=ethiopic}', "");
    Expect(0, 4991, '\p{^Block=ethiopic}', "");
    Expect(0, 4991, '\P{Block=ethiopic}', "");
    Expect(1, 4991, '\P{^Block=ethiopic}', "");
    Expect(0, 4992, '\p{Block=ethiopic}', "");
    Expect(1, 4992, '\p{^Block=ethiopic}', "");
    Expect(1, 4992, '\P{Block=ethiopic}', "");
    Expect(0, 4992, '\P{^Block=ethiopic}', "");
    Expect(1, 4991, '\p{Block=:\Aethiopic\z:}', "");;
    Expect(0, 4992, '\p{Block=:\Aethiopic\z:}', "");;
    Expect(1, 4991, '\p{Block= Ethiopic}', "");
    Expect(0, 4991, '\p{^Block= Ethiopic}', "");
    Expect(0, 4991, '\P{Block= Ethiopic}', "");
    Expect(1, 4991, '\P{^Block= Ethiopic}', "");
    Expect(0, 4992, '\p{Block= Ethiopic}', "");
    Expect(1, 4992, '\p{^Block= Ethiopic}', "");
    Expect(1, 4992, '\P{Block= Ethiopic}', "");
    Expect(0, 4992, '\P{^Block= Ethiopic}', "");
    Error('\p{Blk=/a/-_Ethiopic}');
    Error('\P{Blk=/a/-_Ethiopic}');
    Expect(1, 4991, '\p{Blk=:\AEthiopic\z:}', "");;
    Expect(0, 4992, '\p{Blk=:\AEthiopic\z:}', "");;
    Expect(1, 4991, '\p{Blk=ethiopic}', "");
    Expect(0, 4991, '\p{^Blk=ethiopic}', "");
    Expect(0, 4991, '\P{Blk=ethiopic}', "");
    Expect(1, 4991, '\P{^Blk=ethiopic}', "");
    Expect(0, 4992, '\p{Blk=ethiopic}', "");
    Expect(1, 4992, '\p{^Blk=ethiopic}', "");
    Expect(1, 4992, '\P{Blk=ethiopic}', "");
    Expect(0, 4992, '\P{^Blk=ethiopic}', "");
    Expect(1, 4991, '\p{Blk=:\Aethiopic\z:}', "");;
    Expect(0, 4992, '\p{Blk=:\Aethiopic\z:}', "");;
    Expect(1, 4991, '\p{Blk=_ Ethiopic}', "");
    Expect(0, 4991, '\p{^Blk=_ Ethiopic}', "");
    Expect(0, 4991, '\P{Blk=_ Ethiopic}', "");
    Expect(1, 4991, '\P{^Blk=_ Ethiopic}', "");
    Expect(0, 4992, '\p{Blk=_ Ethiopic}', "");
    Expect(1, 4992, '\p{^Blk=_ Ethiopic}', "");
    Expect(1, 4992, '\P{Blk=_ Ethiopic}', "");
    Expect(0, 4992, '\P{^Blk=_ Ethiopic}', "");
    Error('\p{Is_Block=_Ethiopic/a/}');
    Error('\P{Is_Block=_Ethiopic/a/}');
    Expect(1, 4991, '\p{Is_Block=ethiopic}', "");
    Expect(0, 4991, '\p{^Is_Block=ethiopic}', "");
    Expect(0, 4991, '\P{Is_Block=ethiopic}', "");
    Expect(1, 4991, '\P{^Is_Block=ethiopic}', "");
    Expect(0, 4992, '\p{Is_Block=ethiopic}', "");
    Expect(1, 4992, '\p{^Is_Block=ethiopic}', "");
    Expect(1, 4992, '\P{Is_Block=ethiopic}', "");
    Expect(0, 4992, '\P{^Is_Block=ethiopic}', "");
    Expect(1, 4991, '\p{Is_Block=-_Ethiopic}', "");
    Expect(0, 4991, '\p{^Is_Block=-_Ethiopic}', "");
    Expect(0, 4991, '\P{Is_Block=-_Ethiopic}', "");
    Expect(1, 4991, '\P{^Is_Block=-_Ethiopic}', "");
    Expect(0, 4992, '\p{Is_Block=-_Ethiopic}', "");
    Expect(1, 4992, '\p{^Is_Block=-_Ethiopic}', "");
    Expect(1, 4992, '\P{Is_Block=-_Ethiopic}', "");
    Expect(0, 4992, '\P{^Is_Block=-_Ethiopic}', "");
    Error('\p{Is_Blk=	/a/Ethiopic}');
    Error('\P{Is_Blk=	/a/Ethiopic}');
    Expect(1, 4991, '\p{Is_Blk:	ethiopic}', "");
    Expect(0, 4991, '\p{^Is_Blk:	ethiopic}', "");
    Expect(0, 4991, '\P{Is_Blk:	ethiopic}', "");
    Expect(1, 4991, '\P{^Is_Blk:	ethiopic}', "");
    Expect(0, 4992, '\p{Is_Blk:	ethiopic}', "");
    Expect(1, 4992, '\p{^Is_Blk:	ethiopic}', "");
    Expect(1, 4992, '\P{Is_Blk:	ethiopic}', "");
    Expect(0, 4992, '\P{^Is_Blk:	ethiopic}', "");
    Expect(1, 4991, '\p{Is_Blk= Ethiopic}', "");
    Expect(0, 4991, '\p{^Is_Blk= Ethiopic}', "");
    Expect(0, 4991, '\P{Is_Blk= Ethiopic}', "");
    Expect(1, 4991, '\P{^Is_Blk= Ethiopic}', "");
    Expect(0, 4992, '\p{Is_Blk= Ethiopic}', "");
    Expect(1, 4992, '\p{^Is_Blk= Ethiopic}', "");
    Expect(1, 4992, '\P{Is_Blk= Ethiopic}', "");
    Expect(0, 4992, '\P{^Is_Blk= Ethiopic}', "");
    Error('\p{Block=  Ethiopic_Extended:=}');
    Error('\P{Block=  Ethiopic_Extended:=}');
    Expect(1, 11743, '\p{Block=:\AEthiopic_Extended\z:}', "");;
    Expect(0, 11744, '\p{Block=:\AEthiopic_Extended\z:}', "");;
    Expect(1, 11743, '\p{Block=ethiopicextended}', "");
    Expect(0, 11743, '\p{^Block=ethiopicextended}', "");
    Expect(0, 11743, '\P{Block=ethiopicextended}', "");
    Expect(1, 11743, '\P{^Block=ethiopicextended}', "");
    Expect(0, 11744, '\p{Block=ethiopicextended}', "");
    Expect(1, 11744, '\p{^Block=ethiopicextended}', "");
    Expect(1, 11744, '\P{Block=ethiopicextended}', "");
    Expect(0, 11744, '\P{^Block=ethiopicextended}', "");
    Expect(1, 11743, '\p{Block=:\Aethiopicextended\z:}', "");;
    Expect(0, 11744, '\p{Block=:\Aethiopicextended\z:}', "");;
    Expect(1, 11743, '\p{Block=_ethiopic_Extended}', "");
    Expect(0, 11743, '\p{^Block=_ethiopic_Extended}', "");
    Expect(0, 11743, '\P{Block=_ethiopic_Extended}', "");
    Expect(1, 11743, '\P{^Block=_ethiopic_Extended}', "");
    Expect(0, 11744, '\p{Block=_ethiopic_Extended}', "");
    Expect(1, 11744, '\p{^Block=_ethiopic_Extended}', "");
    Expect(1, 11744, '\P{Block=_ethiopic_Extended}', "");
    Expect(0, 11744, '\P{^Block=_ethiopic_Extended}', "");
    Error('\p{Blk= /a/ETHIOPIC_Ext}');
    Error('\P{Blk= /a/ETHIOPIC_Ext}');
    Expect(1, 11743, '\p{Blk=:\AEthiopic_Ext\z:}', "");;
    Expect(0, 11744, '\p{Blk=:\AEthiopic_Ext\z:}', "");;
    Expect(1, 11743, '\p{Blk=ethiopicext}', "");
    Expect(0, 11743, '\p{^Blk=ethiopicext}', "");
    Expect(0, 11743, '\P{Blk=ethiopicext}', "");
    Expect(1, 11743, '\P{^Blk=ethiopicext}', "");
    Expect(0, 11744, '\p{Blk=ethiopicext}', "");
    Expect(1, 11744, '\p{^Blk=ethiopicext}', "");
    Expect(1, 11744, '\P{Blk=ethiopicext}', "");
    Expect(0, 11744, '\P{^Blk=ethiopicext}', "");
    Expect(1, 11743, '\p{Blk=:\Aethiopicext\z:}', "");;
    Expect(0, 11744, '\p{Blk=:\Aethiopicext\z:}', "");;
    Expect(1, 11743, '\p{Blk=_ethiopic_Ext}', "");
    Expect(0, 11743, '\p{^Blk=_ethiopic_Ext}', "");
    Expect(0, 11743, '\P{Blk=_ethiopic_Ext}', "");
    Expect(1, 11743, '\P{^Blk=_ethiopic_Ext}', "");
    Expect(0, 11744, '\p{Blk=_ethiopic_Ext}', "");
    Expect(1, 11744, '\p{^Blk=_ethiopic_Ext}', "");
    Expect(1, 11744, '\P{Blk=_ethiopic_Ext}', "");
    Expect(0, 11744, '\P{^Blk=_ethiopic_Ext}', "");
    Error('\p{Is_Block=:=Ethiopic_extended}');
    Error('\P{Is_Block=:=Ethiopic_extended}');
    Expect(1, 11743, '\p{Is_Block=ethiopicextended}', "");
    Expect(0, 11743, '\p{^Is_Block=ethiopicextended}', "");
    Expect(0, 11743, '\P{Is_Block=ethiopicextended}', "");
    Expect(1, 11743, '\P{^Is_Block=ethiopicextended}', "");
    Expect(0, 11744, '\p{Is_Block=ethiopicextended}', "");
    Expect(1, 11744, '\p{^Is_Block=ethiopicextended}', "");
    Expect(1, 11744, '\P{Is_Block=ethiopicextended}', "");
    Expect(0, 11744, '\P{^Is_Block=ethiopicextended}', "");
    Expect(1, 11743, '\p{Is_Block: -ETHIOPIC_Extended}', "");
    Expect(0, 11743, '\p{^Is_Block: -ETHIOPIC_Extended}', "");
    Expect(0, 11743, '\P{Is_Block: -ETHIOPIC_Extended}', "");
    Expect(1, 11743, '\P{^Is_Block: -ETHIOPIC_Extended}', "");
    Expect(0, 11744, '\p{Is_Block: -ETHIOPIC_Extended}', "");
    Expect(1, 11744, '\p{^Is_Block: -ETHIOPIC_Extended}', "");
    Expect(1, 11744, '\P{Is_Block: -ETHIOPIC_Extended}', "");
    Expect(0, 11744, '\P{^Is_Block: -ETHIOPIC_Extended}', "");
    Error('\p{Is_Blk=/a/ 	ETHIOPIC_Ext}');
    Error('\P{Is_Blk=/a/ 	ETHIOPIC_Ext}');
    Expect(1, 11743, '\p{Is_Blk=ethiopicext}', "");
    Expect(0, 11743, '\p{^Is_Blk=ethiopicext}', "");
    Expect(0, 11743, '\P{Is_Blk=ethiopicext}', "");
    Expect(1, 11743, '\P{^Is_Blk=ethiopicext}', "");
    Expect(0, 11744, '\p{Is_Blk=ethiopicext}', "");
    Expect(1, 11744, '\p{^Is_Blk=ethiopicext}', "");
    Expect(1, 11744, '\P{Is_Blk=ethiopicext}', "");
    Expect(0, 11744, '\P{^Is_Blk=ethiopicext}', "");
    Expect(1, 11743, '\p{Is_Blk= -Ethiopic_EXT}', "");
    Expect(0, 11743, '\p{^Is_Blk= -Ethiopic_EXT}', "");
    Expect(0, 11743, '\P{Is_Blk= -Ethiopic_EXT}', "");
    Expect(1, 11743, '\P{^Is_Blk= -Ethiopic_EXT}', "");
    Expect(0, 11744, '\p{Is_Blk= -Ethiopic_EXT}', "");
    Expect(1, 11744, '\p{^Is_Blk= -Ethiopic_EXT}', "");
    Expect(1, 11744, '\P{Is_Blk= -Ethiopic_EXT}', "");
    Expect(0, 11744, '\P{^Is_Blk= -Ethiopic_EXT}', "");
    Error('\p{Block=/a/Ethiopic_Extended_a}');
    Error('\P{Block=/a/Ethiopic_Extended_a}');
    Expect(1, 43823, '\p{Block=:\AEthiopic_Extended_A\z:}', "");;
    Expect(0, 43824, '\p{Block=:\AEthiopic_Extended_A\z:}', "");;
    Expect(1, 43823, '\p{Block:	ethiopicextendeda}', "");
    Expect(0, 43823, '\p{^Block:	ethiopicextendeda}', "");
    Expect(0, 43823, '\P{Block:	ethiopicextendeda}', "");
    Expect(1, 43823, '\P{^Block:	ethiopicextendeda}', "");
    Expect(0, 43824, '\p{Block:	ethiopicextendeda}', "");
    Expect(1, 43824, '\p{^Block:	ethiopicextendeda}', "");
    Expect(1, 43824, '\P{Block:	ethiopicextendeda}', "");
    Expect(0, 43824, '\P{^Block:	ethiopicextendeda}', "");
    Expect(1, 43823, '\p{Block=:\Aethiopicextendeda\z:}', "");;
    Expect(0, 43824, '\p{Block=:\Aethiopicextendeda\z:}', "");;
    Expect(1, 43823, '\p{Block=	-ethiopic_Extended_A}', "");
    Expect(0, 43823, '\p{^Block=	-ethiopic_Extended_A}', "");
    Expect(0, 43823, '\P{Block=	-ethiopic_Extended_A}', "");
    Expect(1, 43823, '\P{^Block=	-ethiopic_Extended_A}', "");
    Expect(0, 43824, '\p{Block=	-ethiopic_Extended_A}', "");
    Expect(1, 43824, '\p{^Block=	-ethiopic_Extended_A}', "");
    Expect(1, 43824, '\P{Block=	-ethiopic_Extended_A}', "");
    Expect(0, 43824, '\P{^Block=	-ethiopic_Extended_A}', "");
    Error('\p{Blk:/a/_ ETHIOPIC_ext_A}');
    Error('\P{Blk:/a/_ ETHIOPIC_ext_A}');
    Expect(1, 43823, '\p{Blk=:\AEthiopic_Ext_A\z:}', "");;
    Expect(0, 43824, '\p{Blk=:\AEthiopic_Ext_A\z:}', "");;
    Expect(1, 43823, '\p{Blk=ethiopicexta}', "");
    Expect(0, 43823, '\p{^Blk=ethiopicexta}', "");
    Expect(0, 43823, '\P{Blk=ethiopicexta}', "");
    Expect(1, 43823, '\P{^Blk=ethiopicexta}', "");
    Expect(0, 43824, '\p{Blk=ethiopicexta}', "");
    Expect(1, 43824, '\p{^Blk=ethiopicexta}', "");
    Expect(1, 43824, '\P{Blk=ethiopicexta}', "");
    Expect(0, 43824, '\P{^Blk=ethiopicexta}', "");
    Expect(1, 43823, '\p{Blk=:\Aethiopicexta\z:}', "");;
    Expect(0, 43824, '\p{Blk=:\Aethiopicexta\z:}', "");;
    Expect(1, 43823, '\p{Blk:    ETHIOPIC_EXT_a}', "");
    Expect(0, 43823, '\p{^Blk:    ETHIOPIC_EXT_a}', "");
    Expect(0, 43823, '\P{Blk:    ETHIOPIC_EXT_a}', "");
    Expect(1, 43823, '\P{^Blk:    ETHIOPIC_EXT_a}', "");
    Expect(0, 43824, '\p{Blk:    ETHIOPIC_EXT_a}', "");
    Expect(1, 43824, '\p{^Blk:    ETHIOPIC_EXT_a}', "");
    Expect(1, 43824, '\P{Blk:    ETHIOPIC_EXT_a}', "");
    Expect(0, 43824, '\P{^Blk:    ETHIOPIC_EXT_a}', "");
    Error('\p{Is_Block:_/a/ETHIOPIC_EXTENDED_a}');
    Error('\P{Is_Block:_/a/ETHIOPIC_EXTENDED_a}');
    Expect(1, 43823, '\p{Is_Block=ethiopicextendeda}', "");
    Expect(0, 43823, '\p{^Is_Block=ethiopicextendeda}', "");
    Expect(0, 43823, '\P{Is_Block=ethiopicextendeda}', "");
    Expect(1, 43823, '\P{^Is_Block=ethiopicextendeda}', "");
    Expect(0, 43824, '\p{Is_Block=ethiopicextendeda}', "");
    Expect(1, 43824, '\p{^Is_Block=ethiopicextendeda}', "");
    Expect(1, 43824, '\P{Is_Block=ethiopicextendeda}', "");
    Expect(0, 43824, '\P{^Is_Block=ethiopicextendeda}', "");
    Expect(1, 43823, '\p{Is_Block=__ethiopic_extended_A}', "");
    Expect(0, 43823, '\p{^Is_Block=__ethiopic_extended_A}', "");
    Expect(0, 43823, '\P{Is_Block=__ethiopic_extended_A}', "");
    Expect(1, 43823, '\P{^Is_Block=__ethiopic_extended_A}', "");
    Expect(0, 43824, '\p{Is_Block=__ethiopic_extended_A}', "");
    Expect(1, 43824, '\p{^Is_Block=__ethiopic_extended_A}', "");
    Expect(1, 43824, '\P{Is_Block=__ethiopic_extended_A}', "");
    Expect(0, 43824, '\P{^Is_Block=__ethiopic_extended_A}', "");
    Error('\p{Is_Blk=	_ETHIOPIC_Ext_A/a/}');
    Error('\P{Is_Blk=	_ETHIOPIC_Ext_A/a/}');
    Expect(1, 43823, '\p{Is_Blk=ethiopicexta}', "");
    Expect(0, 43823, '\p{^Is_Blk=ethiopicexta}', "");
    Expect(0, 43823, '\P{Is_Blk=ethiopicexta}', "");
    Expect(1, 43823, '\P{^Is_Blk=ethiopicexta}', "");
    Expect(0, 43824, '\p{Is_Blk=ethiopicexta}', "");
    Expect(1, 43824, '\p{^Is_Blk=ethiopicexta}', "");
    Expect(1, 43824, '\P{Is_Blk=ethiopicexta}', "");
    Expect(0, 43824, '\P{^Is_Blk=ethiopicexta}', "");
    Expect(1, 43823, '\p{Is_Blk:    -Ethiopic_EXT_A}', "");
    Expect(0, 43823, '\p{^Is_Blk:    -Ethiopic_EXT_A}', "");
    Expect(0, 43823, '\P{Is_Blk:    -Ethiopic_EXT_A}', "");
    Expect(1, 43823, '\P{^Is_Blk:    -Ethiopic_EXT_A}', "");
    Expect(0, 43824, '\p{Is_Blk:    -Ethiopic_EXT_A}', "");
    Expect(1, 43824, '\p{^Is_Blk:    -Ethiopic_EXT_A}', "");
    Expect(1, 43824, '\P{Is_Blk:    -Ethiopic_EXT_A}', "");
    Expect(0, 43824, '\P{^Is_Blk:    -Ethiopic_EXT_A}', "");
    Error('\p{Block= Ethiopic_EXTENDED_b:=}');
    Error('\P{Block= Ethiopic_EXTENDED_b:=}');
    Expect(1, 124927, '\p{Block=:\AEthiopic_Extended_B\z:}', "");;
    Expect(0, 124928, '\p{Block=:\AEthiopic_Extended_B\z:}', "");;
    Expect(1, 124927, '\p{Block=ethiopicextendedb}', "");
    Expect(0, 124927, '\p{^Block=ethiopicextendedb}', "");
    Expect(0, 124927, '\P{Block=ethiopicextendedb}', "");
    Expect(1, 124927, '\P{^Block=ethiopicextendedb}', "");
    Expect(0, 124928, '\p{Block=ethiopicextendedb}', "");
    Expect(1, 124928, '\p{^Block=ethiopicextendedb}', "");
    Expect(1, 124928, '\P{Block=ethiopicextendedb}', "");
    Expect(0, 124928, '\P{^Block=ethiopicextendedb}', "");
    Expect(1, 124927, '\p{Block=:\Aethiopicextendedb\z:}', "");;
    Expect(0, 124928, '\p{Block=:\Aethiopicextendedb\z:}', "");;
    Expect(1, 124927, '\p{Block=Ethiopic_extended_b}', "");
    Expect(0, 124927, '\p{^Block=Ethiopic_extended_b}', "");
    Expect(0, 124927, '\P{Block=Ethiopic_extended_b}', "");
    Expect(1, 124927, '\P{^Block=Ethiopic_extended_b}', "");
    Expect(0, 124928, '\p{Block=Ethiopic_extended_b}', "");
    Expect(1, 124928, '\p{^Block=Ethiopic_extended_b}', "");
    Expect(1, 124928, '\P{Block=Ethiopic_extended_b}', "");
    Expect(0, 124928, '\P{^Block=Ethiopic_extended_b}', "");
    Error('\p{Blk=-:=Ethiopic_Ext_B}');
    Error('\P{Blk=-:=Ethiopic_Ext_B}');
    Expect(1, 124927, '\p{Blk=:\AEthiopic_Ext_B\z:}', "");;
    Expect(0, 124928, '\p{Blk=:\AEthiopic_Ext_B\z:}', "");;
    Expect(1, 124927, '\p{Blk=ethiopicextb}', "");
    Expect(0, 124927, '\p{^Blk=ethiopicextb}', "");
    Expect(0, 124927, '\P{Blk=ethiopicextb}', "");
    Expect(1, 124927, '\P{^Blk=ethiopicextb}', "");
    Expect(0, 124928, '\p{Blk=ethiopicextb}', "");
    Expect(1, 124928, '\p{^Blk=ethiopicextb}', "");
    Expect(1, 124928, '\P{Blk=ethiopicextb}', "");
    Expect(0, 124928, '\P{^Blk=ethiopicextb}', "");
    Expect(1, 124927, '\p{Blk=:\Aethiopicextb\z:}', "");;
    Expect(0, 124928, '\p{Blk=:\Aethiopicextb\z:}', "");;
    Expect(1, 124927, '\p{Blk=-ethiopic_Ext_b}', "");
    Expect(0, 124927, '\p{^Blk=-ethiopic_Ext_b}', "");
    Expect(0, 124927, '\P{Blk=-ethiopic_Ext_b}', "");
    Expect(1, 124927, '\P{^Blk=-ethiopic_Ext_b}', "");
    Expect(0, 124928, '\p{Blk=-ethiopic_Ext_b}', "");
    Expect(1, 124928, '\p{^Blk=-ethiopic_Ext_b}', "");
    Expect(1, 124928, '\P{Blk=-ethiopic_Ext_b}', "");
    Expect(0, 124928, '\P{^Blk=-ethiopic_Ext_b}', "");
    Error('\p{Is_Block=:=		Ethiopic_Extended_B}');
    Error('\P{Is_Block=:=		Ethiopic_Extended_B}');
    Expect(1, 124927, '\p{Is_Block=ethiopicextendedb}', "");
    Expect(0, 124927, '\p{^Is_Block=ethiopicextendedb}', "");
    Expect(0, 124927, '\P{Is_Block=ethiopicextendedb}', "");
    Expect(1, 124927, '\P{^Is_Block=ethiopicextendedb}', "");
    Expect(0, 124928, '\p{Is_Block=ethiopicextendedb}', "");
    Expect(1, 124928, '\p{^Is_Block=ethiopicextendedb}', "");
    Expect(1, 124928, '\P{Is_Block=ethiopicextendedb}', "");
    Expect(0, 124928, '\P{^Is_Block=ethiopicextendedb}', "");
    Expect(1, 124927, '\p{Is_Block=-	ETHIOPIC_Extended_B}', "");
    Expect(0, 124927, '\p{^Is_Block=-	ETHIOPIC_Extended_B}', "");
    Expect(0, 124927, '\P{Is_Block=-	ETHIOPIC_Extended_B}', "");
    Expect(1, 124927, '\P{^Is_Block=-	ETHIOPIC_Extended_B}', "");
    Expect(0, 124928, '\p{Is_Block=-	ETHIOPIC_Extended_B}', "");
    Expect(1, 124928, '\p{^Is_Block=-	ETHIOPIC_Extended_B}', "");
    Expect(1, 124928, '\P{Is_Block=-	ETHIOPIC_Extended_B}', "");
    Expect(0, 124928, '\P{^Is_Block=-	ETHIOPIC_Extended_B}', "");
    Error('\p{Is_Blk=/a/		ethiopic_ext_B}');
    Error('\P{Is_Blk=/a/		ethiopic_ext_B}');
    Expect(1, 124927, '\p{Is_Blk=ethiopicextb}', "");
    Expect(0, 124927, '\p{^Is_Blk=ethiopicextb}', "");
    Expect(0, 124927, '\P{Is_Blk=ethiopicextb}', "");
    Expect(1, 124927, '\P{^Is_Blk=ethiopicextb}', "");
    Expect(0, 124928, '\p{Is_Blk=ethiopicextb}', "");
    Expect(1, 124928, '\p{^Is_Blk=ethiopicextb}', "");
    Expect(1, 124928, '\P{Is_Blk=ethiopicextb}', "");
    Expect(0, 124928, '\P{^Is_Blk=ethiopicextb}', "");
    Expect(1, 124927, '\p{Is_Blk=__ethiopic_Ext_B}', "");
    Expect(0, 124927, '\p{^Is_Blk=__ethiopic_Ext_B}', "");
    Expect(0, 124927, '\P{Is_Blk=__ethiopic_Ext_B}', "");
    Expect(1, 124927, '\P{^Is_Blk=__ethiopic_Ext_B}', "");
    Expect(0, 124928, '\p{Is_Blk=__ethiopic_Ext_B}', "");
    Expect(1, 124928, '\p{^Is_Blk=__ethiopic_Ext_B}', "");
    Expect(1, 124928, '\P{Is_Blk=__ethiopic_Ext_B}', "");
    Expect(0, 124928, '\P{^Is_Blk=__ethiopic_Ext_B}', "");
    Error('\p{Block=_/a/ethiopic_Supplement}');
    Error('\P{Block=_/a/ethiopic_Supplement}');
    Expect(1, 5023, '\p{Block=:\AEthiopic_Supplement\z:}', "");;
    Expect(0, 5024, '\p{Block=:\AEthiopic_Supplement\z:}', "");;
    Expect(1, 5023, '\p{Block=ethiopicsupplement}', "");
    Expect(0, 5023, '\p{^Block=ethiopicsupplement}', "");
    Expect(0, 5023, '\P{Block=ethiopicsupplement}', "");
    Expect(1, 5023, '\P{^Block=ethiopicsupplement}', "");
    Expect(0, 5024, '\p{Block=ethiopicsupplement}', "");
    Expect(1, 5024, '\p{^Block=ethiopicsupplement}', "");
    Expect(1, 5024, '\P{Block=ethiopicsupplement}', "");
    Expect(0, 5024, '\P{^Block=ethiopicsupplement}', "");
    Expect(1, 5023, '\p{Block=:\Aethiopicsupplement\z:}', "");;
    Expect(0, 5024, '\p{Block=:\Aethiopicsupplement\z:}', "");;
    Expect(1, 5023, '\p{Block:   -ethiopic_supplement}', "");
    Expect(0, 5023, '\p{^Block:   -ethiopic_supplement}', "");
    Expect(0, 5023, '\P{Block:   -ethiopic_supplement}', "");
    Expect(1, 5023, '\P{^Block:   -ethiopic_supplement}', "");
    Expect(0, 5024, '\p{Block:   -ethiopic_supplement}', "");
    Expect(1, 5024, '\p{^Block:   -ethiopic_supplement}', "");
    Expect(1, 5024, '\P{Block:   -ethiopic_supplement}', "");
    Expect(0, 5024, '\P{^Block:   -ethiopic_supplement}', "");
    Error('\p{Blk=-Ethiopic_sup/a/}');
    Error('\P{Blk=-Ethiopic_sup/a/}');
    Expect(1, 5023, '\p{Blk=:\AEthiopic_Sup\z:}', "");;
    Expect(0, 5024, '\p{Blk=:\AEthiopic_Sup\z:}', "");;
    Expect(1, 5023, '\p{Blk=ethiopicsup}', "");
    Expect(0, 5023, '\p{^Blk=ethiopicsup}', "");
    Expect(0, 5023, '\P{Blk=ethiopicsup}', "");
    Expect(1, 5023, '\P{^Blk=ethiopicsup}', "");
    Expect(0, 5024, '\p{Blk=ethiopicsup}', "");
    Expect(1, 5024, '\p{^Blk=ethiopicsup}', "");
    Expect(1, 5024, '\P{Blk=ethiopicsup}', "");
    Expect(0, 5024, '\P{^Blk=ethiopicsup}', "");
    Expect(1, 5023, '\p{Blk=:\Aethiopicsup\z:}', "");;
    Expect(0, 5024, '\p{Blk=:\Aethiopicsup\z:}', "");;
    Expect(1, 5023, '\p{Blk=-ETHIOPIC_Sup}', "");
    Expect(0, 5023, '\p{^Blk=-ETHIOPIC_Sup}', "");
    Expect(0, 5023, '\P{Blk=-ETHIOPIC_Sup}', "");
    Expect(1, 5023, '\P{^Blk=-ETHIOPIC_Sup}', "");
    Expect(0, 5024, '\p{Blk=-ETHIOPIC_Sup}', "");
    Expect(1, 5024, '\p{^Blk=-ETHIOPIC_Sup}', "");
    Expect(1, 5024, '\P{Blk=-ETHIOPIC_Sup}', "");
    Expect(0, 5024, '\P{^Blk=-ETHIOPIC_Sup}', "");
    Error('\p{Is_Block=:=_	ETHIOPIC_Supplement}');
    Error('\P{Is_Block=:=_	ETHIOPIC_Supplement}');
    Expect(1, 5023, '\p{Is_Block=ethiopicsupplement}', "");
    Expect(0, 5023, '\p{^Is_Block=ethiopicsupplement}', "");
    Expect(0, 5023, '\P{Is_Block=ethiopicsupplement}', "");
    Expect(1, 5023, '\P{^Is_Block=ethiopicsupplement}', "");
    Expect(0, 5024, '\p{Is_Block=ethiopicsupplement}', "");
    Expect(1, 5024, '\p{^Is_Block=ethiopicsupplement}', "");
    Expect(1, 5024, '\P{Is_Block=ethiopicsupplement}', "");
    Expect(0, 5024, '\P{^Is_Block=ethiopicsupplement}', "");
    Expect(1, 5023, '\p{Is_Block= ethiopic_SUPPLEMENT}', "");
    Expect(0, 5023, '\p{^Is_Block= ethiopic_SUPPLEMENT}', "");
    Expect(0, 5023, '\P{Is_Block= ethiopic_SUPPLEMENT}', "");
    Expect(1, 5023, '\P{^Is_Block= ethiopic_SUPPLEMENT}', "");
    Expect(0, 5024, '\p{Is_Block= ethiopic_SUPPLEMENT}', "");
    Expect(1, 5024, '\p{^Is_Block= ethiopic_SUPPLEMENT}', "");
    Expect(1, 5024, '\P{Is_Block= ethiopic_SUPPLEMENT}', "");
    Expect(0, 5024, '\P{^Is_Block= ethiopic_SUPPLEMENT}', "");
    Error('\p{Is_Blk=/a/ ethiopic_Sup}');
    Error('\P{Is_Blk=/a/ ethiopic_Sup}');
    Expect(1, 5023, '\p{Is_Blk: ethiopicsup}', "");
    Expect(0, 5023, '\p{^Is_Blk: ethiopicsup}', "");
    Expect(0, 5023, '\P{Is_Blk: ethiopicsup}', "");
    Expect(1, 5023, '\P{^Is_Blk: ethiopicsup}', "");
    Expect(0, 5024, '\p{Is_Blk: ethiopicsup}', "");
    Expect(1, 5024, '\p{^Is_Blk: ethiopicsup}', "");
    Expect(1, 5024, '\P{Is_Blk: ethiopicsup}', "");
    Expect(0, 5024, '\P{^Is_Blk: ethiopicsup}', "");
    Expect(1, 5023, '\p{Is_Blk=_ETHIOPIC_Sup}', "");
    Expect(0, 5023, '\p{^Is_Blk=_ETHIOPIC_Sup}', "");
    Expect(0, 5023, '\P{Is_Blk=_ETHIOPIC_Sup}', "");
    Expect(1, 5023, '\P{^Is_Blk=_ETHIOPIC_Sup}', "");
    Expect(0, 5024, '\p{Is_Blk=_ETHIOPIC_Sup}', "");
    Expect(1, 5024, '\p{^Is_Blk=_ETHIOPIC_Sup}', "");
    Expect(1, 5024, '\P{Is_Blk=_ETHIOPIC_Sup}', "");
    Expect(0, 5024, '\P{^Is_Blk=_ETHIOPIC_Sup}', "");
    Error('\p{Block=	geometric_shapes:=}');
    Error('\P{Block=	geometric_shapes:=}');
    Expect(1, 9727, '\p{Block=:\AGeometric_Shapes\z:}', "");;
    Expect(0, 9728, '\p{Block=:\AGeometric_Shapes\z:}', "");;
    Expect(1, 9727, '\p{Block=geometricshapes}', "");
    Expect(0, 9727, '\p{^Block=geometricshapes}', "");
    Expect(0, 9727, '\P{Block=geometricshapes}', "");
    Expect(1, 9727, '\P{^Block=geometricshapes}', "");
    Expect(0, 9728, '\p{Block=geometricshapes}', "");
    Expect(1, 9728, '\p{^Block=geometricshapes}', "");
    Expect(1, 9728, '\P{Block=geometricshapes}', "");
    Expect(0, 9728, '\P{^Block=geometricshapes}', "");
    Expect(1, 9727, '\p{Block=:\Ageometricshapes\z:}', "");;
    Expect(0, 9728, '\p{Block=:\Ageometricshapes\z:}', "");;
    Expect(1, 9727, '\p{Block=- geometric_shapes}', "");
    Expect(0, 9727, '\p{^Block=- geometric_shapes}', "");
    Expect(0, 9727, '\P{Block=- geometric_shapes}', "");
    Expect(1, 9727, '\P{^Block=- geometric_shapes}', "");
    Expect(0, 9728, '\p{Block=- geometric_shapes}', "");
    Expect(1, 9728, '\p{^Block=- geometric_shapes}', "");
    Expect(1, 9728, '\P{Block=- geometric_shapes}', "");
    Expect(0, 9728, '\P{^Block=- geometric_shapes}', "");
    Error('\p{Blk=/a/		Geometric_Shapes}');
    Error('\P{Blk=/a/		Geometric_Shapes}');
    Expect(1, 9727, '\p{Blk=:\AGeometric_Shapes\z:}', "");;
    Expect(0, 9728, '\p{Blk=:\AGeometric_Shapes\z:}', "");;
    Expect(1, 9727, '\p{Blk=geometricshapes}', "");
    Expect(0, 9727, '\p{^Blk=geometricshapes}', "");
    Expect(0, 9727, '\P{Blk=geometricshapes}', "");
    Expect(1, 9727, '\P{^Blk=geometricshapes}', "");
    Expect(0, 9728, '\p{Blk=geometricshapes}', "");
    Expect(1, 9728, '\p{^Blk=geometricshapes}', "");
    Expect(1, 9728, '\P{Blk=geometricshapes}', "");
    Expect(0, 9728, '\P{^Blk=geometricshapes}', "");
    Expect(1, 9727, '\p{Blk=:\Ageometricshapes\z:}', "");;
    Expect(0, 9728, '\p{Blk=:\Ageometricshapes\z:}', "");;
    Expect(1, 9727, '\p{Blk=-_Geometric_Shapes}', "");
    Expect(0, 9727, '\p{^Blk=-_Geometric_Shapes}', "");
    Expect(0, 9727, '\P{Blk=-_Geometric_Shapes}', "");
    Expect(1, 9727, '\P{^Blk=-_Geometric_Shapes}', "");
    Expect(0, 9728, '\p{Blk=-_Geometric_Shapes}', "");
    Expect(1, 9728, '\p{^Blk=-_Geometric_Shapes}', "");
    Expect(1, 9728, '\P{Blk=-_Geometric_Shapes}', "");
    Expect(0, 9728, '\P{^Blk=-_Geometric_Shapes}', "");
    Error('\p{Is_Block=  geometric_Shapes:=}');
    Error('\P{Is_Block=  geometric_Shapes:=}');
    Expect(1, 9727, '\p{Is_Block=geometricshapes}', "");
    Expect(0, 9727, '\p{^Is_Block=geometricshapes}', "");
    Expect(0, 9727, '\P{Is_Block=geometricshapes}', "");
    Expect(1, 9727, '\P{^Is_Block=geometricshapes}', "");
    Expect(0, 9728, '\p{Is_Block=geometricshapes}', "");
    Expect(1, 9728, '\p{^Is_Block=geometricshapes}', "");
    Expect(1, 9728, '\P{Is_Block=geometricshapes}', "");
    Expect(0, 9728, '\P{^Is_Block=geometricshapes}', "");
    Expect(1, 9727, '\p{Is_Block=	Geometric_shapes}', "");
    Expect(0, 9727, '\p{^Is_Block=	Geometric_shapes}', "");
    Expect(0, 9727, '\P{Is_Block=	Geometric_shapes}', "");
    Expect(1, 9727, '\P{^Is_Block=	Geometric_shapes}', "");
    Expect(0, 9728, '\p{Is_Block=	Geometric_shapes}', "");
    Expect(1, 9728, '\p{^Is_Block=	Geometric_shapes}', "");
    Expect(1, 9728, '\P{Is_Block=	Geometric_shapes}', "");
    Expect(0, 9728, '\P{^Is_Block=	Geometric_shapes}', "");
    Error('\p{Is_Blk=	_Geometric_shapes/a/}');
    Error('\P{Is_Blk=	_Geometric_shapes/a/}');
    Expect(1, 9727, '\p{Is_Blk=geometricshapes}', "");
    Expect(0, 9727, '\p{^Is_Blk=geometricshapes}', "");
    Expect(0, 9727, '\P{Is_Blk=geometricshapes}', "");
    Expect(1, 9727, '\P{^Is_Blk=geometricshapes}', "");
    Expect(0, 9728, '\p{Is_Blk=geometricshapes}', "");
    Expect(1, 9728, '\p{^Is_Blk=geometricshapes}', "");
    Expect(1, 9728, '\P{Is_Blk=geometricshapes}', "");
    Expect(0, 9728, '\P{^Is_Blk=geometricshapes}', "");
    Expect(1, 9727, '\p{Is_Blk=_-Geometric_Shapes}', "");
    Expect(0, 9727, '\p{^Is_Blk=_-Geometric_Shapes}', "");
    Expect(0, 9727, '\P{Is_Blk=_-Geometric_Shapes}', "");
    Expect(1, 9727, '\P{^Is_Blk=_-Geometric_Shapes}', "");
    Expect(0, 9728, '\p{Is_Blk=_-Geometric_Shapes}', "");
    Expect(1, 9728, '\p{^Is_Blk=_-Geometric_Shapes}', "");
    Expect(1, 9728, '\P{Is_Blk=_-Geometric_Shapes}', "");
    Expect(0, 9728, '\P{^Is_Blk=_-Geometric_Shapes}', "");
    Error('\p{Block=-geometric_Shapes_Extended/a/}');
    Error('\P{Block=-geometric_Shapes_Extended/a/}');
    Expect(1, 129023, '\p{Block=:\AGeometric_Shapes_Extended\z:}', "");;
    Expect(0, 129024, '\p{Block=:\AGeometric_Shapes_Extended\z:}', "");;
    Expect(1, 129023, '\p{Block=geometricshapesextended}', "");
    Expect(0, 129023, '\p{^Block=geometricshapesextended}', "");
    Expect(0, 129023, '\P{Block=geometricshapesextended}', "");
    Expect(1, 129023, '\P{^Block=geometricshapesextended}', "");
    Expect(0, 129024, '\p{Block=geometricshapesextended}', "");
    Expect(1, 129024, '\p{^Block=geometricshapesextended}', "");
    Expect(1, 129024, '\P{Block=geometricshapesextended}', "");
    Expect(0, 129024, '\P{^Block=geometricshapesextended}', "");
    Expect(1, 129023, '\p{Block=:\Ageometricshapesextended\z:}', "");;
    Expect(0, 129024, '\p{Block=:\Ageometricshapesextended\z:}', "");;
    Expect(1, 129023, '\p{Block:	 geometric_Shapes_EXTENDED}', "");
    Expect(0, 129023, '\p{^Block:	 geometric_Shapes_EXTENDED}', "");
    Expect(0, 129023, '\P{Block:	 geometric_Shapes_EXTENDED}', "");
    Expect(1, 129023, '\P{^Block:	 geometric_Shapes_EXTENDED}', "");
    Expect(0, 129024, '\p{Block:	 geometric_Shapes_EXTENDED}', "");
    Expect(1, 129024, '\p{^Block:	 geometric_Shapes_EXTENDED}', "");
    Expect(1, 129024, '\P{Block:	 geometric_Shapes_EXTENDED}', "");
    Expect(0, 129024, '\P{^Block:	 geometric_Shapes_EXTENDED}', "");
    Error('\p{Blk=	-Geometric_Shapes_ext:=}');
    Error('\P{Blk=	-Geometric_Shapes_ext:=}');
    Expect(1, 129023, '\p{Blk=:\AGeometric_Shapes_Ext\z:}', "");;
    Expect(0, 129024, '\p{Blk=:\AGeometric_Shapes_Ext\z:}', "");;
    Expect(1, 129023, '\p{Blk=geometricshapesext}', "");
    Expect(0, 129023, '\p{^Blk=geometricshapesext}', "");
    Expect(0, 129023, '\P{Blk=geometricshapesext}', "");
    Expect(1, 129023, '\P{^Blk=geometricshapesext}', "");
    Expect(0, 129024, '\p{Blk=geometricshapesext}', "");
    Expect(1, 129024, '\p{^Blk=geometricshapesext}', "");
    Expect(1, 129024, '\P{Blk=geometricshapesext}', "");
    Expect(0, 129024, '\P{^Blk=geometricshapesext}', "");
    Expect(1, 129023, '\p{Blk=:\Ageometricshapesext\z:}', "");;
    Expect(0, 129024, '\p{Blk=:\Ageometricshapesext\z:}', "");;
    Expect(1, 129023, '\p{Blk=__Geometric_SHAPES_EXT}', "");
    Expect(0, 129023, '\p{^Blk=__Geometric_SHAPES_EXT}', "");
    Expect(0, 129023, '\P{Blk=__Geometric_SHAPES_EXT}', "");
    Expect(1, 129023, '\P{^Blk=__Geometric_SHAPES_EXT}', "");
    Expect(0, 129024, '\p{Blk=__Geometric_SHAPES_EXT}', "");
    Expect(1, 129024, '\p{^Blk=__Geometric_SHAPES_EXT}', "");
    Expect(1, 129024, '\P{Blk=__Geometric_SHAPES_EXT}', "");
    Expect(0, 129024, '\P{^Blk=__Geometric_SHAPES_EXT}', "");
    Error('\p{Is_Block=/a/ -Geometric_Shapes_extended}');
    Error('\P{Is_Block=/a/ -Geometric_Shapes_extended}');
    Expect(1, 129023, '\p{Is_Block=geometricshapesextended}', "");
    Expect(0, 129023, '\p{^Is_Block=geometricshapesextended}', "");
    Expect(0, 129023, '\P{Is_Block=geometricshapesextended}', "");
    Expect(1, 129023, '\P{^Is_Block=geometricshapesextended}', "");
    Expect(0, 129024, '\p{Is_Block=geometricshapesextended}', "");
    Expect(1, 129024, '\p{^Is_Block=geometricshapesextended}', "");
    Expect(1, 129024, '\P{Is_Block=geometricshapesextended}', "");
    Expect(0, 129024, '\P{^Is_Block=geometricshapesextended}', "");
    Expect(1, 129023, '\p{Is_Block=	Geometric_Shapes_extended}', "");
    Expect(0, 129023, '\p{^Is_Block=	Geometric_Shapes_extended}', "");
    Expect(0, 129023, '\P{Is_Block=	Geometric_Shapes_extended}', "");
    Expect(1, 129023, '\P{^Is_Block=	Geometric_Shapes_extended}', "");
    Expect(0, 129024, '\p{Is_Block=	Geometric_Shapes_extended}', "");
    Expect(1, 129024, '\p{^Is_Block=	Geometric_Shapes_extended}', "");
    Expect(1, 129024, '\P{Is_Block=	Geometric_Shapes_extended}', "");
    Expect(0, 129024, '\P{^Is_Block=	Geometric_Shapes_extended}', "");
    Error('\p{Is_Blk=	:=GEOMETRIC_Shapes_ext}');
    Error('\P{Is_Blk=	:=GEOMETRIC_Shapes_ext}');
    Expect(1, 129023, '\p{Is_Blk=geometricshapesext}', "");
    Expect(0, 129023, '\p{^Is_Blk=geometricshapesext}', "");
    Expect(0, 129023, '\P{Is_Blk=geometricshapesext}', "");
    Expect(1, 129023, '\P{^Is_Blk=geometricshapesext}', "");
    Expect(0, 129024, '\p{Is_Blk=geometricshapesext}', "");
    Expect(1, 129024, '\p{^Is_Blk=geometricshapesext}', "");
    Expect(1, 129024, '\P{Is_Blk=geometricshapesext}', "");
    Expect(0, 129024, '\P{^Is_Blk=geometricshapesext}', "");
    Expect(1, 129023, '\p{Is_Blk=	 Geometric_Shapes_Ext}', "");
    Expect(0, 129023, '\p{^Is_Blk=	 Geometric_Shapes_Ext}', "");
    Expect(0, 129023, '\P{Is_Blk=	 Geometric_Shapes_Ext}', "");
    Expect(1, 129023, '\P{^Is_Blk=	 Geometric_Shapes_Ext}', "");
    Expect(0, 129024, '\p{Is_Blk=	 Geometric_Shapes_Ext}', "");
    Expect(1, 129024, '\p{^Is_Blk=	 Geometric_Shapes_Ext}', "");
    Expect(1, 129024, '\P{Is_Blk=	 Geometric_Shapes_Ext}', "");
    Expect(0, 129024, '\P{^Is_Blk=	 Geometric_Shapes_Ext}', "");
    Error('\p{Block=:=--Georgian}');
    Error('\P{Block=:=--Georgian}');
    Expect(1, 4351, '\p{Block=:\AGeorgian\z:}', "");;
    Expect(0, 4352, '\p{Block=:\AGeorgian\z:}', "");;
    Expect(1, 4351, '\p{Block=georgian}', "");
    Expect(0, 4351, '\p{^Block=georgian}', "");
    Expect(0, 4351, '\P{Block=georgian}', "");
    Expect(1, 4351, '\P{^Block=georgian}', "");
    Expect(0, 4352, '\p{Block=georgian}', "");
    Expect(1, 4352, '\p{^Block=georgian}', "");
    Expect(1, 4352, '\P{Block=georgian}', "");
    Expect(0, 4352, '\P{^Block=georgian}', "");
    Expect(1, 4351, '\p{Block=:\Ageorgian\z:}', "");;
    Expect(0, 4352, '\p{Block=:\Ageorgian\z:}', "");;
    Expect(1, 4351, '\p{Block=_georgian}', "");
    Expect(0, 4351, '\p{^Block=_georgian}', "");
    Expect(0, 4351, '\P{Block=_georgian}', "");
    Expect(1, 4351, '\P{^Block=_georgian}', "");
    Expect(0, 4352, '\p{Block=_georgian}', "");
    Expect(1, 4352, '\p{^Block=_georgian}', "");
    Expect(1, 4352, '\P{Block=_georgian}', "");
    Expect(0, 4352, '\P{^Block=_georgian}', "");
    Error('\p{Blk=	georgian/a/}');
    Error('\P{Blk=	georgian/a/}');
    Expect(1, 4351, '\p{Blk=:\AGeorgian\z:}', "");;
    Expect(0, 4352, '\p{Blk=:\AGeorgian\z:}', "");;
    Expect(1, 4351, '\p{Blk=georgian}', "");
    Expect(0, 4351, '\p{^Blk=georgian}', "");
    Expect(0, 4351, '\P{Blk=georgian}', "");
    Expect(1, 4351, '\P{^Blk=georgian}', "");
    Expect(0, 4352, '\p{Blk=georgian}', "");
    Expect(1, 4352, '\p{^Blk=georgian}', "");
    Expect(1, 4352, '\P{Blk=georgian}', "");
    Expect(0, 4352, '\P{^Blk=georgian}', "");
    Expect(1, 4351, '\p{Blk=:\Ageorgian\z:}', "");;
    Expect(0, 4352, '\p{Blk=:\Ageorgian\z:}', "");;
    Expect(1, 4351, '\p{Blk=_ GEORGIAN}', "");
    Expect(0, 4351, '\p{^Blk=_ GEORGIAN}', "");
    Expect(0, 4351, '\P{Blk=_ GEORGIAN}', "");
    Expect(1, 4351, '\P{^Blk=_ GEORGIAN}', "");
    Expect(0, 4352, '\p{Blk=_ GEORGIAN}', "");
    Expect(1, 4352, '\p{^Blk=_ GEORGIAN}', "");
    Expect(1, 4352, '\P{Blk=_ GEORGIAN}', "");
    Expect(0, 4352, '\P{^Blk=_ GEORGIAN}', "");
    Error('\p{Is_Block:   _Georgian/a/}');
    Error('\P{Is_Block:   _Georgian/a/}');
    Expect(1, 4351, '\p{Is_Block=georgian}', "");
    Expect(0, 4351, '\p{^Is_Block=georgian}', "");
    Expect(0, 4351, '\P{Is_Block=georgian}', "");
    Expect(1, 4351, '\P{^Is_Block=georgian}', "");
    Expect(0, 4352, '\p{Is_Block=georgian}', "");
    Expect(1, 4352, '\p{^Is_Block=georgian}', "");
    Expect(1, 4352, '\P{Is_Block=georgian}', "");
    Expect(0, 4352, '\P{^Is_Block=georgian}', "");
    Expect(1, 4351, '\p{Is_Block=-georgian}', "");
    Expect(0, 4351, '\p{^Is_Block=-georgian}', "");
    Expect(0, 4351, '\P{Is_Block=-georgian}', "");
    Expect(1, 4351, '\P{^Is_Block=-georgian}', "");
    Expect(0, 4352, '\p{Is_Block=-georgian}', "");
    Expect(1, 4352, '\p{^Is_Block=-georgian}', "");
    Expect(1, 4352, '\P{Is_Block=-georgian}', "");
    Expect(0, 4352, '\P{^Is_Block=-georgian}', "");
    Error('\p{Is_Blk=/a/-_GEORGIAN}');
    Error('\P{Is_Blk=/a/-_GEORGIAN}');
    Expect(1, 4351, '\p{Is_Blk=georgian}', "");
    Expect(0, 4351, '\p{^Is_Blk=georgian}', "");
    Expect(0, 4351, '\P{Is_Blk=georgian}', "");
    Expect(1, 4351, '\P{^Is_Blk=georgian}', "");
    Expect(0, 4352, '\p{Is_Blk=georgian}', "");
    Expect(1, 4352, '\p{^Is_Blk=georgian}', "");
    Expect(1, 4352, '\P{Is_Blk=georgian}', "");
    Expect(0, 4352, '\P{^Is_Blk=georgian}', "");
    Expect(1, 4351, '\p{Is_Blk:  GEORGIAN}', "");
    Expect(0, 4351, '\p{^Is_Blk:  GEORGIAN}', "");
    Expect(0, 4351, '\P{Is_Blk:  GEORGIAN}', "");
    Expect(1, 4351, '\P{^Is_Blk:  GEORGIAN}', "");
    Expect(0, 4352, '\p{Is_Blk:  GEORGIAN}', "");
    Expect(1, 4352, '\p{^Is_Blk:  GEORGIAN}', "");
    Expect(1, 4352, '\P{Is_Blk:  GEORGIAN}', "");
    Expect(0, 4352, '\P{^Is_Blk:  GEORGIAN}', "");
    Error('\p{Block=/a/	_GEORGIAN_EXTENDED}');
    Error('\P{Block=/a/	_GEORGIAN_EXTENDED}');
    Expect(1, 7359, '\p{Block=:\AGeorgian_Extended\z:}', "");;
    Expect(0, 7360, '\p{Block=:\AGeorgian_Extended\z:}', "");;
    Expect(1, 7359, '\p{Block=georgianextended}', "");
    Expect(0, 7359, '\p{^Block=georgianextended}', "");
    Expect(0, 7359, '\P{Block=georgianextended}', "");
    Expect(1, 7359, '\P{^Block=georgianextended}', "");
    Expect(0, 7360, '\p{Block=georgianextended}', "");
    Expect(1, 7360, '\p{^Block=georgianextended}', "");
    Expect(1, 7360, '\P{Block=georgianextended}', "");
    Expect(0, 7360, '\P{^Block=georgianextended}', "");
    Expect(1, 7359, '\p{Block=:\Ageorgianextended\z:}', "");;
    Expect(0, 7360, '\p{Block=:\Ageorgianextended\z:}', "");;
    Expect(1, 7359, '\p{Block=_	Georgian_Extended}', "");
    Expect(0, 7359, '\p{^Block=_	Georgian_Extended}', "");
    Expect(0, 7359, '\P{Block=_	Georgian_Extended}', "");
    Expect(1, 7359, '\P{^Block=_	Georgian_Extended}', "");
    Expect(0, 7360, '\p{Block=_	Georgian_Extended}', "");
    Expect(1, 7360, '\p{^Block=_	Georgian_Extended}', "");
    Expect(1, 7360, '\P{Block=_	Georgian_Extended}', "");
    Expect(0, 7360, '\P{^Block=_	Georgian_Extended}', "");
    Error('\p{Blk=-:=georgian_Ext}');
    Error('\P{Blk=-:=georgian_Ext}');
    Expect(1, 7359, '\p{Blk=:\AGeorgian_Ext\z:}', "");;
    Expect(0, 7360, '\p{Blk=:\AGeorgian_Ext\z:}', "");;
    Expect(1, 7359, '\p{Blk=georgianext}', "");
    Expect(0, 7359, '\p{^Blk=georgianext}', "");
    Expect(0, 7359, '\P{Blk=georgianext}', "");
    Expect(1, 7359, '\P{^Blk=georgianext}', "");
    Expect(0, 7360, '\p{Blk=georgianext}', "");
    Expect(1, 7360, '\p{^Blk=georgianext}', "");
    Expect(1, 7360, '\P{Blk=georgianext}', "");
    Expect(0, 7360, '\P{^Blk=georgianext}', "");
    Expect(1, 7359, '\p{Blk=:\Ageorgianext\z:}', "");;
    Expect(0, 7360, '\p{Blk=:\Ageorgianext\z:}', "");;
    Expect(1, 7359, '\p{Blk=_Georgian_EXT}', "");
    Expect(0, 7359, '\p{^Blk=_Georgian_EXT}', "");
    Expect(0, 7359, '\P{Blk=_Georgian_EXT}', "");
    Expect(1, 7359, '\P{^Blk=_Georgian_EXT}', "");
    Expect(0, 7360, '\p{Blk=_Georgian_EXT}', "");
    Expect(1, 7360, '\p{^Blk=_Georgian_EXT}', "");
    Expect(1, 7360, '\P{Blk=_Georgian_EXT}', "");
    Expect(0, 7360, '\P{^Blk=_Georgian_EXT}', "");
    Error('\p{Is_Block=_georgian_EXTENDED:=}');
    Error('\P{Is_Block=_georgian_EXTENDED:=}');
    Expect(1, 7359, '\p{Is_Block=georgianextended}', "");
    Expect(0, 7359, '\p{^Is_Block=georgianextended}', "");
    Expect(0, 7359, '\P{Is_Block=georgianextended}', "");
    Expect(1, 7359, '\P{^Is_Block=georgianextended}', "");
    Expect(0, 7360, '\p{Is_Block=georgianextended}', "");
    Expect(1, 7360, '\p{^Is_Block=georgianextended}', "");
    Expect(1, 7360, '\P{Is_Block=georgianextended}', "");
    Expect(0, 7360, '\P{^Is_Block=georgianextended}', "");
    Expect(1, 7359, '\p{Is_Block= 	GEORGIAN_Extended}', "");
    Expect(0, 7359, '\p{^Is_Block= 	GEORGIAN_Extended}', "");
    Expect(0, 7359, '\P{Is_Block= 	GEORGIAN_Extended}', "");
    Expect(1, 7359, '\P{^Is_Block= 	GEORGIAN_Extended}', "");
    Expect(0, 7360, '\p{Is_Block= 	GEORGIAN_Extended}', "");
    Expect(1, 7360, '\p{^Is_Block= 	GEORGIAN_Extended}', "");
    Expect(1, 7360, '\P{Is_Block= 	GEORGIAN_Extended}', "");
    Expect(0, 7360, '\P{^Is_Block= 	GEORGIAN_Extended}', "");
    Error('\p{Is_Blk=-:=georgian_Ext}');
    Error('\P{Is_Blk=-:=georgian_Ext}');
    Expect(1, 7359, '\p{Is_Blk:georgianext}', "");
    Expect(0, 7359, '\p{^Is_Blk:georgianext}', "");
    Expect(0, 7359, '\P{Is_Blk:georgianext}', "");
    Expect(1, 7359, '\P{^Is_Blk:georgianext}', "");
    Expect(0, 7360, '\p{Is_Blk:georgianext}', "");
    Expect(1, 7360, '\p{^Is_Blk:georgianext}', "");
    Expect(1, 7360, '\P{Is_Blk:georgianext}', "");
    Expect(0, 7360, '\P{^Is_Blk:georgianext}', "");
    Expect(1, 7359, '\p{Is_Blk=_-GEORGIAN_Ext}', "");
    Expect(0, 7359, '\p{^Is_Blk=_-GEORGIAN_Ext}', "");
    Expect(0, 7359, '\P{Is_Blk=_-GEORGIAN_Ext}', "");
    Expect(1, 7359, '\P{^Is_Blk=_-GEORGIAN_Ext}', "");
    Expect(0, 7360, '\p{Is_Blk=_-GEORGIAN_Ext}', "");
    Expect(1, 7360, '\p{^Is_Blk=_-GEORGIAN_Ext}', "");
    Expect(1, 7360, '\P{Is_Blk=_-GEORGIAN_Ext}', "");
    Expect(0, 7360, '\P{^Is_Blk=_-GEORGIAN_Ext}', "");
    Error('\p{Block=:=_-Georgian_supplement}');
    Error('\P{Block=:=_-Georgian_supplement}');
    Expect(1, 11567, '\p{Block=:\AGeorgian_Supplement\z:}', "");;
    Expect(0, 11568, '\p{Block=:\AGeorgian_Supplement\z:}', "");;
    Expect(1, 11567, '\p{Block=georgiansupplement}', "");
    Expect(0, 11567, '\p{^Block=georgiansupplement}', "");
    Expect(0, 11567, '\P{Block=georgiansupplement}', "");
    Expect(1, 11567, '\P{^Block=georgiansupplement}', "");
    Expect(0, 11568, '\p{Block=georgiansupplement}', "");
    Expect(1, 11568, '\p{^Block=georgiansupplement}', "");
    Expect(1, 11568, '\P{Block=georgiansupplement}', "");
    Expect(0, 11568, '\P{^Block=georgiansupplement}', "");
    Expect(1, 11567, '\p{Block=:\Ageorgiansupplement\z:}', "");;
    Expect(0, 11568, '\p{Block=:\Ageorgiansupplement\z:}', "");;
    Expect(1, 11567, '\p{Block=_-Georgian_Supplement}', "");
    Expect(0, 11567, '\p{^Block=_-Georgian_Supplement}', "");
    Expect(0, 11567, '\P{Block=_-Georgian_Supplement}', "");
    Expect(1, 11567, '\P{^Block=_-Georgian_Supplement}', "");
    Expect(0, 11568, '\p{Block=_-Georgian_Supplement}', "");
    Expect(1, 11568, '\p{^Block=_-Georgian_Supplement}', "");
    Expect(1, 11568, '\P{Block=_-Georgian_Supplement}', "");
    Expect(0, 11568, '\P{^Block=_-Georgian_Supplement}', "");
    Error('\p{Blk=-/a/GEORGIAN_SUP}');
    Error('\P{Blk=-/a/GEORGIAN_SUP}');
    Expect(1, 11567, '\p{Blk=:\AGeorgian_Sup\z:}', "");;
    Expect(0, 11568, '\p{Blk=:\AGeorgian_Sup\z:}', "");;
    Expect(1, 11567, '\p{Blk=georgiansup}', "");
    Expect(0, 11567, '\p{^Blk=georgiansup}', "");
    Expect(0, 11567, '\P{Blk=georgiansup}', "");
    Expect(1, 11567, '\P{^Blk=georgiansup}', "");
    Expect(0, 11568, '\p{Blk=georgiansup}', "");
    Expect(1, 11568, '\p{^Blk=georgiansup}', "");
    Expect(1, 11568, '\P{Blk=georgiansup}', "");
    Expect(0, 11568, '\P{^Blk=georgiansup}', "");
    Expect(1, 11567, '\p{Blk=:\Ageorgiansup\z:}', "");;
    Expect(0, 11568, '\p{Blk=:\Ageorgiansup\z:}', "");;
    Expect(1, 11567, '\p{Blk=	Georgian_sup}', "");
    Expect(0, 11567, '\p{^Blk=	Georgian_sup}', "");
    Expect(0, 11567, '\P{Blk=	Georgian_sup}', "");
    Expect(1, 11567, '\P{^Blk=	Georgian_sup}', "");
    Expect(0, 11568, '\p{Blk=	Georgian_sup}', "");
    Expect(1, 11568, '\p{^Blk=	Georgian_sup}', "");
    Expect(1, 11568, '\P{Blk=	Georgian_sup}', "");
    Expect(0, 11568, '\P{^Blk=	Georgian_sup}', "");
    Error('\p{Is_Block=:=_-georgian_Supplement}');
    Error('\P{Is_Block=:=_-georgian_Supplement}');
    Expect(1, 11567, '\p{Is_Block=georgiansupplement}', "");
    Expect(0, 11567, '\p{^Is_Block=georgiansupplement}', "");
    Expect(0, 11567, '\P{Is_Block=georgiansupplement}', "");
    Expect(1, 11567, '\P{^Is_Block=georgiansupplement}', "");
    Expect(0, 11568, '\p{Is_Block=georgiansupplement}', "");
    Expect(1, 11568, '\p{^Is_Block=georgiansupplement}', "");
    Expect(1, 11568, '\P{Is_Block=georgiansupplement}', "");
    Expect(0, 11568, '\P{^Is_Block=georgiansupplement}', "");
    Expect(1, 11567, '\p{Is_Block= -Georgian_Supplement}', "");
    Expect(0, 11567, '\p{^Is_Block= -Georgian_Supplement}', "");
    Expect(0, 11567, '\P{Is_Block= -Georgian_Supplement}', "");
    Expect(1, 11567, '\P{^Is_Block= -Georgian_Supplement}', "");
    Expect(0, 11568, '\p{Is_Block= -Georgian_Supplement}', "");
    Expect(1, 11568, '\p{^Is_Block= -Georgian_Supplement}', "");
    Expect(1, 11568, '\P{Is_Block= -Georgian_Supplement}', "");
    Expect(0, 11568, '\P{^Is_Block= -Georgian_Supplement}', "");
    Error('\p{Is_Blk=_ georgian_SUP/a/}');
    Error('\P{Is_Blk=_ georgian_SUP/a/}');
    Expect(1, 11567, '\p{Is_Blk:   georgiansup}', "");
    Expect(0, 11567, '\p{^Is_Blk:   georgiansup}', "");
    Expect(0, 11567, '\P{Is_Blk:   georgiansup}', "");
    Expect(1, 11567, '\P{^Is_Blk:   georgiansup}', "");
    Expect(0, 11568, '\p{Is_Blk:   georgiansup}', "");
    Expect(1, 11568, '\p{^Is_Blk:   georgiansup}', "");
    Expect(1, 11568, '\P{Is_Blk:   georgiansup}', "");
    Expect(0, 11568, '\P{^Is_Blk:   georgiansup}', "");
    Expect(1, 11567, '\p{Is_Blk=_Georgian_Sup}', "");
    Expect(0, 11567, '\p{^Is_Blk=_Georgian_Sup}', "");
    Expect(0, 11567, '\P{Is_Blk=_Georgian_Sup}', "");
    Expect(1, 11567, '\P{^Is_Blk=_Georgian_Sup}', "");
    Expect(0, 11568, '\p{Is_Blk=_Georgian_Sup}', "");
    Expect(1, 11568, '\p{^Is_Blk=_Georgian_Sup}', "");
    Expect(1, 11568, '\P{Is_Blk=_Georgian_Sup}', "");
    Expect(0, 11568, '\P{^Is_Blk=_Georgian_Sup}', "");
    Error('\p{Block=/a/- glagolitic}');
    Error('\P{Block=/a/- glagolitic}');
    Expect(1, 11359, '\p{Block=:\AGlagolitic\z:}', "");;
    Expect(0, 11360, '\p{Block=:\AGlagolitic\z:}', "");;
    Expect(1, 11359, '\p{Block=glagolitic}', "");
    Expect(0, 11359, '\p{^Block=glagolitic}', "");
    Expect(0, 11359, '\P{Block=glagolitic}', "");
    Expect(1, 11359, '\P{^Block=glagolitic}', "");
    Expect(0, 11360, '\p{Block=glagolitic}', "");
    Expect(1, 11360, '\p{^Block=glagolitic}', "");
    Expect(1, 11360, '\P{Block=glagolitic}', "");
    Expect(0, 11360, '\P{^Block=glagolitic}', "");
    Expect(1, 11359, '\p{Block=:\Aglagolitic\z:}', "");;
    Expect(0, 11360, '\p{Block=:\Aglagolitic\z:}', "");;
    Expect(1, 11359, '\p{Block=_ glagolitic}', "");
    Expect(0, 11359, '\p{^Block=_ glagolitic}', "");
    Expect(0, 11359, '\P{Block=_ glagolitic}', "");
    Expect(1, 11359, '\P{^Block=_ glagolitic}', "");
    Expect(0, 11360, '\p{Block=_ glagolitic}', "");
    Expect(1, 11360, '\p{^Block=_ glagolitic}', "");
    Expect(1, 11360, '\P{Block=_ glagolitic}', "");
    Expect(0, 11360, '\P{^Block=_ glagolitic}', "");
    Error('\p{Blk=	:=glagolitic}');
    Error('\P{Blk=	:=glagolitic}');
    Expect(1, 11359, '\p{Blk=:\AGlagolitic\z:}', "");;
    Expect(0, 11360, '\p{Blk=:\AGlagolitic\z:}', "");;
    Expect(1, 11359, '\p{Blk=glagolitic}', "");
    Expect(0, 11359, '\p{^Blk=glagolitic}', "");
    Expect(0, 11359, '\P{Blk=glagolitic}', "");
    Expect(1, 11359, '\P{^Blk=glagolitic}', "");
    Expect(0, 11360, '\p{Blk=glagolitic}', "");
    Expect(1, 11360, '\p{^Blk=glagolitic}', "");
    Expect(1, 11360, '\P{Blk=glagolitic}', "");
    Expect(0, 11360, '\P{^Blk=glagolitic}', "");
    Expect(1, 11359, '\p{Blk=:\Aglagolitic\z:}', "");;
    Expect(0, 11360, '\p{Blk=:\Aglagolitic\z:}', "");;
    Expect(1, 11359, '\p{Blk=_Glagolitic}', "");
    Expect(0, 11359, '\p{^Blk=_Glagolitic}', "");
    Expect(0, 11359, '\P{Blk=_Glagolitic}', "");
    Expect(1, 11359, '\P{^Blk=_Glagolitic}', "");
    Expect(0, 11360, '\p{Blk=_Glagolitic}', "");
    Expect(1, 11360, '\p{^Blk=_Glagolitic}', "");
    Expect(1, 11360, '\P{Blk=_Glagolitic}', "");
    Expect(0, 11360, '\P{^Blk=_Glagolitic}', "");
    Error('\p{Is_Block=-	GLAGOLITIC:=}');
    Error('\P{Is_Block=-	GLAGOLITIC:=}');
    Expect(1, 11359, '\p{Is_Block=glagolitic}', "");
    Expect(0, 11359, '\p{^Is_Block=glagolitic}', "");
    Expect(0, 11359, '\P{Is_Block=glagolitic}', "");
    Expect(1, 11359, '\P{^Is_Block=glagolitic}', "");
    Expect(0, 11360, '\p{Is_Block=glagolitic}', "");
    Expect(1, 11360, '\p{^Is_Block=glagolitic}', "");
    Expect(1, 11360, '\P{Is_Block=glagolitic}', "");
    Expect(0, 11360, '\P{^Is_Block=glagolitic}', "");
    Expect(1, 11359, '\p{Is_Block:   	Glagolitic}', "");
    Expect(0, 11359, '\p{^Is_Block:   	Glagolitic}', "");
    Expect(0, 11359, '\P{Is_Block:   	Glagolitic}', "");
    Expect(1, 11359, '\P{^Is_Block:   	Glagolitic}', "");
    Expect(0, 11360, '\p{Is_Block:   	Glagolitic}', "");
    Expect(1, 11360, '\p{^Is_Block:   	Glagolitic}', "");
    Expect(1, 11360, '\P{Is_Block:   	Glagolitic}', "");
    Expect(0, 11360, '\P{^Is_Block:   	Glagolitic}', "");
    Error('\p{Is_Blk=/a/Glagolitic}');
    Error('\P{Is_Blk=/a/Glagolitic}');
    Expect(1, 11359, '\p{Is_Blk=glagolitic}', "");
    Expect(0, 11359, '\p{^Is_Blk=glagolitic}', "");
    Expect(0, 11359, '\P{Is_Blk=glagolitic}', "");
    Expect(1, 11359, '\P{^Is_Blk=glagolitic}', "");
    Expect(0, 11360, '\p{Is_Blk=glagolitic}', "");
    Expect(1, 11360, '\p{^Is_Blk=glagolitic}', "");
    Expect(1, 11360, '\P{Is_Blk=glagolitic}', "");
    Expect(0, 11360, '\P{^Is_Blk=glagolitic}', "");
    Expect(1, 11359, '\p{Is_Blk: Glagolitic}', "");
    Expect(0, 11359, '\p{^Is_Blk: Glagolitic}', "");
    Expect(0, 11359, '\P{Is_Blk: Glagolitic}', "");
    Expect(1, 11359, '\P{^Is_Blk: Glagolitic}', "");
    Expect(0, 11360, '\p{Is_Blk: Glagolitic}', "");
    Expect(1, 11360, '\p{^Is_Blk: Glagolitic}', "");
    Expect(1, 11360, '\P{Is_Blk: Glagolitic}', "");
    Expect(0, 11360, '\P{^Is_Blk: Glagolitic}', "");
    Error('\p{Block=/a/-_Glagolitic_SUPPLEMENT}');
    Error('\P{Block=/a/-_Glagolitic_SUPPLEMENT}');
    Expect(1, 122927, '\p{Block=:\AGlagolitic_Supplement\z:}', "");;
    Expect(0, 122928, '\p{Block=:\AGlagolitic_Supplement\z:}', "");;
    Expect(1, 122927, '\p{Block=glagoliticsupplement}', "");
    Expect(0, 122927, '\p{^Block=glagoliticsupplement}', "");
    Expect(0, 122927, '\P{Block=glagoliticsupplement}', "");
    Expect(1, 122927, '\P{^Block=glagoliticsupplement}', "");
    Expect(0, 122928, '\p{Block=glagoliticsupplement}', "");
    Expect(1, 122928, '\p{^Block=glagoliticsupplement}', "");
    Expect(1, 122928, '\P{Block=glagoliticsupplement}', "");
    Expect(0, 122928, '\P{^Block=glagoliticsupplement}', "");
    Expect(1, 122927, '\p{Block=:\Aglagoliticsupplement\z:}', "");;
    Expect(0, 122928, '\p{Block=:\Aglagoliticsupplement\z:}', "");;
    Expect(1, 122927, '\p{Block= Glagolitic_supplement}', "");
    Expect(0, 122927, '\p{^Block= Glagolitic_supplement}', "");
    Expect(0, 122927, '\P{Block= Glagolitic_supplement}', "");
    Expect(1, 122927, '\P{^Block= Glagolitic_supplement}', "");
    Expect(0, 122928, '\p{Block= Glagolitic_supplement}', "");
    Expect(1, 122928, '\p{^Block= Glagolitic_supplement}', "");
    Expect(1, 122928, '\P{Block= Glagolitic_supplement}', "");
    Expect(0, 122928, '\P{^Block= Glagolitic_supplement}', "");
    Error('\p{Blk=_glagolitic_sup:=}');
    Error('\P{Blk=_glagolitic_sup:=}');
    Expect(1, 122927, '\p{Blk=:\AGlagolitic_Sup\z:}', "");;
    Expect(0, 122928, '\p{Blk=:\AGlagolitic_Sup\z:}', "");;
    Expect(1, 122927, '\p{Blk=glagoliticsup}', "");
    Expect(0, 122927, '\p{^Blk=glagoliticsup}', "");
    Expect(0, 122927, '\P{Blk=glagoliticsup}', "");
    Expect(1, 122927, '\P{^Blk=glagoliticsup}', "");
    Expect(0, 122928, '\p{Blk=glagoliticsup}', "");
    Expect(1, 122928, '\p{^Blk=glagoliticsup}', "");
    Expect(1, 122928, '\P{Blk=glagoliticsup}', "");
    Expect(0, 122928, '\P{^Blk=glagoliticsup}', "");
    Expect(1, 122927, '\p{Blk=:\Aglagoliticsup\z:}', "");;
    Expect(0, 122928, '\p{Blk=:\Aglagoliticsup\z:}', "");;
    Expect(1, 122927, '\p{Blk=  GLAGOLITIC_Sup}', "");
    Expect(0, 122927, '\p{^Blk=  GLAGOLITIC_Sup}', "");
    Expect(0, 122927, '\P{Blk=  GLAGOLITIC_Sup}', "");
    Expect(1, 122927, '\P{^Blk=  GLAGOLITIC_Sup}', "");
    Expect(0, 122928, '\p{Blk=  GLAGOLITIC_Sup}', "");
    Expect(1, 122928, '\p{^Blk=  GLAGOLITIC_Sup}', "");
    Expect(1, 122928, '\P{Blk=  GLAGOLITIC_Sup}', "");
    Expect(0, 122928, '\P{^Blk=  GLAGOLITIC_Sup}', "");
    Error('\p{Is_Block=Glagolitic_supplement:=}');
    Error('\P{Is_Block=Glagolitic_supplement:=}');
    Expect(1, 122927, '\p{Is_Block=glagoliticsupplement}', "");
    Expect(0, 122927, '\p{^Is_Block=glagoliticsupplement}', "");
    Expect(0, 122927, '\P{Is_Block=glagoliticsupplement}', "");
    Expect(1, 122927, '\P{^Is_Block=glagoliticsupplement}', "");
    Expect(0, 122928, '\p{Is_Block=glagoliticsupplement}', "");
    Expect(1, 122928, '\p{^Is_Block=glagoliticsupplement}', "");
    Expect(1, 122928, '\P{Is_Block=glagoliticsupplement}', "");
    Expect(0, 122928, '\P{^Is_Block=glagoliticsupplement}', "");
    Expect(1, 122927, '\p{Is_Block=-glagolitic_supplement}', "");
    Expect(0, 122927, '\p{^Is_Block=-glagolitic_supplement}', "");
    Expect(0, 122927, '\P{Is_Block=-glagolitic_supplement}', "");
    Expect(1, 122927, '\P{^Is_Block=-glagolitic_supplement}', "");
    Expect(0, 122928, '\p{Is_Block=-glagolitic_supplement}', "");
    Expect(1, 122928, '\p{^Is_Block=-glagolitic_supplement}', "");
    Expect(1, 122928, '\P{Is_Block=-glagolitic_supplement}', "");
    Expect(0, 122928, '\P{^Is_Block=-glagolitic_supplement}', "");
    Error('\p{Is_Blk=:=- GLAGOLITIC_SUP}');
    Error('\P{Is_Blk=:=- GLAGOLITIC_SUP}');
    Expect(1, 122927, '\p{Is_Blk=glagoliticsup}', "");
    Expect(0, 122927, '\p{^Is_Blk=glagoliticsup}', "");
    Expect(0, 122927, '\P{Is_Blk=glagoliticsup}', "");
    Expect(1, 122927, '\P{^Is_Blk=glagoliticsup}', "");
    Expect(0, 122928, '\p{Is_Blk=glagoliticsup}', "");
    Expect(1, 122928, '\p{^Is_Blk=glagoliticsup}', "");
    Expect(1, 122928, '\P{Is_Blk=glagoliticsup}', "");
    Expect(0, 122928, '\P{^Is_Blk=glagoliticsup}', "");
    Expect(1, 122927, '\p{Is_Blk=_	GLAGOLITIC_sup}', "");
    Expect(0, 122927, '\p{^Is_Blk=_	GLAGOLITIC_sup}', "");
    Expect(0, 122927, '\P{Is_Blk=_	GLAGOLITIC_sup}', "");
    Expect(1, 122927, '\P{^Is_Blk=_	GLAGOLITIC_sup}', "");
    Expect(0, 122928, '\p{Is_Blk=_	GLAGOLITIC_sup}', "");
    Expect(1, 122928, '\p{^Is_Blk=_	GLAGOLITIC_sup}', "");
    Expect(1, 122928, '\P{Is_Blk=_	GLAGOLITIC_sup}', "");
    Expect(0, 122928, '\P{^Is_Blk=_	GLAGOLITIC_sup}', "");
    Error('\p{Block=:=-Gothic}');
    Error('\P{Block=:=-Gothic}');
    Expect(1, 66383, '\p{Block=:\AGothic\z:}', "");;
    Expect(0, 66384, '\p{Block=:\AGothic\z:}', "");;
    Expect(1, 66383, '\p{Block=gothic}', "");
    Expect(0, 66383, '\p{^Block=gothic}', "");
    Expect(0, 66383, '\P{Block=gothic}', "");
    Expect(1, 66383, '\P{^Block=gothic}', "");
    Expect(0, 66384, '\p{Block=gothic}', "");
    Expect(1, 66384, '\p{^Block=gothic}', "");
    Expect(1, 66384, '\P{Block=gothic}', "");
    Expect(0, 66384, '\P{^Block=gothic}', "");
    Expect(1, 66383, '\p{Block=:\Agothic\z:}', "");;
    Expect(0, 66384, '\p{Block=:\Agothic\z:}', "");;
    Expect(1, 66383, '\p{Block=	gothic}', "");
    Expect(0, 66383, '\p{^Block=	gothic}', "");
    Expect(0, 66383, '\P{Block=	gothic}', "");
    Expect(1, 66383, '\P{^Block=	gothic}', "");
    Expect(0, 66384, '\p{Block=	gothic}', "");
    Expect(1, 66384, '\p{^Block=	gothic}', "");
    Expect(1, 66384, '\P{Block=	gothic}', "");
    Expect(0, 66384, '\P{^Block=	gothic}', "");
    Error('\p{Blk:		Gothic/a/}');
    Error('\P{Blk:		Gothic/a/}');
    Expect(1, 66383, '\p{Blk=:\AGothic\z:}', "");;
    Expect(0, 66384, '\p{Blk=:\AGothic\z:}', "");;
    Expect(1, 66383, '\p{Blk=gothic}', "");
    Expect(0, 66383, '\p{^Blk=gothic}', "");
    Expect(0, 66383, '\P{Blk=gothic}', "");
    Expect(1, 66383, '\P{^Blk=gothic}', "");
    Expect(0, 66384, '\p{Blk=gothic}', "");
    Expect(1, 66384, '\p{^Blk=gothic}', "");
    Expect(1, 66384, '\P{Blk=gothic}', "");
    Expect(0, 66384, '\P{^Blk=gothic}', "");
    Expect(1, 66383, '\p{Blk=:\Agothic\z:}', "");;
    Expect(0, 66384, '\p{Blk=:\Agothic\z:}', "");;
    Expect(1, 66383, '\p{Blk=_	Gothic}', "");
    Expect(0, 66383, '\p{^Blk=_	Gothic}', "");
    Expect(0, 66383, '\P{Blk=_	Gothic}', "");
    Expect(1, 66383, '\P{^Blk=_	Gothic}', "");
    Expect(0, 66384, '\p{Blk=_	Gothic}', "");
    Expect(1, 66384, '\p{^Blk=_	Gothic}', "");
    Expect(1, 66384, '\P{Blk=_	Gothic}', "");
    Expect(0, 66384, '\P{^Blk=_	Gothic}', "");
    Error('\p{Is_Block=	:=gothic}');
    Error('\P{Is_Block=	:=gothic}');
    Expect(1, 66383, '\p{Is_Block=gothic}', "");
    Expect(0, 66383, '\p{^Is_Block=gothic}', "");
    Expect(0, 66383, '\P{Is_Block=gothic}', "");
    Expect(1, 66383, '\P{^Is_Block=gothic}', "");
    Expect(0, 66384, '\p{Is_Block=gothic}', "");
    Expect(1, 66384, '\p{^Is_Block=gothic}', "");
    Expect(1, 66384, '\P{Is_Block=gothic}', "");
    Expect(0, 66384, '\P{^Is_Block=gothic}', "");
    Expect(1, 66383, '\p{Is_Block:   - gothic}', "");
    Expect(0, 66383, '\p{^Is_Block:   - gothic}', "");
    Expect(0, 66383, '\P{Is_Block:   - gothic}', "");
    Expect(1, 66383, '\P{^Is_Block:   - gothic}', "");
    Expect(0, 66384, '\p{Is_Block:   - gothic}', "");
    Expect(1, 66384, '\p{^Is_Block:   - gothic}', "");
    Expect(1, 66384, '\P{Is_Block:   - gothic}', "");
    Expect(0, 66384, '\P{^Is_Block:   - gothic}', "");
    Error('\p{Is_Blk=- Gothic/a/}');
    Error('\P{Is_Blk=- Gothic/a/}');
    Expect(1, 66383, '\p{Is_Blk=gothic}', "");
    Expect(0, 66383, '\p{^Is_Blk=gothic}', "");
    Expect(0, 66383, '\P{Is_Blk=gothic}', "");
    Expect(1, 66383, '\P{^Is_Blk=gothic}', "");
    Expect(0, 66384, '\p{Is_Blk=gothic}', "");
    Expect(1, 66384, '\p{^Is_Blk=gothic}', "");
    Expect(1, 66384, '\P{Is_Blk=gothic}', "");
    Expect(0, 66384, '\P{^Is_Blk=gothic}', "");
    Expect(1, 66383, '\p{Is_Blk=	gothic}', "");
    Expect(0, 66383, '\p{^Is_Blk=	gothic}', "");
    Expect(0, 66383, '\P{Is_Blk=	gothic}', "");
    Expect(1, 66383, '\P{^Is_Blk=	gothic}', "");
    Expect(0, 66384, '\p{Is_Blk=	gothic}', "");
    Expect(1, 66384, '\p{^Is_Blk=	gothic}', "");
    Expect(1, 66384, '\P{Is_Blk=	gothic}', "");
    Expect(0, 66384, '\P{^Is_Blk=	gothic}', "");
    Error('\p{Block=/a/_Grantha}');
    Error('\P{Block=/a/_Grantha}');
    Expect(1, 70527, '\p{Block=:\AGrantha\z:}', "");;
    Expect(0, 70528, '\p{Block=:\AGrantha\z:}', "");;
    Expect(1, 70527, '\p{Block=grantha}', "");
    Expect(0, 70527, '\p{^Block=grantha}', "");
    Expect(0, 70527, '\P{Block=grantha}', "");
    Expect(1, 70527, '\P{^Block=grantha}', "");
    Expect(0, 70528, '\p{Block=grantha}', "");
    Expect(1, 70528, '\p{^Block=grantha}', "");
    Expect(1, 70528, '\P{Block=grantha}', "");
    Expect(0, 70528, '\P{^Block=grantha}', "");
    Expect(1, 70527, '\p{Block=:\Agrantha\z:}', "");;
    Expect(0, 70528, '\p{Block=:\Agrantha\z:}', "");;
    Expect(1, 70527, '\p{Block=_GRANTHA}', "");
    Expect(0, 70527, '\p{^Block=_GRANTHA}', "");
    Expect(0, 70527, '\P{Block=_GRANTHA}', "");
    Expect(1, 70527, '\P{^Block=_GRANTHA}', "");
    Expect(0, 70528, '\p{Block=_GRANTHA}', "");
    Expect(1, 70528, '\p{^Block=_GRANTHA}', "");
    Expect(1, 70528, '\P{Block=_GRANTHA}', "");
    Expect(0, 70528, '\P{^Block=_GRANTHA}', "");
    Error('\p{Blk: 	 GRANTHA/a/}');
    Error('\P{Blk: 	 GRANTHA/a/}');
    Expect(1, 70527, '\p{Blk=:\AGrantha\z:}', "");;
    Expect(0, 70528, '\p{Blk=:\AGrantha\z:}', "");;
    Expect(1, 70527, '\p{Blk=grantha}', "");
    Expect(0, 70527, '\p{^Blk=grantha}', "");
    Expect(0, 70527, '\P{Blk=grantha}', "");
    Expect(1, 70527, '\P{^Blk=grantha}', "");
    Expect(0, 70528, '\p{Blk=grantha}', "");
    Expect(1, 70528, '\p{^Blk=grantha}', "");
    Expect(1, 70528, '\P{Blk=grantha}', "");
    Expect(0, 70528, '\P{^Blk=grantha}', "");
    Expect(1, 70527, '\p{Blk=:\Agrantha\z:}', "");;
    Expect(0, 70528, '\p{Blk=:\Agrantha\z:}', "");;
    Expect(1, 70527, '\p{Blk=-GRANTHA}', "");
    Expect(0, 70527, '\p{^Blk=-GRANTHA}', "");
    Expect(0, 70527, '\P{Blk=-GRANTHA}', "");
    Expect(1, 70527, '\P{^Blk=-GRANTHA}', "");
    Expect(0, 70528, '\p{Blk=-GRANTHA}', "");
    Expect(1, 70528, '\p{^Blk=-GRANTHA}', "");
    Expect(1, 70528, '\P{Blk=-GRANTHA}', "");
    Expect(0, 70528, '\P{^Blk=-GRANTHA}', "");
    Error('\p{Is_Block=:=-grantha}');
    Error('\P{Is_Block=:=-grantha}');
    Expect(1, 70527, '\p{Is_Block=grantha}', "");
    Expect(0, 70527, '\p{^Is_Block=grantha}', "");
    Expect(0, 70527, '\P{Is_Block=grantha}', "");
    Expect(1, 70527, '\P{^Is_Block=grantha}', "");
    Expect(0, 70528, '\p{Is_Block=grantha}', "");
    Expect(1, 70528, '\p{^Is_Block=grantha}', "");
    Expect(1, 70528, '\P{Is_Block=grantha}', "");
    Expect(0, 70528, '\P{^Is_Block=grantha}', "");
    Expect(1, 70527, '\p{Is_Block= -Grantha}', "");
    Expect(0, 70527, '\p{^Is_Block= -Grantha}', "");
    Expect(0, 70527, '\P{Is_Block= -Grantha}', "");
    Expect(1, 70527, '\P{^Is_Block= -Grantha}', "");
    Expect(0, 70528, '\p{Is_Block= -Grantha}', "");
    Expect(1, 70528, '\p{^Is_Block= -Grantha}', "");
    Expect(1, 70528, '\P{Is_Block= -Grantha}', "");
    Expect(0, 70528, '\P{^Is_Block= -Grantha}', "");
    Error('\p{Is_Blk: -_Grantha/a/}');
    Error('\P{Is_Blk: -_Grantha/a/}');
    Expect(1, 70527, '\p{Is_Blk=grantha}', "");
    Expect(0, 70527, '\p{^Is_Blk=grantha}', "");
    Expect(0, 70527, '\P{Is_Blk=grantha}', "");
    Expect(1, 70527, '\P{^Is_Blk=grantha}', "");
    Expect(0, 70528, '\p{Is_Blk=grantha}', "");
    Expect(1, 70528, '\p{^Is_Blk=grantha}', "");
    Expect(1, 70528, '\P{Is_Blk=grantha}', "");
    Expect(0, 70528, '\P{^Is_Blk=grantha}', "");
    Expect(1, 70527, '\p{Is_Blk=_ Grantha}', "");
    Expect(0, 70527, '\p{^Is_Blk=_ Grantha}', "");
    Expect(0, 70527, '\P{Is_Blk=_ Grantha}', "");
    Expect(1, 70527, '\P{^Is_Blk=_ Grantha}', "");
    Expect(0, 70528, '\p{Is_Blk=_ Grantha}', "");
    Expect(1, 70528, '\p{^Is_Blk=_ Grantha}', "");
    Expect(1, 70528, '\P{Is_Blk=_ Grantha}', "");
    Expect(0, 70528, '\P{^Is_Blk=_ Grantha}', "");
    Error('\p{Block=_/a/GREEK_AND_Coptic}');
    Error('\P{Block=_/a/GREEK_AND_Coptic}');
    Expect(1, 1023, '\p{Block=:\AGreek_And_Coptic\z:}', "");;
    Expect(0, 1024, '\p{Block=:\AGreek_And_Coptic\z:}', "");;
    Expect(1, 1023, '\p{Block=greekandcoptic}', "");
    Expect(0, 1023, '\p{^Block=greekandcoptic}', "");
    Expect(0, 1023, '\P{Block=greekandcoptic}', "");
    Expect(1, 1023, '\P{^Block=greekandcoptic}', "");
    Expect(0, 1024, '\p{Block=greekandcoptic}', "");
    Expect(1, 1024, '\p{^Block=greekandcoptic}', "");
    Expect(1, 1024, '\P{Block=greekandcoptic}', "");
    Expect(0, 1024, '\P{^Block=greekandcoptic}', "");
    Expect(1, 1023, '\p{Block=:\Agreekandcoptic\z:}', "");;
    Expect(0, 1024, '\p{Block=:\Agreekandcoptic\z:}', "");;
    Expect(1, 1023, '\p{Block= Greek_And_coptic}', "");
    Expect(0, 1023, '\p{^Block= Greek_And_coptic}', "");
    Expect(0, 1023, '\P{Block= Greek_And_coptic}', "");
    Expect(1, 1023, '\P{^Block= Greek_And_coptic}', "");
    Expect(0, 1024, '\p{Block= Greek_And_coptic}', "");
    Expect(1, 1024, '\p{^Block= Greek_And_coptic}', "");
    Expect(1, 1024, '\P{Block= Greek_And_coptic}', "");
    Expect(0, 1024, '\P{^Block= Greek_And_coptic}', "");
    Error('\p{Blk= /a/greek}');
    Error('\P{Blk= /a/greek}');
    Expect(1, 1023, '\p{Blk=:\AGreek\z:}', "");;
    Expect(0, 1024, '\p{Blk=:\AGreek\z:}', "");;
    Expect(1, 1023, '\p{Blk=greek}', "");
    Expect(0, 1023, '\p{^Blk=greek}', "");
    Expect(0, 1023, '\P{Blk=greek}', "");
    Expect(1, 1023, '\P{^Blk=greek}', "");
    Expect(0, 1024, '\p{Blk=greek}', "");
    Expect(1, 1024, '\p{^Blk=greek}', "");
    Expect(1, 1024, '\P{Blk=greek}', "");
    Expect(0, 1024, '\P{^Blk=greek}', "");
    Expect(1, 1023, '\p{Blk=:\Agreek\z:}', "");;
    Expect(0, 1024, '\p{Blk=:\Agreek\z:}', "");;
    Expect(1, 1023, '\p{Blk=-	greek}', "");
    Expect(0, 1023, '\p{^Blk=-	greek}', "");
    Expect(0, 1023, '\P{Blk=-	greek}', "");
    Expect(1, 1023, '\P{^Blk=-	greek}', "");
    Expect(0, 1024, '\p{Blk=-	greek}', "");
    Expect(1, 1024, '\p{^Blk=-	greek}', "");
    Expect(1, 1024, '\P{Blk=-	greek}', "");
    Expect(0, 1024, '\P{^Blk=-	greek}', "");
    Error('\p{Is_Block=_:=greek_And_Coptic}');
    Error('\P{Is_Block=_:=greek_And_Coptic}');
    Expect(1, 1023, '\p{Is_Block=greekandcoptic}', "");
    Expect(0, 1023, '\p{^Is_Block=greekandcoptic}', "");
    Expect(0, 1023, '\P{Is_Block=greekandcoptic}', "");
    Expect(1, 1023, '\P{^Is_Block=greekandcoptic}', "");
    Expect(0, 1024, '\p{Is_Block=greekandcoptic}', "");
    Expect(1, 1024, '\p{^Is_Block=greekandcoptic}', "");
    Expect(1, 1024, '\P{Is_Block=greekandcoptic}', "");
    Expect(0, 1024, '\P{^Is_Block=greekandcoptic}', "");
    Expect(1, 1023, '\p{Is_Block=_ Greek_AND_COPTIC}', "");
    Expect(0, 1023, '\p{^Is_Block=_ Greek_AND_COPTIC}', "");
    Expect(0, 1023, '\P{Is_Block=_ Greek_AND_COPTIC}', "");
    Expect(1, 1023, '\P{^Is_Block=_ Greek_AND_COPTIC}', "");
    Expect(0, 1024, '\p{Is_Block=_ Greek_AND_COPTIC}', "");
    Expect(1, 1024, '\p{^Is_Block=_ Greek_AND_COPTIC}', "");
    Expect(1, 1024, '\P{Is_Block=_ Greek_AND_COPTIC}', "");
    Expect(0, 1024, '\P{^Is_Block=_ Greek_AND_COPTIC}', "");
    Error('\p{Is_Blk=		Greek:=}');
    Error('\P{Is_Blk=		Greek:=}');
    Expect(1, 1023, '\p{Is_Blk=greek}', "");
    Expect(0, 1023, '\p{^Is_Blk=greek}', "");
    Expect(0, 1023, '\P{Is_Blk=greek}', "");
    Expect(1, 1023, '\P{^Is_Blk=greek}', "");
    Expect(0, 1024, '\p{Is_Blk=greek}', "");
    Expect(1, 1024, '\p{^Is_Blk=greek}', "");
    Expect(1, 1024, '\P{Is_Blk=greek}', "");
    Expect(0, 1024, '\P{^Is_Blk=greek}', "");
    Expect(1, 1023, '\p{Is_Blk=-	Greek}', "");
    Expect(0, 1023, '\p{^Is_Blk=-	Greek}', "");
    Expect(0, 1023, '\P{Is_Blk=-	Greek}', "");
    Expect(1, 1023, '\P{^Is_Blk=-	Greek}', "");
    Expect(0, 1024, '\p{Is_Blk=-	Greek}', "");
    Expect(1, 1024, '\p{^Is_Blk=-	Greek}', "");
    Expect(1, 1024, '\P{Is_Blk=-	Greek}', "");
    Expect(0, 1024, '\P{^Is_Blk=-	Greek}', "");
    Error('\p{Block=Greek_EXTENDED:=}');
    Error('\P{Block=Greek_EXTENDED:=}');
    Expect(1, 8191, '\p{Block=:\AGreek_Extended\z:}', "");;
    Expect(0, 8192, '\p{Block=:\AGreek_Extended\z:}', "");;
    Expect(1, 8191, '\p{Block=greekextended}', "");
    Expect(0, 8191, '\p{^Block=greekextended}', "");
    Expect(0, 8191, '\P{Block=greekextended}', "");
    Expect(1, 8191, '\P{^Block=greekextended}', "");
    Expect(0, 8192, '\p{Block=greekextended}', "");
    Expect(1, 8192, '\p{^Block=greekextended}', "");
    Expect(1, 8192, '\P{Block=greekextended}', "");
    Expect(0, 8192, '\P{^Block=greekextended}', "");
    Expect(1, 8191, '\p{Block=:\Agreekextended\z:}', "");;
    Expect(0, 8192, '\p{Block=:\Agreekextended\z:}', "");;
    Expect(1, 8191, '\p{Block= greek_Extended}', "");
    Expect(0, 8191, '\p{^Block= greek_Extended}', "");
    Expect(0, 8191, '\P{Block= greek_Extended}', "");
    Expect(1, 8191, '\P{^Block= greek_Extended}', "");
    Expect(0, 8192, '\p{Block= greek_Extended}', "");
    Expect(1, 8192, '\p{^Block= greek_Extended}', "");
    Expect(1, 8192, '\P{Block= greek_Extended}', "");
    Expect(0, 8192, '\P{^Block= greek_Extended}', "");
    Error('\p{Blk=	:=greek_EXT}');
    Error('\P{Blk=	:=greek_EXT}');
    Expect(1, 8191, '\p{Blk=:\AGreek_Ext\z:}', "");;
    Expect(0, 8192, '\p{Blk=:\AGreek_Ext\z:}', "");;
    Expect(1, 8191, '\p{Blk=greekext}', "");
    Expect(0, 8191, '\p{^Blk=greekext}', "");
    Expect(0, 8191, '\P{Blk=greekext}', "");
    Expect(1, 8191, '\P{^Blk=greekext}', "");
    Expect(0, 8192, '\p{Blk=greekext}', "");
    Expect(1, 8192, '\p{^Blk=greekext}', "");
    Expect(1, 8192, '\P{Blk=greekext}', "");
    Expect(0, 8192, '\P{^Blk=greekext}', "");
    Expect(1, 8191, '\p{Blk=:\Agreekext\z:}', "");;
    Expect(0, 8192, '\p{Blk=:\Agreekext\z:}', "");;
    Expect(1, 8191, '\p{Blk=__Greek_Ext}', "");
    Expect(0, 8191, '\p{^Blk=__Greek_Ext}', "");
    Expect(0, 8191, '\P{Blk=__Greek_Ext}', "");
    Expect(1, 8191, '\P{^Blk=__Greek_Ext}', "");
    Expect(0, 8192, '\p{Blk=__Greek_Ext}', "");
    Expect(1, 8192, '\p{^Blk=__Greek_Ext}', "");
    Expect(1, 8192, '\P{Blk=__Greek_Ext}', "");
    Expect(0, 8192, '\P{^Blk=__Greek_Ext}', "");
    Error('\p{Is_Block=-greek_extended/a/}');
    Error('\P{Is_Block=-greek_extended/a/}');
    Expect(1, 8191, '\p{Is_Block=greekextended}', "");
    Expect(0, 8191, '\p{^Is_Block=greekextended}', "");
    Expect(0, 8191, '\P{Is_Block=greekextended}', "");
    Expect(1, 8191, '\P{^Is_Block=greekextended}', "");
    Expect(0, 8192, '\p{Is_Block=greekextended}', "");
    Expect(1, 8192, '\p{^Is_Block=greekextended}', "");
    Expect(1, 8192, '\P{Is_Block=greekextended}', "");
    Expect(0, 8192, '\P{^Is_Block=greekextended}', "");
    Expect(1, 8191, '\p{Is_Block=	GREEK_EXTENDED}', "");
    Expect(0, 8191, '\p{^Is_Block=	GREEK_EXTENDED}', "");
    Expect(0, 8191, '\P{Is_Block=	GREEK_EXTENDED}', "");
    Expect(1, 8191, '\P{^Is_Block=	GREEK_EXTENDED}', "");
    Expect(0, 8192, '\p{Is_Block=	GREEK_EXTENDED}', "");
    Expect(1, 8192, '\p{^Is_Block=	GREEK_EXTENDED}', "");
    Expect(1, 8192, '\P{Is_Block=	GREEK_EXTENDED}', "");
    Expect(0, 8192, '\P{^Is_Block=	GREEK_EXTENDED}', "");
    Error('\p{Is_Blk=/a/- greek_Ext}');
    Error('\P{Is_Blk=/a/- greek_Ext}');
    Expect(1, 8191, '\p{Is_Blk:greekext}', "");
    Expect(0, 8191, '\p{^Is_Blk:greekext}', "");
    Expect(0, 8191, '\P{Is_Blk:greekext}', "");
    Expect(1, 8191, '\P{^Is_Blk:greekext}', "");
    Expect(0, 8192, '\p{Is_Blk:greekext}', "");
    Expect(1, 8192, '\p{^Is_Blk:greekext}', "");
    Expect(1, 8192, '\P{Is_Blk:greekext}', "");
    Expect(0, 8192, '\P{^Is_Blk:greekext}', "");
    Expect(1, 8191, '\p{Is_Blk=-_Greek_Ext}', "");
    Expect(0, 8191, '\p{^Is_Blk=-_Greek_Ext}', "");
    Expect(0, 8191, '\P{Is_Blk=-_Greek_Ext}', "");
    Expect(1, 8191, '\P{^Is_Blk=-_Greek_Ext}', "");
    Expect(0, 8192, '\p{Is_Blk=-_Greek_Ext}', "");
    Expect(1, 8192, '\p{^Is_Blk=-_Greek_Ext}', "");
    Expect(1, 8192, '\P{Is_Blk=-_Greek_Ext}', "");
    Expect(0, 8192, '\P{^Is_Blk=-_Greek_Ext}', "");
    Error('\p{Block=:=gujarati}');
    Error('\P{Block=:=gujarati}');
    Expect(1, 2815, '\p{Block=:\AGujarati\z:}', "");;
    Expect(0, 2816, '\p{Block=:\AGujarati\z:}', "");;
    Expect(1, 2815, '\p{Block=gujarati}', "");
    Expect(0, 2815, '\p{^Block=gujarati}', "");
    Expect(0, 2815, '\P{Block=gujarati}', "");
    Expect(1, 2815, '\P{^Block=gujarati}', "");
    Expect(0, 2816, '\p{Block=gujarati}', "");
    Expect(1, 2816, '\p{^Block=gujarati}', "");
    Expect(1, 2816, '\P{Block=gujarati}', "");
    Expect(0, 2816, '\P{^Block=gujarati}', "");
    Expect(1, 2815, '\p{Block=:\Agujarati\z:}', "");;
    Expect(0, 2816, '\p{Block=:\Agujarati\z:}', "");;
    Expect(1, 2815, '\p{Block= -gujarati}', "");
    Expect(0, 2815, '\p{^Block= -gujarati}', "");
    Expect(0, 2815, '\P{Block= -gujarati}', "");
    Expect(1, 2815, '\P{^Block= -gujarati}', "");
    Expect(0, 2816, '\p{Block= -gujarati}', "");
    Expect(1, 2816, '\p{^Block= -gujarati}', "");
    Expect(1, 2816, '\P{Block= -gujarati}', "");
    Expect(0, 2816, '\P{^Block= -gujarati}', "");
    Error('\p{Blk=/a/	-Gujarati}');
    Error('\P{Blk=/a/	-Gujarati}');
    Expect(1, 2815, '\p{Blk=:\AGujarati\z:}', "");;
    Expect(0, 2816, '\p{Blk=:\AGujarati\z:}', "");;
    Expect(1, 2815, '\p{Blk=gujarati}', "");
    Expect(0, 2815, '\p{^Blk=gujarati}', "");
    Expect(0, 2815, '\P{Blk=gujarati}', "");
    Expect(1, 2815, '\P{^Blk=gujarati}', "");
    Expect(0, 2816, '\p{Blk=gujarati}', "");
    Expect(1, 2816, '\p{^Blk=gujarati}', "");
    Expect(1, 2816, '\P{Blk=gujarati}', "");
    Expect(0, 2816, '\P{^Blk=gujarati}', "");
    Expect(1, 2815, '\p{Blk=:\Agujarati\z:}', "");;
    Expect(0, 2816, '\p{Blk=:\Agujarati\z:}', "");;
    Expect(1, 2815, '\p{Blk= gujarati}', "");
    Expect(0, 2815, '\p{^Blk= gujarati}', "");
    Expect(0, 2815, '\P{Blk= gujarati}', "");
    Expect(1, 2815, '\P{^Blk= gujarati}', "");
    Expect(0, 2816, '\p{Blk= gujarati}', "");
    Expect(1, 2816, '\p{^Blk= gujarati}', "");
    Expect(1, 2816, '\P{Blk= gujarati}', "");
    Expect(0, 2816, '\P{^Blk= gujarati}', "");
    Error('\p{Is_Block= GUJARATI:=}');
    Error('\P{Is_Block= GUJARATI:=}');
    Expect(1, 2815, '\p{Is_Block=gujarati}', "");
    Expect(0, 2815, '\p{^Is_Block=gujarati}', "");
    Expect(0, 2815, '\P{Is_Block=gujarati}', "");
    Expect(1, 2815, '\P{^Is_Block=gujarati}', "");
    Expect(0, 2816, '\p{Is_Block=gujarati}', "");
    Expect(1, 2816, '\p{^Is_Block=gujarati}', "");
    Expect(1, 2816, '\P{Is_Block=gujarati}', "");
    Expect(0, 2816, '\P{^Is_Block=gujarati}', "");
    Expect(1, 2815, '\p{Is_Block:-GUJARATI}', "");
    Expect(0, 2815, '\p{^Is_Block:-GUJARATI}', "");
    Expect(0, 2815, '\P{Is_Block:-GUJARATI}', "");
    Expect(1, 2815, '\P{^Is_Block:-GUJARATI}', "");
    Expect(0, 2816, '\p{Is_Block:-GUJARATI}', "");
    Expect(1, 2816, '\p{^Is_Block:-GUJARATI}', "");
    Expect(1, 2816, '\P{Is_Block:-GUJARATI}', "");
    Expect(0, 2816, '\P{^Is_Block:-GUJARATI}', "");
    Error('\p{Is_Blk=:=-Gujarati}');
    Error('\P{Is_Blk=:=-Gujarati}');
    Expect(1, 2815, '\p{Is_Blk=gujarati}', "");
    Expect(0, 2815, '\p{^Is_Blk=gujarati}', "");
    Expect(0, 2815, '\P{Is_Blk=gujarati}', "");
    Expect(1, 2815, '\P{^Is_Blk=gujarati}', "");
    Expect(0, 2816, '\p{Is_Blk=gujarati}', "");
    Expect(1, 2816, '\p{^Is_Blk=gujarati}', "");
    Expect(1, 2816, '\P{Is_Blk=gujarati}', "");
    Expect(0, 2816, '\P{^Is_Blk=gujarati}', "");
    Expect(1, 2815, '\p{Is_Blk=_Gujarati}', "");
    Expect(0, 2815, '\p{^Is_Blk=_Gujarati}', "");
    Expect(0, 2815, '\P{Is_Blk=_Gujarati}', "");
    Expect(1, 2815, '\P{^Is_Blk=_Gujarati}', "");
    Expect(0, 2816, '\p{Is_Blk=_Gujarati}', "");
    Expect(1, 2816, '\p{^Is_Blk=_Gujarati}', "");
    Expect(1, 2816, '\P{Is_Blk=_Gujarati}', "");
    Expect(0, 2816, '\P{^Is_Blk=_Gujarati}', "");
    Error('\p{Block=	:=Gunjala_gondi}');
    Error('\P{Block=	:=Gunjala_gondi}');
    Expect(1, 73135, '\p{Block=:\AGunjala_Gondi\z:}', "");;
    Expect(0, 73136, '\p{Block=:\AGunjala_Gondi\z:}', "");;
    Expect(1, 73135, '\p{Block:gunjalagondi}', "");
    Expect(0, 73135, '\p{^Block:gunjalagondi}', "");
    Expect(0, 73135, '\P{Block:gunjalagondi}', "");
    Expect(1, 73135, '\P{^Block:gunjalagondi}', "");
    Expect(0, 73136, '\p{Block:gunjalagondi}', "");
    Expect(1, 73136, '\p{^Block:gunjalagondi}', "");
    Expect(1, 73136, '\P{Block:gunjalagondi}', "");
    Expect(0, 73136, '\P{^Block:gunjalagondi}', "");
    Expect(1, 73135, '\p{Block=:\Agunjalagondi\z:}', "");;
    Expect(0, 73136, '\p{Block=:\Agunjalagondi\z:}', "");;
    Expect(1, 73135, '\p{Block=-	gunjala_Gondi}', "");
    Expect(0, 73135, '\p{^Block=-	gunjala_Gondi}', "");
    Expect(0, 73135, '\P{Block=-	gunjala_Gondi}', "");
    Expect(1, 73135, '\P{^Block=-	gunjala_Gondi}', "");
    Expect(0, 73136, '\p{Block=-	gunjala_Gondi}', "");
    Expect(1, 73136, '\p{^Block=-	gunjala_Gondi}', "");
    Expect(1, 73136, '\P{Block=-	gunjala_Gondi}', "");
    Expect(0, 73136, '\P{^Block=-	gunjala_Gondi}', "");
    Error('\p{Blk=		GUNJALA_Gondi:=}');
    Error('\P{Blk=		GUNJALA_Gondi:=}');
    Expect(1, 73135, '\p{Blk=:\AGunjala_Gondi\z:}', "");;
    Expect(0, 73136, '\p{Blk=:\AGunjala_Gondi\z:}', "");;
    Expect(1, 73135, '\p{Blk=gunjalagondi}', "");
    Expect(0, 73135, '\p{^Blk=gunjalagondi}', "");
    Expect(0, 73135, '\P{Blk=gunjalagondi}', "");
    Expect(1, 73135, '\P{^Blk=gunjalagondi}', "");
    Expect(0, 73136, '\p{Blk=gunjalagondi}', "");
    Expect(1, 73136, '\p{^Blk=gunjalagondi}', "");
    Expect(1, 73136, '\P{Blk=gunjalagondi}', "");
    Expect(0, 73136, '\P{^Blk=gunjalagondi}', "");
    Expect(1, 73135, '\p{Blk=:\Agunjalagondi\z:}', "");;
    Expect(0, 73136, '\p{Blk=:\Agunjalagondi\z:}', "");;
    Expect(1, 73135, '\p{Blk=--GUNJALA_Gondi}', "");
    Expect(0, 73135, '\p{^Blk=--GUNJALA_Gondi}', "");
    Expect(0, 73135, '\P{Blk=--GUNJALA_Gondi}', "");
    Expect(1, 73135, '\P{^Blk=--GUNJALA_Gondi}', "");
    Expect(0, 73136, '\p{Blk=--GUNJALA_Gondi}', "");
    Expect(1, 73136, '\p{^Blk=--GUNJALA_Gondi}', "");
    Expect(1, 73136, '\P{Blk=--GUNJALA_Gondi}', "");
    Expect(0, 73136, '\P{^Blk=--GUNJALA_Gondi}', "");
    Error('\p{Is_Block=	:=Gunjala_Gondi}');
    Error('\P{Is_Block=	:=Gunjala_Gondi}');
    Expect(1, 73135, '\p{Is_Block=gunjalagondi}', "");
    Expect(0, 73135, '\p{^Is_Block=gunjalagondi}', "");
    Expect(0, 73135, '\P{Is_Block=gunjalagondi}', "");
    Expect(1, 73135, '\P{^Is_Block=gunjalagondi}', "");
    Expect(0, 73136, '\p{Is_Block=gunjalagondi}', "");
    Expect(1, 73136, '\p{^Is_Block=gunjalagondi}', "");
    Expect(1, 73136, '\P{Is_Block=gunjalagondi}', "");
    Expect(0, 73136, '\P{^Is_Block=gunjalagondi}', "");
    Expect(1, 73135, '\p{Is_Block=		gunjala_Gondi}', "");
    Expect(0, 73135, '\p{^Is_Block=		gunjala_Gondi}', "");
    Expect(0, 73135, '\P{Is_Block=		gunjala_Gondi}', "");
    Expect(1, 73135, '\P{^Is_Block=		gunjala_Gondi}', "");
    Expect(0, 73136, '\p{Is_Block=		gunjala_Gondi}', "");
    Expect(1, 73136, '\p{^Is_Block=		gunjala_Gondi}', "");
    Expect(1, 73136, '\P{Is_Block=		gunjala_Gondi}', "");
    Expect(0, 73136, '\P{^Is_Block=		gunjala_Gondi}', "");
    Error('\p{Is_Blk=:=	GUNJALA_Gondi}');
    Error('\P{Is_Blk=:=	GUNJALA_Gondi}');
    Expect(1, 73135, '\p{Is_Blk=gunjalagondi}', "");
    Expect(0, 73135, '\p{^Is_Blk=gunjalagondi}', "");
    Expect(0, 73135, '\P{Is_Blk=gunjalagondi}', "");
    Expect(1, 73135, '\P{^Is_Blk=gunjalagondi}', "");
    Expect(0, 73136, '\p{Is_Blk=gunjalagondi}', "");
    Expect(1, 73136, '\p{^Is_Blk=gunjalagondi}', "");
    Expect(1, 73136, '\P{Is_Blk=gunjalagondi}', "");
    Expect(0, 73136, '\P{^Is_Blk=gunjalagondi}', "");
    Expect(1, 73135, '\p{Is_Blk:    _gunjala_gondi}', "");
    Expect(0, 73135, '\p{^Is_Blk:    _gunjala_gondi}', "");
    Expect(0, 73135, '\P{Is_Blk:    _gunjala_gondi}', "");
    Expect(1, 73135, '\P{^Is_Blk:    _gunjala_gondi}', "");
    Expect(0, 73136, '\p{Is_Blk:    _gunjala_gondi}', "");
    Expect(1, 73136, '\p{^Is_Blk:    _gunjala_gondi}', "");
    Expect(1, 73136, '\P{Is_Blk:    _gunjala_gondi}', "");
    Expect(0, 73136, '\P{^Is_Blk:    _gunjala_gondi}', "");
    Error('\p{Block: _:=Gurmukhi}');
    Error('\P{Block: _:=Gurmukhi}');
    Expect(1, 2687, '\p{Block=:\AGurmukhi\z:}', "");;
    Expect(0, 2688, '\p{Block=:\AGurmukhi\z:}', "");;
    Expect(1, 2687, '\p{Block=gurmukhi}', "");
    Expect(0, 2687, '\p{^Block=gurmukhi}', "");
    Expect(0, 2687, '\P{Block=gurmukhi}', "");
    Expect(1, 2687, '\P{^Block=gurmukhi}', "");
    Expect(0, 2688, '\p{Block=gurmukhi}', "");
    Expect(1, 2688, '\p{^Block=gurmukhi}', "");
    Expect(1, 2688, '\P{Block=gurmukhi}', "");
    Expect(0, 2688, '\P{^Block=gurmukhi}', "");
    Expect(1, 2687, '\p{Block=:\Agurmukhi\z:}', "");;
    Expect(0, 2688, '\p{Block=:\Agurmukhi\z:}', "");;
    Expect(1, 2687, '\p{Block=	gurmukhi}', "");
    Expect(0, 2687, '\p{^Block=	gurmukhi}', "");
    Expect(0, 2687, '\P{Block=	gurmukhi}', "");
    Expect(1, 2687, '\P{^Block=	gurmukhi}', "");
    Expect(0, 2688, '\p{Block=	gurmukhi}', "");
    Expect(1, 2688, '\p{^Block=	gurmukhi}', "");
    Expect(1, 2688, '\P{Block=	gurmukhi}', "");
    Expect(0, 2688, '\P{^Block=	gurmukhi}', "");
    Error('\p{Blk=:=Gurmukhi}');
    Error('\P{Blk=:=Gurmukhi}');
    Expect(1, 2687, '\p{Blk=:\AGurmukhi\z:}', "");;
    Expect(0, 2688, '\p{Blk=:\AGurmukhi\z:}', "");;
    Expect(1, 2687, '\p{Blk=gurmukhi}', "");
    Expect(0, 2687, '\p{^Blk=gurmukhi}', "");
    Expect(0, 2687, '\P{Blk=gurmukhi}', "");
    Expect(1, 2687, '\P{^Blk=gurmukhi}', "");
    Expect(0, 2688, '\p{Blk=gurmukhi}', "");
    Expect(1, 2688, '\p{^Blk=gurmukhi}', "");
    Expect(1, 2688, '\P{Blk=gurmukhi}', "");
    Expect(0, 2688, '\P{^Blk=gurmukhi}', "");
    Expect(1, 2687, '\p{Blk=:\Agurmukhi\z:}', "");;
    Expect(0, 2688, '\p{Blk=:\Agurmukhi\z:}', "");;
    Expect(1, 2687, '\p{Blk=	GURMUKHI}', "");
    Expect(0, 2687, '\p{^Blk=	GURMUKHI}', "");
    Expect(0, 2687, '\P{Blk=	GURMUKHI}', "");
    Expect(1, 2687, '\P{^Blk=	GURMUKHI}', "");
    Expect(0, 2688, '\p{Blk=	GURMUKHI}', "");
    Expect(1, 2688, '\p{^Blk=	GURMUKHI}', "");
    Expect(1, 2688, '\P{Blk=	GURMUKHI}', "");
    Expect(0, 2688, '\P{^Blk=	GURMUKHI}', "");
    Error('\p{Is_Block:   	:=Gurmukhi}');
    Error('\P{Is_Block:   	:=Gurmukhi}');
    Expect(1, 2687, '\p{Is_Block=gurmukhi}', "");
    Expect(0, 2687, '\p{^Is_Block=gurmukhi}', "");
    Expect(0, 2687, '\P{Is_Block=gurmukhi}', "");
    Expect(1, 2687, '\P{^Is_Block=gurmukhi}', "");
    Expect(0, 2688, '\p{Is_Block=gurmukhi}', "");
    Expect(1, 2688, '\p{^Is_Block=gurmukhi}', "");
    Expect(1, 2688, '\P{Is_Block=gurmukhi}', "");
    Expect(0, 2688, '\P{^Is_Block=gurmukhi}', "");
    Expect(1, 2687, '\p{Is_Block:	- Gurmukhi}', "");
    Expect(0, 2687, '\p{^Is_Block:	- Gurmukhi}', "");
    Expect(0, 2687, '\P{Is_Block:	- Gurmukhi}', "");
    Expect(1, 2687, '\P{^Is_Block:	- Gurmukhi}', "");
    Expect(0, 2688, '\p{Is_Block:	- Gurmukhi}', "");
    Expect(1, 2688, '\p{^Is_Block:	- Gurmukhi}', "");
    Expect(1, 2688, '\P{Is_Block:	- Gurmukhi}', "");
    Expect(0, 2688, '\P{^Is_Block:	- Gurmukhi}', "");
    Error('\p{Is_Blk=  gurmukhi:=}');
    Error('\P{Is_Blk=  gurmukhi:=}');
    Expect(1, 2687, '\p{Is_Blk=gurmukhi}', "");
    Expect(0, 2687, '\p{^Is_Blk=gurmukhi}', "");
    Expect(0, 2687, '\P{Is_Blk=gurmukhi}', "");
    Expect(1, 2687, '\P{^Is_Blk=gurmukhi}', "");
    Expect(0, 2688, '\p{Is_Blk=gurmukhi}', "");
    Expect(1, 2688, '\p{^Is_Blk=gurmukhi}', "");
    Expect(1, 2688, '\P{Is_Blk=gurmukhi}', "");
    Expect(0, 2688, '\P{^Is_Blk=gurmukhi}', "");
    Expect(1, 2687, '\p{Is_Blk=_Gurmukhi}', "");
    Expect(0, 2687, '\p{^Is_Blk=_Gurmukhi}', "");
    Expect(0, 2687, '\P{Is_Blk=_Gurmukhi}', "");
    Expect(1, 2687, '\P{^Is_Blk=_Gurmukhi}', "");
    Expect(0, 2688, '\p{Is_Blk=_Gurmukhi}', "");
    Expect(1, 2688, '\p{^Is_Blk=_Gurmukhi}', "");
    Expect(1, 2688, '\P{Is_Blk=_Gurmukhi}', "");
    Expect(0, 2688, '\P{^Is_Blk=_Gurmukhi}', "");
    Error('\p{Block=/a/	HALFWIDTH_And_Fullwidth_FORMS}');
    Error('\P{Block=/a/	HALFWIDTH_And_Fullwidth_FORMS}');
    Expect(1, 65519, '\p{Block=:\AHalfwidth_And_Fullwidth_Forms\z:}', "");;
    Expect(0, 65520, '\p{Block=:\AHalfwidth_And_Fullwidth_Forms\z:}', "");;
    Expect(1, 65519, '\p{Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65519, '\p{^Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65519, '\P{Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65519, '\P{^Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65520, '\p{Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65520, '\p{^Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65520, '\P{Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65520, '\P{^Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65519, '\p{Block=:\Ahalfwidthandfullwidthforms\z:}', "");;
    Expect(0, 65520, '\p{Block=:\Ahalfwidthandfullwidthforms\z:}', "");;
    Expect(1, 65519, '\p{Block=	-HALFWIDTH_AND_Fullwidth_forms}', "");
    Expect(0, 65519, '\p{^Block=	-HALFWIDTH_AND_Fullwidth_forms}', "");
    Expect(0, 65519, '\P{Block=	-HALFWIDTH_AND_Fullwidth_forms}', "");
    Expect(1, 65519, '\P{^Block=	-HALFWIDTH_AND_Fullwidth_forms}', "");
    Expect(0, 65520, '\p{Block=	-HALFWIDTH_AND_Fullwidth_forms}', "");
    Expect(1, 65520, '\p{^Block=	-HALFWIDTH_AND_Fullwidth_forms}', "");
    Expect(1, 65520, '\P{Block=	-HALFWIDTH_AND_Fullwidth_forms}', "");
    Expect(0, 65520, '\P{^Block=	-HALFWIDTH_AND_Fullwidth_forms}', "");
    Error('\p{Blk=-/a/half_And_Full_FORMS}');
    Error('\P{Blk=-/a/half_And_Full_FORMS}');
    Expect(1, 65519, '\p{Blk=:\AHalf_And_Full_Forms\z:}', "");;
    Expect(0, 65520, '\p{Blk=:\AHalf_And_Full_Forms\z:}', "");;
    Expect(1, 65519, '\p{Blk=halfandfullforms}', "");
    Expect(0, 65519, '\p{^Blk=halfandfullforms}', "");
    Expect(0, 65519, '\P{Blk=halfandfullforms}', "");
    Expect(1, 65519, '\P{^Blk=halfandfullforms}', "");
    Expect(0, 65520, '\p{Blk=halfandfullforms}', "");
    Expect(1, 65520, '\p{^Blk=halfandfullforms}', "");
    Expect(1, 65520, '\P{Blk=halfandfullforms}', "");
    Expect(0, 65520, '\P{^Blk=halfandfullforms}', "");
    Expect(1, 65519, '\p{Blk=:\Ahalfandfullforms\z:}', "");;
    Expect(0, 65520, '\p{Blk=:\Ahalfandfullforms\z:}', "");;
    Expect(1, 65519, '\p{Blk=	-Half_And_Full_FORMS}', "");
    Expect(0, 65519, '\p{^Blk=	-Half_And_Full_FORMS}', "");
    Expect(0, 65519, '\P{Blk=	-Half_And_Full_FORMS}', "");
    Expect(1, 65519, '\P{^Blk=	-Half_And_Full_FORMS}', "");
    Expect(0, 65520, '\p{Blk=	-Half_And_Full_FORMS}', "");
    Expect(1, 65520, '\p{^Blk=	-Half_And_Full_FORMS}', "");
    Expect(1, 65520, '\P{Blk=	-Half_And_Full_FORMS}', "");
    Expect(0, 65520, '\P{^Blk=	-Half_And_Full_FORMS}', "");
    Error('\p{Is_Block=  Halfwidth_AND_fullwidth_Forms:=}');
    Error('\P{Is_Block=  Halfwidth_AND_fullwidth_Forms:=}');
    Expect(1, 65519, '\p{Is_Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65519, '\p{^Is_Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65519, '\P{Is_Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65519, '\P{^Is_Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65520, '\p{Is_Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65520, '\p{^Is_Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65520, '\P{Is_Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65520, '\P{^Is_Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65519, '\p{Is_Block=  Halfwidth_And_FULLWIDTH_FORMS}', "");
    Expect(0, 65519, '\p{^Is_Block=  Halfwidth_And_FULLWIDTH_FORMS}', "");
    Expect(0, 65519, '\P{Is_Block=  Halfwidth_And_FULLWIDTH_FORMS}', "");
    Expect(1, 65519, '\P{^Is_Block=  Halfwidth_And_FULLWIDTH_FORMS}', "");
    Expect(0, 65520, '\p{Is_Block=  Halfwidth_And_FULLWIDTH_FORMS}', "");
    Expect(1, 65520, '\p{^Is_Block=  Halfwidth_And_FULLWIDTH_FORMS}', "");
    Expect(1, 65520, '\P{Is_Block=  Halfwidth_And_FULLWIDTH_FORMS}', "");
    Expect(0, 65520, '\P{^Is_Block=  Halfwidth_And_FULLWIDTH_FORMS}', "");
    Error('\p{Is_Blk=	-Half_And_full_Forms:=}');
    Error('\P{Is_Blk=	-Half_And_full_Forms:=}');
    Expect(1, 65519, '\p{Is_Blk=halfandfullforms}', "");
    Expect(0, 65519, '\p{^Is_Blk=halfandfullforms}', "");
    Expect(0, 65519, '\P{Is_Blk=halfandfullforms}', "");
    Expect(1, 65519, '\P{^Is_Blk=halfandfullforms}', "");
    Expect(0, 65520, '\p{Is_Blk=halfandfullforms}', "");
    Expect(1, 65520, '\p{^Is_Blk=halfandfullforms}', "");
    Expect(1, 65520, '\P{Is_Blk=halfandfullforms}', "");
    Expect(0, 65520, '\P{^Is_Blk=halfandfullforms}', "");
    Expect(1, 65519, '\p{Is_Blk:   	Half_and_Full_forms}', "");
    Expect(0, 65519, '\p{^Is_Blk:   	Half_and_Full_forms}', "");
    Expect(0, 65519, '\P{Is_Blk:   	Half_and_Full_forms}', "");
    Expect(1, 65519, '\P{^Is_Blk:   	Half_and_Full_forms}', "");
    Expect(0, 65520, '\p{Is_Blk:   	Half_and_Full_forms}', "");
    Expect(1, 65520, '\p{^Is_Blk:   	Half_and_Full_forms}', "");
    Expect(1, 65520, '\P{Is_Blk:   	Half_and_Full_forms}', "");
    Expect(0, 65520, '\P{^Is_Blk:   	Half_and_Full_forms}', "");
    Error('\p{Block=:=-	Combining_Half_MARKS}');
    Error('\P{Block=:=-	Combining_Half_MARKS}');
    Expect(1, 65071, '\p{Block=:\ACombining_Half_Marks\z:}', "");;
    Expect(0, 65072, '\p{Block=:\ACombining_Half_Marks\z:}', "");;
    Expect(1, 65071, '\p{Block:   combininghalfmarks}', "");
    Expect(0, 65071, '\p{^Block:   combininghalfmarks}', "");
    Expect(0, 65071, '\P{Block:   combininghalfmarks}', "");
    Expect(1, 65071, '\P{^Block:   combininghalfmarks}', "");
    Expect(0, 65072, '\p{Block:   combininghalfmarks}', "");
    Expect(1, 65072, '\p{^Block:   combininghalfmarks}', "");
    Expect(1, 65072, '\P{Block:   combininghalfmarks}', "");
    Expect(0, 65072, '\P{^Block:   combininghalfmarks}', "");
    Expect(1, 65071, '\p{Block=:\Acombininghalfmarks\z:}', "");;
    Expect(0, 65072, '\p{Block=:\Acombininghalfmarks\z:}', "");;
    Expect(1, 65071, '\p{Block=--Combining_Half_Marks}', "");
    Expect(0, 65071, '\p{^Block=--Combining_Half_Marks}', "");
    Expect(0, 65071, '\P{Block=--Combining_Half_Marks}', "");
    Expect(1, 65071, '\P{^Block=--Combining_Half_Marks}', "");
    Expect(0, 65072, '\p{Block=--Combining_Half_Marks}', "");
    Expect(1, 65072, '\p{^Block=--Combining_Half_Marks}', "");
    Expect(1, 65072, '\P{Block=--Combining_Half_Marks}', "");
    Expect(0, 65072, '\P{^Block=--Combining_Half_Marks}', "");
    Error('\p{Blk=:= Half_Marks}');
    Error('\P{Blk=:= Half_Marks}');
    Expect(1, 65071, '\p{Blk=:\AHalf_Marks\z:}', "");;
    Expect(0, 65072, '\p{Blk=:\AHalf_Marks\z:}', "");;
    Expect(1, 65071, '\p{Blk=halfmarks}', "");
    Expect(0, 65071, '\p{^Blk=halfmarks}', "");
    Expect(0, 65071, '\P{Blk=halfmarks}', "");
    Expect(1, 65071, '\P{^Blk=halfmarks}', "");
    Expect(0, 65072, '\p{Blk=halfmarks}', "");
    Expect(1, 65072, '\p{^Blk=halfmarks}', "");
    Expect(1, 65072, '\P{Blk=halfmarks}', "");
    Expect(0, 65072, '\P{^Blk=halfmarks}', "");
    Expect(1, 65071, '\p{Blk=:\Ahalfmarks\z:}', "");;
    Expect(0, 65072, '\p{Blk=:\Ahalfmarks\z:}', "");;
    Expect(1, 65071, '\p{Blk= 	HALF_Marks}', "");
    Expect(0, 65071, '\p{^Blk= 	HALF_Marks}', "");
    Expect(0, 65071, '\P{Blk= 	HALF_Marks}', "");
    Expect(1, 65071, '\P{^Blk= 	HALF_Marks}', "");
    Expect(0, 65072, '\p{Blk= 	HALF_Marks}', "");
    Expect(1, 65072, '\p{^Blk= 	HALF_Marks}', "");
    Expect(1, 65072, '\P{Blk= 	HALF_Marks}', "");
    Expect(0, 65072, '\P{^Blk= 	HALF_Marks}', "");
    Error('\p{Is_Block=/a/-_Combining_half_Marks}');
    Error('\P{Is_Block=/a/-_Combining_half_Marks}');
    Expect(1, 65071, '\p{Is_Block=combininghalfmarks}', "");
    Expect(0, 65071, '\p{^Is_Block=combininghalfmarks}', "");
    Expect(0, 65071, '\P{Is_Block=combininghalfmarks}', "");
    Expect(1, 65071, '\P{^Is_Block=combininghalfmarks}', "");
    Expect(0, 65072, '\p{Is_Block=combininghalfmarks}', "");
    Expect(1, 65072, '\p{^Is_Block=combininghalfmarks}', "");
    Expect(1, 65072, '\P{Is_Block=combininghalfmarks}', "");
    Expect(0, 65072, '\P{^Is_Block=combininghalfmarks}', "");
    Expect(1, 65071, '\p{Is_Block=	 COMBINING_Half_marks}', "");
    Expect(0, 65071, '\p{^Is_Block=	 COMBINING_Half_marks}', "");
    Expect(0, 65071, '\P{Is_Block=	 COMBINING_Half_marks}', "");
    Expect(1, 65071, '\P{^Is_Block=	 COMBINING_Half_marks}', "");
    Expect(0, 65072, '\p{Is_Block=	 COMBINING_Half_marks}', "");
    Expect(1, 65072, '\p{^Is_Block=	 COMBINING_Half_marks}', "");
    Expect(1, 65072, '\P{Is_Block=	 COMBINING_Half_marks}', "");
    Expect(0, 65072, '\P{^Is_Block=	 COMBINING_Half_marks}', "");
    Error('\p{Is_Blk=	-half_Marks/a/}');
    Error('\P{Is_Blk=	-half_Marks/a/}');
    Expect(1, 65071, '\p{Is_Blk:halfmarks}', "");
    Expect(0, 65071, '\p{^Is_Blk:halfmarks}', "");
    Expect(0, 65071, '\P{Is_Blk:halfmarks}', "");
    Expect(1, 65071, '\P{^Is_Blk:halfmarks}', "");
    Expect(0, 65072, '\p{Is_Blk:halfmarks}', "");
    Expect(1, 65072, '\p{^Is_Blk:halfmarks}', "");
    Expect(1, 65072, '\P{Is_Blk:halfmarks}', "");
    Expect(0, 65072, '\P{^Is_Blk:halfmarks}', "");
    Expect(1, 65071, '\p{Is_Blk: 	-Half_marks}', "");
    Expect(0, 65071, '\p{^Is_Blk: 	-Half_marks}', "");
    Expect(0, 65071, '\P{Is_Blk: 	-Half_marks}', "");
    Expect(1, 65071, '\P{^Is_Blk: 	-Half_marks}', "");
    Expect(0, 65072, '\p{Is_Blk: 	-Half_marks}', "");
    Expect(1, 65072, '\p{^Is_Blk: 	-Half_marks}', "");
    Expect(1, 65072, '\P{Is_Blk: 	-Half_marks}', "");
    Expect(0, 65072, '\P{^Is_Blk: 	-Half_marks}', "");
    Error('\p{Block=	/a/hangul_syllables}');
    Error('\P{Block=	/a/hangul_syllables}');
    Expect(1, 55215, '\p{Block=:\AHangul_Syllables\z:}', "");;
    Expect(0, 55216, '\p{Block=:\AHangul_Syllables\z:}', "");;
    Expect(1, 55215, '\p{Block=hangulsyllables}', "");
    Expect(0, 55215, '\p{^Block=hangulsyllables}', "");
    Expect(0, 55215, '\P{Block=hangulsyllables}', "");
    Expect(1, 55215, '\P{^Block=hangulsyllables}', "");
    Expect(0, 55216, '\p{Block=hangulsyllables}', "");
    Expect(1, 55216, '\p{^Block=hangulsyllables}', "");
    Expect(1, 55216, '\P{Block=hangulsyllables}', "");
    Expect(0, 55216, '\P{^Block=hangulsyllables}', "");
    Expect(1, 55215, '\p{Block=:\Ahangulsyllables\z:}', "");;
    Expect(0, 55216, '\p{Block=:\Ahangulsyllables\z:}', "");;
    Expect(1, 55215, '\p{Block=-Hangul_Syllables}', "");
    Expect(0, 55215, '\p{^Block=-Hangul_Syllables}', "");
    Expect(0, 55215, '\P{Block=-Hangul_Syllables}', "");
    Expect(1, 55215, '\P{^Block=-Hangul_Syllables}', "");
    Expect(0, 55216, '\p{Block=-Hangul_Syllables}', "");
    Expect(1, 55216, '\p{^Block=-Hangul_Syllables}', "");
    Expect(1, 55216, '\P{Block=-Hangul_Syllables}', "");
    Expect(0, 55216, '\P{^Block=-Hangul_Syllables}', "");
    Error('\p{Blk=	 HANGUL:=}');
    Error('\P{Blk=	 HANGUL:=}');
    Expect(1, 55215, '\p{Blk=:\AHangul\z:}', "");;
    Expect(0, 55216, '\p{Blk=:\AHangul\z:}', "");;
    Expect(1, 55215, '\p{Blk=hangul}', "");
    Expect(0, 55215, '\p{^Blk=hangul}', "");
    Expect(0, 55215, '\P{Blk=hangul}', "");
    Expect(1, 55215, '\P{^Blk=hangul}', "");
    Expect(0, 55216, '\p{Blk=hangul}', "");
    Expect(1, 55216, '\p{^Blk=hangul}', "");
    Expect(1, 55216, '\P{Blk=hangul}', "");
    Expect(0, 55216, '\P{^Blk=hangul}', "");
    Expect(1, 55215, '\p{Blk=:\Ahangul\z:}', "");;
    Expect(0, 55216, '\p{Blk=:\Ahangul\z:}', "");;
    Expect(1, 55215, '\p{Blk=- Hangul}', "");
    Expect(0, 55215, '\p{^Blk=- Hangul}', "");
    Expect(0, 55215, '\P{Blk=- Hangul}', "");
    Expect(1, 55215, '\P{^Blk=- Hangul}', "");
    Expect(0, 55216, '\p{Blk=- Hangul}', "");
    Expect(1, 55216, '\p{^Blk=- Hangul}', "");
    Expect(1, 55216, '\P{Blk=- Hangul}', "");
    Expect(0, 55216, '\P{^Blk=- Hangul}', "");
    Error('\p{Is_Block=:=Hangul_Syllables}');
    Error('\P{Is_Block=:=Hangul_Syllables}');
    Expect(1, 55215, '\p{Is_Block=hangulsyllables}', "");
    Expect(0, 55215, '\p{^Is_Block=hangulsyllables}', "");
    Expect(0, 55215, '\P{Is_Block=hangulsyllables}', "");
    Expect(1, 55215, '\P{^Is_Block=hangulsyllables}', "");
    Expect(0, 55216, '\p{Is_Block=hangulsyllables}', "");
    Expect(1, 55216, '\p{^Is_Block=hangulsyllables}', "");
    Expect(1, 55216, '\P{Is_Block=hangulsyllables}', "");
    Expect(0, 55216, '\P{^Is_Block=hangulsyllables}', "");
    Expect(1, 55215, '\p{Is_Block=_ HANGUL_Syllables}', "");
    Expect(0, 55215, '\p{^Is_Block=_ HANGUL_Syllables}', "");
    Expect(0, 55215, '\P{Is_Block=_ HANGUL_Syllables}', "");
    Expect(1, 55215, '\P{^Is_Block=_ HANGUL_Syllables}', "");
    Expect(0, 55216, '\p{Is_Block=_ HANGUL_Syllables}', "");
    Expect(1, 55216, '\p{^Is_Block=_ HANGUL_Syllables}', "");
    Expect(1, 55216, '\P{Is_Block=_ HANGUL_Syllables}', "");
    Expect(0, 55216, '\P{^Is_Block=_ HANGUL_Syllables}', "");
    Error('\p{Is_Blk= :=HANGUL}');
    Error('\P{Is_Blk= :=HANGUL}');
    Expect(1, 55215, '\p{Is_Blk=hangul}', "");
    Expect(0, 55215, '\p{^Is_Blk=hangul}', "");
    Expect(0, 55215, '\P{Is_Blk=hangul}', "");
    Expect(1, 55215, '\P{^Is_Blk=hangul}', "");
    Expect(0, 55216, '\p{Is_Blk=hangul}', "");
    Expect(1, 55216, '\p{^Is_Blk=hangul}', "");
    Expect(1, 55216, '\P{Is_Blk=hangul}', "");
    Expect(0, 55216, '\P{^Is_Blk=hangul}', "");
    Expect(1, 55215, '\p{Is_Blk=_HANGUL}', "");
    Expect(0, 55215, '\p{^Is_Blk=_HANGUL}', "");
    Expect(0, 55215, '\P{Is_Blk=_HANGUL}', "");
    Expect(1, 55215, '\P{^Is_Blk=_HANGUL}', "");
    Expect(0, 55216, '\p{Is_Blk=_HANGUL}', "");
    Expect(1, 55216, '\p{^Is_Blk=_HANGUL}', "");
    Expect(1, 55216, '\P{Is_Blk=_HANGUL}', "");
    Expect(0, 55216, '\P{^Is_Blk=_HANGUL}', "");
    Error('\p{Block=/a/Hanifi_ROHINGYA}');
    Error('\P{Block=/a/Hanifi_ROHINGYA}');
    Expect(1, 68927, '\p{Block=:\AHanifi_Rohingya\z:}', "");;
    Expect(0, 68928, '\p{Block=:\AHanifi_Rohingya\z:}', "");;
    Expect(1, 68927, '\p{Block=hanifirohingya}', "");
    Expect(0, 68927, '\p{^Block=hanifirohingya}', "");
    Expect(0, 68927, '\P{Block=hanifirohingya}', "");
    Expect(1, 68927, '\P{^Block=hanifirohingya}', "");
    Expect(0, 68928, '\p{Block=hanifirohingya}', "");
    Expect(1, 68928, '\p{^Block=hanifirohingya}', "");
    Expect(1, 68928, '\P{Block=hanifirohingya}', "");
    Expect(0, 68928, '\P{^Block=hanifirohingya}', "");
    Expect(1, 68927, '\p{Block=:\Ahanifirohingya\z:}', "");;
    Expect(0, 68928, '\p{Block=:\Ahanifirohingya\z:}', "");;
    Expect(1, 68927, '\p{Block=hanifi_Rohingya}', "");
    Expect(0, 68927, '\p{^Block=hanifi_Rohingya}', "");
    Expect(0, 68927, '\P{Block=hanifi_Rohingya}', "");
    Expect(1, 68927, '\P{^Block=hanifi_Rohingya}', "");
    Expect(0, 68928, '\p{Block=hanifi_Rohingya}', "");
    Expect(1, 68928, '\p{^Block=hanifi_Rohingya}', "");
    Expect(1, 68928, '\P{Block=hanifi_Rohingya}', "");
    Expect(0, 68928, '\P{^Block=hanifi_Rohingya}', "");
    Error('\p{Blk=/a/__Hanifi_rohingya}');
    Error('\P{Blk=/a/__Hanifi_rohingya}');
    Expect(1, 68927, '\p{Blk=:\AHanifi_Rohingya\z:}', "");;
    Expect(0, 68928, '\p{Blk=:\AHanifi_Rohingya\z:}', "");;
    Expect(1, 68927, '\p{Blk=hanifirohingya}', "");
    Expect(0, 68927, '\p{^Blk=hanifirohingya}', "");
    Expect(0, 68927, '\P{Blk=hanifirohingya}', "");
    Expect(1, 68927, '\P{^Blk=hanifirohingya}', "");
    Expect(0, 68928, '\p{Blk=hanifirohingya}', "");
    Expect(1, 68928, '\p{^Blk=hanifirohingya}', "");
    Expect(1, 68928, '\P{Blk=hanifirohingya}', "");
    Expect(0, 68928, '\P{^Blk=hanifirohingya}', "");
    Expect(1, 68927, '\p{Blk=:\Ahanifirohingya\z:}', "");;
    Expect(0, 68928, '\p{Blk=:\Ahanifirohingya\z:}', "");;
    Expect(1, 68927, '\p{Blk=_Hanifi_ROHINGYA}', "");
    Expect(0, 68927, '\p{^Blk=_Hanifi_ROHINGYA}', "");
    Expect(0, 68927, '\P{Blk=_Hanifi_ROHINGYA}', "");
    Expect(1, 68927, '\P{^Blk=_Hanifi_ROHINGYA}', "");
    Expect(0, 68928, '\p{Blk=_Hanifi_ROHINGYA}', "");
    Expect(1, 68928, '\p{^Blk=_Hanifi_ROHINGYA}', "");
    Expect(1, 68928, '\P{Blk=_Hanifi_ROHINGYA}', "");
    Expect(0, 68928, '\P{^Blk=_Hanifi_ROHINGYA}', "");
    Error('\p{Is_Block= :=HANIFI_ROHINGYA}');
    Error('\P{Is_Block= :=HANIFI_ROHINGYA}');
    Expect(1, 68927, '\p{Is_Block=hanifirohingya}', "");
    Expect(0, 68927, '\p{^Is_Block=hanifirohingya}', "");
    Expect(0, 68927, '\P{Is_Block=hanifirohingya}', "");
    Expect(1, 68927, '\P{^Is_Block=hanifirohingya}', "");
    Expect(0, 68928, '\p{Is_Block=hanifirohingya}', "");
    Expect(1, 68928, '\p{^Is_Block=hanifirohingya}', "");
    Expect(1, 68928, '\P{Is_Block=hanifirohingya}', "");
    Expect(0, 68928, '\P{^Is_Block=hanifirohingya}', "");
    Expect(1, 68927, '\p{Is_Block= -Hanifi_Rohingya}', "");
    Expect(0, 68927, '\p{^Is_Block= -Hanifi_Rohingya}', "");
    Expect(0, 68927, '\P{Is_Block= -Hanifi_Rohingya}', "");
    Expect(1, 68927, '\P{^Is_Block= -Hanifi_Rohingya}', "");
    Expect(0, 68928, '\p{Is_Block= -Hanifi_Rohingya}', "");
    Expect(1, 68928, '\p{^Is_Block= -Hanifi_Rohingya}', "");
    Expect(1, 68928, '\P{Is_Block= -Hanifi_Rohingya}', "");
    Expect(0, 68928, '\P{^Is_Block= -Hanifi_Rohingya}', "");
    Error('\p{Is_Blk=	:=Hanifi_Rohingya}');
    Error('\P{Is_Blk=	:=Hanifi_Rohingya}');
    Expect(1, 68927, '\p{Is_Blk=hanifirohingya}', "");
    Expect(0, 68927, '\p{^Is_Blk=hanifirohingya}', "");
    Expect(0, 68927, '\P{Is_Blk=hanifirohingya}', "");
    Expect(1, 68927, '\P{^Is_Blk=hanifirohingya}', "");
    Expect(0, 68928, '\p{Is_Blk=hanifirohingya}', "");
    Expect(1, 68928, '\p{^Is_Blk=hanifirohingya}', "");
    Expect(1, 68928, '\P{Is_Blk=hanifirohingya}', "");
    Expect(0, 68928, '\P{^Is_Blk=hanifirohingya}', "");
    Expect(1, 68927, '\p{Is_Blk=		Hanifi_Rohingya}', "");
    Expect(0, 68927, '\p{^Is_Blk=		Hanifi_Rohingya}', "");
    Expect(0, 68927, '\P{Is_Blk=		Hanifi_Rohingya}', "");
    Expect(1, 68927, '\P{^Is_Blk=		Hanifi_Rohingya}', "");
    Expect(0, 68928, '\p{Is_Blk=		Hanifi_Rohingya}', "");
    Expect(1, 68928, '\p{^Is_Blk=		Hanifi_Rohingya}', "");
    Expect(1, 68928, '\P{Is_Blk=		Hanifi_Rohingya}', "");
    Expect(0, 68928, '\P{^Is_Blk=		Hanifi_Rohingya}', "");
    Error('\p{Block=_ HANUNOO:=}');
    Error('\P{Block=_ HANUNOO:=}');
    Expect(1, 5951, '\p{Block=:\AHanunoo\z:}', "");;
    Expect(0, 5952, '\p{Block=:\AHanunoo\z:}', "");;
    Expect(1, 5951, '\p{Block=hanunoo}', "");
    Expect(0, 5951, '\p{^Block=hanunoo}', "");
    Expect(0, 5951, '\P{Block=hanunoo}', "");
    Expect(1, 5951, '\P{^Block=hanunoo}', "");
    Expect(0, 5952, '\p{Block=hanunoo}', "");
    Expect(1, 5952, '\p{^Block=hanunoo}', "");
    Expect(1, 5952, '\P{Block=hanunoo}', "");
    Expect(0, 5952, '\P{^Block=hanunoo}', "");
    Expect(1, 5951, '\p{Block=:\Ahanunoo\z:}', "");;
    Expect(0, 5952, '\p{Block=:\Ahanunoo\z:}', "");;
    Expect(1, 5951, '\p{Block=_Hanunoo}', "");
    Expect(0, 5951, '\p{^Block=_Hanunoo}', "");
    Expect(0, 5951, '\P{Block=_Hanunoo}', "");
    Expect(1, 5951, '\P{^Block=_Hanunoo}', "");
    Expect(0, 5952, '\p{Block=_Hanunoo}', "");
    Expect(1, 5952, '\p{^Block=_Hanunoo}', "");
    Expect(1, 5952, '\P{Block=_Hanunoo}', "");
    Expect(0, 5952, '\P{^Block=_Hanunoo}', "");
    Error('\p{Blk=_ Hanunoo/a/}');
    Error('\P{Blk=_ Hanunoo/a/}');
    Expect(1, 5951, '\p{Blk=:\AHanunoo\z:}', "");;
    Expect(0, 5952, '\p{Blk=:\AHanunoo\z:}', "");;
    Expect(1, 5951, '\p{Blk=hanunoo}', "");
    Expect(0, 5951, '\p{^Blk=hanunoo}', "");
    Expect(0, 5951, '\P{Blk=hanunoo}', "");
    Expect(1, 5951, '\P{^Blk=hanunoo}', "");
    Expect(0, 5952, '\p{Blk=hanunoo}', "");
    Expect(1, 5952, '\p{^Blk=hanunoo}', "");
    Expect(1, 5952, '\P{Blk=hanunoo}', "");
    Expect(0, 5952, '\P{^Blk=hanunoo}', "");
    Expect(1, 5951, '\p{Blk=:\Ahanunoo\z:}', "");;
    Expect(0, 5952, '\p{Blk=:\Ahanunoo\z:}', "");;
    Expect(1, 5951, '\p{Blk=-_Hanunoo}', "");
    Expect(0, 5951, '\p{^Blk=-_Hanunoo}', "");
    Expect(0, 5951, '\P{Blk=-_Hanunoo}', "");
    Expect(1, 5951, '\P{^Blk=-_Hanunoo}', "");
    Expect(0, 5952, '\p{Blk=-_Hanunoo}', "");
    Expect(1, 5952, '\p{^Blk=-_Hanunoo}', "");
    Expect(1, 5952, '\P{Blk=-_Hanunoo}', "");
    Expect(0, 5952, '\P{^Blk=-_Hanunoo}', "");
    Error('\p{Is_Block=-	Hanunoo:=}');
    Error('\P{Is_Block=-	Hanunoo:=}');
    Expect(1, 5951, '\p{Is_Block=hanunoo}', "");
    Expect(0, 5951, '\p{^Is_Block=hanunoo}', "");
    Expect(0, 5951, '\P{Is_Block=hanunoo}', "");
    Expect(1, 5951, '\P{^Is_Block=hanunoo}', "");
    Expect(0, 5952, '\p{Is_Block=hanunoo}', "");
    Expect(1, 5952, '\p{^Is_Block=hanunoo}', "");
    Expect(1, 5952, '\P{Is_Block=hanunoo}', "");
    Expect(0, 5952, '\P{^Is_Block=hanunoo}', "");
    Expect(1, 5951, '\p{Is_Block=  HANUNOO}', "");
    Expect(0, 5951, '\p{^Is_Block=  HANUNOO}', "");
    Expect(0, 5951, '\P{Is_Block=  HANUNOO}', "");
    Expect(1, 5951, '\P{^Is_Block=  HANUNOO}', "");
    Expect(0, 5952, '\p{Is_Block=  HANUNOO}', "");
    Expect(1, 5952, '\p{^Is_Block=  HANUNOO}', "");
    Expect(1, 5952, '\P{Is_Block=  HANUNOO}', "");
    Expect(0, 5952, '\P{^Is_Block=  HANUNOO}', "");
    Error('\p{Is_Blk=_ HANUNOO:=}');
    Error('\P{Is_Blk=_ HANUNOO:=}');
    Expect(1, 5951, '\p{Is_Blk=hanunoo}', "");
    Expect(0, 5951, '\p{^Is_Blk=hanunoo}', "");
    Expect(0, 5951, '\P{Is_Blk=hanunoo}', "");
    Expect(1, 5951, '\P{^Is_Blk=hanunoo}', "");
    Expect(0, 5952, '\p{Is_Blk=hanunoo}', "");
    Expect(1, 5952, '\p{^Is_Blk=hanunoo}', "");
    Expect(1, 5952, '\P{Is_Blk=hanunoo}', "");
    Expect(0, 5952, '\P{^Is_Blk=hanunoo}', "");
    Expect(1, 5951, '\p{Is_Blk=_	HANUNOO}', "");
    Expect(0, 5951, '\p{^Is_Blk=_	HANUNOO}', "");
    Expect(0, 5951, '\P{Is_Blk=_	HANUNOO}', "");
    Expect(1, 5951, '\P{^Is_Blk=_	HANUNOO}', "");
    Expect(0, 5952, '\p{Is_Blk=_	HANUNOO}', "");
    Expect(1, 5952, '\p{^Is_Blk=_	HANUNOO}', "");
    Expect(1, 5952, '\P{Is_Blk=_	HANUNOO}', "");
    Expect(0, 5952, '\P{^Is_Blk=_	HANUNOO}', "");
    Error('\p{Block:   	:=Hatran}');
    Error('\P{Block:   	:=Hatran}');
    Expect(1, 67839, '\p{Block=:\AHatran\z:}', "");;
    Expect(0, 67840, '\p{Block=:\AHatran\z:}', "");;
    Expect(1, 67839, '\p{Block=hatran}', "");
    Expect(0, 67839, '\p{^Block=hatran}', "");
    Expect(0, 67839, '\P{Block=hatran}', "");
    Expect(1, 67839, '\P{^Block=hatran}', "");
    Expect(0, 67840, '\p{Block=hatran}', "");
    Expect(1, 67840, '\p{^Block=hatran}', "");
    Expect(1, 67840, '\P{Block=hatran}', "");
    Expect(0, 67840, '\P{^Block=hatran}', "");
    Expect(1, 67839, '\p{Block=:\Ahatran\z:}', "");;
    Expect(0, 67840, '\p{Block=:\Ahatran\z:}', "");;
    Expect(1, 67839, '\p{Block= Hatran}', "");
    Expect(0, 67839, '\p{^Block= Hatran}', "");
    Expect(0, 67839, '\P{Block= Hatran}', "");
    Expect(1, 67839, '\P{^Block= Hatran}', "");
    Expect(0, 67840, '\p{Block= Hatran}', "");
    Expect(1, 67840, '\p{^Block= Hatran}', "");
    Expect(1, 67840, '\P{Block= Hatran}', "");
    Expect(0, 67840, '\P{^Block= Hatran}', "");
    Error('\p{Blk=/a/Hatran}');
    Error('\P{Blk=/a/Hatran}');
    Expect(1, 67839, '\p{Blk=:\AHatran\z:}', "");;
    Expect(0, 67840, '\p{Blk=:\AHatran\z:}', "");;
    Expect(1, 67839, '\p{Blk=hatran}', "");
    Expect(0, 67839, '\p{^Blk=hatran}', "");
    Expect(0, 67839, '\P{Blk=hatran}', "");
    Expect(1, 67839, '\P{^Blk=hatran}', "");
    Expect(0, 67840, '\p{Blk=hatran}', "");
    Expect(1, 67840, '\p{^Blk=hatran}', "");
    Expect(1, 67840, '\P{Blk=hatran}', "");
    Expect(0, 67840, '\P{^Blk=hatran}', "");
    Expect(1, 67839, '\p{Blk=:\Ahatran\z:}', "");;
    Expect(0, 67840, '\p{Blk=:\Ahatran\z:}', "");;
    Expect(1, 67839, '\p{Blk=_ Hatran}', "");
    Expect(0, 67839, '\p{^Blk=_ Hatran}', "");
    Expect(0, 67839, '\P{Blk=_ Hatran}', "");
    Expect(1, 67839, '\P{^Blk=_ Hatran}', "");
    Expect(0, 67840, '\p{Blk=_ Hatran}', "");
    Expect(1, 67840, '\p{^Blk=_ Hatran}', "");
    Expect(1, 67840, '\P{Blk=_ Hatran}', "");
    Expect(0, 67840, '\P{^Blk=_ Hatran}', "");
    Error('\p{Is_Block=		hatran:=}');
    Error('\P{Is_Block=		hatran:=}');
    Expect(1, 67839, '\p{Is_Block=hatran}', "");
    Expect(0, 67839, '\p{^Is_Block=hatran}', "");
    Expect(0, 67839, '\P{Is_Block=hatran}', "");
    Expect(1, 67839, '\P{^Is_Block=hatran}', "");
    Expect(0, 67840, '\p{Is_Block=hatran}', "");
    Expect(1, 67840, '\p{^Is_Block=hatran}', "");
    Expect(1, 67840, '\P{Is_Block=hatran}', "");
    Expect(0, 67840, '\P{^Is_Block=hatran}', "");
    Expect(1, 67839, '\p{Is_Block= HATRAN}', "");
    Expect(0, 67839, '\p{^Is_Block= HATRAN}', "");
    Expect(0, 67839, '\P{Is_Block= HATRAN}', "");
    Expect(1, 67839, '\P{^Is_Block= HATRAN}', "");
    Expect(0, 67840, '\p{Is_Block= HATRAN}', "");
    Expect(1, 67840, '\p{^Is_Block= HATRAN}', "");
    Expect(1, 67840, '\P{Is_Block= HATRAN}', "");
    Expect(0, 67840, '\P{^Is_Block= HATRAN}', "");
    Error('\p{Is_Blk=-:=Hatran}');
    Error('\P{Is_Blk=-:=Hatran}');
    Expect(1, 67839, '\p{Is_Blk=hatran}', "");
    Expect(0, 67839, '\p{^Is_Blk=hatran}', "");
    Expect(0, 67839, '\P{Is_Blk=hatran}', "");
    Expect(1, 67839, '\P{^Is_Blk=hatran}', "");
    Expect(0, 67840, '\p{Is_Blk=hatran}', "");
    Expect(1, 67840, '\p{^Is_Blk=hatran}', "");
    Expect(1, 67840, '\P{Is_Blk=hatran}', "");
    Expect(0, 67840, '\P{^Is_Blk=hatran}', "");
    Expect(1, 67839, '\p{Is_Blk=_-HATRAN}', "");
    Expect(0, 67839, '\p{^Is_Blk=_-HATRAN}', "");
    Expect(0, 67839, '\P{Is_Blk=_-HATRAN}', "");
    Expect(1, 67839, '\P{^Is_Blk=_-HATRAN}', "");
    Expect(0, 67840, '\p{Is_Blk=_-HATRAN}', "");
    Expect(1, 67840, '\p{^Is_Blk=_-HATRAN}', "");
    Expect(1, 67840, '\P{Is_Blk=_-HATRAN}', "");
    Expect(0, 67840, '\P{^Is_Blk=_-HATRAN}', "");
    Error('\p{Block=/a/	_HEBREW}');
    Error('\P{Block=/a/	_HEBREW}');
    Expect(1, 1535, '\p{Block=:\AHebrew\z:}', "");;
    Expect(0, 1536, '\p{Block=:\AHebrew\z:}', "");;
    Expect(1, 1535, '\p{Block:hebrew}', "");
    Expect(0, 1535, '\p{^Block:hebrew}', "");
    Expect(0, 1535, '\P{Block:hebrew}', "");
    Expect(1, 1535, '\P{^Block:hebrew}', "");
    Expect(0, 1536, '\p{Block:hebrew}', "");
    Expect(1, 1536, '\p{^Block:hebrew}', "");
    Expect(1, 1536, '\P{Block:hebrew}', "");
    Expect(0, 1536, '\P{^Block:hebrew}', "");
    Expect(1, 1535, '\p{Block=:\Ahebrew\z:}', "");;
    Expect(0, 1536, '\p{Block=:\Ahebrew\z:}', "");;
    Expect(1, 1535, '\p{Block= 	Hebrew}', "");
    Expect(0, 1535, '\p{^Block= 	Hebrew}', "");
    Expect(0, 1535, '\P{Block= 	Hebrew}', "");
    Expect(1, 1535, '\P{^Block= 	Hebrew}', "");
    Expect(0, 1536, '\p{Block= 	Hebrew}', "");
    Expect(1, 1536, '\p{^Block= 	Hebrew}', "");
    Expect(1, 1536, '\P{Block= 	Hebrew}', "");
    Expect(0, 1536, '\P{^Block= 	Hebrew}', "");
    Error('\p{Blk=  hebrew:=}');
    Error('\P{Blk=  hebrew:=}');
    Expect(1, 1535, '\p{Blk=:\AHebrew\z:}', "");;
    Expect(0, 1536, '\p{Blk=:\AHebrew\z:}', "");;
    Expect(1, 1535, '\p{Blk=hebrew}', "");
    Expect(0, 1535, '\p{^Blk=hebrew}', "");
    Expect(0, 1535, '\P{Blk=hebrew}', "");
    Expect(1, 1535, '\P{^Blk=hebrew}', "");
    Expect(0, 1536, '\p{Blk=hebrew}', "");
    Expect(1, 1536, '\p{^Blk=hebrew}', "");
    Expect(1, 1536, '\P{Blk=hebrew}', "");
    Expect(0, 1536, '\P{^Blk=hebrew}', "");
    Expect(1, 1535, '\p{Blk=:\Ahebrew\z:}', "");;
    Expect(0, 1536, '\p{Blk=:\Ahebrew\z:}', "");;
    Expect(1, 1535, '\p{Blk=	hebrew}', "");
    Expect(0, 1535, '\p{^Blk=	hebrew}', "");
    Expect(0, 1535, '\P{Blk=	hebrew}', "");
    Expect(1, 1535, '\P{^Blk=	hebrew}', "");
    Expect(0, 1536, '\p{Blk=	hebrew}', "");
    Expect(1, 1536, '\p{^Blk=	hebrew}', "");
    Expect(1, 1536, '\P{Blk=	hebrew}', "");
    Expect(0, 1536, '\P{^Blk=	hebrew}', "");
    Error('\p{Is_Block=__hebrew:=}');
    Error('\P{Is_Block=__hebrew:=}');
    Expect(1, 1535, '\p{Is_Block=hebrew}', "");
    Expect(0, 1535, '\p{^Is_Block=hebrew}', "");
    Expect(0, 1535, '\P{Is_Block=hebrew}', "");
    Expect(1, 1535, '\P{^Is_Block=hebrew}', "");
    Expect(0, 1536, '\p{Is_Block=hebrew}', "");
    Expect(1, 1536, '\p{^Is_Block=hebrew}', "");
    Expect(1, 1536, '\P{Is_Block=hebrew}', "");
    Expect(0, 1536, '\P{^Is_Block=hebrew}', "");
    Expect(1, 1535, '\p{Is_Block=	 Hebrew}', "");
    Expect(0, 1535, '\p{^Is_Block=	 Hebrew}', "");
    Expect(0, 1535, '\P{Is_Block=	 Hebrew}', "");
    Expect(1, 1535, '\P{^Is_Block=	 Hebrew}', "");
    Expect(0, 1536, '\p{Is_Block=	 Hebrew}', "");
    Expect(1, 1536, '\p{^Is_Block=	 Hebrew}', "");
    Expect(1, 1536, '\P{Is_Block=	 Hebrew}', "");
    Expect(0, 1536, '\P{^Is_Block=	 Hebrew}', "");
    Error('\p{Is_Blk=_	hebrew:=}');
    Error('\P{Is_Blk=_	hebrew:=}');
    Expect(1, 1535, '\p{Is_Blk:hebrew}', "");
    Expect(0, 1535, '\p{^Is_Blk:hebrew}', "");
    Expect(0, 1535, '\P{Is_Blk:hebrew}', "");
    Expect(1, 1535, '\P{^Is_Blk:hebrew}', "");
    Expect(0, 1536, '\p{Is_Blk:hebrew}', "");
    Expect(1, 1536, '\p{^Is_Blk:hebrew}', "");
    Expect(1, 1536, '\P{Is_Blk:hebrew}', "");
    Expect(0, 1536, '\P{^Is_Blk:hebrew}', "");
    Expect(1, 1535, '\p{Is_Blk=	_Hebrew}', "");
    Expect(0, 1535, '\p{^Is_Blk=	_Hebrew}', "");
    Expect(0, 1535, '\P{Is_Blk=	_Hebrew}', "");
    Expect(1, 1535, '\P{^Is_Blk=	_Hebrew}', "");
    Expect(0, 1536, '\p{Is_Blk=	_Hebrew}', "");
    Expect(1, 1536, '\p{^Is_Blk=	_Hebrew}', "");
    Expect(1, 1536, '\P{Is_Blk=	_Hebrew}', "");
    Expect(0, 1536, '\P{^Is_Blk=	_Hebrew}', "");
    Error('\p{Block=		High_Private_Use_Surrogates:=}');
    Error('\P{Block=		High_Private_Use_Surrogates:=}');
    Expect(1, 56319, '\p{Block=:\AHigh_Private_Use_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\AHigh_Private_Use_Surrogates\z:}', "");;
    Expect(1, 56319, '\p{Block=highprivateusesurrogates}', "");
    Expect(0, 56319, '\p{^Block=highprivateusesurrogates}', "");
    Expect(0, 56319, '\P{Block=highprivateusesurrogates}', "");
    Expect(1, 56319, '\P{^Block=highprivateusesurrogates}', "");
    Expect(0, 57344, '\p{Block=highprivateusesurrogates}', "");
    Expect(1, 57344, '\p{^Block=highprivateusesurrogates}', "");
    Expect(1, 57344, '\P{Block=highprivateusesurrogates}', "");
    Expect(0, 57344, '\P{^Block=highprivateusesurrogates}', "");
    Expect(1, 56319, '\p{Block=:\Ahighprivateusesurrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\Ahighprivateusesurrogates\z:}', "");;
    Expect(1, 56319, '\p{Block=	HIGH_Private_USE_SURROGATES}', "");
    Expect(0, 56319, '\p{^Block=	HIGH_Private_USE_SURROGATES}', "");
    Expect(0, 56319, '\P{Block=	HIGH_Private_USE_SURROGATES}', "");
    Expect(1, 56319, '\P{^Block=	HIGH_Private_USE_SURROGATES}', "");
    Expect(0, 57344, '\p{Block=	HIGH_Private_USE_SURROGATES}', "");
    Expect(1, 57344, '\p{^Block=	HIGH_Private_USE_SURROGATES}', "");
    Expect(1, 57344, '\P{Block=	HIGH_Private_USE_SURROGATES}', "");
    Expect(0, 57344, '\P{^Block=	HIGH_Private_USE_SURROGATES}', "");
    Error('\p{Blk=	/a/high_PU_SURROGATES}');
    Error('\P{Blk=	/a/high_PU_SURROGATES}');
    Expect(1, 56319, '\p{Blk=:\AHigh_PU_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\AHigh_PU_Surrogates\z:}', "");;
    Expect(1, 56319, '\p{Blk=highpusurrogates}', "");
    Expect(0, 56319, '\p{^Blk=highpusurrogates}', "");
    Expect(0, 56319, '\P{Blk=highpusurrogates}', "");
    Expect(1, 56319, '\P{^Blk=highpusurrogates}', "");
    Expect(0, 57344, '\p{Blk=highpusurrogates}', "");
    Expect(1, 57344, '\p{^Blk=highpusurrogates}', "");
    Expect(1, 57344, '\P{Blk=highpusurrogates}', "");
    Expect(0, 57344, '\P{^Blk=highpusurrogates}', "");
    Expect(1, 56319, '\p{Blk=:\Ahighpusurrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\Ahighpusurrogates\z:}', "");;
    Expect(1, 56319, '\p{Blk=- HIGH_PU_surrogates}', "");
    Expect(0, 56319, '\p{^Blk=- HIGH_PU_surrogates}', "");
    Expect(0, 56319, '\P{Blk=- HIGH_PU_surrogates}', "");
    Expect(1, 56319, '\P{^Blk=- HIGH_PU_surrogates}', "");
    Expect(0, 57344, '\p{Blk=- HIGH_PU_surrogates}', "");
    Expect(1, 57344, '\p{^Blk=- HIGH_PU_surrogates}', "");
    Expect(1, 57344, '\P{Blk=- HIGH_PU_surrogates}', "");
    Expect(0, 57344, '\P{^Blk=- HIGH_PU_surrogates}', "");
    Error('\p{Is_Block=	High_private_USE_Surrogates:=}');
    Error('\P{Is_Block=	High_private_USE_Surrogates:=}');
    Expect(1, 56319, '\p{Is_Block=highprivateusesurrogates}', "");
    Expect(0, 56319, '\p{^Is_Block=highprivateusesurrogates}', "");
    Expect(0, 56319, '\P{Is_Block=highprivateusesurrogates}', "");
    Expect(1, 56319, '\P{^Is_Block=highprivateusesurrogates}', "");
    Expect(0, 57344, '\p{Is_Block=highprivateusesurrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=highprivateusesurrogates}', "");
    Expect(1, 57344, '\P{Is_Block=highprivateusesurrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=highprivateusesurrogates}', "");
    Expect(1, 56319, '\p{Is_Block=	high_Private_USE_Surrogates}', "");
    Expect(0, 56319, '\p{^Is_Block=	high_Private_USE_Surrogates}', "");
    Expect(0, 56319, '\P{Is_Block=	high_Private_USE_Surrogates}', "");
    Expect(1, 56319, '\P{^Is_Block=	high_Private_USE_Surrogates}', "");
    Expect(0, 57344, '\p{Is_Block=	high_Private_USE_Surrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=	high_Private_USE_Surrogates}', "");
    Expect(1, 57344, '\P{Is_Block=	high_Private_USE_Surrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=	high_Private_USE_Surrogates}', "");
    Error('\p{Is_Blk=/a/- high_pu_surrogates}');
    Error('\P{Is_Blk=/a/- high_pu_surrogates}');
    Expect(1, 56319, '\p{Is_Blk=highpusurrogates}', "");
    Expect(0, 56319, '\p{^Is_Blk=highpusurrogates}', "");
    Expect(0, 56319, '\P{Is_Blk=highpusurrogates}', "");
    Expect(1, 56319, '\P{^Is_Blk=highpusurrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=highpusurrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=highpusurrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=highpusurrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=highpusurrogates}', "");
    Expect(1, 56319, '\p{Is_Blk=-_high_PU_surrogates}', "");
    Expect(0, 56319, '\p{^Is_Blk=-_high_PU_surrogates}', "");
    Expect(0, 56319, '\P{Is_Blk=-_high_PU_surrogates}', "");
    Expect(1, 56319, '\P{^Is_Blk=-_high_PU_surrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=-_high_PU_surrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=-_high_PU_surrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=-_high_PU_surrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=-_high_PU_surrogates}', "");
    Error('\p{Block=	/a/HIGH_Surrogates}');
    Error('\P{Block=	/a/HIGH_Surrogates}');
    Expect(1, 56191, '\p{Block=:\AHigh_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\AHigh_Surrogates\z:}', "");;
    Expect(1, 56191, '\p{Block=highsurrogates}', "");
    Expect(0, 56191, '\p{^Block=highsurrogates}', "");
    Expect(0, 56191, '\P{Block=highsurrogates}', "");
    Expect(1, 56191, '\P{^Block=highsurrogates}', "");
    Expect(0, 57344, '\p{Block=highsurrogates}', "");
    Expect(1, 57344, '\p{^Block=highsurrogates}', "");
    Expect(1, 57344, '\P{Block=highsurrogates}', "");
    Expect(0, 57344, '\P{^Block=highsurrogates}', "");
    Expect(1, 56191, '\p{Block=:\Ahighsurrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\Ahighsurrogates\z:}', "");;
    Expect(1, 56191, '\p{Block=	 high_Surrogates}', "");
    Expect(0, 56191, '\p{^Block=	 high_Surrogates}', "");
    Expect(0, 56191, '\P{Block=	 high_Surrogates}', "");
    Expect(1, 56191, '\P{^Block=	 high_Surrogates}', "");
    Expect(0, 57344, '\p{Block=	 high_Surrogates}', "");
    Expect(1, 57344, '\p{^Block=	 high_Surrogates}', "");
    Expect(1, 57344, '\P{Block=	 high_Surrogates}', "");
    Expect(0, 57344, '\P{^Block=	 high_Surrogates}', "");
    Error('\p{Blk=/a/_-HIGH_surrogates}');
    Error('\P{Blk=/a/_-HIGH_surrogates}');
    Expect(1, 56191, '\p{Blk=:\AHigh_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\AHigh_Surrogates\z:}', "");;
    Expect(1, 56191, '\p{Blk=highsurrogates}', "");
    Expect(0, 56191, '\p{^Blk=highsurrogates}', "");
    Expect(0, 56191, '\P{Blk=highsurrogates}', "");
    Expect(1, 56191, '\P{^Blk=highsurrogates}', "");
    Expect(0, 57344, '\p{Blk=highsurrogates}', "");
    Expect(1, 57344, '\p{^Blk=highsurrogates}', "");
    Expect(1, 57344, '\P{Blk=highsurrogates}', "");
    Expect(0, 57344, '\P{^Blk=highsurrogates}', "");
    Expect(1, 56191, '\p{Blk=:\Ahighsurrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\Ahighsurrogates\z:}', "");;
    Expect(1, 56191, '\p{Blk=- HIGH_Surrogates}', "");
    Expect(0, 56191, '\p{^Blk=- HIGH_Surrogates}', "");
    Expect(0, 56191, '\P{Blk=- HIGH_Surrogates}', "");
    Expect(1, 56191, '\P{^Blk=- HIGH_Surrogates}', "");
    Expect(0, 57344, '\p{Blk=- HIGH_Surrogates}', "");
    Expect(1, 57344, '\p{^Blk=- HIGH_Surrogates}', "");
    Expect(1, 57344, '\P{Blk=- HIGH_Surrogates}', "");
    Expect(0, 57344, '\P{^Blk=- HIGH_Surrogates}', "");
    Error('\p{Is_Block=:=	high_Surrogates}');
    Error('\P{Is_Block=:=	high_Surrogates}');
    Expect(1, 56191, '\p{Is_Block=highsurrogates}', "");
    Expect(0, 56191, '\p{^Is_Block=highsurrogates}', "");
    Expect(0, 56191, '\P{Is_Block=highsurrogates}', "");
    Expect(1, 56191, '\P{^Is_Block=highsurrogates}', "");
    Expect(0, 57344, '\p{Is_Block=highsurrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=highsurrogates}', "");
    Expect(1, 57344, '\P{Is_Block=highsurrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=highsurrogates}', "");
    Expect(1, 56191, '\p{Is_Block=- HIGH_Surrogates}', "");
    Expect(0, 56191, '\p{^Is_Block=- HIGH_Surrogates}', "");
    Expect(0, 56191, '\P{Is_Block=- HIGH_Surrogates}', "");
    Expect(1, 56191, '\P{^Is_Block=- HIGH_Surrogates}', "");
    Expect(0, 57344, '\p{Is_Block=- HIGH_Surrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=- HIGH_Surrogates}', "");
    Expect(1, 57344, '\P{Is_Block=- HIGH_Surrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=- HIGH_Surrogates}', "");
    Error('\p{Is_Blk=- High_SURROGATES:=}');
    Error('\P{Is_Blk=- High_SURROGATES:=}');
    Expect(1, 56191, '\p{Is_Blk=highsurrogates}', "");
    Expect(0, 56191, '\p{^Is_Blk=highsurrogates}', "");
    Expect(0, 56191, '\P{Is_Blk=highsurrogates}', "");
    Expect(1, 56191, '\P{^Is_Blk=highsurrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=highsurrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=highsurrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=highsurrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=highsurrogates}', "");
    Expect(1, 56191, '\p{Is_Blk=_-High_Surrogates}', "");
    Expect(0, 56191, '\p{^Is_Blk=_-High_Surrogates}', "");
    Expect(0, 56191, '\P{Is_Blk=_-High_Surrogates}', "");
    Expect(1, 56191, '\P{^Is_Blk=_-High_Surrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=_-High_Surrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=_-High_Surrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=_-High_Surrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=_-High_Surrogates}', "");
    Error('\p{Block=:=Hiragana}');
    Error('\P{Block=:=Hiragana}');
    Expect(1, 12447, '\p{Block=:\AHiragana\z:}', "");;
    Expect(0, 12448, '\p{Block=:\AHiragana\z:}', "");;
    Expect(1, 12447, '\p{Block=hiragana}', "");
    Expect(0, 12447, '\p{^Block=hiragana}', "");
    Expect(0, 12447, '\P{Block=hiragana}', "");
    Expect(1, 12447, '\P{^Block=hiragana}', "");
    Expect(0, 12448, '\p{Block=hiragana}', "");
    Expect(1, 12448, '\p{^Block=hiragana}', "");
    Expect(1, 12448, '\P{Block=hiragana}', "");
    Expect(0, 12448, '\P{^Block=hiragana}', "");
    Expect(1, 12447, '\p{Block=:\Ahiragana\z:}', "");;
    Expect(0, 12448, '\p{Block=:\Ahiragana\z:}', "");;
    Expect(1, 12447, '\p{Block=_	Hiragana}', "");
    Expect(0, 12447, '\p{^Block=_	Hiragana}', "");
    Expect(0, 12447, '\P{Block=_	Hiragana}', "");
    Expect(1, 12447, '\P{^Block=_	Hiragana}', "");
    Expect(0, 12448, '\p{Block=_	Hiragana}', "");
    Expect(1, 12448, '\p{^Block=_	Hiragana}', "");
    Expect(1, 12448, '\P{Block=_	Hiragana}', "");
    Expect(0, 12448, '\P{^Block=_	Hiragana}', "");
    Error('\p{Blk=_:=Hiragana}');
    Error('\P{Blk=_:=Hiragana}');
    Expect(1, 12447, '\p{Blk=:\AHiragana\z:}', "");;
    Expect(0, 12448, '\p{Blk=:\AHiragana\z:}', "");;
    Expect(1, 12447, '\p{Blk=hiragana}', "");
    Expect(0, 12447, '\p{^Blk=hiragana}', "");
    Expect(0, 12447, '\P{Blk=hiragana}', "");
    Expect(1, 12447, '\P{^Blk=hiragana}', "");
    Expect(0, 12448, '\p{Blk=hiragana}', "");
    Expect(1, 12448, '\p{^Blk=hiragana}', "");
    Expect(1, 12448, '\P{Blk=hiragana}', "");
    Expect(0, 12448, '\P{^Blk=hiragana}', "");
    Expect(1, 12447, '\p{Blk=:\Ahiragana\z:}', "");;
    Expect(0, 12448, '\p{Blk=:\Ahiragana\z:}', "");;
    Expect(1, 12447, '\p{Blk:   --HIRAGANA}', "");
    Expect(0, 12447, '\p{^Blk:   --HIRAGANA}', "");
    Expect(0, 12447, '\P{Blk:   --HIRAGANA}', "");
    Expect(1, 12447, '\P{^Blk:   --HIRAGANA}', "");
    Expect(0, 12448, '\p{Blk:   --HIRAGANA}', "");
    Expect(1, 12448, '\p{^Blk:   --HIRAGANA}', "");
    Expect(1, 12448, '\P{Blk:   --HIRAGANA}', "");
    Expect(0, 12448, '\P{^Blk:   --HIRAGANA}', "");
    Error('\p{Is_Block= Hiragana:=}');
    Error('\P{Is_Block= Hiragana:=}');
    Expect(1, 12447, '\p{Is_Block=hiragana}', "");
    Expect(0, 12447, '\p{^Is_Block=hiragana}', "");
    Expect(0, 12447, '\P{Is_Block=hiragana}', "");
    Expect(1, 12447, '\P{^Is_Block=hiragana}', "");
    Expect(0, 12448, '\p{Is_Block=hiragana}', "");
    Expect(1, 12448, '\p{^Is_Block=hiragana}', "");
    Expect(1, 12448, '\P{Is_Block=hiragana}', "");
    Expect(0, 12448, '\P{^Is_Block=hiragana}', "");
    Expect(1, 12447, '\p{Is_Block=-hiragana}', "");
    Expect(0, 12447, '\p{^Is_Block=-hiragana}', "");
    Expect(0, 12447, '\P{Is_Block=-hiragana}', "");
    Expect(1, 12447, '\P{^Is_Block=-hiragana}', "");
    Expect(0, 12448, '\p{Is_Block=-hiragana}', "");
    Expect(1, 12448, '\p{^Is_Block=-hiragana}', "");
    Expect(1, 12448, '\P{Is_Block=-hiragana}', "");
    Expect(0, 12448, '\P{^Is_Block=-hiragana}', "");
    Error('\p{Is_Blk=/a/- Hiragana}');
    Error('\P{Is_Blk=/a/- Hiragana}');
    Expect(1, 12447, '\p{Is_Blk:hiragana}', "");
    Expect(0, 12447, '\p{^Is_Blk:hiragana}', "");
    Expect(0, 12447, '\P{Is_Blk:hiragana}', "");
    Expect(1, 12447, '\P{^Is_Blk:hiragana}', "");
    Expect(0, 12448, '\p{Is_Blk:hiragana}', "");
    Expect(1, 12448, '\p{^Is_Blk:hiragana}', "");
    Expect(1, 12448, '\P{Is_Blk:hiragana}', "");
    Expect(0, 12448, '\P{^Is_Blk:hiragana}', "");
    Expect(1, 12447, '\p{Is_Blk=-_Hiragana}', "");
    Expect(0, 12447, '\p{^Is_Blk=-_Hiragana}', "");
    Expect(0, 12447, '\P{Is_Blk=-_Hiragana}', "");
    Expect(1, 12447, '\P{^Is_Blk=-_Hiragana}', "");
    Expect(0, 12448, '\p{Is_Blk=-_Hiragana}', "");
    Expect(1, 12448, '\p{^Is_Blk=-_Hiragana}', "");
    Expect(1, 12448, '\P{Is_Blk=-_Hiragana}', "");
    Expect(0, 12448, '\P{^Is_Blk=-_Hiragana}', "");
    Error('\p{Block=--ideographic_description_Characters:=}');
    Error('\P{Block=--ideographic_description_Characters:=}');
    Expect(1, 12287, '\p{Block=:\AIdeographic_Description_Characters\z:}', "");;
    Expect(0, 12288, '\p{Block=:\AIdeographic_Description_Characters\z:}', "");;
    Expect(1, 12287, '\p{Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12287, '\p{^Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12287, '\P{Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12287, '\P{^Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12288, '\p{Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12288, '\p{^Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12288, '\P{Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12288, '\P{^Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12287, '\p{Block=:\Aideographicdescriptioncharacters\z:}', "");;
    Expect(0, 12288, '\p{Block=:\Aideographicdescriptioncharacters\z:}', "");;
    Expect(1, 12287, '\p{Block:   Ideographic_description_Characters}', "");
    Expect(0, 12287, '\p{^Block:   Ideographic_description_Characters}', "");
    Expect(0, 12287, '\P{Block:   Ideographic_description_Characters}', "");
    Expect(1, 12287, '\P{^Block:   Ideographic_description_Characters}', "");
    Expect(0, 12288, '\p{Block:   Ideographic_description_Characters}', "");
    Expect(1, 12288, '\p{^Block:   Ideographic_description_Characters}', "");
    Expect(1, 12288, '\P{Block:   Ideographic_description_Characters}', "");
    Expect(0, 12288, '\P{^Block:   Ideographic_description_Characters}', "");
    Error('\p{Blk=-	IDC/a/}');
    Error('\P{Blk=-	IDC/a/}');
    Expect(1, 12287, '\p{Blk=:\AIDC\z:}', "");;
    Expect(0, 12288, '\p{Blk=:\AIDC\z:}', "");;
    Expect(1, 12287, '\p{Blk=idc}', "");
    Expect(0, 12287, '\p{^Blk=idc}', "");
    Expect(0, 12287, '\P{Blk=idc}', "");
    Expect(1, 12287, '\P{^Blk=idc}', "");
    Expect(0, 12288, '\p{Blk=idc}', "");
    Expect(1, 12288, '\p{^Blk=idc}', "");
    Expect(1, 12288, '\P{Blk=idc}', "");
    Expect(0, 12288, '\P{^Blk=idc}', "");
    Expect(1, 12287, '\p{Blk=:\Aidc\z:}', "");;
    Expect(0, 12288, '\p{Blk=:\Aidc\z:}', "");;
    Expect(1, 12287, '\p{Blk=	idc}', "");
    Expect(0, 12287, '\p{^Blk=	idc}', "");
    Expect(0, 12287, '\P{Blk=	idc}', "");
    Expect(1, 12287, '\P{^Blk=	idc}', "");
    Expect(0, 12288, '\p{Blk=	idc}', "");
    Expect(1, 12288, '\p{^Blk=	idc}', "");
    Expect(1, 12288, '\P{Blk=	idc}', "");
    Expect(0, 12288, '\P{^Blk=	idc}', "");
    Error('\p{Is_Block=_:=IDEOGRAPHIC_Description_characters}');
    Error('\P{Is_Block=_:=IDEOGRAPHIC_Description_characters}');
    Expect(1, 12287, '\p{Is_Block: ideographicdescriptioncharacters}', "");
    Expect(0, 12287, '\p{^Is_Block: ideographicdescriptioncharacters}', "");
    Expect(0, 12287, '\P{Is_Block: ideographicdescriptioncharacters}', "");
    Expect(1, 12287, '\P{^Is_Block: ideographicdescriptioncharacters}', "");
    Expect(0, 12288, '\p{Is_Block: ideographicdescriptioncharacters}', "");
    Expect(1, 12288, '\p{^Is_Block: ideographicdescriptioncharacters}', "");
    Expect(1, 12288, '\P{Is_Block: ideographicdescriptioncharacters}', "");
    Expect(0, 12288, '\P{^Is_Block: ideographicdescriptioncharacters}', "");
    Expect(1, 12287, '\p{Is_Block=		ideographic_Description_Characters}', "");
    Expect(0, 12287, '\p{^Is_Block=		ideographic_Description_Characters}', "");
    Expect(0, 12287, '\P{Is_Block=		ideographic_Description_Characters}', "");
    Expect(1, 12287, '\P{^Is_Block=		ideographic_Description_Characters}', "");
    Expect(0, 12288, '\p{Is_Block=		ideographic_Description_Characters}', "");
    Expect(1, 12288, '\p{^Is_Block=		ideographic_Description_Characters}', "");
    Expect(1, 12288, '\P{Is_Block=		ideographic_Description_Characters}', "");
    Expect(0, 12288, '\P{^Is_Block=		ideographic_Description_Characters}', "");
    Error('\p{Is_Blk=	_idc/a/}');
    Error('\P{Is_Blk=	_idc/a/}');
    Expect(1, 12287, '\p{Is_Blk:	idc}', "");
    Expect(0, 12287, '\p{^Is_Blk:	idc}', "");
    Expect(0, 12287, '\P{Is_Blk:	idc}', "");
    Expect(1, 12287, '\P{^Is_Blk:	idc}', "");
    Expect(0, 12288, '\p{Is_Blk:	idc}', "");
    Expect(1, 12288, '\p{^Is_Blk:	idc}', "");
    Expect(1, 12288, '\P{Is_Blk:	idc}', "");
    Expect(0, 12288, '\P{^Is_Blk:	idc}', "");
    Expect(1, 12287, '\p{Is_Blk= _IDC}', "");
    Expect(0, 12287, '\p{^Is_Blk= _IDC}', "");
    Expect(0, 12287, '\P{Is_Blk= _IDC}', "");
    Expect(1, 12287, '\P{^Is_Blk= _IDC}', "");
    Expect(0, 12288, '\p{Is_Blk= _IDC}', "");
    Expect(1, 12288, '\p{^Is_Blk= _IDC}', "");
    Expect(1, 12288, '\P{Is_Blk= _IDC}', "");
    Expect(0, 12288, '\P{^Is_Blk= _IDC}', "");
    Error('\p{Block=- IDEOGRAPHIC_symbols_And_punctuation:=}');
    Error('\P{Block=- IDEOGRAPHIC_symbols_And_punctuation:=}');
    Expect(1, 94207, '\p{Block=:\AIdeographic_Symbols_And_Punctuation\z:}', "");;
    Expect(0, 94208, '\p{Block=:\AIdeographic_Symbols_And_Punctuation\z:}', "");;
    Expect(1, 94207, '\p{Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94207, '\p{^Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94207, '\P{Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94207, '\P{^Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94208, '\p{Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94208, '\p{^Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94208, '\P{Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94208, '\P{^Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94207, '\p{Block=:\Aideographicsymbolsandpunctuation\z:}', "");;
    Expect(0, 94208, '\p{Block=:\Aideographicsymbolsandpunctuation\z:}', "");;
    Expect(1, 94207, '\p{Block=-	IDEOGRAPHIC_SYMBOLS_And_PUNCTUATION}', "");
    Expect(0, 94207, '\p{^Block=-	IDEOGRAPHIC_SYMBOLS_And_PUNCTUATION}', "");
    Expect(0, 94207, '\P{Block=-	IDEOGRAPHIC_SYMBOLS_And_PUNCTUATION}', "");
    Expect(1, 94207, '\P{^Block=-	IDEOGRAPHIC_SYMBOLS_And_PUNCTUATION}', "");
    Expect(0, 94208, '\p{Block=-	IDEOGRAPHIC_SYMBOLS_And_PUNCTUATION}', "");
    Expect(1, 94208, '\p{^Block=-	IDEOGRAPHIC_SYMBOLS_And_PUNCTUATION}', "");
    Expect(1, 94208, '\P{Block=-	IDEOGRAPHIC_SYMBOLS_And_PUNCTUATION}', "");
    Expect(0, 94208, '\P{^Block=-	IDEOGRAPHIC_SYMBOLS_And_PUNCTUATION}', "");
    Error('\p{Blk=:=	-Ideographic_Symbols}');
    Error('\P{Blk=:=	-Ideographic_Symbols}');
    Expect(1, 94207, '\p{Blk=:\AIdeographic_Symbols\z:}', "");;
    Expect(0, 94208, '\p{Blk=:\AIdeographic_Symbols\z:}', "");;
    Expect(1, 94207, '\p{Blk=ideographicsymbols}', "");
    Expect(0, 94207, '\p{^Blk=ideographicsymbols}', "");
    Expect(0, 94207, '\P{Blk=ideographicsymbols}', "");
    Expect(1, 94207, '\P{^Blk=ideographicsymbols}', "");
    Expect(0, 94208, '\p{Blk=ideographicsymbols}', "");
    Expect(1, 94208, '\p{^Blk=ideographicsymbols}', "");
    Expect(1, 94208, '\P{Blk=ideographicsymbols}', "");
    Expect(0, 94208, '\P{^Blk=ideographicsymbols}', "");
    Expect(1, 94207, '\p{Blk=:\Aideographicsymbols\z:}', "");;
    Expect(0, 94208, '\p{Blk=:\Aideographicsymbols\z:}', "");;
    Expect(1, 94207, '\p{Blk= -Ideographic_Symbols}', "");
    Expect(0, 94207, '\p{^Blk= -Ideographic_Symbols}', "");
    Expect(0, 94207, '\P{Blk= -Ideographic_Symbols}', "");
    Expect(1, 94207, '\P{^Blk= -Ideographic_Symbols}', "");
    Expect(0, 94208, '\p{Blk= -Ideographic_Symbols}', "");
    Expect(1, 94208, '\p{^Blk= -Ideographic_Symbols}', "");
    Expect(1, 94208, '\P{Blk= -Ideographic_Symbols}', "");
    Expect(0, 94208, '\P{^Blk= -Ideographic_Symbols}', "");
    Error('\p{Is_Block:   -:=ideographic_Symbols_And_Punctuation}');
    Error('\P{Is_Block:   -:=ideographic_Symbols_And_Punctuation}');
    Expect(1, 94207, '\p{Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94207, '\p{^Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94207, '\P{Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94207, '\P{^Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94208, '\p{Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94208, '\p{^Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94208, '\P{Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94208, '\P{^Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94207, '\p{Is_Block=_	ideographic_Symbols_AND_PUNCTUATION}', "");
    Expect(0, 94207, '\p{^Is_Block=_	ideographic_Symbols_AND_PUNCTUATION}', "");
    Expect(0, 94207, '\P{Is_Block=_	ideographic_Symbols_AND_PUNCTUATION}', "");
    Expect(1, 94207, '\P{^Is_Block=_	ideographic_Symbols_AND_PUNCTUATION}', "");
    Expect(0, 94208, '\p{Is_Block=_	ideographic_Symbols_AND_PUNCTUATION}', "");
    Expect(1, 94208, '\p{^Is_Block=_	ideographic_Symbols_AND_PUNCTUATION}', "");
    Expect(1, 94208, '\P{Is_Block=_	ideographic_Symbols_AND_PUNCTUATION}', "");
    Expect(0, 94208, '\P{^Is_Block=_	ideographic_Symbols_AND_PUNCTUATION}', "");
    Error('\p{Is_Blk= :=Ideographic_Symbols}');
    Error('\P{Is_Blk= :=Ideographic_Symbols}');
    Expect(1, 94207, '\p{Is_Blk=ideographicsymbols}', "");
    Expect(0, 94207, '\p{^Is_Blk=ideographicsymbols}', "");
    Expect(0, 94207, '\P{Is_Blk=ideographicsymbols}', "");
    Expect(1, 94207, '\P{^Is_Blk=ideographicsymbols}', "");
    Expect(0, 94208, '\p{Is_Blk=ideographicsymbols}', "");
    Expect(1, 94208, '\p{^Is_Blk=ideographicsymbols}', "");
    Expect(1, 94208, '\P{Is_Blk=ideographicsymbols}', "");
    Expect(0, 94208, '\P{^Is_Blk=ideographicsymbols}', "");
    Expect(1, 94207, '\p{Is_Blk=_ ideographic_Symbols}', "");
    Expect(0, 94207, '\p{^Is_Blk=_ ideographic_Symbols}', "");
    Expect(0, 94207, '\P{Is_Blk=_ ideographic_Symbols}', "");
    Expect(1, 94207, '\P{^Is_Blk=_ ideographic_Symbols}', "");
    Expect(0, 94208, '\p{Is_Blk=_ ideographic_Symbols}', "");
    Expect(1, 94208, '\p{^Is_Blk=_ ideographic_Symbols}', "");
    Expect(1, 94208, '\P{Is_Blk=_ ideographic_Symbols}', "");
    Expect(0, 94208, '\P{^Is_Blk=_ ideographic_Symbols}', "");
    Error('\p{Block=/a/--Imperial_ARAMAIC}');
    Error('\P{Block=/a/--Imperial_ARAMAIC}');
    Expect(1, 67679, '\p{Block=:\AImperial_Aramaic\z:}', "");;
    Expect(0, 67680, '\p{Block=:\AImperial_Aramaic\z:}', "");;
    Expect(1, 67679, '\p{Block=imperialaramaic}', "");
    Expect(0, 67679, '\p{^Block=imperialaramaic}', "");
    Expect(0, 67679, '\P{Block=imperialaramaic}', "");
    Expect(1, 67679, '\P{^Block=imperialaramaic}', "");
    Expect(0, 67680, '\p{Block=imperialaramaic}', "");
    Expect(1, 67680, '\p{^Block=imperialaramaic}', "");
    Expect(1, 67680, '\P{Block=imperialaramaic}', "");
    Expect(0, 67680, '\P{^Block=imperialaramaic}', "");
    Expect(1, 67679, '\p{Block=:\Aimperialaramaic\z:}', "");;
    Expect(0, 67680, '\p{Block=:\Aimperialaramaic\z:}', "");;
    Expect(1, 67679, '\p{Block:	IMPERIAL_ARAMAIC}', "");
    Expect(0, 67679, '\p{^Block:	IMPERIAL_ARAMAIC}', "");
    Expect(0, 67679, '\P{Block:	IMPERIAL_ARAMAIC}', "");
    Expect(1, 67679, '\P{^Block:	IMPERIAL_ARAMAIC}', "");
    Expect(0, 67680, '\p{Block:	IMPERIAL_ARAMAIC}', "");
    Expect(1, 67680, '\p{^Block:	IMPERIAL_ARAMAIC}', "");
    Expect(1, 67680, '\P{Block:	IMPERIAL_ARAMAIC}', "");
    Expect(0, 67680, '\P{^Block:	IMPERIAL_ARAMAIC}', "");
    Error('\p{Blk=	/a/Imperial_Aramaic}');
    Error('\P{Blk=	/a/Imperial_Aramaic}');
    Expect(1, 67679, '\p{Blk=:\AImperial_Aramaic\z:}', "");;
    Expect(0, 67680, '\p{Blk=:\AImperial_Aramaic\z:}', "");;
    Expect(1, 67679, '\p{Blk=imperialaramaic}', "");
    Expect(0, 67679, '\p{^Blk=imperialaramaic}', "");
    Expect(0, 67679, '\P{Blk=imperialaramaic}', "");
    Expect(1, 67679, '\P{^Blk=imperialaramaic}', "");
    Expect(0, 67680, '\p{Blk=imperialaramaic}', "");
    Expect(1, 67680, '\p{^Blk=imperialaramaic}', "");
    Expect(1, 67680, '\P{Blk=imperialaramaic}', "");
    Expect(0, 67680, '\P{^Blk=imperialaramaic}', "");
    Expect(1, 67679, '\p{Blk=:\Aimperialaramaic\z:}', "");;
    Expect(0, 67680, '\p{Blk=:\Aimperialaramaic\z:}', "");;
    Expect(1, 67679, '\p{Blk:-	Imperial_aramaic}', "");
    Expect(0, 67679, '\p{^Blk:-	Imperial_aramaic}', "");
    Expect(0, 67679, '\P{Blk:-	Imperial_aramaic}', "");
    Expect(1, 67679, '\P{^Blk:-	Imperial_aramaic}', "");
    Expect(0, 67680, '\p{Blk:-	Imperial_aramaic}', "");
    Expect(1, 67680, '\p{^Blk:-	Imperial_aramaic}', "");
    Expect(1, 67680, '\P{Blk:-	Imperial_aramaic}', "");
    Expect(0, 67680, '\P{^Blk:-	Imperial_aramaic}', "");
    Error('\p{Is_Block::=imperial_aramaic}');
    Error('\P{Is_Block::=imperial_aramaic}');
    Expect(1, 67679, '\p{Is_Block=imperialaramaic}', "");
    Expect(0, 67679, '\p{^Is_Block=imperialaramaic}', "");
    Expect(0, 67679, '\P{Is_Block=imperialaramaic}', "");
    Expect(1, 67679, '\P{^Is_Block=imperialaramaic}', "");
    Expect(0, 67680, '\p{Is_Block=imperialaramaic}', "");
    Expect(1, 67680, '\p{^Is_Block=imperialaramaic}', "");
    Expect(1, 67680, '\P{Is_Block=imperialaramaic}', "");
    Expect(0, 67680, '\P{^Is_Block=imperialaramaic}', "");
    Expect(1, 67679, '\p{Is_Block= 	Imperial_Aramaic}', "");
    Expect(0, 67679, '\p{^Is_Block= 	Imperial_Aramaic}', "");
    Expect(0, 67679, '\P{Is_Block= 	Imperial_Aramaic}', "");
    Expect(1, 67679, '\P{^Is_Block= 	Imperial_Aramaic}', "");
    Expect(0, 67680, '\p{Is_Block= 	Imperial_Aramaic}', "");
    Expect(1, 67680, '\p{^Is_Block= 	Imperial_Aramaic}', "");
    Expect(1, 67680, '\P{Is_Block= 	Imperial_Aramaic}', "");
    Expect(0, 67680, '\P{^Is_Block= 	Imperial_Aramaic}', "");
    Error('\p{Is_Blk=- Imperial_ARAMAIC:=}');
    Error('\P{Is_Blk=- Imperial_ARAMAIC:=}');
    Expect(1, 67679, '\p{Is_Blk=imperialaramaic}', "");
    Expect(0, 67679, '\p{^Is_Blk=imperialaramaic}', "");
    Expect(0, 67679, '\P{Is_Blk=imperialaramaic}', "");
    Expect(1, 67679, '\P{^Is_Blk=imperialaramaic}', "");
    Expect(0, 67680, '\p{Is_Blk=imperialaramaic}', "");
    Expect(1, 67680, '\p{^Is_Blk=imperialaramaic}', "");
    Expect(1, 67680, '\P{Is_Blk=imperialaramaic}', "");
    Expect(0, 67680, '\P{^Is_Blk=imperialaramaic}', "");
    Expect(1, 67679, '\p{Is_Blk=_-imperial_ARAMAIC}', "");
    Expect(0, 67679, '\p{^Is_Blk=_-imperial_ARAMAIC}', "");
    Expect(0, 67679, '\P{Is_Blk=_-imperial_ARAMAIC}', "");
    Expect(1, 67679, '\P{^Is_Blk=_-imperial_ARAMAIC}', "");
    Expect(0, 67680, '\p{Is_Blk=_-imperial_ARAMAIC}', "");
    Expect(1, 67680, '\p{^Is_Blk=_-imperial_ARAMAIC}', "");
    Expect(1, 67680, '\P{Is_Blk=_-imperial_ARAMAIC}', "");
    Expect(0, 67680, '\P{^Is_Blk=_-imperial_ARAMAIC}', "");
    Error('\p{Block=/a/ Common_Indic_NUMBER_Forms}');
    Error('\P{Block=/a/ Common_Indic_NUMBER_Forms}');
    Expect(1, 43071, '\p{Block=:\ACommon_Indic_Number_Forms\z:}', "");;
    Expect(0, 43072, '\p{Block=:\ACommon_Indic_Number_Forms\z:}', "");;
    Expect(1, 43071, '\p{Block=commonindicnumberforms}', "");
    Expect(0, 43071, '\p{^Block=commonindicnumberforms}', "");
    Expect(0, 43071, '\P{Block=commonindicnumberforms}', "");
    Expect(1, 43071, '\P{^Block=commonindicnumberforms}', "");
    Expect(0, 43072, '\p{Block=commonindicnumberforms}', "");
    Expect(1, 43072, '\p{^Block=commonindicnumberforms}', "");
    Expect(1, 43072, '\P{Block=commonindicnumberforms}', "");
    Expect(0, 43072, '\P{^Block=commonindicnumberforms}', "");
    Expect(1, 43071, '\p{Block=:\Acommonindicnumberforms\z:}', "");;
    Expect(0, 43072, '\p{Block=:\Acommonindicnumberforms\z:}', "");;
    Expect(1, 43071, '\p{Block=		Common_indic_Number_Forms}', "");
    Expect(0, 43071, '\p{^Block=		Common_indic_Number_Forms}', "");
    Expect(0, 43071, '\P{Block=		Common_indic_Number_Forms}', "");
    Expect(1, 43071, '\P{^Block=		Common_indic_Number_Forms}', "");
    Expect(0, 43072, '\p{Block=		Common_indic_Number_Forms}', "");
    Expect(1, 43072, '\p{^Block=		Common_indic_Number_Forms}', "");
    Expect(1, 43072, '\P{Block=		Common_indic_Number_Forms}', "");
    Expect(0, 43072, '\P{^Block=		Common_indic_Number_Forms}', "");
    Error('\p{Blk=_ Indic_number_Forms:=}');
    Error('\P{Blk=_ Indic_number_Forms:=}');
    Expect(1, 43071, '\p{Blk=:\AIndic_Number_Forms\z:}', "");;
    Expect(0, 43072, '\p{Blk=:\AIndic_Number_Forms\z:}', "");;
    Expect(1, 43071, '\p{Blk=indicnumberforms}', "");
    Expect(0, 43071, '\p{^Blk=indicnumberforms}', "");
    Expect(0, 43071, '\P{Blk=indicnumberforms}', "");
    Expect(1, 43071, '\P{^Blk=indicnumberforms}', "");
    Expect(0, 43072, '\p{Blk=indicnumberforms}', "");
    Expect(1, 43072, '\p{^Blk=indicnumberforms}', "");
    Expect(1, 43072, '\P{Blk=indicnumberforms}', "");
    Expect(0, 43072, '\P{^Blk=indicnumberforms}', "");
    Expect(1, 43071, '\p{Blk=:\Aindicnumberforms\z:}', "");;
    Expect(0, 43072, '\p{Blk=:\Aindicnumberforms\z:}', "");;
    Expect(1, 43071, '\p{Blk=_ INDIC_number_Forms}', "");
    Expect(0, 43071, '\p{^Blk=_ INDIC_number_Forms}', "");
    Expect(0, 43071, '\P{Blk=_ INDIC_number_Forms}', "");
    Expect(1, 43071, '\P{^Blk=_ INDIC_number_Forms}', "");
    Expect(0, 43072, '\p{Blk=_ INDIC_number_Forms}', "");
    Expect(1, 43072, '\p{^Blk=_ INDIC_number_Forms}', "");
    Expect(1, 43072, '\P{Blk=_ INDIC_number_Forms}', "");
    Expect(0, 43072, '\P{^Blk=_ INDIC_number_Forms}', "");
    Error('\p{Is_Block=_/a/Common_indic_NUMBER_Forms}');
    Error('\P{Is_Block=_/a/Common_indic_NUMBER_Forms}');
    Expect(1, 43071, '\p{Is_Block=commonindicnumberforms}', "");
    Expect(0, 43071, '\p{^Is_Block=commonindicnumberforms}', "");
    Expect(0, 43071, '\P{Is_Block=commonindicnumberforms}', "");
    Expect(1, 43071, '\P{^Is_Block=commonindicnumberforms}', "");
    Expect(0, 43072, '\p{Is_Block=commonindicnumberforms}', "");
    Expect(1, 43072, '\p{^Is_Block=commonindicnumberforms}', "");
    Expect(1, 43072, '\P{Is_Block=commonindicnumberforms}', "");
    Expect(0, 43072, '\P{^Is_Block=commonindicnumberforms}', "");
    Expect(1, 43071, '\p{Is_Block=common_INDIC_NUMBER_Forms}', "");
    Expect(0, 43071, '\p{^Is_Block=common_INDIC_NUMBER_Forms}', "");
    Expect(0, 43071, '\P{Is_Block=common_INDIC_NUMBER_Forms}', "");
    Expect(1, 43071, '\P{^Is_Block=common_INDIC_NUMBER_Forms}', "");
    Expect(0, 43072, '\p{Is_Block=common_INDIC_NUMBER_Forms}', "");
    Expect(1, 43072, '\p{^Is_Block=common_INDIC_NUMBER_Forms}', "");
    Expect(1, 43072, '\P{Is_Block=common_INDIC_NUMBER_Forms}', "");
    Expect(0, 43072, '\P{^Is_Block=common_INDIC_NUMBER_Forms}', "");
    Error('\p{Is_Blk=	Indic_number_forms:=}');
    Error('\P{Is_Blk=	Indic_number_forms:=}');
    Expect(1, 43071, '\p{Is_Blk=indicnumberforms}', "");
    Expect(0, 43071, '\p{^Is_Blk=indicnumberforms}', "");
    Expect(0, 43071, '\P{Is_Blk=indicnumberforms}', "");
    Expect(1, 43071, '\P{^Is_Blk=indicnumberforms}', "");
    Expect(0, 43072, '\p{Is_Blk=indicnumberforms}', "");
    Expect(1, 43072, '\p{^Is_Blk=indicnumberforms}', "");
    Expect(1, 43072, '\P{Is_Blk=indicnumberforms}', "");
    Expect(0, 43072, '\P{^Is_Blk=indicnumberforms}', "");
    Expect(1, 43071, '\p{Is_Blk=-INDIC_Number_Forms}', "");
    Expect(0, 43071, '\p{^Is_Blk=-INDIC_Number_Forms}', "");
    Expect(0, 43071, '\P{Is_Blk=-INDIC_Number_Forms}', "");
    Expect(1, 43071, '\P{^Is_Blk=-INDIC_Number_Forms}', "");
    Expect(0, 43072, '\p{Is_Blk=-INDIC_Number_Forms}', "");
    Expect(1, 43072, '\p{^Is_Blk=-INDIC_Number_Forms}', "");
    Expect(1, 43072, '\P{Is_Blk=-INDIC_Number_Forms}', "");
    Expect(0, 43072, '\P{^Is_Blk=-INDIC_Number_Forms}', "");
    Error('\p{Block= -INDIC_siyaq_NUMBERS/a/}');
    Error('\P{Block= -INDIC_siyaq_NUMBERS/a/}');
    Expect(1, 126143, '\p{Block=:\AIndic_Siyaq_Numbers\z:}', "");;
    Expect(0, 126144, '\p{Block=:\AIndic_Siyaq_Numbers\z:}', "");;
    Expect(1, 126143, '\p{Block=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\p{^Block=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\P{Block=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\P{^Block=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\p{Block=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\p{^Block=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\P{Block=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\P{^Block=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\p{Block=:\Aindicsiyaqnumbers\z:}', "");;
    Expect(0, 126144, '\p{Block=:\Aindicsiyaqnumbers\z:}', "");;
    Expect(1, 126143, '\p{Block=	INDIC_Siyaq_NUMBERS}', "");
    Expect(0, 126143, '\p{^Block=	INDIC_Siyaq_NUMBERS}', "");
    Expect(0, 126143, '\P{Block=	INDIC_Siyaq_NUMBERS}', "");
    Expect(1, 126143, '\P{^Block=	INDIC_Siyaq_NUMBERS}', "");
    Expect(0, 126144, '\p{Block=	INDIC_Siyaq_NUMBERS}', "");
    Expect(1, 126144, '\p{^Block=	INDIC_Siyaq_NUMBERS}', "");
    Expect(1, 126144, '\P{Block=	INDIC_Siyaq_NUMBERS}', "");
    Expect(0, 126144, '\P{^Block=	INDIC_Siyaq_NUMBERS}', "");
    Error('\p{Blk=/a/__Indic_Siyaq_numbers}');
    Error('\P{Blk=/a/__Indic_Siyaq_numbers}');
    Expect(1, 126143, '\p{Blk=:\AIndic_Siyaq_Numbers\z:}', "");;
    Expect(0, 126144, '\p{Blk=:\AIndic_Siyaq_Numbers\z:}', "");;
    Expect(1, 126143, '\p{Blk=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\p{^Blk=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\P{Blk=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\P{^Blk=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\p{Blk=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\p{^Blk=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\P{Blk=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\P{^Blk=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\p{Blk=:\Aindicsiyaqnumbers\z:}', "");;
    Expect(0, 126144, '\p{Blk=:\Aindicsiyaqnumbers\z:}', "");;
    Expect(1, 126143, '\p{Blk= -Indic_SIYAQ_Numbers}', "");
    Expect(0, 126143, '\p{^Blk= -Indic_SIYAQ_Numbers}', "");
    Expect(0, 126143, '\P{Blk= -Indic_SIYAQ_Numbers}', "");
    Expect(1, 126143, '\P{^Blk= -Indic_SIYAQ_Numbers}', "");
    Expect(0, 126144, '\p{Blk= -Indic_SIYAQ_Numbers}', "");
    Expect(1, 126144, '\p{^Blk= -Indic_SIYAQ_Numbers}', "");
    Expect(1, 126144, '\P{Blk= -Indic_SIYAQ_Numbers}', "");
    Expect(0, 126144, '\P{^Blk= -Indic_SIYAQ_Numbers}', "");
    Error('\p{Is_Block=_:=Indic_siyaq_Numbers}');
    Error('\P{Is_Block=_:=Indic_siyaq_Numbers}');
    Expect(1, 126143, '\p{Is_Block=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\p{^Is_Block=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\P{Is_Block=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\P{^Is_Block=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\p{Is_Block=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\p{^Is_Block=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\P{Is_Block=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\P{^Is_Block=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\p{Is_Block=-Indic_SIYAQ_Numbers}', "");
    Expect(0, 126143, '\p{^Is_Block=-Indic_SIYAQ_Numbers}', "");
    Expect(0, 126143, '\P{Is_Block=-Indic_SIYAQ_Numbers}', "");
    Expect(1, 126143, '\P{^Is_Block=-Indic_SIYAQ_Numbers}', "");
    Expect(0, 126144, '\p{Is_Block=-Indic_SIYAQ_Numbers}', "");
    Expect(1, 126144, '\p{^Is_Block=-Indic_SIYAQ_Numbers}', "");
    Expect(1, 126144, '\P{Is_Block=-Indic_SIYAQ_Numbers}', "");
    Expect(0, 126144, '\P{^Is_Block=-Indic_SIYAQ_Numbers}', "");
    Error('\p{Is_Blk:		INDIC_SIYAQ_numbers:=}');
    Error('\P{Is_Blk:		INDIC_SIYAQ_numbers:=}');
    Expect(1, 126143, '\p{Is_Blk:	indicsiyaqnumbers}', "");
    Expect(0, 126143, '\p{^Is_Blk:	indicsiyaqnumbers}', "");
    Expect(0, 126143, '\P{Is_Blk:	indicsiyaqnumbers}', "");
    Expect(1, 126143, '\P{^Is_Blk:	indicsiyaqnumbers}', "");
    Expect(0, 126144, '\p{Is_Blk:	indicsiyaqnumbers}', "");
    Expect(1, 126144, '\p{^Is_Blk:	indicsiyaqnumbers}', "");
    Expect(1, 126144, '\P{Is_Blk:	indicsiyaqnumbers}', "");
    Expect(0, 126144, '\P{^Is_Blk:	indicsiyaqnumbers}', "");
    Expect(1, 126143, '\p{Is_Blk=_	indic_SIYAQ_Numbers}', "");
    Expect(0, 126143, '\p{^Is_Blk=_	indic_SIYAQ_Numbers}', "");
    Expect(0, 126143, '\P{Is_Blk=_	indic_SIYAQ_Numbers}', "");
    Expect(1, 126143, '\P{^Is_Blk=_	indic_SIYAQ_Numbers}', "");
    Expect(0, 126144, '\p{Is_Blk=_	indic_SIYAQ_Numbers}', "");
    Expect(1, 126144, '\p{^Is_Blk=_	indic_SIYAQ_Numbers}', "");
    Expect(1, 126144, '\P{Is_Blk=_	indic_SIYAQ_Numbers}', "");
    Expect(0, 126144, '\P{^Is_Blk=_	indic_SIYAQ_Numbers}', "");
    Error('\p{Block=/a/__inscriptional_Pahlavi}');
    Error('\P{Block=/a/__inscriptional_Pahlavi}');
    Expect(1, 68479, '\p{Block=:\AInscriptional_Pahlavi\z:}', "");;
    Expect(0, 68480, '\p{Block=:\AInscriptional_Pahlavi\z:}', "");;
    Expect(1, 68479, '\p{Block=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\p{^Block=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\P{Block=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\P{^Block=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\p{Block=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\p{^Block=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\P{Block=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\P{^Block=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\p{Block=:\Ainscriptionalpahlavi\z:}', "");;
    Expect(0, 68480, '\p{Block=:\Ainscriptionalpahlavi\z:}', "");;
    Expect(1, 68479, '\p{Block=	Inscriptional_pahlavi}', "");
    Expect(0, 68479, '\p{^Block=	Inscriptional_pahlavi}', "");
    Expect(0, 68479, '\P{Block=	Inscriptional_pahlavi}', "");
    Expect(1, 68479, '\P{^Block=	Inscriptional_pahlavi}', "");
    Expect(0, 68480, '\p{Block=	Inscriptional_pahlavi}', "");
    Expect(1, 68480, '\p{^Block=	Inscriptional_pahlavi}', "");
    Expect(1, 68480, '\P{Block=	Inscriptional_pahlavi}', "");
    Expect(0, 68480, '\P{^Block=	Inscriptional_pahlavi}', "");
    Error('\p{Blk=/a/ _INSCRIPTIONAL_Pahlavi}');
    Error('\P{Blk=/a/ _INSCRIPTIONAL_Pahlavi}');
    Expect(1, 68479, '\p{Blk=:\AInscriptional_Pahlavi\z:}', "");;
    Expect(0, 68480, '\p{Blk=:\AInscriptional_Pahlavi\z:}', "");;
    Expect(1, 68479, '\p{Blk=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\p{^Blk=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\P{Blk=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\P{^Blk=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\p{Blk=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\p{^Blk=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\P{Blk=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\P{^Blk=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\p{Blk=:\Ainscriptionalpahlavi\z:}', "");;
    Expect(0, 68480, '\p{Blk=:\Ainscriptionalpahlavi\z:}', "");;
    Expect(1, 68479, '\p{Blk=_	inscriptional_Pahlavi}', "");
    Expect(0, 68479, '\p{^Blk=_	inscriptional_Pahlavi}', "");
    Expect(0, 68479, '\P{Blk=_	inscriptional_Pahlavi}', "");
    Expect(1, 68479, '\P{^Blk=_	inscriptional_Pahlavi}', "");
    Expect(0, 68480, '\p{Blk=_	inscriptional_Pahlavi}', "");
    Expect(1, 68480, '\p{^Blk=_	inscriptional_Pahlavi}', "");
    Expect(1, 68480, '\P{Blk=_	inscriptional_Pahlavi}', "");
    Expect(0, 68480, '\P{^Blk=_	inscriptional_Pahlavi}', "");
    Error('\p{Is_Block= :=inscriptional_pahlavi}');
    Error('\P{Is_Block= :=inscriptional_pahlavi}');
    Expect(1, 68479, '\p{Is_Block=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\p{^Is_Block=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\P{Is_Block=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\P{^Is_Block=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\p{Is_Block=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\p{^Is_Block=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\P{Is_Block=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\P{^Is_Block=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\p{Is_Block=-Inscriptional_PAHLAVI}', "");
    Expect(0, 68479, '\p{^Is_Block=-Inscriptional_PAHLAVI}', "");
    Expect(0, 68479, '\P{Is_Block=-Inscriptional_PAHLAVI}', "");
    Expect(1, 68479, '\P{^Is_Block=-Inscriptional_PAHLAVI}', "");
    Expect(0, 68480, '\p{Is_Block=-Inscriptional_PAHLAVI}', "");
    Expect(1, 68480, '\p{^Is_Block=-Inscriptional_PAHLAVI}', "");
    Expect(1, 68480, '\P{Is_Block=-Inscriptional_PAHLAVI}', "");
    Expect(0, 68480, '\P{^Is_Block=-Inscriptional_PAHLAVI}', "");
    Error('\p{Is_Blk=_:=INSCRIPTIONAL_Pahlavi}');
    Error('\P{Is_Blk=_:=INSCRIPTIONAL_Pahlavi}');
    Expect(1, 68479, '\p{Is_Blk=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\p{^Is_Blk=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\P{Is_Blk=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\P{^Is_Blk=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\p{Is_Blk=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\p{^Is_Blk=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\P{Is_Blk=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\P{^Is_Blk=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\p{Is_Blk=--Inscriptional_PAHLAVI}', "");
    Expect(0, 68479, '\p{^Is_Blk=--Inscriptional_PAHLAVI}', "");
    Expect(0, 68479, '\P{Is_Blk=--Inscriptional_PAHLAVI}', "");
    Expect(1, 68479, '\P{^Is_Blk=--Inscriptional_PAHLAVI}', "");
    Expect(0, 68480, '\p{Is_Blk=--Inscriptional_PAHLAVI}', "");
    Expect(1, 68480, '\p{^Is_Blk=--Inscriptional_PAHLAVI}', "");
    Expect(1, 68480, '\P{Is_Blk=--Inscriptional_PAHLAVI}', "");
    Expect(0, 68480, '\P{^Is_Blk=--Inscriptional_PAHLAVI}', "");
    Error('\p{Block=	:=Inscriptional_parthian}');
    Error('\P{Block=	:=Inscriptional_parthian}');
    Expect(1, 68447, '\p{Block=:\AInscriptional_Parthian\z:}', "");;
    Expect(0, 68448, '\p{Block=:\AInscriptional_Parthian\z:}', "");;
    Expect(1, 68447, '\p{Block=inscriptionalparthian}', "");
    Expect(0, 68447, '\p{^Block=inscriptionalparthian}', "");
    Expect(0, 68447, '\P{Block=inscriptionalparthian}', "");
    Expect(1, 68447, '\P{^Block=inscriptionalparthian}', "");
    Expect(0, 68448, '\p{Block=inscriptionalparthian}', "");
    Expect(1, 68448, '\p{^Block=inscriptionalparthian}', "");
    Expect(1, 68448, '\P{Block=inscriptionalparthian}', "");
    Expect(0, 68448, '\P{^Block=inscriptionalparthian}', "");
    Expect(1, 68447, '\p{Block=:\Ainscriptionalparthian\z:}', "");;
    Expect(0, 68448, '\p{Block=:\Ainscriptionalparthian\z:}', "");;
    Expect(1, 68447, '\p{Block=_Inscriptional_PARTHIAN}', "");
    Expect(0, 68447, '\p{^Block=_Inscriptional_PARTHIAN}', "");
    Expect(0, 68447, '\P{Block=_Inscriptional_PARTHIAN}', "");
    Expect(1, 68447, '\P{^Block=_Inscriptional_PARTHIAN}', "");
    Expect(0, 68448, '\p{Block=_Inscriptional_PARTHIAN}', "");
    Expect(1, 68448, '\p{^Block=_Inscriptional_PARTHIAN}', "");
    Expect(1, 68448, '\P{Block=_Inscriptional_PARTHIAN}', "");
    Expect(0, 68448, '\P{^Block=_Inscriptional_PARTHIAN}', "");
    Error('\p{Blk= -Inscriptional_Parthian/a/}');
    Error('\P{Blk= -Inscriptional_Parthian/a/}');
    Expect(1, 68447, '\p{Blk=:\AInscriptional_Parthian\z:}', "");;
    Expect(0, 68448, '\p{Blk=:\AInscriptional_Parthian\z:}', "");;
    Expect(1, 68447, '\p{Blk=inscriptionalparthian}', "");
    Expect(0, 68447, '\p{^Blk=inscriptionalparthian}', "");
    Expect(0, 68447, '\P{Blk=inscriptionalparthian}', "");
    Expect(1, 68447, '\P{^Blk=inscriptionalparthian}', "");
    Expect(0, 68448, '\p{Blk=inscriptionalparthian}', "");
    Expect(1, 68448, '\p{^Blk=inscriptionalparthian}', "");
    Expect(1, 68448, '\P{Blk=inscriptionalparthian}', "");
    Expect(0, 68448, '\P{^Blk=inscriptionalparthian}', "");
    Expect(1, 68447, '\p{Blk=:\Ainscriptionalparthian\z:}', "");;
    Expect(0, 68448, '\p{Blk=:\Ainscriptionalparthian\z:}', "");;
    Expect(1, 68447, '\p{Blk= Inscriptional_parthian}', "");
    Expect(0, 68447, '\p{^Blk= Inscriptional_parthian}', "");
    Expect(0, 68447, '\P{Blk= Inscriptional_parthian}', "");
    Expect(1, 68447, '\P{^Blk= Inscriptional_parthian}', "");
    Expect(0, 68448, '\p{Blk= Inscriptional_parthian}', "");
    Expect(1, 68448, '\p{^Blk= Inscriptional_parthian}', "");
    Expect(1, 68448, '\P{Blk= Inscriptional_parthian}', "");
    Expect(0, 68448, '\P{^Blk= Inscriptional_parthian}', "");
    Error('\p{Is_Block=:= 	inscriptional_PARTHIAN}');
    Error('\P{Is_Block=:= 	inscriptional_PARTHIAN}');
    Expect(1, 68447, '\p{Is_Block=inscriptionalparthian}', "");
    Expect(0, 68447, '\p{^Is_Block=inscriptionalparthian}', "");
    Expect(0, 68447, '\P{Is_Block=inscriptionalparthian}', "");
    Expect(1, 68447, '\P{^Is_Block=inscriptionalparthian}', "");
    Expect(0, 68448, '\p{Is_Block=inscriptionalparthian}', "");
    Expect(1, 68448, '\p{^Is_Block=inscriptionalparthian}', "");
    Expect(1, 68448, '\P{Is_Block=inscriptionalparthian}', "");
    Expect(0, 68448, '\P{^Is_Block=inscriptionalparthian}', "");
    Expect(1, 68447, '\p{Is_Block=_Inscriptional_Parthian}', "");
    Expect(0, 68447, '\p{^Is_Block=_Inscriptional_Parthian}', "");
    Expect(0, 68447, '\P{Is_Block=_Inscriptional_Parthian}', "");
    Expect(1, 68447, '\P{^Is_Block=_Inscriptional_Parthian}', "");
    Expect(0, 68448, '\p{Is_Block=_Inscriptional_Parthian}', "");
    Expect(1, 68448, '\p{^Is_Block=_Inscriptional_Parthian}', "");
    Expect(1, 68448, '\P{Is_Block=_Inscriptional_Parthian}', "");
    Expect(0, 68448, '\P{^Is_Block=_Inscriptional_Parthian}', "");
    Error('\p{Is_Blk=/a/ -INSCRIPTIONAL_Parthian}');
    Error('\P{Is_Blk=/a/ -INSCRIPTIONAL_Parthian}');
    Expect(1, 68447, '\p{Is_Blk=inscriptionalparthian}', "");
    Expect(0, 68447, '\p{^Is_Blk=inscriptionalparthian}', "");
    Expect(0, 68447, '\P{Is_Blk=inscriptionalparthian}', "");
    Expect(1, 68447, '\P{^Is_Blk=inscriptionalparthian}', "");
    Expect(0, 68448, '\p{Is_Blk=inscriptionalparthian}', "");
    Expect(1, 68448, '\p{^Is_Blk=inscriptionalparthian}', "");
    Expect(1, 68448, '\P{Is_Blk=inscriptionalparthian}', "");
    Expect(0, 68448, '\P{^Is_Blk=inscriptionalparthian}', "");
    Expect(1, 68447, '\p{Is_Blk=	Inscriptional_Parthian}', "");
    Expect(0, 68447, '\p{^Is_Blk=	Inscriptional_Parthian}', "");
    Expect(0, 68447, '\P{Is_Blk=	Inscriptional_Parthian}', "");
    Expect(1, 68447, '\P{^Is_Blk=	Inscriptional_Parthian}', "");
    Expect(0, 68448, '\p{Is_Blk=	Inscriptional_Parthian}', "");
    Expect(1, 68448, '\p{^Is_Blk=	Inscriptional_Parthian}', "");
    Expect(1, 68448, '\P{Is_Blk=	Inscriptional_Parthian}', "");
    Expect(0, 68448, '\P{^Is_Blk=	Inscriptional_Parthian}', "");
    Error('\p{Block=-/a/IPA_EXTENSIONS}');
    Error('\P{Block=-/a/IPA_EXTENSIONS}');
    Expect(1, 687, '\p{Block=:\AIPA_Extensions\z:}', "");;
    Expect(0, 688, '\p{Block=:\AIPA_Extensions\z:}', "");;
    Expect(1, 687, '\p{Block: ipaextensions}', "");
    Expect(0, 687, '\p{^Block: ipaextensions}', "");
    Expect(0, 687, '\P{Block: ipaextensions}', "");
    Expect(1, 687, '\P{^Block: ipaextensions}', "");
    Expect(0, 688, '\p{Block: ipaextensions}', "");
    Expect(1, 688, '\p{^Block: ipaextensions}', "");
    Expect(1, 688, '\P{Block: ipaextensions}', "");
    Expect(0, 688, '\P{^Block: ipaextensions}', "");
    Expect(1, 687, '\p{Block=:\Aipaextensions\z:}', "");;
    Expect(0, 688, '\p{Block=:\Aipaextensions\z:}', "");;
    Expect(1, 687, '\p{Block=-IPA_EXTENSIONS}', "");
    Expect(0, 687, '\p{^Block=-IPA_EXTENSIONS}', "");
    Expect(0, 687, '\P{Block=-IPA_EXTENSIONS}', "");
    Expect(1, 687, '\P{^Block=-IPA_EXTENSIONS}', "");
    Expect(0, 688, '\p{Block=-IPA_EXTENSIONS}', "");
    Expect(1, 688, '\p{^Block=-IPA_EXTENSIONS}', "");
    Expect(1, 688, '\P{Block=-IPA_EXTENSIONS}', "");
    Expect(0, 688, '\P{^Block=-IPA_EXTENSIONS}', "");
    Error('\p{Blk=/a/		IPA_Ext}');
    Error('\P{Blk=/a/		IPA_Ext}');
    Expect(1, 687, '\p{Blk=:\AIPA_Ext\z:}', "");;
    Expect(0, 688, '\p{Blk=:\AIPA_Ext\z:}', "");;
    Expect(1, 687, '\p{Blk:	ipaext}', "");
    Expect(0, 687, '\p{^Blk:	ipaext}', "");
    Expect(0, 687, '\P{Blk:	ipaext}', "");
    Expect(1, 687, '\P{^Blk:	ipaext}', "");
    Expect(0, 688, '\p{Blk:	ipaext}', "");
    Expect(1, 688, '\p{^Blk:	ipaext}', "");
    Expect(1, 688, '\P{Blk:	ipaext}', "");
    Expect(0, 688, '\P{^Blk:	ipaext}', "");
    Expect(1, 687, '\p{Blk=:\Aipaext\z:}', "");;
    Expect(0, 688, '\p{Blk=:\Aipaext\z:}', "");;
    Expect(1, 687, '\p{Blk=ipa_ext}', "");
    Expect(0, 687, '\p{^Blk=ipa_ext}', "");
    Expect(0, 687, '\P{Blk=ipa_ext}', "");
    Expect(1, 687, '\P{^Blk=ipa_ext}', "");
    Expect(0, 688, '\p{Blk=ipa_ext}', "");
    Expect(1, 688, '\p{^Blk=ipa_ext}', "");
    Expect(1, 688, '\P{Blk=ipa_ext}', "");
    Expect(0, 688, '\P{^Blk=ipa_ext}', "");
    Error('\p{Is_Block=-/a/ipa_Extensions}');
    Error('\P{Is_Block=-/a/ipa_Extensions}');
    Expect(1, 687, '\p{Is_Block=ipaextensions}', "");
    Expect(0, 687, '\p{^Is_Block=ipaextensions}', "");
    Expect(0, 687, '\P{Is_Block=ipaextensions}', "");
    Expect(1, 687, '\P{^Is_Block=ipaextensions}', "");
    Expect(0, 688, '\p{Is_Block=ipaextensions}', "");
    Expect(1, 688, '\p{^Is_Block=ipaextensions}', "");
    Expect(1, 688, '\P{Is_Block=ipaextensions}', "");
    Expect(0, 688, '\P{^Is_Block=ipaextensions}', "");
    Expect(1, 687, '\p{Is_Block= _IPA_Extensions}', "");
    Expect(0, 687, '\p{^Is_Block= _IPA_Extensions}', "");
    Expect(0, 687, '\P{Is_Block= _IPA_Extensions}', "");
    Expect(1, 687, '\P{^Is_Block= _IPA_Extensions}', "");
    Expect(0, 688, '\p{Is_Block= _IPA_Extensions}', "");
    Expect(1, 688, '\p{^Is_Block= _IPA_Extensions}', "");
    Expect(1, 688, '\P{Is_Block= _IPA_Extensions}', "");
    Expect(0, 688, '\P{^Is_Block= _IPA_Extensions}', "");
    Error('\p{Is_Blk=/a/IPA_Ext}');
    Error('\P{Is_Blk=/a/IPA_Ext}');
    Expect(1, 687, '\p{Is_Blk=ipaext}', "");
    Expect(0, 687, '\p{^Is_Blk=ipaext}', "");
    Expect(0, 687, '\P{Is_Blk=ipaext}', "");
    Expect(1, 687, '\P{^Is_Blk=ipaext}', "");
    Expect(0, 688, '\p{Is_Blk=ipaext}', "");
    Expect(1, 688, '\p{^Is_Blk=ipaext}', "");
    Expect(1, 688, '\P{Is_Blk=ipaext}', "");
    Expect(0, 688, '\P{^Is_Blk=ipaext}', "");
    Expect(1, 687, '\p{Is_Blk=	IPA_EXT}', "");
    Expect(0, 687, '\p{^Is_Blk=	IPA_EXT}', "");
    Expect(0, 687, '\P{Is_Blk=	IPA_EXT}', "");
    Expect(1, 687, '\P{^Is_Blk=	IPA_EXT}', "");
    Expect(0, 688, '\p{Is_Blk=	IPA_EXT}', "");
    Expect(1, 688, '\p{^Is_Blk=	IPA_EXT}', "");
    Expect(1, 688, '\P{Is_Blk=	IPA_EXT}', "");
    Expect(0, 688, '\P{^Is_Blk=	IPA_EXT}', "");
    Error('\p{Block=:=-	Hangul_Jamo}');
    Error('\P{Block=:=-	Hangul_Jamo}');
    Expect(1, 4607, '\p{Block=:\AHangul_Jamo\z:}', "");;
    Expect(0, 4608, '\p{Block=:\AHangul_Jamo\z:}', "");;
    Expect(1, 4607, '\p{Block=hanguljamo}', "");
    Expect(0, 4607, '\p{^Block=hanguljamo}', "");
    Expect(0, 4607, '\P{Block=hanguljamo}', "");
    Expect(1, 4607, '\P{^Block=hanguljamo}', "");
    Expect(0, 4608, '\p{Block=hanguljamo}', "");
    Expect(1, 4608, '\p{^Block=hanguljamo}', "");
    Expect(1, 4608, '\P{Block=hanguljamo}', "");
    Expect(0, 4608, '\P{^Block=hanguljamo}', "");
    Expect(1, 4607, '\p{Block=:\Ahanguljamo\z:}', "");;
    Expect(0, 4608, '\p{Block=:\Ahanguljamo\z:}', "");;
    Expect(1, 4607, '\p{Block=-_Hangul_jamo}', "");
    Expect(0, 4607, '\p{^Block=-_Hangul_jamo}', "");
    Expect(0, 4607, '\P{Block=-_Hangul_jamo}', "");
    Expect(1, 4607, '\P{^Block=-_Hangul_jamo}', "");
    Expect(0, 4608, '\p{Block=-_Hangul_jamo}', "");
    Expect(1, 4608, '\p{^Block=-_Hangul_jamo}', "");
    Expect(1, 4608, '\P{Block=-_Hangul_jamo}', "");
    Expect(0, 4608, '\P{^Block=-_Hangul_jamo}', "");
    Error('\p{Blk=:=	jamo}');
    Error('\P{Blk=:=	jamo}');
    Expect(1, 4607, '\p{Blk=:\AJamo\z:}', "");;
    Expect(0, 4608, '\p{Blk=:\AJamo\z:}', "");;
    Expect(1, 4607, '\p{Blk=jamo}', "");
    Expect(0, 4607, '\p{^Blk=jamo}', "");
    Expect(0, 4607, '\P{Blk=jamo}', "");
    Expect(1, 4607, '\P{^Blk=jamo}', "");
    Expect(0, 4608, '\p{Blk=jamo}', "");
    Expect(1, 4608, '\p{^Blk=jamo}', "");
    Expect(1, 4608, '\P{Blk=jamo}', "");
    Expect(0, 4608, '\P{^Blk=jamo}', "");
    Expect(1, 4607, '\p{Blk=:\Ajamo\z:}', "");;
    Expect(0, 4608, '\p{Blk=:\Ajamo\z:}', "");;
    Expect(1, 4607, '\p{Blk=--JAMO}', "");
    Expect(0, 4607, '\p{^Blk=--JAMO}', "");
    Expect(0, 4607, '\P{Blk=--JAMO}', "");
    Expect(1, 4607, '\P{^Blk=--JAMO}', "");
    Expect(0, 4608, '\p{Blk=--JAMO}', "");
    Expect(1, 4608, '\p{^Blk=--JAMO}', "");
    Expect(1, 4608, '\P{Blk=--JAMO}', "");
    Expect(0, 4608, '\P{^Blk=--JAMO}', "");
    Error('\p{Is_Block=-:=HANGUL_Jamo}');
    Error('\P{Is_Block=-:=HANGUL_Jamo}');
    Expect(1, 4607, '\p{Is_Block=hanguljamo}', "");
    Expect(0, 4607, '\p{^Is_Block=hanguljamo}', "");
    Expect(0, 4607, '\P{Is_Block=hanguljamo}', "");
    Expect(1, 4607, '\P{^Is_Block=hanguljamo}', "");
    Expect(0, 4608, '\p{Is_Block=hanguljamo}', "");
    Expect(1, 4608, '\p{^Is_Block=hanguljamo}', "");
    Expect(1, 4608, '\P{Is_Block=hanguljamo}', "");
    Expect(0, 4608, '\P{^Is_Block=hanguljamo}', "");
    Expect(1, 4607, '\p{Is_Block=	 Hangul_JAMO}', "");
    Expect(0, 4607, '\p{^Is_Block=	 Hangul_JAMO}', "");
    Expect(0, 4607, '\P{Is_Block=	 Hangul_JAMO}', "");
    Expect(1, 4607, '\P{^Is_Block=	 Hangul_JAMO}', "");
    Expect(0, 4608, '\p{Is_Block=	 Hangul_JAMO}', "");
    Expect(1, 4608, '\p{^Is_Block=	 Hangul_JAMO}', "");
    Expect(1, 4608, '\P{Is_Block=	 Hangul_JAMO}', "");
    Expect(0, 4608, '\P{^Is_Block=	 Hangul_JAMO}', "");
    Error('\p{Is_Blk=_/a/jamo}');
    Error('\P{Is_Blk=_/a/jamo}');
    Expect(1, 4607, '\p{Is_Blk:   jamo}', "");
    Expect(0, 4607, '\p{^Is_Blk:   jamo}', "");
    Expect(0, 4607, '\P{Is_Blk:   jamo}', "");
    Expect(1, 4607, '\P{^Is_Blk:   jamo}', "");
    Expect(0, 4608, '\p{Is_Blk:   jamo}', "");
    Expect(1, 4608, '\p{^Is_Blk:   jamo}', "");
    Expect(1, 4608, '\P{Is_Blk:   jamo}', "");
    Expect(0, 4608, '\P{^Is_Blk:   jamo}', "");
    Expect(1, 4607, '\p{Is_Blk=-JAMO}', "");
    Expect(0, 4607, '\p{^Is_Blk=-JAMO}', "");
    Expect(0, 4607, '\P{Is_Blk=-JAMO}', "");
    Expect(1, 4607, '\P{^Is_Blk=-JAMO}', "");
    Expect(0, 4608, '\p{Is_Blk=-JAMO}', "");
    Expect(1, 4608, '\p{^Is_Blk=-JAMO}', "");
    Expect(1, 4608, '\P{Is_Blk=-JAMO}', "");
    Expect(0, 4608, '\P{^Is_Blk=-JAMO}', "");
    Error('\p{Block=:=Hangul_JAMO_extended_A}');
    Error('\P{Block=:=Hangul_JAMO_extended_A}');
    Expect(1, 43391, '\p{Block=:\AHangul_Jamo_Extended_A\z:}', "");;
    Expect(0, 43392, '\p{Block=:\AHangul_Jamo_Extended_A\z:}', "");;
    Expect(1, 43391, '\p{Block:	hanguljamoextendeda}', "");
    Expect(0, 43391, '\p{^Block:	hanguljamoextendeda}', "");
    Expect(0, 43391, '\P{Block:	hanguljamoextendeda}', "");
    Expect(1, 43391, '\P{^Block:	hanguljamoextendeda}', "");
    Expect(0, 43392, '\p{Block:	hanguljamoextendeda}', "");
    Expect(1, 43392, '\p{^Block:	hanguljamoextendeda}', "");
    Expect(1, 43392, '\P{Block:	hanguljamoextendeda}', "");
    Expect(0, 43392, '\P{^Block:	hanguljamoextendeda}', "");
    Expect(1, 43391, '\p{Block=:\Ahanguljamoextendeda\z:}', "");;
    Expect(0, 43392, '\p{Block=:\Ahanguljamoextendeda\z:}', "");;
    Expect(1, 43391, '\p{Block= _Hangul_Jamo_Extended_A}', "");
    Expect(0, 43391, '\p{^Block= _Hangul_Jamo_Extended_A}', "");
    Expect(0, 43391, '\P{Block= _Hangul_Jamo_Extended_A}', "");
    Expect(1, 43391, '\P{^Block= _Hangul_Jamo_Extended_A}', "");
    Expect(0, 43392, '\p{Block= _Hangul_Jamo_Extended_A}', "");
    Expect(1, 43392, '\p{^Block= _Hangul_Jamo_Extended_A}', "");
    Expect(1, 43392, '\P{Block= _Hangul_Jamo_Extended_A}', "");
    Expect(0, 43392, '\P{^Block= _Hangul_Jamo_Extended_A}', "");
    Error('\p{Blk= /a/Jamo_Ext_a}');
    Error('\P{Blk= /a/Jamo_Ext_a}');
    Expect(1, 43391, '\p{Blk=:\AJamo_Ext_A\z:}', "");;
    Expect(0, 43392, '\p{Blk=:\AJamo_Ext_A\z:}', "");;
    Expect(1, 43391, '\p{Blk=jamoexta}', "");
    Expect(0, 43391, '\p{^Blk=jamoexta}', "");
    Expect(0, 43391, '\P{Blk=jamoexta}', "");
    Expect(1, 43391, '\P{^Blk=jamoexta}', "");
    Expect(0, 43392, '\p{Blk=jamoexta}', "");
    Expect(1, 43392, '\p{^Blk=jamoexta}', "");
    Expect(1, 43392, '\P{Blk=jamoexta}', "");
    Expect(0, 43392, '\P{^Blk=jamoexta}', "");
    Expect(1, 43391, '\p{Blk=:\Ajamoexta\z:}', "");;
    Expect(0, 43392, '\p{Blk=:\Ajamoexta\z:}', "");;
    Expect(1, 43391, '\p{Blk=	_JAMO_EXT_A}', "");
    Expect(0, 43391, '\p{^Blk=	_JAMO_EXT_A}', "");
    Expect(0, 43391, '\P{Blk=	_JAMO_EXT_A}', "");
    Expect(1, 43391, '\P{^Blk=	_JAMO_EXT_A}', "");
    Expect(0, 43392, '\p{Blk=	_JAMO_EXT_A}', "");
    Expect(1, 43392, '\p{^Blk=	_JAMO_EXT_A}', "");
    Expect(1, 43392, '\P{Blk=	_JAMO_EXT_A}', "");
    Expect(0, 43392, '\P{^Blk=	_JAMO_EXT_A}', "");
    Error('\p{Is_Block=  Hangul_jamo_Extended_A/a/}');
    Error('\P{Is_Block=  Hangul_jamo_Extended_A/a/}');
    Expect(1, 43391, '\p{Is_Block=hanguljamoextendeda}', "");
    Expect(0, 43391, '\p{^Is_Block=hanguljamoextendeda}', "");
    Expect(0, 43391, '\P{Is_Block=hanguljamoextendeda}', "");
    Expect(1, 43391, '\P{^Is_Block=hanguljamoextendeda}', "");
    Expect(0, 43392, '\p{Is_Block=hanguljamoextendeda}', "");
    Expect(1, 43392, '\p{^Is_Block=hanguljamoextendeda}', "");
    Expect(1, 43392, '\P{Is_Block=hanguljamoextendeda}', "");
    Expect(0, 43392, '\P{^Is_Block=hanguljamoextendeda}', "");
    Expect(1, 43391, '\p{Is_Block= -HANGUL_JAMO_Extended_a}', "");
    Expect(0, 43391, '\p{^Is_Block= -HANGUL_JAMO_Extended_a}', "");
    Expect(0, 43391, '\P{Is_Block= -HANGUL_JAMO_Extended_a}', "");
    Expect(1, 43391, '\P{^Is_Block= -HANGUL_JAMO_Extended_a}', "");
    Expect(0, 43392, '\p{Is_Block= -HANGUL_JAMO_Extended_a}', "");
    Expect(1, 43392, '\p{^Is_Block= -HANGUL_JAMO_Extended_a}', "");
    Expect(1, 43392, '\P{Is_Block= -HANGUL_JAMO_Extended_a}', "");
    Expect(0, 43392, '\P{^Is_Block= -HANGUL_JAMO_Extended_a}', "");
    Error('\p{Is_Blk=-_Jamo_ext_A:=}');
    Error('\P{Is_Blk=-_Jamo_ext_A:=}');
    Expect(1, 43391, '\p{Is_Blk:	jamoexta}', "");
    Expect(0, 43391, '\p{^Is_Blk:	jamoexta}', "");
    Expect(0, 43391, '\P{Is_Blk:	jamoexta}', "");
    Expect(1, 43391, '\P{^Is_Blk:	jamoexta}', "");
    Expect(0, 43392, '\p{Is_Blk:	jamoexta}', "");
    Expect(1, 43392, '\p{^Is_Blk:	jamoexta}', "");
    Expect(1, 43392, '\P{Is_Blk:	jamoexta}', "");
    Expect(0, 43392, '\P{^Is_Blk:	jamoexta}', "");
    Expect(1, 43391, '\p{Is_Blk= -Jamo_Ext_a}', "");
    Expect(0, 43391, '\p{^Is_Blk= -Jamo_Ext_a}', "");
    Expect(0, 43391, '\P{Is_Blk= -Jamo_Ext_a}', "");
    Expect(1, 43391, '\P{^Is_Blk= -Jamo_Ext_a}', "");
    Expect(0, 43392, '\p{Is_Blk= -Jamo_Ext_a}', "");
    Expect(1, 43392, '\p{^Is_Blk= -Jamo_Ext_a}', "");
    Expect(1, 43392, '\P{Is_Blk= -Jamo_Ext_a}', "");
    Expect(0, 43392, '\P{^Is_Blk= -Jamo_Ext_a}', "");
    Error('\p{Block=_-Hangul_jamo_extended_b:=}');
    Error('\P{Block=_-Hangul_jamo_extended_b:=}');
    Expect(1, 55295, '\p{Block=:\AHangul_Jamo_Extended_B\z:}', "");;
    Expect(0, 57344, '\p{Block=:\AHangul_Jamo_Extended_B\z:}', "");;
    Expect(1, 55295, '\p{Block=hanguljamoextendedb}', "");
    Expect(0, 55295, '\p{^Block=hanguljamoextendedb}', "");
    Expect(0, 55295, '\P{Block=hanguljamoextendedb}', "");
    Expect(1, 55295, '\P{^Block=hanguljamoextendedb}', "");
    Expect(0, 57344, '\p{Block=hanguljamoextendedb}', "");
    Expect(1, 57344, '\p{^Block=hanguljamoextendedb}', "");
    Expect(1, 57344, '\P{Block=hanguljamoextendedb}', "");
    Expect(0, 57344, '\P{^Block=hanguljamoextendedb}', "");
    Expect(1, 55295, '\p{Block=:\Ahanguljamoextendedb\z:}', "");;
    Expect(0, 57344, '\p{Block=:\Ahanguljamoextendedb\z:}', "");;
    Expect(1, 55295, '\p{Block=	-HANGUL_Jamo_Extended_B}', "");
    Expect(0, 55295, '\p{^Block=	-HANGUL_Jamo_Extended_B}', "");
    Expect(0, 55295, '\P{Block=	-HANGUL_Jamo_Extended_B}', "");
    Expect(1, 55295, '\P{^Block=	-HANGUL_Jamo_Extended_B}', "");
    Expect(0, 57344, '\p{Block=	-HANGUL_Jamo_Extended_B}', "");
    Expect(1, 57344, '\p{^Block=	-HANGUL_Jamo_Extended_B}', "");
    Expect(1, 57344, '\P{Block=	-HANGUL_Jamo_Extended_B}', "");
    Expect(0, 57344, '\P{^Block=	-HANGUL_Jamo_Extended_B}', "");
    Error('\p{Blk= _Jamo_EXT_B/a/}');
    Error('\P{Blk= _Jamo_EXT_B/a/}');
    Expect(1, 55295, '\p{Blk=:\AJamo_Ext_B\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\AJamo_Ext_B\z:}', "");;
    Expect(1, 55295, '\p{Blk=jamoextb}', "");
    Expect(0, 55295, '\p{^Blk=jamoextb}', "");
    Expect(0, 55295, '\P{Blk=jamoextb}', "");
    Expect(1, 55295, '\P{^Blk=jamoextb}', "");
    Expect(0, 57344, '\p{Blk=jamoextb}', "");
    Expect(1, 57344, '\p{^Blk=jamoextb}', "");
    Expect(1, 57344, '\P{Blk=jamoextb}', "");
    Expect(0, 57344, '\P{^Blk=jamoextb}', "");
    Expect(1, 55295, '\p{Blk=:\Ajamoextb\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\Ajamoextb\z:}', "");;
    Expect(1, 55295, '\p{Blk=-_Jamo_EXT_B}', "");
    Expect(0, 55295, '\p{^Blk=-_Jamo_EXT_B}', "");
    Expect(0, 55295, '\P{Blk=-_Jamo_EXT_B}', "");
    Expect(1, 55295, '\P{^Blk=-_Jamo_EXT_B}', "");
    Expect(0, 57344, '\p{Blk=-_Jamo_EXT_B}', "");
    Expect(1, 57344, '\p{^Blk=-_Jamo_EXT_B}', "");
    Expect(1, 57344, '\P{Blk=-_Jamo_EXT_B}', "");
    Expect(0, 57344, '\P{^Blk=-_Jamo_EXT_B}', "");
    Error('\p{Is_Block=_-HANGUL_JAMO_extended_B/a/}');
    Error('\P{Is_Block=_-HANGUL_JAMO_extended_B/a/}');
    Expect(1, 55295, '\p{Is_Block: hanguljamoextendedb}', "");
    Expect(0, 55295, '\p{^Is_Block: hanguljamoextendedb}', "");
    Expect(0, 55295, '\P{Is_Block: hanguljamoextendedb}', "");
    Expect(1, 55295, '\P{^Is_Block: hanguljamoextendedb}', "");
    Expect(0, 57344, '\p{Is_Block: hanguljamoextendedb}', "");
    Expect(1, 57344, '\p{^Is_Block: hanguljamoextendedb}', "");
    Expect(1, 57344, '\P{Is_Block: hanguljamoextendedb}', "");
    Expect(0, 57344, '\P{^Is_Block: hanguljamoextendedb}', "");
    Expect(1, 55295, '\p{Is_Block=hangul_Jamo_Extended_B}', "");
    Expect(0, 55295, '\p{^Is_Block=hangul_Jamo_Extended_B}', "");
    Expect(0, 55295, '\P{Is_Block=hangul_Jamo_Extended_B}', "");
    Expect(1, 55295, '\P{^Is_Block=hangul_Jamo_Extended_B}', "");
    Expect(0, 57344, '\p{Is_Block=hangul_Jamo_Extended_B}', "");
    Expect(1, 57344, '\p{^Is_Block=hangul_Jamo_Extended_B}', "");
    Expect(1, 57344, '\P{Is_Block=hangul_Jamo_Extended_B}', "");
    Expect(0, 57344, '\P{^Is_Block=hangul_Jamo_Extended_B}', "");
    Error('\p{Is_Blk=_Jamo_Ext_B/a/}');
    Error('\P{Is_Blk=_Jamo_Ext_B/a/}');
    Expect(1, 55295, '\p{Is_Blk=jamoextb}', "");
    Expect(0, 55295, '\p{^Is_Blk=jamoextb}', "");
    Expect(0, 55295, '\P{Is_Blk=jamoextb}', "");
    Expect(1, 55295, '\P{^Is_Blk=jamoextb}', "");
    Expect(0, 57344, '\p{Is_Blk=jamoextb}', "");
    Expect(1, 57344, '\p{^Is_Blk=jamoextb}', "");
    Expect(1, 57344, '\P{Is_Blk=jamoextb}', "");
    Expect(0, 57344, '\P{^Is_Blk=jamoextb}', "");
    Expect(1, 55295, '\p{Is_Blk= JAMO_Ext_b}', "");
    Expect(0, 55295, '\p{^Is_Blk= JAMO_Ext_b}', "");
    Expect(0, 55295, '\P{Is_Blk= JAMO_Ext_b}', "");
    Expect(1, 55295, '\P{^Is_Blk= JAMO_Ext_b}', "");
    Expect(0, 57344, '\p{Is_Blk= JAMO_Ext_b}', "");
    Expect(1, 57344, '\p{^Is_Blk= JAMO_Ext_b}', "");
    Expect(1, 57344, '\P{Is_Blk= JAMO_Ext_b}', "");
    Expect(0, 57344, '\P{^Is_Blk= JAMO_Ext_b}', "");
    Error('\p{Block=/a/-Javanese}');
    Error('\P{Block=/a/-Javanese}');
    Expect(1, 43487, '\p{Block=:\AJavanese\z:}', "");;
    Expect(0, 43488, '\p{Block=:\AJavanese\z:}', "");;
    Expect(1, 43487, '\p{Block=javanese}', "");
    Expect(0, 43487, '\p{^Block=javanese}', "");
    Expect(0, 43487, '\P{Block=javanese}', "");
    Expect(1, 43487, '\P{^Block=javanese}', "");
    Expect(0, 43488, '\p{Block=javanese}', "");
    Expect(1, 43488, '\p{^Block=javanese}', "");
    Expect(1, 43488, '\P{Block=javanese}', "");
    Expect(0, 43488, '\P{^Block=javanese}', "");
    Expect(1, 43487, '\p{Block=:\Ajavanese\z:}', "");;
    Expect(0, 43488, '\p{Block=:\Ajavanese\z:}', "");;
    Expect(1, 43487, '\p{Block:		_Javanese}', "");
    Expect(0, 43487, '\p{^Block:		_Javanese}', "");
    Expect(0, 43487, '\P{Block:		_Javanese}', "");
    Expect(1, 43487, '\P{^Block:		_Javanese}', "");
    Expect(0, 43488, '\p{Block:		_Javanese}', "");
    Expect(1, 43488, '\p{^Block:		_Javanese}', "");
    Expect(1, 43488, '\P{Block:		_Javanese}', "");
    Expect(0, 43488, '\P{^Block:		_Javanese}', "");
    Error('\p{Blk=_/a/Javanese}');
    Error('\P{Blk=_/a/Javanese}');
    Expect(1, 43487, '\p{Blk=:\AJavanese\z:}', "");;
    Expect(0, 43488, '\p{Blk=:\AJavanese\z:}', "");;
    Expect(1, 43487, '\p{Blk=javanese}', "");
    Expect(0, 43487, '\p{^Blk=javanese}', "");
    Expect(0, 43487, '\P{Blk=javanese}', "");
    Expect(1, 43487, '\P{^Blk=javanese}', "");
    Expect(0, 43488, '\p{Blk=javanese}', "");
    Expect(1, 43488, '\p{^Blk=javanese}', "");
    Expect(1, 43488, '\P{Blk=javanese}', "");
    Expect(0, 43488, '\P{^Blk=javanese}', "");
    Expect(1, 43487, '\p{Blk=:\Ajavanese\z:}', "");;
    Expect(0, 43488, '\p{Blk=:\Ajavanese\z:}', "");;
    Expect(1, 43487, '\p{Blk=	Javanese}', "");
    Expect(0, 43487, '\p{^Blk=	Javanese}', "");
    Expect(0, 43487, '\P{Blk=	Javanese}', "");
    Expect(1, 43487, '\P{^Blk=	Javanese}', "");
    Expect(0, 43488, '\p{Blk=	Javanese}', "");
    Expect(1, 43488, '\p{^Blk=	Javanese}', "");
    Expect(1, 43488, '\P{Blk=	Javanese}', "");
    Expect(0, 43488, '\P{^Blk=	Javanese}', "");
    Error('\p{Is_Block=_	Javanese/a/}');
    Error('\P{Is_Block=_	Javanese/a/}');
    Expect(1, 43487, '\p{Is_Block=javanese}', "");
    Expect(0, 43487, '\p{^Is_Block=javanese}', "");
    Expect(0, 43487, '\P{Is_Block=javanese}', "");
    Expect(1, 43487, '\P{^Is_Block=javanese}', "");
    Expect(0, 43488, '\p{Is_Block=javanese}', "");
    Expect(1, 43488, '\p{^Is_Block=javanese}', "");
    Expect(1, 43488, '\P{Is_Block=javanese}', "");
    Expect(0, 43488, '\P{^Is_Block=javanese}', "");
    Expect(1, 43487, '\p{Is_Block: _JAVANESE}', "");
    Expect(0, 43487, '\p{^Is_Block: _JAVANESE}', "");
    Expect(0, 43487, '\P{Is_Block: _JAVANESE}', "");
    Expect(1, 43487, '\P{^Is_Block: _JAVANESE}', "");
    Expect(0, 43488, '\p{Is_Block: _JAVANESE}', "");
    Expect(1, 43488, '\p{^Is_Block: _JAVANESE}', "");
    Expect(1, 43488, '\P{Is_Block: _JAVANESE}', "");
    Expect(0, 43488, '\P{^Is_Block: _JAVANESE}', "");
    Error('\p{Is_Blk= 	Javanese/a/}');
    Error('\P{Is_Blk= 	Javanese/a/}');
    Expect(1, 43487, '\p{Is_Blk=javanese}', "");
    Expect(0, 43487, '\p{^Is_Blk=javanese}', "");
    Expect(0, 43487, '\P{Is_Blk=javanese}', "");
    Expect(1, 43487, '\P{^Is_Blk=javanese}', "");
    Expect(0, 43488, '\p{Is_Blk=javanese}', "");
    Expect(1, 43488, '\p{^Is_Blk=javanese}', "");
    Expect(1, 43488, '\P{Is_Blk=javanese}', "");
    Expect(0, 43488, '\P{^Is_Blk=javanese}', "");
    Expect(1, 43487, '\p{Is_Blk=  JAVANESE}', "");
    Expect(0, 43487, '\p{^Is_Blk=  JAVANESE}', "");
    Expect(0, 43487, '\P{Is_Blk=  JAVANESE}', "");
    Expect(1, 43487, '\P{^Is_Blk=  JAVANESE}', "");
    Expect(0, 43488, '\p{Is_Blk=  JAVANESE}', "");
    Expect(1, 43488, '\p{^Is_Blk=  JAVANESE}', "");
    Expect(1, 43488, '\P{Is_Blk=  JAVANESE}', "");
    Expect(0, 43488, '\P{^Is_Blk=  JAVANESE}', "");
    Error('\p{Block=/a/_Kaithi}');
    Error('\P{Block=/a/_Kaithi}');
    Expect(1, 69839, '\p{Block=:\AKaithi\z:}', "");;
    Expect(0, 69840, '\p{Block=:\AKaithi\z:}', "");;
    Expect(1, 69839, '\p{Block=kaithi}', "");
    Expect(0, 69839, '\p{^Block=kaithi}', "");
    Expect(0, 69839, '\P{Block=kaithi}', "");
    Expect(1, 69839, '\P{^Block=kaithi}', "");
    Expect(0, 69840, '\p{Block=kaithi}', "");
    Expect(1, 69840, '\p{^Block=kaithi}', "");
    Expect(1, 69840, '\P{Block=kaithi}', "");
    Expect(0, 69840, '\P{^Block=kaithi}', "");
    Expect(1, 69839, '\p{Block=:\Akaithi\z:}', "");;
    Expect(0, 69840, '\p{Block=:\Akaithi\z:}', "");;
    Expect(1, 69839, '\p{Block=_ Kaithi}', "");
    Expect(0, 69839, '\p{^Block=_ Kaithi}', "");
    Expect(0, 69839, '\P{Block=_ Kaithi}', "");
    Expect(1, 69839, '\P{^Block=_ Kaithi}', "");
    Expect(0, 69840, '\p{Block=_ Kaithi}', "");
    Expect(1, 69840, '\p{^Block=_ Kaithi}', "");
    Expect(1, 69840, '\P{Block=_ Kaithi}', "");
    Expect(0, 69840, '\P{^Block=_ Kaithi}', "");
    Error('\p{Blk=:=_	kaithi}');
    Error('\P{Blk=:=_	kaithi}');
    Expect(1, 69839, '\p{Blk=:\AKaithi\z:}', "");;
    Expect(0, 69840, '\p{Blk=:\AKaithi\z:}', "");;
    Expect(1, 69839, '\p{Blk=kaithi}', "");
    Expect(0, 69839, '\p{^Blk=kaithi}', "");
    Expect(0, 69839, '\P{Blk=kaithi}', "");
    Expect(1, 69839, '\P{^Blk=kaithi}', "");
    Expect(0, 69840, '\p{Blk=kaithi}', "");
    Expect(1, 69840, '\p{^Blk=kaithi}', "");
    Expect(1, 69840, '\P{Blk=kaithi}', "");
    Expect(0, 69840, '\P{^Blk=kaithi}', "");
    Expect(1, 69839, '\p{Blk=:\Akaithi\z:}', "");;
    Expect(0, 69840, '\p{Blk=:\Akaithi\z:}', "");;
    Expect(1, 69839, '\p{Blk=-kaithi}', "");
    Expect(0, 69839, '\p{^Blk=-kaithi}', "");
    Expect(0, 69839, '\P{Blk=-kaithi}', "");
    Expect(1, 69839, '\P{^Blk=-kaithi}', "");
    Expect(0, 69840, '\p{Blk=-kaithi}', "");
    Expect(1, 69840, '\p{^Blk=-kaithi}', "");
    Expect(1, 69840, '\P{Blk=-kaithi}', "");
    Expect(0, 69840, '\P{^Blk=-kaithi}', "");
    Error('\p{Is_Block=/a/KAITHI}');
    Error('\P{Is_Block=/a/KAITHI}');
    Expect(1, 69839, '\p{Is_Block=kaithi}', "");
    Expect(0, 69839, '\p{^Is_Block=kaithi}', "");
    Expect(0, 69839, '\P{Is_Block=kaithi}', "");
    Expect(1, 69839, '\P{^Is_Block=kaithi}', "");
    Expect(0, 69840, '\p{Is_Block=kaithi}', "");
    Expect(1, 69840, '\p{^Is_Block=kaithi}', "");
    Expect(1, 69840, '\P{Is_Block=kaithi}', "");
    Expect(0, 69840, '\P{^Is_Block=kaithi}', "");
    Expect(1, 69839, '\p{Is_Block=	-Kaithi}', "");
    Expect(0, 69839, '\p{^Is_Block=	-Kaithi}', "");
    Expect(0, 69839, '\P{Is_Block=	-Kaithi}', "");
    Expect(1, 69839, '\P{^Is_Block=	-Kaithi}', "");
    Expect(0, 69840, '\p{Is_Block=	-Kaithi}', "");
    Expect(1, 69840, '\p{^Is_Block=	-Kaithi}', "");
    Expect(1, 69840, '\P{Is_Block=	-Kaithi}', "");
    Expect(0, 69840, '\P{^Is_Block=	-Kaithi}', "");
    Error('\p{Is_Blk=:=--Kaithi}');
    Error('\P{Is_Blk=:=--Kaithi}');
    Expect(1, 69839, '\p{Is_Blk=kaithi}', "");
    Expect(0, 69839, '\p{^Is_Blk=kaithi}', "");
    Expect(0, 69839, '\P{Is_Blk=kaithi}', "");
    Expect(1, 69839, '\P{^Is_Blk=kaithi}', "");
    Expect(0, 69840, '\p{Is_Blk=kaithi}', "");
    Expect(1, 69840, '\p{^Is_Blk=kaithi}', "");
    Expect(1, 69840, '\P{Is_Blk=kaithi}', "");
    Expect(0, 69840, '\P{^Is_Blk=kaithi}', "");
    Expect(1, 69839, '\p{Is_Blk=- KAITHI}', "");
    Expect(0, 69839, '\p{^Is_Blk=- KAITHI}', "");
    Expect(0, 69839, '\P{Is_Blk=- KAITHI}', "");
    Expect(1, 69839, '\P{^Is_Blk=- KAITHI}', "");
    Expect(0, 69840, '\p{Is_Blk=- KAITHI}', "");
    Expect(1, 69840, '\p{^Is_Blk=- KAITHI}', "");
    Expect(1, 69840, '\P{Is_Blk=- KAITHI}', "");
    Expect(0, 69840, '\P{^Is_Blk=- KAITHI}', "");
    Error('\p{Block=_Kaktovik_Numerals/a/}');
    Error('\P{Block=_Kaktovik_Numerals/a/}');
    Expect(1, 119519, '\p{Block=:\AKaktovik_Numerals\z:}', "");;
    Expect(0, 119520, '\p{Block=:\AKaktovik_Numerals\z:}', "");;
    Expect(1, 119519, '\p{Block=kaktoviknumerals}', "");
    Expect(0, 119519, '\p{^Block=kaktoviknumerals}', "");
    Expect(0, 119519, '\P{Block=kaktoviknumerals}', "");
    Expect(1, 119519, '\P{^Block=kaktoviknumerals}', "");
    Expect(0, 119520, '\p{Block=kaktoviknumerals}', "");
    Expect(1, 119520, '\p{^Block=kaktoviknumerals}', "");
    Expect(1, 119520, '\P{Block=kaktoviknumerals}', "");
    Expect(0, 119520, '\P{^Block=kaktoviknumerals}', "");
    Expect(1, 119519, '\p{Block=:\Akaktoviknumerals\z:}', "");;
    Expect(0, 119520, '\p{Block=:\Akaktoviknumerals\z:}', "");;
    Expect(1, 119519, '\p{Block=_-kaktovik_Numerals}', "");
    Expect(0, 119519, '\p{^Block=_-kaktovik_Numerals}', "");
    Expect(0, 119519, '\P{Block=_-kaktovik_Numerals}', "");
    Expect(1, 119519, '\P{^Block=_-kaktovik_Numerals}', "");
    Expect(0, 119520, '\p{Block=_-kaktovik_Numerals}', "");
    Expect(1, 119520, '\p{^Block=_-kaktovik_Numerals}', "");
    Expect(1, 119520, '\P{Block=_-kaktovik_Numerals}', "");
    Expect(0, 119520, '\P{^Block=_-kaktovik_Numerals}', "");
    Error('\p{Blk=/a/KAKTOVIK_NUMERALS}');
    Error('\P{Blk=/a/KAKTOVIK_NUMERALS}');
    Expect(1, 119519, '\p{Blk=:\AKaktovik_Numerals\z:}', "");;
    Expect(0, 119520, '\p{Blk=:\AKaktovik_Numerals\z:}', "");;
    Expect(1, 119519, '\p{Blk=kaktoviknumerals}', "");
    Expect(0, 119519, '\p{^Blk=kaktoviknumerals}', "");
    Expect(0, 119519, '\P{Blk=kaktoviknumerals}', "");
    Expect(1, 119519, '\P{^Blk=kaktoviknumerals}', "");
    Expect(0, 119520, '\p{Blk=kaktoviknumerals}', "");
    Expect(1, 119520, '\p{^Blk=kaktoviknumerals}', "");
    Expect(1, 119520, '\P{Blk=kaktoviknumerals}', "");
    Expect(0, 119520, '\P{^Blk=kaktoviknumerals}', "");
    Expect(1, 119519, '\p{Blk=:\Akaktoviknumerals\z:}', "");;
    Expect(0, 119520, '\p{Blk=:\Akaktoviknumerals\z:}', "");;
    Expect(1, 119519, '\p{Blk=_	kaktovik_Numerals}', "");
    Expect(0, 119519, '\p{^Blk=_	kaktovik_Numerals}', "");
    Expect(0, 119519, '\P{Blk=_	kaktovik_Numerals}', "");
    Expect(1, 119519, '\P{^Blk=_	kaktovik_Numerals}', "");
    Expect(0, 119520, '\p{Blk=_	kaktovik_Numerals}', "");
    Expect(1, 119520, '\p{^Blk=_	kaktovik_Numerals}', "");
    Expect(1, 119520, '\P{Blk=_	kaktovik_Numerals}', "");
    Expect(0, 119520, '\P{^Blk=_	kaktovik_Numerals}', "");
    Error('\p{Is_Block=  kaktovik_Numerals:=}');
    Error('\P{Is_Block=  kaktovik_Numerals:=}');
    Expect(1, 119519, '\p{Is_Block=kaktoviknumerals}', "");
    Expect(0, 119519, '\p{^Is_Block=kaktoviknumerals}', "");
    Expect(0, 119519, '\P{Is_Block=kaktoviknumerals}', "");
    Expect(1, 119519, '\P{^Is_Block=kaktoviknumerals}', "");
    Expect(0, 119520, '\p{Is_Block=kaktoviknumerals}', "");
    Expect(1, 119520, '\p{^Is_Block=kaktoviknumerals}', "");
    Expect(1, 119520, '\P{Is_Block=kaktoviknumerals}', "");
    Expect(0, 119520, '\P{^Is_Block=kaktoviknumerals}', "");
    Expect(1, 119519, '\p{Is_Block=		kaktovik_NUMERALS}', "");
    Expect(0, 119519, '\p{^Is_Block=		kaktovik_NUMERALS}', "");
    Expect(0, 119519, '\P{Is_Block=		kaktovik_NUMERALS}', "");
    Expect(1, 119519, '\P{^Is_Block=		kaktovik_NUMERALS}', "");
    Expect(0, 119520, '\p{Is_Block=		kaktovik_NUMERALS}', "");
    Expect(1, 119520, '\p{^Is_Block=		kaktovik_NUMERALS}', "");
    Expect(1, 119520, '\P{Is_Block=		kaktovik_NUMERALS}', "");
    Expect(0, 119520, '\P{^Is_Block=		kaktovik_NUMERALS}', "");
    Error('\p{Is_Blk=-Kaktovik_Numerals:=}');
    Error('\P{Is_Blk=-Kaktovik_Numerals:=}');
    Expect(1, 119519, '\p{Is_Blk=kaktoviknumerals}', "");
    Expect(0, 119519, '\p{^Is_Blk=kaktoviknumerals}', "");
    Expect(0, 119519, '\P{Is_Blk=kaktoviknumerals}', "");
    Expect(1, 119519, '\P{^Is_Blk=kaktoviknumerals}', "");
    Expect(0, 119520, '\p{Is_Blk=kaktoviknumerals}', "");
    Expect(1, 119520, '\p{^Is_Blk=kaktoviknumerals}', "");
    Expect(1, 119520, '\P{Is_Blk=kaktoviknumerals}', "");
    Expect(0, 119520, '\P{^Is_Blk=kaktoviknumerals}', "");
    Expect(1, 119519, '\p{Is_Blk=__Kaktovik_Numerals}', "");
    Expect(0, 119519, '\p{^Is_Blk=__Kaktovik_Numerals}', "");
    Expect(0, 119519, '\P{Is_Blk=__Kaktovik_Numerals}', "");
    Expect(1, 119519, '\P{^Is_Blk=__Kaktovik_Numerals}', "");
    Expect(0, 119520, '\p{Is_Blk=__Kaktovik_Numerals}', "");
    Expect(1, 119520, '\p{^Is_Blk=__Kaktovik_Numerals}', "");
    Expect(1, 119520, '\P{Is_Blk=__Kaktovik_Numerals}', "");
    Expect(0, 119520, '\P{^Is_Blk=__Kaktovik_Numerals}', "");
    Error('\p{Block= _kana_EXTENDED_A:=}');
    Error('\P{Block= _kana_EXTENDED_A:=}');
    Expect(1, 110895, '\p{Block=:\AKana_Extended_A\z:}', "");;
    Expect(0, 110896, '\p{Block=:\AKana_Extended_A\z:}', "");;
    Expect(1, 110895, '\p{Block=kanaextendeda}', "");
    Expect(0, 110895, '\p{^Block=kanaextendeda}', "");
    Expect(0, 110895, '\P{Block=kanaextendeda}', "");
    Expect(1, 110895, '\P{^Block=kanaextendeda}', "");
    Expect(0, 110896, '\p{Block=kanaextendeda}', "");
    Expect(1, 110896, '\p{^Block=kanaextendeda}', "");
    Expect(1, 110896, '\P{Block=kanaextendeda}', "");
    Expect(0, 110896, '\P{^Block=kanaextendeda}', "");
    Expect(1, 110895, '\p{Block=:\Akanaextendeda\z:}', "");;
    Expect(0, 110896, '\p{Block=:\Akanaextendeda\z:}', "");;
    Expect(1, 110895, '\p{Block= 	Kana_EXTENDED_A}', "");
    Expect(0, 110895, '\p{^Block= 	Kana_EXTENDED_A}', "");
    Expect(0, 110895, '\P{Block= 	Kana_EXTENDED_A}', "");
    Expect(1, 110895, '\P{^Block= 	Kana_EXTENDED_A}', "");
    Expect(0, 110896, '\p{Block= 	Kana_EXTENDED_A}', "");
    Expect(1, 110896, '\p{^Block= 	Kana_EXTENDED_A}', "");
    Expect(1, 110896, '\P{Block= 	Kana_EXTENDED_A}', "");
    Expect(0, 110896, '\P{^Block= 	Kana_EXTENDED_A}', "");
    Error('\p{Blk=	:=kana_Ext_A}');
    Error('\P{Blk=	:=kana_Ext_A}');
    Expect(1, 110895, '\p{Blk=:\AKana_Ext_A\z:}', "");;
    Expect(0, 110896, '\p{Blk=:\AKana_Ext_A\z:}', "");;
    Expect(1, 110895, '\p{Blk=kanaexta}', "");
    Expect(0, 110895, '\p{^Blk=kanaexta}', "");
    Expect(0, 110895, '\P{Blk=kanaexta}', "");
    Expect(1, 110895, '\P{^Blk=kanaexta}', "");
    Expect(0, 110896, '\p{Blk=kanaexta}', "");
    Expect(1, 110896, '\p{^Blk=kanaexta}', "");
    Expect(1, 110896, '\P{Blk=kanaexta}', "");
    Expect(0, 110896, '\P{^Blk=kanaexta}', "");
    Expect(1, 110895, '\p{Blk=:\Akanaexta\z:}', "");;
    Expect(0, 110896, '\p{Blk=:\Akanaexta\z:}', "");;
    Expect(1, 110895, '\p{Blk: __Kana_Ext_A}', "");
    Expect(0, 110895, '\p{^Blk: __Kana_Ext_A}', "");
    Expect(0, 110895, '\P{Blk: __Kana_Ext_A}', "");
    Expect(1, 110895, '\P{^Blk: __Kana_Ext_A}', "");
    Expect(0, 110896, '\p{Blk: __Kana_Ext_A}', "");
    Expect(1, 110896, '\p{^Blk: __Kana_Ext_A}', "");
    Expect(1, 110896, '\P{Blk: __Kana_Ext_A}', "");
    Expect(0, 110896, '\P{^Blk: __Kana_Ext_A}', "");
    Error('\p{Is_Block=--KANA_Extended_A/a/}');
    Error('\P{Is_Block=--KANA_Extended_A/a/}');
    Expect(1, 110895, '\p{Is_Block=kanaextendeda}', "");
    Expect(0, 110895, '\p{^Is_Block=kanaextendeda}', "");
    Expect(0, 110895, '\P{Is_Block=kanaextendeda}', "");
    Expect(1, 110895, '\P{^Is_Block=kanaextendeda}', "");
    Expect(0, 110896, '\p{Is_Block=kanaextendeda}', "");
    Expect(1, 110896, '\p{^Is_Block=kanaextendeda}', "");
    Expect(1, 110896, '\P{Is_Block=kanaextendeda}', "");
    Expect(0, 110896, '\P{^Is_Block=kanaextendeda}', "");
    Expect(1, 110895, '\p{Is_Block=_ kana_EXTENDED_a}', "");
    Expect(0, 110895, '\p{^Is_Block=_ kana_EXTENDED_a}', "");
    Expect(0, 110895, '\P{Is_Block=_ kana_EXTENDED_a}', "");
    Expect(1, 110895, '\P{^Is_Block=_ kana_EXTENDED_a}', "");
    Expect(0, 110896, '\p{Is_Block=_ kana_EXTENDED_a}', "");
    Expect(1, 110896, '\p{^Is_Block=_ kana_EXTENDED_a}', "");
    Expect(1, 110896, '\P{Is_Block=_ kana_EXTENDED_a}', "");
    Expect(0, 110896, '\P{^Is_Block=_ kana_EXTENDED_a}', "");
    Error('\p{Is_Blk=/a/Kana_ext_a}');
    Error('\P{Is_Blk=/a/Kana_ext_a}');
    Expect(1, 110895, '\p{Is_Blk=kanaexta}', "");
    Expect(0, 110895, '\p{^Is_Blk=kanaexta}', "");
    Expect(0, 110895, '\P{Is_Blk=kanaexta}', "");
    Expect(1, 110895, '\P{^Is_Blk=kanaexta}', "");
    Expect(0, 110896, '\p{Is_Blk=kanaexta}', "");
    Expect(1, 110896, '\p{^Is_Blk=kanaexta}', "");
    Expect(1, 110896, '\P{Is_Blk=kanaexta}', "");
    Expect(0, 110896, '\P{^Is_Blk=kanaexta}', "");
    Expect(1, 110895, '\p{Is_Blk= 	kana_Ext_A}', "");
    Expect(0, 110895, '\p{^Is_Blk= 	kana_Ext_A}', "");
    Expect(0, 110895, '\P{Is_Blk= 	kana_Ext_A}', "");
    Expect(1, 110895, '\P{^Is_Blk= 	kana_Ext_A}', "");
    Expect(0, 110896, '\p{Is_Blk= 	kana_Ext_A}', "");
    Expect(1, 110896, '\p{^Is_Blk= 	kana_Ext_A}', "");
    Expect(1, 110896, '\P{Is_Blk= 	kana_Ext_A}', "");
    Expect(0, 110896, '\P{^Is_Blk= 	kana_Ext_A}', "");
    Error('\p{Block:   - Kana_Extended_b:=}');
    Error('\P{Block:   - Kana_Extended_b:=}');
    Expect(1, 110591, '\p{Block=:\AKana_Extended_B\z:}', "");;
    Expect(0, 110592, '\p{Block=:\AKana_Extended_B\z:}', "");;
    Expect(1, 110591, '\p{Block:	kanaextendedb}', "");
    Expect(0, 110591, '\p{^Block:	kanaextendedb}', "");
    Expect(0, 110591, '\P{Block:	kanaextendedb}', "");
    Expect(1, 110591, '\P{^Block:	kanaextendedb}', "");
    Expect(0, 110592, '\p{Block:	kanaextendedb}', "");
    Expect(1, 110592, '\p{^Block:	kanaextendedb}', "");
    Expect(1, 110592, '\P{Block:	kanaextendedb}', "");
    Expect(0, 110592, '\P{^Block:	kanaextendedb}', "");
    Expect(1, 110591, '\p{Block=:\Akanaextendedb\z:}', "");;
    Expect(0, 110592, '\p{Block=:\Akanaextendedb\z:}', "");;
    Expect(1, 110591, '\p{Block=__KANA_Extended_B}', "");
    Expect(0, 110591, '\p{^Block=__KANA_Extended_B}', "");
    Expect(0, 110591, '\P{Block=__KANA_Extended_B}', "");
    Expect(1, 110591, '\P{^Block=__KANA_Extended_B}', "");
    Expect(0, 110592, '\p{Block=__KANA_Extended_B}', "");
    Expect(1, 110592, '\p{^Block=__KANA_Extended_B}', "");
    Expect(1, 110592, '\P{Block=__KANA_Extended_B}', "");
    Expect(0, 110592, '\P{^Block=__KANA_Extended_B}', "");
    Error('\p{Blk=/a/Kana_Ext_b}');
    Error('\P{Blk=/a/Kana_Ext_b}');
    Expect(1, 110591, '\p{Blk=:\AKana_Ext_B\z:}', "");;
    Expect(0, 110592, '\p{Blk=:\AKana_Ext_B\z:}', "");;
    Expect(1, 110591, '\p{Blk=kanaextb}', "");
    Expect(0, 110591, '\p{^Blk=kanaextb}', "");
    Expect(0, 110591, '\P{Blk=kanaextb}', "");
    Expect(1, 110591, '\P{^Blk=kanaextb}', "");
    Expect(0, 110592, '\p{Blk=kanaextb}', "");
    Expect(1, 110592, '\p{^Blk=kanaextb}', "");
    Expect(1, 110592, '\P{Blk=kanaextb}', "");
    Expect(0, 110592, '\P{^Blk=kanaextb}', "");
    Expect(1, 110591, '\p{Blk=:\Akanaextb\z:}', "");;
    Expect(0, 110592, '\p{Blk=:\Akanaextb\z:}', "");;
    Expect(1, 110591, '\p{Blk= KANA_EXT_b}', "");
    Expect(0, 110591, '\p{^Blk= KANA_EXT_b}', "");
    Expect(0, 110591, '\P{Blk= KANA_EXT_b}', "");
    Expect(1, 110591, '\P{^Blk= KANA_EXT_b}', "");
    Expect(0, 110592, '\p{Blk= KANA_EXT_b}', "");
    Expect(1, 110592, '\p{^Blk= KANA_EXT_b}', "");
    Expect(1, 110592, '\P{Blk= KANA_EXT_b}', "");
    Expect(0, 110592, '\P{^Blk= KANA_EXT_b}', "");
    Error('\p{Is_Block=:=		Kana_extended_B}');
    Error('\P{Is_Block=:=		Kana_extended_B}');
    Expect(1, 110591, '\p{Is_Block:kanaextendedb}', "");
    Expect(0, 110591, '\p{^Is_Block:kanaextendedb}', "");
    Expect(0, 110591, '\P{Is_Block:kanaextendedb}', "");
    Expect(1, 110591, '\P{^Is_Block:kanaextendedb}', "");
    Expect(0, 110592, '\p{Is_Block:kanaextendedb}', "");
    Expect(1, 110592, '\p{^Is_Block:kanaextendedb}', "");
    Expect(1, 110592, '\P{Is_Block:kanaextendedb}', "");
    Expect(0, 110592, '\P{^Is_Block:kanaextendedb}', "");
    Expect(1, 110591, '\p{Is_Block:   -_kana_EXTENDED_B}', "");
    Expect(0, 110591, '\p{^Is_Block:   -_kana_EXTENDED_B}', "");
    Expect(0, 110591, '\P{Is_Block:   -_kana_EXTENDED_B}', "");
    Expect(1, 110591, '\P{^Is_Block:   -_kana_EXTENDED_B}', "");
    Expect(0, 110592, '\p{Is_Block:   -_kana_EXTENDED_B}', "");
    Expect(1, 110592, '\p{^Is_Block:   -_kana_EXTENDED_B}', "");
    Expect(1, 110592, '\P{Is_Block:   -_kana_EXTENDED_B}', "");
    Expect(0, 110592, '\P{^Is_Block:   -_kana_EXTENDED_B}', "");
    Error('\p{Is_Blk=-	KANA_EXT_B:=}');
    Error('\P{Is_Blk=-	KANA_EXT_B:=}');
    Expect(1, 110591, '\p{Is_Blk=kanaextb}', "");
    Expect(0, 110591, '\p{^Is_Blk=kanaextb}', "");
    Expect(0, 110591, '\P{Is_Blk=kanaextb}', "");
    Expect(1, 110591, '\P{^Is_Blk=kanaextb}', "");
    Expect(0, 110592, '\p{Is_Blk=kanaextb}', "");
    Expect(1, 110592, '\p{^Is_Blk=kanaextb}', "");
    Expect(1, 110592, '\P{Is_Blk=kanaextb}', "");
    Expect(0, 110592, '\P{^Is_Blk=kanaextb}', "");
    Expect(1, 110591, '\p{Is_Blk=	Kana_Ext_B}', "");
    Expect(0, 110591, '\p{^Is_Blk=	Kana_Ext_B}', "");
    Expect(0, 110591, '\P{Is_Blk=	Kana_Ext_B}', "");
    Expect(1, 110591, '\P{^Is_Blk=	Kana_Ext_B}', "");
    Expect(0, 110592, '\p{Is_Blk=	Kana_Ext_B}', "");
    Expect(1, 110592, '\p{^Is_Blk=	Kana_Ext_B}', "");
    Expect(1, 110592, '\P{Is_Blk=	Kana_Ext_B}', "");
    Expect(0, 110592, '\P{^Is_Blk=	Kana_Ext_B}', "");
    Error('\p{Block=  Kana_Supplement/a/}');
    Error('\P{Block=  Kana_Supplement/a/}');
    Expect(1, 110847, '\p{Block=:\AKana_Supplement\z:}', "");;
    Expect(0, 110848, '\p{Block=:\AKana_Supplement\z:}', "");;
    Expect(1, 110847, '\p{Block=kanasupplement}', "");
    Expect(0, 110847, '\p{^Block=kanasupplement}', "");
    Expect(0, 110847, '\P{Block=kanasupplement}', "");
    Expect(1, 110847, '\P{^Block=kanasupplement}', "");
    Expect(0, 110848, '\p{Block=kanasupplement}', "");
    Expect(1, 110848, '\p{^Block=kanasupplement}', "");
    Expect(1, 110848, '\P{Block=kanasupplement}', "");
    Expect(0, 110848, '\P{^Block=kanasupplement}', "");
    Expect(1, 110847, '\p{Block=:\Akanasupplement\z:}', "");;
    Expect(0, 110848, '\p{Block=:\Akanasupplement\z:}', "");;
    Expect(1, 110847, '\p{Block=	_kana_SUPPLEMENT}', "");
    Expect(0, 110847, '\p{^Block=	_kana_SUPPLEMENT}', "");
    Expect(0, 110847, '\P{Block=	_kana_SUPPLEMENT}', "");
    Expect(1, 110847, '\P{^Block=	_kana_SUPPLEMENT}', "");
    Expect(0, 110848, '\p{Block=	_kana_SUPPLEMENT}', "");
    Expect(1, 110848, '\p{^Block=	_kana_SUPPLEMENT}', "");
    Expect(1, 110848, '\P{Block=	_kana_SUPPLEMENT}', "");
    Expect(0, 110848, '\P{^Block=	_kana_SUPPLEMENT}', "");
    Error('\p{Blk=/a/-KANA_SUP}');
    Error('\P{Blk=/a/-KANA_SUP}');
    Expect(1, 110847, '\p{Blk=:\AKana_Sup\z:}', "");;
    Expect(0, 110848, '\p{Blk=:\AKana_Sup\z:}', "");;
    Expect(1, 110847, '\p{Blk=kanasup}', "");
    Expect(0, 110847, '\p{^Blk=kanasup}', "");
    Expect(0, 110847, '\P{Blk=kanasup}', "");
    Expect(1, 110847, '\P{^Blk=kanasup}', "");
    Expect(0, 110848, '\p{Blk=kanasup}', "");
    Expect(1, 110848, '\p{^Blk=kanasup}', "");
    Expect(1, 110848, '\P{Blk=kanasup}', "");
    Expect(0, 110848, '\P{^Blk=kanasup}', "");
    Expect(1, 110847, '\p{Blk=:\Akanasup\z:}', "");;
    Expect(0, 110848, '\p{Blk=:\Akanasup\z:}', "");;
    Expect(1, 110847, '\p{Blk=-_Kana_sup}', "");
    Expect(0, 110847, '\p{^Blk=-_Kana_sup}', "");
    Expect(0, 110847, '\P{Blk=-_Kana_sup}', "");
    Expect(1, 110847, '\P{^Blk=-_Kana_sup}', "");
    Expect(0, 110848, '\p{Blk=-_Kana_sup}', "");
    Expect(1, 110848, '\p{^Blk=-_Kana_sup}', "");
    Expect(1, 110848, '\P{Blk=-_Kana_sup}', "");
    Expect(0, 110848, '\P{^Blk=-_Kana_sup}', "");
    Error('\p{Is_Block=	-kana_Supplement/a/}');
    Error('\P{Is_Block=	-kana_Supplement/a/}');
    Expect(1, 110847, '\p{Is_Block=kanasupplement}', "");
    Expect(0, 110847, '\p{^Is_Block=kanasupplement}', "");
    Expect(0, 110847, '\P{Is_Block=kanasupplement}', "");
    Expect(1, 110847, '\P{^Is_Block=kanasupplement}', "");
    Expect(0, 110848, '\p{Is_Block=kanasupplement}', "");
    Expect(1, 110848, '\p{^Is_Block=kanasupplement}', "");
    Expect(1, 110848, '\P{Is_Block=kanasupplement}', "");
    Expect(0, 110848, '\P{^Is_Block=kanasupplement}', "");
    Expect(1, 110847, '\p{Is_Block=-	Kana_SUPPLEMENT}', "");
    Expect(0, 110847, '\p{^Is_Block=-	Kana_SUPPLEMENT}', "");
    Expect(0, 110847, '\P{Is_Block=-	Kana_SUPPLEMENT}', "");
    Expect(1, 110847, '\P{^Is_Block=-	Kana_SUPPLEMENT}', "");
    Expect(0, 110848, '\p{Is_Block=-	Kana_SUPPLEMENT}', "");
    Expect(1, 110848, '\p{^Is_Block=-	Kana_SUPPLEMENT}', "");
    Expect(1, 110848, '\P{Is_Block=-	Kana_SUPPLEMENT}', "");
    Expect(0, 110848, '\P{^Is_Block=-	Kana_SUPPLEMENT}', "");
    Error('\p{Is_Blk= Kana_sup/a/}');
    Error('\P{Is_Blk= Kana_sup/a/}');
    Expect(1, 110847, '\p{Is_Blk=kanasup}', "");
    Expect(0, 110847, '\p{^Is_Blk=kanasup}', "");
    Expect(0, 110847, '\P{Is_Blk=kanasup}', "");
    Expect(1, 110847, '\P{^Is_Blk=kanasup}', "");
    Expect(0, 110848, '\p{Is_Blk=kanasup}', "");
    Expect(1, 110848, '\p{^Is_Blk=kanasup}', "");
    Expect(1, 110848, '\P{Is_Blk=kanasup}', "");
    Expect(0, 110848, '\P{^Is_Blk=kanasup}', "");
    Expect(1, 110847, '\p{Is_Blk= -Kana_Sup}', "");
    Expect(0, 110847, '\p{^Is_Blk= -Kana_Sup}', "");
    Expect(0, 110847, '\P{Is_Blk= -Kana_Sup}', "");
    Expect(1, 110847, '\P{^Is_Blk= -Kana_Sup}', "");
    Expect(0, 110848, '\p{Is_Blk= -Kana_Sup}', "");
    Expect(1, 110848, '\p{^Is_Blk= -Kana_Sup}', "");
    Expect(1, 110848, '\P{Is_Blk= -Kana_Sup}', "");
    Expect(0, 110848, '\P{^Is_Blk= -Kana_Sup}', "");
    Error('\p{Block:			kanbun/a/}');
    Error('\P{Block:			kanbun/a/}');
    Expect(1, 12703, '\p{Block=:\AKanbun\z:}', "");;
    Expect(0, 12704, '\p{Block=:\AKanbun\z:}', "");;
    Expect(1, 12703, '\p{Block=kanbun}', "");
    Expect(0, 12703, '\p{^Block=kanbun}', "");
    Expect(0, 12703, '\P{Block=kanbun}', "");
    Expect(1, 12703, '\P{^Block=kanbun}', "");
    Expect(0, 12704, '\p{Block=kanbun}', "");
    Expect(1, 12704, '\p{^Block=kanbun}', "");
    Expect(1, 12704, '\P{Block=kanbun}', "");
    Expect(0, 12704, '\P{^Block=kanbun}', "");
    Expect(1, 12703, '\p{Block=:\Akanbun\z:}', "");;
    Expect(0, 12704, '\p{Block=:\Akanbun\z:}', "");;
    Expect(1, 12703, '\p{Block= -Kanbun}', "");
    Expect(0, 12703, '\p{^Block= -Kanbun}', "");
    Expect(0, 12703, '\P{Block= -Kanbun}', "");
    Expect(1, 12703, '\P{^Block= -Kanbun}', "");
    Expect(0, 12704, '\p{Block= -Kanbun}', "");
    Expect(1, 12704, '\p{^Block= -Kanbun}', "");
    Expect(1, 12704, '\P{Block= -Kanbun}', "");
    Expect(0, 12704, '\P{^Block= -Kanbun}', "");
    Error('\p{Blk=/a/_KANBUN}');
    Error('\P{Blk=/a/_KANBUN}');
    Expect(1, 12703, '\p{Blk=:\AKanbun\z:}', "");;
    Expect(0, 12704, '\p{Blk=:\AKanbun\z:}', "");;
    Expect(1, 12703, '\p{Blk=kanbun}', "");
    Expect(0, 12703, '\p{^Blk=kanbun}', "");
    Expect(0, 12703, '\P{Blk=kanbun}', "");
    Expect(1, 12703, '\P{^Blk=kanbun}', "");
    Expect(0, 12704, '\p{Blk=kanbun}', "");
    Expect(1, 12704, '\p{^Blk=kanbun}', "");
    Expect(1, 12704, '\P{Blk=kanbun}', "");
    Expect(0, 12704, '\P{^Blk=kanbun}', "");
    Expect(1, 12703, '\p{Blk=:\Akanbun\z:}', "");;
    Expect(0, 12704, '\p{Blk=:\Akanbun\z:}', "");;
    Expect(1, 12703, '\p{Blk=-_KANBUN}', "");
    Expect(0, 12703, '\p{^Blk=-_KANBUN}', "");
    Expect(0, 12703, '\P{Blk=-_KANBUN}', "");
    Expect(1, 12703, '\P{^Blk=-_KANBUN}', "");
    Expect(0, 12704, '\p{Blk=-_KANBUN}', "");
    Expect(1, 12704, '\p{^Blk=-_KANBUN}', "");
    Expect(1, 12704, '\P{Blk=-_KANBUN}', "");
    Expect(0, 12704, '\P{^Blk=-_KANBUN}', "");
    Error('\p{Is_Block=	/a/KANBUN}');
    Error('\P{Is_Block=	/a/KANBUN}');
    Expect(1, 12703, '\p{Is_Block: kanbun}', "");
    Expect(0, 12703, '\p{^Is_Block: kanbun}', "");
    Expect(0, 12703, '\P{Is_Block: kanbun}', "");
    Expect(1, 12703, '\P{^Is_Block: kanbun}', "");
    Expect(0, 12704, '\p{Is_Block: kanbun}', "");
    Expect(1, 12704, '\p{^Is_Block: kanbun}', "");
    Expect(1, 12704, '\P{Is_Block: kanbun}', "");
    Expect(0, 12704, '\P{^Is_Block: kanbun}', "");
    Expect(1, 12703, '\p{Is_Block=	_Kanbun}', "");
    Expect(0, 12703, '\p{^Is_Block=	_Kanbun}', "");
    Expect(0, 12703, '\P{Is_Block=	_Kanbun}', "");
    Expect(1, 12703, '\P{^Is_Block=	_Kanbun}', "");
    Expect(0, 12704, '\p{Is_Block=	_Kanbun}', "");
    Expect(1, 12704, '\p{^Is_Block=	_Kanbun}', "");
    Expect(1, 12704, '\P{Is_Block=	_Kanbun}', "");
    Expect(0, 12704, '\P{^Is_Block=	_Kanbun}', "");
    Error('\p{Is_Blk:	_kanbun/a/}');
    Error('\P{Is_Blk:	_kanbun/a/}');
    Expect(1, 12703, '\p{Is_Blk=kanbun}', "");
    Expect(0, 12703, '\p{^Is_Blk=kanbun}', "");
    Expect(0, 12703, '\P{Is_Blk=kanbun}', "");
    Expect(1, 12703, '\P{^Is_Blk=kanbun}', "");
    Expect(0, 12704, '\p{Is_Blk=kanbun}', "");
    Expect(1, 12704, '\p{^Is_Blk=kanbun}', "");
    Expect(1, 12704, '\P{Is_Blk=kanbun}', "");
    Expect(0, 12704, '\P{^Is_Blk=kanbun}', "");
    Expect(1, 12703, '\p{Is_Blk=--KANBUN}', "");
    Expect(0, 12703, '\p{^Is_Blk=--KANBUN}', "");
    Expect(0, 12703, '\P{Is_Blk=--KANBUN}', "");
    Expect(1, 12703, '\P{^Is_Blk=--KANBUN}', "");
    Expect(0, 12704, '\p{Is_Blk=--KANBUN}', "");
    Expect(1, 12704, '\p{^Is_Blk=--KANBUN}', "");
    Expect(1, 12704, '\P{Is_Blk=--KANBUN}', "");
    Expect(0, 12704, '\P{^Is_Blk=--KANBUN}', "");
    Error('\p{Block=	/a/Kangxi_radicals}');
    Error('\P{Block=	/a/Kangxi_radicals}');
    Expect(1, 12255, '\p{Block=:\AKangxi_Radicals\z:}', "");;
    Expect(0, 12256, '\p{Block=:\AKangxi_Radicals\z:}', "");;
    Expect(1, 12255, '\p{Block=kangxiradicals}', "");
    Expect(0, 12255, '\p{^Block=kangxiradicals}', "");
    Expect(0, 12255, '\P{Block=kangxiradicals}', "");
    Expect(1, 12255, '\P{^Block=kangxiradicals}', "");
    Expect(0, 12256, '\p{Block=kangxiradicals}', "");
    Expect(1, 12256, '\p{^Block=kangxiradicals}', "");
    Expect(1, 12256, '\P{Block=kangxiradicals}', "");
    Expect(0, 12256, '\P{^Block=kangxiradicals}', "");
    Expect(1, 12255, '\p{Block=:\Akangxiradicals\z:}', "");;
    Expect(0, 12256, '\p{Block=:\Akangxiradicals\z:}', "");;
    Expect(1, 12255, '\p{Block= -Kangxi_radicals}', "");
    Expect(0, 12255, '\p{^Block= -Kangxi_radicals}', "");
    Expect(0, 12255, '\P{Block= -Kangxi_radicals}', "");
    Expect(1, 12255, '\P{^Block= -Kangxi_radicals}', "");
    Expect(0, 12256, '\p{Block= -Kangxi_radicals}', "");
    Expect(1, 12256, '\p{^Block= -Kangxi_radicals}', "");
    Expect(1, 12256, '\P{Block= -Kangxi_radicals}', "");
    Expect(0, 12256, '\P{^Block= -Kangxi_radicals}', "");
    Error('\p{Blk=/a/Kangxi}');
    Error('\P{Blk=/a/Kangxi}');
    Expect(1, 12255, '\p{Blk=:\AKangxi\z:}', "");;
    Expect(0, 12256, '\p{Blk=:\AKangxi\z:}', "");;
    Expect(1, 12255, '\p{Blk=kangxi}', "");
    Expect(0, 12255, '\p{^Blk=kangxi}', "");
    Expect(0, 12255, '\P{Blk=kangxi}', "");
    Expect(1, 12255, '\P{^Blk=kangxi}', "");
    Expect(0, 12256, '\p{Blk=kangxi}', "");
    Expect(1, 12256, '\p{^Blk=kangxi}', "");
    Expect(1, 12256, '\P{Blk=kangxi}', "");
    Expect(0, 12256, '\P{^Blk=kangxi}', "");
    Expect(1, 12255, '\p{Blk=:\Akangxi\z:}', "");;
    Expect(0, 12256, '\p{Blk=:\Akangxi\z:}', "");;
    Expect(1, 12255, '\p{Blk=--Kangxi}', "");
    Expect(0, 12255, '\p{^Blk=--Kangxi}', "");
    Expect(0, 12255, '\P{Blk=--Kangxi}', "");
    Expect(1, 12255, '\P{^Blk=--Kangxi}', "");
    Expect(0, 12256, '\p{Blk=--Kangxi}', "");
    Expect(1, 12256, '\p{^Blk=--Kangxi}', "");
    Expect(1, 12256, '\P{Blk=--Kangxi}', "");
    Expect(0, 12256, '\P{^Blk=--Kangxi}', "");
    Error('\p{Is_Block=:=	_kangxi_Radicals}');
    Error('\P{Is_Block=:=	_kangxi_Radicals}');
    Expect(1, 12255, '\p{Is_Block=kangxiradicals}', "");
    Expect(0, 12255, '\p{^Is_Block=kangxiradicals}', "");
    Expect(0, 12255, '\P{Is_Block=kangxiradicals}', "");
    Expect(1, 12255, '\P{^Is_Block=kangxiradicals}', "");
    Expect(0, 12256, '\p{Is_Block=kangxiradicals}', "");
    Expect(1, 12256, '\p{^Is_Block=kangxiradicals}', "");
    Expect(1, 12256, '\P{Is_Block=kangxiradicals}', "");
    Expect(0, 12256, '\P{^Is_Block=kangxiradicals}', "");
    Expect(1, 12255, '\p{Is_Block=-	kangxi_RADICALS}', "");
    Expect(0, 12255, '\p{^Is_Block=-	kangxi_RADICALS}', "");
    Expect(0, 12255, '\P{Is_Block=-	kangxi_RADICALS}', "");
    Expect(1, 12255, '\P{^Is_Block=-	kangxi_RADICALS}', "");
    Expect(0, 12256, '\p{Is_Block=-	kangxi_RADICALS}', "");
    Expect(1, 12256, '\p{^Is_Block=-	kangxi_RADICALS}', "");
    Expect(1, 12256, '\P{Is_Block=-	kangxi_RADICALS}', "");
    Expect(0, 12256, '\P{^Is_Block=-	kangxi_RADICALS}', "");
    Error('\p{Is_Blk= :=kangxi}');
    Error('\P{Is_Blk= :=kangxi}');
    Expect(1, 12255, '\p{Is_Blk=kangxi}', "");
    Expect(0, 12255, '\p{^Is_Blk=kangxi}', "");
    Expect(0, 12255, '\P{Is_Blk=kangxi}', "");
    Expect(1, 12255, '\P{^Is_Blk=kangxi}', "");
    Expect(0, 12256, '\p{Is_Blk=kangxi}', "");
    Expect(1, 12256, '\p{^Is_Blk=kangxi}', "");
    Expect(1, 12256, '\P{Is_Blk=kangxi}', "");
    Expect(0, 12256, '\P{^Is_Blk=kangxi}', "");
    Expect(1, 12255, '\p{Is_Blk= 	Kangxi}', "");
    Expect(0, 12255, '\p{^Is_Blk= 	Kangxi}', "");
    Expect(0, 12255, '\P{Is_Blk= 	Kangxi}', "");
    Expect(1, 12255, '\P{^Is_Blk= 	Kangxi}', "");
    Expect(0, 12256, '\p{Is_Blk= 	Kangxi}', "");
    Expect(1, 12256, '\p{^Is_Blk= 	Kangxi}', "");
    Expect(1, 12256, '\P{Is_Blk= 	Kangxi}', "");
    Expect(0, 12256, '\P{^Is_Blk= 	Kangxi}', "");
    Error('\p{Block=/a/ kannada}');
    Error('\P{Block=/a/ kannada}');
    Expect(1, 3327, '\p{Block=:\AKannada\z:}', "");;
    Expect(0, 3328, '\p{Block=:\AKannada\z:}', "");;
    Expect(1, 3327, '\p{Block=kannada}', "");
    Expect(0, 3327, '\p{^Block=kannada}', "");
    Expect(0, 3327, '\P{Block=kannada}', "");
    Expect(1, 3327, '\P{^Block=kannada}', "");
    Expect(0, 3328, '\p{Block=kannada}', "");
    Expect(1, 3328, '\p{^Block=kannada}', "");
    Expect(1, 3328, '\P{Block=kannada}', "");
    Expect(0, 3328, '\P{^Block=kannada}', "");
    Expect(1, 3327, '\p{Block=:\Akannada\z:}', "");;
    Expect(0, 3328, '\p{Block=:\Akannada\z:}', "");;
    Expect(1, 3327, '\p{Block=  KANNADA}', "");
    Expect(0, 3327, '\p{^Block=  KANNADA}', "");
    Expect(0, 3327, '\P{Block=  KANNADA}', "");
    Expect(1, 3327, '\P{^Block=  KANNADA}', "");
    Expect(0, 3328, '\p{Block=  KANNADA}', "");
    Expect(1, 3328, '\p{^Block=  KANNADA}', "");
    Expect(1, 3328, '\P{Block=  KANNADA}', "");
    Expect(0, 3328, '\P{^Block=  KANNADA}', "");
    Error('\p{Blk:	 :=KANNADA}');
    Error('\P{Blk:	 :=KANNADA}');
    Expect(1, 3327, '\p{Blk=:\AKannada\z:}', "");;
    Expect(0, 3328, '\p{Blk=:\AKannada\z:}', "");;
    Expect(1, 3327, '\p{Blk=kannada}', "");
    Expect(0, 3327, '\p{^Blk=kannada}', "");
    Expect(0, 3327, '\P{Blk=kannada}', "");
    Expect(1, 3327, '\P{^Blk=kannada}', "");
    Expect(0, 3328, '\p{Blk=kannada}', "");
    Expect(1, 3328, '\p{^Blk=kannada}', "");
    Expect(1, 3328, '\P{Blk=kannada}', "");
    Expect(0, 3328, '\P{^Blk=kannada}', "");
    Expect(1, 3327, '\p{Blk=:\Akannada\z:}', "");;
    Expect(0, 3328, '\p{Blk=:\Akannada\z:}', "");;
    Expect(1, 3327, '\p{Blk=--Kannada}', "");
    Expect(0, 3327, '\p{^Blk=--Kannada}', "");
    Expect(0, 3327, '\P{Blk=--Kannada}', "");
    Expect(1, 3327, '\P{^Blk=--Kannada}', "");
    Expect(0, 3328, '\p{Blk=--Kannada}', "");
    Expect(1, 3328, '\p{^Blk=--Kannada}', "");
    Expect(1, 3328, '\P{Blk=--Kannada}', "");
    Expect(0, 3328, '\P{^Blk=--Kannada}', "");
    Error('\p{Is_Block=_/a/KANNADA}');
    Error('\P{Is_Block=_/a/KANNADA}');
    Expect(1, 3327, '\p{Is_Block=kannada}', "");
    Expect(0, 3327, '\p{^Is_Block=kannada}', "");
    Expect(0, 3327, '\P{Is_Block=kannada}', "");
    Expect(1, 3327, '\P{^Is_Block=kannada}', "");
    Expect(0, 3328, '\p{Is_Block=kannada}', "");
    Expect(1, 3328, '\p{^Is_Block=kannada}', "");
    Expect(1, 3328, '\P{Is_Block=kannada}', "");
    Expect(0, 3328, '\P{^Is_Block=kannada}', "");
    Expect(1, 3327, '\p{Is_Block:	-_KANNADA}', "");
    Expect(0, 3327, '\p{^Is_Block:	-_KANNADA}', "");
    Expect(0, 3327, '\P{Is_Block:	-_KANNADA}', "");
    Expect(1, 3327, '\P{^Is_Block:	-_KANNADA}', "");
    Expect(0, 3328, '\p{Is_Block:	-_KANNADA}', "");
    Expect(1, 3328, '\p{^Is_Block:	-_KANNADA}', "");
    Expect(1, 3328, '\P{Is_Block:	-_KANNADA}', "");
    Expect(0, 3328, '\P{^Is_Block:	-_KANNADA}', "");
    Error('\p{Is_Blk= -Kannada:=}');
    Error('\P{Is_Blk= -Kannada:=}');
    Expect(1, 3327, '\p{Is_Blk=kannada}', "");
    Expect(0, 3327, '\p{^Is_Blk=kannada}', "");
    Expect(0, 3327, '\P{Is_Blk=kannada}', "");
    Expect(1, 3327, '\P{^Is_Blk=kannada}', "");
    Expect(0, 3328, '\p{Is_Blk=kannada}', "");
    Expect(1, 3328, '\p{^Is_Blk=kannada}', "");
    Expect(1, 3328, '\P{Is_Blk=kannada}', "");
    Expect(0, 3328, '\P{^Is_Blk=kannada}', "");
    Expect(1, 3327, '\p{Is_Blk=__Kannada}', "");
    Expect(0, 3327, '\p{^Is_Blk=__Kannada}', "");
    Expect(0, 3327, '\P{Is_Blk=__Kannada}', "");
    Expect(1, 3327, '\P{^Is_Blk=__Kannada}', "");
    Expect(0, 3328, '\p{Is_Blk=__Kannada}', "");
    Expect(1, 3328, '\p{^Is_Blk=__Kannada}', "");
    Expect(1, 3328, '\P{Is_Blk=__Kannada}', "");
    Expect(0, 3328, '\P{^Is_Blk=__Kannada}', "");
    Error('\p{Block= 	Katakana:=}');
    Error('\P{Block= 	Katakana:=}');
    Expect(1, 12543, '\p{Block=:\AKatakana\z:}', "");;
    Expect(0, 12544, '\p{Block=:\AKatakana\z:}', "");;
    Expect(1, 12543, '\p{Block=katakana}', "");
    Expect(0, 12543, '\p{^Block=katakana}', "");
    Expect(0, 12543, '\P{Block=katakana}', "");
    Expect(1, 12543, '\P{^Block=katakana}', "");
    Expect(0, 12544, '\p{Block=katakana}', "");
    Expect(1, 12544, '\p{^Block=katakana}', "");
    Expect(1, 12544, '\P{Block=katakana}', "");
    Expect(0, 12544, '\P{^Block=katakana}', "");
    Expect(1, 12543, '\p{Block=:\Akatakana\z:}', "");;
    Expect(0, 12544, '\p{Block=:\Akatakana\z:}', "");;
    Expect(1, 12543, '\p{Block=	KATAKANA}', "");
    Expect(0, 12543, '\p{^Block=	KATAKANA}', "");
    Expect(0, 12543, '\P{Block=	KATAKANA}', "");
    Expect(1, 12543, '\P{^Block=	KATAKANA}', "");
    Expect(0, 12544, '\p{Block=	KATAKANA}', "");
    Expect(1, 12544, '\p{^Block=	KATAKANA}', "");
    Expect(1, 12544, '\P{Block=	KATAKANA}', "");
    Expect(0, 12544, '\P{^Block=	KATAKANA}', "");
    Error('\p{Blk:-/a/Katakana}');
    Error('\P{Blk:-/a/Katakana}');
    Expect(1, 12543, '\p{Blk=:\AKatakana\z:}', "");;
    Expect(0, 12544, '\p{Blk=:\AKatakana\z:}', "");;
    Expect(1, 12543, '\p{Blk=katakana}', "");
    Expect(0, 12543, '\p{^Blk=katakana}', "");
    Expect(0, 12543, '\P{Blk=katakana}', "");
    Expect(1, 12543, '\P{^Blk=katakana}', "");
    Expect(0, 12544, '\p{Blk=katakana}', "");
    Expect(1, 12544, '\p{^Blk=katakana}', "");
    Expect(1, 12544, '\P{Blk=katakana}', "");
    Expect(0, 12544, '\P{^Blk=katakana}', "");
    Expect(1, 12543, '\p{Blk=:\Akatakana\z:}', "");;
    Expect(0, 12544, '\p{Blk=:\Akatakana\z:}', "");;
    Expect(1, 12543, '\p{Blk= KATAKANA}', "");
    Expect(0, 12543, '\p{^Blk= KATAKANA}', "");
    Expect(0, 12543, '\P{Blk= KATAKANA}', "");
    Expect(1, 12543, '\P{^Blk= KATAKANA}', "");
    Expect(0, 12544, '\p{Blk= KATAKANA}', "");
    Expect(1, 12544, '\p{^Blk= KATAKANA}', "");
    Expect(1, 12544, '\P{Blk= KATAKANA}', "");
    Expect(0, 12544, '\P{^Blk= KATAKANA}', "");
    Error('\p{Is_Block= _Katakana/a/}');
    Error('\P{Is_Block= _Katakana/a/}');
    Expect(1, 12543, '\p{Is_Block=katakana}', "");
    Expect(0, 12543, '\p{^Is_Block=katakana}', "");
    Expect(0, 12543, '\P{Is_Block=katakana}', "");
    Expect(1, 12543, '\P{^Is_Block=katakana}', "");
    Expect(0, 12544, '\p{Is_Block=katakana}', "");
    Expect(1, 12544, '\p{^Is_Block=katakana}', "");
    Expect(1, 12544, '\P{Is_Block=katakana}', "");
    Expect(0, 12544, '\P{^Is_Block=katakana}', "");
    Expect(1, 12543, '\p{Is_Block: _ Katakana}', "");
    Expect(0, 12543, '\p{^Is_Block: _ Katakana}', "");
    Expect(0, 12543, '\P{Is_Block: _ Katakana}', "");
    Expect(1, 12543, '\P{^Is_Block: _ Katakana}', "");
    Expect(0, 12544, '\p{Is_Block: _ Katakana}', "");
    Expect(1, 12544, '\p{^Is_Block: _ Katakana}', "");
    Expect(1, 12544, '\P{Is_Block: _ Katakana}', "");
    Expect(0, 12544, '\P{^Is_Block: _ Katakana}', "");
    Error('\p{Is_Blk=:=Katakana}');
    Error('\P{Is_Blk=:=Katakana}');
    Expect(1, 12543, '\p{Is_Blk=katakana}', "");
    Expect(0, 12543, '\p{^Is_Blk=katakana}', "");
    Expect(0, 12543, '\P{Is_Blk=katakana}', "");
    Expect(1, 12543, '\P{^Is_Blk=katakana}', "");
    Expect(0, 12544, '\p{Is_Blk=katakana}', "");
    Expect(1, 12544, '\p{^Is_Blk=katakana}', "");
    Expect(1, 12544, '\P{Is_Blk=katakana}', "");
    Expect(0, 12544, '\P{^Is_Blk=katakana}', "");
    Expect(1, 12543, '\p{Is_Blk=- Katakana}', "");
    Expect(0, 12543, '\p{^Is_Blk=- Katakana}', "");
    Expect(0, 12543, '\P{Is_Blk=- Katakana}', "");
    Expect(1, 12543, '\P{^Is_Blk=- Katakana}', "");
    Expect(0, 12544, '\p{Is_Blk=- Katakana}', "");
    Expect(1, 12544, '\p{^Is_Blk=- Katakana}', "");
    Expect(1, 12544, '\P{Is_Blk=- Katakana}', "");
    Expect(0, 12544, '\P{^Is_Blk=- Katakana}', "");
    Error('\p{Block=Katakana_phonetic_EXTENSIONS/a/}');
    Error('\P{Block=Katakana_phonetic_EXTENSIONS/a/}');
    Expect(1, 12799, '\p{Block=:\AKatakana_Phonetic_Extensions\z:}', "");;
    Expect(0, 12800, '\p{Block=:\AKatakana_Phonetic_Extensions\z:}', "");;
    Expect(1, 12799, '\p{Block=katakanaphoneticextensions}', "");
    Expect(0, 12799, '\p{^Block=katakanaphoneticextensions}', "");
    Expect(0, 12799, '\P{Block=katakanaphoneticextensions}', "");
    Expect(1, 12799, '\P{^Block=katakanaphoneticextensions}', "");
    Expect(0, 12800, '\p{Block=katakanaphoneticextensions}', "");
    Expect(1, 12800, '\p{^Block=katakanaphoneticextensions}', "");
    Expect(1, 12800, '\P{Block=katakanaphoneticextensions}', "");
    Expect(0, 12800, '\P{^Block=katakanaphoneticextensions}', "");
    Expect(1, 12799, '\p{Block=:\Akatakanaphoneticextensions\z:}', "");;
    Expect(0, 12800, '\p{Block=:\Akatakanaphoneticextensions\z:}', "");;
    Expect(1, 12799, '\p{Block=	_katakana_phonetic_Extensions}', "");
    Expect(0, 12799, '\p{^Block=	_katakana_phonetic_Extensions}', "");
    Expect(0, 12799, '\P{Block=	_katakana_phonetic_Extensions}', "");
    Expect(1, 12799, '\P{^Block=	_katakana_phonetic_Extensions}', "");
    Expect(0, 12800, '\p{Block=	_katakana_phonetic_Extensions}', "");
    Expect(1, 12800, '\p{^Block=	_katakana_phonetic_Extensions}', "");
    Expect(1, 12800, '\P{Block=	_katakana_phonetic_Extensions}', "");
    Expect(0, 12800, '\P{^Block=	_katakana_phonetic_Extensions}', "");
    Error('\p{Blk=:=	 katakana_Ext}');
    Error('\P{Blk=:=	 katakana_Ext}');
    Expect(1, 12799, '\p{Blk=:\AKatakana_Ext\z:}', "");;
    Expect(0, 12800, '\p{Blk=:\AKatakana_Ext\z:}', "");;
    Expect(1, 12799, '\p{Blk=katakanaext}', "");
    Expect(0, 12799, '\p{^Blk=katakanaext}', "");
    Expect(0, 12799, '\P{Blk=katakanaext}', "");
    Expect(1, 12799, '\P{^Blk=katakanaext}', "");
    Expect(0, 12800, '\p{Blk=katakanaext}', "");
    Expect(1, 12800, '\p{^Blk=katakanaext}', "");
    Expect(1, 12800, '\P{Blk=katakanaext}', "");
    Expect(0, 12800, '\P{^Blk=katakanaext}', "");
    Expect(1, 12799, '\p{Blk=:\Akatakanaext\z:}', "");;
    Expect(0, 12800, '\p{Blk=:\Akatakanaext\z:}', "");;
    Expect(1, 12799, '\p{Blk= 	Katakana_EXT}', "");
    Expect(0, 12799, '\p{^Blk= 	Katakana_EXT}', "");
    Expect(0, 12799, '\P{Blk= 	Katakana_EXT}', "");
    Expect(1, 12799, '\P{^Blk= 	Katakana_EXT}', "");
    Expect(0, 12800, '\p{Blk= 	Katakana_EXT}', "");
    Expect(1, 12800, '\p{^Blk= 	Katakana_EXT}', "");
    Expect(1, 12800, '\P{Blk= 	Katakana_EXT}', "");
    Expect(0, 12800, '\P{^Blk= 	Katakana_EXT}', "");
    Error('\p{Is_Block=_/a/KATAKANA_phonetic_Extensions}');
    Error('\P{Is_Block=_/a/KATAKANA_phonetic_Extensions}');
    Expect(1, 12799, '\p{Is_Block=katakanaphoneticextensions}', "");
    Expect(0, 12799, '\p{^Is_Block=katakanaphoneticextensions}', "");
    Expect(0, 12799, '\P{Is_Block=katakanaphoneticextensions}', "");
    Expect(1, 12799, '\P{^Is_Block=katakanaphoneticextensions}', "");
    Expect(0, 12800, '\p{Is_Block=katakanaphoneticextensions}', "");
    Expect(1, 12800, '\p{^Is_Block=katakanaphoneticextensions}', "");
    Expect(1, 12800, '\P{Is_Block=katakanaphoneticextensions}', "");
    Expect(0, 12800, '\P{^Is_Block=katakanaphoneticextensions}', "");
    Expect(1, 12799, '\p{Is_Block= -KATAKANA_Phonetic_Extensions}', "");
    Expect(0, 12799, '\p{^Is_Block= -KATAKANA_Phonetic_Extensions}', "");
    Expect(0, 12799, '\P{Is_Block= -KATAKANA_Phonetic_Extensions}', "");
    Expect(1, 12799, '\P{^Is_Block= -KATAKANA_Phonetic_Extensions}', "");
    Expect(0, 12800, '\p{Is_Block= -KATAKANA_Phonetic_Extensions}', "");
    Expect(1, 12800, '\p{^Is_Block= -KATAKANA_Phonetic_Extensions}', "");
    Expect(1, 12800, '\P{Is_Block= -KATAKANA_Phonetic_Extensions}', "");
    Expect(0, 12800, '\P{^Is_Block= -KATAKANA_Phonetic_Extensions}', "");
    Error('\p{Is_Blk=KATAKANA_Ext/a/}');
    Error('\P{Is_Blk=KATAKANA_Ext/a/}');
    Expect(1, 12799, '\p{Is_Blk=katakanaext}', "");
    Expect(0, 12799, '\p{^Is_Blk=katakanaext}', "");
    Expect(0, 12799, '\P{Is_Blk=katakanaext}', "");
    Expect(1, 12799, '\P{^Is_Blk=katakanaext}', "");
    Expect(0, 12800, '\p{Is_Blk=katakanaext}', "");
    Expect(1, 12800, '\p{^Is_Blk=katakanaext}', "");
    Expect(1, 12800, '\P{Is_Blk=katakanaext}', "");
    Expect(0, 12800, '\P{^Is_Blk=katakanaext}', "");
    Expect(1, 12799, '\p{Is_Blk=_Katakana_EXT}', "");
    Expect(0, 12799, '\p{^Is_Blk=_Katakana_EXT}', "");
    Expect(0, 12799, '\P{Is_Blk=_Katakana_EXT}', "");
    Expect(1, 12799, '\P{^Is_Blk=_Katakana_EXT}', "");
    Expect(0, 12800, '\p{Is_Blk=_Katakana_EXT}', "");
    Expect(1, 12800, '\p{^Is_Blk=_Katakana_EXT}', "");
    Expect(1, 12800, '\P{Is_Blk=_Katakana_EXT}', "");
    Expect(0, 12800, '\P{^Is_Blk=_Katakana_EXT}', "");
    Error('\p{Block=/a/_	KAWI}');
    Error('\P{Block=/a/_	KAWI}');
    Expect(1, 73567, '\p{Block=:\AKawi\z:}', "");;
    Expect(0, 73568, '\p{Block=:\AKawi\z:}', "");;
    Expect(1, 73567, '\p{Block=kawi}', "");
    Expect(0, 73567, '\p{^Block=kawi}', "");
    Expect(0, 73567, '\P{Block=kawi}', "");
    Expect(1, 73567, '\P{^Block=kawi}', "");
    Expect(0, 73568, '\p{Block=kawi}', "");
    Expect(1, 73568, '\p{^Block=kawi}', "");
    Expect(1, 73568, '\P{Block=kawi}', "");
    Expect(0, 73568, '\P{^Block=kawi}', "");
    Expect(1, 73567, '\p{Block=:\Akawi\z:}', "");;
    Expect(0, 73568, '\p{Block=:\Akawi\z:}', "");;
    Expect(1, 73567, '\p{Block:		-KAWI}', "");
    Expect(0, 73567, '\p{^Block:		-KAWI}', "");
    Expect(0, 73567, '\P{Block:		-KAWI}', "");
    Expect(1, 73567, '\P{^Block:		-KAWI}', "");
    Expect(0, 73568, '\p{Block:		-KAWI}', "");
    Expect(1, 73568, '\p{^Block:		-KAWI}', "");
    Expect(1, 73568, '\P{Block:		-KAWI}', "");
    Expect(0, 73568, '\P{^Block:		-KAWI}', "");
    Error('\p{Blk=-_Kawi/a/}');
    Error('\P{Blk=-_Kawi/a/}');
    Expect(1, 73567, '\p{Blk=:\AKawi\z:}', "");;
    Expect(0, 73568, '\p{Blk=:\AKawi\z:}', "");;
    Expect(1, 73567, '\p{Blk=kawi}', "");
    Expect(0, 73567, '\p{^Blk=kawi}', "");
    Expect(0, 73567, '\P{Blk=kawi}', "");
    Expect(1, 73567, '\P{^Blk=kawi}', "");
    Expect(0, 73568, '\p{Blk=kawi}', "");
    Expect(1, 73568, '\p{^Blk=kawi}', "");
    Expect(1, 73568, '\P{Blk=kawi}', "");
    Expect(0, 73568, '\P{^Blk=kawi}', "");
    Expect(1, 73567, '\p{Blk=:\Akawi\z:}', "");;
    Expect(0, 73568, '\p{Blk=:\Akawi\z:}', "");;
    Expect(1, 73567, '\p{Blk=	-Kawi}', "");
    Expect(0, 73567, '\p{^Blk=	-Kawi}', "");
    Expect(0, 73567, '\P{Blk=	-Kawi}', "");
    Expect(1, 73567, '\P{^Blk=	-Kawi}', "");
    Expect(0, 73568, '\p{Blk=	-Kawi}', "");
    Expect(1, 73568, '\p{^Blk=	-Kawi}', "");
    Expect(1, 73568, '\P{Blk=	-Kawi}', "");
    Expect(0, 73568, '\P{^Blk=	-Kawi}', "");
    Error('\p{Is_Block=:=  Kawi}');
    Error('\P{Is_Block=:=  Kawi}');
    Expect(1, 73567, '\p{Is_Block=kawi}', "");
    Expect(0, 73567, '\p{^Is_Block=kawi}', "");
    Expect(0, 73567, '\P{Is_Block=kawi}', "");
    Expect(1, 73567, '\P{^Is_Block=kawi}', "");
    Expect(0, 73568, '\p{Is_Block=kawi}', "");
    Expect(1, 73568, '\p{^Is_Block=kawi}', "");
    Expect(1, 73568, '\P{Is_Block=kawi}', "");
    Expect(0, 73568, '\P{^Is_Block=kawi}', "");
    Expect(1, 73567, '\p{Is_Block=_	Kawi}', "");
    Expect(0, 73567, '\p{^Is_Block=_	Kawi}', "");
    Expect(0, 73567, '\P{Is_Block=_	Kawi}', "");
    Expect(1, 73567, '\P{^Is_Block=_	Kawi}', "");
    Expect(0, 73568, '\p{Is_Block=_	Kawi}', "");
    Expect(1, 73568, '\p{^Is_Block=_	Kawi}', "");
    Expect(1, 73568, '\P{Is_Block=_	Kawi}', "");
    Expect(0, 73568, '\P{^Is_Block=_	Kawi}', "");
    Error('\p{Is_Blk=/a/	 kawi}');
    Error('\P{Is_Blk=/a/	 kawi}');
    Expect(1, 73567, '\p{Is_Blk=kawi}', "");
    Expect(0, 73567, '\p{^Is_Blk=kawi}', "");
    Expect(0, 73567, '\P{Is_Blk=kawi}', "");
    Expect(1, 73567, '\P{^Is_Blk=kawi}', "");
    Expect(0, 73568, '\p{Is_Blk=kawi}', "");
    Expect(1, 73568, '\p{^Is_Blk=kawi}', "");
    Expect(1, 73568, '\P{Is_Blk=kawi}', "");
    Expect(0, 73568, '\P{^Is_Blk=kawi}', "");
    Expect(1, 73567, '\p{Is_Blk:	-_Kawi}', "");
    Expect(0, 73567, '\p{^Is_Blk:	-_Kawi}', "");
    Expect(0, 73567, '\P{Is_Blk:	-_Kawi}', "");
    Expect(1, 73567, '\P{^Is_Blk:	-_Kawi}', "");
    Expect(0, 73568, '\p{Is_Blk:	-_Kawi}', "");
    Expect(1, 73568, '\p{^Is_Blk:	-_Kawi}', "");
    Expect(1, 73568, '\P{Is_Blk:	-_Kawi}', "");
    Expect(0, 73568, '\P{^Is_Blk:	-_Kawi}', "");
    Error('\p{Block=_ kayah_Li/a/}');
    Error('\P{Block=_ kayah_Li/a/}');
    Expect(1, 43311, '\p{Block=:\AKayah_Li\z:}', "");;
    Expect(0, 43312, '\p{Block=:\AKayah_Li\z:}', "");;
    Expect(1, 43311, '\p{Block:	kayahli}', "");
    Expect(0, 43311, '\p{^Block:	kayahli}', "");
    Expect(0, 43311, '\P{Block:	kayahli}', "");
    Expect(1, 43311, '\P{^Block:	kayahli}', "");
    Expect(0, 43312, '\p{Block:	kayahli}', "");
    Expect(1, 43312, '\p{^Block:	kayahli}', "");
    Expect(1, 43312, '\P{Block:	kayahli}', "");
    Expect(0, 43312, '\P{^Block:	kayahli}', "");
    Expect(1, 43311, '\p{Block=:\Akayahli\z:}', "");;
    Expect(0, 43312, '\p{Block=:\Akayahli\z:}', "");;
    Expect(1, 43311, '\p{Block=Kayah_LI}', "");
    Expect(0, 43311, '\p{^Block=Kayah_LI}', "");
    Expect(0, 43311, '\P{Block=Kayah_LI}', "");
    Expect(1, 43311, '\P{^Block=Kayah_LI}', "");
    Expect(0, 43312, '\p{Block=Kayah_LI}', "");
    Expect(1, 43312, '\p{^Block=Kayah_LI}', "");
    Expect(1, 43312, '\P{Block=Kayah_LI}', "");
    Expect(0, 43312, '\P{^Block=Kayah_LI}', "");
    Error('\p{Blk=:=--KAYAH_li}');
    Error('\P{Blk=:=--KAYAH_li}');
    Expect(1, 43311, '\p{Blk=:\AKayah_Li\z:}', "");;
    Expect(0, 43312, '\p{Blk=:\AKayah_Li\z:}', "");;
    Expect(1, 43311, '\p{Blk=kayahli}', "");
    Expect(0, 43311, '\p{^Blk=kayahli}', "");
    Expect(0, 43311, '\P{Blk=kayahli}', "");
    Expect(1, 43311, '\P{^Blk=kayahli}', "");
    Expect(0, 43312, '\p{Blk=kayahli}', "");
    Expect(1, 43312, '\p{^Blk=kayahli}', "");
    Expect(1, 43312, '\P{Blk=kayahli}', "");
    Expect(0, 43312, '\P{^Blk=kayahli}', "");
    Expect(1, 43311, '\p{Blk=:\Akayahli\z:}', "");;
    Expect(0, 43312, '\p{Blk=:\Akayahli\z:}', "");;
    Expect(1, 43311, '\p{Blk=- KAYAH_li}', "");
    Expect(0, 43311, '\p{^Blk=- KAYAH_li}', "");
    Expect(0, 43311, '\P{Blk=- KAYAH_li}', "");
    Expect(1, 43311, '\P{^Blk=- KAYAH_li}', "");
    Expect(0, 43312, '\p{Blk=- KAYAH_li}', "");
    Expect(1, 43312, '\p{^Blk=- KAYAH_li}', "");
    Expect(1, 43312, '\P{Blk=- KAYAH_li}', "");
    Expect(0, 43312, '\P{^Blk=- KAYAH_li}', "");
    Error('\p{Is_Block=_KAYAH_Li:=}');
    Error('\P{Is_Block=_KAYAH_Li:=}');
    Expect(1, 43311, '\p{Is_Block:	kayahli}', "");
    Expect(0, 43311, '\p{^Is_Block:	kayahli}', "");
    Expect(0, 43311, '\P{Is_Block:	kayahli}', "");
    Expect(1, 43311, '\P{^Is_Block:	kayahli}', "");
    Expect(0, 43312, '\p{Is_Block:	kayahli}', "");
    Expect(1, 43312, '\p{^Is_Block:	kayahli}', "");
    Expect(1, 43312, '\P{Is_Block:	kayahli}', "");
    Expect(0, 43312, '\P{^Is_Block:	kayahli}', "");
    Expect(1, 43311, '\p{Is_Block=	 Kayah_Li}', "");
    Expect(0, 43311, '\p{^Is_Block=	 Kayah_Li}', "");
    Expect(0, 43311, '\P{Is_Block=	 Kayah_Li}', "");
    Expect(1, 43311, '\P{^Is_Block=	 Kayah_Li}', "");
    Expect(0, 43312, '\p{Is_Block=	 Kayah_Li}', "");
    Expect(1, 43312, '\p{^Is_Block=	 Kayah_Li}', "");
    Expect(1, 43312, '\P{Is_Block=	 Kayah_Li}', "");
    Expect(0, 43312, '\P{^Is_Block=	 Kayah_Li}', "");
    Error('\p{Is_Blk=/a/_	Kayah_li}');
    Error('\P{Is_Blk=/a/_	Kayah_li}');
    Expect(1, 43311, '\p{Is_Blk=kayahli}', "");
    Expect(0, 43311, '\p{^Is_Blk=kayahli}', "");
    Expect(0, 43311, '\P{Is_Blk=kayahli}', "");
    Expect(1, 43311, '\P{^Is_Blk=kayahli}', "");
    Expect(0, 43312, '\p{Is_Blk=kayahli}', "");
    Expect(1, 43312, '\p{^Is_Blk=kayahli}', "");
    Expect(1, 43312, '\P{Is_Blk=kayahli}', "");
    Expect(0, 43312, '\P{^Is_Blk=kayahli}', "");
    Expect(1, 43311, '\p{Is_Blk=	Kayah_Li}', "");
    Expect(0, 43311, '\p{^Is_Blk=	Kayah_Li}', "");
    Expect(0, 43311, '\P{Is_Blk=	Kayah_Li}', "");
    Expect(1, 43311, '\P{^Is_Blk=	Kayah_Li}', "");
    Expect(0, 43312, '\p{Is_Blk=	Kayah_Li}', "");
    Expect(1, 43312, '\p{^Is_Blk=	Kayah_Li}', "");
    Expect(1, 43312, '\P{Is_Blk=	Kayah_Li}', "");
    Expect(0, 43312, '\P{^Is_Blk=	Kayah_Li}', "");
    Error('\p{Block:/a/_KHAROSHTHI}');
    Error('\P{Block:/a/_KHAROSHTHI}');
    Expect(1, 68191, '\p{Block=:\AKharoshthi\z:}', "");;
    Expect(0, 68192, '\p{Block=:\AKharoshthi\z:}', "");;
    Expect(1, 68191, '\p{Block=kharoshthi}', "");
    Expect(0, 68191, '\p{^Block=kharoshthi}', "");
    Expect(0, 68191, '\P{Block=kharoshthi}', "");
    Expect(1, 68191, '\P{^Block=kharoshthi}', "");
    Expect(0, 68192, '\p{Block=kharoshthi}', "");
    Expect(1, 68192, '\p{^Block=kharoshthi}', "");
    Expect(1, 68192, '\P{Block=kharoshthi}', "");
    Expect(0, 68192, '\P{^Block=kharoshthi}', "");
    Expect(1, 68191, '\p{Block=:\Akharoshthi\z:}', "");;
    Expect(0, 68192, '\p{Block=:\Akharoshthi\z:}', "");;
    Expect(1, 68191, '\p{Block=-_Kharoshthi}', "");
    Expect(0, 68191, '\p{^Block=-_Kharoshthi}', "");
    Expect(0, 68191, '\P{Block=-_Kharoshthi}', "");
    Expect(1, 68191, '\P{^Block=-_Kharoshthi}', "");
    Expect(0, 68192, '\p{Block=-_Kharoshthi}', "");
    Expect(1, 68192, '\p{^Block=-_Kharoshthi}', "");
    Expect(1, 68192, '\P{Block=-_Kharoshthi}', "");
    Expect(0, 68192, '\P{^Block=-_Kharoshthi}', "");
    Error('\p{Blk=/a/	-KHAROSHTHI}');
    Error('\P{Blk=/a/	-KHAROSHTHI}');
    Expect(1, 68191, '\p{Blk=:\AKharoshthi\z:}', "");;
    Expect(0, 68192, '\p{Blk=:\AKharoshthi\z:}', "");;
    Expect(1, 68191, '\p{Blk:	kharoshthi}', "");
    Expect(0, 68191, '\p{^Blk:	kharoshthi}', "");
    Expect(0, 68191, '\P{Blk:	kharoshthi}', "");
    Expect(1, 68191, '\P{^Blk:	kharoshthi}', "");
    Expect(0, 68192, '\p{Blk:	kharoshthi}', "");
    Expect(1, 68192, '\p{^Blk:	kharoshthi}', "");
    Expect(1, 68192, '\P{Blk:	kharoshthi}', "");
    Expect(0, 68192, '\P{^Blk:	kharoshthi}', "");
    Expect(1, 68191, '\p{Blk=:\Akharoshthi\z:}', "");;
    Expect(0, 68192, '\p{Blk=:\Akharoshthi\z:}', "");;
    Expect(1, 68191, '\p{Blk= 	kharoshthi}', "");
    Expect(0, 68191, '\p{^Blk= 	kharoshthi}', "");
    Expect(0, 68191, '\P{Blk= 	kharoshthi}', "");
    Expect(1, 68191, '\P{^Blk= 	kharoshthi}', "");
    Expect(0, 68192, '\p{Blk= 	kharoshthi}', "");
    Expect(1, 68192, '\p{^Blk= 	kharoshthi}', "");
    Expect(1, 68192, '\P{Blk= 	kharoshthi}', "");
    Expect(0, 68192, '\P{^Blk= 	kharoshthi}', "");
    Error('\p{Is_Block= 	Kharoshthi:=}');
    Error('\P{Is_Block= 	Kharoshthi:=}');
    Expect(1, 68191, '\p{Is_Block=kharoshthi}', "");
    Expect(0, 68191, '\p{^Is_Block=kharoshthi}', "");
    Expect(0, 68191, '\P{Is_Block=kharoshthi}', "");
    Expect(1, 68191, '\P{^Is_Block=kharoshthi}', "");
    Expect(0, 68192, '\p{Is_Block=kharoshthi}', "");
    Expect(1, 68192, '\p{^Is_Block=kharoshthi}', "");
    Expect(1, 68192, '\P{Is_Block=kharoshthi}', "");
    Expect(0, 68192, '\P{^Is_Block=kharoshthi}', "");
    Expect(1, 68191, '\p{Is_Block=_kharoshthi}', "");
    Expect(0, 68191, '\p{^Is_Block=_kharoshthi}', "");
    Expect(0, 68191, '\P{Is_Block=_kharoshthi}', "");
    Expect(1, 68191, '\P{^Is_Block=_kharoshthi}', "");
    Expect(0, 68192, '\p{Is_Block=_kharoshthi}', "");
    Expect(1, 68192, '\p{^Is_Block=_kharoshthi}', "");
    Expect(1, 68192, '\P{Is_Block=_kharoshthi}', "");
    Expect(0, 68192, '\P{^Is_Block=_kharoshthi}', "");
    Error('\p{Is_Blk=  Kharoshthi:=}');
    Error('\P{Is_Blk=  Kharoshthi:=}');
    Expect(1, 68191, '\p{Is_Blk:	kharoshthi}', "");
    Expect(0, 68191, '\p{^Is_Blk:	kharoshthi}', "");
    Expect(0, 68191, '\P{Is_Blk:	kharoshthi}', "");
    Expect(1, 68191, '\P{^Is_Blk:	kharoshthi}', "");
    Expect(0, 68192, '\p{Is_Blk:	kharoshthi}', "");
    Expect(1, 68192, '\p{^Is_Blk:	kharoshthi}', "");
    Expect(1, 68192, '\P{Is_Blk:	kharoshthi}', "");
    Expect(0, 68192, '\P{^Is_Blk:	kharoshthi}', "");
    Expect(1, 68191, '\p{Is_Blk= Kharoshthi}', "");
    Expect(0, 68191, '\p{^Is_Blk= Kharoshthi}', "");
    Expect(0, 68191, '\P{Is_Blk= Kharoshthi}', "");
    Expect(1, 68191, '\P{^Is_Blk= Kharoshthi}', "");
    Expect(0, 68192, '\p{Is_Blk= Kharoshthi}', "");
    Expect(1, 68192, '\p{^Is_Blk= Kharoshthi}', "");
    Expect(1, 68192, '\P{Is_Blk= Kharoshthi}', "");
    Expect(0, 68192, '\P{^Is_Blk= Kharoshthi}', "");
    Error('\p{Block=-	Khitan_small_Script/a/}');
    Error('\P{Block=-	Khitan_small_Script/a/}');
    Expect(1, 101631, '\p{Block=:\AKhitan_Small_Script\z:}', "");;
    Expect(0, 101632, '\p{Block=:\AKhitan_Small_Script\z:}', "");;
    Expect(1, 101631, '\p{Block=khitansmallscript}', "");
    Expect(0, 101631, '\p{^Block=khitansmallscript}', "");
    Expect(0, 101631, '\P{Block=khitansmallscript}', "");
    Expect(1, 101631, '\P{^Block=khitansmallscript}', "");
    Expect(0, 101632, '\p{Block=khitansmallscript}', "");
    Expect(1, 101632, '\p{^Block=khitansmallscript}', "");
    Expect(1, 101632, '\P{Block=khitansmallscript}', "");
    Expect(0, 101632, '\P{^Block=khitansmallscript}', "");
    Expect(1, 101631, '\p{Block=:\Akhitansmallscript\z:}', "");;
    Expect(0, 101632, '\p{Block=:\Akhitansmallscript\z:}', "");;
    Expect(1, 101631, '\p{Block=_khitan_Small_Script}', "");
    Expect(0, 101631, '\p{^Block=_khitan_Small_Script}', "");
    Expect(0, 101631, '\P{Block=_khitan_Small_Script}', "");
    Expect(1, 101631, '\P{^Block=_khitan_Small_Script}', "");
    Expect(0, 101632, '\p{Block=_khitan_Small_Script}', "");
    Expect(1, 101632, '\p{^Block=_khitan_Small_Script}', "");
    Expect(1, 101632, '\P{Block=_khitan_Small_Script}', "");
    Expect(0, 101632, '\P{^Block=_khitan_Small_Script}', "");
    Error('\p{Blk=-:=Khitan_Small_Script}');
    Error('\P{Blk=-:=Khitan_Small_Script}');
    Expect(1, 101631, '\p{Blk=:\AKhitan_Small_Script\z:}', "");;
    Expect(0, 101632, '\p{Blk=:\AKhitan_Small_Script\z:}', "");;
    Expect(1, 101631, '\p{Blk=khitansmallscript}', "");
    Expect(0, 101631, '\p{^Blk=khitansmallscript}', "");
    Expect(0, 101631, '\P{Blk=khitansmallscript}', "");
    Expect(1, 101631, '\P{^Blk=khitansmallscript}', "");
    Expect(0, 101632, '\p{Blk=khitansmallscript}', "");
    Expect(1, 101632, '\p{^Blk=khitansmallscript}', "");
    Expect(1, 101632, '\P{Blk=khitansmallscript}', "");
    Expect(0, 101632, '\P{^Blk=khitansmallscript}', "");
    Expect(1, 101631, '\p{Blk=:\Akhitansmallscript\z:}', "");;
    Expect(0, 101632, '\p{Blk=:\Akhitansmallscript\z:}', "");;
    Expect(1, 101631, '\p{Blk= Khitan_small_SCRIPT}', "");
    Expect(0, 101631, '\p{^Blk= Khitan_small_SCRIPT}', "");
    Expect(0, 101631, '\P{Blk= Khitan_small_SCRIPT}', "");
    Expect(1, 101631, '\P{^Blk= Khitan_small_SCRIPT}', "");
    Expect(0, 101632, '\p{Blk= Khitan_small_SCRIPT}', "");
    Expect(1, 101632, '\p{^Blk= Khitan_small_SCRIPT}', "");
    Expect(1, 101632, '\P{Blk= Khitan_small_SCRIPT}', "");
    Expect(0, 101632, '\P{^Blk= Khitan_small_SCRIPT}', "");
    Error('\p{Is_Block=:=_KHITAN_SMALL_Script}');
    Error('\P{Is_Block=:=_KHITAN_SMALL_Script}');
    Expect(1, 101631, '\p{Is_Block=khitansmallscript}', "");
    Expect(0, 101631, '\p{^Is_Block=khitansmallscript}', "");
    Expect(0, 101631, '\P{Is_Block=khitansmallscript}', "");
    Expect(1, 101631, '\P{^Is_Block=khitansmallscript}', "");
    Expect(0, 101632, '\p{Is_Block=khitansmallscript}', "");
    Expect(1, 101632, '\p{^Is_Block=khitansmallscript}', "");
    Expect(1, 101632, '\P{Is_Block=khitansmallscript}', "");
    Expect(0, 101632, '\P{^Is_Block=khitansmallscript}', "");
    Expect(1, 101631, '\p{Is_Block:	_khitan_Small_script}', "");
    Expect(0, 101631, '\p{^Is_Block:	_khitan_Small_script}', "");
    Expect(0, 101631, '\P{Is_Block:	_khitan_Small_script}', "");
    Expect(1, 101631, '\P{^Is_Block:	_khitan_Small_script}', "");
    Expect(0, 101632, '\p{Is_Block:	_khitan_Small_script}', "");
    Expect(1, 101632, '\p{^Is_Block:	_khitan_Small_script}', "");
    Expect(1, 101632, '\P{Is_Block:	_khitan_Small_script}', "");
    Expect(0, 101632, '\P{^Is_Block:	_khitan_Small_script}', "");
    Error('\p{Is_Blk=:= 	Khitan_small_Script}');
    Error('\P{Is_Blk=:= 	Khitan_small_Script}');
    Expect(1, 101631, '\p{Is_Blk=khitansmallscript}', "");
    Expect(0, 101631, '\p{^Is_Blk=khitansmallscript}', "");
    Expect(0, 101631, '\P{Is_Blk=khitansmallscript}', "");
    Expect(1, 101631, '\P{^Is_Blk=khitansmallscript}', "");
    Expect(0, 101632, '\p{Is_Blk=khitansmallscript}', "");
    Expect(1, 101632, '\p{^Is_Blk=khitansmallscript}', "");
    Expect(1, 101632, '\P{Is_Blk=khitansmallscript}', "");
    Expect(0, 101632, '\P{^Is_Blk=khitansmallscript}', "");
    Expect(1, 101631, '\p{Is_Blk=	_KHITAN_Small_script}', "");
    Expect(0, 101631, '\p{^Is_Blk=	_KHITAN_Small_script}', "");
    Expect(0, 101631, '\P{Is_Blk=	_KHITAN_Small_script}', "");
    Expect(1, 101631, '\P{^Is_Blk=	_KHITAN_Small_script}', "");
    Expect(0, 101632, '\p{Is_Blk=	_KHITAN_Small_script}', "");
    Expect(1, 101632, '\p{^Is_Blk=	_KHITAN_Small_script}', "");
    Expect(1, 101632, '\P{Is_Blk=	_KHITAN_Small_script}', "");
    Expect(0, 101632, '\P{^Is_Blk=	_KHITAN_Small_script}', "");
    Error('\p{Block=_:=khmer}');
    Error('\P{Block=_:=khmer}');
    Expect(1, 6143, '\p{Block=:\AKhmer\z:}', "");;
    Expect(0, 6144, '\p{Block=:\AKhmer\z:}', "");;
    Expect(1, 6143, '\p{Block=khmer}', "");
    Expect(0, 6143, '\p{^Block=khmer}', "");
    Expect(0, 6143, '\P{Block=khmer}', "");
    Expect(1, 6143, '\P{^Block=khmer}', "");
    Expect(0, 6144, '\p{Block=khmer}', "");
    Expect(1, 6144, '\p{^Block=khmer}', "");
    Expect(1, 6144, '\P{Block=khmer}', "");
    Expect(0, 6144, '\P{^Block=khmer}', "");
    Expect(1, 6143, '\p{Block=:\Akhmer\z:}', "");;
    Expect(0, 6144, '\p{Block=:\Akhmer\z:}', "");;
    Expect(1, 6143, '\p{Block=- Khmer}', "");
    Expect(0, 6143, '\p{^Block=- Khmer}', "");
    Expect(0, 6143, '\P{Block=- Khmer}', "");
    Expect(1, 6143, '\P{^Block=- Khmer}', "");
    Expect(0, 6144, '\p{Block=- Khmer}', "");
    Expect(1, 6144, '\p{^Block=- Khmer}', "");
    Expect(1, 6144, '\P{Block=- Khmer}', "");
    Expect(0, 6144, '\P{^Block=- Khmer}', "");
    Error('\p{Blk= /a/khmer}');
    Error('\P{Blk= /a/khmer}');
    Expect(1, 6143, '\p{Blk=:\AKhmer\z:}', "");;
    Expect(0, 6144, '\p{Blk=:\AKhmer\z:}', "");;
    Expect(1, 6143, '\p{Blk=khmer}', "");
    Expect(0, 6143, '\p{^Blk=khmer}', "");
    Expect(0, 6143, '\P{Blk=khmer}', "");
    Expect(1, 6143, '\P{^Blk=khmer}', "");
    Expect(0, 6144, '\p{Blk=khmer}', "");
    Expect(1, 6144, '\p{^Blk=khmer}', "");
    Expect(1, 6144, '\P{Blk=khmer}', "");
    Expect(0, 6144, '\P{^Blk=khmer}', "");
    Expect(1, 6143, '\p{Blk=:\Akhmer\z:}', "");;
    Expect(0, 6144, '\p{Blk=:\Akhmer\z:}', "");;
    Expect(1, 6143, '\p{Blk=-khmer}', "");
    Expect(0, 6143, '\p{^Blk=-khmer}', "");
    Expect(0, 6143, '\P{Blk=-khmer}', "");
    Expect(1, 6143, '\P{^Blk=-khmer}', "");
    Expect(0, 6144, '\p{Blk=-khmer}', "");
    Expect(1, 6144, '\p{^Blk=-khmer}', "");
    Expect(1, 6144, '\P{Blk=-khmer}', "");
    Expect(0, 6144, '\P{^Blk=-khmer}', "");
    Error('\p{Is_Block=	/a/khmer}');
    Error('\P{Is_Block=	/a/khmer}');
    Expect(1, 6143, '\p{Is_Block=khmer}', "");
    Expect(0, 6143, '\p{^Is_Block=khmer}', "");
    Expect(0, 6143, '\P{Is_Block=khmer}', "");
    Expect(1, 6143, '\P{^Is_Block=khmer}', "");
    Expect(0, 6144, '\p{Is_Block=khmer}', "");
    Expect(1, 6144, '\p{^Is_Block=khmer}', "");
    Expect(1, 6144, '\P{Is_Block=khmer}', "");
    Expect(0, 6144, '\P{^Is_Block=khmer}', "");
    Expect(1, 6143, '\p{Is_Block=--Khmer}', "");
    Expect(0, 6143, '\p{^Is_Block=--Khmer}', "");
    Expect(0, 6143, '\P{Is_Block=--Khmer}', "");
    Expect(1, 6143, '\P{^Is_Block=--Khmer}', "");
    Expect(0, 6144, '\p{Is_Block=--Khmer}', "");
    Expect(1, 6144, '\p{^Is_Block=--Khmer}', "");
    Expect(1, 6144, '\P{Is_Block=--Khmer}', "");
    Expect(0, 6144, '\P{^Is_Block=--Khmer}', "");
    Error('\p{Is_Blk=--Khmer/a/}');
    Error('\P{Is_Blk=--Khmer/a/}');
    Expect(1, 6143, '\p{Is_Blk=khmer}', "");
    Expect(0, 6143, '\p{^Is_Blk=khmer}', "");
    Expect(0, 6143, '\P{Is_Blk=khmer}', "");
    Expect(1, 6143, '\P{^Is_Blk=khmer}', "");
    Expect(0, 6144, '\p{Is_Blk=khmer}', "");
    Expect(1, 6144, '\p{^Is_Blk=khmer}', "");
    Expect(1, 6144, '\P{Is_Blk=khmer}', "");
    Expect(0, 6144, '\P{^Is_Blk=khmer}', "");
    Expect(1, 6143, '\p{Is_Blk=-Khmer}', "");
    Expect(0, 6143, '\p{^Is_Blk=-Khmer}', "");
    Expect(0, 6143, '\P{Is_Blk=-Khmer}', "");
    Expect(1, 6143, '\P{^Is_Blk=-Khmer}', "");
    Expect(0, 6144, '\p{Is_Blk=-Khmer}', "");
    Expect(1, 6144, '\p{^Is_Blk=-Khmer}', "");
    Expect(1, 6144, '\P{Is_Blk=-Khmer}', "");
    Expect(0, 6144, '\P{^Is_Blk=-Khmer}', "");
    Error('\p{Block=_:=Khmer_Symbols}');
    Error('\P{Block=_:=Khmer_Symbols}');
    Expect(1, 6655, '\p{Block=:\AKhmer_Symbols\z:}', "");;
    Expect(0, 6656, '\p{Block=:\AKhmer_Symbols\z:}', "");;
    Expect(1, 6655, '\p{Block=khmersymbols}', "");
    Expect(0, 6655, '\p{^Block=khmersymbols}', "");
    Expect(0, 6655, '\P{Block=khmersymbols}', "");
    Expect(1, 6655, '\P{^Block=khmersymbols}', "");
    Expect(0, 6656, '\p{Block=khmersymbols}', "");
    Expect(1, 6656, '\p{^Block=khmersymbols}', "");
    Expect(1, 6656, '\P{Block=khmersymbols}', "");
    Expect(0, 6656, '\P{^Block=khmersymbols}', "");
    Expect(1, 6655, '\p{Block=:\Akhmersymbols\z:}', "");;
    Expect(0, 6656, '\p{Block=:\Akhmersymbols\z:}', "");;
    Expect(1, 6655, '\p{Block=_Khmer_SYMBOLS}', "");
    Expect(0, 6655, '\p{^Block=_Khmer_SYMBOLS}', "");
    Expect(0, 6655, '\P{Block=_Khmer_SYMBOLS}', "");
    Expect(1, 6655, '\P{^Block=_Khmer_SYMBOLS}', "");
    Expect(0, 6656, '\p{Block=_Khmer_SYMBOLS}', "");
    Expect(1, 6656, '\p{^Block=_Khmer_SYMBOLS}', "");
    Expect(1, 6656, '\P{Block=_Khmer_SYMBOLS}', "");
    Expect(0, 6656, '\P{^Block=_Khmer_SYMBOLS}', "");
    Error('\p{Blk=:=_ KHMER_SYMBOLS}');
    Error('\P{Blk=:=_ KHMER_SYMBOLS}');
    Expect(1, 6655, '\p{Blk=:\AKhmer_Symbols\z:}', "");;
    Expect(0, 6656, '\p{Blk=:\AKhmer_Symbols\z:}', "");;
    Expect(1, 6655, '\p{Blk=khmersymbols}', "");
    Expect(0, 6655, '\p{^Blk=khmersymbols}', "");
    Expect(0, 6655, '\P{Blk=khmersymbols}', "");
    Expect(1, 6655, '\P{^Blk=khmersymbols}', "");
    Expect(0, 6656, '\p{Blk=khmersymbols}', "");
    Expect(1, 6656, '\p{^Blk=khmersymbols}', "");
    Expect(1, 6656, '\P{Blk=khmersymbols}', "");
    Expect(0, 6656, '\P{^Blk=khmersymbols}', "");
    Expect(1, 6655, '\p{Blk=:\Akhmersymbols\z:}', "");;
    Expect(0, 6656, '\p{Blk=:\Akhmersymbols\z:}', "");;
    Expect(1, 6655, '\p{Blk:_Khmer_Symbols}', "");
    Expect(0, 6655, '\p{^Blk:_Khmer_Symbols}', "");
    Expect(0, 6655, '\P{Blk:_Khmer_Symbols}', "");
    Expect(1, 6655, '\P{^Blk:_Khmer_Symbols}', "");
    Expect(0, 6656, '\p{Blk:_Khmer_Symbols}', "");
    Expect(1, 6656, '\p{^Blk:_Khmer_Symbols}', "");
    Expect(1, 6656, '\P{Blk:_Khmer_Symbols}', "");
    Expect(0, 6656, '\P{^Blk:_Khmer_Symbols}', "");
    Error('\p{Is_Block=-:=Khmer_Symbols}');
    Error('\P{Is_Block=-:=Khmer_Symbols}');
    Expect(1, 6655, '\p{Is_Block: khmersymbols}', "");
    Expect(0, 6655, '\p{^Is_Block: khmersymbols}', "");
    Expect(0, 6655, '\P{Is_Block: khmersymbols}', "");
    Expect(1, 6655, '\P{^Is_Block: khmersymbols}', "");
    Expect(0, 6656, '\p{Is_Block: khmersymbols}', "");
    Expect(1, 6656, '\p{^Is_Block: khmersymbols}', "");
    Expect(1, 6656, '\P{Is_Block: khmersymbols}', "");
    Expect(0, 6656, '\P{^Is_Block: khmersymbols}', "");
    Expect(1, 6655, '\p{Is_Block=_khmer_symbols}', "");
    Expect(0, 6655, '\p{^Is_Block=_khmer_symbols}', "");
    Expect(0, 6655, '\P{Is_Block=_khmer_symbols}', "");
    Expect(1, 6655, '\P{^Is_Block=_khmer_symbols}', "");
    Expect(0, 6656, '\p{Is_Block=_khmer_symbols}', "");
    Expect(1, 6656, '\p{^Is_Block=_khmer_symbols}', "");
    Expect(1, 6656, '\P{Is_Block=_khmer_symbols}', "");
    Expect(0, 6656, '\P{^Is_Block=_khmer_symbols}', "");
    Error('\p{Is_Blk:   /a/ -KHMER_SYMBOLS}');
    Error('\P{Is_Blk:   /a/ -KHMER_SYMBOLS}');
    Expect(1, 6655, '\p{Is_Blk:khmersymbols}', "");
    Expect(0, 6655, '\p{^Is_Blk:khmersymbols}', "");
    Expect(0, 6655, '\P{Is_Blk:khmersymbols}', "");
    Expect(1, 6655, '\P{^Is_Blk:khmersymbols}', "");
    Expect(0, 6656, '\p{Is_Blk:khmersymbols}', "");
    Expect(1, 6656, '\p{^Is_Blk:khmersymbols}', "");
    Expect(1, 6656, '\P{Is_Blk:khmersymbols}', "");
    Expect(0, 6656, '\P{^Is_Blk:khmersymbols}', "");
    Expect(1, 6655, '\p{Is_Blk:	 Khmer_Symbols}', "");
    Expect(0, 6655, '\p{^Is_Blk:	 Khmer_Symbols}', "");
    Expect(0, 6655, '\P{Is_Blk:	 Khmer_Symbols}', "");
    Expect(1, 6655, '\P{^Is_Blk:	 Khmer_Symbols}', "");
    Expect(0, 6656, '\p{Is_Blk:	 Khmer_Symbols}', "");
    Expect(1, 6656, '\p{^Is_Blk:	 Khmer_Symbols}', "");
    Expect(1, 6656, '\P{Is_Blk:	 Khmer_Symbols}', "");
    Expect(0, 6656, '\P{^Is_Blk:	 Khmer_Symbols}', "");
    Error('\p{Block=-_khojki:=}');
    Error('\P{Block=-_khojki:=}');
    Expect(1, 70223, '\p{Block=:\AKhojki\z:}', "");;
    Expect(0, 70224, '\p{Block=:\AKhojki\z:}', "");;
    Expect(1, 70223, '\p{Block=khojki}', "");
    Expect(0, 70223, '\p{^Block=khojki}', "");
    Expect(0, 70223, '\P{Block=khojki}', "");
    Expect(1, 70223, '\P{^Block=khojki}', "");
    Expect(0, 70224, '\p{Block=khojki}', "");
    Expect(1, 70224, '\p{^Block=khojki}', "");
    Expect(1, 70224, '\P{Block=khojki}', "");
    Expect(0, 70224, '\P{^Block=khojki}', "");
    Expect(1, 70223, '\p{Block=:\Akhojki\z:}', "");;
    Expect(0, 70224, '\p{Block=:\Akhojki\z:}', "");;
    Expect(1, 70223, '\p{Block=- Khojki}', "");
    Expect(0, 70223, '\p{^Block=- Khojki}', "");
    Expect(0, 70223, '\P{Block=- Khojki}', "");
    Expect(1, 70223, '\P{^Block=- Khojki}', "");
    Expect(0, 70224, '\p{Block=- Khojki}', "");
    Expect(1, 70224, '\p{^Block=- Khojki}', "");
    Expect(1, 70224, '\P{Block=- Khojki}', "");
    Expect(0, 70224, '\P{^Block=- Khojki}', "");
    Error('\p{Blk=	 khojki:=}');
    Error('\P{Blk=	 khojki:=}');
    Expect(1, 70223, '\p{Blk=:\AKhojki\z:}', "");;
    Expect(0, 70224, '\p{Blk=:\AKhojki\z:}', "");;
    Expect(1, 70223, '\p{Blk=khojki}', "");
    Expect(0, 70223, '\p{^Blk=khojki}', "");
    Expect(0, 70223, '\P{Blk=khojki}', "");
    Expect(1, 70223, '\P{^Blk=khojki}', "");
    Expect(0, 70224, '\p{Blk=khojki}', "");
    Expect(1, 70224, '\p{^Blk=khojki}', "");
    Expect(1, 70224, '\P{Blk=khojki}', "");
    Expect(0, 70224, '\P{^Blk=khojki}', "");
    Expect(1, 70223, '\p{Blk=:\Akhojki\z:}', "");;
    Expect(0, 70224, '\p{Blk=:\Akhojki\z:}', "");;
    Expect(1, 70223, '\p{Blk=-Khojki}', "");
    Expect(0, 70223, '\p{^Blk=-Khojki}', "");
    Expect(0, 70223, '\P{Blk=-Khojki}', "");
    Expect(1, 70223, '\P{^Blk=-Khojki}', "");
    Expect(0, 70224, '\p{Blk=-Khojki}', "");
    Expect(1, 70224, '\p{^Blk=-Khojki}', "");
    Expect(1, 70224, '\P{Blk=-Khojki}', "");
    Expect(0, 70224, '\P{^Blk=-Khojki}', "");
    Error('\p{Is_Block=:=- Khojki}');
    Error('\P{Is_Block=:=- Khojki}');
    Expect(1, 70223, '\p{Is_Block=khojki}', "");
    Expect(0, 70223, '\p{^Is_Block=khojki}', "");
    Expect(0, 70223, '\P{Is_Block=khojki}', "");
    Expect(1, 70223, '\P{^Is_Block=khojki}', "");
    Expect(0, 70224, '\p{Is_Block=khojki}', "");
    Expect(1, 70224, '\p{^Is_Block=khojki}', "");
    Expect(1, 70224, '\P{Is_Block=khojki}', "");
    Expect(0, 70224, '\P{^Is_Block=khojki}', "");
    Expect(1, 70223, '\p{Is_Block=  Khojki}', "");
    Expect(0, 70223, '\p{^Is_Block=  Khojki}', "");
    Expect(0, 70223, '\P{Is_Block=  Khojki}', "");
    Expect(1, 70223, '\P{^Is_Block=  Khojki}', "");
    Expect(0, 70224, '\p{Is_Block=  Khojki}', "");
    Expect(1, 70224, '\p{^Is_Block=  Khojki}', "");
    Expect(1, 70224, '\P{Is_Block=  Khojki}', "");
    Expect(0, 70224, '\P{^Is_Block=  Khojki}', "");
    Error('\p{Is_Blk:	-_Khojki:=}');
    Error('\P{Is_Blk:	-_Khojki:=}');
    Expect(1, 70223, '\p{Is_Blk=khojki}', "");
    Expect(0, 70223, '\p{^Is_Blk=khojki}', "");
    Expect(0, 70223, '\P{Is_Blk=khojki}', "");
    Expect(1, 70223, '\P{^Is_Blk=khojki}', "");
    Expect(0, 70224, '\p{Is_Blk=khojki}', "");
    Expect(1, 70224, '\p{^Is_Blk=khojki}', "");
    Expect(1, 70224, '\P{Is_Blk=khojki}', "");
    Expect(0, 70224, '\P{^Is_Blk=khojki}', "");
    Expect(1, 70223, '\p{Is_Blk=	Khojki}', "");
    Expect(0, 70223, '\p{^Is_Blk=	Khojki}', "");
    Expect(0, 70223, '\P{Is_Blk=	Khojki}', "");
    Expect(1, 70223, '\P{^Is_Blk=	Khojki}', "");
    Expect(0, 70224, '\p{Is_Blk=	Khojki}', "");
    Expect(1, 70224, '\p{^Is_Blk=	Khojki}', "");
    Expect(1, 70224, '\P{Is_Blk=	Khojki}', "");
    Expect(0, 70224, '\P{^Is_Blk=	Khojki}', "");
    Error('\p{Block=-_khudawadi/a/}');
    Error('\P{Block=-_khudawadi/a/}');
    Expect(1, 70399, '\p{Block=:\AKhudawadi\z:}', "");;
    Expect(0, 70400, '\p{Block=:\AKhudawadi\z:}', "");;
    Expect(1, 70399, '\p{Block: khudawadi}', "");
    Expect(0, 70399, '\p{^Block: khudawadi}', "");
    Expect(0, 70399, '\P{Block: khudawadi}', "");
    Expect(1, 70399, '\P{^Block: khudawadi}', "");
    Expect(0, 70400, '\p{Block: khudawadi}', "");
    Expect(1, 70400, '\p{^Block: khudawadi}', "");
    Expect(1, 70400, '\P{Block: khudawadi}', "");
    Expect(0, 70400, '\P{^Block: khudawadi}', "");
    Expect(1, 70399, '\p{Block=:\Akhudawadi\z:}', "");;
    Expect(0, 70400, '\p{Block=:\Akhudawadi\z:}', "");;
    Expect(1, 70399, '\p{Block=_ khudawadi}', "");
    Expect(0, 70399, '\p{^Block=_ khudawadi}', "");
    Expect(0, 70399, '\P{Block=_ khudawadi}', "");
    Expect(1, 70399, '\P{^Block=_ khudawadi}', "");
    Expect(0, 70400, '\p{Block=_ khudawadi}', "");
    Expect(1, 70400, '\p{^Block=_ khudawadi}', "");
    Expect(1, 70400, '\P{Block=_ khudawadi}', "");
    Expect(0, 70400, '\P{^Block=_ khudawadi}', "");
    Error('\p{Blk:   _ khudawadi/a/}');
    Error('\P{Blk:   _ khudawadi/a/}');
    Expect(1, 70399, '\p{Blk=:\AKhudawadi\z:}', "");;
    Expect(0, 70400, '\p{Blk=:\AKhudawadi\z:}', "");;
    Expect(1, 70399, '\p{Blk=khudawadi}', "");
    Expect(0, 70399, '\p{^Blk=khudawadi}', "");
    Expect(0, 70399, '\P{Blk=khudawadi}', "");
    Expect(1, 70399, '\P{^Blk=khudawadi}', "");
    Expect(0, 70400, '\p{Blk=khudawadi}', "");
    Expect(1, 70400, '\p{^Blk=khudawadi}', "");
    Expect(1, 70400, '\P{Blk=khudawadi}', "");
    Expect(0, 70400, '\P{^Blk=khudawadi}', "");
    Expect(1, 70399, '\p{Blk=:\Akhudawadi\z:}', "");;
    Expect(0, 70400, '\p{Blk=:\Akhudawadi\z:}', "");;
    Expect(1, 70399, '\p{Blk= khudawadi}', "");
    Expect(0, 70399, '\p{^Blk= khudawadi}', "");
    Expect(0, 70399, '\P{Blk= khudawadi}', "");
    Expect(1, 70399, '\P{^Blk= khudawadi}', "");
    Expect(0, 70400, '\p{Blk= khudawadi}', "");
    Expect(1, 70400, '\p{^Blk= khudawadi}', "");
    Expect(1, 70400, '\P{Blk= khudawadi}', "");
    Expect(0, 70400, '\P{^Blk= khudawadi}', "");
    Error('\p{Is_Block=_khudawadi/a/}');
    Error('\P{Is_Block=_khudawadi/a/}');
    Expect(1, 70399, '\p{Is_Block=khudawadi}', "");
    Expect(0, 70399, '\p{^Is_Block=khudawadi}', "");
    Expect(0, 70399, '\P{Is_Block=khudawadi}', "");
    Expect(1, 70399, '\P{^Is_Block=khudawadi}', "");
    Expect(0, 70400, '\p{Is_Block=khudawadi}', "");
    Expect(1, 70400, '\p{^Is_Block=khudawadi}', "");
    Expect(1, 70400, '\P{Is_Block=khudawadi}', "");
    Expect(0, 70400, '\P{^Is_Block=khudawadi}', "");
    Expect(1, 70399, '\p{Is_Block=_KHUDAWADI}', "");
    Expect(0, 70399, '\p{^Is_Block=_KHUDAWADI}', "");
    Expect(0, 70399, '\P{Is_Block=_KHUDAWADI}', "");
    Expect(1, 70399, '\P{^Is_Block=_KHUDAWADI}', "");
    Expect(0, 70400, '\p{Is_Block=_KHUDAWADI}', "");
    Expect(1, 70400, '\p{^Is_Block=_KHUDAWADI}', "");
    Expect(1, 70400, '\P{Is_Block=_KHUDAWADI}', "");
    Expect(0, 70400, '\P{^Is_Block=_KHUDAWADI}', "");
    Error('\p{Is_Blk=:=KHUDAWADI}');
    Error('\P{Is_Blk=:=KHUDAWADI}');
    Expect(1, 70399, '\p{Is_Blk=khudawadi}', "");
    Expect(0, 70399, '\p{^Is_Blk=khudawadi}', "");
    Expect(0, 70399, '\P{Is_Blk=khudawadi}', "");
    Expect(1, 70399, '\P{^Is_Blk=khudawadi}', "");
    Expect(0, 70400, '\p{Is_Blk=khudawadi}', "");
    Expect(1, 70400, '\p{^Is_Blk=khudawadi}', "");
    Expect(1, 70400, '\P{Is_Blk=khudawadi}', "");
    Expect(0, 70400, '\P{^Is_Blk=khudawadi}', "");
    Expect(1, 70399, '\p{Is_Blk=  khudawadi}', "");
    Expect(0, 70399, '\p{^Is_Blk=  khudawadi}', "");
    Expect(0, 70399, '\P{Is_Blk=  khudawadi}', "");
    Expect(1, 70399, '\P{^Is_Blk=  khudawadi}', "");
    Expect(0, 70400, '\p{Is_Blk=  khudawadi}', "");
    Expect(1, 70400, '\p{^Is_Blk=  khudawadi}', "");
    Expect(1, 70400, '\P{Is_Blk=  khudawadi}', "");
    Expect(0, 70400, '\P{^Is_Blk=  khudawadi}', "");
    Error('\p{Block=	_lao/a/}');
    Error('\P{Block=	_lao/a/}');
    Expect(1, 3839, '\p{Block=:\ALao\z:}', "");;
    Expect(0, 3840, '\p{Block=:\ALao\z:}', "");;
    Expect(1, 3839, '\p{Block=lao}', "");
    Expect(0, 3839, '\p{^Block=lao}', "");
    Expect(0, 3839, '\P{Block=lao}', "");
    Expect(1, 3839, '\P{^Block=lao}', "");
    Expect(0, 3840, '\p{Block=lao}', "");
    Expect(1, 3840, '\p{^Block=lao}', "");
    Expect(1, 3840, '\P{Block=lao}', "");
    Expect(0, 3840, '\P{^Block=lao}', "");
    Expect(1, 3839, '\p{Block=:\Alao\z:}', "");;
    Expect(0, 3840, '\p{Block=:\Alao\z:}', "");;
    Expect(1, 3839, '\p{Block=  LAO}', "");
    Expect(0, 3839, '\p{^Block=  LAO}', "");
    Expect(0, 3839, '\P{Block=  LAO}', "");
    Expect(1, 3839, '\P{^Block=  LAO}', "");
    Expect(0, 3840, '\p{Block=  LAO}', "");
    Expect(1, 3840, '\p{^Block=  LAO}', "");
    Expect(1, 3840, '\P{Block=  LAO}', "");
    Expect(0, 3840, '\P{^Block=  LAO}', "");
    Error('\p{Blk=--Lao:=}');
    Error('\P{Blk=--Lao:=}');
    Expect(1, 3839, '\p{Blk=:\ALao\z:}', "");;
    Expect(0, 3840, '\p{Blk=:\ALao\z:}', "");;
    Expect(1, 3839, '\p{Blk=lao}', "");
    Expect(0, 3839, '\p{^Blk=lao}', "");
    Expect(0, 3839, '\P{Blk=lao}', "");
    Expect(1, 3839, '\P{^Blk=lao}', "");
    Expect(0, 3840, '\p{Blk=lao}', "");
    Expect(1, 3840, '\p{^Blk=lao}', "");
    Expect(1, 3840, '\P{Blk=lao}', "");
    Expect(0, 3840, '\P{^Blk=lao}', "");
    Expect(1, 3839, '\p{Blk=:\Alao\z:}', "");;
    Expect(0, 3840, '\p{Blk=:\Alao\z:}', "");;
    Expect(1, 3839, '\p{Blk=-Lao}', "");
    Expect(0, 3839, '\p{^Blk=-Lao}', "");
    Expect(0, 3839, '\P{Blk=-Lao}', "");
    Expect(1, 3839, '\P{^Blk=-Lao}', "");
    Expect(0, 3840, '\p{Blk=-Lao}', "");
    Expect(1, 3840, '\p{^Blk=-Lao}', "");
    Expect(1, 3840, '\P{Blk=-Lao}', "");
    Expect(0, 3840, '\P{^Blk=-Lao}', "");
    Error('\p{Is_Block=-	lao/a/}');
    Error('\P{Is_Block=-	lao/a/}');
    Expect(1, 3839, '\p{Is_Block=lao}', "");
    Expect(0, 3839, '\p{^Is_Block=lao}', "");
    Expect(0, 3839, '\P{Is_Block=lao}', "");
    Expect(1, 3839, '\P{^Is_Block=lao}', "");
    Expect(0, 3840, '\p{Is_Block=lao}', "");
    Expect(1, 3840, '\p{^Is_Block=lao}', "");
    Expect(1, 3840, '\P{Is_Block=lao}', "");
    Expect(0, 3840, '\P{^Is_Block=lao}', "");
    Expect(1, 3839, '\p{Is_Block: 	Lao}', "");
    Expect(0, 3839, '\p{^Is_Block: 	Lao}', "");
    Expect(0, 3839, '\P{Is_Block: 	Lao}', "");
    Expect(1, 3839, '\P{^Is_Block: 	Lao}', "");
    Expect(0, 3840, '\p{Is_Block: 	Lao}', "");
    Expect(1, 3840, '\p{^Is_Block: 	Lao}', "");
    Expect(1, 3840, '\P{Is_Block: 	Lao}', "");
    Expect(0, 3840, '\P{^Is_Block: 	Lao}', "");
    Error('\p{Is_Blk=-/a/lao}');
    Error('\P{Is_Blk=-/a/lao}');
    Expect(1, 3839, '\p{Is_Blk=lao}', "");
    Expect(0, 3839, '\p{^Is_Blk=lao}', "");
    Expect(0, 3839, '\P{Is_Blk=lao}', "");
    Expect(1, 3839, '\P{^Is_Blk=lao}', "");
    Expect(0, 3840, '\p{Is_Blk=lao}', "");
    Expect(1, 3840, '\p{^Is_Blk=lao}', "");
    Expect(1, 3840, '\P{Is_Blk=lao}', "");
    Expect(0, 3840, '\P{^Is_Blk=lao}', "");
    Expect(1, 3839, '\p{Is_Blk: 		lao}', "");
    Expect(0, 3839, '\p{^Is_Blk: 		lao}', "");
    Expect(0, 3839, '\P{Is_Blk: 		lao}', "");
    Expect(1, 3839, '\P{^Is_Blk: 		lao}', "");
    Expect(0, 3840, '\p{Is_Blk: 		lao}', "");
    Expect(1, 3840, '\p{^Is_Blk: 		lao}', "");
    Expect(1, 3840, '\P{Is_Blk: 		lao}', "");
    Expect(0, 3840, '\P{^Is_Blk: 		lao}', "");
    Error('\p{Block=:=latin_1_Supplement}');
    Error('\P{Block=:=latin_1_Supplement}');
    Expect(1, 255, '\p{Block=:\ALatin_1_Supplement\z:}', "");;
    Expect(0, 256, '\p{Block=:\ALatin_1_Supplement\z:}', "");;
    Expect(1, 255, '\p{Block=latin1supplement}', "");
    Expect(0, 255, '\p{^Block=latin1supplement}', "");
    Expect(0, 255, '\P{Block=latin1supplement}', "");
    Expect(1, 255, '\P{^Block=latin1supplement}', "");
    Expect(0, 256, '\p{Block=latin1supplement}', "");
    Expect(1, 256, '\p{^Block=latin1supplement}', "");
    Expect(1, 256, '\P{Block=latin1supplement}', "");
    Expect(0, 256, '\P{^Block=latin1supplement}', "");
    Expect(1, 255, '\p{Block=:\Alatin1supplement\z:}', "");;
    Expect(0, 256, '\p{Block=:\Alatin1supplement\z:}', "");;
    Expect(1, 255, '\p{Block= LATIN_1_SUPPLEMENT}', "");
    Expect(0, 255, '\p{^Block= LATIN_1_SUPPLEMENT}', "");
    Expect(0, 255, '\P{Block= LATIN_1_SUPPLEMENT}', "");
    Expect(1, 255, '\P{^Block= LATIN_1_SUPPLEMENT}', "");
    Expect(0, 256, '\p{Block= LATIN_1_SUPPLEMENT}', "");
    Expect(1, 256, '\p{^Block= LATIN_1_SUPPLEMENT}', "");
    Expect(1, 256, '\P{Block= LATIN_1_SUPPLEMENT}', "");
    Expect(0, 256, '\P{^Block= LATIN_1_SUPPLEMENT}', "");
    Error('\p{Blk=/a/_ latin_1_sup}');
    Error('\P{Blk=/a/_ latin_1_sup}');
    Expect(1, 255, '\p{Blk=:\ALatin_1_Sup\z:}', "");;
    Expect(0, 256, '\p{Blk=:\ALatin_1_Sup\z:}', "");;
    Expect(1, 255, '\p{Blk=latin1sup}', "");
    Expect(0, 255, '\p{^Blk=latin1sup}', "");
    Expect(0, 255, '\P{Blk=latin1sup}', "");
    Expect(1, 255, '\P{^Blk=latin1sup}', "");
    Expect(0, 256, '\p{Blk=latin1sup}', "");
    Expect(1, 256, '\p{^Blk=latin1sup}', "");
    Expect(1, 256, '\P{Blk=latin1sup}', "");
    Expect(0, 256, '\P{^Blk=latin1sup}', "");
    Expect(1, 255, '\p{Blk=:\Alatin1sup\z:}', "");;
    Expect(0, 256, '\p{Blk=:\Alatin1sup\z:}', "");;
    Expect(1, 255, '\p{Blk=latin_1_Sup}', "");
    Expect(0, 255, '\p{^Blk=latin_1_Sup}', "");
    Expect(0, 255, '\P{Blk=latin_1_Sup}', "");
    Expect(1, 255, '\P{^Blk=latin_1_Sup}', "");
    Expect(0, 256, '\p{Blk=latin_1_Sup}', "");
    Expect(1, 256, '\p{^Blk=latin_1_Sup}', "");
    Expect(1, 256, '\P{Blk=latin_1_Sup}', "");
    Expect(0, 256, '\P{^Blk=latin_1_Sup}', "");
    Error('\p{Is_Block=_-LATIN_1:=}');
    Error('\P{Is_Block=_-LATIN_1:=}');
    Expect(1, 255, '\p{Is_Block=latin1}', "");
    Expect(0, 255, '\p{^Is_Block=latin1}', "");
    Expect(0, 255, '\P{Is_Block=latin1}', "");
    Expect(1, 255, '\P{^Is_Block=latin1}', "");
    Expect(0, 256, '\p{Is_Block=latin1}', "");
    Expect(1, 256, '\p{^Is_Block=latin1}', "");
    Expect(1, 256, '\P{Is_Block=latin1}', "");
    Expect(0, 256, '\P{^Is_Block=latin1}', "");
    Expect(1, 255, '\p{Is_Block=Latin_1}', "");
    Expect(0, 255, '\p{^Is_Block=Latin_1}', "");
    Expect(0, 255, '\P{Is_Block=Latin_1}', "");
    Expect(1, 255, '\P{^Is_Block=Latin_1}', "");
    Expect(0, 256, '\p{Is_Block=Latin_1}', "");
    Expect(1, 256, '\p{^Is_Block=Latin_1}', "");
    Expect(1, 256, '\P{Is_Block=Latin_1}', "");
    Expect(0, 256, '\P{^Is_Block=Latin_1}', "");
    Error('\p{Is_Blk=:=latin_1_Supplement}');
    Error('\P{Is_Blk=:=latin_1_Supplement}');
    Expect(1, 255, '\p{Is_Blk=latin1supplement}', "");
    Expect(0, 255, '\p{^Is_Blk=latin1supplement}', "");
    Expect(0, 255, '\P{Is_Blk=latin1supplement}', "");
    Expect(1, 255, '\P{^Is_Blk=latin1supplement}', "");
    Expect(0, 256, '\p{Is_Blk=latin1supplement}', "");
    Expect(1, 256, '\p{^Is_Blk=latin1supplement}', "");
    Expect(1, 256, '\P{Is_Blk=latin1supplement}', "");
    Expect(0, 256, '\P{^Is_Blk=latin1supplement}', "");
    Expect(1, 255, '\p{Is_Blk= 	LATIN_1_Supplement}', "");
    Expect(0, 255, '\p{^Is_Blk= 	LATIN_1_Supplement}', "");
    Expect(0, 255, '\P{Is_Blk= 	LATIN_1_Supplement}', "");
    Expect(1, 255, '\P{^Is_Blk= 	LATIN_1_Supplement}', "");
    Expect(0, 256, '\p{Is_Blk= 	LATIN_1_Supplement}', "");
    Expect(1, 256, '\p{^Is_Blk= 	LATIN_1_Supplement}', "");
    Expect(1, 256, '\P{Is_Blk= 	LATIN_1_Supplement}', "");
    Expect(0, 256, '\P{^Is_Blk= 	LATIN_1_Supplement}', "");
    Error('\p{Block=	/a/Latin_Extended_A}');
    Error('\P{Block=	/a/Latin_Extended_A}');
    Expect(1, 383, '\p{Block=:\ALatin_Extended_A\z:}', "");;
    Expect(0, 384, '\p{Block=:\ALatin_Extended_A\z:}', "");;
    Expect(1, 383, '\p{Block:	latinextendeda}', "");
    Expect(0, 383, '\p{^Block:	latinextendeda}', "");
    Expect(0, 383, '\P{Block:	latinextendeda}', "");
    Expect(1, 383, '\P{^Block:	latinextendeda}', "");
    Expect(0, 384, '\p{Block:	latinextendeda}', "");
    Expect(1, 384, '\p{^Block:	latinextendeda}', "");
    Expect(1, 384, '\P{Block:	latinextendeda}', "");
    Expect(0, 384, '\P{^Block:	latinextendeda}', "");
    Expect(1, 383, '\p{Block=:\Alatinextendeda\z:}', "");;
    Expect(0, 384, '\p{Block=:\Alatinextendeda\z:}', "");;
    Expect(1, 383, '\p{Block= 	Latin_Extended_A}', "");
    Expect(0, 383, '\p{^Block= 	Latin_Extended_A}', "");
    Expect(0, 383, '\P{Block= 	Latin_Extended_A}', "");
    Expect(1, 383, '\P{^Block= 	Latin_Extended_A}', "");
    Expect(0, 384, '\p{Block= 	Latin_Extended_A}', "");
    Expect(1, 384, '\p{^Block= 	Latin_Extended_A}', "");
    Expect(1, 384, '\P{Block= 	Latin_Extended_A}', "");
    Expect(0, 384, '\P{^Block= 	Latin_Extended_A}', "");
    Error('\p{Blk=_:=latin_EXT_a}');
    Error('\P{Blk=_:=latin_EXT_a}');
    Expect(1, 383, '\p{Blk=:\ALatin_Ext_A\z:}', "");;
    Expect(0, 384, '\p{Blk=:\ALatin_Ext_A\z:}', "");;
    Expect(1, 383, '\p{Blk=latinexta}', "");
    Expect(0, 383, '\p{^Blk=latinexta}', "");
    Expect(0, 383, '\P{Blk=latinexta}', "");
    Expect(1, 383, '\P{^Blk=latinexta}', "");
    Expect(0, 384, '\p{Blk=latinexta}', "");
    Expect(1, 384, '\p{^Blk=latinexta}', "");
    Expect(1, 384, '\P{Blk=latinexta}', "");
    Expect(0, 384, '\P{^Blk=latinexta}', "");
    Expect(1, 383, '\p{Blk=:\Alatinexta\z:}', "");;
    Expect(0, 384, '\p{Blk=:\Alatinexta\z:}', "");;
    Expect(1, 383, '\p{Blk=- LATIN_EXT_A}', "");
    Expect(0, 383, '\p{^Blk=- LATIN_EXT_A}', "");
    Expect(0, 383, '\P{Blk=- LATIN_EXT_A}', "");
    Expect(1, 383, '\P{^Blk=- LATIN_EXT_A}', "");
    Expect(0, 384, '\p{Blk=- LATIN_EXT_A}', "");
    Expect(1, 384, '\p{^Blk=- LATIN_EXT_A}', "");
    Expect(1, 384, '\P{Blk=- LATIN_EXT_A}', "");
    Expect(0, 384, '\P{^Blk=- LATIN_EXT_A}', "");
    Error('\p{Is_Block=_Latin_extended_a:=}');
    Error('\P{Is_Block=_Latin_extended_a:=}');
    Expect(1, 383, '\p{Is_Block=latinextendeda}', "");
    Expect(0, 383, '\p{^Is_Block=latinextendeda}', "");
    Expect(0, 383, '\P{Is_Block=latinextendeda}', "");
    Expect(1, 383, '\P{^Is_Block=latinextendeda}', "");
    Expect(0, 384, '\p{Is_Block=latinextendeda}', "");
    Expect(1, 384, '\p{^Is_Block=latinextendeda}', "");
    Expect(1, 384, '\P{Is_Block=latinextendeda}', "");
    Expect(0, 384, '\P{^Is_Block=latinextendeda}', "");
    Expect(1, 383, '\p{Is_Block=_Latin_Extended_A}', "");
    Expect(0, 383, '\p{^Is_Block=_Latin_Extended_A}', "");
    Expect(0, 383, '\P{Is_Block=_Latin_Extended_A}', "");
    Expect(1, 383, '\P{^Is_Block=_Latin_Extended_A}', "");
    Expect(0, 384, '\p{Is_Block=_Latin_Extended_A}', "");
    Expect(1, 384, '\p{^Is_Block=_Latin_Extended_A}', "");
    Expect(1, 384, '\P{Is_Block=_Latin_Extended_A}', "");
    Expect(0, 384, '\P{^Is_Block=_Latin_Extended_A}', "");
    Error('\p{Is_Blk=/a/_	Latin_ext_A}');
    Error('\P{Is_Blk=/a/_	Latin_ext_A}');
    Expect(1, 383, '\p{Is_Blk=latinexta}', "");
    Expect(0, 383, '\p{^Is_Blk=latinexta}', "");
    Expect(0, 383, '\P{Is_Blk=latinexta}', "");
    Expect(1, 383, '\P{^Is_Blk=latinexta}', "");
    Expect(0, 384, '\p{Is_Blk=latinexta}', "");
    Expect(1, 384, '\p{^Is_Blk=latinexta}', "");
    Expect(1, 384, '\P{Is_Blk=latinexta}', "");
    Expect(0, 384, '\P{^Is_Blk=latinexta}', "");
    Expect(1, 383, '\p{Is_Blk= _Latin_Ext_A}', "");
    Expect(0, 383, '\p{^Is_Blk= _Latin_Ext_A}', "");
    Expect(0, 383, '\P{Is_Blk= _Latin_Ext_A}', "");
    Expect(1, 383, '\P{^Is_Blk= _Latin_Ext_A}', "");
    Expect(0, 384, '\p{Is_Blk= _Latin_Ext_A}', "");
    Expect(1, 384, '\p{^Is_Blk= _Latin_Ext_A}', "");
    Expect(1, 384, '\P{Is_Blk= _Latin_Ext_A}', "");
    Expect(0, 384, '\P{^Is_Blk= _Latin_Ext_A}', "");
    Error('\p{Block=	/a/Latin_Extended_Additional}');
    Error('\P{Block=	/a/Latin_Extended_Additional}');
    Expect(1, 7935, '\p{Block=:\ALatin_Extended_Additional\z:}', "");;
    Expect(0, 7936, '\p{Block=:\ALatin_Extended_Additional\z:}', "");;
    Expect(1, 7935, '\p{Block=latinextendedadditional}', "");
    Expect(0, 7935, '\p{^Block=latinextendedadditional}', "");
    Expect(0, 7935, '\P{Block=latinextendedadditional}', "");
    Expect(1, 7935, '\P{^Block=latinextendedadditional}', "");
    Expect(0, 7936, '\p{Block=latinextendedadditional}', "");
    Expect(1, 7936, '\p{^Block=latinextendedadditional}', "");
    Expect(1, 7936, '\P{Block=latinextendedadditional}', "");
    Expect(0, 7936, '\P{^Block=latinextendedadditional}', "");
    Expect(1, 7935, '\p{Block=:\Alatinextendedadditional\z:}', "");;
    Expect(0, 7936, '\p{Block=:\Alatinextendedadditional\z:}', "");;
    Expect(1, 7935, '\p{Block=-latin_EXTENDED_ADDITIONAL}', "");
    Expect(0, 7935, '\p{^Block=-latin_EXTENDED_ADDITIONAL}', "");
    Expect(0, 7935, '\P{Block=-latin_EXTENDED_ADDITIONAL}', "");
    Expect(1, 7935, '\P{^Block=-latin_EXTENDED_ADDITIONAL}', "");
    Expect(0, 7936, '\p{Block=-latin_EXTENDED_ADDITIONAL}', "");
    Expect(1, 7936, '\p{^Block=-latin_EXTENDED_ADDITIONAL}', "");
    Expect(1, 7936, '\P{Block=-latin_EXTENDED_ADDITIONAL}', "");
    Expect(0, 7936, '\P{^Block=-latin_EXTENDED_ADDITIONAL}', "");
    Error('\p{Blk:-	latin_ext_additional:=}');
    Error('\P{Blk:-	latin_ext_additional:=}');
    Expect(1, 7935, '\p{Blk=:\ALatin_Ext_Additional\z:}', "");;
    Expect(0, 7936, '\p{Blk=:\ALatin_Ext_Additional\z:}', "");;
    Expect(1, 7935, '\p{Blk=latinextadditional}', "");
    Expect(0, 7935, '\p{^Blk=latinextadditional}', "");
    Expect(0, 7935, '\P{Blk=latinextadditional}', "");
    Expect(1, 7935, '\P{^Blk=latinextadditional}', "");
    Expect(0, 7936, '\p{Blk=latinextadditional}', "");
    Expect(1, 7936, '\p{^Blk=latinextadditional}', "");
    Expect(1, 7936, '\P{Blk=latinextadditional}', "");
    Expect(0, 7936, '\P{^Blk=latinextadditional}', "");
    Expect(1, 7935, '\p{Blk=:\Alatinextadditional\z:}', "");;
    Expect(0, 7936, '\p{Blk=:\Alatinextadditional\z:}', "");;
    Expect(1, 7935, '\p{Blk=_	Latin_Ext_Additional}', "");
    Expect(0, 7935, '\p{^Blk=_	Latin_Ext_Additional}', "");
    Expect(0, 7935, '\P{Blk=_	Latin_Ext_Additional}', "");
    Expect(1, 7935, '\P{^Blk=_	Latin_Ext_Additional}', "");
    Expect(0, 7936, '\p{Blk=_	Latin_Ext_Additional}', "");
    Expect(1, 7936, '\p{^Blk=_	Latin_Ext_Additional}', "");
    Expect(1, 7936, '\P{Blk=_	Latin_Ext_Additional}', "");
    Expect(0, 7936, '\P{^Blk=_	Latin_Ext_Additional}', "");
    Error('\p{Is_Block=_:=LATIN_EXTENDED_additional}');
    Error('\P{Is_Block=_:=LATIN_EXTENDED_additional}');
    Expect(1, 7935, '\p{Is_Block=latinextendedadditional}', "");
    Expect(0, 7935, '\p{^Is_Block=latinextendedadditional}', "");
    Expect(0, 7935, '\P{Is_Block=latinextendedadditional}', "");
    Expect(1, 7935, '\P{^Is_Block=latinextendedadditional}', "");
    Expect(0, 7936, '\p{Is_Block=latinextendedadditional}', "");
    Expect(1, 7936, '\p{^Is_Block=latinextendedadditional}', "");
    Expect(1, 7936, '\P{Is_Block=latinextendedadditional}', "");
    Expect(0, 7936, '\P{^Is_Block=latinextendedadditional}', "");
    Expect(1, 7935, '\p{Is_Block=- LATIN_EXTENDED_additional}', "");
    Expect(0, 7935, '\p{^Is_Block=- LATIN_EXTENDED_additional}', "");
    Expect(0, 7935, '\P{Is_Block=- LATIN_EXTENDED_additional}', "");
    Expect(1, 7935, '\P{^Is_Block=- LATIN_EXTENDED_additional}', "");
    Expect(0, 7936, '\p{Is_Block=- LATIN_EXTENDED_additional}', "");
    Expect(1, 7936, '\p{^Is_Block=- LATIN_EXTENDED_additional}', "");
    Expect(1, 7936, '\P{Is_Block=- LATIN_EXTENDED_additional}', "");
    Expect(0, 7936, '\P{^Is_Block=- LATIN_EXTENDED_additional}', "");
    Error('\p{Is_Blk:   	/a/latin_ext_Additional}');
    Error('\P{Is_Blk:   	/a/latin_ext_Additional}');
    Expect(1, 7935, '\p{Is_Blk=latinextadditional}', "");
    Expect(0, 7935, '\p{^Is_Blk=latinextadditional}', "");
    Expect(0, 7935, '\P{Is_Blk=latinextadditional}', "");
    Expect(1, 7935, '\P{^Is_Blk=latinextadditional}', "");
    Expect(0, 7936, '\p{Is_Blk=latinextadditional}', "");
    Expect(1, 7936, '\p{^Is_Blk=latinextadditional}', "");
    Expect(1, 7936, '\P{Is_Blk=latinextadditional}', "");
    Expect(0, 7936, '\P{^Is_Blk=latinextadditional}', "");
    Expect(1, 7935, '\p{Is_Blk= -Latin_EXT_ADDITIONAL}', "");
    Expect(0, 7935, '\p{^Is_Blk= -Latin_EXT_ADDITIONAL}', "");
    Expect(0, 7935, '\P{Is_Blk= -Latin_EXT_ADDITIONAL}', "");
    Expect(1, 7935, '\P{^Is_Blk= -Latin_EXT_ADDITIONAL}', "");
    Expect(0, 7936, '\p{Is_Blk= -Latin_EXT_ADDITIONAL}', "");
    Expect(1, 7936, '\p{^Is_Blk= -Latin_EXT_ADDITIONAL}', "");
    Expect(1, 7936, '\P{Is_Blk= -Latin_EXT_ADDITIONAL}', "");
    Expect(0, 7936, '\P{^Is_Blk= -Latin_EXT_ADDITIONAL}', "");
    Error('\p{Block=__Latin_Extended_B:=}');
    Error('\P{Block=__Latin_Extended_B:=}');
    Expect(1, 591, '\p{Block=:\ALatin_Extended_B\z:}', "");;
    Expect(0, 592, '\p{Block=:\ALatin_Extended_B\z:}', "");;
    Expect(1, 591, '\p{Block=latinextendedb}', "");
    Expect(0, 591, '\p{^Block=latinextendedb}', "");
    Expect(0, 591, '\P{Block=latinextendedb}', "");
    Expect(1, 591, '\P{^Block=latinextendedb}', "");
    Expect(0, 592, '\p{Block=latinextendedb}', "");
    Expect(1, 592, '\p{^Block=latinextendedb}', "");
    Expect(1, 592, '\P{Block=latinextendedb}', "");
    Expect(0, 592, '\P{^Block=latinextendedb}', "");
    Expect(1, 591, '\p{Block=:\Alatinextendedb\z:}', "");;
    Expect(0, 592, '\p{Block=:\Alatinextendedb\z:}', "");;
    Expect(1, 591, '\p{Block=_-latin_Extended_b}', "");
    Expect(0, 591, '\p{^Block=_-latin_Extended_b}', "");
    Expect(0, 591, '\P{Block=_-latin_Extended_b}', "");
    Expect(1, 591, '\P{^Block=_-latin_Extended_b}', "");
    Expect(0, 592, '\p{Block=_-latin_Extended_b}', "");
    Expect(1, 592, '\p{^Block=_-latin_Extended_b}', "");
    Expect(1, 592, '\P{Block=_-latin_Extended_b}', "");
    Expect(0, 592, '\P{^Block=_-latin_Extended_b}', "");
    Error('\p{Blk=_	latin_EXT_b:=}');
    Error('\P{Blk=_	latin_EXT_b:=}');
    Expect(1, 591, '\p{Blk=:\ALatin_Ext_B\z:}', "");;
    Expect(0, 592, '\p{Blk=:\ALatin_Ext_B\z:}', "");;
    Expect(1, 591, '\p{Blk=latinextb}', "");
    Expect(0, 591, '\p{^Blk=latinextb}', "");
    Expect(0, 591, '\P{Blk=latinextb}', "");
    Expect(1, 591, '\P{^Blk=latinextb}', "");
    Expect(0, 592, '\p{Blk=latinextb}', "");
    Expect(1, 592, '\p{^Blk=latinextb}', "");
    Expect(1, 592, '\P{Blk=latinextb}', "");
    Expect(0, 592, '\P{^Blk=latinextb}', "");
    Expect(1, 591, '\p{Blk=:\Alatinextb\z:}', "");;
    Expect(0, 592, '\p{Blk=:\Alatinextb\z:}', "");;
    Expect(1, 591, '\p{Blk=	_Latin_Ext_B}', "");
    Expect(0, 591, '\p{^Blk=	_Latin_Ext_B}', "");
    Expect(0, 591, '\P{Blk=	_Latin_Ext_B}', "");
    Expect(1, 591, '\P{^Blk=	_Latin_Ext_B}', "");
    Expect(0, 592, '\p{Blk=	_Latin_Ext_B}', "");
    Expect(1, 592, '\p{^Blk=	_Latin_Ext_B}', "");
    Expect(1, 592, '\P{Blk=	_Latin_Ext_B}', "");
    Expect(0, 592, '\P{^Blk=	_Latin_Ext_B}', "");
    Error('\p{Is_Block=/a/ 	Latin_Extended_B}');
    Error('\P{Is_Block=/a/ 	Latin_Extended_B}');
    Expect(1, 591, '\p{Is_Block=latinextendedb}', "");
    Expect(0, 591, '\p{^Is_Block=latinextendedb}', "");
    Expect(0, 591, '\P{Is_Block=latinextendedb}', "");
    Expect(1, 591, '\P{^Is_Block=latinextendedb}', "");
    Expect(0, 592, '\p{Is_Block=latinextendedb}', "");
    Expect(1, 592, '\p{^Is_Block=latinextendedb}', "");
    Expect(1, 592, '\P{Is_Block=latinextendedb}', "");
    Expect(0, 592, '\P{^Is_Block=latinextendedb}', "");
    Expect(1, 591, '\p{Is_Block=-_LATIN_Extended_B}', "");
    Expect(0, 591, '\p{^Is_Block=-_LATIN_Extended_B}', "");
    Expect(0, 591, '\P{Is_Block=-_LATIN_Extended_B}', "");
    Expect(1, 591, '\P{^Is_Block=-_LATIN_Extended_B}', "");
    Expect(0, 592, '\p{Is_Block=-_LATIN_Extended_B}', "");
    Expect(1, 592, '\p{^Is_Block=-_LATIN_Extended_B}', "");
    Expect(1, 592, '\P{Is_Block=-_LATIN_Extended_B}', "");
    Expect(0, 592, '\P{^Is_Block=-_LATIN_Extended_B}', "");
    Error('\p{Is_Blk:	_:=latin_Ext_B}');
    Error('\P{Is_Blk:	_:=latin_Ext_B}');
    Expect(1, 591, '\p{Is_Blk=latinextb}', "");
    Expect(0, 591, '\p{^Is_Blk=latinextb}', "");
    Expect(0, 591, '\P{Is_Blk=latinextb}', "");
    Expect(1, 591, '\P{^Is_Blk=latinextb}', "");
    Expect(0, 592, '\p{Is_Blk=latinextb}', "");
    Expect(1, 592, '\p{^Is_Blk=latinextb}', "");
    Expect(1, 592, '\P{Is_Blk=latinextb}', "");
    Expect(0, 592, '\P{^Is_Blk=latinextb}', "");
    Expect(1, 591, '\p{Is_Blk= 	Latin_ext_b}', "");
    Expect(0, 591, '\p{^Is_Blk= 	Latin_ext_b}', "");
    Expect(0, 591, '\P{Is_Blk= 	Latin_ext_b}', "");
    Expect(1, 591, '\P{^Is_Blk= 	Latin_ext_b}', "");
    Expect(0, 592, '\p{Is_Blk= 	Latin_ext_b}', "");
    Expect(1, 592, '\p{^Is_Blk= 	Latin_ext_b}', "");
    Expect(1, 592, '\P{Is_Blk= 	Latin_ext_b}', "");
    Expect(0, 592, '\P{^Is_Blk= 	Latin_ext_b}', "");
    Error('\p{Block=/a/latin_EXTENDED_C}');
    Error('\P{Block=/a/latin_EXTENDED_C}');
    Expect(1, 11391, '\p{Block=:\ALatin_Extended_C\z:}', "");;
    Expect(0, 11392, '\p{Block=:\ALatin_Extended_C\z:}', "");;
    Expect(1, 11391, '\p{Block=latinextendedc}', "");
    Expect(0, 11391, '\p{^Block=latinextendedc}', "");
    Expect(0, 11391, '\P{Block=latinextendedc}', "");
    Expect(1, 11391, '\P{^Block=latinextendedc}', "");
    Expect(0, 11392, '\p{Block=latinextendedc}', "");
    Expect(1, 11392, '\p{^Block=latinextendedc}', "");
    Expect(1, 11392, '\P{Block=latinextendedc}', "");
    Expect(0, 11392, '\P{^Block=latinextendedc}', "");
    Expect(1, 11391, '\p{Block=:\Alatinextendedc\z:}', "");;
    Expect(0, 11392, '\p{Block=:\Alatinextendedc\z:}', "");;
    Expect(1, 11391, '\p{Block=	_LATIN_Extended_C}', "");
    Expect(0, 11391, '\p{^Block=	_LATIN_Extended_C}', "");
    Expect(0, 11391, '\P{Block=	_LATIN_Extended_C}', "");
    Expect(1, 11391, '\P{^Block=	_LATIN_Extended_C}', "");
    Expect(0, 11392, '\p{Block=	_LATIN_Extended_C}', "");
    Expect(1, 11392, '\p{^Block=	_LATIN_Extended_C}', "");
    Expect(1, 11392, '\P{Block=	_LATIN_Extended_C}', "");
    Expect(0, 11392, '\P{^Block=	_LATIN_Extended_C}', "");
    Error('\p{Blk=_ latin_Ext_C:=}');
    Error('\P{Blk=_ latin_Ext_C:=}');
    Expect(1, 11391, '\p{Blk=:\ALatin_Ext_C\z:}', "");;
    Expect(0, 11392, '\p{Blk=:\ALatin_Ext_C\z:}', "");;
    Expect(1, 11391, '\p{Blk:   latinextc}', "");
    Expect(0, 11391, '\p{^Blk:   latinextc}', "");
    Expect(0, 11391, '\P{Blk:   latinextc}', "");
    Expect(1, 11391, '\P{^Blk:   latinextc}', "");
    Expect(0, 11392, '\p{Blk:   latinextc}', "");
    Expect(1, 11392, '\p{^Blk:   latinextc}', "");
    Expect(1, 11392, '\P{Blk:   latinextc}', "");
    Expect(0, 11392, '\P{^Blk:   latinextc}', "");
    Expect(1, 11391, '\p{Blk=:\Alatinextc\z:}', "");;
    Expect(0, 11392, '\p{Blk=:\Alatinextc\z:}', "");;
    Expect(1, 11391, '\p{Blk=_ Latin_EXT_C}', "");
    Expect(0, 11391, '\p{^Blk=_ Latin_EXT_C}', "");
    Expect(0, 11391, '\P{Blk=_ Latin_EXT_C}', "");
    Expect(1, 11391, '\P{^Blk=_ Latin_EXT_C}', "");
    Expect(0, 11392, '\p{Blk=_ Latin_EXT_C}', "");
    Expect(1, 11392, '\p{^Blk=_ Latin_EXT_C}', "");
    Expect(1, 11392, '\P{Blk=_ Latin_EXT_C}', "");
    Expect(0, 11392, '\P{^Blk=_ Latin_EXT_C}', "");
    Error('\p{Is_Block:   :=Latin_extended_C}');
    Error('\P{Is_Block:   :=Latin_extended_C}');
    Expect(1, 11391, '\p{Is_Block=latinextendedc}', "");
    Expect(0, 11391, '\p{^Is_Block=latinextendedc}', "");
    Expect(0, 11391, '\P{Is_Block=latinextendedc}', "");
    Expect(1, 11391, '\P{^Is_Block=latinextendedc}', "");
    Expect(0, 11392, '\p{Is_Block=latinextendedc}', "");
    Expect(1, 11392, '\p{^Is_Block=latinextendedc}', "");
    Expect(1, 11392, '\P{Is_Block=latinextendedc}', "");
    Expect(0, 11392, '\P{^Is_Block=latinextendedc}', "");
    Expect(1, 11391, '\p{Is_Block=	-Latin_extended_C}', "");
    Expect(0, 11391, '\p{^Is_Block=	-Latin_extended_C}', "");
    Expect(0, 11391, '\P{Is_Block=	-Latin_extended_C}', "");
    Expect(1, 11391, '\P{^Is_Block=	-Latin_extended_C}', "");
    Expect(0, 11392, '\p{Is_Block=	-Latin_extended_C}', "");
    Expect(1, 11392, '\p{^Is_Block=	-Latin_extended_C}', "");
    Expect(1, 11392, '\P{Is_Block=	-Latin_extended_C}', "");
    Expect(0, 11392, '\P{^Is_Block=	-Latin_extended_C}', "");
    Error('\p{Is_Blk=_/a/latin_Ext_C}');
    Error('\P{Is_Blk=_/a/latin_Ext_C}');
    Expect(1, 11391, '\p{Is_Blk=latinextc}', "");
    Expect(0, 11391, '\p{^Is_Blk=latinextc}', "");
    Expect(0, 11391, '\P{Is_Blk=latinextc}', "");
    Expect(1, 11391, '\P{^Is_Blk=latinextc}', "");
    Expect(0, 11392, '\p{Is_Blk=latinextc}', "");
    Expect(1, 11392, '\p{^Is_Blk=latinextc}', "");
    Expect(1, 11392, '\P{Is_Blk=latinextc}', "");
    Expect(0, 11392, '\P{^Is_Blk=latinextc}', "");
    Expect(1, 11391, '\p{Is_Blk=-_Latin_ext_c}', "");
    Expect(0, 11391, '\p{^Is_Blk=-_Latin_ext_c}', "");
    Expect(0, 11391, '\P{Is_Blk=-_Latin_ext_c}', "");
    Expect(1, 11391, '\P{^Is_Blk=-_Latin_ext_c}', "");
    Expect(0, 11392, '\p{Is_Blk=-_Latin_ext_c}', "");
    Expect(1, 11392, '\p{^Is_Blk=-_Latin_ext_c}', "");
    Expect(1, 11392, '\P{Is_Blk=-_Latin_ext_c}', "");
    Expect(0, 11392, '\P{^Is_Blk=-_Latin_ext_c}', "");
    Error('\p{Block=:=		Latin_Extended_d}');
    Error('\P{Block=:=		Latin_Extended_d}');
    Expect(1, 43007, '\p{Block=:\ALatin_Extended_D\z:}', "");;
    Expect(0, 43008, '\p{Block=:\ALatin_Extended_D\z:}', "");;
    Expect(1, 43007, '\p{Block=latinextendedd}', "");
    Expect(0, 43007, '\p{^Block=latinextendedd}', "");
    Expect(0, 43007, '\P{Block=latinextendedd}', "");
    Expect(1, 43007, '\P{^Block=latinextendedd}', "");
    Expect(0, 43008, '\p{Block=latinextendedd}', "");
    Expect(1, 43008, '\p{^Block=latinextendedd}', "");
    Expect(1, 43008, '\P{Block=latinextendedd}', "");
    Expect(0, 43008, '\P{^Block=latinextendedd}', "");
    Expect(1, 43007, '\p{Block=:\Alatinextendedd\z:}', "");;
    Expect(0, 43008, '\p{Block=:\Alatinextendedd\z:}', "");;
    Expect(1, 43007, '\p{Block=_ latin_Extended_D}', "");
    Expect(0, 43007, '\p{^Block=_ latin_Extended_D}', "");
    Expect(0, 43007, '\P{Block=_ latin_Extended_D}', "");
    Expect(1, 43007, '\P{^Block=_ latin_Extended_D}', "");
    Expect(0, 43008, '\p{Block=_ latin_Extended_D}', "");
    Expect(1, 43008, '\p{^Block=_ latin_Extended_D}', "");
    Expect(1, 43008, '\P{Block=_ latin_Extended_D}', "");
    Expect(0, 43008, '\P{^Block=_ latin_Extended_D}', "");
    Error('\p{Blk:/a/ -LATIN_EXT_D}');
    Error('\P{Blk:/a/ -LATIN_EXT_D}');
    Expect(1, 43007, '\p{Blk=:\ALatin_Ext_D\z:}', "");;
    Expect(0, 43008, '\p{Blk=:\ALatin_Ext_D\z:}', "");;
    Expect(1, 43007, '\p{Blk=latinextd}', "");
    Expect(0, 43007, '\p{^Blk=latinextd}', "");
    Expect(0, 43007, '\P{Blk=latinextd}', "");
    Expect(1, 43007, '\P{^Blk=latinextd}', "");
    Expect(0, 43008, '\p{Blk=latinextd}', "");
    Expect(1, 43008, '\p{^Blk=latinextd}', "");
    Expect(1, 43008, '\P{Blk=latinextd}', "");
    Expect(0, 43008, '\P{^Blk=latinextd}', "");
    Expect(1, 43007, '\p{Blk=:\Alatinextd\z:}', "");;
    Expect(0, 43008, '\p{Blk=:\Alatinextd\z:}', "");;
    Expect(1, 43007, '\p{Blk= Latin_ext_D}', "");
    Expect(0, 43007, '\p{^Blk= Latin_ext_D}', "");
    Expect(0, 43007, '\P{Blk= Latin_ext_D}', "");
    Expect(1, 43007, '\P{^Blk= Latin_ext_D}', "");
    Expect(0, 43008, '\p{Blk= Latin_ext_D}', "");
    Expect(1, 43008, '\p{^Blk= Latin_ext_D}', "");
    Expect(1, 43008, '\P{Blk= Latin_ext_D}', "");
    Expect(0, 43008, '\P{^Blk= Latin_ext_D}', "");
    Error('\p{Is_Block=Latin_extended_D/a/}');
    Error('\P{Is_Block=Latin_extended_D/a/}');
    Expect(1, 43007, '\p{Is_Block=latinextendedd}', "");
    Expect(0, 43007, '\p{^Is_Block=latinextendedd}', "");
    Expect(0, 43007, '\P{Is_Block=latinextendedd}', "");
    Expect(1, 43007, '\P{^Is_Block=latinextendedd}', "");
    Expect(0, 43008, '\p{Is_Block=latinextendedd}', "");
    Expect(1, 43008, '\p{^Is_Block=latinextendedd}', "");
    Expect(1, 43008, '\P{Is_Block=latinextendedd}', "");
    Expect(0, 43008, '\P{^Is_Block=latinextendedd}', "");
    Expect(1, 43007, '\p{Is_Block=_LATIN_extended_D}', "");
    Expect(0, 43007, '\p{^Is_Block=_LATIN_extended_D}', "");
    Expect(0, 43007, '\P{Is_Block=_LATIN_extended_D}', "");
    Expect(1, 43007, '\P{^Is_Block=_LATIN_extended_D}', "");
    Expect(0, 43008, '\p{Is_Block=_LATIN_extended_D}', "");
    Expect(1, 43008, '\p{^Is_Block=_LATIN_extended_D}', "");
    Expect(1, 43008, '\P{Is_Block=_LATIN_extended_D}', "");
    Expect(0, 43008, '\P{^Is_Block=_LATIN_extended_D}', "");
    Error('\p{Is_Blk=  Latin_EXT_D:=}');
    Error('\P{Is_Blk=  Latin_EXT_D:=}');
    Expect(1, 43007, '\p{Is_Blk=latinextd}', "");
    Expect(0, 43007, '\p{^Is_Blk=latinextd}', "");
    Expect(0, 43007, '\P{Is_Blk=latinextd}', "");
    Expect(1, 43007, '\P{^Is_Blk=latinextd}', "");
    Expect(0, 43008, '\p{Is_Blk=latinextd}', "");
    Expect(1, 43008, '\p{^Is_Blk=latinextd}', "");
    Expect(1, 43008, '\P{Is_Blk=latinextd}', "");
    Expect(0, 43008, '\P{^Is_Blk=latinextd}', "");
    Expect(1, 43007, '\p{Is_Blk=-	LATIN_ext_d}', "");
    Expect(0, 43007, '\p{^Is_Blk=-	LATIN_ext_d}', "");
    Expect(0, 43007, '\P{Is_Blk=-	LATIN_ext_d}', "");
    Expect(1, 43007, '\P{^Is_Blk=-	LATIN_ext_d}', "");
    Expect(0, 43008, '\p{Is_Blk=-	LATIN_ext_d}', "");
    Expect(1, 43008, '\p{^Is_Blk=-	LATIN_ext_d}', "");
    Expect(1, 43008, '\P{Is_Blk=-	LATIN_ext_d}', "");
    Expect(0, 43008, '\P{^Is_Blk=-	LATIN_ext_d}', "");
    Error('\p{Block=:= 	LATIN_EXTENDED_E}');
    Error('\P{Block=:= 	LATIN_EXTENDED_E}');
    Expect(1, 43887, '\p{Block=:\ALatin_Extended_E\z:}', "");;
    Expect(0, 43888, '\p{Block=:\ALatin_Extended_E\z:}', "");;
    Expect(1, 43887, '\p{Block=latinextendede}', "");
    Expect(0, 43887, '\p{^Block=latinextendede}', "");
    Expect(0, 43887, '\P{Block=latinextendede}', "");
    Expect(1, 43887, '\P{^Block=latinextendede}', "");
    Expect(0, 43888, '\p{Block=latinextendede}', "");
    Expect(1, 43888, '\p{^Block=latinextendede}', "");
    Expect(1, 43888, '\P{Block=latinextendede}', "");
    Expect(0, 43888, '\P{^Block=latinextendede}', "");
    Expect(1, 43887, '\p{Block=:\Alatinextendede\z:}', "");;
    Expect(0, 43888, '\p{Block=:\Alatinextendede\z:}', "");;
    Expect(1, 43887, '\p{Block=-Latin_Extended_E}', "");
    Expect(0, 43887, '\p{^Block=-Latin_Extended_E}', "");
    Expect(0, 43887, '\P{Block=-Latin_Extended_E}', "");
    Expect(1, 43887, '\P{^Block=-Latin_Extended_E}', "");
    Expect(0, 43888, '\p{Block=-Latin_Extended_E}', "");
    Expect(1, 43888, '\p{^Block=-Latin_Extended_E}', "");
    Expect(1, 43888, '\P{Block=-Latin_Extended_E}', "");
    Expect(0, 43888, '\P{^Block=-Latin_Extended_E}', "");
    Error('\p{Blk=/a/_LATIN_EXT_e}');
    Error('\P{Blk=/a/_LATIN_EXT_e}');
    Expect(1, 43887, '\p{Blk=:\ALatin_Ext_E\z:}', "");;
    Expect(0, 43888, '\p{Blk=:\ALatin_Ext_E\z:}', "");;
    Expect(1, 43887, '\p{Blk=latinexte}', "");
    Expect(0, 43887, '\p{^Blk=latinexte}', "");
    Expect(0, 43887, '\P{Blk=latinexte}', "");
    Expect(1, 43887, '\P{^Blk=latinexte}', "");
    Expect(0, 43888, '\p{Blk=latinexte}', "");
    Expect(1, 43888, '\p{^Blk=latinexte}', "");
    Expect(1, 43888, '\P{Blk=latinexte}', "");
    Expect(0, 43888, '\P{^Blk=latinexte}', "");
    Expect(1, 43887, '\p{Blk=:\Alatinexte\z:}', "");;
    Expect(0, 43888, '\p{Blk=:\Alatinexte\z:}', "");;
    Expect(1, 43887, '\p{Blk=_LATIN_EXT_E}', "");
    Expect(0, 43887, '\p{^Blk=_LATIN_EXT_E}', "");
    Expect(0, 43887, '\P{Blk=_LATIN_EXT_E}', "");
    Expect(1, 43887, '\P{^Blk=_LATIN_EXT_E}', "");
    Expect(0, 43888, '\p{Blk=_LATIN_EXT_E}', "");
    Expect(1, 43888, '\p{^Blk=_LATIN_EXT_E}', "");
    Expect(1, 43888, '\P{Blk=_LATIN_EXT_E}', "");
    Expect(0, 43888, '\P{^Blk=_LATIN_EXT_E}', "");
    Error('\p{Is_Block=/a/		LATIN_extended_E}');
    Error('\P{Is_Block=/a/		LATIN_extended_E}');
    Expect(1, 43887, '\p{Is_Block=latinextendede}', "");
    Expect(0, 43887, '\p{^Is_Block=latinextendede}', "");
    Expect(0, 43887, '\P{Is_Block=latinextendede}', "");
    Expect(1, 43887, '\P{^Is_Block=latinextendede}', "");
    Expect(0, 43888, '\p{Is_Block=latinextendede}', "");
    Expect(1, 43888, '\p{^Is_Block=latinextendede}', "");
    Expect(1, 43888, '\P{Is_Block=latinextendede}', "");
    Expect(0, 43888, '\P{^Is_Block=latinextendede}', "");
    Expect(1, 43887, '\p{Is_Block=_ latin_extended_E}', "");
    Expect(0, 43887, '\p{^Is_Block=_ latin_extended_E}', "");
    Expect(0, 43887, '\P{Is_Block=_ latin_extended_E}', "");
    Expect(1, 43887, '\P{^Is_Block=_ latin_extended_E}', "");
    Expect(0, 43888, '\p{Is_Block=_ latin_extended_E}', "");
    Expect(1, 43888, '\p{^Is_Block=_ latin_extended_E}', "");
    Expect(1, 43888, '\P{Is_Block=_ latin_extended_E}', "");
    Expect(0, 43888, '\P{^Is_Block=_ latin_extended_E}', "");
    Error('\p{Is_Blk=/a/-Latin_ext_E}');
    Error('\P{Is_Blk=/a/-Latin_ext_E}');
    Expect(1, 43887, '\p{Is_Blk=latinexte}', "");
    Expect(0, 43887, '\p{^Is_Blk=latinexte}', "");
    Expect(0, 43887, '\P{Is_Blk=latinexte}', "");
    Expect(1, 43887, '\P{^Is_Blk=latinexte}', "");
    Expect(0, 43888, '\p{Is_Blk=latinexte}', "");
    Expect(1, 43888, '\p{^Is_Blk=latinexte}', "");
    Expect(1, 43888, '\P{Is_Blk=latinexte}', "");
    Expect(0, 43888, '\P{^Is_Blk=latinexte}', "");
    Expect(1, 43887, '\p{Is_Blk=Latin_EXT_E}', "");
    Expect(0, 43887, '\p{^Is_Blk=Latin_EXT_E}', "");
    Expect(0, 43887, '\P{Is_Blk=Latin_EXT_E}', "");
    Expect(1, 43887, '\P{^Is_Blk=Latin_EXT_E}', "");
    Expect(0, 43888, '\p{Is_Blk=Latin_EXT_E}', "");
    Expect(1, 43888, '\p{^Is_Blk=Latin_EXT_E}', "");
    Expect(1, 43888, '\P{Is_Blk=Latin_EXT_E}', "");
    Expect(0, 43888, '\P{^Is_Blk=Latin_EXT_E}', "");
    Error('\p{Block=/a/-	LATIN_extended_F}');
    Error('\P{Block=/a/-	LATIN_extended_F}');
    Expect(1, 67519, '\p{Block=:\ALatin_Extended_F\z:}', "");;
    Expect(0, 67520, '\p{Block=:\ALatin_Extended_F\z:}', "");;
    Expect(1, 67519, '\p{Block=latinextendedf}', "");
    Expect(0, 67519, '\p{^Block=latinextendedf}', "");
    Expect(0, 67519, '\P{Block=latinextendedf}', "");
    Expect(1, 67519, '\P{^Block=latinextendedf}', "");
    Expect(0, 67520, '\p{Block=latinextendedf}', "");
    Expect(1, 67520, '\p{^Block=latinextendedf}', "");
    Expect(1, 67520, '\P{Block=latinextendedf}', "");
    Expect(0, 67520, '\P{^Block=latinextendedf}', "");
    Expect(1, 67519, '\p{Block=:\Alatinextendedf\z:}', "");;
    Expect(0, 67520, '\p{Block=:\Alatinextendedf\z:}', "");;
    Expect(1, 67519, '\p{Block= _Latin_Extended_f}', "");
    Expect(0, 67519, '\p{^Block= _Latin_Extended_f}', "");
    Expect(0, 67519, '\P{Block= _Latin_Extended_f}', "");
    Expect(1, 67519, '\P{^Block= _Latin_Extended_f}', "");
    Expect(0, 67520, '\p{Block= _Latin_Extended_f}', "");
    Expect(1, 67520, '\p{^Block= _Latin_Extended_f}', "");
    Expect(1, 67520, '\P{Block= _Latin_Extended_f}', "");
    Expect(0, 67520, '\P{^Block= _Latin_Extended_f}', "");
    Error('\p{Blk=	_Latin_ext_f:=}');
    Error('\P{Blk=	_Latin_ext_f:=}');
    Expect(1, 67519, '\p{Blk=:\ALatin_Ext_F\z:}', "");;
    Expect(0, 67520, '\p{Blk=:\ALatin_Ext_F\z:}', "");;
    Expect(1, 67519, '\p{Blk:   latinextf}', "");
    Expect(0, 67519, '\p{^Blk:   latinextf}', "");
    Expect(0, 67519, '\P{Blk:   latinextf}', "");
    Expect(1, 67519, '\P{^Blk:   latinextf}', "");
    Expect(0, 67520, '\p{Blk:   latinextf}', "");
    Expect(1, 67520, '\p{^Blk:   latinextf}', "");
    Expect(1, 67520, '\P{Blk:   latinextf}', "");
    Expect(0, 67520, '\P{^Blk:   latinextf}', "");
    Expect(1, 67519, '\p{Blk=:\Alatinextf\z:}', "");;
    Expect(0, 67520, '\p{Blk=:\Alatinextf\z:}', "");;
    Expect(1, 67519, '\p{Blk= 	latin_Ext_F}', "");
    Expect(0, 67519, '\p{^Blk= 	latin_Ext_F}', "");
    Expect(0, 67519, '\P{Blk= 	latin_Ext_F}', "");
    Expect(1, 67519, '\P{^Blk= 	latin_Ext_F}', "");
    Expect(0, 67520, '\p{Blk= 	latin_Ext_F}', "");
    Expect(1, 67520, '\p{^Blk= 	latin_Ext_F}', "");
    Expect(1, 67520, '\P{Blk= 	latin_Ext_F}', "");
    Expect(0, 67520, '\P{^Blk= 	latin_Ext_F}', "");
    Error('\p{Is_Block: --LATIN_Extended_F:=}');
    Error('\P{Is_Block: --LATIN_Extended_F:=}');
    Expect(1, 67519, '\p{Is_Block=latinextendedf}', "");
    Expect(0, 67519, '\p{^Is_Block=latinextendedf}', "");
    Expect(0, 67519, '\P{Is_Block=latinextendedf}', "");
    Expect(1, 67519, '\P{^Is_Block=latinextendedf}', "");
    Expect(0, 67520, '\p{Is_Block=latinextendedf}', "");
    Expect(1, 67520, '\p{^Is_Block=latinextendedf}', "");
    Expect(1, 67520, '\P{Is_Block=latinextendedf}', "");
    Expect(0, 67520, '\P{^Is_Block=latinextendedf}', "");
    Expect(1, 67519, '\p{Is_Block= 	Latin_Extended_F}', "");
    Expect(0, 67519, '\p{^Is_Block= 	Latin_Extended_F}', "");
    Expect(0, 67519, '\P{Is_Block= 	Latin_Extended_F}', "");
    Expect(1, 67519, '\P{^Is_Block= 	Latin_Extended_F}', "");
    Expect(0, 67520, '\p{Is_Block= 	Latin_Extended_F}', "");
    Expect(1, 67520, '\p{^Is_Block= 	Latin_Extended_F}', "");
    Expect(1, 67520, '\P{Is_Block= 	Latin_Extended_F}', "");
    Expect(0, 67520, '\P{^Is_Block= 	Latin_Extended_F}', "");
    Error('\p{Is_Blk= Latin_Ext_F:=}');
    Error('\P{Is_Blk= Latin_Ext_F:=}');
    Expect(1, 67519, '\p{Is_Blk=latinextf}', "");
    Expect(0, 67519, '\p{^Is_Blk=latinextf}', "");
    Expect(0, 67519, '\P{Is_Blk=latinextf}', "");
    Expect(1, 67519, '\P{^Is_Blk=latinextf}', "");
    Expect(0, 67520, '\p{Is_Blk=latinextf}', "");
    Expect(1, 67520, '\p{^Is_Blk=latinextf}', "");
    Expect(1, 67520, '\P{Is_Blk=latinextf}', "");
    Expect(0, 67520, '\P{^Is_Blk=latinextf}', "");
    Expect(1, 67519, '\p{Is_Blk=_	Latin_EXT_F}', "");
    Expect(0, 67519, '\p{^Is_Blk=_	Latin_EXT_F}', "");
    Expect(0, 67519, '\P{Is_Blk=_	Latin_EXT_F}', "");
    Expect(1, 67519, '\P{^Is_Blk=_	Latin_EXT_F}', "");
    Expect(0, 67520, '\p{Is_Blk=_	Latin_EXT_F}', "");
    Expect(1, 67520, '\p{^Is_Blk=_	Latin_EXT_F}', "");
    Expect(1, 67520, '\P{Is_Blk=_	Latin_EXT_F}', "");
    Expect(0, 67520, '\P{^Is_Blk=_	Latin_EXT_F}', "");
    Error('\p{Block= -LATIN_EXTENDED_G:=}');
    Error('\P{Block= -LATIN_EXTENDED_G:=}');
    Expect(1, 122879, '\p{Block=:\ALatin_Extended_G\z:}', "");;
    Expect(0, 122880, '\p{Block=:\ALatin_Extended_G\z:}', "");;
    Expect(1, 122879, '\p{Block=latinextendedg}', "");
    Expect(0, 122879, '\p{^Block=latinextendedg}', "");
    Expect(0, 122879, '\P{Block=latinextendedg}', "");
    Expect(1, 122879, '\P{^Block=latinextendedg}', "");
    Expect(0, 122880, '\p{Block=latinextendedg}', "");
    Expect(1, 122880, '\p{^Block=latinextendedg}', "");
    Expect(1, 122880, '\P{Block=latinextendedg}', "");
    Expect(0, 122880, '\P{^Block=latinextendedg}', "");
    Expect(1, 122879, '\p{Block=:\Alatinextendedg\z:}', "");;
    Expect(0, 122880, '\p{Block=:\Alatinextendedg\z:}', "");;
    Expect(1, 122879, '\p{Block=-LATIN_Extended_G}', "");
    Expect(0, 122879, '\p{^Block=-LATIN_Extended_G}', "");
    Expect(0, 122879, '\P{Block=-LATIN_Extended_G}', "");
    Expect(1, 122879, '\P{^Block=-LATIN_Extended_G}', "");
    Expect(0, 122880, '\p{Block=-LATIN_Extended_G}', "");
    Expect(1, 122880, '\p{^Block=-LATIN_Extended_G}', "");
    Expect(1, 122880, '\P{Block=-LATIN_Extended_G}', "");
    Expect(0, 122880, '\P{^Block=-LATIN_Extended_G}', "");
    Error('\p{Blk:   latin_Ext_G/a/}');
    Error('\P{Blk:   latin_Ext_G/a/}');
    Expect(1, 122879, '\p{Blk=:\ALatin_Ext_G\z:}', "");;
    Expect(0, 122880, '\p{Blk=:\ALatin_Ext_G\z:}', "");;
    Expect(1, 122879, '\p{Blk=latinextg}', "");
    Expect(0, 122879, '\p{^Blk=latinextg}', "");
    Expect(0, 122879, '\P{Blk=latinextg}', "");
    Expect(1, 122879, '\P{^Blk=latinextg}', "");
    Expect(0, 122880, '\p{Blk=latinextg}', "");
    Expect(1, 122880, '\p{^Blk=latinextg}', "");
    Expect(1, 122880, '\P{Blk=latinextg}', "");
    Expect(0, 122880, '\P{^Blk=latinextg}', "");
    Expect(1, 122879, '\p{Blk=:\Alatinextg\z:}', "");;
    Expect(0, 122880, '\p{Blk=:\Alatinextg\z:}', "");;
    Expect(1, 122879, '\p{Blk=--LATIN_Ext_G}', "");
    Expect(0, 122879, '\p{^Blk=--LATIN_Ext_G}', "");
    Expect(0, 122879, '\P{Blk=--LATIN_Ext_G}', "");
    Expect(1, 122879, '\P{^Blk=--LATIN_Ext_G}', "");
    Expect(0, 122880, '\p{Blk=--LATIN_Ext_G}', "");
    Expect(1, 122880, '\p{^Blk=--LATIN_Ext_G}', "");
    Expect(1, 122880, '\P{Blk=--LATIN_Ext_G}', "");
    Expect(0, 122880, '\P{^Blk=--LATIN_Ext_G}', "");
    Error('\p{Is_Block=-	LATIN_EXTENDED_G:=}');
    Error('\P{Is_Block=-	LATIN_EXTENDED_G:=}');
    Expect(1, 122879, '\p{Is_Block=latinextendedg}', "");
    Expect(0, 122879, '\p{^Is_Block=latinextendedg}', "");
    Expect(0, 122879, '\P{Is_Block=latinextendedg}', "");
    Expect(1, 122879, '\P{^Is_Block=latinextendedg}', "");
    Expect(0, 122880, '\p{Is_Block=latinextendedg}', "");
    Expect(1, 122880, '\p{^Is_Block=latinextendedg}', "");
    Expect(1, 122880, '\P{Is_Block=latinextendedg}', "");
    Expect(0, 122880, '\P{^Is_Block=latinextendedg}', "");
    Expect(1, 122879, '\p{Is_Block= 	Latin_EXTENDED_G}', "");
    Expect(0, 122879, '\p{^Is_Block= 	Latin_EXTENDED_G}', "");
    Expect(0, 122879, '\P{Is_Block= 	Latin_EXTENDED_G}', "");
    Expect(1, 122879, '\P{^Is_Block= 	Latin_EXTENDED_G}', "");
    Expect(0, 122880, '\p{Is_Block= 	Latin_EXTENDED_G}', "");
    Expect(1, 122880, '\p{^Is_Block= 	Latin_EXTENDED_G}', "");
    Expect(1, 122880, '\P{Is_Block= 	Latin_EXTENDED_G}', "");
    Expect(0, 122880, '\P{^Is_Block= 	Latin_EXTENDED_G}', "");
    Error('\p{Is_Blk=	_LATIN_ext_G/a/}');
    Error('\P{Is_Blk=	_LATIN_ext_G/a/}');
    Expect(1, 122879, '\p{Is_Blk=latinextg}', "");
    Expect(0, 122879, '\p{^Is_Blk=latinextg}', "");
    Expect(0, 122879, '\P{Is_Blk=latinextg}', "");
    Expect(1, 122879, '\P{^Is_Blk=latinextg}', "");
    Expect(0, 122880, '\p{Is_Blk=latinextg}', "");
    Expect(1, 122880, '\p{^Is_Blk=latinextg}', "");
    Expect(1, 122880, '\P{Is_Blk=latinextg}', "");
    Expect(0, 122880, '\P{^Is_Blk=latinextg}', "");
    Expect(1, 122879, '\p{Is_Blk=_	Latin_EXT_G}', "");
    Expect(0, 122879, '\p{^Is_Blk=_	Latin_EXT_G}', "");
    Expect(0, 122879, '\P{Is_Blk=_	Latin_EXT_G}', "");
    Expect(1, 122879, '\P{^Is_Blk=_	Latin_EXT_G}', "");
    Expect(0, 122880, '\p{Is_Blk=_	Latin_EXT_G}', "");
    Expect(1, 122880, '\p{^Is_Blk=_	Latin_EXT_G}', "");
    Expect(1, 122880, '\P{Is_Blk=_	Latin_EXT_G}', "");
    Expect(0, 122880, '\P{^Is_Blk=_	Latin_EXT_G}', "");
    Error('\p{Block=/a/LEPCHA}');
    Error('\P{Block=/a/LEPCHA}');
    Expect(1, 7247, '\p{Block=:\ALepcha\z:}', "");;
    Expect(0, 7248, '\p{Block=:\ALepcha\z:}', "");;
    Expect(1, 7247, '\p{Block=lepcha}', "");
    Expect(0, 7247, '\p{^Block=lepcha}', "");
    Expect(0, 7247, '\P{Block=lepcha}', "");
    Expect(1, 7247, '\P{^Block=lepcha}', "");
    Expect(0, 7248, '\p{Block=lepcha}', "");
    Expect(1, 7248, '\p{^Block=lepcha}', "");
    Expect(1, 7248, '\P{Block=lepcha}', "");
    Expect(0, 7248, '\P{^Block=lepcha}', "");
    Expect(1, 7247, '\p{Block=:\Alepcha\z:}', "");;
    Expect(0, 7248, '\p{Block=:\Alepcha\z:}', "");;
    Expect(1, 7247, '\p{Block=  Lepcha}', "");
    Expect(0, 7247, '\p{^Block=  Lepcha}', "");
    Expect(0, 7247, '\P{Block=  Lepcha}', "");
    Expect(1, 7247, '\P{^Block=  Lepcha}', "");
    Expect(0, 7248, '\p{Block=  Lepcha}', "");
    Expect(1, 7248, '\p{^Block=  Lepcha}', "");
    Expect(1, 7248, '\P{Block=  Lepcha}', "");
    Expect(0, 7248, '\P{^Block=  Lepcha}', "");
    Error('\p{Blk=/a/ Lepcha}');
    Error('\P{Blk=/a/ Lepcha}');
    Expect(1, 7247, '\p{Blk=:\ALepcha\z:}', "");;
    Expect(0, 7248, '\p{Blk=:\ALepcha\z:}', "");;
    Expect(1, 7247, '\p{Blk:   lepcha}', "");
    Expect(0, 7247, '\p{^Blk:   lepcha}', "");
    Expect(0, 7247, '\P{Blk:   lepcha}', "");
    Expect(1, 7247, '\P{^Blk:   lepcha}', "");
    Expect(0, 7248, '\p{Blk:   lepcha}', "");
    Expect(1, 7248, '\p{^Blk:   lepcha}', "");
    Expect(1, 7248, '\P{Blk:   lepcha}', "");
    Expect(0, 7248, '\P{^Blk:   lepcha}', "");
    Expect(1, 7247, '\p{Blk=:\Alepcha\z:}', "");;
    Expect(0, 7248, '\p{Blk=:\Alepcha\z:}', "");;
    Expect(1, 7247, '\p{Blk=_lepcha}', "");
    Expect(0, 7247, '\p{^Blk=_lepcha}', "");
    Expect(0, 7247, '\P{Blk=_lepcha}', "");
    Expect(1, 7247, '\P{^Blk=_lepcha}', "");
    Expect(0, 7248, '\p{Blk=_lepcha}', "");
    Expect(1, 7248, '\p{^Blk=_lepcha}', "");
    Expect(1, 7248, '\P{Blk=_lepcha}', "");
    Expect(0, 7248, '\P{^Blk=_lepcha}', "");
    Error('\p{Is_Block= _LEPCHA:=}');
    Error('\P{Is_Block= _LEPCHA:=}');
    Expect(1, 7247, '\p{Is_Block=lepcha}', "");
    Expect(0, 7247, '\p{^Is_Block=lepcha}', "");
    Expect(0, 7247, '\P{Is_Block=lepcha}', "");
    Expect(1, 7247, '\P{^Is_Block=lepcha}', "");
    Expect(0, 7248, '\p{Is_Block=lepcha}', "");
    Expect(1, 7248, '\p{^Is_Block=lepcha}', "");
    Expect(1, 7248, '\P{Is_Block=lepcha}', "");
    Expect(0, 7248, '\P{^Is_Block=lepcha}', "");
    Expect(1, 7247, '\p{Is_Block=LEPCHA}', "");
    Expect(0, 7247, '\p{^Is_Block=LEPCHA}', "");
    Expect(0, 7247, '\P{Is_Block=LEPCHA}', "");
    Expect(1, 7247, '\P{^Is_Block=LEPCHA}', "");
    Expect(0, 7248, '\p{Is_Block=LEPCHA}', "");
    Expect(1, 7248, '\p{^Is_Block=LEPCHA}', "");
    Expect(1, 7248, '\P{Is_Block=LEPCHA}', "");
    Expect(0, 7248, '\P{^Is_Block=LEPCHA}', "");
    Error('\p{Is_Blk=  Lepcha:=}');
    Error('\P{Is_Blk=  Lepcha:=}');
    Expect(1, 7247, '\p{Is_Blk=lepcha}', "");
    Expect(0, 7247, '\p{^Is_Blk=lepcha}', "");
    Expect(0, 7247, '\P{Is_Blk=lepcha}', "");
    Expect(1, 7247, '\P{^Is_Blk=lepcha}', "");
    Expect(0, 7248, '\p{Is_Blk=lepcha}', "");
    Expect(1, 7248, '\p{^Is_Blk=lepcha}', "");
    Expect(1, 7248, '\P{Is_Blk=lepcha}', "");
    Expect(0, 7248, '\P{^Is_Blk=lepcha}', "");
    Expect(1, 7247, '\p{Is_Blk=_-Lepcha}', "");
    Expect(0, 7247, '\p{^Is_Blk=_-Lepcha}', "");
    Expect(0, 7247, '\P{Is_Blk=_-Lepcha}', "");
    Expect(1, 7247, '\P{^Is_Blk=_-Lepcha}', "");
    Expect(0, 7248, '\p{Is_Blk=_-Lepcha}', "");
    Expect(1, 7248, '\p{^Is_Blk=_-Lepcha}', "");
    Expect(1, 7248, '\P{Is_Blk=_-Lepcha}', "");
    Expect(0, 7248, '\P{^Is_Blk=_-Lepcha}', "");
    Error('\p{Block=:= -Letterlike_SYMBOLS}');
    Error('\P{Block=:= -Letterlike_SYMBOLS}');
    Expect(1, 8527, '\p{Block=:\ALetterlike_Symbols\z:}', "");;
    Expect(0, 8528, '\p{Block=:\ALetterlike_Symbols\z:}', "");;
    Expect(1, 8527, '\p{Block=letterlikesymbols}', "");
    Expect(0, 8527, '\p{^Block=letterlikesymbols}', "");
    Expect(0, 8527, '\P{Block=letterlikesymbols}', "");
    Expect(1, 8527, '\P{^Block=letterlikesymbols}', "");
    Expect(0, 8528, '\p{Block=letterlikesymbols}', "");
    Expect(1, 8528, '\p{^Block=letterlikesymbols}', "");
    Expect(1, 8528, '\P{Block=letterlikesymbols}', "");
    Expect(0, 8528, '\P{^Block=letterlikesymbols}', "");
    Expect(1, 8527, '\p{Block=:\Aletterlikesymbols\z:}', "");;
    Expect(0, 8528, '\p{Block=:\Aletterlikesymbols\z:}', "");;
    Expect(1, 8527, '\p{Block=__Letterlike_Symbols}', "");
    Expect(0, 8527, '\p{^Block=__Letterlike_Symbols}', "");
    Expect(0, 8527, '\P{Block=__Letterlike_Symbols}', "");
    Expect(1, 8527, '\P{^Block=__Letterlike_Symbols}', "");
    Expect(0, 8528, '\p{Block=__Letterlike_Symbols}', "");
    Expect(1, 8528, '\p{^Block=__Letterlike_Symbols}', "");
    Expect(1, 8528, '\P{Block=__Letterlike_Symbols}', "");
    Expect(0, 8528, '\P{^Block=__Letterlike_Symbols}', "");
    Error('\p{Blk=	:=letterlike_SYMBOLS}');
    Error('\P{Blk=	:=letterlike_SYMBOLS}');
    Expect(1, 8527, '\p{Blk=:\ALetterlike_Symbols\z:}', "");;
    Expect(0, 8528, '\p{Blk=:\ALetterlike_Symbols\z:}', "");;
    Expect(1, 8527, '\p{Blk: letterlikesymbols}', "");
    Expect(0, 8527, '\p{^Blk: letterlikesymbols}', "");
    Expect(0, 8527, '\P{Blk: letterlikesymbols}', "");
    Expect(1, 8527, '\P{^Blk: letterlikesymbols}', "");
    Expect(0, 8528, '\p{Blk: letterlikesymbols}', "");
    Expect(1, 8528, '\p{^Blk: letterlikesymbols}', "");
    Expect(1, 8528, '\P{Blk: letterlikesymbols}', "");
    Expect(0, 8528, '\P{^Blk: letterlikesymbols}', "");
    Expect(1, 8527, '\p{Blk=:\Aletterlikesymbols\z:}', "");;
    Expect(0, 8528, '\p{Blk=:\Aletterlikesymbols\z:}', "");;
    Expect(1, 8527, '\p{Blk=	Letterlike_Symbols}', "");
    Expect(0, 8527, '\p{^Blk=	Letterlike_Symbols}', "");
    Expect(0, 8527, '\P{Blk=	Letterlike_Symbols}', "");
    Expect(1, 8527, '\P{^Blk=	Letterlike_Symbols}', "");
    Expect(0, 8528, '\p{Blk=	Letterlike_Symbols}', "");
    Expect(1, 8528, '\p{^Blk=	Letterlike_Symbols}', "");
    Expect(1, 8528, '\P{Blk=	Letterlike_Symbols}', "");
    Expect(0, 8528, '\P{^Blk=	Letterlike_Symbols}', "");
    Error('\p{Is_Block: _ Letterlike_Symbols/a/}');
    Error('\P{Is_Block: _ Letterlike_Symbols/a/}');
    Expect(1, 8527, '\p{Is_Block=letterlikesymbols}', "");
    Expect(0, 8527, '\p{^Is_Block=letterlikesymbols}', "");
    Expect(0, 8527, '\P{Is_Block=letterlikesymbols}', "");
    Expect(1, 8527, '\P{^Is_Block=letterlikesymbols}', "");
    Expect(0, 8528, '\p{Is_Block=letterlikesymbols}', "");
    Expect(1, 8528, '\p{^Is_Block=letterlikesymbols}', "");
    Expect(1, 8528, '\P{Is_Block=letterlikesymbols}', "");
    Expect(0, 8528, '\P{^Is_Block=letterlikesymbols}', "");
    Expect(1, 8527, '\p{Is_Block= 	Letterlike_Symbols}', "");
    Expect(0, 8527, '\p{^Is_Block= 	Letterlike_Symbols}', "");
    Expect(0, 8527, '\P{Is_Block= 	Letterlike_Symbols}', "");
    Expect(1, 8527, '\P{^Is_Block= 	Letterlike_Symbols}', "");
    Expect(0, 8528, '\p{Is_Block= 	Letterlike_Symbols}', "");
    Expect(1, 8528, '\p{^Is_Block= 	Letterlike_Symbols}', "");
    Expect(1, 8528, '\P{Is_Block= 	Letterlike_Symbols}', "");
    Expect(0, 8528, '\P{^Is_Block= 	Letterlike_Symbols}', "");
    Error('\p{Is_Blk=/a/-_LETTERLIKE_symbols}');
    Error('\P{Is_Blk=/a/-_LETTERLIKE_symbols}');
    Expect(1, 8527, '\p{Is_Blk=letterlikesymbols}', "");
    Expect(0, 8527, '\p{^Is_Blk=letterlikesymbols}', "");
    Expect(0, 8527, '\P{Is_Blk=letterlikesymbols}', "");
    Expect(1, 8527, '\P{^Is_Blk=letterlikesymbols}', "");
    Expect(0, 8528, '\p{Is_Blk=letterlikesymbols}', "");
    Expect(1, 8528, '\p{^Is_Blk=letterlikesymbols}', "");
    Expect(1, 8528, '\P{Is_Blk=letterlikesymbols}', "");
    Expect(0, 8528, '\P{^Is_Blk=letterlikesymbols}', "");
    Expect(1, 8527, '\p{Is_Blk=Letterlike_symbols}', "");
    Expect(0, 8527, '\p{^Is_Blk=Letterlike_symbols}', "");
    Expect(0, 8527, '\P{Is_Blk=Letterlike_symbols}', "");
    Expect(1, 8527, '\P{^Is_Blk=Letterlike_symbols}', "");
    Expect(0, 8528, '\p{Is_Blk=Letterlike_symbols}', "");
    Expect(1, 8528, '\p{^Is_Blk=Letterlike_symbols}', "");
    Expect(1, 8528, '\P{Is_Blk=Letterlike_symbols}', "");
    Expect(0, 8528, '\P{^Is_Blk=Letterlike_symbols}', "");
    Error('\p{Block=:=	 LIMBU}');
    Error('\P{Block=:=	 LIMBU}');
    Expect(1, 6479, '\p{Block=:\ALimbu\z:}', "");;
    Expect(0, 6480, '\p{Block=:\ALimbu\z:}', "");;
    Expect(1, 6479, '\p{Block=limbu}', "");
    Expect(0, 6479, '\p{^Block=limbu}', "");
    Expect(0, 6479, '\P{Block=limbu}', "");
    Expect(1, 6479, '\P{^Block=limbu}', "");
    Expect(0, 6480, '\p{Block=limbu}', "");
    Expect(1, 6480, '\p{^Block=limbu}', "");
    Expect(1, 6480, '\P{Block=limbu}', "");
    Expect(0, 6480, '\P{^Block=limbu}', "");
    Expect(1, 6479, '\p{Block=:\Alimbu\z:}', "");;
    Expect(0, 6480, '\p{Block=:\Alimbu\z:}', "");;
    Expect(1, 6479, '\p{Block=	limbu}', "");
    Expect(0, 6479, '\p{^Block=	limbu}', "");
    Expect(0, 6479, '\P{Block=	limbu}', "");
    Expect(1, 6479, '\P{^Block=	limbu}', "");
    Expect(0, 6480, '\p{Block=	limbu}', "");
    Expect(1, 6480, '\p{^Block=	limbu}', "");
    Expect(1, 6480, '\P{Block=	limbu}', "");
    Expect(0, 6480, '\P{^Block=	limbu}', "");
    Error('\p{Blk=-:=Limbu}');
    Error('\P{Blk=-:=Limbu}');
    Expect(1, 6479, '\p{Blk=:\ALimbu\z:}', "");;
    Expect(0, 6480, '\p{Blk=:\ALimbu\z:}', "");;
    Expect(1, 6479, '\p{Blk=limbu}', "");
    Expect(0, 6479, '\p{^Blk=limbu}', "");
    Expect(0, 6479, '\P{Blk=limbu}', "");
    Expect(1, 6479, '\P{^Blk=limbu}', "");
    Expect(0, 6480, '\p{Blk=limbu}', "");
    Expect(1, 6480, '\p{^Blk=limbu}', "");
    Expect(1, 6480, '\P{Blk=limbu}', "");
    Expect(0, 6480, '\P{^Blk=limbu}', "");
    Expect(1, 6479, '\p{Blk=:\Alimbu\z:}', "");;
    Expect(0, 6480, '\p{Blk=:\Alimbu\z:}', "");;
    Expect(1, 6479, '\p{Blk:	-_limbu}', "");
    Expect(0, 6479, '\p{^Blk:	-_limbu}', "");
    Expect(0, 6479, '\P{Blk:	-_limbu}', "");
    Expect(1, 6479, '\P{^Blk:	-_limbu}', "");
    Expect(0, 6480, '\p{Blk:	-_limbu}', "");
    Expect(1, 6480, '\p{^Blk:	-_limbu}', "");
    Expect(1, 6480, '\P{Blk:	-_limbu}', "");
    Expect(0, 6480, '\P{^Blk:	-_limbu}', "");
    Error('\p{Is_Block= Limbu/a/}');
    Error('\P{Is_Block= Limbu/a/}');
    Expect(1, 6479, '\p{Is_Block=limbu}', "");
    Expect(0, 6479, '\p{^Is_Block=limbu}', "");
    Expect(0, 6479, '\P{Is_Block=limbu}', "");
    Expect(1, 6479, '\P{^Is_Block=limbu}', "");
    Expect(0, 6480, '\p{Is_Block=limbu}', "");
    Expect(1, 6480, '\p{^Is_Block=limbu}', "");
    Expect(1, 6480, '\P{Is_Block=limbu}', "");
    Expect(0, 6480, '\P{^Is_Block=limbu}', "");
    Expect(1, 6479, '\p{Is_Block=_ limbu}', "");
    Expect(0, 6479, '\p{^Is_Block=_ limbu}', "");
    Expect(0, 6479, '\P{Is_Block=_ limbu}', "");
    Expect(1, 6479, '\P{^Is_Block=_ limbu}', "");
    Expect(0, 6480, '\p{Is_Block=_ limbu}', "");
    Expect(1, 6480, '\p{^Is_Block=_ limbu}', "");
    Expect(1, 6480, '\P{Is_Block=_ limbu}', "");
    Expect(0, 6480, '\P{^Is_Block=_ limbu}', "");
    Error('\p{Is_Blk=/a/	-Limbu}');
    Error('\P{Is_Blk=/a/	-Limbu}');
    Expect(1, 6479, '\p{Is_Blk=limbu}', "");
    Expect(0, 6479, '\p{^Is_Blk=limbu}', "");
    Expect(0, 6479, '\P{Is_Blk=limbu}', "");
    Expect(1, 6479, '\P{^Is_Blk=limbu}', "");
    Expect(0, 6480, '\p{Is_Blk=limbu}', "");
    Expect(1, 6480, '\p{^Is_Blk=limbu}', "");
    Expect(1, 6480, '\P{Is_Blk=limbu}', "");
    Expect(0, 6480, '\P{^Is_Blk=limbu}', "");
    Expect(1, 6479, '\p{Is_Blk=	-LIMBU}', "");
    Expect(0, 6479, '\p{^Is_Blk=	-LIMBU}', "");
    Expect(0, 6479, '\P{Is_Blk=	-LIMBU}', "");
    Expect(1, 6479, '\P{^Is_Blk=	-LIMBU}', "");
    Expect(0, 6480, '\p{Is_Blk=	-LIMBU}', "");
    Expect(1, 6480, '\p{^Is_Blk=	-LIMBU}', "");
    Expect(1, 6480, '\P{Is_Blk=	-LIMBU}', "");
    Expect(0, 6480, '\P{^Is_Blk=	-LIMBU}', "");
    Error('\p{Block=/a/_	Linear_A}');
    Error('\P{Block=/a/_	Linear_A}');
    Expect(1, 67455, '\p{Block=:\ALinear_A\z:}', "");;
    Expect(0, 67456, '\p{Block=:\ALinear_A\z:}', "");;
    Expect(1, 67455, '\p{Block:	lineara}', "");
    Expect(0, 67455, '\p{^Block:	lineara}', "");
    Expect(0, 67455, '\P{Block:	lineara}', "");
    Expect(1, 67455, '\P{^Block:	lineara}', "");
    Expect(0, 67456, '\p{Block:	lineara}', "");
    Expect(1, 67456, '\p{^Block:	lineara}', "");
    Expect(1, 67456, '\P{Block:	lineara}', "");
    Expect(0, 67456, '\P{^Block:	lineara}', "");
    Expect(1, 67455, '\p{Block=:\Alineara\z:}', "");;
    Expect(0, 67456, '\p{Block=:\Alineara\z:}', "");;
    Expect(1, 67455, '\p{Block=__Linear_A}', "");
    Expect(0, 67455, '\p{^Block=__Linear_A}', "");
    Expect(0, 67455, '\P{Block=__Linear_A}', "");
    Expect(1, 67455, '\P{^Block=__Linear_A}', "");
    Expect(0, 67456, '\p{Block=__Linear_A}', "");
    Expect(1, 67456, '\p{^Block=__Linear_A}', "");
    Expect(1, 67456, '\P{Block=__Linear_A}', "");
    Expect(0, 67456, '\P{^Block=__Linear_A}', "");
    Error('\p{Blk=	/a/linear_A}');
    Error('\P{Blk=	/a/linear_A}');
    Expect(1, 67455, '\p{Blk=:\ALinear_A\z:}', "");;
    Expect(0, 67456, '\p{Blk=:\ALinear_A\z:}', "");;
    Expect(1, 67455, '\p{Blk=lineara}', "");
    Expect(0, 67455, '\p{^Blk=lineara}', "");
    Expect(0, 67455, '\P{Blk=lineara}', "");
    Expect(1, 67455, '\P{^Blk=lineara}', "");
    Expect(0, 67456, '\p{Blk=lineara}', "");
    Expect(1, 67456, '\p{^Blk=lineara}', "");
    Expect(1, 67456, '\P{Blk=lineara}', "");
    Expect(0, 67456, '\P{^Blk=lineara}', "");
    Expect(1, 67455, '\p{Blk=:\Alineara\z:}', "");;
    Expect(0, 67456, '\p{Blk=:\Alineara\z:}', "");;
    Expect(1, 67455, '\p{Blk=	Linear_A}', "");
    Expect(0, 67455, '\p{^Blk=	Linear_A}', "");
    Expect(0, 67455, '\P{Blk=	Linear_A}', "");
    Expect(1, 67455, '\P{^Blk=	Linear_A}', "");
    Expect(0, 67456, '\p{Blk=	Linear_A}', "");
    Expect(1, 67456, '\p{^Blk=	Linear_A}', "");
    Expect(1, 67456, '\P{Blk=	Linear_A}', "");
    Expect(0, 67456, '\P{^Blk=	Linear_A}', "");
    Error('\p{Is_Block:   _:=linear_a}');
    Error('\P{Is_Block:   _:=linear_a}');
    Expect(1, 67455, '\p{Is_Block=lineara}', "");
    Expect(0, 67455, '\p{^Is_Block=lineara}', "");
    Expect(0, 67455, '\P{Is_Block=lineara}', "");
    Expect(1, 67455, '\P{^Is_Block=lineara}', "");
    Expect(0, 67456, '\p{Is_Block=lineara}', "");
    Expect(1, 67456, '\p{^Is_Block=lineara}', "");
    Expect(1, 67456, '\P{Is_Block=lineara}', "");
    Expect(0, 67456, '\P{^Is_Block=lineara}', "");
    Expect(1, 67455, '\p{Is_Block= _Linear_A}', "");
    Expect(0, 67455, '\p{^Is_Block= _Linear_A}', "");
    Expect(0, 67455, '\P{Is_Block= _Linear_A}', "");
    Expect(1, 67455, '\P{^Is_Block= _Linear_A}', "");
    Expect(0, 67456, '\p{Is_Block= _Linear_A}', "");
    Expect(1, 67456, '\p{^Is_Block= _Linear_A}', "");
    Expect(1, 67456, '\P{Is_Block= _Linear_A}', "");
    Expect(0, 67456, '\P{^Is_Block= _Linear_A}', "");
    Error('\p{Is_Blk=:=	linear_a}');
    Error('\P{Is_Blk=:=	linear_a}');
    Expect(1, 67455, '\p{Is_Blk=lineara}', "");
    Expect(0, 67455, '\p{^Is_Blk=lineara}', "");
    Expect(0, 67455, '\P{Is_Blk=lineara}', "");
    Expect(1, 67455, '\P{^Is_Blk=lineara}', "");
    Expect(0, 67456, '\p{Is_Blk=lineara}', "");
    Expect(1, 67456, '\p{^Is_Blk=lineara}', "");
    Expect(1, 67456, '\P{Is_Blk=lineara}', "");
    Expect(0, 67456, '\P{^Is_Blk=lineara}', "");
    Expect(1, 67455, '\p{Is_Blk=__LINEAR_A}', "");
    Expect(0, 67455, '\p{^Is_Blk=__LINEAR_A}', "");
    Expect(0, 67455, '\P{Is_Blk=__LINEAR_A}', "");
    Expect(1, 67455, '\P{^Is_Blk=__LINEAR_A}', "");
    Expect(0, 67456, '\p{Is_Blk=__LINEAR_A}', "");
    Expect(1, 67456, '\p{^Is_Blk=__LINEAR_A}', "");
    Expect(1, 67456, '\P{Is_Blk=__LINEAR_A}', "");
    Expect(0, 67456, '\P{^Is_Blk=__LINEAR_A}', "");
    Error('\p{Block=_ LINEAR_B_IDEOGRAMS/a/}');
    Error('\P{Block=_ LINEAR_B_IDEOGRAMS/a/}');
    Expect(1, 65791, '\p{Block=:\ALinear_B_Ideograms\z:}', "");;
    Expect(0, 65792, '\p{Block=:\ALinear_B_Ideograms\z:}', "");;
    Expect(1, 65791, '\p{Block=linearbideograms}', "");
    Expect(0, 65791, '\p{^Block=linearbideograms}', "");
    Expect(0, 65791, '\P{Block=linearbideograms}', "");
    Expect(1, 65791, '\P{^Block=linearbideograms}', "");
    Expect(0, 65792, '\p{Block=linearbideograms}', "");
    Expect(1, 65792, '\p{^Block=linearbideograms}', "");
    Expect(1, 65792, '\P{Block=linearbideograms}', "");
    Expect(0, 65792, '\P{^Block=linearbideograms}', "");
    Expect(1, 65791, '\p{Block=:\Alinearbideograms\z:}', "");;
    Expect(0, 65792, '\p{Block=:\Alinearbideograms\z:}', "");;
    Expect(1, 65791, '\p{Block: -LINEAR_b_Ideograms}', "");
    Expect(0, 65791, '\p{^Block: -LINEAR_b_Ideograms}', "");
    Expect(0, 65791, '\P{Block: -LINEAR_b_Ideograms}', "");
    Expect(1, 65791, '\P{^Block: -LINEAR_b_Ideograms}', "");
    Expect(0, 65792, '\p{Block: -LINEAR_b_Ideograms}', "");
    Expect(1, 65792, '\p{^Block: -LINEAR_b_Ideograms}', "");
    Expect(1, 65792, '\P{Block: -LINEAR_b_Ideograms}', "");
    Expect(0, 65792, '\P{^Block: -LINEAR_b_Ideograms}', "");
    Error('\p{Blk=	:=Linear_B_ideograms}');
    Error('\P{Blk=	:=Linear_B_ideograms}');
    Expect(1, 65791, '\p{Blk=:\ALinear_B_Ideograms\z:}', "");;
    Expect(0, 65792, '\p{Blk=:\ALinear_B_Ideograms\z:}', "");;
    Expect(1, 65791, '\p{Blk=linearbideograms}', "");
    Expect(0, 65791, '\p{^Blk=linearbideograms}', "");
    Expect(0, 65791, '\P{Blk=linearbideograms}', "");
    Expect(1, 65791, '\P{^Blk=linearbideograms}', "");
    Expect(0, 65792, '\p{Blk=linearbideograms}', "");
    Expect(1, 65792, '\p{^Blk=linearbideograms}', "");
    Expect(1, 65792, '\P{Blk=linearbideograms}', "");
    Expect(0, 65792, '\P{^Blk=linearbideograms}', "");
    Expect(1, 65791, '\p{Blk=:\Alinearbideograms\z:}', "");;
    Expect(0, 65792, '\p{Blk=:\Alinearbideograms\z:}', "");;
    Expect(1, 65791, '\p{Blk=_ linear_B_ideograms}', "");
    Expect(0, 65791, '\p{^Blk=_ linear_B_ideograms}', "");
    Expect(0, 65791, '\P{Blk=_ linear_B_ideograms}', "");
    Expect(1, 65791, '\P{^Blk=_ linear_B_ideograms}', "");
    Expect(0, 65792, '\p{Blk=_ linear_B_ideograms}', "");
    Expect(1, 65792, '\p{^Blk=_ linear_B_ideograms}', "");
    Expect(1, 65792, '\P{Blk=_ linear_B_ideograms}', "");
    Expect(0, 65792, '\P{^Blk=_ linear_B_ideograms}', "");
    Error('\p{Is_Block= 	Linear_b_Ideograms:=}');
    Error('\P{Is_Block= 	Linear_b_Ideograms:=}');
    Expect(1, 65791, '\p{Is_Block=linearbideograms}', "");
    Expect(0, 65791, '\p{^Is_Block=linearbideograms}', "");
    Expect(0, 65791, '\P{Is_Block=linearbideograms}', "");
    Expect(1, 65791, '\P{^Is_Block=linearbideograms}', "");
    Expect(0, 65792, '\p{Is_Block=linearbideograms}', "");
    Expect(1, 65792, '\p{^Is_Block=linearbideograms}', "");
    Expect(1, 65792, '\P{Is_Block=linearbideograms}', "");
    Expect(0, 65792, '\P{^Is_Block=linearbideograms}', "");
    Expect(1, 65791, '\p{Is_Block=	-linear_B_ideograms}', "");
    Expect(0, 65791, '\p{^Is_Block=	-linear_B_ideograms}', "");
    Expect(0, 65791, '\P{Is_Block=	-linear_B_ideograms}', "");
    Expect(1, 65791, '\P{^Is_Block=	-linear_B_ideograms}', "");
    Expect(0, 65792, '\p{Is_Block=	-linear_B_ideograms}', "");
    Expect(1, 65792, '\p{^Is_Block=	-linear_B_ideograms}', "");
    Expect(1, 65792, '\P{Is_Block=	-linear_B_ideograms}', "");
    Expect(0, 65792, '\P{^Is_Block=	-linear_B_ideograms}', "");
    Error('\p{Is_Blk=-_linear_B_ideograms:=}');
    Error('\P{Is_Blk=-_linear_B_ideograms:=}');
    Expect(1, 65791, '\p{Is_Blk=linearbideograms}', "");
    Expect(0, 65791, '\p{^Is_Blk=linearbideograms}', "");
    Expect(0, 65791, '\P{Is_Blk=linearbideograms}', "");
    Expect(1, 65791, '\P{^Is_Blk=linearbideograms}', "");
    Expect(0, 65792, '\p{Is_Blk=linearbideograms}', "");
    Expect(1, 65792, '\p{^Is_Blk=linearbideograms}', "");
    Expect(1, 65792, '\P{Is_Blk=linearbideograms}', "");
    Expect(0, 65792, '\P{^Is_Blk=linearbideograms}', "");
    Expect(1, 65791, '\p{Is_Blk:	_ linear_B_IDEOGRAMS}', "");
    Expect(0, 65791, '\p{^Is_Blk:	_ linear_B_IDEOGRAMS}', "");
    Expect(0, 65791, '\P{Is_Blk:	_ linear_B_IDEOGRAMS}', "");
    Expect(1, 65791, '\P{^Is_Blk:	_ linear_B_IDEOGRAMS}', "");
    Expect(0, 65792, '\p{Is_Blk:	_ linear_B_IDEOGRAMS}', "");
    Expect(1, 65792, '\p{^Is_Blk:	_ linear_B_IDEOGRAMS}', "");
    Expect(1, 65792, '\P{Is_Blk:	_ linear_B_IDEOGRAMS}', "");
    Expect(0, 65792, '\P{^Is_Blk:	_ linear_B_IDEOGRAMS}', "");
    Error('\p{Block=- linear_b_Syllabary/a/}');
    Error('\P{Block=- linear_b_Syllabary/a/}');
    Expect(1, 65663, '\p{Block=:\ALinear_B_Syllabary\z:}', "");;
    Expect(0, 65664, '\p{Block=:\ALinear_B_Syllabary\z:}', "");;
    Expect(1, 65663, '\p{Block=linearbsyllabary}', "");
    Expect(0, 65663, '\p{^Block=linearbsyllabary}', "");
    Expect(0, 65663, '\P{Block=linearbsyllabary}', "");
    Expect(1, 65663, '\P{^Block=linearbsyllabary}', "");
    Expect(0, 65664, '\p{Block=linearbsyllabary}', "");
    Expect(1, 65664, '\p{^Block=linearbsyllabary}', "");
    Expect(1, 65664, '\P{Block=linearbsyllabary}', "");
    Expect(0, 65664, '\P{^Block=linearbsyllabary}', "");
    Expect(1, 65663, '\p{Block=:\Alinearbsyllabary\z:}', "");;
    Expect(0, 65664, '\p{Block=:\Alinearbsyllabary\z:}', "");;
    Expect(1, 65663, '\p{Block= -LINEAR_B_syllabary}', "");
    Expect(0, 65663, '\p{^Block= -LINEAR_B_syllabary}', "");
    Expect(0, 65663, '\P{Block= -LINEAR_B_syllabary}', "");
    Expect(1, 65663, '\P{^Block= -LINEAR_B_syllabary}', "");
    Expect(0, 65664, '\p{Block= -LINEAR_B_syllabary}', "");
    Expect(1, 65664, '\p{^Block= -LINEAR_B_syllabary}', "");
    Expect(1, 65664, '\P{Block= -LINEAR_B_syllabary}', "");
    Expect(0, 65664, '\P{^Block= -LINEAR_B_syllabary}', "");
    Error('\p{Blk=-/a/Linear_B_syllabary}');
    Error('\P{Blk=-/a/Linear_B_syllabary}');
    Expect(1, 65663, '\p{Blk=:\ALinear_B_Syllabary\z:}', "");;
    Expect(0, 65664, '\p{Blk=:\ALinear_B_Syllabary\z:}', "");;
    Expect(1, 65663, '\p{Blk=linearbsyllabary}', "");
    Expect(0, 65663, '\p{^Blk=linearbsyllabary}', "");
    Expect(0, 65663, '\P{Blk=linearbsyllabary}', "");
    Expect(1, 65663, '\P{^Blk=linearbsyllabary}', "");
    Expect(0, 65664, '\p{Blk=linearbsyllabary}', "");
    Expect(1, 65664, '\p{^Blk=linearbsyllabary}', "");
    Expect(1, 65664, '\P{Blk=linearbsyllabary}', "");
    Expect(0, 65664, '\P{^Blk=linearbsyllabary}', "");
    Expect(1, 65663, '\p{Blk=:\Alinearbsyllabary\z:}', "");;
    Expect(0, 65664, '\p{Blk=:\Alinearbsyllabary\z:}', "");;
    Expect(1, 65663, '\p{Blk=  Linear_B_SYLLABARY}', "");
    Expect(0, 65663, '\p{^Blk=  Linear_B_SYLLABARY}', "");
    Expect(0, 65663, '\P{Blk=  Linear_B_SYLLABARY}', "");
    Expect(1, 65663, '\P{^Blk=  Linear_B_SYLLABARY}', "");
    Expect(0, 65664, '\p{Blk=  Linear_B_SYLLABARY}', "");
    Expect(1, 65664, '\p{^Blk=  Linear_B_SYLLABARY}', "");
    Expect(1, 65664, '\P{Blk=  Linear_B_SYLLABARY}', "");
    Expect(0, 65664, '\P{^Blk=  Linear_B_SYLLABARY}', "");
    Error('\p{Is_Block=:= LINEAR_B_SYLLABARY}');
    Error('\P{Is_Block=:= LINEAR_B_SYLLABARY}');
    Expect(1, 65663, '\p{Is_Block=linearbsyllabary}', "");
    Expect(0, 65663, '\p{^Is_Block=linearbsyllabary}', "");
    Expect(0, 65663, '\P{Is_Block=linearbsyllabary}', "");
    Expect(1, 65663, '\P{^Is_Block=linearbsyllabary}', "");
    Expect(0, 65664, '\p{Is_Block=linearbsyllabary}', "");
    Expect(1, 65664, '\p{^Is_Block=linearbsyllabary}', "");
    Expect(1, 65664, '\P{Is_Block=linearbsyllabary}', "");
    Expect(0, 65664, '\P{^Is_Block=linearbsyllabary}', "");
    Expect(1, 65663, '\p{Is_Block=_ Linear_B_Syllabary}', "");
    Expect(0, 65663, '\p{^Is_Block=_ Linear_B_Syllabary}', "");
    Expect(0, 65663, '\P{Is_Block=_ Linear_B_Syllabary}', "");
    Expect(1, 65663, '\P{^Is_Block=_ Linear_B_Syllabary}', "");
    Expect(0, 65664, '\p{Is_Block=_ Linear_B_Syllabary}', "");
    Expect(1, 65664, '\p{^Is_Block=_ Linear_B_Syllabary}', "");
    Expect(1, 65664, '\P{Is_Block=_ Linear_B_Syllabary}', "");
    Expect(0, 65664, '\P{^Is_Block=_ Linear_B_Syllabary}', "");
    Error('\p{Is_Blk:   	:=linear_b_SYLLABARY}');
    Error('\P{Is_Blk:   	:=linear_b_SYLLABARY}');
    Expect(1, 65663, '\p{Is_Blk=linearbsyllabary}', "");
    Expect(0, 65663, '\p{^Is_Blk=linearbsyllabary}', "");
    Expect(0, 65663, '\P{Is_Blk=linearbsyllabary}', "");
    Expect(1, 65663, '\P{^Is_Blk=linearbsyllabary}', "");
    Expect(0, 65664, '\p{Is_Blk=linearbsyllabary}', "");
    Expect(1, 65664, '\p{^Is_Blk=linearbsyllabary}', "");
    Expect(1, 65664, '\P{Is_Blk=linearbsyllabary}', "");
    Expect(0, 65664, '\P{^Is_Blk=linearbsyllabary}', "");
    Expect(1, 65663, '\p{Is_Blk=__Linear_B_Syllabary}', "");
    Expect(0, 65663, '\p{^Is_Blk=__Linear_B_Syllabary}', "");
    Expect(0, 65663, '\P{Is_Blk=__Linear_B_Syllabary}', "");
    Expect(1, 65663, '\P{^Is_Blk=__Linear_B_Syllabary}', "");
    Expect(0, 65664, '\p{Is_Blk=__Linear_B_Syllabary}', "");
    Expect(1, 65664, '\p{^Is_Blk=__Linear_B_Syllabary}', "");
    Expect(1, 65664, '\P{Is_Blk=__Linear_B_Syllabary}', "");
    Expect(0, 65664, '\P{^Is_Blk=__Linear_B_Syllabary}', "");
    Error('\p{Block=:=__Lisu}');
    Error('\P{Block=:=__Lisu}');
    Expect(1, 42239, '\p{Block=:\ALisu\z:}', "");;
    Expect(0, 42240, '\p{Block=:\ALisu\z:}', "");;
    Expect(1, 42239, '\p{Block=lisu}', "");
    Expect(0, 42239, '\p{^Block=lisu}', "");
    Expect(0, 42239, '\P{Block=lisu}', "");
    Expect(1, 42239, '\P{^Block=lisu}', "");
    Expect(0, 42240, '\p{Block=lisu}', "");
    Expect(1, 42240, '\p{^Block=lisu}', "");
    Expect(1, 42240, '\P{Block=lisu}', "");
    Expect(0, 42240, '\P{^Block=lisu}', "");
    Expect(1, 42239, '\p{Block=:\Alisu\z:}', "");;
    Expect(0, 42240, '\p{Block=:\Alisu\z:}', "");;
    Expect(1, 42239, '\p{Block=	-Lisu}', "");
    Expect(0, 42239, '\p{^Block=	-Lisu}', "");
    Expect(0, 42239, '\P{Block=	-Lisu}', "");
    Expect(1, 42239, '\P{^Block=	-Lisu}', "");
    Expect(0, 42240, '\p{Block=	-Lisu}', "");
    Expect(1, 42240, '\p{^Block=	-Lisu}', "");
    Expect(1, 42240, '\P{Block=	-Lisu}', "");
    Expect(0, 42240, '\P{^Block=	-Lisu}', "");
    Error('\p{Blk= :=Lisu}');
    Error('\P{Blk= :=Lisu}');
    Expect(1, 42239, '\p{Blk=:\ALisu\z:}', "");;
    Expect(0, 42240, '\p{Blk=:\ALisu\z:}', "");;
    Expect(1, 42239, '\p{Blk=lisu}', "");
    Expect(0, 42239, '\p{^Blk=lisu}', "");
    Expect(0, 42239, '\P{Blk=lisu}', "");
    Expect(1, 42239, '\P{^Blk=lisu}', "");
    Expect(0, 42240, '\p{Blk=lisu}', "");
    Expect(1, 42240, '\p{^Blk=lisu}', "");
    Expect(1, 42240, '\P{Blk=lisu}', "");
    Expect(0, 42240, '\P{^Blk=lisu}', "");
    Expect(1, 42239, '\p{Blk=:\Alisu\z:}', "");;
    Expect(0, 42240, '\p{Blk=:\Alisu\z:}', "");;
    Expect(1, 42239, '\p{Blk=--Lisu}', "");
    Expect(0, 42239, '\p{^Blk=--Lisu}', "");
    Expect(0, 42239, '\P{Blk=--Lisu}', "");
    Expect(1, 42239, '\P{^Blk=--Lisu}', "");
    Expect(0, 42240, '\p{Blk=--Lisu}', "");
    Expect(1, 42240, '\p{^Blk=--Lisu}', "");
    Expect(1, 42240, '\P{Blk=--Lisu}', "");
    Expect(0, 42240, '\P{^Blk=--Lisu}', "");
    Error('\p{Is_Block=:=_	Lisu}');
    Error('\P{Is_Block=:=_	Lisu}');
    Expect(1, 42239, '\p{Is_Block=lisu}', "");
    Expect(0, 42239, '\p{^Is_Block=lisu}', "");
    Expect(0, 42239, '\P{Is_Block=lisu}', "");
    Expect(1, 42239, '\P{^Is_Block=lisu}', "");
    Expect(0, 42240, '\p{Is_Block=lisu}', "");
    Expect(1, 42240, '\p{^Is_Block=lisu}', "");
    Expect(1, 42240, '\P{Is_Block=lisu}', "");
    Expect(0, 42240, '\P{^Is_Block=lisu}', "");
    Expect(1, 42239, '\p{Is_Block=_Lisu}', "");
    Expect(0, 42239, '\p{^Is_Block=_Lisu}', "");
    Expect(0, 42239, '\P{Is_Block=_Lisu}', "");
    Expect(1, 42239, '\P{^Is_Block=_Lisu}', "");
    Expect(0, 42240, '\p{Is_Block=_Lisu}', "");
    Expect(1, 42240, '\p{^Is_Block=_Lisu}', "");
    Expect(1, 42240, '\P{Is_Block=_Lisu}', "");
    Expect(0, 42240, '\P{^Is_Block=_Lisu}', "");
    Error('\p{Is_Blk=:=Lisu}');
    Error('\P{Is_Blk=:=Lisu}');
    Expect(1, 42239, '\p{Is_Blk=lisu}', "");
    Expect(0, 42239, '\p{^Is_Blk=lisu}', "");
    Expect(0, 42239, '\P{Is_Blk=lisu}', "");
    Expect(1, 42239, '\P{^Is_Blk=lisu}', "");
    Expect(0, 42240, '\p{Is_Blk=lisu}', "");
    Expect(1, 42240, '\p{^Is_Blk=lisu}', "");
    Expect(1, 42240, '\P{Is_Blk=lisu}', "");
    Expect(0, 42240, '\P{^Is_Blk=lisu}', "");
    Expect(1, 42239, '\p{Is_Blk=	Lisu}', "");
    Expect(0, 42239, '\p{^Is_Blk=	Lisu}', "");
    Expect(0, 42239, '\P{Is_Blk=	Lisu}', "");
    Expect(1, 42239, '\P{^Is_Blk=	Lisu}', "");
    Expect(0, 42240, '\p{Is_Blk=	Lisu}', "");
    Expect(1, 42240, '\p{^Is_Blk=	Lisu}', "");
    Expect(1, 42240, '\P{Is_Blk=	Lisu}', "");
    Expect(0, 42240, '\P{^Is_Blk=	Lisu}', "");
    Error('\p{Block:	/a/lisu_Supplement}');
    Error('\P{Block:	/a/lisu_Supplement}');
    Expect(1, 73663, '\p{Block=:\ALisu_Supplement\z:}', "");;
    Expect(0, 73664, '\p{Block=:\ALisu_Supplement\z:}', "");;
    Expect(1, 73663, '\p{Block=lisusupplement}', "");
    Expect(0, 73663, '\p{^Block=lisusupplement}', "");
    Expect(0, 73663, '\P{Block=lisusupplement}', "");
    Expect(1, 73663, '\P{^Block=lisusupplement}', "");
    Expect(0, 73664, '\p{Block=lisusupplement}', "");
    Expect(1, 73664, '\p{^Block=lisusupplement}', "");
    Expect(1, 73664, '\P{Block=lisusupplement}', "");
    Expect(0, 73664, '\P{^Block=lisusupplement}', "");
    Expect(1, 73663, '\p{Block=:\Alisusupplement\z:}', "");;
    Expect(0, 73664, '\p{Block=:\Alisusupplement\z:}', "");;
    Expect(1, 73663, '\p{Block= Lisu_Supplement}', "");
    Expect(0, 73663, '\p{^Block= Lisu_Supplement}', "");
    Expect(0, 73663, '\P{Block= Lisu_Supplement}', "");
    Expect(1, 73663, '\P{^Block= Lisu_Supplement}', "");
    Expect(0, 73664, '\p{Block= Lisu_Supplement}', "");
    Expect(1, 73664, '\p{^Block= Lisu_Supplement}', "");
    Expect(1, 73664, '\P{Block= Lisu_Supplement}', "");
    Expect(0, 73664, '\P{^Block= Lisu_Supplement}', "");
    Error('\p{Blk=/a/	 Lisu_sup}');
    Error('\P{Blk=/a/	 Lisu_sup}');
    Expect(1, 73663, '\p{Blk=:\ALisu_Sup\z:}', "");;
    Expect(0, 73664, '\p{Blk=:\ALisu_Sup\z:}', "");;
    Expect(1, 73663, '\p{Blk=lisusup}', "");
    Expect(0, 73663, '\p{^Blk=lisusup}', "");
    Expect(0, 73663, '\P{Blk=lisusup}', "");
    Expect(1, 73663, '\P{^Blk=lisusup}', "");
    Expect(0, 73664, '\p{Blk=lisusup}', "");
    Expect(1, 73664, '\p{^Blk=lisusup}', "");
    Expect(1, 73664, '\P{Blk=lisusup}', "");
    Expect(0, 73664, '\P{^Blk=lisusup}', "");
    Expect(1, 73663, '\p{Blk=:\Alisusup\z:}', "");;
    Expect(0, 73664, '\p{Blk=:\Alisusup\z:}', "");;
    Expect(1, 73663, '\p{Blk=_	LISU_SUP}', "");
    Expect(0, 73663, '\p{^Blk=_	LISU_SUP}', "");
    Expect(0, 73663, '\P{Blk=_	LISU_SUP}', "");
    Expect(1, 73663, '\P{^Blk=_	LISU_SUP}', "");
    Expect(0, 73664, '\p{Blk=_	LISU_SUP}', "");
    Expect(1, 73664, '\p{^Blk=_	LISU_SUP}', "");
    Expect(1, 73664, '\P{Blk=_	LISU_SUP}', "");
    Expect(0, 73664, '\P{^Blk=_	LISU_SUP}', "");
    Error('\p{Is_Block=_Lisu_Supplement/a/}');
    Error('\P{Is_Block=_Lisu_Supplement/a/}');
    Expect(1, 73663, '\p{Is_Block=lisusupplement}', "");
    Expect(0, 73663, '\p{^Is_Block=lisusupplement}', "");
    Expect(0, 73663, '\P{Is_Block=lisusupplement}', "");
    Expect(1, 73663, '\P{^Is_Block=lisusupplement}', "");
    Expect(0, 73664, '\p{Is_Block=lisusupplement}', "");
    Expect(1, 73664, '\p{^Is_Block=lisusupplement}', "");
    Expect(1, 73664, '\P{Is_Block=lisusupplement}', "");
    Expect(0, 73664, '\P{^Is_Block=lisusupplement}', "");
    Expect(1, 73663, '\p{Is_Block=- LISU_SUPPLEMENT}', "");
    Expect(0, 73663, '\p{^Is_Block=- LISU_SUPPLEMENT}', "");
    Expect(0, 73663, '\P{Is_Block=- LISU_SUPPLEMENT}', "");
    Expect(1, 73663, '\P{^Is_Block=- LISU_SUPPLEMENT}', "");
    Expect(0, 73664, '\p{Is_Block=- LISU_SUPPLEMENT}', "");
    Expect(1, 73664, '\p{^Is_Block=- LISU_SUPPLEMENT}', "");
    Expect(1, 73664, '\P{Is_Block=- LISU_SUPPLEMENT}', "");
    Expect(0, 73664, '\P{^Is_Block=- LISU_SUPPLEMENT}', "");
    Error('\p{Is_Blk=:=	Lisu_Sup}');
    Error('\P{Is_Blk=:=	Lisu_Sup}');
    Expect(1, 73663, '\p{Is_Blk=lisusup}', "");
    Expect(0, 73663, '\p{^Is_Blk=lisusup}', "");
    Expect(0, 73663, '\P{Is_Blk=lisusup}', "");
    Expect(1, 73663, '\P{^Is_Blk=lisusup}', "");
    Expect(0, 73664, '\p{Is_Blk=lisusup}', "");
    Expect(1, 73664, '\p{^Is_Blk=lisusup}', "");
    Expect(1, 73664, '\P{Is_Blk=lisusup}', "");
    Expect(0, 73664, '\P{^Is_Blk=lisusup}', "");
    Expect(1, 73663, '\p{Is_Blk= Lisu_SUP}', "");
    Expect(0, 73663, '\p{^Is_Blk= Lisu_SUP}', "");
    Expect(0, 73663, '\P{Is_Blk= Lisu_SUP}', "");
    Expect(1, 73663, '\P{^Is_Blk= Lisu_SUP}', "");
    Expect(0, 73664, '\p{Is_Blk= Lisu_SUP}', "");
    Expect(1, 73664, '\p{^Is_Blk= Lisu_SUP}', "");
    Expect(1, 73664, '\P{Is_Blk= Lisu_SUP}', "");
    Expect(0, 73664, '\P{^Is_Blk= Lisu_SUP}', "");
    Error('\p{Block= Low_SURROGATES/a/}');
    Error('\P{Block= Low_SURROGATES/a/}');
    Expect(1, 57343, '\p{Block=:\ALow_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\ALow_Surrogates\z:}', "");;
    Expect(1, 57343, '\p{Block=lowsurrogates}', "");
    Expect(0, 57343, '\p{^Block=lowsurrogates}', "");
    Expect(0, 57343, '\P{Block=lowsurrogates}', "");
    Expect(1, 57343, '\P{^Block=lowsurrogates}', "");
    Expect(0, 57344, '\p{Block=lowsurrogates}', "");
    Expect(1, 57344, '\p{^Block=lowsurrogates}', "");
    Expect(1, 57344, '\P{Block=lowsurrogates}', "");
    Expect(0, 57344, '\P{^Block=lowsurrogates}', "");
    Expect(1, 57343, '\p{Block=:\Alowsurrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\Alowsurrogates\z:}', "");;
    Expect(1, 57343, '\p{Block=__Low_Surrogates}', "");
    Expect(0, 57343, '\p{^Block=__Low_Surrogates}', "");
    Expect(0, 57343, '\P{Block=__Low_Surrogates}', "");
    Expect(1, 57343, '\P{^Block=__Low_Surrogates}', "");
    Expect(0, 57344, '\p{Block=__Low_Surrogates}', "");
    Expect(1, 57344, '\p{^Block=__Low_Surrogates}', "");
    Expect(1, 57344, '\P{Block=__Low_Surrogates}', "");
    Expect(0, 57344, '\P{^Block=__Low_Surrogates}', "");
    Error('\p{Blk=	 low_Surrogates:=}');
    Error('\P{Blk=	 low_Surrogates:=}');
    Expect(1, 57343, '\p{Blk=:\ALow_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\ALow_Surrogates\z:}', "");;
    Expect(1, 57343, '\p{Blk=lowsurrogates}', "");
    Expect(0, 57343, '\p{^Blk=lowsurrogates}', "");
    Expect(0, 57343, '\P{Blk=lowsurrogates}', "");
    Expect(1, 57343, '\P{^Blk=lowsurrogates}', "");
    Expect(0, 57344, '\p{Blk=lowsurrogates}', "");
    Expect(1, 57344, '\p{^Blk=lowsurrogates}', "");
    Expect(1, 57344, '\P{Blk=lowsurrogates}', "");
    Expect(0, 57344, '\P{^Blk=lowsurrogates}', "");
    Expect(1, 57343, '\p{Blk=:\Alowsurrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\Alowsurrogates\z:}', "");;
    Expect(1, 57343, '\p{Blk= -Low_Surrogates}', "");
    Expect(0, 57343, '\p{^Blk= -Low_Surrogates}', "");
    Expect(0, 57343, '\P{Blk= -Low_Surrogates}', "");
    Expect(1, 57343, '\P{^Blk= -Low_Surrogates}', "");
    Expect(0, 57344, '\p{Blk= -Low_Surrogates}', "");
    Expect(1, 57344, '\p{^Blk= -Low_Surrogates}', "");
    Expect(1, 57344, '\P{Blk= -Low_Surrogates}', "");
    Expect(0, 57344, '\P{^Blk= -Low_Surrogates}', "");
    Error('\p{Is_Block:   _	Low_Surrogates:=}');
    Error('\P{Is_Block:   _	Low_Surrogates:=}');
    Expect(1, 57343, '\p{Is_Block=lowsurrogates}', "");
    Expect(0, 57343, '\p{^Is_Block=lowsurrogates}', "");
    Expect(0, 57343, '\P{Is_Block=lowsurrogates}', "");
    Expect(1, 57343, '\P{^Is_Block=lowsurrogates}', "");
    Expect(0, 57344, '\p{Is_Block=lowsurrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=lowsurrogates}', "");
    Expect(1, 57344, '\P{Is_Block=lowsurrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=lowsurrogates}', "");
    Expect(1, 57343, '\p{Is_Block= _Low_SURROGATES}', "");
    Expect(0, 57343, '\p{^Is_Block= _Low_SURROGATES}', "");
    Expect(0, 57343, '\P{Is_Block= _Low_SURROGATES}', "");
    Expect(1, 57343, '\P{^Is_Block= _Low_SURROGATES}', "");
    Expect(0, 57344, '\p{Is_Block= _Low_SURROGATES}', "");
    Expect(1, 57344, '\p{^Is_Block= _Low_SURROGATES}', "");
    Expect(1, 57344, '\P{Is_Block= _Low_SURROGATES}', "");
    Expect(0, 57344, '\P{^Is_Block= _Low_SURROGATES}', "");
    Error('\p{Is_Blk=_ Low_Surrogates:=}');
    Error('\P{Is_Blk=_ Low_Surrogates:=}');
    Expect(1, 57343, '\p{Is_Blk=lowsurrogates}', "");
    Expect(0, 57343, '\p{^Is_Blk=lowsurrogates}', "");
    Expect(0, 57343, '\P{Is_Blk=lowsurrogates}', "");
    Expect(1, 57343, '\P{^Is_Blk=lowsurrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=lowsurrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=lowsurrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=lowsurrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=lowsurrogates}', "");
    Expect(1, 57343, '\p{Is_Blk= _Low_Surrogates}', "");
    Expect(0, 57343, '\p{^Is_Blk= _Low_Surrogates}', "");
    Expect(0, 57343, '\P{Is_Blk= _Low_Surrogates}', "");
    Expect(1, 57343, '\P{^Is_Blk= _Low_Surrogates}', "");
    Expect(0, 57344, '\p{Is_Blk= _Low_Surrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk= _Low_Surrogates}', "");
    Expect(1, 57344, '\P{Is_Blk= _Low_Surrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk= _Low_Surrogates}', "");
    Error('\p{Block=	LYCIAN/a/}');
    Error('\P{Block=	LYCIAN/a/}');
    Expect(1, 66207, '\p{Block=:\ALycian\z:}', "");;
    Expect(0, 66208, '\p{Block=:\ALycian\z:}', "");;
    Expect(1, 66207, '\p{Block=lycian}', "");
    Expect(0, 66207, '\p{^Block=lycian}', "");
    Expect(0, 66207, '\P{Block=lycian}', "");
    Expect(1, 66207, '\P{^Block=lycian}', "");
    Expect(0, 66208, '\p{Block=lycian}', "");
    Expect(1, 66208, '\p{^Block=lycian}', "");
    Expect(1, 66208, '\P{Block=lycian}', "");
    Expect(0, 66208, '\P{^Block=lycian}', "");
    Expect(1, 66207, '\p{Block=:\Alycian\z:}', "");;
    Expect(0, 66208, '\p{Block=:\Alycian\z:}', "");;
    Expect(1, 66207, '\p{Block=	 LYCIAN}', "");
    Expect(0, 66207, '\p{^Block=	 LYCIAN}', "");
    Expect(0, 66207, '\P{Block=	 LYCIAN}', "");
    Expect(1, 66207, '\P{^Block=	 LYCIAN}', "");
    Expect(0, 66208, '\p{Block=	 LYCIAN}', "");
    Expect(1, 66208, '\p{^Block=	 LYCIAN}', "");
    Expect(1, 66208, '\P{Block=	 LYCIAN}', "");
    Expect(0, 66208, '\P{^Block=	 LYCIAN}', "");
    Error('\p{Blk=/a/Lycian}');
    Error('\P{Blk=/a/Lycian}');
    Expect(1, 66207, '\p{Blk=:\ALycian\z:}', "");;
    Expect(0, 66208, '\p{Blk=:\ALycian\z:}', "");;
    Expect(1, 66207, '\p{Blk=lycian}', "");
    Expect(0, 66207, '\p{^Blk=lycian}', "");
    Expect(0, 66207, '\P{Blk=lycian}', "");
    Expect(1, 66207, '\P{^Blk=lycian}', "");
    Expect(0, 66208, '\p{Blk=lycian}', "");
    Expect(1, 66208, '\p{^Blk=lycian}', "");
    Expect(1, 66208, '\P{Blk=lycian}', "");
    Expect(0, 66208, '\P{^Blk=lycian}', "");
    Expect(1, 66207, '\p{Blk=:\Alycian\z:}', "");;
    Expect(0, 66208, '\p{Blk=:\Alycian\z:}', "");;
    Expect(1, 66207, '\p{Blk=__lycian}', "");
    Expect(0, 66207, '\p{^Blk=__lycian}', "");
    Expect(0, 66207, '\P{Blk=__lycian}', "");
    Expect(1, 66207, '\P{^Blk=__lycian}', "");
    Expect(0, 66208, '\p{Blk=__lycian}', "");
    Expect(1, 66208, '\p{^Blk=__lycian}', "");
    Expect(1, 66208, '\P{Blk=__lycian}', "");
    Expect(0, 66208, '\P{^Blk=__lycian}', "");
    Error('\p{Is_Block=/a/LYCIAN}');
    Error('\P{Is_Block=/a/LYCIAN}');
    Expect(1, 66207, '\p{Is_Block:   lycian}', "");
    Expect(0, 66207, '\p{^Is_Block:   lycian}', "");
    Expect(0, 66207, '\P{Is_Block:   lycian}', "");
    Expect(1, 66207, '\P{^Is_Block:   lycian}', "");
    Expect(0, 66208, '\p{Is_Block:   lycian}', "");
    Expect(1, 66208, '\p{^Is_Block:   lycian}', "");
    Expect(1, 66208, '\P{Is_Block:   lycian}', "");
    Expect(0, 66208, '\P{^Is_Block:   lycian}', "");
    Expect(1, 66207, '\p{Is_Block=_ LYCIAN}', "");
    Expect(0, 66207, '\p{^Is_Block=_ LYCIAN}', "");
    Expect(0, 66207, '\P{Is_Block=_ LYCIAN}', "");
    Expect(1, 66207, '\P{^Is_Block=_ LYCIAN}', "");
    Expect(0, 66208, '\p{Is_Block=_ LYCIAN}', "");
    Expect(1, 66208, '\p{^Is_Block=_ LYCIAN}', "");
    Expect(1, 66208, '\P{Is_Block=_ LYCIAN}', "");
    Expect(0, 66208, '\P{^Is_Block=_ LYCIAN}', "");
    Error('\p{Is_Blk=/a/ Lycian}');
    Error('\P{Is_Blk=/a/ Lycian}');
    Expect(1, 66207, '\p{Is_Blk=lycian}', "");
    Expect(0, 66207, '\p{^Is_Blk=lycian}', "");
    Expect(0, 66207, '\P{Is_Blk=lycian}', "");
    Expect(1, 66207, '\P{^Is_Blk=lycian}', "");
    Expect(0, 66208, '\p{Is_Blk=lycian}', "");
    Expect(1, 66208, '\p{^Is_Blk=lycian}', "");
    Expect(1, 66208, '\P{Is_Blk=lycian}', "");
    Expect(0, 66208, '\P{^Is_Blk=lycian}', "");
    Expect(1, 66207, '\p{Is_Blk=-LYCIAN}', "");
    Expect(0, 66207, '\p{^Is_Blk=-LYCIAN}', "");
    Expect(0, 66207, '\P{Is_Blk=-LYCIAN}', "");
    Expect(1, 66207, '\P{^Is_Blk=-LYCIAN}', "");
    Expect(0, 66208, '\p{Is_Blk=-LYCIAN}', "");
    Expect(1, 66208, '\p{^Is_Blk=-LYCIAN}', "");
    Expect(1, 66208, '\P{Is_Blk=-LYCIAN}', "");
    Expect(0, 66208, '\P{^Is_Blk=-LYCIAN}', "");
    Error('\p{Block=/a/Lydian}');
    Error('\P{Block=/a/Lydian}');
    Expect(1, 67903, '\p{Block=:\ALydian\z:}', "");;
    Expect(0, 67904, '\p{Block=:\ALydian\z:}', "");;
    Expect(1, 67903, '\p{Block=lydian}', "");
    Expect(0, 67903, '\p{^Block=lydian}', "");
    Expect(0, 67903, '\P{Block=lydian}', "");
    Expect(1, 67903, '\P{^Block=lydian}', "");
    Expect(0, 67904, '\p{Block=lydian}', "");
    Expect(1, 67904, '\p{^Block=lydian}', "");
    Expect(1, 67904, '\P{Block=lydian}', "");
    Expect(0, 67904, '\P{^Block=lydian}', "");
    Expect(1, 67903, '\p{Block=:\Alydian\z:}', "");;
    Expect(0, 67904, '\p{Block=:\Alydian\z:}', "");;
    Expect(1, 67903, '\p{Block:		Lydian}', "");
    Expect(0, 67903, '\p{^Block:		Lydian}', "");
    Expect(0, 67903, '\P{Block:		Lydian}', "");
    Expect(1, 67903, '\P{^Block:		Lydian}', "");
    Expect(0, 67904, '\p{Block:		Lydian}', "");
    Expect(1, 67904, '\p{^Block:		Lydian}', "");
    Expect(1, 67904, '\P{Block:		Lydian}', "");
    Expect(0, 67904, '\P{^Block:		Lydian}', "");
    Error('\p{Blk=:=Lydian}');
    Error('\P{Blk=:=Lydian}');
    Expect(1, 67903, '\p{Blk=:\ALydian\z:}', "");;
    Expect(0, 67904, '\p{Blk=:\ALydian\z:}', "");;
    Expect(1, 67903, '\p{Blk=lydian}', "");
    Expect(0, 67903, '\p{^Blk=lydian}', "");
    Expect(0, 67903, '\P{Blk=lydian}', "");
    Expect(1, 67903, '\P{^Blk=lydian}', "");
    Expect(0, 67904, '\p{Blk=lydian}', "");
    Expect(1, 67904, '\p{^Blk=lydian}', "");
    Expect(1, 67904, '\P{Blk=lydian}', "");
    Expect(0, 67904, '\P{^Blk=lydian}', "");
    Expect(1, 67903, '\p{Blk=:\Alydian\z:}', "");;
    Expect(0, 67904, '\p{Blk=:\Alydian\z:}', "");;
    Expect(1, 67903, '\p{Blk=		Lydian}', "");
    Expect(0, 67903, '\p{^Blk=		Lydian}', "");
    Expect(0, 67903, '\P{Blk=		Lydian}', "");
    Expect(1, 67903, '\P{^Blk=		Lydian}', "");
    Expect(0, 67904, '\p{Blk=		Lydian}', "");
    Expect(1, 67904, '\p{^Blk=		Lydian}', "");
    Expect(1, 67904, '\P{Blk=		Lydian}', "");
    Expect(0, 67904, '\P{^Blk=		Lydian}', "");
    Error('\p{Is_Block=/a/__Lydian}');
    Error('\P{Is_Block=/a/__Lydian}');
    Expect(1, 67903, '\p{Is_Block=lydian}', "");
    Expect(0, 67903, '\p{^Is_Block=lydian}', "");
    Expect(0, 67903, '\P{Is_Block=lydian}', "");
    Expect(1, 67903, '\P{^Is_Block=lydian}', "");
    Expect(0, 67904, '\p{Is_Block=lydian}', "");
    Expect(1, 67904, '\p{^Is_Block=lydian}', "");
    Expect(1, 67904, '\P{Is_Block=lydian}', "");
    Expect(0, 67904, '\P{^Is_Block=lydian}', "");
    Expect(1, 67903, '\p{Is_Block=	Lydian}', "");
    Expect(0, 67903, '\p{^Is_Block=	Lydian}', "");
    Expect(0, 67903, '\P{Is_Block=	Lydian}', "");
    Expect(1, 67903, '\P{^Is_Block=	Lydian}', "");
    Expect(0, 67904, '\p{Is_Block=	Lydian}', "");
    Expect(1, 67904, '\p{^Is_Block=	Lydian}', "");
    Expect(1, 67904, '\P{Is_Block=	Lydian}', "");
    Expect(0, 67904, '\P{^Is_Block=	Lydian}', "");
    Error('\p{Is_Blk:	-:=lydian}');
    Error('\P{Is_Blk:	-:=lydian}');
    Expect(1, 67903, '\p{Is_Blk=lydian}', "");
    Expect(0, 67903, '\p{^Is_Blk=lydian}', "");
    Expect(0, 67903, '\P{Is_Blk=lydian}', "");
    Expect(1, 67903, '\P{^Is_Blk=lydian}', "");
    Expect(0, 67904, '\p{Is_Blk=lydian}', "");
    Expect(1, 67904, '\p{^Is_Blk=lydian}', "");
    Expect(1, 67904, '\P{Is_Blk=lydian}', "");
    Expect(0, 67904, '\P{^Is_Blk=lydian}', "");
    Expect(1, 67903, '\p{Is_Blk=-Lydian}', "");
    Expect(0, 67903, '\p{^Is_Blk=-Lydian}', "");
    Expect(0, 67903, '\P{Is_Blk=-Lydian}', "");
    Expect(1, 67903, '\P{^Is_Blk=-Lydian}', "");
    Expect(0, 67904, '\p{Is_Blk=-Lydian}', "");
    Expect(1, 67904, '\p{^Is_Blk=-Lydian}', "");
    Expect(1, 67904, '\P{Is_Blk=-Lydian}', "");
    Expect(0, 67904, '\P{^Is_Blk=-Lydian}', "");
    Error('\p{Block=:= -MAHAJANI}');
    Error('\P{Block=:= -MAHAJANI}');
    Expect(1, 70015, '\p{Block=:\AMahajani\z:}', "");;
    Expect(0, 70016, '\p{Block=:\AMahajani\z:}', "");;
    Expect(1, 70015, '\p{Block=mahajani}', "");
    Expect(0, 70015, '\p{^Block=mahajani}', "");
    Expect(0, 70015, '\P{Block=mahajani}', "");
    Expect(1, 70015, '\P{^Block=mahajani}', "");
    Expect(0, 70016, '\p{Block=mahajani}', "");
    Expect(1, 70016, '\p{^Block=mahajani}', "");
    Expect(1, 70016, '\P{Block=mahajani}', "");
    Expect(0, 70016, '\P{^Block=mahajani}', "");
    Expect(1, 70015, '\p{Block=:\Amahajani\z:}', "");;
    Expect(0, 70016, '\p{Block=:\Amahajani\z:}', "");;
    Expect(1, 70015, '\p{Block=  Mahajani}', "");
    Expect(0, 70015, '\p{^Block=  Mahajani}', "");
    Expect(0, 70015, '\P{Block=  Mahajani}', "");
    Expect(1, 70015, '\P{^Block=  Mahajani}', "");
    Expect(0, 70016, '\p{Block=  Mahajani}', "");
    Expect(1, 70016, '\p{^Block=  Mahajani}', "");
    Expect(1, 70016, '\P{Block=  Mahajani}', "");
    Expect(0, 70016, '\P{^Block=  Mahajani}', "");
    Error('\p{Blk=:=__MAHAJANI}');
    Error('\P{Blk=:=__MAHAJANI}');
    Expect(1, 70015, '\p{Blk=:\AMahajani\z:}', "");;
    Expect(0, 70016, '\p{Blk=:\AMahajani\z:}', "");;
    Expect(1, 70015, '\p{Blk=mahajani}', "");
    Expect(0, 70015, '\p{^Blk=mahajani}', "");
    Expect(0, 70015, '\P{Blk=mahajani}', "");
    Expect(1, 70015, '\P{^Blk=mahajani}', "");
    Expect(0, 70016, '\p{Blk=mahajani}', "");
    Expect(1, 70016, '\p{^Blk=mahajani}', "");
    Expect(1, 70016, '\P{Blk=mahajani}', "");
    Expect(0, 70016, '\P{^Blk=mahajani}', "");
    Expect(1, 70015, '\p{Blk=:\Amahajani\z:}', "");;
    Expect(0, 70016, '\p{Blk=:\Amahajani\z:}', "");;
    Expect(1, 70015, '\p{Blk=	 Mahajani}', "");
    Expect(0, 70015, '\p{^Blk=	 Mahajani}', "");
    Expect(0, 70015, '\P{Blk=	 Mahajani}', "");
    Expect(1, 70015, '\P{^Blk=	 Mahajani}', "");
    Expect(0, 70016, '\p{Blk=	 Mahajani}', "");
    Expect(1, 70016, '\p{^Blk=	 Mahajani}', "");
    Expect(1, 70016, '\P{Blk=	 Mahajani}', "");
    Expect(0, 70016, '\P{^Blk=	 Mahajani}', "");
    Error('\p{Is_Block=/a/  mahajani}');
    Error('\P{Is_Block=/a/  mahajani}');
    Expect(1, 70015, '\p{Is_Block=mahajani}', "");
    Expect(0, 70015, '\p{^Is_Block=mahajani}', "");
    Expect(0, 70015, '\P{Is_Block=mahajani}', "");
    Expect(1, 70015, '\P{^Is_Block=mahajani}', "");
    Expect(0, 70016, '\p{Is_Block=mahajani}', "");
    Expect(1, 70016, '\p{^Is_Block=mahajani}', "");
    Expect(1, 70016, '\P{Is_Block=mahajani}', "");
    Expect(0, 70016, '\P{^Is_Block=mahajani}', "");
    Expect(1, 70015, '\p{Is_Block=_mahajani}', "");
    Expect(0, 70015, '\p{^Is_Block=_mahajani}', "");
    Expect(0, 70015, '\P{Is_Block=_mahajani}', "");
    Expect(1, 70015, '\P{^Is_Block=_mahajani}', "");
    Expect(0, 70016, '\p{Is_Block=_mahajani}', "");
    Expect(1, 70016, '\p{^Is_Block=_mahajani}', "");
    Expect(1, 70016, '\P{Is_Block=_mahajani}', "");
    Expect(0, 70016, '\P{^Is_Block=_mahajani}', "");
    Error('\p{Is_Blk= /a/Mahajani}');
    Error('\P{Is_Blk= /a/Mahajani}');
    Expect(1, 70015, '\p{Is_Blk=mahajani}', "");
    Expect(0, 70015, '\p{^Is_Blk=mahajani}', "");
    Expect(0, 70015, '\P{Is_Blk=mahajani}', "");
    Expect(1, 70015, '\P{^Is_Blk=mahajani}', "");
    Expect(0, 70016, '\p{Is_Blk=mahajani}', "");
    Expect(1, 70016, '\p{^Is_Blk=mahajani}', "");
    Expect(1, 70016, '\P{Is_Blk=mahajani}', "");
    Expect(0, 70016, '\P{^Is_Blk=mahajani}', "");
    Expect(1, 70015, '\p{Is_Blk=_	Mahajani}', "");
    Expect(0, 70015, '\p{^Is_Blk=_	Mahajani}', "");
    Expect(0, 70015, '\P{Is_Blk=_	Mahajani}', "");
    Expect(1, 70015, '\P{^Is_Blk=_	Mahajani}', "");
    Expect(0, 70016, '\p{Is_Blk=_	Mahajani}', "");
    Expect(1, 70016, '\p{^Is_Blk=_	Mahajani}', "");
    Expect(1, 70016, '\P{Is_Blk=_	Mahajani}', "");
    Expect(0, 70016, '\P{^Is_Blk=_	Mahajani}', "");
    Error('\p{Block=:=_	Mahjong_TILES}');
    Error('\P{Block=:=_	Mahjong_TILES}');
    Expect(1, 127023, '\p{Block=:\AMahjong_Tiles\z:}', "");;
    Expect(0, 127024, '\p{Block=:\AMahjong_Tiles\z:}', "");;
    Expect(1, 127023, '\p{Block=mahjongtiles}', "");
    Expect(0, 127023, '\p{^Block=mahjongtiles}', "");
    Expect(0, 127023, '\P{Block=mahjongtiles}', "");
    Expect(1, 127023, '\P{^Block=mahjongtiles}', "");
    Expect(0, 127024, '\p{Block=mahjongtiles}', "");
    Expect(1, 127024, '\p{^Block=mahjongtiles}', "");
    Expect(1, 127024, '\P{Block=mahjongtiles}', "");
    Expect(0, 127024, '\P{^Block=mahjongtiles}', "");
    Expect(1, 127023, '\p{Block=:\Amahjongtiles\z:}', "");;
    Expect(0, 127024, '\p{Block=:\Amahjongtiles\z:}', "");;
    Expect(1, 127023, '\p{Block= -mahjong_tiles}', "");
    Expect(0, 127023, '\p{^Block= -mahjong_tiles}', "");
    Expect(0, 127023, '\P{Block= -mahjong_tiles}', "");
    Expect(1, 127023, '\P{^Block= -mahjong_tiles}', "");
    Expect(0, 127024, '\p{Block= -mahjong_tiles}', "");
    Expect(1, 127024, '\p{^Block= -mahjong_tiles}', "");
    Expect(1, 127024, '\P{Block= -mahjong_tiles}', "");
    Expect(0, 127024, '\P{^Block= -mahjong_tiles}', "");
    Error('\p{Blk=_:=Mahjong}');
    Error('\P{Blk=_:=Mahjong}');
    Expect(1, 127023, '\p{Blk=:\AMahjong\z:}', "");;
    Expect(0, 127024, '\p{Blk=:\AMahjong\z:}', "");;
    Expect(1, 127023, '\p{Blk=mahjong}', "");
    Expect(0, 127023, '\p{^Blk=mahjong}', "");
    Expect(0, 127023, '\P{Blk=mahjong}', "");
    Expect(1, 127023, '\P{^Blk=mahjong}', "");
    Expect(0, 127024, '\p{Blk=mahjong}', "");
    Expect(1, 127024, '\p{^Blk=mahjong}', "");
    Expect(1, 127024, '\P{Blk=mahjong}', "");
    Expect(0, 127024, '\P{^Blk=mahjong}', "");
    Expect(1, 127023, '\p{Blk=:\Amahjong\z:}', "");;
    Expect(0, 127024, '\p{Blk=:\Amahjong\z:}', "");;
    Error('\p{Is_Block= 	Mahjong_Tiles:=}');
    Error('\P{Is_Block= 	Mahjong_Tiles:=}');
    Expect(1, 127023, '\p{Is_Block=mahjongtiles}', "");
    Expect(0, 127023, '\p{^Is_Block=mahjongtiles}', "");
    Expect(0, 127023, '\P{Is_Block=mahjongtiles}', "");
    Expect(1, 127023, '\P{^Is_Block=mahjongtiles}', "");
    Expect(0, 127024, '\p{Is_Block=mahjongtiles}', "");
    Expect(1, 127024, '\p{^Is_Block=mahjongtiles}', "");
    Expect(1, 127024, '\P{Is_Block=mahjongtiles}', "");
    Expect(0, 127024, '\P{^Is_Block=mahjongtiles}', "");
    Expect(1, 127023, '\p{Is_Block=-	Mahjong_Tiles}', "");
    Expect(0, 127023, '\p{^Is_Block=-	Mahjong_Tiles}', "");
    Expect(0, 127023, '\P{Is_Block=-	Mahjong_Tiles}', "");
    Expect(1, 127023, '\P{^Is_Block=-	Mahjong_Tiles}', "");
    Expect(0, 127024, '\p{Is_Block=-	Mahjong_Tiles}', "");
    Expect(1, 127024, '\p{^Is_Block=-	Mahjong_Tiles}', "");
    Expect(1, 127024, '\P{Is_Block=-	Mahjong_Tiles}', "");
    Expect(0, 127024, '\P{^Is_Block=-	Mahjong_Tiles}', "");
    Error('\p{Is_Blk=-mahjong:=}');
    Error('\P{Is_Blk=-mahjong:=}');
    Expect(1, 127023, '\p{Is_Blk:   mahjong}', "");
    Expect(0, 127023, '\p{^Is_Blk:   mahjong}', "");
    Expect(0, 127023, '\P{Is_Blk:   mahjong}', "");
    Expect(1, 127023, '\P{^Is_Blk:   mahjong}', "");
    Expect(0, 127024, '\p{Is_Blk:   mahjong}', "");
    Expect(1, 127024, '\p{^Is_Blk:   mahjong}', "");
    Expect(1, 127024, '\P{Is_Blk:   mahjong}', "");
    Expect(0, 127024, '\P{^Is_Blk:   mahjong}', "");
    Expect(1, 127023, '\p{Is_Blk=	MAHJONG}', "");
    Expect(0, 127023, '\p{^Is_Blk=	MAHJONG}', "");
    Expect(0, 127023, '\P{Is_Blk=	MAHJONG}', "");
    Expect(1, 127023, '\P{^Is_Blk=	MAHJONG}', "");
    Expect(0, 127024, '\p{Is_Blk=	MAHJONG}', "");
    Expect(1, 127024, '\p{^Is_Blk=	MAHJONG}', "");
    Expect(1, 127024, '\P{Is_Blk=	MAHJONG}', "");
    Expect(0, 127024, '\P{^Is_Blk=	MAHJONG}', "");
    Error('\p{Block=		Makasar/a/}');
    Error('\P{Block=		Makasar/a/}');
    Expect(1, 73471, '\p{Block=:\AMakasar\z:}', "");;
    Expect(0, 73472, '\p{Block=:\AMakasar\z:}', "");;
    Expect(1, 73471, '\p{Block=makasar}', "");
    Expect(0, 73471, '\p{^Block=makasar}', "");
    Expect(0, 73471, '\P{Block=makasar}', "");
    Expect(1, 73471, '\P{^Block=makasar}', "");
    Expect(0, 73472, '\p{Block=makasar}', "");
    Expect(1, 73472, '\p{^Block=makasar}', "");
    Expect(1, 73472, '\P{Block=makasar}', "");
    Expect(0, 73472, '\P{^Block=makasar}', "");
    Expect(1, 73471, '\p{Block=:\Amakasar\z:}', "");;
    Expect(0, 73472, '\p{Block=:\Amakasar\z:}', "");;
    Expect(1, 73471, '\p{Block=-makasar}', "");
    Expect(0, 73471, '\p{^Block=-makasar}', "");
    Expect(0, 73471, '\P{Block=-makasar}', "");
    Expect(1, 73471, '\P{^Block=-makasar}', "");
    Expect(0, 73472, '\p{Block=-makasar}', "");
    Expect(1, 73472, '\p{^Block=-makasar}', "");
    Expect(1, 73472, '\P{Block=-makasar}', "");
    Expect(0, 73472, '\P{^Block=-makasar}', "");
    Error('\p{Blk= MAKASAR/a/}');
    Error('\P{Blk= MAKASAR/a/}');
    Expect(1, 73471, '\p{Blk=:\AMakasar\z:}', "");;
    Expect(0, 73472, '\p{Blk=:\AMakasar\z:}', "");;
    Expect(1, 73471, '\p{Blk=makasar}', "");
    Expect(0, 73471, '\p{^Blk=makasar}', "");
    Expect(0, 73471, '\P{Blk=makasar}', "");
    Expect(1, 73471, '\P{^Blk=makasar}', "");
    Expect(0, 73472, '\p{Blk=makasar}', "");
    Expect(1, 73472, '\p{^Blk=makasar}', "");
    Expect(1, 73472, '\P{Blk=makasar}', "");
    Expect(0, 73472, '\P{^Blk=makasar}', "");
    Expect(1, 73471, '\p{Blk=:\Amakasar\z:}', "");;
    Expect(0, 73472, '\p{Blk=:\Amakasar\z:}', "");;
    Expect(1, 73471, '\p{Blk=-Makasar}', "");
    Expect(0, 73471, '\p{^Blk=-Makasar}', "");
    Expect(0, 73471, '\P{Blk=-Makasar}', "");
    Expect(1, 73471, '\P{^Blk=-Makasar}', "");
    Expect(0, 73472, '\p{Blk=-Makasar}', "");
    Expect(1, 73472, '\p{^Blk=-Makasar}', "");
    Expect(1, 73472, '\P{Blk=-Makasar}', "");
    Expect(0, 73472, '\P{^Blk=-Makasar}', "");
    Error('\p{Is_Block= Makasar:=}');
    Error('\P{Is_Block= Makasar:=}');
    Expect(1, 73471, '\p{Is_Block=makasar}', "");
    Expect(0, 73471, '\p{^Is_Block=makasar}', "");
    Expect(0, 73471, '\P{Is_Block=makasar}', "");
    Expect(1, 73471, '\P{^Is_Block=makasar}', "");
    Expect(0, 73472, '\p{Is_Block=makasar}', "");
    Expect(1, 73472, '\p{^Is_Block=makasar}', "");
    Expect(1, 73472, '\P{Is_Block=makasar}', "");
    Expect(0, 73472, '\P{^Is_Block=makasar}', "");
    Expect(1, 73471, '\p{Is_Block:  makasar}', "");
    Expect(0, 73471, '\p{^Is_Block:  makasar}', "");
    Expect(0, 73471, '\P{Is_Block:  makasar}', "");
    Expect(1, 73471, '\P{^Is_Block:  makasar}', "");
    Expect(0, 73472, '\p{Is_Block:  makasar}', "");
    Expect(1, 73472, '\p{^Is_Block:  makasar}', "");
    Expect(1, 73472, '\P{Is_Block:  makasar}', "");
    Expect(0, 73472, '\P{^Is_Block:  makasar}', "");
    Error('\p{Is_Blk=-	MAKASAR/a/}');
    Error('\P{Is_Blk=-	MAKASAR/a/}');
    Expect(1, 73471, '\p{Is_Blk:makasar}', "");
    Expect(0, 73471, '\p{^Is_Blk:makasar}', "");
    Expect(0, 73471, '\P{Is_Blk:makasar}', "");
    Expect(1, 73471, '\P{^Is_Blk:makasar}', "");
    Expect(0, 73472, '\p{Is_Blk:makasar}', "");
    Expect(1, 73472, '\p{^Is_Blk:makasar}', "");
    Expect(1, 73472, '\P{Is_Blk:makasar}', "");
    Expect(0, 73472, '\P{^Is_Blk:makasar}', "");
    Expect(1, 73471, '\p{Is_Blk=	Makasar}', "");
    Expect(0, 73471, '\p{^Is_Blk=	Makasar}', "");
    Expect(0, 73471, '\P{Is_Blk=	Makasar}', "");
    Expect(1, 73471, '\P{^Is_Blk=	Makasar}', "");
    Expect(0, 73472, '\p{Is_Blk=	Makasar}', "");
    Expect(1, 73472, '\p{^Is_Blk=	Makasar}', "");
    Expect(1, 73472, '\P{Is_Blk=	Makasar}', "");
    Expect(0, 73472, '\P{^Is_Blk=	Makasar}', "");
    Error('\p{Block=/a/	MALAYALAM}');
    Error('\P{Block=/a/	MALAYALAM}');
    Expect(1, 3455, '\p{Block=:\AMalayalam\z:}', "");;
    Expect(0, 3456, '\p{Block=:\AMalayalam\z:}', "");;
    Expect(1, 3455, '\p{Block=malayalam}', "");
    Expect(0, 3455, '\p{^Block=malayalam}', "");
    Expect(0, 3455, '\P{Block=malayalam}', "");
    Expect(1, 3455, '\P{^Block=malayalam}', "");
    Expect(0, 3456, '\p{Block=malayalam}', "");
    Expect(1, 3456, '\p{^Block=malayalam}', "");
    Expect(1, 3456, '\P{Block=malayalam}', "");
    Expect(0, 3456, '\P{^Block=malayalam}', "");
    Expect(1, 3455, '\p{Block=:\Amalayalam\z:}', "");;
    Expect(0, 3456, '\p{Block=:\Amalayalam\z:}', "");;
    Expect(1, 3455, '\p{Block= Malayalam}', "");
    Expect(0, 3455, '\p{^Block= Malayalam}', "");
    Expect(0, 3455, '\P{Block= Malayalam}', "");
    Expect(1, 3455, '\P{^Block= Malayalam}', "");
    Expect(0, 3456, '\p{Block= Malayalam}', "");
    Expect(1, 3456, '\p{^Block= Malayalam}', "");
    Expect(1, 3456, '\P{Block= Malayalam}', "");
    Expect(0, 3456, '\P{^Block= Malayalam}', "");
    Error('\p{Blk=_ Malayalam:=}');
    Error('\P{Blk=_ Malayalam:=}');
    Expect(1, 3455, '\p{Blk=:\AMalayalam\z:}', "");;
    Expect(0, 3456, '\p{Blk=:\AMalayalam\z:}', "");;
    Expect(1, 3455, '\p{Blk=malayalam}', "");
    Expect(0, 3455, '\p{^Blk=malayalam}', "");
    Expect(0, 3455, '\P{Blk=malayalam}', "");
    Expect(1, 3455, '\P{^Blk=malayalam}', "");
    Expect(0, 3456, '\p{Blk=malayalam}', "");
    Expect(1, 3456, '\p{^Blk=malayalam}', "");
    Expect(1, 3456, '\P{Blk=malayalam}', "");
    Expect(0, 3456, '\P{^Blk=malayalam}', "");
    Expect(1, 3455, '\p{Blk=:\Amalayalam\z:}', "");;
    Expect(0, 3456, '\p{Blk=:\Amalayalam\z:}', "");;
    Expect(1, 3455, '\p{Blk=	Malayalam}', "");
    Expect(0, 3455, '\p{^Blk=	Malayalam}', "");
    Expect(0, 3455, '\P{Blk=	Malayalam}', "");
    Expect(1, 3455, '\P{^Blk=	Malayalam}', "");
    Expect(0, 3456, '\p{Blk=	Malayalam}', "");
    Expect(1, 3456, '\p{^Blk=	Malayalam}', "");
    Expect(1, 3456, '\P{Blk=	Malayalam}', "");
    Expect(0, 3456, '\P{^Blk=	Malayalam}', "");
    Error('\p{Is_Block=/a/malayalam}');
    Error('\P{Is_Block=/a/malayalam}');
    Expect(1, 3455, '\p{Is_Block:malayalam}', "");
    Expect(0, 3455, '\p{^Is_Block:malayalam}', "");
    Expect(0, 3455, '\P{Is_Block:malayalam}', "");
    Expect(1, 3455, '\P{^Is_Block:malayalam}', "");
    Expect(0, 3456, '\p{Is_Block:malayalam}', "");
    Expect(1, 3456, '\p{^Is_Block:malayalam}', "");
    Expect(1, 3456, '\P{Is_Block:malayalam}', "");
    Expect(0, 3456, '\P{^Is_Block:malayalam}', "");
    Expect(1, 3455, '\p{Is_Block=	Malayalam}', "");
    Expect(0, 3455, '\p{^Is_Block=	Malayalam}', "");
    Expect(0, 3455, '\P{Is_Block=	Malayalam}', "");
    Expect(1, 3455, '\P{^Is_Block=	Malayalam}', "");
    Expect(0, 3456, '\p{Is_Block=	Malayalam}', "");
    Expect(1, 3456, '\p{^Is_Block=	Malayalam}', "");
    Expect(1, 3456, '\P{Is_Block=	Malayalam}', "");
    Expect(0, 3456, '\P{^Is_Block=	Malayalam}', "");
    Error('\p{Is_Blk=:=MALAYALAM}');
    Error('\P{Is_Blk=:=MALAYALAM}');
    Expect(1, 3455, '\p{Is_Blk=malayalam}', "");
    Expect(0, 3455, '\p{^Is_Blk=malayalam}', "");
    Expect(0, 3455, '\P{Is_Blk=malayalam}', "");
    Expect(1, 3455, '\P{^Is_Blk=malayalam}', "");
    Expect(0, 3456, '\p{Is_Blk=malayalam}', "");
    Expect(1, 3456, '\p{^Is_Blk=malayalam}', "");
    Expect(1, 3456, '\P{Is_Blk=malayalam}', "");
    Expect(0, 3456, '\P{^Is_Blk=malayalam}', "");
    Expect(1, 3455, '\p{Is_Blk=-_malayalam}', "");
    Expect(0, 3455, '\p{^Is_Blk=-_malayalam}', "");
    Expect(0, 3455, '\P{Is_Blk=-_malayalam}', "");
    Expect(1, 3455, '\P{^Is_Blk=-_malayalam}', "");
    Expect(0, 3456, '\p{Is_Blk=-_malayalam}', "");
    Expect(1, 3456, '\p{^Is_Blk=-_malayalam}', "");
    Expect(1, 3456, '\P{Is_Blk=-_malayalam}', "");
    Expect(0, 3456, '\P{^Is_Blk=-_malayalam}', "");
    Error('\p{Block= /a/Mandaic}');
    Error('\P{Block= /a/Mandaic}');
    Expect(1, 2143, '\p{Block=:\AMandaic\z:}', "");;
    Expect(0, 2144, '\p{Block=:\AMandaic\z:}', "");;
    Expect(1, 2143, '\p{Block:	mandaic}', "");
    Expect(0, 2143, '\p{^Block:	mandaic}', "");
    Expect(0, 2143, '\P{Block:	mandaic}', "");
    Expect(1, 2143, '\P{^Block:	mandaic}', "");
    Expect(0, 2144, '\p{Block:	mandaic}', "");
    Expect(1, 2144, '\p{^Block:	mandaic}', "");
    Expect(1, 2144, '\P{Block:	mandaic}', "");
    Expect(0, 2144, '\P{^Block:	mandaic}', "");
    Expect(1, 2143, '\p{Block=:\Amandaic\z:}', "");;
    Expect(0, 2144, '\p{Block=:\Amandaic\z:}', "");;
    Expect(1, 2143, '\p{Block=		MANDAIC}', "");
    Expect(0, 2143, '\p{^Block=		MANDAIC}', "");
    Expect(0, 2143, '\P{Block=		MANDAIC}', "");
    Expect(1, 2143, '\P{^Block=		MANDAIC}', "");
    Expect(0, 2144, '\p{Block=		MANDAIC}', "");
    Expect(1, 2144, '\p{^Block=		MANDAIC}', "");
    Expect(1, 2144, '\P{Block=		MANDAIC}', "");
    Expect(0, 2144, '\P{^Block=		MANDAIC}', "");
    Error('\p{Blk= /a/Mandaic}');
    Error('\P{Blk= /a/Mandaic}');
    Expect(1, 2143, '\p{Blk=:\AMandaic\z:}', "");;
    Expect(0, 2144, '\p{Blk=:\AMandaic\z:}', "");;
    Expect(1, 2143, '\p{Blk: mandaic}', "");
    Expect(0, 2143, '\p{^Blk: mandaic}', "");
    Expect(0, 2143, '\P{Blk: mandaic}', "");
    Expect(1, 2143, '\P{^Blk: mandaic}', "");
    Expect(0, 2144, '\p{Blk: mandaic}', "");
    Expect(1, 2144, '\p{^Blk: mandaic}', "");
    Expect(1, 2144, '\P{Blk: mandaic}', "");
    Expect(0, 2144, '\P{^Blk: mandaic}', "");
    Expect(1, 2143, '\p{Blk=:\Amandaic\z:}', "");;
    Expect(0, 2144, '\p{Blk=:\Amandaic\z:}', "");;
    Expect(1, 2143, '\p{Blk=		Mandaic}', "");
    Expect(0, 2143, '\p{^Blk=		Mandaic}', "");
    Expect(0, 2143, '\P{Blk=		Mandaic}', "");
    Expect(1, 2143, '\P{^Blk=		Mandaic}', "");
    Expect(0, 2144, '\p{Blk=		Mandaic}', "");
    Expect(1, 2144, '\p{^Blk=		Mandaic}', "");
    Expect(1, 2144, '\P{Blk=		Mandaic}', "");
    Expect(0, 2144, '\P{^Blk=		Mandaic}', "");
    Error('\p{Is_Block=/a/Mandaic}');
    Error('\P{Is_Block=/a/Mandaic}');
    Expect(1, 2143, '\p{Is_Block:   mandaic}', "");
    Expect(0, 2143, '\p{^Is_Block:   mandaic}', "");
    Expect(0, 2143, '\P{Is_Block:   mandaic}', "");
    Expect(1, 2143, '\P{^Is_Block:   mandaic}', "");
    Expect(0, 2144, '\p{Is_Block:   mandaic}', "");
    Expect(1, 2144, '\p{^Is_Block:   mandaic}', "");
    Expect(1, 2144, '\P{Is_Block:   mandaic}', "");
    Expect(0, 2144, '\P{^Is_Block:   mandaic}', "");
    Expect(1, 2143, '\p{Is_Block=Mandaic}', "");
    Expect(0, 2143, '\p{^Is_Block=Mandaic}', "");
    Expect(0, 2143, '\P{Is_Block=Mandaic}', "");
    Expect(1, 2143, '\P{^Is_Block=Mandaic}', "");
    Expect(0, 2144, '\p{Is_Block=Mandaic}', "");
    Expect(1, 2144, '\p{^Is_Block=Mandaic}', "");
    Expect(1, 2144, '\P{Is_Block=Mandaic}', "");
    Expect(0, 2144, '\P{^Is_Block=Mandaic}', "");
    Error('\p{Is_Blk=	_mandaic/a/}');
    Error('\P{Is_Blk=	_mandaic/a/}');
    Expect(1, 2143, '\p{Is_Blk=mandaic}', "");
    Expect(0, 2143, '\p{^Is_Blk=mandaic}', "");
    Expect(0, 2143, '\P{Is_Blk=mandaic}', "");
    Expect(1, 2143, '\P{^Is_Blk=mandaic}', "");
    Expect(0, 2144, '\p{Is_Blk=mandaic}', "");
    Expect(1, 2144, '\p{^Is_Blk=mandaic}', "");
    Expect(1, 2144, '\P{Is_Blk=mandaic}', "");
    Expect(0, 2144, '\P{^Is_Blk=mandaic}', "");
    Expect(1, 2143, '\p{Is_Blk=_-Mandaic}', "");
    Expect(0, 2143, '\p{^Is_Blk=_-Mandaic}', "");
    Expect(0, 2143, '\P{Is_Blk=_-Mandaic}', "");
    Expect(1, 2143, '\P{^Is_Blk=_-Mandaic}', "");
    Expect(0, 2144, '\p{Is_Blk=_-Mandaic}', "");
    Expect(1, 2144, '\p{^Is_Blk=_-Mandaic}', "");
    Expect(1, 2144, '\P{Is_Blk=_-Mandaic}', "");
    Expect(0, 2144, '\P{^Is_Blk=_-Mandaic}', "");
    Error('\p{Block=/a/Manichaean}');
    Error('\P{Block=/a/Manichaean}');
    Expect(1, 68351, '\p{Block=:\AManichaean\z:}', "");;
    Expect(0, 68352, '\p{Block=:\AManichaean\z:}', "");;
    Expect(1, 68351, '\p{Block=manichaean}', "");
    Expect(0, 68351, '\p{^Block=manichaean}', "");
    Expect(0, 68351, '\P{Block=manichaean}', "");
    Expect(1, 68351, '\P{^Block=manichaean}', "");
    Expect(0, 68352, '\p{Block=manichaean}', "");
    Expect(1, 68352, '\p{^Block=manichaean}', "");
    Expect(1, 68352, '\P{Block=manichaean}', "");
    Expect(0, 68352, '\P{^Block=manichaean}', "");
    Expect(1, 68351, '\p{Block=:\Amanichaean\z:}', "");;
    Expect(0, 68352, '\p{Block=:\Amanichaean\z:}', "");;
    Expect(1, 68351, '\p{Block=	_manichaean}', "");
    Expect(0, 68351, '\p{^Block=	_manichaean}', "");
    Expect(0, 68351, '\P{Block=	_manichaean}', "");
    Expect(1, 68351, '\P{^Block=	_manichaean}', "");
    Expect(0, 68352, '\p{Block=	_manichaean}', "");
    Expect(1, 68352, '\p{^Block=	_manichaean}', "");
    Expect(1, 68352, '\P{Block=	_manichaean}', "");
    Expect(0, 68352, '\P{^Block=	_manichaean}', "");
    Error('\p{Blk:/a/ -manichaean}');
    Error('\P{Blk:/a/ -manichaean}');
    Expect(1, 68351, '\p{Blk=:\AManichaean\z:}', "");;
    Expect(0, 68352, '\p{Blk=:\AManichaean\z:}', "");;
    Expect(1, 68351, '\p{Blk=manichaean}', "");
    Expect(0, 68351, '\p{^Blk=manichaean}', "");
    Expect(0, 68351, '\P{Blk=manichaean}', "");
    Expect(1, 68351, '\P{^Blk=manichaean}', "");
    Expect(0, 68352, '\p{Blk=manichaean}', "");
    Expect(1, 68352, '\p{^Blk=manichaean}', "");
    Expect(1, 68352, '\P{Blk=manichaean}', "");
    Expect(0, 68352, '\P{^Blk=manichaean}', "");
    Expect(1, 68351, '\p{Blk=:\Amanichaean\z:}', "");;
    Expect(0, 68352, '\p{Blk=:\Amanichaean\z:}', "");;
    Expect(1, 68351, '\p{Blk=--manichaean}', "");
    Expect(0, 68351, '\p{^Blk=--manichaean}', "");
    Expect(0, 68351, '\P{Blk=--manichaean}', "");
    Expect(1, 68351, '\P{^Blk=--manichaean}', "");
    Expect(0, 68352, '\p{Blk=--manichaean}', "");
    Expect(1, 68352, '\p{^Blk=--manichaean}', "");
    Expect(1, 68352, '\P{Blk=--manichaean}', "");
    Expect(0, 68352, '\P{^Blk=--manichaean}', "");
    Error('\p{Is_Block=_/a/MANICHAEAN}');
    Error('\P{Is_Block=_/a/MANICHAEAN}');
    Expect(1, 68351, '\p{Is_Block=manichaean}', "");
    Expect(0, 68351, '\p{^Is_Block=manichaean}', "");
    Expect(0, 68351, '\P{Is_Block=manichaean}', "");
    Expect(1, 68351, '\P{^Is_Block=manichaean}', "");
    Expect(0, 68352, '\p{Is_Block=manichaean}', "");
    Expect(1, 68352, '\p{^Is_Block=manichaean}', "");
    Expect(1, 68352, '\P{Is_Block=manichaean}', "");
    Expect(0, 68352, '\P{^Is_Block=manichaean}', "");
    Expect(1, 68351, '\p{Is_Block=-_manichaean}', "");
    Expect(0, 68351, '\p{^Is_Block=-_manichaean}', "");
    Expect(0, 68351, '\P{Is_Block=-_manichaean}', "");
    Expect(1, 68351, '\P{^Is_Block=-_manichaean}', "");
    Expect(0, 68352, '\p{Is_Block=-_manichaean}', "");
    Expect(1, 68352, '\p{^Is_Block=-_manichaean}', "");
    Expect(1, 68352, '\P{Is_Block=-_manichaean}', "");
    Expect(0, 68352, '\P{^Is_Block=-_manichaean}', "");
    Error('\p{Is_Blk=_/a/manichaean}');
    Error('\P{Is_Blk=_/a/manichaean}');
    Expect(1, 68351, '\p{Is_Blk=manichaean}', "");
    Expect(0, 68351, '\p{^Is_Blk=manichaean}', "");
    Expect(0, 68351, '\P{Is_Blk=manichaean}', "");
    Expect(1, 68351, '\P{^Is_Blk=manichaean}', "");
    Expect(0, 68352, '\p{Is_Blk=manichaean}', "");
    Expect(1, 68352, '\p{^Is_Blk=manichaean}', "");
    Expect(1, 68352, '\P{Is_Blk=manichaean}', "");
    Expect(0, 68352, '\P{^Is_Blk=manichaean}', "");
    Expect(1, 68351, '\p{Is_Blk=	Manichaean}', "");
    Expect(0, 68351, '\p{^Is_Blk=	Manichaean}', "");
    Expect(0, 68351, '\P{Is_Blk=	Manichaean}', "");
    Expect(1, 68351, '\P{^Is_Blk=	Manichaean}', "");
    Expect(0, 68352, '\p{Is_Blk=	Manichaean}', "");
    Expect(1, 68352, '\p{^Is_Blk=	Manichaean}', "");
    Expect(1, 68352, '\P{Is_Blk=	Manichaean}', "");
    Expect(0, 68352, '\P{^Is_Blk=	Manichaean}', "");
    Error('\p{Block=_:=marchen}');
    Error('\P{Block=_:=marchen}');
    Expect(1, 72895, '\p{Block=:\AMarchen\z:}', "");;
    Expect(0, 72896, '\p{Block=:\AMarchen\z:}', "");;
    Expect(1, 72895, '\p{Block=marchen}', "");
    Expect(0, 72895, '\p{^Block=marchen}', "");
    Expect(0, 72895, '\P{Block=marchen}', "");
    Expect(1, 72895, '\P{^Block=marchen}', "");
    Expect(0, 72896, '\p{Block=marchen}', "");
    Expect(1, 72896, '\p{^Block=marchen}', "");
    Expect(1, 72896, '\P{Block=marchen}', "");
    Expect(0, 72896, '\P{^Block=marchen}', "");
    Expect(1, 72895, '\p{Block=:\Amarchen\z:}', "");;
    Expect(0, 72896, '\p{Block=:\Amarchen\z:}', "");;
    Expect(1, 72895, '\p{Block= _MARCHEN}', "");
    Expect(0, 72895, '\p{^Block= _MARCHEN}', "");
    Expect(0, 72895, '\P{Block= _MARCHEN}', "");
    Expect(1, 72895, '\P{^Block= _MARCHEN}', "");
    Expect(0, 72896, '\p{Block= _MARCHEN}', "");
    Expect(1, 72896, '\p{^Block= _MARCHEN}', "");
    Expect(1, 72896, '\P{Block= _MARCHEN}', "");
    Expect(0, 72896, '\P{^Block= _MARCHEN}', "");
    Error('\p{Blk=	/a/Marchen}');
    Error('\P{Blk=	/a/Marchen}');
    Expect(1, 72895, '\p{Blk=:\AMarchen\z:}', "");;
    Expect(0, 72896, '\p{Blk=:\AMarchen\z:}', "");;
    Expect(1, 72895, '\p{Blk=marchen}', "");
    Expect(0, 72895, '\p{^Blk=marchen}', "");
    Expect(0, 72895, '\P{Blk=marchen}', "");
    Expect(1, 72895, '\P{^Blk=marchen}', "");
    Expect(0, 72896, '\p{Blk=marchen}', "");
    Expect(1, 72896, '\p{^Blk=marchen}', "");
    Expect(1, 72896, '\P{Blk=marchen}', "");
    Expect(0, 72896, '\P{^Blk=marchen}', "");
    Expect(1, 72895, '\p{Blk=:\Amarchen\z:}', "");;
    Expect(0, 72896, '\p{Blk=:\Amarchen\z:}', "");;
    Error('\p{Is_Block: -:=marchen}');
    Error('\P{Is_Block: -:=marchen}');
    Expect(1, 72895, '\p{Is_Block=marchen}', "");
    Expect(0, 72895, '\p{^Is_Block=marchen}', "");
    Expect(0, 72895, '\P{Is_Block=marchen}', "");
    Expect(1, 72895, '\P{^Is_Block=marchen}', "");
    Expect(0, 72896, '\p{Is_Block=marchen}', "");
    Expect(1, 72896, '\p{^Is_Block=marchen}', "");
    Expect(1, 72896, '\P{Is_Block=marchen}', "");
    Expect(0, 72896, '\P{^Is_Block=marchen}', "");
    Expect(1, 72895, '\p{Is_Block=--marchen}', "");
    Expect(0, 72895, '\p{^Is_Block=--marchen}', "");
    Expect(0, 72895, '\P{Is_Block=--marchen}', "");
    Expect(1, 72895, '\P{^Is_Block=--marchen}', "");
    Expect(0, 72896, '\p{Is_Block=--marchen}', "");
    Expect(1, 72896, '\p{^Is_Block=--marchen}', "");
    Expect(1, 72896, '\P{Is_Block=--marchen}', "");
    Expect(0, 72896, '\P{^Is_Block=--marchen}', "");
    Error('\p{Is_Blk=:=--Marchen}');
    Error('\P{Is_Blk=:=--Marchen}');
    Expect(1, 72895, '\p{Is_Blk=marchen}', "");
    Expect(0, 72895, '\p{^Is_Blk=marchen}', "");
    Expect(0, 72895, '\P{Is_Blk=marchen}', "");
    Expect(1, 72895, '\P{^Is_Blk=marchen}', "");
    Expect(0, 72896, '\p{Is_Blk=marchen}', "");
    Expect(1, 72896, '\p{^Is_Blk=marchen}', "");
    Expect(1, 72896, '\P{Is_Blk=marchen}', "");
    Expect(0, 72896, '\P{^Is_Blk=marchen}', "");
    Expect(1, 72895, '\p{Is_Blk=_Marchen}', "");
    Expect(0, 72895, '\p{^Is_Blk=_Marchen}', "");
    Expect(0, 72895, '\P{Is_Blk=_Marchen}', "");
    Expect(1, 72895, '\P{^Is_Blk=_Marchen}', "");
    Expect(0, 72896, '\p{Is_Blk=_Marchen}', "");
    Expect(1, 72896, '\p{^Is_Blk=_Marchen}', "");
    Expect(1, 72896, '\P{Is_Blk=_Marchen}', "");
    Expect(0, 72896, '\P{^Is_Blk=_Marchen}', "");
    Error('\p{Block=/a/Masaram_Gondi}');
    Error('\P{Block=/a/Masaram_Gondi}');
    Expect(1, 73055, '\p{Block=:\AMasaram_Gondi\z:}', "");;
    Expect(0, 73056, '\p{Block=:\AMasaram_Gondi\z:}', "");;
    Expect(1, 73055, '\p{Block=masaramgondi}', "");
    Expect(0, 73055, '\p{^Block=masaramgondi}', "");
    Expect(0, 73055, '\P{Block=masaramgondi}', "");
    Expect(1, 73055, '\P{^Block=masaramgondi}', "");
    Expect(0, 73056, '\p{Block=masaramgondi}', "");
    Expect(1, 73056, '\p{^Block=masaramgondi}', "");
    Expect(1, 73056, '\P{Block=masaramgondi}', "");
    Expect(0, 73056, '\P{^Block=masaramgondi}', "");
    Expect(1, 73055, '\p{Block=:\Amasaramgondi\z:}', "");;
    Expect(0, 73056, '\p{Block=:\Amasaramgondi\z:}', "");;
    Expect(1, 73055, '\p{Block=__MASARAM_Gondi}', "");
    Expect(0, 73055, '\p{^Block=__MASARAM_Gondi}', "");
    Expect(0, 73055, '\P{Block=__MASARAM_Gondi}', "");
    Expect(1, 73055, '\P{^Block=__MASARAM_Gondi}', "");
    Expect(0, 73056, '\p{Block=__MASARAM_Gondi}', "");
    Expect(1, 73056, '\p{^Block=__MASARAM_Gondi}', "");
    Expect(1, 73056, '\P{Block=__MASARAM_Gondi}', "");
    Expect(0, 73056, '\P{^Block=__MASARAM_Gondi}', "");
    Error('\p{Blk=-/a/Masaram_GONDI}');
    Error('\P{Blk=-/a/Masaram_GONDI}');
    Expect(1, 73055, '\p{Blk=:\AMasaram_Gondi\z:}', "");;
    Expect(0, 73056, '\p{Blk=:\AMasaram_Gondi\z:}', "");;
    Expect(1, 73055, '\p{Blk=masaramgondi}', "");
    Expect(0, 73055, '\p{^Blk=masaramgondi}', "");
    Expect(0, 73055, '\P{Blk=masaramgondi}', "");
    Expect(1, 73055, '\P{^Blk=masaramgondi}', "");
    Expect(0, 73056, '\p{Blk=masaramgondi}', "");
    Expect(1, 73056, '\p{^Blk=masaramgondi}', "");
    Expect(1, 73056, '\P{Blk=masaramgondi}', "");
    Expect(0, 73056, '\P{^Blk=masaramgondi}', "");
    Expect(1, 73055, '\p{Blk=:\Amasaramgondi\z:}', "");;
    Expect(0, 73056, '\p{Blk=:\Amasaramgondi\z:}', "");;
    Expect(1, 73055, '\p{Blk=- Masaram_GONDI}', "");
    Expect(0, 73055, '\p{^Blk=- Masaram_GONDI}', "");
    Expect(0, 73055, '\P{Blk=- Masaram_GONDI}', "");
    Expect(1, 73055, '\P{^Blk=- Masaram_GONDI}', "");
    Expect(0, 73056, '\p{Blk=- Masaram_GONDI}', "");
    Expect(1, 73056, '\p{^Blk=- Masaram_GONDI}', "");
    Expect(1, 73056, '\P{Blk=- Masaram_GONDI}', "");
    Expect(0, 73056, '\P{^Blk=- Masaram_GONDI}', "");
    Error('\p{Is_Block: /a/_masaram_Gondi}');
    Error('\P{Is_Block: /a/_masaram_Gondi}');
    Expect(1, 73055, '\p{Is_Block: masaramgondi}', "");
    Expect(0, 73055, '\p{^Is_Block: masaramgondi}', "");
    Expect(0, 73055, '\P{Is_Block: masaramgondi}', "");
    Expect(1, 73055, '\P{^Is_Block: masaramgondi}', "");
    Expect(0, 73056, '\p{Is_Block: masaramgondi}', "");
    Expect(1, 73056, '\p{^Is_Block: masaramgondi}', "");
    Expect(1, 73056, '\P{Is_Block: masaramgondi}', "");
    Expect(0, 73056, '\P{^Is_Block: masaramgondi}', "");
    Expect(1, 73055, '\p{Is_Block=_ masaram_Gondi}', "");
    Expect(0, 73055, '\p{^Is_Block=_ masaram_Gondi}', "");
    Expect(0, 73055, '\P{Is_Block=_ masaram_Gondi}', "");
    Expect(1, 73055, '\P{^Is_Block=_ masaram_Gondi}', "");
    Expect(0, 73056, '\p{Is_Block=_ masaram_Gondi}', "");
    Expect(1, 73056, '\p{^Is_Block=_ masaram_Gondi}', "");
    Expect(1, 73056, '\P{Is_Block=_ masaram_Gondi}', "");
    Expect(0, 73056, '\P{^Is_Block=_ masaram_Gondi}', "");
    Error('\p{Is_Blk=_:=masaram_Gondi}');
    Error('\P{Is_Blk=_:=masaram_Gondi}');
    Expect(1, 73055, '\p{Is_Blk=masaramgondi}', "");
    Expect(0, 73055, '\p{^Is_Blk=masaramgondi}', "");
    Expect(0, 73055, '\P{Is_Blk=masaramgondi}', "");
    Expect(1, 73055, '\P{^Is_Blk=masaramgondi}', "");
    Expect(0, 73056, '\p{Is_Blk=masaramgondi}', "");
    Expect(1, 73056, '\p{^Is_Blk=masaramgondi}', "");
    Expect(1, 73056, '\P{Is_Blk=masaramgondi}', "");
    Expect(0, 73056, '\P{^Is_Blk=masaramgondi}', "");
    Expect(1, 73055, '\p{Is_Blk:    masaram_Gondi}', "");
    Expect(0, 73055, '\p{^Is_Blk:    masaram_Gondi}', "");
    Expect(0, 73055, '\P{Is_Blk:    masaram_Gondi}', "");
    Expect(1, 73055, '\P{^Is_Blk:    masaram_Gondi}', "");
    Expect(0, 73056, '\p{Is_Blk:    masaram_Gondi}', "");
    Expect(1, 73056, '\p{^Is_Blk:    masaram_Gondi}', "");
    Expect(1, 73056, '\P{Is_Blk:    masaram_Gondi}', "");
    Expect(0, 73056, '\P{^Is_Blk:    masaram_Gondi}', "");
    Error('\p{Block=:=mathematical_alphanumeric_symbols}');
    Error('\P{Block=:=mathematical_alphanumeric_symbols}');
    Expect(1, 120831, '\p{Block=:\AMathematical_Alphanumeric_Symbols\z:}', "");;
    Expect(0, 120832, '\p{Block=:\AMathematical_Alphanumeric_Symbols\z:}', "");;
    Expect(1, 120831, '\p{Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120831, '\p{^Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120831, '\P{Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120831, '\P{^Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120832, '\p{Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120832, '\p{^Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120832, '\P{Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120832, '\P{^Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120831, '\p{Block=:\Amathematicalalphanumericsymbols\z:}', "");;
    Expect(0, 120832, '\p{Block=:\Amathematicalalphanumericsymbols\z:}', "");;
    Expect(1, 120831, '\p{Block=_Mathematical_alphanumeric_Symbols}', "");
    Expect(0, 120831, '\p{^Block=_Mathematical_alphanumeric_Symbols}', "");
    Expect(0, 120831, '\P{Block=_Mathematical_alphanumeric_Symbols}', "");
    Expect(1, 120831, '\P{^Block=_Mathematical_alphanumeric_Symbols}', "");
    Expect(0, 120832, '\p{Block=_Mathematical_alphanumeric_Symbols}', "");
    Expect(1, 120832, '\p{^Block=_Mathematical_alphanumeric_Symbols}', "");
    Expect(1, 120832, '\P{Block=_Mathematical_alphanumeric_Symbols}', "");
    Expect(0, 120832, '\P{^Block=_Mathematical_alphanumeric_Symbols}', "");
    Error('\p{Blk=  Math_ALPHANUM:=}');
    Error('\P{Blk=  Math_ALPHANUM:=}');
    Expect(1, 120831, '\p{Blk=:\AMath_Alphanum\z:}', "");;
    Expect(0, 120832, '\p{Blk=:\AMath_Alphanum\z:}', "");;
    Expect(1, 120831, '\p{Blk=mathalphanum}', "");
    Expect(0, 120831, '\p{^Blk=mathalphanum}', "");
    Expect(0, 120831, '\P{Blk=mathalphanum}', "");
    Expect(1, 120831, '\P{^Blk=mathalphanum}', "");
    Expect(0, 120832, '\p{Blk=mathalphanum}', "");
    Expect(1, 120832, '\p{^Blk=mathalphanum}', "");
    Expect(1, 120832, '\P{Blk=mathalphanum}', "");
    Expect(0, 120832, '\P{^Blk=mathalphanum}', "");
    Expect(1, 120831, '\p{Blk=:\Amathalphanum\z:}', "");;
    Expect(0, 120832, '\p{Blk=:\Amathalphanum\z:}', "");;
    Expect(1, 120831, '\p{Blk= 	math_Alphanum}', "");
    Expect(0, 120831, '\p{^Blk= 	math_Alphanum}', "");
    Expect(0, 120831, '\P{Blk= 	math_Alphanum}', "");
    Expect(1, 120831, '\P{^Blk= 	math_Alphanum}', "");
    Expect(0, 120832, '\p{Blk= 	math_Alphanum}', "");
    Expect(1, 120832, '\p{^Blk= 	math_Alphanum}', "");
    Expect(1, 120832, '\P{Blk= 	math_Alphanum}', "");
    Expect(0, 120832, '\P{^Blk= 	math_Alphanum}', "");
    Error('\p{Is_Block:   -:=Mathematical_ALPHANUMERIC_Symbols}');
    Error('\P{Is_Block:   -:=Mathematical_ALPHANUMERIC_Symbols}');
    Expect(1, 120831, '\p{Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120831, '\p{^Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120831, '\P{Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120831, '\P{^Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120832, '\p{Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120832, '\p{^Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120832, '\P{Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120832, '\P{^Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120831, '\p{Is_Block:-_Mathematical_Alphanumeric_Symbols}', "");
    Expect(0, 120831, '\p{^Is_Block:-_Mathematical_Alphanumeric_Symbols}', "");
    Expect(0, 120831, '\P{Is_Block:-_Mathematical_Alphanumeric_Symbols}', "");
    Expect(1, 120831, '\P{^Is_Block:-_Mathematical_Alphanumeric_Symbols}', "");
    Expect(0, 120832, '\p{Is_Block:-_Mathematical_Alphanumeric_Symbols}', "");
    Expect(1, 120832, '\p{^Is_Block:-_Mathematical_Alphanumeric_Symbols}', "");
    Expect(1, 120832, '\P{Is_Block:-_Mathematical_Alphanumeric_Symbols}', "");
    Expect(0, 120832, '\P{^Is_Block:-_Mathematical_Alphanumeric_Symbols}', "");
    Error('\p{Is_Blk=:=-Math_ALPHANUM}');
    Error('\P{Is_Blk=:=-Math_ALPHANUM}');
    Expect(1, 120831, '\p{Is_Blk=mathalphanum}', "");
    Expect(0, 120831, '\p{^Is_Blk=mathalphanum}', "");
    Expect(0, 120831, '\P{Is_Blk=mathalphanum}', "");
    Expect(1, 120831, '\P{^Is_Blk=mathalphanum}', "");
    Expect(0, 120832, '\p{Is_Blk=mathalphanum}', "");
    Expect(1, 120832, '\p{^Is_Blk=mathalphanum}', "");
    Expect(1, 120832, '\P{Is_Blk=mathalphanum}', "");
    Expect(0, 120832, '\P{^Is_Blk=mathalphanum}', "");
    Expect(1, 120831, '\p{Is_Blk=	MATH_alphanum}', "");
    Expect(0, 120831, '\p{^Is_Blk=	MATH_alphanum}', "");
    Expect(0, 120831, '\P{Is_Blk=	MATH_alphanum}', "");
    Expect(1, 120831, '\P{^Is_Blk=	MATH_alphanum}', "");
    Expect(0, 120832, '\p{Is_Blk=	MATH_alphanum}', "");
    Expect(1, 120832, '\p{^Is_Blk=	MATH_alphanum}', "");
    Expect(1, 120832, '\P{Is_Blk=	MATH_alphanum}', "");
    Expect(0, 120832, '\P{^Is_Blk=	MATH_alphanum}', "");
    Error('\p{Block=-mathematical_Operators:=}');
    Error('\P{Block=-mathematical_Operators:=}');
    Expect(1, 8959, '\p{Block=:\AMathematical_Operators\z:}', "");;
    Expect(0, 8960, '\p{Block=:\AMathematical_Operators\z:}', "");;
    Expect(1, 8959, '\p{Block=mathematicaloperators}', "");