static char SCCSID[] = "@(#)scroll.c	1.1 89/02/08";
/*
 * Copyright 1989 Siemens
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Siemens not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Siemens makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Claus Gittinger, Siemens Munich, unido!sinix!claus@uunet.uu.net
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "externals.h"

static GC myGC;

#define SCROLLWIDTH     640
#define SCROLLHEIGHT    400

/*
 * screen->screen copy area vertical only
 *
 * special case for scrolling
 */
scroll_setup(dpy, win, dummy)
Display *dpy;
Window win;
{
	int screen = DefaultScreen(dpy);

	myGC = XCreateGC(dpy, win, 0L, NULL);
	if (! myGC) return 1;
	XSetForeground(dpy, myGC, WhitePixel(dpy, screen));
	XSetBackground(dpy, myGC, BlackPixel(dpy, screen));
	XDrawImageString(dpy, win, myGC, 0, SCROLLHEIGHT+5, "scroll", 6);

	return 0;
}

scroll_cleanup(dpy, win, dummy)
Display *dpy;
Window win;
{
	XFreeGC(dpy, myGC);
}

scroll_bench(dpy, win, delta)
Display *dpy;
Window win;
{
	int ncopy;

	ncopy= 0;
	while (benchRunning) {
	    XCopyArea(dpy, win, win, myGC, 0, delta, SCROLLWIDTH, SCROLLHEIGHT,
						 0, 0);
	    if (sync) XSync(dpy, 0);
	    ncopy++;
	}
	return ncopy;
}

scroll_msg(deltaT, ncopy, delta, rate)
double rate;
{
	printf("SCROLL\n");
	printf("\n");
	printf("%d scrolls (area: %d x %d) in %d secs\n",
				ncopy, SCROLLWIDTH, SCROLLHEIGHT, delta, deltaT);
	printf("rate = %8.2f scrolls/sec (%d Pixels/sec)\n",
				rate,
				(ncopy*SCROLLWIDTH*SCROLLHEIGHT)/deltaT);
}
