static char SCCSID[] = "@(#)arcs.c	1.1 89/02/08";
/*
 * Copyright 1989 Siemens
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Siemens not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Siemens makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Claus Gittinger, Siemens Munich, unido!sinix!claus@uunet.uu.net
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "externals.h"

static GC drawWhite, drawBlack;

/*
 * arcs
 */
arcs_setup(dpy, win, dummy)
Display *dpy;
Window win;
{
	int screen = DefaultScreen(dpy);

	drawWhite = XCreateGC(dpy, win, 0L, NULL);
	if (! drawWhite) return 1;
	XSetForeground(dpy, drawWhite, WhitePixel(dpy, screen));
	XSetBackground(dpy, drawWhite, BlackPixel(dpy, screen));

	drawBlack = XCreateGC(dpy, win, 0L, NULL);
	if (!drawBlack) return 1;
	XSetForeground(dpy, drawBlack, BlackPixel(dpy, screen));
	XSetBackground(dpy, drawBlack, WhitePixel(dpy, screen));

	return 0;
}

arcs_cleanup(dpy, win, dummy)
Display *dpy;
Window win;
{
	XFreeGC(dpy, drawWhite);
	XFreeGC(dpy, drawBlack);
}

arcs_bench(dpy, win, len)
Display *dpy;
Window win;
{
	int angle;
	int narcs;

	angle = 5*64;
	narcs = 0;
	while (benchRunning) {
	    XDrawArc(dpy, win, drawWhite, 0, 0, len, len, 0, angle);
	    XDrawArc(dpy, win, drawBlack, 0, 0, len, len, 0, angle);
	    angle += 5*64;
	    if (angle >= 360*64) {
		angle = 5*64;
	    }
	    if (sync) XSync(dpy, 0);
	    narcs += 2;
	}
	return narcs;
}

arcs_msg(deltaT, narcs, len, rate)
double rate;
{
	printf("ARCS\n");
	printf("\n");
	printf("%d arcs with %d pixel diameter in %d secs\n",
				narcs, len, deltaT);
	printf("rate = %8.2f arcs/sec\n", rate);
}
