//////////////////////////////////////////////////////
//	STR.HPP	Null-Ended String Class
//////////////////////////////////////////////////////
#if !defined(STR_HPP)
#define STR_HPP
#include <string.h>

/**
#include "AFC.HPP"
extern TRACER* t;
**/

class STR {
	char *s;	// free store pointer
	int  l;		// strlen + 1

public:
	STR();					// STR Dummy; l=1
	STR(const STR&);
	STR(const char szS[]);	// STR V("abc"); l=4
	STR(int);      			// STR V(25); s[0]=0, l=26
	~STR();

	operator const char* () const { return s; }
	int len() const { return strlen(s); }
	int space() const { return l-1; }

	STR& operator=(const STR &y);
	STR& operator+=(const STR &y);
	int operator==(const STR &y) const
			{ return (0 == strcmp(s, y.s)); }
	int operator!=(const STR &y) const
			{ return (0 != strcmp(s, y.s)); }

	STR& operator=(const char szS[]);
	STR& operator+=(const char szS[]);
	int operator==(const char szS[]) const
			{ return (0 == strcmp(s, szS)); }
	int operator!=(const char szS[]) const
			{ return (0 != strcmp(s, szS)); }

	STR& operator=(char c);
	STR& operator+=(char c);

	char& operator[](int i) { return s[i]; }
	const char& operator[](int i) const
			{ return s[i]; }

	int streq(const char szS[]) const;
	int hasin(const char szSubstring[],
			int nFromIndex = 0, int bIgnoreCase = 0
			) const ;// returns absolute index or -1
	int hasin(char c,
			int nFromIndex = 0, int bIgnoreCase = 0
			) const ;// returns absolute index or -1

	STR& toupper() { strupr(s); return *this; }
	STR& tolower() { strlwr(s); return *this; }
	void noFrontSpace();	// "  \t\nabc" --> "abc"
	void noTrailSpace();	// "abc  \t\n " --> "abc"
};
#endif
