/////////////////////////////////////////////////////
//	SHOWDATA implementation
/////////////////////////////////////////////////////
#include "SHOWDATA.HPP"
#include "MODALDLG.HPP"

#include <stdlib.h>
#include <stdio.h>

SHOWDATA::SHOWDATA(
	const char szStorFile[], const char szStorSect[])
	: ASSOCMEM(),
	_name(szStorFile),
	_sect(szStorSect ? szStorSect : "DEFAULT")
{
_dlg = 0;
}

SHOWDATA::~SHOWDATA()
{
if(_dlg != 0){
	delete _dlg;
	_dlg = 0;
	}
}

const char* SHOWDATA::get(const char szS[],
						STR& Val) const
{
int k;
int i = 80;
while (TRUE){
	STR temp(i);
	k = GetPrivateProfileString(_sect, szS, Val,
			(char*)(const char*)temp, i, _name);
	if(k < i-1){
		Val = temp;
		return Val;
		}
	else	i *= 2;
	}
}

int SHOWDATA::get(const char szS[], int nDef) const
{
return GetPrivateProfileInt(_sect, szS, nDef, _name);
}

void SHOWDATA::set(const char szS[], const char szVal[])
{
WritePrivateProfileString(_sect, szS, szVal, _name);
}

void SHOWDATA::set(const char szSym[], int nNumValue)
{
char Buff[16];
itoa(nNumValue, Buff, 10);
WritePrivateProfileString(_sect, szSym, Buff, _name);
}

SHOWDATA::RET
SHOWDATA::modalDlg(HWND hWndParent,
			HINSTANCE hInst,
			const char szDescFile[],
			const char szDescSect[],
			const char szResourceType[])
{
RET Ret;
if(0 != _dlg)
	return INTERNALERR;
_dlg = new MODALDLG(this, hWndParent, hInst,
			szDescFile, szDescSect, szResourceType);
if(0 == _dlg)
	return MEMORYOUT;
Ret = _dlg->isValid();
if(OK != Ret)
	return Ret;
Ret = _dlg->run();
delete _dlg;
_dlg = 0;
return Ret;
}
