// MODAL1, MODALDLG's geometry
//////////////////////////////////////////////////////
#include "MODALDLG.HPP"
#include "KW.HPP"

const int MODALDLG::DUXMARGIN = 4;
const int MODALDLG::DUYMARGIN = 4;

const MODALDLG::DLGHEADER MODALDLG::_DlgHd = {
	DS_SETFONT | DS_MODALFRAME |
		DS_ABSALIGN | WS_SYSMENU,
	0,
	0, 0,
	0, 0,
	'\0',
	'\0',
	'\0',
	8,
	"MS Sans Serif"
	};

BOOL MODALDLG::_initGeometry()
{
_template.add((unsigned char*)&_DlgHd,
				sizeof(_DlgHd));
MULTIPARAM Iter(&_dlgline, KW::G);
_ng = Iter.no();
if(0 == (_pGXY = new GRPXY[_ng ? _ng : 1])){
	_valid = SHOWDATA::MEMORYOUT;
	return FALSE;
	}
for(int i = 0; i < _ng; i++){
	Iter.value(i, _pGXY[i].name);
	_pGXY[i].duwLabel = duwText(_pGXY[i].name, TRUE);
	_pGXY[i].duhLabel = duhPush();
	_pGXY[i].duwAll = _pGXY[i].duwLabel;
	_pGXY[i].duhAll = _pGXY[i].duhLabel + DUYMARGIN;
	_pGXY[i].duwAll = _pGXY[i].duwLabel;
	_pGXY[i].duxNext = DUXMARGIN;
	_pGXY[i].duyNext = _pGXY[i].duhAll;
	}
if(i == 0){	// no defined groups
	_pGXY[i].duwLabel = _pGXY[i].duhLabel = 0;
	_pGXY[i].duwAll = _pGXY[i].duxNext = DUXMARGIN;
	_pGXY[i].duhAll = _pGXY[i].duyNext = DUYMARGIN;
	}
return TRUE;
}

void MODALDLG::_addToGroupGeometry(int nGrp,
						int duW, int duH)
{
_pGXY[nGrp].duwAll = max(_pGXY[nGrp].duwAll,
							duW+2*DUXMARGIN);
_pGXY[nGrp].duhAll += duH + DUYMARGIN;
_pGXY[nGrp].duyNext += duH + DUYMARGIN;
}

int MODALDLG::duwText(const char szText[],
					BOOL bForButton) const
{
int rough = 4 * strlen(szText);
LOGFONT lFont;

HFONT hFont = CreateFont(
			-_DlgHd.wPointSize, 8,
			0, 0,
			700,
			0, 0, 0,
			ANSI_CHARSET, OUT_CHARACTER_PRECIS,
			CLIP_CHARACTER_PRECIS, PROOF_QUALITY,
			VARIABLE_PITCH | FF_SWISS,
			_DlgHd.szFaceName);
if(hFont == NULL)
	return rough;
if(!GetObject(hFont, sizeof(LOGFONT), (LPSTR) &lFont)){
	DeleteObject((HGDIOBJ)hFont);
	return rough;
	}
if(0 == lFont.lfWidth){
	DeleteObject((HGDIOBJ)hFont);
	return rough;
	}
HDC hDC = GetDC(NULL);
HFONT hOld = (HFONT)SelectObject(hDC, (HGDIOBJ)hFont);
RECT r = { 0, 0, 0, 0};
DrawText(hDC, szText, -1, &r, DT_CALCRECT |
		DT_CENTER | DT_SINGLELINE);
DeleteObject(SelectObject(hDC, (HGDIOBJ)hOld));
ReleaseDC(NULL, hDC);
rough = ((r.right - r.left + 1) * 4) / lFont.lfWidth;
rough += (rough % 2);
return bForButton ? rough + 4 : rough;
}

int MODALDLG::duhText() const { return 10; }
int MODALDLG::duhEdit() const { return 12; }
int MODALDLG::duhPush() const { return 14; }
int MODALDLG::duSquareBox() const { return 12; }
int MODALDLG::duwScreen() const
{ return (GetSystemMetrics(SM_CXSCREEN) * 4L) / 8; }
int MODALDLG::duhScreen() const
{ return (GetSystemMetrics(SM_CYSCREEN) * 8L) / 16; }

const CTL::DLGITEM MODALDLG::_ItemOk = {
	0, 0,
	0, 0,
	IDOK,
	BS_DEFPUSHBUTTON | WS_TABSTOP |
			WS_VISIBLE | WS_CHILD,
	0x80,
	'\0',
	0
	};

const CTL::DLGITEM MODALDLG::_ItemCan = {
	0, 0,
	0, 0,
	IDCANCEL,
	BS_PUSHBUTTON | WS_TABSTOP |
		WS_VISIBLE | WS_CHILD,
	0x80,
	'\0',
	0
	};

const CTL::DLGITEM MODALDLG::_ItemGroup = {
	0, 0,
	0, 0,
	0,
	BS_OWNERDRAW | WS_VISIBLE | WS_CHILD,
	0x80,
	'\0',
	0
	};

void MODALDLG::_putTabsAndOKCAN()
{
int i, duwDlg, duhDlg, duwGroups;

// set final # of items in dialog header:
DLGHEADER *pH = (DLGHEADER*)(_template.get());
pH->dtItemCount = _nCtls + _xOffset - 1;

// first adjustment of dialog size:
for(i = duwDlg = duhDlg = 0; i < max(1, _ng); i++){
	duwDlg = max(duwDlg, _pGXY[i].duwAll);
	duhDlg = max(duhDlg, _pGXY[i].duhAll);
	}
for(i = duwGroups = 0; i < _ng; i++)
	duwGroups += _pGXY[i].duwLabel;
duwDlg = max(duwDlg, duwGroups);

// prepare copies of OK and CANCEL:
CTL::DLGITEM ok(_ItemOk);
CTL::DLGITEM can(_ItemCan);

// OK/CANCEL height and Y pos:
duhDlg += DUYMARGIN;
ok.dtilY = can.dtilY = duhDlg;
ok.dtilCY = can.dtilCY = duhPush();
duhDlg += (2 * duhPush() + DUYMARGIN);

// OK/CANCEL width and X pos:
STR oktxt, cantxt;
_dlgline.value(KW::OK, oktxt);
_dlgline.value(KW::CANCEL, cantxt);
int okcanW = max(duwText(oktxt, TRUE),
				duwText(cantxt, TRUE)) + 24;
ok.dtilCX = can.dtilCX = okcanW;
int duwLeastOkCanLine = 8 * DUXMARGIN + 2 * okcanW;
duwDlg = max(duwDlg, duwLeastOkCanLine);
int nOneFourth = (duwDlg - 2 * okcanW) / 4;
ok.dtilX = nOneFourth;
can.dtilX = 3 * nOneFourth + okcanW;

//...and stick both on template:
_template.add((unsigned char*)&ok, sizeof(ok));
_template.add((unsigned char*)&can, sizeof(can));

// add dialog tabs
int xG = 0;
for(i = 0; i < _ng; i++){
	CTL::DLGITEM grp(_ItemGroup);
	grp.dtilID = i + 3;
	grp.dtilX = xG;
	grp.dtilY = 0;
	grp.dtilCX = _pGXY[i].duwLabel;
	grp.dtilCY = _pGXY[i].duhLabel;
	xG += grp.dtilCX;
	_template.add((unsigned char*)&grp, sizeof(grp));
	}
if(duwDlg > xG && _ng){ // add dummy to fill tab line
	CTL::DLGITEM grp(_ItemGroup);
	pH->dtItemCount += 1;
	grp.dtilID = -1;
	grp.dtilStyle |= WS_DISABLED;
	grp.dtilX = xG;
	grp.dtilY = 0;
	grp.dtilCX = duwDlg - xG;
	grp.dtilCY = _pGXY[i-1].duhLabel;
	_template.add((unsigned char*)&grp, sizeof(grp));
	}
// final dialog overall dimensions:
pH->dtCX = duwDlg;
pH->dtCY = duhDlg;
}

