Listing 1: Avoiding equal sort elements

/* Here's the definition of the structure */
struct info
        {
        char * name;  /* We'll sort the array by name */
/* Insert other fields here that we'll ignore when sorting */

/* This is the extra field used to ensure things sort correctly.
Ensure that it is always initialized to zero. */
        unsigned int extra;
        };

/* Here's the array we're going to sort */
struct info *array [100];

/* Here's the comparison routine */
int compare_info(const void *p1, const void *p2)
        {
/* The arguments point to array elements, so they are (struct info **) */
        struct info *ip1 = *(struct info **) p1;
        struct info *ip2 = *(struct info **) p2;
/* Compare the name fields */
        int r = strcmp (ip1->name, ip2->name);

/* Now deal with elements that compare equal */
        if (r == 0)
                {
                static unsigned int last_extra = 0;

                if (ip1->extra == 0)
                        ip1->extra = ++last_extra;
                if (ip2->extra == 0)
                        ip2->extra = ++last_extra;
                r = ip1->extra < ip2->extra ? -1 : 1;
                }
        return r;
        }
