/*
 * Listing 8 - xwd.c (saver)
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <X11/XWDFile.h>
#include "ips_image.h"

void write_ximage();

int
main(argc, argv)
int argc;
char **argv;
{
	ips_header	header;
	ips_image	image;


	if (argc<3) {
		printf("Usage: %s infile outfile\n", argv[0]);
		exit(1);
	}

	ips_to_img(&header, &image, argv[1]);

	write_ximage(&header, &image, argv[2]);

	exit(0);
}


void
write_ximage(header, image, filename)
ips_header	*header;
ips_image	*image;
char		*filename;
{
	int				i;
	FILE			*fp;
	XWDFileHeader	xheader;
	XWDColor		xcmap[256];


	memset(&xheader, 0, sizeof(XWDFileHeader));

	xheader.header_size		= sizeof(XWDFileHeader);
    xheader.file_version	= XWD_FILE_VERSION;
    xheader.pixmap_format	= 2; /* ZPixmap */
    xheader.pixmap_depth	= header->bpp;
    xheader.pixmap_width	= header->width;
    xheader.pixmap_height	= header->height;
    xheader.byte_order		= 1;
    xheader.bitmap_unit		= 32;
    xheader.bitmap_bit_order= 1;
    xheader.bitmap_pad		= 32;
    xheader.bits_per_pixel	= 8;
    xheader.bytes_per_line	= header->width;
    xheader.visual_class	= 3; /* PseudoColor */
    xheader.bits_per_rgb	= header->bpp;
    xheader.colormap_entries= header->cmap_count;
	xheader.ncolors			= header->cmap_count;
    xheader.window_width	= header->width;
    xheader.window_height	= header->height;

    for (i=0; i < header->cmap_count; i++) {
		xcmap[i].pixel	= i;
		xcmap[i].red	= image->cmap[i].red   << 8;
		xcmap[i].green	= image->cmap[i].green << 8;
		xcmap[i].blue	= image->cmap[i].blue  << 8;
    }

	if ((fp = fopen(filename, "w")) == NULL) {
		perror("write_ximage");
		exit(1);
	}

	fwrite(&xheader, 1, sizeof(XWDFileHeader), fp);
	fwrite(xcmap, 1, sizeof(XWDColor) * header->cmap_count, fp);
	fwrite(image->data, 1, header->width * header->height, fp);

	fclose(fp);
}
