/*
 * Listing 1 - ips.x
 */


/****  Client/Server Messages  ****/

const	IPS_DECODE				= 0;
const	IPS_OK_ID				= 1;
const	IPS_UNSUPPORTED_FORMAT			= 2;
const	IPS_UNKNOWN_FORMAT			= 3;

const	IPS_REQUEST_OPS				= 4;
const	IPS_SEND_OPS				= 5;

const	IPS_REQUEST_LOADERS			= 6;
const	IPS_SEND_LOADERS			= 7;

const	IPS_REQUEST_SAVERS			= 8;
const	IPS_SEND_SAVERS	 			= 9;

const	IPS_REQUEST_IMAGE			= 10;
const	IPS_SEND_IMAGE				= 11;

const	IPS_PROCESS				= 12;
const	IPS_PROCESS_OK				= 13;

const	IPS_IMAGE_RELEASE			= 14;
const	IPS_RELEASE_OK				= 15;
const	IPS_IMAGE_NOT_AVAIL			= 16;

const	IPS_INIT				= 17;
const	IPS_HELLO				= 18;

const	ERROR					= 255;

/******** Image/Text Sizes ********/

const	MAXPIX			 		= 4194304;

/********** Structures ************/

struct raw_data {
	string	filename<>;
	string	format<>;
	opaque	data<MAXPIX>;
};

struct converted_data {
	opaque	data<MAXPIX>;
};

struct list {
	string	name<>;
	struct list *next;
};

struct proc_data {
	int		id;
	string	command<>;
	int		argc;
	list	argv;
};

struct request_send {
	int		id;
	string	format<>;
	int		argc;
	list	argv;
};

/********* Main Stuff ***********/

union Packet switch (int op) {
  case IPS_INIT:				void;
  case IPS_HELLO:				string hello_string<>;

  case IPS_DECODE:				raw_data raw_img;
  case IPS_OK_ID:				int id;
  case IPS_UNSUPPORTED_FORMAT:	void;
  case IPS_UNKNOWN_FORMAT:		void;

  case IPS_REQUEST_OPS:			void;
  case IPS_SEND_OPS:			list operators;

  case IPS_REQUEST_LOADERS:		void;
  case IPS_SEND_LOADERS:		list loaders;

  case IPS_REQUEST_SAVERS:		void;
  case IPS_SEND_SAVERS:			list savers;

  case IPS_REQUEST_IMAGE:		request_send send_ops;
  case IPS_SEND_IMAGE:			converted_data img;

  case IPS_PROCESS:				proc_data proc;
  case IPS_PROCESS_OK:			void;

  case IPS_IMAGE_RELEASE:		int place_holder;
  case IPS_RELEASE_OK:			void;
  case IPS_IMAGE_NOT_AVAIL:		void;

  case ERROR:					void;
  default: 						void;
};

program IPSPROG {
  version IPSVERS {
    Packet IPS(Packet) = 1;
  } = 1;
} =  0x20000001;
