LISTING 23 - A set type for integers, using a fixed-size array
data structure
// set.h

#include <stddef.h>
#include "bool.h"

class ostream;

class SetOfInt
{
    friend ostream & operator<<(ostream &os, const SetOfInt &s)
    {
        s.print(os);
        return os;
    }

public:
    SetOfInt();
    bool contains(int) const;
    void insert(int);
    void remove(int);
    void print(ostream &) const;

private:
    enum {LIMIT = 64};
    int elems[LIMIT];
    size_t nelems;
};

