LISTING 1 - Shows roundoff error in computing powers of e

#include <stdio.h>
#include <math.h>

double e(double x);

main()
{
    printf("e(55.5) == %g, exp(55.5) == %g\n",
           e(55.5), exp(55.5));
    printf("e(-55.5) == %g, exp(-55.5) == %g\n",
           e(-55.5), exp(-55.5));
    printf("1/e(55.5) == %g\n",1.0 / e(55.5));
    return 0;
}

double e(double x)
{
    double sum1 = 1.0;
    double sum2 = 1.0 + x;
    double term = x;
    int i = 1;

    /* Calculate exp(x) via Taylor Series */
    while (sum1 != sum2)
    {
        sum1 = sum2;
        term = term * x / ++i;
        sum2 += term;
    }
    return sum2;
}

/* Output:
e(55.5) == 1.26866e+24, exp(55.5) == 1.26866e+24
e(-55.5) == -6.76351e+06, exp(-55.5) == 7.88236e-25
1/e(55.5) == 7.88236e-25
*/

