/* ------------------------- */
/* Calculate filter gain (H) */
/* ------------------------- */
matmpy(S, j, j, M, n, j, Q, ABT, P);

matmpy(M, n, j, Q, j, n, R, AB, CPP);
unused = augvrt(R, n, n, n);
matmpy(Q, j, n, R, n, n, H, AB, P);

/* -------------------------------------- */
/* Update S - Error estimation covariance */
/* -------------------------------------- */
/* ------------------------------ */
/* First form (I - HM)S = S - HMS */
/* Calculate Q = -HM 		  */
/* ------------------------------ */
matmpy(H, j, n, M, n, j, Q, AB, MP);

/* ------------------------------ */
/* Now, form W = -HMS		  */
/* ------------------------------ */
matmpy(Q, j, j, S, j, j, W, AB, P);

/* ------------------------------ */
/* Call the most-excellent madsub */
/* function to get S - HMS --> S  */
/* AB  - treat S and W normally   */
/*       (no transposes involved) */
/* ADD - causes madsub to add     */
/* ------------------------------ */
madsub(S, j, j, W, j, j, S, j, j, AB, ADD);

/* ------------------------------ */
/* Now, W = SQ' = (S - HMS)(-HM)' */
/* ------------------------------ */
matmpy(S, j, j, Q, j, j, W, ABT, P);

/* ------------------------------ */
/* Finish augend		  */
/*  S = S + W			  */
/*    = (S - HMS)+(S - HMS)(-HM') */
/*    = (S - HMS)-(S - HMS)HM'    */
/*    = (S - HMS)(I - HM')	  */
/*    = (I - HM)S(I - HM)'	  */
/* As required                    */
/* ------------------------------ */
madsub(S, j, j, W, j, j, S, j, j, AB, ADD);

/* ---------------------------- */
/* Finish update of S           */
/* First, calculate addend HRH' */
/* ---------------------------- */
matmpy(H, j, n, R, n, n, Q, AB, P);
matmpy(Q, j, n, H, j, n, W, ABT, P);

/* ---------------------------- */
/* Finally, S + W -> S += HRH'	*/
/* ---------------------------- */
madsub(S, j, j, W, j, j, S, j, j, AB, ADD);

