// TDExmpl.hpp: Financial Market Example (LISTING 5)
#ifndef TDEXMPL_HPP
#define TDEXMPL_HPP
#include "tdbuf.hpp"

// This class communicates with the database
// (Note that cellType class must have SetValue()
// and SetAttr() methods.)
template <class cellType> class TableDataMarketBuf:
        public TableDataBuffer<cellType>
{
public:
    TableDataMarketBuf (TableData<cellType> *const
            prev, const int nRows, const int nCols):
            TableDataBuffer<cellType>
            (prev, nRows, nCols)
    {
        // Put some dummy data in the table
        // (Replace these with real database reads.)
        assert (nRows == 4);
        assert (nCols == 4);
        for (int row = 0; row < GetNumRows(); row++)
        {
            for (int col=0; col < GetNumCols(); col++)
            {
                RefCell(row, col).SetValue
                        (row * 100 + col + 1);
                if (col > 2 || row < 2)
                    RefCell(row, col).SetAttr
                            (cellType::CT_PROTECTED);
            }
        }
        strcpy (&RefRowHeading(0), "Sugar-Domest.");
        strcpy (&RefRowHeading(1), "Cotton");
        strcpy (&RefRowHeading(2), "Orange Juice");
        strcpy (&RefRowHeading(3), "Brent Crude");
        strcpy (&RefColHeading(0), "Open");
        strcpy (&RefColHeading(1), "High");
        strcpy (&RefColHeading(2), "Low");
        strcpy (&RefColHeading(3), "Settle");

    }
    // A real app would also provide a method to save
    // updated data to the database.
};

// A simple cell class to use in the table,
// stores a float value & attribute per cell
class ValAttrCell
{
public:
    enum CellAttr // values can be OR'd
    {
        CT_NONE         = 0x00,
        CT_PROTECTED    = 0x01,
        CT_HIGHLIGHTED  = 0x02
    };

    ValAttrCell (float value = 0.0, CellAttr attr
            = CT_NONE): Value (value), Attr (attr)
    { }

    void SetValue (float value)
    { Value = value; }

    float GetValue (void) const
    { return (Value); }

    void SetAttr (CellAttr attr)
    { Attr = attr; }

    CellAttr GetAttr (void) const
    { return (Attr); }

private:
    float Value;   // value stored in cell
    CellAttr Attr; // display (or other) attributes
};
#endif
