// tdexmpl.cpp: Example use of TableData (LISTING 6)
#include <stdio.h>
#include <assert.h>
#include <iostream.h>
#include <iomanip.h>
#include "tdexmpl.hpp"
#include "tdnorm.hpp"
#include "tdavg.hpp"

// For ease of specifying type:
typedef TableData<ValAttrCell> ValAttrTable;
// Local function prototypes:
static void PrintTable(ValAttrTable *, ValAttrTable *);
static void PrintRow(ValAttrTable *, int);

int main ()
{
    // First instantiate the buffer
    ValAttrTable *aTableDataMarketBuf = new
            TableDataMarketBuf<ValAttrCell>
            ((ValAttrTable *)0, 4, 4);
    assert (aTableDataMarketBuf != 0);

    // Instantiate filters: first one normalizes
    ValAttrTable *aTableDataNormalize = new
            TableDataNormalize<ValAttrCell>
            (aTableDataMarketBuf);
    assert (aTableDataNormalize != 0);

    // Next one averages the original data:
    ValAttrTable *aTableDataAverage1 = new
            TableDataAverage<ValAttrCell>
            (aTableDataMarketBuf);
    assert (aTableDataAverage1 != 0);

    // Next one averages the normalized data:
    ValAttrTable *aTableDataAverage2 = new
            TableDataAverage<ValAttrCell>
            (aTableDataNormalize);
    assert (aTableDataAverage2 != 0);

    cout << "Original data:" << endl;
    PrintTable (aTableDataMarketBuf,
            aTableDataAverage1);

    cout << endl << "After normalizing:" << endl;
    PrintTable (aTableDataNormalize,
            aTableDataAverage2);

    delete aTableDataAverage2;
    delete aTableDataAverage1;
    delete aTableDataNormalize;
    delete aTableDataMarketBuf;
    return (0);
}

static void PrintTable (ValAttrTable *topTD,
        ValAttrTable *avgTD)
{
    // Print the table: First the column headings
    cout << setw(11) << " ";
    for (int col = 0; col < topTD->GetNumCols(); col++)
        cout << setw(10)
                << &(topTD->GetColHeading (col));
    cout << endl;

    for (int row = 0; row < topTD->GetNumRows(); row++)
        PrintRow (topTD, row);

    // Then print the averages:
    PrintRow (avgTD, 0);
}

static void PrintRow (ValAttrTable *topTD, int row)
{
    cout << setw(13) << &(topTD->GetRowHeading (row));
    // Set up money-style output for floats:
    cout.precision(2);
    cout.setf(ios::fixed,ios::floatfield);
    cout.setf(ios::right);
    for (int col = 0; col < topTD->GetNumCols(); col++)
    {
        ValAttrCell cell = topTD->GetCell (row, col);
        cout << setw(8) << cell.GetValue();
        // Show protected cells with an asterisk
        if (cell.GetAttr() & ValAttrCell::CT_PROTECTED)
            cout << "* ";
        else
            cout << "  ";
    }
    cout << endl;
}
