// tdavg.hpp: TableDataAverage class (LISTING 3)
#ifndef TDAVG_HPP
#define TDAVG_HPP
#include "tbldata.hpp"

// (Same assumptions about cellType as TDNORM)
template <class cellType> class TableDataAverage:
        public TableData<cellType>
{
public:
    TableDataAverage (TableData<cellType> *const
            prev): TableData<cellType> (prev)
    { }

    virtual const cellType GetCell (const int row,
            const int col)
    {
        assert (PrevTD != 0);
        assert (row == 0); // only 1 row in this table
        // Inherit properties from row 0 cell:
        cellType cell (PrevTD->GetCell (0, col));
        for (int p_row = 1; p_row <
                PrevTD->GetNumRows(); p_row++)
            cell.SetValue (cell.GetValue() +
                    (PrevTD->GetCell
                    (p_row, col)).GetValue());
        cell.SetValue (cell.GetValue() /
                PrevTD->GetNumRows());
        return (cell);
    }

    virtual void PutCell (const int, const int,
            const cellType &)
    { cerr << "Error: Row write-protected!" << endl; }

    virtual const int GetNumRows (void) const
    { return (1); }

    virtual const char &GetRowHeading (const int)
    { return (*("Average")); }
};
#endif
