// tbldata.hpp: TableData class (LISTING 1)
#ifndef TBLDATA_HPP
#define TBLDATA_HPP
#include <string.h>
#include <assert.h>

template <class cellType> class TableData
{
public:
    TableData (TableData *const prev):
            PrevTD (prev)
    { }
    virtual ~TableData (void)
    { }

    virtual const cellType GetCell (const int row,
            const int col)
    {
        assert (PrevTD != 0); // Override in buffer
        return (PrevTD->GetCell (row, col));
    }

    virtual void PutCell (const int row, const int col,
            const cellType &value)
    {
        assert (PrevTD != 0);
        PrevTD->PutCell (row, col, value);
    }

    virtual const int GetNumRows (void) const
    {
        assert (PrevTD != 0);
        return (PrevTD->GetNumRows ());
    }

    virtual const int GetNumCols (void) const
    {
        assert (PrevTD != 0);
        return (PrevTD->GetNumCols ());
    }

    virtual const char &GetRowHeading (const int row)
    {
        assert (PrevTD != 0);
        return (PrevTD->GetRowHeading (row));
    }

    virtual const char &GetColHeading (const int col)
    {
        assert (PrevTD != 0);
        return (PrevTD->GetColHeading (col));
    }

protected:
    TableData *PrevTD;  // ptr to prev link in chain
private:
    TableData (void);   // disable default methods
    TableData (const TableData &tData);
    TableData& operator= (const TableData&);
};
#endif
