----------------------- Listing 1: Bare-bones FOSSIL Program ---------

// Bare bones FOSSIL terminal program.
// Compiled with Microsoft VC++ 1.0, but should
// port to other compilers.

#include <stdio.h>
#include <dos.h>
#include <conio.h>

typedef unsigned char BYTE;
typedef unsigned int  WORD;

// Extended key code for
// Alt-X
#define ALT_X (0x2d)
#define SER_DAT_READY (0x100)

int def_port=0;


// Generalized FOSSIL function
//          AH   AL   DX
WORD fossil(BYTE,BYTE,WORD);


// Specific FOSSIL functions actually implemented
// as macros
#define fos_setparms(p,x) fossil(0,x,p)
#define fos_putc(p,c)     fossil(1,c,p)
#define fos_getc(p)       fossil(2,0,p)
#define fos_status(p)     fossil(3,0,p)
#define fos_init(p)       fossil(4,0,p)
#define fos_uninit(p)     fossil(5,0,p)
#define fos_setDTR(p,f)   fossil(6,f,p)

main(int argc,char **argv)
{
   int c;

   if(fos_init(def_port)!=0x1954) {
      fprintf(stderr,
         "\nFOSSIL driver not present!\n");
      exit(1);
   }

   // Set Parms 9600,N,8,1
   fos_setparms(def_port,0xe3);

   // Main Terminal Loop
   while(1) {
      if(kbhit()) {
         c=getch();
         if(!c) {
            if(getch()==ALT_X)
               break;
         }
         else
            fos_putc(def_port,(BYTE)c);
      }

      // See if a character is waiting to be read
      // If so, display it.
      if((fos_status(def_port)&SER_DAT_READY)!=0) {
         fputc(fos_getc(def_port),stdout);
      }
   }
   // Lower DTR
   fos_setDTR(def_port,0);
   // Uninitialize Driver
   fos_uninit(def_port);
   exit(0);
}

// Use older interrupt interface rather than
// inline assembly.
WORD fossil (BYTE ahreg,BYTE alreg, WORD dxreg)
{
   union REGS r;
   r.h.ah=ahreg;
   r.h.al=alreg;
   r.x.dx=dxreg;
   int86(0x14,&r,&r);
   return(r.x.ax);
}

