Listing 1: Code Listing for Primary Function tstsort()
	   in tstsort.c
=================================================

/* ============================== */
/* tstsort - tests sort functions */
/* ============================== */
void
tstsort(SORT_TEST_STRU * SortParms)
{
    int     SortOpt;
    long    NextSize;
    USHORT  ElapsedMillSec;
    time_t  ElapsedSeconds, Hrs, Mins, Secs;
    struct _timeb StartTime, StopTime;

    /* -------------------- */
    /* Execute exit() on ^C */
    /* -------------------- */
    signal(SIGINT, AbortGracefully);

    SortOpt = InitSortRun(SortParms);

    if (SortOpt)
    {
# if defined(REDIRECT)

	char	StdErrName[] = "sort_std.err";
	if (freopen(StdErrName, "a", stderr))
	{
	    char   *FullPathName;
	    FullPathName = _fullpath(NULL, StdErrName, 0);

	    AX(("File stderr redirected to %s\n",
		    FullPathName));
	    free(FullPathName);
	}
	else
	{
	    printf("tstsort(): Could not redirect stderr\n");
	    perror(StdErrName);
	}

# endif

	E3("Generating Targets in [%ld (%ld) %ld]\n",
	    StartSize, StepSize, StopSize);
	E1("Sort Function is %s\n", SortParms->ExecLabel);
	E1("PlotTimer Option is %s\n",
	    (PlotTimer) ? "TRUE" : "FALSE");

	if (PlotTimer)
	{
	    int     i;

	    /* ------------------------------------ */
	    /* Put Individual Timing Data on stsout */
	    /* ------------------------------------ */
	    AX(("METHOD\t%s\n", SortParms->ExecLabel));
	    AX(("DATA TYPES\t%d\n", NUM_ITEMS(DataTypes)));

	    for (i = 1; i <= NUM_ITEMS(DataTypes); ++i)
	    {
		AX(("%2d:  %s\n", i, DataTypes[i - 1]));
	    }
	    AX(("*     N   "));
	    for (i = 1; i <= NUM_ITEMS(DataTypes); ++i)
	    {
		AX(("%3d   ", i));
	    }
	    AX(("\n"));
	}

	SetStartTime(&StartTime);

	for (NextSize = StartSize;
	    NextSize <= StopSize;
	    NextSize += StepSize)
	{
	    struct _timeb SuiteTime;

	    if (NextSize > MAX_SORT)
	    {
		break;
	    }
	    E("\n  Items  Comparisons");
	    E("  Exchanges  Code/Target I.D.\n");
	    E1("%7ld", NextSize);

	    SortSize = (size_t) NextSize;
	    TotCmprs = TotSwaps = 0;
	    if (PlotTimer)
	    {
		AX(("%7u", SortSize));
	    }

	    SetStartTime(&SuiteTime);

	    if (WANT(SortList, 0))
	    {
		GenRndmTgt(SortTgt, SortSize);
		SortThisTarget(0);
	    }
	    else
	    {
		SkipThisTarget(0);
	    }

	    if (WANT(SortList, 1))
	    {
		GenSortedTgt(SortTgt, SortSize);
		SortThisTarget(1);
	    }
	    else
	    {
		SkipThisTarget(1);
	    }

	    if (WANT(SortList, 2))
	    {
		GenRevSrtdTgt(SortTgt, SortSize);
		SortThisTarget(2);
	    }
	    else
	    {
		SkipThisTarget(2);
	    }

	    if (WANT(SortList, 3))
	    {
		GenRevSrtHlv(SortTgt, SortSize);
		SortThisTarget(3);
	    }
	    else
	    {
		SkipThisTarget(3);
	    }

	    if (WANT(SortList, 4))
	    {
		GenFrstItmOut(SortTgt, SortSize);
		SortThisTarget(4);
	    }
	    else
	    {
		SkipThisTarget(4);
	    }

	    if (WANT(SortList, 5))
	    {
		GenEvryThrdInv(SortTgt, SortSize);
		SortThisTarget(5);
	    }
	    else
	    {
		SkipThisTarget(5);
	    }

	    if (WANT(SortList, 6))
	    {
		GenEqualTgt(SortTgt, SortSize, NOT_MODIFIED);
		SortThisTarget(6);
	    }
	    else
	    {
		SkipThisTarget(6);
	    }

	    if (WANT(SortList, 7))
	    {
		GenEqualTgt(SortTgt, SortSize, MODIFIED);
		SortThisTarget(7);
	    }
	    else
	    {
		SkipThisTarget(7);
	    }

	    if (WANT(SortList, 8))
	    {
		GenAltPairs(SortTgt, SortSize);
		SortThisTarget(8);
	    }
	    else
	    {
		SkipThisTarget(8);
	    }

	    if (WANT(SortList, 9))
	    {
		GenBoreSgtTgt(SortTgt, SortSize);
		SortThisTarget(9);
	    }
	    else
	    {
		SkipThisTarget(9);
	    }

	    if (PlotTimer)
	    {
		AX(("\n"));
	    }

	    _ftime(&StopTime);
	    GetElapsedTime(&SuiteTime, &StopTime,
		&ElapsedSeconds, &ElapsedMillSec);

	    E3("Suite Stats: %u Items, %lu.%.2u Seconds\n",
		SortSize, ElapsedSeconds, ElapsedMillSec / 10);
	    E2("\t     %.f Comparisons, %.f Exchanges\n",
		TotCmprs, TotSwaps);
	}

	E("\n");

	_ftime(&StopTime);

	GetElapsedTime(&StartTime, &StopTime,
	    &ElapsedSeconds, &ElapsedMillSec);

	Hrs = ElapsedSeconds / 3600;
	Mins = ElapsedSeconds / 60 - Hrs * 60;
	Secs = ElapsedSeconds - 60 * (Hrs * 60 + Mins);

	E2("Total Sort Time: %lu Hrs, %lu Mins,",
	    Hrs, Mins);
	E2(" %lu.%.2u Secs\n\n",
	    Secs, ElapsedMillSec / 10);
    }
}
