Listing 1 - A program the illustrates the effect of 
when a program does not evaluate the left operand of a 
member access expression

#include <iostream.h>

class widget
    {
public:
    widget(int i);
    ~widget();
    static unsigned how_many();
    int value() const;
private:
    int v;
    static unsigned counter;
    };

widget::widget(int i)
    : v(i)
    {
    ++counter;
    }

widget::~widget()
    {
    --counter;
    }

unsigned widget::how_many()
    {
    return counter;
    }

int widget::value() const
    {
    return v;
    }

unsigned widget::counter = 0;

#define DIM(a) (sizeof(a)/sizeof(a[0]))
#define BEYOND(a) (a + DIM(a))

int main()
    {
    int i;
    widget *a[10];
    for (i = 0; i < DIM(a); ++i)
        a[i] = new widget (i * i);
    widget **p = a;
    while (p < BEYOND(a))
        {
        cout << (*p)->how_many() << ": ";
        cout << (*p++)->value() << endl;
        }
    while (p > a)
        {
        cout << (*--p)->how_many() << ": ";
        cout << (*p)->value() << endl;
        delete *p;
        }
    return 0;
    }
