//========================= AUTOQ.HPP ===================================
//  Header file for the AutoQueue class.
//  R. Scott Guthrie - Original Code Creation
//=======================================================================
#ifndef __AUTOQ_HPP
#define __AUTOQ_HPP

// ===== AutoQueue Base Class =====
// There is no public interface for the AutoQueue base class.
class AutoQueue
{
  protected:
    // ----- Constructors / Destructor -----
    AutoQueue() { QHead_ = 0; Next_ = Previous_ = 0; };
    AutoQueue(AutoQueue** QHead);
    virtual ~AutoQueue();

    // ----- Protected Member Functions -----
    int IsLinked()               { return QHead_ ? 1 : 0; };
    AutoQueue* GetFirstNode()    { return *QHead_;   };
    AutoQueue* GetNextNode()     { return Next_;     };
    AutoQueue* GetPreviousNode() { return Previous_; };

  private:
    // ----- Private Member Functions -----
    // Prohibit Copy Constructor and Default Assignment Operator.
    // (Do not define these functions)
    AutoQueue(const AutoQueue& rhs);
    AutoQueue& operator=(const AutoQueue& rhs);

    // ----- Private Data -----
    AutoQueue** QHead_;     // Head of list containing this instance.
    AutoQueue* Previous_;   // Previous AutoQueue Node.
    AutoQueue* Next_;       // Next AutoQueue Node.
    
    // Derived class will specify private data and access methods as
    // necessary for their implementation.
};
#endif
// end file AUTOQ.HPP
